#ifndef iarduino_RTC_DS3231_h																	//
#define iarduino_RTC_DS3231_h																	//
#define	RTC_DS3231 3																			//	Модуль часов реального времени с протоколом передачи данных I2C, памятью 019x8, температурной компенсацией, двумя будильниками и встроенным кварцевым резонатором
#include "iarduino_RTC_I2C.h"																	//	Подключаем файл iarduino_RTC_I2C.h - для работы с шиной I2C
																								//
class iarduino_RTC_DS3231: public iarduino_RTC_BASE{											//
	public:																						//
	/**	функции доступные пользователю **/														//
//		Инициализация модуля:																	//
		void	begin(void){																	//	(без параметров)
//					Инициализация работы с шиной I2C:											//
					objI2C.begin(100);															//	(скорость шины в кГц)
//					Установка флагов управления и состояния модуля:								//
					varI=objI2C.readByte(valAddress, 0x02); if( varI & 0b01000000                         ){objI2C.writeByte(valAddress, 0x02, (varI&~0b01000000)            );}	//		(если установлен 6 бит в 2 регистре, то сбрасываем его - переводим модуль в 24 часовой режим)
					varI=objI2C.readByte(valAddress, 0x0E); if( varI & 0b11011111                         ){objI2C.writeByte(valAddress, 0x0E, (varI&~0b11011111)            );}	//		(если установлены 7,6,4,3,2,1 и 0 биты в 14 регистре, то сбрасываем их - разрешаем генератору работать от батарейки, запрещаем выводу SQW работать от батарейки, выводим меандр с частотой 1Гц на вывод SQW, переводим вывод INT/SQW в режим SQW, запрещаем прерывания будильников)
					varI=objI2C.readByte(valAddress, 0x0F); if((varI & 0b10000011) || !(varI & 0b00001000)){objI2C.writeByte(valAddress, 0x0F, (varI&~0b10000011)|0b00001000 );}	//		(если установлены 7,1 и 0 биты или сброшен 3 бит в 15 регистре, то сбрасываем 7,1 и 0 биты, а 3 устанавливаем - сбрасываем флаг остановки генератора, разрешаем меандр с частотой 32768Гц на выводе 32kHz, сбрасываем флаги будильников)
		}																						//
																								//
//		Чтение одного значения из регистров даты и времени модуля:								//
		uint8_t	funcReadTimeIndex(uint8_t i){													//	(i = 0-секунды / 1-минуты / 2-часы / 3-день / 4-месяц / 5-год / 6-день недели)
					delay(1); 																	//
					return objI2C.readByte(valAddress, arrTimeRegAddr[i]) & arrTimeRegMack[i];	//
		}																						//
																								//
//		Запись одного значения в регистры даты и времени модуля:								//
		void	funcWriteTimeIndex(uint8_t i, uint8_t j){										//	(i = 0-секунды / 1-минуты / 2-часы / 3-день / 4-месяц / 5-год / 6-день недели, j = значение)
					varI=funcReadTimeIndex(i);													//	Читаем данные из регистра i
					j |= ~arrTimeRegMack[i] & varI;												//	Устанавливаем биты значения j по маске arrTimeRegMack[i] в прочитанные из регистра i
					j &=  arrTimeRegMack[i] | varI;												//	Сбрасываем    биты значения j по маске arrTimeRegMack[i] в прочитанные из регистра i
					objI2C.writeByte(valAddress, arrTimeRegAddr[i], j);							//	Сохраняем значение j в регистр arrTimeRegAddr[i]
		}																						//
																								//
	private:																					//
	/**	Внутренние переменные **/																//
		iarduino_I2C objI2C;																	//	Создаём объект для работы с шиной I2C
		uint8_t	valAddress				=	 0x68;												//	Адрес модуля на шине I2C
		uint8_t	arrTimeRegAddr[7]		=	{0x00,0x01,0x02,0x04,0x05,0x06,0x03};				//	Определяем массив с адресами регистров даты и времени				(сек, мин, час, день, месяц, год, день недели)
		uint8_t	arrTimeRegMack[7]		=	{0x7F,0x7F,0x3F,0x3F,0x1F,0xFF,0x07};				//	Определяем маскировочный массив для регистров даты и времени		(при чтении/записи, нужно совершить побитовое «и»)
		uint8_t	varI;																			//
};																								//
																								//
#endif																							//