#ifndef iarduino_RTC_RX8025_h																	//
#define iarduino_RTC_RX8025_h																	//
#define	RTC_RX8025 4																			//	Модуль часов реального времени с протоколом передачи данных I2C, памятью 016x8, температурной компенсацией, двумя будильниками и встроенным кварцевым резонатором
#include "iarduino_RTC_I2C.h"																	//	Подключаем файл iarduino_RTC_I2C.h - для работы с шиной I2C
																								//
class iarduino_RTC_RX8025: public iarduino_RTC_BASE{											//
	public:																						//
	/**	функции доступные пользователю **/														//
//		Инициализация модуля:																	//
		void	begin(void){																	//	(без параметров)
//					Инициализация работы с шиной I2C:											//
					objI2C.begin(100);															//	(скорость шины в кГц)
//					Установка флагов управления и состояния модуля:								//
					delay(10); objI2C.writeByte(valAddress, 0x0F, 0xA0);						//	Записываем байт 0xA0 (10100000) в регистр 0x0F (Control-2): VDSL=1 пороговое напряжение 1.3В, VDET=0 перезапуск определения падения мощности, /XST=1 перезапуск определения остановки колебаний, PON=0 перезапуск сброса при вкл питания, 0, CTFG=0 сброс периодического прерывания, WAFG=0 и DAFG=0 сброс прерываний будильников Alarm_D и Alarm_W
					delay(10); objI2C.writeByte(valAddress, 0x0E, 0x20);						//	Записываем байт 0x20 (00100000) в регистр 0x0E (Control-1): WALE=0 и DALE=0 отключение будильников Alarm_W и Alarm_D, /12,24=1 переключение в 24-часовой формат, 00, CT2-0=000 отключение периодического прерывания.
		}																						//
																								//
//		Чтение одного значения из регистров даты и времени модуля:								//
		uint8_t	funcReadTimeIndex(uint8_t i){													//	(i = 0-секунды / 1-минуты / 2-часы / 3-день / 4-месяц / 5-год / 6-день недели)
					delay(1); 																	//
					varI = objI2C.readByte(valAddress, arrTimeRegAddr[i]) & arrTimeRegMack[i];	//	Читаем байт из регистра arrTimeRegAddr[i] с маской arrTimeRegMack[i] в переменную varI.
					if(i==6){for(uint8_t j=1;j<8;j++){if(varI&bit(j-1)){return j;}} return 1;}	//	Если запрошен день недели, то возвращаем позицию (1...7) установленного бита в байте varI.
				//	if( i==6 ){ varI++; }														//	Если чип считает день недели как написано в datasheet, то раскомментируйте данную строку и закомментируйте предыдущую.
					return varI;																//
		}																						//
																								//
//		Запись одного значения в регистры даты и времени модуля:								//
		void	funcWriteTimeIndex(uint8_t i, uint8_t j){										//	(i = 0-секунды / 1-минуты / 2-часы / 3-день / 4-месяц / 5-год / 6-день недели, j = значение)
					if( i==6 ){ if( (j==0)||(j>7) ){ j=1; } j=bit(j-1); }						//	Устанавливаем один бит в переменной j;
				//	if( i==6 ){j--;}															//	Если чип считает день недели как написано в datasheet, то раскомментируйте данную строку и закомментируйте предыдущую.
					objI2C.writeByte(valAddress, arrTimeRegAddr[i], j&arrTimeRegMack[i]);		//	Сохраняем значение j в регистр arrTimeRegAddr[i] с маской arrTimeRegMack[i].
		}																						//
																								//
	private:																					//
	/**	Внутренние переменные **/																//
		iarduino_I2C objI2C;																	//	Создаём объект для работы с шиной I2C
		uint8_t	valAddress				=	 0x32;												//	Адрес модуля на шине I2C
		uint8_t	arrTimeRegAddr[7]		=	{0x00,0x01,0x02,0x04,0x05,0x06,0x03};				//	Определяем массив с адресами регистров даты и времени				(сек, мин, час, день, месяц, год, день недели)
		uint8_t	arrTimeRegMack[7]		=	{0x7F,0x7F,0x3F,0x3F,0x1F,0xFF,0x7F};				//	Определяем маскировочный массив для регистров даты и времени		(при чтении/записи, нужно совершить побитовое «и»)
		uint8_t	varI;																			//
};																								//
																								//
#endif																							//
