# The version number is the ** lowest ** version to which the states apply
#
# See src/main/navigation/navigation_private.h
# navigationFSMState_t
#

module NavStates
  STATES = {
    "0" => {
      0 => :nav_state_undefined,
      1 => :nav_state_idle,
      2 => :nav_state_althold_initialize,
      3 => :nav_state_althold_in_progress,
      4 => :nav_state_poshold_2d_initialize,
      5 => :nav_state_poshold_2d_in_progress,
      6 => :nav_state_poshold_3d_initialize,
      7 => :nav_state_poshold_3d_in_progress,
      8 => :nav_state_rth_initialize,
      9 => :nav_state_rth_2d_initialize,
      10 => :nav_state_rth_2d_head_home,
      11 => :nav_state_rth_2d_gps_failing,
      12 => :nav_state_rth_2d_finishing,
      13 => :nav_state_rth_2d_finished,
      14 => :nav_state_rth_3d_initialize,
      15 => :nav_state_rth_3d_climb_to_safe_alt,
      16 => :nav_state_rth_3d_head_home,
      17 => :nav_state_rth_3d_gps_failing,
      18 => :nav_state_rth_3d_hover_prior_to_landing,
      19 => :nav_state_rth_3d_landing,
      20 => :nav_state_rth_3d_finishing,
      21 => :nav_state_rth_3d_finished,
      22 => :nav_state_waypoint_initialize,
      23 => :nav_state_waypoint_pre_action,
      24 => :nav_state_waypoint_in_progress,
      25 => :nav_state_waypoint_reached,
      26 => :nav_state_waypoint_finished,
      27 => :nav_state_emergency_landing_initialize,
      28 => :nav_state_emergency_landing_in_progress,
      29 => :nav_state_emergency_landing_finished,
      30 => :nav_state_count,
    },
    "1.2.0" => {
      0 => :nav_state_undefined,
      1 => :nav_state_idle,
      2 => :nav_state_althold_initialize,
      3 => :nav_state_althold_in_progress,
      4 => :nav_state_poshold_2d_initialize,
      5 => :nav_state_poshold_2d_in_progress,
      6 => :nav_state_poshold_3d_initialize,
      7 => :nav_state_poshold_3d_in_progress,
      8 => :nav_state_rth_initialize,
      9 => :nav_state_rth_2d_initialize,
      10 => :nav_state_rth_2d_head_home,
      11 => :nav_state_rth_2d_gps_failing,
      12 => :nav_state_rth_2d_finishing,
      13 => :nav_state_rth_2d_finished,
      14 => :nav_state_rth_3d_initialize,
      15 => :nav_state_rth_3d_climb_to_safe_alt,
      16 => :nav_state_rth_3d_head_home,
      17 => :nav_state_rth_3d_gps_failing,
      18 => :nav_state_rth_3d_hover_prior_to_landing,
      19 => :nav_state_rth_3d_landing,
      20 => :nav_state_rth_3d_finishing,
      21 => :nav_state_rth_3d_finished,
      22 => :nav_state_waypoint_initialize,
      23 => :nav_state_waypoint_pre_action,
      24 => :nav_state_waypoint_in_progress,
      25 => :nav_state_waypoint_reached,
      26 => :nav_state_waypoint_next,
      27 => :nav_state_waypoint_finished,
      28 => :nav_state_waypoint_rth_land,
      29 => :nav_state_emergency_landing_initialize,
      30 => :nav_state_emergency_landing_in_progress,
      31 => :nav_state_emergency_landing_finished,
      32 => :nav_state_count,
    },
    "1.4.0" => {
      0 => :nav_state_undefined,
      1 => :nav_state_idle,
      2 => :nav_state_althold_initialize,
      3 => :nav_state_althold_in_progress,
      4 => :nav_state_poshold_2d_initialize,
      5 => :nav_state_poshold_2d_in_progress,
      6 => :nav_state_poshold_3d_initialize,
      7 => :nav_state_poshold_3d_in_progress,
      8 => :nav_state_rth_initialize,
      9 => :nav_state_rth_2d_initialize,
      10 => :nav_state_rth_2d_head_home,
      11 => :nav_state_rth_2d_gps_failing,
      12 => :nav_state_rth_2d_finishing,
      13 => :nav_state_rth_2d_finished,
      14 => :nav_state_rth_3d_initialize,
      15 => :nav_state_rth_3d_climb_to_safe_alt,
      16 => :nav_state_rth_3d_head_home,
      17 => :nav_state_rth_3d_gps_failing,
      18 => :nav_state_rth_3d_hover_prior_to_landing,
      19 => :nav_state_rth_3d_landing,
      20 => :nav_state_rth_3d_finishing,
      21 => :nav_state_rth_3d_finished,
      22 => :nav_state_waypoint_initialize,
      23 => :nav_state_waypoint_pre_action,
      24 => :nav_state_waypoint_in_progress,
      25 => :nav_state_waypoint_reached,
      26 => :nav_state_waypoint_next,
      27 => :nav_state_waypoint_finished,
      28 => :nav_state_waypoint_rth_land,
      29 => :nav_state_emergency_landing_initialize,
      30 => :nav_state_emergency_landing_in_progress,
      31 => :nav_state_emergency_landing_finished,
      32 => :nav_state_launch_initialize,
      33 => :nav_state_launch_wait,
      34 => :nav_state_launch_motor_delay,
      35 => :nav_state_launch_in_progress,
      36 => :nav_state_count,
    },
    "1.6.0" => {
      0 => :nav_state_undefined,
      1 => :nav_state_idle,
      2 => :nav_state_althold_initialize,
      3 => :nav_state_althold_in_progress,
      4 => :nav_state_poshold_2d_initialize,
      5 => :nav_state_poshold_2d_in_progress,
      6 => :nav_state_poshold_3d_initialize,
      7 => :nav_state_poshold_3d_in_progress,
      8 => :nav_state_rth_initialize,
      9 => :nav_state_rth_2d_initialize,
      10 => :nav_state_rth_2d_head_home,
      11 => :nav_state_rth_2d_finishing,
      12 => :nav_state_rth_2d_finished,
      13 => :nav_state_rth_3d_initialize,
      14 => :nav_state_rth_3d_climb_to_safe_alt,
      15 => :nav_state_rth_3d_head_home,
      16 => :nav_state_rth_3d_hover_prior_to_landing,
      17 => :nav_state_rth_3d_landing,
      18 => :nav_state_rth_3d_finishing,
      19 => :nav_state_rth_3d_finished,
      20 => :nav_state_waypoint_initialize,
      21 => :nav_state_waypoint_pre_action,
      22 => :nav_state_waypoint_in_progress,
      23 => :nav_state_waypoint_reached,
      24 => :nav_state_waypoint_next,
      25 => :nav_state_waypoint_finished,
      26 => :nav_state_waypoint_rth_land,
      27 => :nav_state_emergency_landing_initialize,
      28 => :nav_state_emergency_landing_in_progress,
      29 => :nav_state_emergency_landing_finished,
      30 => :nav_state_launch_initialize,
      31 => :nav_state_launch_wait,
      32 => :nav_state_launch_motor_delay,
      33 => :nav_state_launch_in_progress,
    34 => :nav_state_count,
    },
    "1.6.2" => {
      0 => :nav_state_undefined,
      1 => :nav_state_idle,
      2 => :nav_state_althold_initialize,
      3 => :nav_state_althold_in_progress,
      4 => :nav_state_poshold_2d_initialize,
      5 => :nav_state_poshold_2d_in_progress,
      6 => :nav_state_poshold_3d_initialize,
      7 => :nav_state_poshold_3d_in_progress,
      8 => :nav_state_rth_initialize,
      9 => :nav_state_rth_climb_to_safe_alt,
      10 => :nav_state_rth_head_home,
      11 => :nav_state_rth_hover_prior_to_landing,
      12 => :nav_state_rth_landing,
      13 => :nav_state_rth_finishing,
      14 => :nav_state_rth_finished,
      15 => :nav_state_waypoint_initialize,
      16 => :nav_state_waypoint_pre_action,
      17 => :nav_state_waypoint_in_progress,
      18 => :nav_state_waypoint_reached,
      19 => :nav_state_waypoint_next,
      20 => :nav_state_waypoint_finished,
      21 => :nav_state_waypoint_rth_land,
      22 => :nav_state_emergency_landing_initialize,
      23 => :nav_state_emergency_landing_in_progress,
      24 => :nav_state_emergency_landing_finished,
      25 => :nav_state_launch_initialize,
      26 => :nav_state_launch_wait,
      27 => :nav_state_launch_motor_delay,
      28 => :nav_state_launch_in_progress,
      29 => :nav_state_count,
    },
    "2.0.0" => {
      0 => :nav_state_undefined,
      1 => :nav_state_idle,
      2 => :nav_state_althold_initialize,
      3 => :nav_state_althold_in_progress,
      4 => :nav_state_undefined,
      5 => :nav_state_undefined,
      6 => :nav_state_poshold_3d_initialize,
      7 => :nav_state_poshold_3d_in_progress,
      8 => :nav_state_rth_initialize,
      9 => :nav_state_rth_climb_to_safe_alt,
      10 => :nav_state_rth_head_home,
      11 => :nav_state_rth_hover_prior_to_landing,
      12 => :nav_state_rth_landing,
      13 => :nav_state_rth_finishing,
      14 => :nav_state_rth_finished,
      15 => :nav_state_waypoint_initialize,
      16 => :nav_state_waypoint_pre_action,
      17 => :nav_state_waypoint_in_progress,
      18 => :nav_state_waypoint_reached,
      19 => :nav_state_waypoint_next,
      20 => :nav_state_waypoint_finished,
      21 => :nav_state_waypoint_rth_land,
      22 => :nav_state_emergency_landing_initialize,
      23 => :nav_state_emergency_landing_in_progress,
      24 => :nav_state_emergency_landing_finished,
      25 => :nav_state_launch_initialize,
      26 => :nav_state_launch_wait,
      27 => :nav_state_undefined,
      28 => :nav_state_launch_in_progress,
      29 => :nav_state_cruise_2d_initialize,
      30 => :nav_state_cruise_2d_in_progress,
      31 => :nav_state_cruise_2d_adjusting,
      32 => :nav_state_cruise_3d_initialize,
      33 => :nav_state_cruise_3d_in_progress,
      34 => :nav_state_cruise_3d_adjusting,
      35 => :nav_state_count,
    },
    "2.5.0" => {
      0 => :nav_state_undefined,
      1 => :nav_state_idle,
      2 => :nav_state_althold_initialize,
      3 => :nav_state_althold_in_progress,
      4 => :nav_state_undefined,
      5 => :nav_state_undefined,
      6 => :nav_state_poshold_3d_initialize,
      7 => :nav_state_poshold_3d_in_progress,
      8 => :nav_state_rth_initialize,
      9 => :nav_state_rth_climb_to_safe_alt,
      10 => :nav_state_rth_head_home,
      11 => :nav_state_rth_hover_prior_to_landing,
      12 => :nav_state_rth_landing,
      13 => :nav_state_rth_finishing,
      14 => :nav_state_rth_finished,
      15 => :nav_state_waypoint_initialize,
      16 => :nav_state_waypoint_pre_action,
      17 => :nav_state_waypoint_in_progress,
      18 => :nav_state_waypoint_reached,
      19 => :nav_state_waypoint_next,
      20 => :nav_state_waypoint_finished,
      21 => :nav_state_waypoint_rth_land,
      22 => :nav_state_emergency_landing_initialize,
      23 => :nav_state_emergency_landing_in_progress,
      24 => :nav_state_emergency_landing_finished,
      25 => :nav_state_launch_initialize,
      26 => :nav_state_launch_wait,
      27 => :nav_state_undefined,
      28 => :nav_state_launch_in_progress,
      29 => :nav_state_cruise_2d_initialize,
      30 => :nav_state_cruise_2d_in_progress,
      31 => :nav_state_cruise_2d_adjusting,
      32 => :nav_state_cruise_3d_initialize,
      33 => :nav_state_cruise_3d_in_progress,
      34 => :nav_state_cruise_3d_adjusting,
      35 => :nav_state_waypoint_hold_time,
      36 => :nav_state_count,
    },
    "2.7.0" => {
      0 => :nav_state_undefined,
      1 => :nav_state_idle,
      2 => :nav_state_althold_initialize,
      3 => :nav_state_althold_in_progress,
      4 => :nav_state_undefined,
      5 => :nav_state_undefined,
      6 => :nav_state_poshold_3d_initialize,
      7 => :nav_state_poshold_3d_in_progress,
      8 => :nav_state_rth_initialize,
      9 => :nav_state_rth_climb_to_safe_alt,
      10 => :nav_state_rth_head_home,
      11 => :nav_state_rth_hover_prior_to_landing,
      12 => :nav_state_rth_landing,
      13 => :nav_state_rth_finishing,
      14 => :nav_state_rth_finished,
      15 => :nav_state_waypoint_initialize,
      16 => :nav_state_waypoint_pre_action,
      17 => :nav_state_waypoint_in_progress,
      18 => :nav_state_waypoint_reached,
      19 => :nav_state_waypoint_next,
      20 => :nav_state_waypoint_finished,
      21 => :nav_state_waypoint_rth_land,
      22 => :nav_state_emergency_landing_initialize,
      23 => :nav_state_emergency_landing_in_progress,
      24 => :nav_state_emergency_landing_finished,
      25 => :nav_state_launch_initialize,
      26 => :nav_state_launch_wait,
      27 => :nav_state_undefined,
      28 => :nav_state_launch_in_progress,
      29 => :nav_state_cruise_2d_initialize,
      30 => :nav_state_cruise_2d_in_progress,
      31 => :nav_state_cruise_2d_adjusting,
      32 => :nav_state_cruise_3d_initialize,
      33 => :nav_state_cruise_3d_in_progress,
      34 => :nav_state_cruise_3d_adjusting,
      35 => :nav_state_waypoint_hold_time,
      36 => :nav_state_rth_hover_above_home,
      37 => :nav_state_waypoint_hover_above_home,
      38 => :nav_state_count,
    },
    "5.0.0" => {
      0 => :nav_state_undefined,
      1 => :nav_state_idle,
      2 => :nav_state_althold_initialize,
      3 => :nav_state_althold_in_progress,
      4 => :nav_state_undefined,
      5 => :nav_state_undefined,
      6 => :nav_state_poshold_3d_initialize,
      7 => :nav_state_poshold_3d_in_progress,
      8 => :nav_state_rth_initialize,
      9 => :nav_state_rth_climb_to_safe_alt,
      10 => :nav_state_rth_head_home,
      11 => :nav_state_rth_hover_prior_to_landing,
      12 => :nav_state_rth_landing,
      13 => :nav_state_rth_finishing,
      14 => :nav_state_rth_finished,
      15 => :nav_state_waypoint_initialize,
      16 => :nav_state_waypoint_pre_action,
      17 => :nav_state_waypoint_in_progress,
      18 => :nav_state_waypoint_reached,
      19 => :nav_state_waypoint_next,
      20 => :nav_state_waypoint_finished,
      21 => :nav_state_waypoint_rth_land,
      22 => :nav_state_emergency_landing_initialize,
      23 => :nav_state_emergency_landing_in_progress,
      24 => :nav_state_emergency_landing_finished,
      25 => :nav_state_launch_initialize,
      26 => :nav_state_launch_wait,
      27 => :nav_state_undefined,
      28 => :nav_state_launch_in_progress,
      29 => :nav_state_cruise_2d_initialize,
      30 => :nav_state_cruise_2d_in_progress,
      31 => :nav_state_cruise_2d_adjusting,
      32 => :nav_state_cruise_3d_initialize,
      33 => :nav_state_cruise_3d_in_progress,
      34 => :nav_state_cruise_3d_adjusting,
      35 => :nav_state_waypoint_hold_time,
      36 => :nav_state_rth_hover_above_home,
      37 => :nav_state_waypoint_hover_above_home,
      38 => :nav_state_rth_trackback,
      39 => :nav_state_count,
    },
  }

  def NavStates.get_state_version iv
    inavers=nil
    if iv.nil?
      inavers = '0'
    else
      STATES.each do |k,v|
        break if iv < k
        inavers = k
      end
    end
    STDERR.puts "INAV #{iv}, states from #{inavers}"
    inavers
  end

  def NavStates.get_states vs
    return STATES[vs]
  end
end
