# Mavlink conformance tester

## Usage

* Validate captured raw data from mavlink telemetry. It is recommended that you use use [`mwp-serial-capture`](../mwp-serial-cap) for the data capture, however any raw data capture should do.
  ```
  $ mwp-serial-cap [-b 115200] [-d /dev/ttyACM0] [-other-options] mavraw.bin
  ```

* Analyse the data
  ```
  $ mavreader mavraw.bin
  ```

## Build

```
$ ninja
## or
$ go build -o mavreader mavreader.go
```
As `mavreader` is a Golang program, it may be compiled for any platform with a Go compiler (Linux, FreeBSD, MacOS, Windows etc.)

## Data file format

`mavreader` understands (and auto-detects) the formats generated by `mwp-serial-cap`.

* Raw data stream. No header or metadata, just raw bytes. This can also be generated by other serial capture tools (e.g.`cat` on Posix OS).

* `mwp` and `mwp-serial-cap` "v2\n" metadata format. Provides timimg and capture read size information in addition to raw bytes. See the `mwp-serial-cap` `README.md` document for details.

* `mwp-serial-cap` streaming JSON. See the `mwp-serial-cap` `README.md` document for details.
