#!/usr/bin/python
# -*- coding: utf-8 -*-

import bpy

class MHC_OT_CreatePrimaryTargetOperator(bpy.types.Operator):
    """Setup required shape keys (i.e create a target)"""
    bl_idname = "mh_community.create_primary_target"
    bl_label = "Create primary target"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def poll(self, context):
        if context.active_object is not None:
            if not hasattr(context.active_object, "MhObjectType"):
                return False
            if context.active_object.select_get():
                if context.active_object.MhObjectType == "Basemesh":
                    if not context.active_object.data.shape_keys:
                        return True
        return False

    def execute(self, context):

        obj = context.active_object
        basis = obj.shape_key_add(name="Basis",from_mix=False)
        primtarget = obj.MhPrimaryTargetName
        primaryTarget = obj.shape_key_add(name=primtarget, from_mix=True)
        primaryTarget.value = 1.0

        idx = context.active_object.data.shape_keys.key_blocks.find(primtarget)
        context.active_object.active_shape_key_index = idx

        self.report({'INFO'},"Target " + primtarget + " initialized")

        return {'FINISHED'}
