# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2019 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.Qt3DRender, except for defaults which are replaced by "...".
"""

# Module PySide2.Qt3DRender
import PySide2
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtCore
import PySide2.QtGui
import PySide2.Qt3DCore
import PySide2.Qt3DRender


class Qt3DRender(Shiboken.Object):

    class PropertyReaderInterface(Shiboken.Object):

        def __init__(self): ...

        def readProperty(self, v:typing.Any) -> typing.Any: ...

    class QAbstractFunctor(Shiboken.Object):

        def __init__(self): ...

        def id(self) -> int: ...

    class QAbstractLight(PySide2.Qt3DCore.Qt3DCore.QComponent):
        PointLight               : Qt3DRender.QAbstractLight = ... # 0x0
        DirectionalLight         : Qt3DRender.QAbstractLight = ... # 0x1
        SpotLight                : Qt3DRender.QAbstractLight = ... # 0x2

        class Type(object):
            PointLight               : Qt3DRender.QAbstractLight.Type = ... # 0x0
            DirectionalLight         : Qt3DRender.QAbstractLight.Type = ... # 0x1
            SpotLight                : Qt3DRender.QAbstractLight.Type = ... # 0x2
        def color(self) -> PySide2.QtGui.QColor: ...
        def intensity(self) -> float: ...
        def setColor(self, color:PySide2.QtGui.QColor): ...
        def setIntensity(self, intensity:float): ...
        def type(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractLight.Type: ...

    class QAbstractRayCaster(PySide2.Qt3DCore.Qt3DCore.QComponent):
        AcceptAnyMatchingLayers  : Qt3DRender.QAbstractRayCaster = ... # 0x0
        Continuous               : Qt3DRender.QAbstractRayCaster = ... # 0x0
        AcceptAllMatchingLayers  : Qt3DRender.QAbstractRayCaster = ... # 0x1
        SingleShot               : Qt3DRender.QAbstractRayCaster = ... # 0x1
        DiscardAnyMatchingLayers : Qt3DRender.QAbstractRayCaster = ... # 0x2
        DiscardAllMatchingLayers : Qt3DRender.QAbstractRayCaster = ... # 0x3

        class FilterMode(object):
            AcceptAnyMatchingLayers  : Qt3DRender.QAbstractRayCaster.FilterMode = ... # 0x0
            AcceptAllMatchingLayers  : Qt3DRender.QAbstractRayCaster.FilterMode = ... # 0x1
            DiscardAnyMatchingLayers : Qt3DRender.QAbstractRayCaster.FilterMode = ... # 0x2
            DiscardAllMatchingLayers : Qt3DRender.QAbstractRayCaster.FilterMode = ... # 0x3

        class RunMode(object):
            Continuous               : Qt3DRender.QAbstractRayCaster.RunMode = ... # 0x0
            SingleShot               : Qt3DRender.QAbstractRayCaster.RunMode = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addLayer(self, layer:PySide2.Qt3DRender.Qt3DRender.QLayer): ...
        def filterMode(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.FilterMode: ...
        def hits(self) -> typing.List: ...
        def layers(self) -> typing.List: ...
        def removeLayer(self, layer:PySide2.Qt3DRender.Qt3DRender.QLayer): ...
        def runMode(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.RunMode: ...
        def setFilterMode(self, filterMode:PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.FilterMode): ...
        def setRunMode(self, runMode:PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.RunMode): ...

    class QAbstractTexture(PySide2.Qt3DCore.Qt3DCore.QNode):
        CompareNone              : Qt3DRender.QAbstractTexture = ... # 0x0
        NoFormat                 : Qt3DRender.QAbstractTexture = ... # 0x0
        NoHandle                 : Qt3DRender.QAbstractTexture = ... # 0x0
        None_                    : Qt3DRender.QAbstractTexture = ... # 0x0
        TargetAutomatic          : Qt3DRender.QAbstractTexture = ... # 0x0
        Automatic                : Qt3DRender.QAbstractTexture = ... # 0x1
        Loading                  : Qt3DRender.QAbstractTexture = ... # 0x1
        OpenGLTextureId          : Qt3DRender.QAbstractTexture = ... # 0x1
        Ready                    : Qt3DRender.QAbstractTexture = ... # 0x2
        Error                    : Qt3DRender.QAbstractTexture = ... # 0x3
        CompareNever             : Qt3DRender.QAbstractTexture = ... # 0x200
        CompareLess              : Qt3DRender.QAbstractTexture = ... # 0x201
        CompareEqual             : Qt3DRender.QAbstractTexture = ... # 0x202
        CompareLessEqual         : Qt3DRender.QAbstractTexture = ... # 0x203
        CompareGreater           : Qt3DRender.QAbstractTexture = ... # 0x204
        CommpareNotEqual         : Qt3DRender.QAbstractTexture = ... # 0x205
        CompareGreaterEqual      : Qt3DRender.QAbstractTexture = ... # 0x206
        CompareAlways            : Qt3DRender.QAbstractTexture = ... # 0x207
        Target1D                 : Qt3DRender.QAbstractTexture = ... # 0xde0
        Target2D                 : Qt3DRender.QAbstractTexture = ... # 0xde1
        DepthFormat              : Qt3DRender.QAbstractTexture = ... # 0x1902
        AlphaFormat              : Qt3DRender.QAbstractTexture = ... # 0x1906
        RGBFormat                : Qt3DRender.QAbstractTexture = ... # 0x1907
        RGBAFormat               : Qt3DRender.QAbstractTexture = ... # 0x1908
        LuminanceFormat          : Qt3DRender.QAbstractTexture = ... # 0x1909
        LuminanceAlphaFormat     : Qt3DRender.QAbstractTexture = ... # 0x190a
        Nearest                  : Qt3DRender.QAbstractTexture = ... # 0x2600
        Linear                   : Qt3DRender.QAbstractTexture = ... # 0x2601
        NearestMipMapNearest     : Qt3DRender.QAbstractTexture = ... # 0x2700
        LinearMipMapNearest      : Qt3DRender.QAbstractTexture = ... # 0x2701
        NearestMipMapLinear      : Qt3DRender.QAbstractTexture = ... # 0x2702
        LinearMipMapLinear       : Qt3DRender.QAbstractTexture = ... # 0x2703
        RG3B2                    : Qt3DRender.QAbstractTexture = ... # 0x2a10
        RGB8_UNorm               : Qt3DRender.QAbstractTexture = ... # 0x8051
        RGB16_UNorm              : Qt3DRender.QAbstractTexture = ... # 0x8054
        RGBA4                    : Qt3DRender.QAbstractTexture = ... # 0x8056
        RGB5A1                   : Qt3DRender.QAbstractTexture = ... # 0x8057
        RGBA8_UNorm              : Qt3DRender.QAbstractTexture = ... # 0x8058
        RGB10A2                  : Qt3DRender.QAbstractTexture = ... # 0x8059
        RGBA16_UNorm             : Qt3DRender.QAbstractTexture = ... # 0x805b
        Target3D                 : Qt3DRender.QAbstractTexture = ... # 0x806f
        D16                      : Qt3DRender.QAbstractTexture = ... # 0x81a5
        D24                      : Qt3DRender.QAbstractTexture = ... # 0x81a6
        D32                      : Qt3DRender.QAbstractTexture = ... # 0x81a7
        R8_UNorm                 : Qt3DRender.QAbstractTexture = ... # 0x8229
        R16_UNorm                : Qt3DRender.QAbstractTexture = ... # 0x822a
        RG8_UNorm                : Qt3DRender.QAbstractTexture = ... # 0x822b
        RG16_UNorm               : Qt3DRender.QAbstractTexture = ... # 0x822c
        R16F                     : Qt3DRender.QAbstractTexture = ... # 0x822d
        R32F                     : Qt3DRender.QAbstractTexture = ... # 0x822e
        RG16F                    : Qt3DRender.QAbstractTexture = ... # 0x822f
        RG32F                    : Qt3DRender.QAbstractTexture = ... # 0x8230
        R8I                      : Qt3DRender.QAbstractTexture = ... # 0x8231
        R8U                      : Qt3DRender.QAbstractTexture = ... # 0x8232
        R16I                     : Qt3DRender.QAbstractTexture = ... # 0x8233
        R16U                     : Qt3DRender.QAbstractTexture = ... # 0x8234
        R32I                     : Qt3DRender.QAbstractTexture = ... # 0x8235
        R32U                     : Qt3DRender.QAbstractTexture = ... # 0x8236
        RG8I                     : Qt3DRender.QAbstractTexture = ... # 0x8237
        RG8U                     : Qt3DRender.QAbstractTexture = ... # 0x8238
        RG16I                    : Qt3DRender.QAbstractTexture = ... # 0x8239
        RG16U                    : Qt3DRender.QAbstractTexture = ... # 0x823a
        RG32I                    : Qt3DRender.QAbstractTexture = ... # 0x823b
        RG32U                    : Qt3DRender.QAbstractTexture = ... # 0x823c
        RGB_DXT1                 : Qt3DRender.QAbstractTexture = ... # 0x83f0
        RGBA_DXT1                : Qt3DRender.QAbstractTexture = ... # 0x83f1
        RGBA_DXT3                : Qt3DRender.QAbstractTexture = ... # 0x83f2
        RGBA_DXT5                : Qt3DRender.QAbstractTexture = ... # 0x83f3
        TargetRectangle          : Qt3DRender.QAbstractTexture = ... # 0x84f5
        TargetCubeMap            : Qt3DRender.QAbstractTexture = ... # 0x8513
        CubeMapPositiveX         : Qt3DRender.QAbstractTexture = ... # 0x8515
        CubeMapNegativeX         : Qt3DRender.QAbstractTexture = ... # 0x8516
        CubeMapPositiveY         : Qt3DRender.QAbstractTexture = ... # 0x8517
        CubeMapNegativeY         : Qt3DRender.QAbstractTexture = ... # 0x8518
        CubeMapPositiveZ         : Qt3DRender.QAbstractTexture = ... # 0x8519
        CubeMapNegativeZ         : Qt3DRender.QAbstractTexture = ... # 0x851a
        AllFaces                 : Qt3DRender.QAbstractTexture = ... # 0x851b
        RGBA32F                  : Qt3DRender.QAbstractTexture = ... # 0x8814
        RGB32F                   : Qt3DRender.QAbstractTexture = ... # 0x8815
        RGBA16F                  : Qt3DRender.QAbstractTexture = ... # 0x881a
        RGB16F                   : Qt3DRender.QAbstractTexture = ... # 0x881b
        CompareRefToTexture      : Qt3DRender.QAbstractTexture = ... # 0x884e
        D24S8                    : Qt3DRender.QAbstractTexture = ... # 0x88f0
        Target1DArray            : Qt3DRender.QAbstractTexture = ... # 0x8c18
        Target2DArray            : Qt3DRender.QAbstractTexture = ... # 0x8c1a
        TargetBuffer             : Qt3DRender.QAbstractTexture = ... # 0x8c2a
        RG11B10F                 : Qt3DRender.QAbstractTexture = ... # 0x8c3a
        RGB9E5                   : Qt3DRender.QAbstractTexture = ... # 0x8c3d
        SRGB8                    : Qt3DRender.QAbstractTexture = ... # 0x8c41
        SRGB8_Alpha8             : Qt3DRender.QAbstractTexture = ... # 0x8c43
        SRGB_DXT1                : Qt3DRender.QAbstractTexture = ... # 0x8c4c
        SRGB_Alpha_DXT1          : Qt3DRender.QAbstractTexture = ... # 0x8c4d
        SRGB_Alpha_DXT3          : Qt3DRender.QAbstractTexture = ... # 0x8c4e
        SRGB_Alpha_DXT5          : Qt3DRender.QAbstractTexture = ... # 0x8c4f
        D32F                     : Qt3DRender.QAbstractTexture = ... # 0x8cac
        D32FS8X24                : Qt3DRender.QAbstractTexture = ... # 0x8cad
        R5G6B5                   : Qt3DRender.QAbstractTexture = ... # 0x8d62
        RGB8_ETC1                : Qt3DRender.QAbstractTexture = ... # 0x8d64
        RGBA32U                  : Qt3DRender.QAbstractTexture = ... # 0x8d70
        RGB32U                   : Qt3DRender.QAbstractTexture = ... # 0x8d71
        RGBA16U                  : Qt3DRender.QAbstractTexture = ... # 0x8d76
        RGB16U                   : Qt3DRender.QAbstractTexture = ... # 0x8d77
        RGBA8U                   : Qt3DRender.QAbstractTexture = ... # 0x8d7c
        RGB8U                    : Qt3DRender.QAbstractTexture = ... # 0x8d7d
        RGBA32I                  : Qt3DRender.QAbstractTexture = ... # 0x8d82
        RGB32I                   : Qt3DRender.QAbstractTexture = ... # 0x8d83
        RGBA16I                  : Qt3DRender.QAbstractTexture = ... # 0x8d88
        RGB16I                   : Qt3DRender.QAbstractTexture = ... # 0x8d89
        RGBA8I                   : Qt3DRender.QAbstractTexture = ... # 0x8d8e
        RGB8I                    : Qt3DRender.QAbstractTexture = ... # 0x8d8f
        R_ATI1N_UNorm            : Qt3DRender.QAbstractTexture = ... # 0x8dbb
        R_ATI1N_SNorm            : Qt3DRender.QAbstractTexture = ... # 0x8dbc
        RG_ATI2N_UNorm           : Qt3DRender.QAbstractTexture = ... # 0x8dbd
        RG_ATI2N_SNorm           : Qt3DRender.QAbstractTexture = ... # 0x8dbe
        RGB_BP_UNorm             : Qt3DRender.QAbstractTexture = ... # 0x8e8c
        SRGB_BP_UNorm            : Qt3DRender.QAbstractTexture = ... # 0x8e8d
        RGB_BP_SIGNED_FLOAT      : Qt3DRender.QAbstractTexture = ... # 0x8e8e
        RGB_BP_UNSIGNED_FLOAT    : Qt3DRender.QAbstractTexture = ... # 0x8e8f
        R8_SNorm                 : Qt3DRender.QAbstractTexture = ... # 0x8f94
        RG8_SNorm                : Qt3DRender.QAbstractTexture = ... # 0x8f95
        RGB8_SNorm               : Qt3DRender.QAbstractTexture = ... # 0x8f96
        RGBA8_SNorm              : Qt3DRender.QAbstractTexture = ... # 0x8f97
        R16_SNorm                : Qt3DRender.QAbstractTexture = ... # 0x8f98
        RG16_SNorm               : Qt3DRender.QAbstractTexture = ... # 0x8f99
        RGB16_SNorm              : Qt3DRender.QAbstractTexture = ... # 0x8f9a
        RGBA16_SNorm             : Qt3DRender.QAbstractTexture = ... # 0x8f9b
        TargetCubeMapArray       : Qt3DRender.QAbstractTexture = ... # 0x9009
        RGB10A2U                 : Qt3DRender.QAbstractTexture = ... # 0x906f
        Target2DMultisample      : Qt3DRender.QAbstractTexture = ... # 0x9100
        Target2DMultisampleArray : Qt3DRender.QAbstractTexture = ... # 0x9102
        R11_EAC_UNorm            : Qt3DRender.QAbstractTexture = ... # 0x9270
        R11_EAC_SNorm            : Qt3DRender.QAbstractTexture = ... # 0x9271
        RG11_EAC_UNorm           : Qt3DRender.QAbstractTexture = ... # 0x9272
        RG11_EAC_SNorm           : Qt3DRender.QAbstractTexture = ... # 0x9273
        RGB8_ETC2                : Qt3DRender.QAbstractTexture = ... # 0x9274
        SRGB8_ETC2               : Qt3DRender.QAbstractTexture = ... # 0x9275
        RGB8_PunchThrough_Alpha1_ETC2: Qt3DRender.QAbstractTexture = ... # 0x9276
        SRGB8_PunchThrough_Alpha1_ETC2: Qt3DRender.QAbstractTexture = ... # 0x9277
        RGBA8_ETC2_EAC           : Qt3DRender.QAbstractTexture = ... # 0x9278
        SRGB8_Alpha8_ETC2_EAC    : Qt3DRender.QAbstractTexture = ... # 0x9279

        class ComparisonFunction(object):
            CompareNever             : Qt3DRender.QAbstractTexture.ComparisonFunction = ... # 0x200
            CompareLess              : Qt3DRender.QAbstractTexture.ComparisonFunction = ... # 0x201
            CompareEqual             : Qt3DRender.QAbstractTexture.ComparisonFunction = ... # 0x202
            CompareLessEqual         : Qt3DRender.QAbstractTexture.ComparisonFunction = ... # 0x203
            CompareGreater           : Qt3DRender.QAbstractTexture.ComparisonFunction = ... # 0x204
            CommpareNotEqual         : Qt3DRender.QAbstractTexture.ComparisonFunction = ... # 0x205
            CompareGreaterEqual      : Qt3DRender.QAbstractTexture.ComparisonFunction = ... # 0x206
            CompareAlways            : Qt3DRender.QAbstractTexture.ComparisonFunction = ... # 0x207

        class ComparisonMode(object):
            CompareNone              : Qt3DRender.QAbstractTexture.ComparisonMode = ... # 0x0
            CompareRefToTexture      : Qt3DRender.QAbstractTexture.ComparisonMode = ... # 0x884e

        class CubeMapFace(object):
            CubeMapPositiveX         : Qt3DRender.QAbstractTexture.CubeMapFace = ... # 0x8515
            CubeMapNegativeX         : Qt3DRender.QAbstractTexture.CubeMapFace = ... # 0x8516
            CubeMapPositiveY         : Qt3DRender.QAbstractTexture.CubeMapFace = ... # 0x8517
            CubeMapNegativeY         : Qt3DRender.QAbstractTexture.CubeMapFace = ... # 0x8518
            CubeMapPositiveZ         : Qt3DRender.QAbstractTexture.CubeMapFace = ... # 0x8519
            CubeMapNegativeZ         : Qt3DRender.QAbstractTexture.CubeMapFace = ... # 0x851a
            AllFaces                 : Qt3DRender.QAbstractTexture.CubeMapFace = ... # 0x851b

        class Filter(object):
            Nearest                  : Qt3DRender.QAbstractTexture.Filter = ... # 0x2600
            Linear                   : Qt3DRender.QAbstractTexture.Filter = ... # 0x2601
            NearestMipMapNearest     : Qt3DRender.QAbstractTexture.Filter = ... # 0x2700
            LinearMipMapNearest      : Qt3DRender.QAbstractTexture.Filter = ... # 0x2701
            NearestMipMapLinear      : Qt3DRender.QAbstractTexture.Filter = ... # 0x2702
            LinearMipMapLinear       : Qt3DRender.QAbstractTexture.Filter = ... # 0x2703

        class HandleType(object):
            NoHandle                 : Qt3DRender.QAbstractTexture.HandleType = ... # 0x0
            OpenGLTextureId          : Qt3DRender.QAbstractTexture.HandleType = ... # 0x1

        class Status(object):
            None_                    : Qt3DRender.QAbstractTexture.Status = ... # 0x0
            Loading                  : Qt3DRender.QAbstractTexture.Status = ... # 0x1
            Ready                    : Qt3DRender.QAbstractTexture.Status = ... # 0x2
            Error                    : Qt3DRender.QAbstractTexture.Status = ... # 0x3

        class Target(object):
            TargetAutomatic          : Qt3DRender.QAbstractTexture.Target = ... # 0x0
            Target1D                 : Qt3DRender.QAbstractTexture.Target = ... # 0xde0
            Target2D                 : Qt3DRender.QAbstractTexture.Target = ... # 0xde1
            Target3D                 : Qt3DRender.QAbstractTexture.Target = ... # 0x806f
            TargetRectangle          : Qt3DRender.QAbstractTexture.Target = ... # 0x84f5
            TargetCubeMap            : Qt3DRender.QAbstractTexture.Target = ... # 0x8513
            Target1DArray            : Qt3DRender.QAbstractTexture.Target = ... # 0x8c18
            Target2DArray            : Qt3DRender.QAbstractTexture.Target = ... # 0x8c1a
            TargetBuffer             : Qt3DRender.QAbstractTexture.Target = ... # 0x8c2a
            TargetCubeMapArray       : Qt3DRender.QAbstractTexture.Target = ... # 0x9009
            Target2DMultisample      : Qt3DRender.QAbstractTexture.Target = ... # 0x9100
            Target2DMultisampleArray : Qt3DRender.QAbstractTexture.Target = ... # 0x9102

        class TextureFormat(object):
            NoFormat                 : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x0
            Automatic                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x1
            DepthFormat              : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x1902
            AlphaFormat              : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x1906
            RGBFormat                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x1907
            RGBAFormat               : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x1908
            LuminanceFormat          : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x1909
            LuminanceAlphaFormat     : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x190a
            RG3B2                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x2a10
            RGB8_UNorm               : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8051
            RGB16_UNorm              : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8054
            RGBA4                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8056
            RGB5A1                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8057
            RGBA8_UNorm              : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8058
            RGB10A2                  : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8059
            RGBA16_UNorm             : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x805b
            D16                      : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x81a5
            D24                      : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x81a6
            D32                      : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x81a7
            R8_UNorm                 : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8229
            R16_UNorm                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x822a
            RG8_UNorm                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x822b
            RG16_UNorm               : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x822c
            R16F                     : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x822d
            R32F                     : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x822e
            RG16F                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x822f
            RG32F                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8230
            R8I                      : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8231
            R8U                      : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8232
            R16I                     : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8233
            R16U                     : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8234
            R32I                     : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8235
            R32U                     : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8236
            RG8I                     : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8237
            RG8U                     : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8238
            RG16I                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8239
            RG16U                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x823a
            RG32I                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x823b
            RG32U                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x823c
            RGB_DXT1                 : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x83f0
            RGBA_DXT1                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x83f1
            RGBA_DXT3                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x83f2
            RGBA_DXT5                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x83f3
            RGBA32F                  : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8814
            RGB32F                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8815
            RGBA16F                  : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x881a
            RGB16F                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x881b
            D24S8                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x88f0
            RG11B10F                 : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8c3a
            RGB9E5                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8c3d
            SRGB8                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8c41
            SRGB8_Alpha8             : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8c43
            SRGB_DXT1                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8c4c
            SRGB_Alpha_DXT1          : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8c4d
            SRGB_Alpha_DXT3          : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8c4e
            SRGB_Alpha_DXT5          : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8c4f
            D32F                     : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8cac
            D32FS8X24                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8cad
            R5G6B5                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d62
            RGB8_ETC1                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d64
            RGBA32U                  : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d70
            RGB32U                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d71
            RGBA16U                  : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d76
            RGB16U                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d77
            RGBA8U                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d7c
            RGB8U                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d7d
            RGBA32I                  : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d82
            RGB32I                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d83
            RGBA16I                  : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d88
            RGB16I                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d89
            RGBA8I                   : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d8e
            RGB8I                    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8d8f
            R_ATI1N_UNorm            : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8dbb
            R_ATI1N_SNorm            : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8dbc
            RG_ATI2N_UNorm           : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8dbd
            RG_ATI2N_SNorm           : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8dbe
            RGB_BP_UNorm             : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8e8c
            SRGB_BP_UNorm            : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8e8d
            RGB_BP_SIGNED_FLOAT      : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8e8e
            RGB_BP_UNSIGNED_FLOAT    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8e8f
            R8_SNorm                 : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8f94
            RG8_SNorm                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8f95
            RGB8_SNorm               : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8f96
            RGBA8_SNorm              : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8f97
            R16_SNorm                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8f98
            RG16_SNorm               : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8f99
            RGB16_SNorm              : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8f9a
            RGBA16_SNorm             : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x8f9b
            RGB10A2U                 : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x906f
            R11_EAC_UNorm            : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x9270
            R11_EAC_SNorm            : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x9271
            RG11_EAC_UNorm           : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x9272
            RG11_EAC_SNorm           : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x9273
            RGB8_ETC2                : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x9274
            SRGB8_ETC2               : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x9275
            RGB8_PunchThrough_Alpha1_ETC2: Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x9276
            SRGB8_PunchThrough_Alpha1_ETC2: Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x9277
            RGBA8_ETC2_EAC           : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x9278
            SRGB8_Alpha8_ETC2_EAC    : Qt3DRender.QAbstractTexture.TextureFormat = ... # 0x9279

        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...
        @typing.overload
        def __init__(self, target:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addTextureImage(self, textureImage:PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage): ...
        def comparisonFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction: ...
        def comparisonMode(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode: ...
        def depth(self) -> int: ...
        def format(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat: ...
        def generateMipMaps(self) -> bool: ...
        def handle(self) -> typing.Any: ...
        def handleType(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.HandleType: ...
        def height(self) -> int: ...
        def layers(self) -> int: ...
        def magnificationFilter(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter: ...
        def maximumAnisotropy(self) -> float: ...
        def minificationFilter(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter: ...
        def removeTextureImage(self, textureImage:PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage): ...
        def samples(self) -> int: ...
        def setComparisonFunction(self, function:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction): ...
        def setComparisonMode(self, mode:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode): ...
        def setDepth(self, depth:int): ...
        def setFormat(self, format:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat): ...
        def setGenerateMipMaps(self, gen:bool): ...
        def setHandle(self, handle:typing.Any): ...
        def setHandleType(self, type:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.HandleType): ...
        def setHeight(self, height:int): ...
        def setLayers(self, layers:int): ...
        def setMagnificationFilter(self, f:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter): ...
        def setMaximumAnisotropy(self, anisotropy:float): ...
        def setMinificationFilter(self, f:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter): ...
        def setSamples(self, samples:int): ...
        def setSize(self, width:int, height:int=..., depth:int=...): ...
        def setStatus(self, status:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Status): ...
        def setWidth(self, width:int): ...
        def setWrapMode(self, wrapMode:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode): ...
        def status(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Status: ...
        def target(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target: ...
        def textureImages(self) -> typing.List: ...
        def width(self) -> int: ...
        def wrapMode(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode: ...

    class QAbstractTextureImage(PySide2.Qt3DCore.Qt3DCore.QNode):
        def face(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace: ...
        def layer(self) -> int: ...
        def mipLevel(self) -> int: ...
        def notifyDataGeneratorChanged(self): ...
        def setFace(self, face:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace): ...
        def setLayer(self, layer:int): ...
        def setMipLevel(self, level:int): ...

    class QAlphaCoverage(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QAlphaTest(PySide2.Qt3DRender.Qt3DRender.QRenderState):
        Never                    : Qt3DRender.QAlphaTest = ... # 0x200
        Less                     : Qt3DRender.QAlphaTest = ... # 0x201
        Equal                    : Qt3DRender.QAlphaTest = ... # 0x202
        LessOrEqual              : Qt3DRender.QAlphaTest = ... # 0x203
        Greater                  : Qt3DRender.QAlphaTest = ... # 0x204
        NotEqual                 : Qt3DRender.QAlphaTest = ... # 0x205
        GreaterOrEqual           : Qt3DRender.QAlphaTest = ... # 0x206
        Always                   : Qt3DRender.QAlphaTest = ... # 0x207

        class AlphaFunction(object):
            Never                    : Qt3DRender.QAlphaTest.AlphaFunction = ... # 0x200
            Less                     : Qt3DRender.QAlphaTest.AlphaFunction = ... # 0x201
            Equal                    : Qt3DRender.QAlphaTest.AlphaFunction = ... # 0x202
            LessOrEqual              : Qt3DRender.QAlphaTest.AlphaFunction = ... # 0x203
            Greater                  : Qt3DRender.QAlphaTest.AlphaFunction = ... # 0x204
            NotEqual                 : Qt3DRender.QAlphaTest.AlphaFunction = ... # 0x205
            GreaterOrEqual           : Qt3DRender.QAlphaTest.AlphaFunction = ... # 0x206
            Always                   : Qt3DRender.QAlphaTest.AlphaFunction = ... # 0x207

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def alphaFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QAlphaTest.AlphaFunction: ...
        def referenceValue(self) -> float: ...
        def setAlphaFunction(self, alphaFunction:PySide2.Qt3DRender.Qt3DRender.QAlphaTest.AlphaFunction): ...
        def setReferenceValue(self, referenceValue:float): ...

    class QAttribute(PySide2.Qt3DCore.Qt3DCore.QNode):
        Byte                     : Qt3DRender.QAttribute = ... # 0x0
        VertexAttribute          : Qt3DRender.QAttribute = ... # 0x0
        IndexAttribute           : Qt3DRender.QAttribute = ... # 0x1
        UnsignedByte             : Qt3DRender.QAttribute = ... # 0x1
        DrawIndirectAttribute    : Qt3DRender.QAttribute = ... # 0x2
        Short                    : Qt3DRender.QAttribute = ... # 0x2
        UnsignedShort            : Qt3DRender.QAttribute = ... # 0x3
        Int                      : Qt3DRender.QAttribute = ... # 0x4
        UnsignedInt              : Qt3DRender.QAttribute = ... # 0x5
        HalfFloat                : Qt3DRender.QAttribute = ... # 0x6
        Float                    : Qt3DRender.QAttribute = ... # 0x7
        Double                   : Qt3DRender.QAttribute = ... # 0x8

        class AttributeType(object):
            VertexAttribute          : Qt3DRender.QAttribute.AttributeType = ... # 0x0
            IndexAttribute           : Qt3DRender.QAttribute.AttributeType = ... # 0x1
            DrawIndirectAttribute    : Qt3DRender.QAttribute.AttributeType = ... # 0x2

        class VertexBaseType(object):
            Byte                     : Qt3DRender.QAttribute.VertexBaseType = ... # 0x0
            UnsignedByte             : Qt3DRender.QAttribute.VertexBaseType = ... # 0x1
            Short                    : Qt3DRender.QAttribute.VertexBaseType = ... # 0x2
            UnsignedShort            : Qt3DRender.QAttribute.VertexBaseType = ... # 0x3
            Int                      : Qt3DRender.QAttribute.VertexBaseType = ... # 0x4
            UnsignedInt              : Qt3DRender.QAttribute.VertexBaseType = ... # 0x5
            HalfFloat                : Qt3DRender.QAttribute.VertexBaseType = ... # 0x6
            Float                    : Qt3DRender.QAttribute.VertexBaseType = ... # 0x7
            Double                   : Qt3DRender.QAttribute.VertexBaseType = ... # 0x8

        @typing.overload
        def __init__(self, buf:PySide2.Qt3DRender.Qt3DRender.QBuffer, name:str, vertexBaseType:PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType, vertexSize:int, count:int, offset:int=..., stride:int=..., parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...
        @typing.overload
        def __init__(self, buf:PySide2.Qt3DRender.Qt3DRender.QBuffer, vertexBaseType:PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType, vertexSize:int, count:int, offset:int=..., stride:int=..., parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def attributeType(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute.AttributeType: ...
        def buffer(self) -> PySide2.Qt3DRender.Qt3DRender.QBuffer: ...
        def byteOffset(self) -> int: ...
        def byteStride(self) -> int: ...
        def count(self) -> int: ...
        @staticmethod
        def defaultColorAttributeName() -> str: ...
        @staticmethod
        def defaultJointIndicesAttributeName() -> str: ...
        @staticmethod
        def defaultJointWeightsAttributeName() -> str: ...
        @staticmethod
        def defaultNormalAttributeName() -> str: ...
        @staticmethod
        def defaultPositionAttributeName() -> str: ...
        @staticmethod
        def defaultTangentAttributeName() -> str: ...
        @staticmethod
        def defaultTextureCoordinate1AttributeName() -> str: ...
        @staticmethod
        def defaultTextureCoordinate2AttributeName() -> str: ...
        @staticmethod
        def defaultTextureCoordinateAttributeName() -> str: ...
        def divisor(self) -> int: ...
        def name(self) -> str: ...
        def setAttributeType(self, attributeType:PySide2.Qt3DRender.Qt3DRender.QAttribute.AttributeType): ...
        def setBuffer(self, buffer:PySide2.Qt3DRender.Qt3DRender.QBuffer): ...
        def setByteOffset(self, byteOffset:int): ...
        def setByteStride(self, byteStride:int): ...
        def setCount(self, count:int): ...
        def setDataSize(self, size:int): ...
        def setDataType(self, type:PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType): ...
        def setDivisor(self, divisor:int): ...
        def setName(self, name:str): ...
        def setVertexBaseType(self, type:PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType): ...
        def setVertexSize(self, size:int): ...
        def vertexBaseType(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType: ...
        def vertexSize(self) -> int: ...

    class QBlendEquation(PySide2.Qt3DRender.Qt3DRender.QRenderState):
        Add                      : Qt3DRender.QBlendEquation = ... # 0x8006
        Min                      : Qt3DRender.QBlendEquation = ... # 0x8007
        Max                      : Qt3DRender.QBlendEquation = ... # 0x8008
        Subtract                 : Qt3DRender.QBlendEquation = ... # 0x800a
        ReverseSubtract          : Qt3DRender.QBlendEquation = ... # 0x800b

        class BlendFunction(object):
            Add                      : Qt3DRender.QBlendEquation.BlendFunction = ... # 0x8006
            Min                      : Qt3DRender.QBlendEquation.BlendFunction = ... # 0x8007
            Max                      : Qt3DRender.QBlendEquation.BlendFunction = ... # 0x8008
            Subtract                 : Qt3DRender.QBlendEquation.BlendFunction = ... # 0x800a
            ReverseSubtract          : Qt3DRender.QBlendEquation.BlendFunction = ... # 0x800b

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def blendFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquation.BlendFunction: ...
        def setBlendFunction(self, blendFunction:PySide2.Qt3DRender.Qt3DRender.QBlendEquation.BlendFunction): ...

    class QBlendEquationArguments(PySide2.Qt3DRender.Qt3DRender.QRenderState):
        Zero                     : Qt3DRender.QBlendEquationArguments = ... # 0x0
        One                      : Qt3DRender.QBlendEquationArguments = ... # 0x1
        SourceColor              : Qt3DRender.QBlendEquationArguments = ... # 0x300
        OneMinusSourceColor      : Qt3DRender.QBlendEquationArguments = ... # 0x301
        SourceAlpha              : Qt3DRender.QBlendEquationArguments = ... # 0x302
        OneMinusSourceAlpha      : Qt3DRender.QBlendEquationArguments = ... # 0x303
        Source1Alpha             : Qt3DRender.QBlendEquationArguments = ... # 0x303
        DestinationAlpha         : Qt3DRender.QBlendEquationArguments = ... # 0x304
        Source1Color             : Qt3DRender.QBlendEquationArguments = ... # 0x304
        OneMinusDestinationAlpha : Qt3DRender.QBlendEquationArguments = ... # 0x305
        DestinationColor         : Qt3DRender.QBlendEquationArguments = ... # 0x306
        OneMinusDestinationColor : Qt3DRender.QBlendEquationArguments = ... # 0x307
        SourceAlphaSaturate      : Qt3DRender.QBlendEquationArguments = ... # 0x308
        ConstantColor            : Qt3DRender.QBlendEquationArguments = ... # 0x8001
        OneMinusConstantColor    : Qt3DRender.QBlendEquationArguments = ... # 0x8002
        ConstantAlpha            : Qt3DRender.QBlendEquationArguments = ... # 0x8003
        OneMinusConstantAlpha    : Qt3DRender.QBlendEquationArguments = ... # 0x8004
        OneMinusSource1Alpha     : Qt3DRender.QBlendEquationArguments = ... # 0x8005
        OneMinusSource1Color     : Qt3DRender.QBlendEquationArguments = ... # 0x8006
        OneMinusSource1Color0    : Qt3DRender.QBlendEquationArguments = ... # 0x8006

        class Blending(object):
            Zero                     : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x0
            One                      : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x1
            SourceColor              : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x300
            OneMinusSourceColor      : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x301
            SourceAlpha              : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x302
            OneMinusSourceAlpha      : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x303
            Source1Alpha             : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x303
            DestinationAlpha         : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x304
            Source1Color             : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x304
            OneMinusDestinationAlpha : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x305
            DestinationColor         : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x306
            OneMinusDestinationColor : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x307
            SourceAlphaSaturate      : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x308
            ConstantColor            : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x8001
            OneMinusConstantColor    : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x8002
            ConstantAlpha            : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x8003
            OneMinusConstantAlpha    : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x8004
            OneMinusSource1Alpha     : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x8005
            OneMinusSource1Color     : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x8006
            OneMinusSource1Color0    : Qt3DRender.QBlendEquationArguments.Blending = ... # 0x8006

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def bufferIndex(self) -> int: ...
        def destinationAlpha(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...
        def destinationRgb(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...
        def setBufferIndex(self, index:int): ...
        def setDestinationAlpha(self, destinationAlpha:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def setDestinationRgb(self, destinationRgb:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def setDestinationRgba(self, destinationRgba:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def setSourceAlpha(self, sourceAlpha:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def setSourceRgb(self, sourceRgb:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def setSourceRgba(self, sourceRgba:PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def sourceAlpha(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...
        def sourceRgb(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...

    class QBlitFramebuffer(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):
        Nearest                  : Qt3DRender.QBlitFramebuffer = ... # 0x0
        Linear                   : Qt3DRender.QBlitFramebuffer = ... # 0x1

        class InterpolationMethod(object):
            Nearest                  : Qt3DRender.QBlitFramebuffer.InterpolationMethod = ... # 0x0
            Linear                   : Qt3DRender.QBlitFramebuffer.InterpolationMethod = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def destination(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTarget: ...
        def destinationAttachmentPoint(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        def destinationRect(self) -> PySide2.QtCore.QRectF: ...
        def interpolationMethod(self) -> PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
        def setDestination(self, destination:PySide2.Qt3DRender.Qt3DRender.QRenderTarget): ...
        def setDestinationAttachmentPoint(self, destinationAttachmentPoint:PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint): ...
        def setDestinationRect(self, destinationRect:PySide2.QtCore.QRectF): ...
        def setInterpolationMethod(self, interpolationMethod:PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.InterpolationMethod): ...
        def setSource(self, source:PySide2.Qt3DRender.Qt3DRender.QRenderTarget): ...
        def setSourceAttachmentPoint(self, sourceAttachmentPoint:PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint): ...
        def setSourceRect(self, sourceRect:PySide2.QtCore.QRectF): ...
        def source(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTarget: ...
        def sourceAttachmentPoint(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        def sourceRect(self) -> PySide2.QtCore.QRectF: ...

    class QBuffer(PySide2.Qt3DCore.Qt3DCore.QNode):
        Write                    : Qt3DRender.QBuffer = ... # 0x1
        Read                     : Qt3DRender.QBuffer = ... # 0x2
        ReadWrite                : Qt3DRender.QBuffer = ... # 0x3
        VertexBuffer             : Qt3DRender.QBuffer = ... # 0x8892
        IndexBuffer              : Qt3DRender.QBuffer = ... # 0x8893
        StreamDraw               : Qt3DRender.QBuffer = ... # 0x88e0
        StreamRead               : Qt3DRender.QBuffer = ... # 0x88e1
        StreamCopy               : Qt3DRender.QBuffer = ... # 0x88e2
        StaticDraw               : Qt3DRender.QBuffer = ... # 0x88e4
        StaticRead               : Qt3DRender.QBuffer = ... # 0x88e5
        StaticCopy               : Qt3DRender.QBuffer = ... # 0x88e6
        DynamicDraw              : Qt3DRender.QBuffer = ... # 0x88e8
        DynamicRead              : Qt3DRender.QBuffer = ... # 0x88e9
        DynamicCopy              : Qt3DRender.QBuffer = ... # 0x88ea
        PixelPackBuffer          : Qt3DRender.QBuffer = ... # 0x88eb
        PixelUnpackBuffer        : Qt3DRender.QBuffer = ... # 0x88ec
        UniformBuffer            : Qt3DRender.QBuffer = ... # 0x8a11
        DrawIndirectBuffer       : Qt3DRender.QBuffer = ... # 0x8f3f
        ShaderStorageBuffer      : Qt3DRender.QBuffer = ... # 0x90d2

        class AccessType(object):
            Write                    : Qt3DRender.QBuffer.AccessType = ... # 0x1
            Read                     : Qt3DRender.QBuffer.AccessType = ... # 0x2
            ReadWrite                : Qt3DRender.QBuffer.AccessType = ... # 0x3

        class BufferType(object):
            VertexBuffer             : Qt3DRender.QBuffer.BufferType = ... # 0x8892
            IndexBuffer              : Qt3DRender.QBuffer.BufferType = ... # 0x8893
            PixelPackBuffer          : Qt3DRender.QBuffer.BufferType = ... # 0x88eb
            PixelUnpackBuffer        : Qt3DRender.QBuffer.BufferType = ... # 0x88ec
            UniformBuffer            : Qt3DRender.QBuffer.BufferType = ... # 0x8a11
            DrawIndirectBuffer       : Qt3DRender.QBuffer.BufferType = ... # 0x8f3f
            ShaderStorageBuffer      : Qt3DRender.QBuffer.BufferType = ... # 0x90d2

        class UsageType(object):
            StreamDraw               : Qt3DRender.QBuffer.UsageType = ... # 0x88e0
            StreamRead               : Qt3DRender.QBuffer.UsageType = ... # 0x88e1
            StreamCopy               : Qt3DRender.QBuffer.UsageType = ... # 0x88e2
            StaticDraw               : Qt3DRender.QBuffer.UsageType = ... # 0x88e4
            StaticRead               : Qt3DRender.QBuffer.UsageType = ... # 0x88e5
            StaticCopy               : Qt3DRender.QBuffer.UsageType = ... # 0x88e6
            DynamicDraw              : Qt3DRender.QBuffer.UsageType = ... # 0x88e8
            DynamicRead              : Qt3DRender.QBuffer.UsageType = ... # 0x88e9
            DynamicCopy              : Qt3DRender.QBuffer.UsageType = ... # 0x88ea

        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...
        @typing.overload
        def __init__(self, ty:PySide2.Qt3DRender.Qt3DRender.QBuffer.BufferType, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def accessType(self) -> PySide2.Qt3DRender.Qt3DRender.QBuffer.AccessType: ...
        def data(self) -> PySide2.QtCore.QByteArray: ...
        def isSyncData(self) -> bool: ...
        def setAccessType(self, access:PySide2.Qt3DRender.Qt3DRender.QBuffer.AccessType): ...
        def setData(self, bytes:PySide2.QtCore.QByteArray): ...
        def setSyncData(self, syncData:bool): ...
        def setType(self, type:PySide2.Qt3DRender.Qt3DRender.QBuffer.BufferType): ...
        def setUsage(self, usage:PySide2.Qt3DRender.Qt3DRender.QBuffer.UsageType): ...
        def type(self) -> PySide2.Qt3DRender.Qt3DRender.QBuffer.BufferType: ...
        def updateData(self, offset:int, bytes:PySide2.QtCore.QByteArray): ...
        def usage(self) -> PySide2.Qt3DRender.Qt3DRender.QBuffer.UsageType: ...

    class QBufferCapture(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QBufferDataGenerator(PySide2.Qt3DRender.Qt3DRender.QAbstractFunctor):

        def __init__(self): ...


    class QCamera(PySide2.Qt3DCore.Qt3DCore.QEntity):
        TranslateViewCenter      : Qt3DRender.QCamera = ... # 0x0
        DontTranslateViewCenter  : Qt3DRender.QCamera = ... # 0x1

        class CameraTranslationOption(object):
            TranslateViewCenter      : Qt3DRender.QCamera.CameraTranslationOption = ... # 0x0
            DontTranslateViewCenter  : Qt3DRender.QCamera.CameraTranslationOption = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def aspectRatio(self) -> float: ...
        def bottom(self) -> float: ...
        def exposure(self) -> float: ...
        def farPlane(self) -> float: ...
        def fieldOfView(self) -> float: ...
        def left(self) -> float: ...
        def lens(self) -> PySide2.Qt3DRender.Qt3DRender.QCameraLens: ...
        def nearPlane(self) -> float: ...
        @typing.overload
        def pan(self, angle:float): ...
        @typing.overload
        def pan(self, angle:float, axis:PySide2.QtGui.QVector3D): ...
        @typing.overload
        def panAboutViewCenter(self, angle:float): ...
        @typing.overload
        def panAboutViewCenter(self, angle:float, axis:PySide2.QtGui.QVector3D): ...
        def panRotation(self, angle:float) -> PySide2.QtGui.QQuaternion: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def projectionMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        def projectionType(self) -> PySide2.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType: ...
        def right(self) -> float: ...
        def roll(self, angle:float): ...
        def rollAboutViewCenter(self, angle:float): ...
        def rollRotation(self, angle:float) -> PySide2.QtGui.QQuaternion: ...
        def rotate(self, q:PySide2.QtGui.QQuaternion): ...
        def rotateAboutViewCenter(self, q:PySide2.QtGui.QQuaternion): ...
        def rotation(self, angle:float, axis:PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
        def setAspectRatio(self, aspectRatio:float): ...
        def setBottom(self, bottom:float): ...
        def setExposure(self, exposure:float): ...
        def setFarPlane(self, farPlane:float): ...
        def setFieldOfView(self, fieldOfView:float): ...
        def setLeft(self, left:float): ...
        def setNearPlane(self, nearPlane:float): ...
        def setPosition(self, position:PySide2.QtGui.QVector3D): ...
        def setProjectionMatrix(self, projectionMatrix:PySide2.QtGui.QMatrix4x4): ...
        def setProjectionType(self, type:PySide2.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType): ...
        def setRight(self, right:float): ...
        def setTop(self, top:float): ...
        def setUpVector(self, upVector:PySide2.QtGui.QVector3D): ...
        def setViewCenter(self, viewCenter:PySide2.QtGui.QVector3D): ...
        def tilt(self, angle:float): ...
        def tiltAboutViewCenter(self, angle:float): ...
        def tiltRotation(self, angle:float) -> PySide2.QtGui.QQuaternion: ...
        def top(self) -> float: ...
        def transform(self) -> PySide2.Qt3DCore.Qt3DCore.QTransform: ...
        def translate(self, vLocal:PySide2.QtGui.QVector3D, option:PySide2.Qt3DRender.Qt3DRender.QCamera.CameraTranslationOption=...): ...
        def translateWorld(self, vWorld:PySide2.QtGui.QVector3D, option:PySide2.Qt3DRender.Qt3DRender.QCamera.CameraTranslationOption=...): ...
        def upVector(self) -> PySide2.QtGui.QVector3D: ...
        def viewAll(self): ...
        def viewCenter(self) -> PySide2.QtGui.QVector3D: ...
        def viewEntity(self, entity:PySide2.Qt3DCore.Qt3DCore.QEntity): ...
        def viewMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        def viewSphere(self, center:PySide2.QtGui.QVector3D, radius:float): ...
        def viewVector(self) -> PySide2.QtGui.QVector3D: ...

    class QCameraLens(PySide2.Qt3DCore.Qt3DCore.QComponent):
        OrthographicProjection   : Qt3DRender.QCameraLens = ... # 0x0
        PerspectiveProjection    : Qt3DRender.QCameraLens = ... # 0x1
        FrustumProjection        : Qt3DRender.QCameraLens = ... # 0x2
        CustomProjection         : Qt3DRender.QCameraLens = ... # 0x3

        class ProjectionType(object):
            OrthographicProjection   : Qt3DRender.QCameraLens.ProjectionType = ... # 0x0
            PerspectiveProjection    : Qt3DRender.QCameraLens.ProjectionType = ... # 0x1
            FrustumProjection        : Qt3DRender.QCameraLens.ProjectionType = ... # 0x2
            CustomProjection         : Qt3DRender.QCameraLens.ProjectionType = ... # 0x3

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def aspectRatio(self) -> float: ...
        def bottom(self) -> float: ...
        def exposure(self) -> float: ...
        def farPlane(self) -> float: ...
        def fieldOfView(self) -> float: ...
        def left(self) -> float: ...
        def nearPlane(self) -> float: ...
        def projectionMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        def projectionType(self) -> PySide2.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType: ...
        def right(self) -> float: ...
        def setAspectRatio(self, aspectRatio:float): ...
        def setBottom(self, bottom:float): ...
        def setExposure(self, exposure:float): ...
        def setFarPlane(self, farPlane:float): ...
        def setFieldOfView(self, fieldOfView:float): ...
        def setFrustumProjection(self, left:float, right:float, bottom:float, top:float, nearPlane:float, farPlane:float): ...
        def setLeft(self, left:float): ...
        def setNearPlane(self, nearPlane:float): ...
        def setOrthographicProjection(self, left:float, right:float, bottom:float, top:float, nearPlane:float, farPlane:float): ...
        def setPerspectiveProjection(self, fieldOfView:float, aspect:float, nearPlane:float, farPlane:float): ...
        def setProjectionMatrix(self, projectionMatrix:PySide2.QtGui.QMatrix4x4): ...
        def setProjectionType(self, projectionType:PySide2.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType): ...
        def setRight(self, right:float): ...
        def setTop(self, top:float): ...
        def top(self) -> float: ...
        def viewAll(self, cameraId:PySide2.Qt3DCore.Qt3DCore.QNodeId): ...
        def viewEntity(self, entityId:PySide2.Qt3DCore.Qt3DCore.QNodeId, cameraId:PySide2.Qt3DCore.Qt3DCore.QNodeId): ...

    class QCameraSelector(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def camera(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def setCamera(self, camera:PySide2.Qt3DCore.Qt3DCore.QEntity): ...

    class QClearBuffers(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):
        AllBuffers               : Qt3DRender.QClearBuffers = ... # -0x1
        None_                    : Qt3DRender.QClearBuffers = ... # 0x0
        ColorBuffer              : Qt3DRender.QClearBuffers = ... # 0x1
        DepthBuffer              : Qt3DRender.QClearBuffers = ... # 0x2
        ColorDepthBuffer         : Qt3DRender.QClearBuffers = ... # 0x3
        StencilBuffer            : Qt3DRender.QClearBuffers = ... # 0x4
        DepthStencilBuffer       : Qt3DRender.QClearBuffers = ... # 0x6
        ColorDepthStencilBuffer  : Qt3DRender.QClearBuffers = ... # 0x7

        class BufferType(object):
            AllBuffers               : Qt3DRender.QClearBuffers.BufferType = ... # -0x1
            None_                    : Qt3DRender.QClearBuffers.BufferType = ... # 0x0
            ColorBuffer              : Qt3DRender.QClearBuffers.BufferType = ... # 0x1
            DepthBuffer              : Qt3DRender.QClearBuffers.BufferType = ... # 0x2
            ColorDepthBuffer         : Qt3DRender.QClearBuffers.BufferType = ... # 0x3
            StencilBuffer            : Qt3DRender.QClearBuffers.BufferType = ... # 0x4
            DepthStencilBuffer       : Qt3DRender.QClearBuffers.BufferType = ... # 0x6
            ColorDepthStencilBuffer  : Qt3DRender.QClearBuffers.BufferType = ... # 0x7

        class BufferTypeFlags(object): ...

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def buffers(self) -> PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType: ...
        def clearColor(self) -> PySide2.QtGui.QColor: ...
        def clearDepthValue(self) -> float: ...
        def clearStencilValue(self) -> int: ...
        def colorBuffer(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput: ...
        def setBuffers(self, buffers:PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType): ...
        def setClearColor(self, color:PySide2.QtGui.QColor): ...
        def setClearDepthValue(self, clearDepthValue:float): ...
        def setClearStencilValue(self, clearStencilValue:int): ...
        def setColorBuffer(self, buffer:PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput): ...

    class QClipPlane(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def distance(self) -> float: ...
        def normal(self) -> PySide2.QtGui.QVector3D: ...
        def planeIndex(self) -> int: ...
        def setDistance(self, arg__1:float): ...
        def setNormal(self, arg__1:PySide2.QtGui.QVector3D): ...
        def setPlaneIndex(self, arg__1:int): ...

    class QColorMask(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def isAlphaMasked(self) -> bool: ...
        def isBlueMasked(self) -> bool: ...
        def isGreenMasked(self) -> bool: ...
        def isRedMasked(self) -> bool: ...
        def setAlphaMasked(self, alphaMasked:bool): ...
        def setBlueMasked(self, blueMasked:bool): ...
        def setGreenMasked(self, greenMasked:bool): ...
        def setRedMasked(self, redMasked:bool): ...

    class QComputeCommand(PySide2.Qt3DCore.Qt3DCore.QComponent):
        Continuous               : Qt3DRender.QComputeCommand = ... # 0x0
        Manual                   : Qt3DRender.QComputeCommand = ... # 0x1

        class RunType(object):
            Continuous               : Qt3DRender.QComputeCommand.RunType = ... # 0x0
            Manual                   : Qt3DRender.QComputeCommand.RunType = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def runType(self) -> PySide2.Qt3DRender.Qt3DRender.QComputeCommand.RunType: ...
        def setRunType(self, runType:PySide2.Qt3DRender.Qt3DRender.QComputeCommand.RunType): ...
        def setWorkGroupX(self, workGroupX:int): ...
        def setWorkGroupY(self, workGroupY:int): ...
        def setWorkGroupZ(self, workGroupZ:int): ...
        @typing.overload
        def trigger(self, frameCount:int=...): ...
        @typing.overload
        def trigger(self, workGroupX:int, workGroupY:int, workGroupZ:int, frameCount:int=...): ...
        def workGroupX(self) -> int: ...
        def workGroupY(self) -> int: ...
        def workGroupZ(self) -> int: ...

    class QCullFace(PySide2.Qt3DRender.Qt3DRender.QRenderState):
        NoCulling                : Qt3DRender.QCullFace = ... # 0x0
        Front                    : Qt3DRender.QCullFace = ... # 0x404
        Back                     : Qt3DRender.QCullFace = ... # 0x405
        FrontAndBack             : Qt3DRender.QCullFace = ... # 0x408

        class CullingMode(object):
            NoCulling                : Qt3DRender.QCullFace.CullingMode = ... # 0x0
            Front                    : Qt3DRender.QCullFace.CullingMode = ... # 0x404
            Back                     : Qt3DRender.QCullFace.CullingMode = ... # 0x405
            FrontAndBack             : Qt3DRender.QCullFace.CullingMode = ... # 0x408

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def mode(self) -> PySide2.Qt3DRender.Qt3DRender.QCullFace.CullingMode: ...
        def setMode(self, mode:PySide2.Qt3DRender.Qt3DRender.QCullFace.CullingMode): ...

    class QDepthTest(PySide2.Qt3DRender.Qt3DRender.QRenderState):
        Never                    : Qt3DRender.QDepthTest = ... # 0x200
        Less                     : Qt3DRender.QDepthTest = ... # 0x201
        Equal                    : Qt3DRender.QDepthTest = ... # 0x202
        LessOrEqual              : Qt3DRender.QDepthTest = ... # 0x203
        Greater                  : Qt3DRender.QDepthTest = ... # 0x204
        NotEqual                 : Qt3DRender.QDepthTest = ... # 0x205
        GreaterOrEqual           : Qt3DRender.QDepthTest = ... # 0x206
        Always                   : Qt3DRender.QDepthTest = ... # 0x207

        class DepthFunction(object):
            Never                    : Qt3DRender.QDepthTest.DepthFunction = ... # 0x200
            Less                     : Qt3DRender.QDepthTest.DepthFunction = ... # 0x201
            Equal                    : Qt3DRender.QDepthTest.DepthFunction = ... # 0x202
            LessOrEqual              : Qt3DRender.QDepthTest.DepthFunction = ... # 0x203
            Greater                  : Qt3DRender.QDepthTest.DepthFunction = ... # 0x204
            NotEqual                 : Qt3DRender.QDepthTest.DepthFunction = ... # 0x205
            GreaterOrEqual           : Qt3DRender.QDepthTest.DepthFunction = ... # 0x206
            Always                   : Qt3DRender.QDepthTest.DepthFunction = ... # 0x207

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def depthFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QDepthTest.DepthFunction: ...
        def setDepthFunction(self, depthFunction:PySide2.Qt3DRender.Qt3DRender.QDepthTest.DepthFunction): ...

    class QDirectionalLight(PySide2.Qt3DRender.Qt3DRender.QAbstractLight):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def setWorldDirection(self, worldDirection:PySide2.QtGui.QVector3D): ...
        def worldDirection(self) -> PySide2.QtGui.QVector3D: ...

    class QDispatchCompute(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def setWorkGroupX(self, workGroupX:int): ...
        def setWorkGroupY(self, workGroupY:int): ...
        def setWorkGroupZ(self, workGroupZ:int): ...
        def workGroupX(self) -> int: ...
        def workGroupY(self) -> int: ...
        def workGroupZ(self) -> int: ...

    class QDithering(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QEffect(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addParameter(self, parameter:PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def addTechnique(self, t:PySide2.Qt3DRender.Qt3DRender.QTechnique): ...
        def parameters(self) -> typing.List: ...
        def removeParameter(self, parameter:PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def removeTechnique(self, t:PySide2.Qt3DRender.Qt3DRender.QTechnique): ...
        def techniques(self) -> typing.List: ...

    class QEnvironmentLight(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def irradiance(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def setIrradiance(self, irradiance:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture): ...
        def setSpecular(self, specular:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture): ...
        def specular(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...

    class QFilterKey(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def name(self) -> str: ...
        def setName(self, customType:str): ...
        def setValue(self, value:typing.Any): ...
        def value(self) -> typing.Any: ...

    class QFrameGraphNode(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def parentFrameGraphNode(self) -> PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode: ...

    class QFrameGraphNodeCreatedChangeBase(PySide2.Qt3DCore.Qt3DCore.QNodeCreatedChangeBase):

        def __init__(self, node:PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode): ...

        def parentFrameGraphNodeId(self) -> PySide2.Qt3DCore.Qt3DCore.QNodeId: ...

    class QFrontFace(PySide2.Qt3DRender.Qt3DRender.QRenderState):
        ClockWise                : Qt3DRender.QFrontFace = ... # 0x900
        CounterClockWise         : Qt3DRender.QFrontFace = ... # 0x901

        class WindingDirection(object):
            ClockWise                : Qt3DRender.QFrontFace.WindingDirection = ... # 0x900
            CounterClockWise         : Qt3DRender.QFrontFace.WindingDirection = ... # 0x901

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def direction(self) -> PySide2.Qt3DRender.Qt3DRender.QFrontFace.WindingDirection: ...
        def setDirection(self, direction:PySide2.Qt3DRender.Qt3DRender.QFrontFace.WindingDirection): ...

    class QFrustumCulling(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QGeometry(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addAttribute(self, attribute:PySide2.Qt3DRender.Qt3DRender.QAttribute): ...
        def attributes(self) -> typing.List: ...
        def boundingVolumePositionAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def maxExtent(self) -> PySide2.QtGui.QVector3D: ...
        def minExtent(self) -> PySide2.QtGui.QVector3D: ...
        def removeAttribute(self, attribute:PySide2.Qt3DRender.Qt3DRender.QAttribute): ...
        def setBoundingVolumePositionAttribute(self, boundingVolumePositionAttribute:PySide2.Qt3DRender.Qt3DRender.QAttribute): ...

    class QGeometryFactory(PySide2.Qt3DRender.Qt3DRender.QAbstractFunctor):

        def __init__(self): ...


    class QGeometryRenderer(PySide2.Qt3DCore.Qt3DCore.QComponent):
        Points                   : Qt3DRender.QGeometryRenderer = ... # 0x0
        Lines                    : Qt3DRender.QGeometryRenderer = ... # 0x1
        LineLoop                 : Qt3DRender.QGeometryRenderer = ... # 0x2
        LineStrip                : Qt3DRender.QGeometryRenderer = ... # 0x3
        Triangles                : Qt3DRender.QGeometryRenderer = ... # 0x4
        TriangleStrip            : Qt3DRender.QGeometryRenderer = ... # 0x5
        TriangleFan              : Qt3DRender.QGeometryRenderer = ... # 0x6
        LinesAdjacency           : Qt3DRender.QGeometryRenderer = ... # 0xa
        LineStripAdjacency       : Qt3DRender.QGeometryRenderer = ... # 0xb
        TrianglesAdjacency       : Qt3DRender.QGeometryRenderer = ... # 0xc
        TriangleStripAdjacency   : Qt3DRender.QGeometryRenderer = ... # 0xd
        Patches                  : Qt3DRender.QGeometryRenderer = ... # 0xe

        class PrimitiveType(object):
            Points                   : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0x0
            Lines                    : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0x1
            LineLoop                 : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0x2
            LineStrip                : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0x3
            Triangles                : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0x4
            TriangleStrip            : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0x5
            TriangleFan              : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0x6
            LinesAdjacency           : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0xa
            LineStripAdjacency       : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0xb
            TrianglesAdjacency       : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0xc
            TriangleStripAdjacency   : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0xd
            Patches                  : Qt3DRender.QGeometryRenderer.PrimitiveType = ... # 0xe

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def firstInstance(self) -> int: ...
        def firstVertex(self) -> int: ...
        def geometry(self) -> PySide2.Qt3DRender.Qt3DRender.QGeometry: ...
        def indexBufferByteOffset(self) -> int: ...
        def indexOffset(self) -> int: ...
        def instanceCount(self) -> int: ...
        def primitiveRestartEnabled(self) -> bool: ...
        def primitiveType(self) -> PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType: ...
        def restartIndexValue(self) -> int: ...
        def setFirstInstance(self, firstInstance:int): ...
        def setFirstVertex(self, firstVertex:int): ...
        def setGeometry(self, geometry:PySide2.Qt3DRender.Qt3DRender.QGeometry): ...
        def setIndexBufferByteOffset(self, offset:int): ...
        def setIndexOffset(self, indexOffset:int): ...
        def setInstanceCount(self, instanceCount:int): ...
        def setPrimitiveRestartEnabled(self, enabled:bool): ...
        def setPrimitiveType(self, primitiveType:PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType): ...
        def setRestartIndexValue(self, index:int): ...
        def setVertexCount(self, vertexCount:int): ...
        def setVerticesPerPatch(self, verticesPerPatch:int): ...
        def vertexCount(self) -> int: ...
        def verticesPerPatch(self) -> int: ...

    class QGraphicsApiFilter(PySide2.QtCore.QObject):
        NoProfile                : Qt3DRender.QGraphicsApiFilter = ... # 0x0
        CoreProfile              : Qt3DRender.QGraphicsApiFilter = ... # 0x1
        OpenGL                   : Qt3DRender.QGraphicsApiFilter = ... # 0x1
        CompatibilityProfile     : Qt3DRender.QGraphicsApiFilter = ... # 0x2
        OpenGLES                 : Qt3DRender.QGraphicsApiFilter = ... # 0x2
        Vulkan                   : Qt3DRender.QGraphicsApiFilter = ... # 0x3
        DirectX                  : Qt3DRender.QGraphicsApiFilter = ... # 0x4

        class Api(object):
            OpenGL                   : Qt3DRender.QGraphicsApiFilter.Api = ... # 0x1
            OpenGLES                 : Qt3DRender.QGraphicsApiFilter.Api = ... # 0x2
            Vulkan                   : Qt3DRender.QGraphicsApiFilter.Api = ... # 0x3
            DirectX                  : Qt3DRender.QGraphicsApiFilter.Api = ... # 0x4

        class OpenGLProfile(object):
            NoProfile                : Qt3DRender.QGraphicsApiFilter.OpenGLProfile = ... # 0x0
            CoreProfile              : Qt3DRender.QGraphicsApiFilter.OpenGLProfile = ... # 0x1
            CompatibilityProfile     : Qt3DRender.QGraphicsApiFilter.OpenGLProfile = ... # 0x2

        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

        def api(self) -> PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.Api: ...
        def extensions(self) -> typing.List: ...
        def majorVersion(self) -> int: ...
        def minorVersion(self) -> int: ...
        def profile(self) -> PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
        def setApi(self, api:PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.Api): ...
        def setExtensions(self, extensions:typing.Sequence): ...
        def setMajorVersion(self, majorVersion:int): ...
        def setMinorVersion(self, minorVersion:int): ...
        def setProfile(self, profile:PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.OpenGLProfile): ...
        def setVendor(self, vendor:str): ...
        def vendor(self) -> str: ...

    class QLayer(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def recursive(self) -> bool: ...
        def setRecursive(self, recursive:bool): ...

    class QLayerFilter(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):
        AcceptAnyMatchingLayers  : Qt3DRender.QLayerFilter = ... # 0x0
        AcceptAllMatchingLayers  : Qt3DRender.QLayerFilter = ... # 0x1
        DiscardAnyMatchingLayers : Qt3DRender.QLayerFilter = ... # 0x2
        DiscardAllMatchingLayers : Qt3DRender.QLayerFilter = ... # 0x3

        class FilterMode(object):
            AcceptAnyMatchingLayers  : Qt3DRender.QLayerFilter.FilterMode = ... # 0x0
            AcceptAllMatchingLayers  : Qt3DRender.QLayerFilter.FilterMode = ... # 0x1
            DiscardAnyMatchingLayers : Qt3DRender.QLayerFilter.FilterMode = ... # 0x2
            DiscardAllMatchingLayers : Qt3DRender.QLayerFilter.FilterMode = ... # 0x3

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addLayer(self, layer:PySide2.Qt3DRender.Qt3DRender.QLayer): ...
        def filterMode(self) -> PySide2.Qt3DRender.Qt3DRender.QLayerFilter.FilterMode: ...
        def layers(self) -> typing.List: ...
        def removeLayer(self, layer:PySide2.Qt3DRender.Qt3DRender.QLayer): ...
        def setFilterMode(self, filterMode:PySide2.Qt3DRender.Qt3DRender.QLayerFilter.FilterMode): ...

    class QLevelOfDetail(PySide2.Qt3DCore.Qt3DCore.QComponent):
        DistanceToCameraThreshold: Qt3DRender.QLevelOfDetail = ... # 0x0
        ProjectedScreenPixelSizeThreshold: Qt3DRender.QLevelOfDetail = ... # 0x1

        class ThresholdType(object):
            DistanceToCameraThreshold: Qt3DRender.QLevelOfDetail.ThresholdType = ... # 0x0
            ProjectedScreenPixelSizeThreshold: Qt3DRender.QLevelOfDetail.ThresholdType = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def camera(self) -> PySide2.Qt3DRender.Qt3DRender.QCamera: ...
        def createBoundingSphere(self, center:PySide2.QtGui.QVector3D, radius:float) -> PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere: ...
        def currentIndex(self) -> int: ...
        def setCamera(self, camera:PySide2.Qt3DRender.Qt3DRender.QCamera): ...
        def setCurrentIndex(self, currentIndex:int): ...
        def setThresholdType(self, thresholdType:PySide2.Qt3DRender.Qt3DRender.QLevelOfDetail.ThresholdType): ...
        def setThresholds(self, thresholds:typing.List): ...
        def setVolumeOverride(self, volumeOverride:PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere): ...
        def thresholdType(self) -> PySide2.Qt3DRender.Qt3DRender.QLevelOfDetail.ThresholdType: ...
        def thresholds(self) -> typing.List: ...
        def volumeOverride(self) -> PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere: ...

    class QLevelOfDetailBoundingSphere(Shiboken.Object):

        @typing.overload
        def __init__(self, center:PySide2.QtGui.QVector3D=..., radius:float=...): ...
        @typing.overload
        def __init__(self, other:PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere): ...

        def center(self) -> PySide2.QtGui.QVector3D: ...
        def isEmpty(self) -> bool: ...
        def radius(self) -> float: ...

    class QLevelOfDetailSwitch(PySide2.Qt3DRender.Qt3DRender.QLevelOfDetail):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QLineWidth(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def setSmooth(self, enabled:bool): ...
        def setValue(self, value:float): ...
        def smooth(self) -> bool: ...
        def value(self) -> float: ...

    class QMaterial(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addParameter(self, parameter:PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def effect(self) -> PySide2.Qt3DRender.Qt3DRender.QEffect: ...
        def parameters(self) -> typing.List: ...
        def removeParameter(self, parameter:PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def setEffect(self, effect:PySide2.Qt3DRender.Qt3DRender.QEffect): ...

    class QMemoryBarrier(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):
        All                      : Qt3DRender.QMemoryBarrier = ... # -0x1
        None_                    : Qt3DRender.QMemoryBarrier = ... # 0x0
        VertexAttributeArray     : Qt3DRender.QMemoryBarrier = ... # 0x1
        ElementArray             : Qt3DRender.QMemoryBarrier = ... # 0x2
        Uniform                  : Qt3DRender.QMemoryBarrier = ... # 0x4
        TextureFetch             : Qt3DRender.QMemoryBarrier = ... # 0x8
        ShaderImageAccess        : Qt3DRender.QMemoryBarrier = ... # 0x10
        Command                  : Qt3DRender.QMemoryBarrier = ... # 0x20
        PixelBuffer              : Qt3DRender.QMemoryBarrier = ... # 0x40
        TextureUpdate            : Qt3DRender.QMemoryBarrier = ... # 0x80
        BufferUpdate             : Qt3DRender.QMemoryBarrier = ... # 0x100
        FrameBuffer              : Qt3DRender.QMemoryBarrier = ... # 0x200
        TransformFeedback        : Qt3DRender.QMemoryBarrier = ... # 0x400
        AtomicCounter            : Qt3DRender.QMemoryBarrier = ... # 0x800
        ShaderStorage            : Qt3DRender.QMemoryBarrier = ... # 0x1000
        QueryBuffer              : Qt3DRender.QMemoryBarrier = ... # 0x2000

        class Operation(object):
            All                      : Qt3DRender.QMemoryBarrier.Operation = ... # -0x1
            None_                    : Qt3DRender.QMemoryBarrier.Operation = ... # 0x0
            VertexAttributeArray     : Qt3DRender.QMemoryBarrier.Operation = ... # 0x1
            ElementArray             : Qt3DRender.QMemoryBarrier.Operation = ... # 0x2
            Uniform                  : Qt3DRender.QMemoryBarrier.Operation = ... # 0x4
            TextureFetch             : Qt3DRender.QMemoryBarrier.Operation = ... # 0x8
            ShaderImageAccess        : Qt3DRender.QMemoryBarrier.Operation = ... # 0x10
            Command                  : Qt3DRender.QMemoryBarrier.Operation = ... # 0x20
            PixelBuffer              : Qt3DRender.QMemoryBarrier.Operation = ... # 0x40
            TextureUpdate            : Qt3DRender.QMemoryBarrier.Operation = ... # 0x80
            BufferUpdate             : Qt3DRender.QMemoryBarrier.Operation = ... # 0x100
            FrameBuffer              : Qt3DRender.QMemoryBarrier.Operation = ... # 0x200
            TransformFeedback        : Qt3DRender.QMemoryBarrier.Operation = ... # 0x400
            AtomicCounter            : Qt3DRender.QMemoryBarrier.Operation = ... # 0x800
            ShaderStorage            : Qt3DRender.QMemoryBarrier.Operation = ... # 0x1000
            QueryBuffer              : Qt3DRender.QMemoryBarrier.Operation = ... # 0x2000

        class Operations(object): ...

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def setWaitOperations(self, operations:PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.Operations): ...
        def waitOperations(self) -> PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.Operations: ...

    class QMesh(PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer):
        None_                    : Qt3DRender.QMesh = ... # 0x0
        Loading                  : Qt3DRender.QMesh = ... # 0x1
        Ready                    : Qt3DRender.QMesh = ... # 0x2
        Error                    : Qt3DRender.QMesh = ... # 0x3

        class Status(object):
            None_                    : Qt3DRender.QMesh.Status = ... # 0x0
            Loading                  : Qt3DRender.QMesh.Status = ... # 0x1
            Ready                    : Qt3DRender.QMesh.Status = ... # 0x2
            Error                    : Qt3DRender.QMesh.Status = ... # 0x3

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def meshName(self) -> str: ...
        def setMeshName(self, meshName:str): ...
        def setSource(self, source:PySide2.QtCore.QUrl): ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> PySide2.Qt3DRender.Qt3DRender.QMesh.Status: ...

    class QMultiSampleAntiAliasing(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QNoDepthMask(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QNoDraw(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QNoPicking(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QObjectPicker(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def containsMouse(self) -> bool: ...
        def isDragEnabled(self) -> bool: ...
        def isHoverEnabled(self) -> bool: ...
        def isPressed(self) -> bool: ...
        def priority(self) -> int: ...
        def setDragEnabled(self, dragEnabled:bool): ...
        def setHoverEnabled(self, hoverEnabled:bool): ...
        def setPriority(self, priority:int): ...

    class QPaintedTextureImage(PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def height(self) -> int: ...
        def paint(self, painter:PySide2.QtGui.QPainter): ...
        def setHeight(self, h:int): ...
        def setSize(self, size:PySide2.QtCore.QSize): ...
        def setWidth(self, w:int): ...
        def size(self) -> PySide2.QtCore.QSize: ...
        def update(self, rect:PySide2.QtCore.QRect=...): ...
        def width(self) -> int: ...

    class QParameter(PySide2.Qt3DCore.Qt3DCore.QNode):

        @typing.overload
        def __init__(self, name:str, texture:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...
        @typing.overload
        def __init__(self, name:str, value:typing.Any, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...
        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def name(self) -> str: ...
        def setName(self, name:str): ...
        def setValue(self, dv:typing.Any): ...
        def value(self) -> typing.Any: ...

    class QPickEvent(PySide2.QtCore.QObject):
        NoButton                 : Qt3DRender.QPickEvent = ... # 0x0
        NoModifier               : Qt3DRender.QPickEvent = ... # 0x0
        LeftButton               : Qt3DRender.QPickEvent = ... # 0x1
        RightButton              : Qt3DRender.QPickEvent = ... # 0x2
        MiddleButton             : Qt3DRender.QPickEvent = ... # 0x4
        BackButton               : Qt3DRender.QPickEvent = ... # 0x8
        ShiftModifier            : Qt3DRender.QPickEvent = ... # 0x2000000
        ControlModifier          : Qt3DRender.QPickEvent = ... # 0x4000000
        AltModifier              : Qt3DRender.QPickEvent = ... # 0x8000000
        MetaModifier             : Qt3DRender.QPickEvent = ... # 0x10000000
        KeypadModifier           : Qt3DRender.QPickEvent = ... # 0x20000000

        class Buttons(object):
            NoButton                 : Qt3DRender.QPickEvent.Buttons = ... # 0x0
            LeftButton               : Qt3DRender.QPickEvent.Buttons = ... # 0x1
            RightButton              : Qt3DRender.QPickEvent.Buttons = ... # 0x2
            MiddleButton             : Qt3DRender.QPickEvent.Buttons = ... # 0x4
            BackButton               : Qt3DRender.QPickEvent.Buttons = ... # 0x8

        class Modifiers(object):
            NoModifier               : Qt3DRender.QPickEvent.Modifiers = ... # 0x0
            ShiftModifier            : Qt3DRender.QPickEvent.Modifiers = ... # 0x2000000
            ControlModifier          : Qt3DRender.QPickEvent.Modifiers = ... # 0x4000000
            AltModifier              : Qt3DRender.QPickEvent.Modifiers = ... # 0x8000000
            MetaModifier             : Qt3DRender.QPickEvent.Modifiers = ... # 0x10000000
            KeypadModifier           : Qt3DRender.QPickEvent.Modifiers = ... # 0x20000000

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, position:PySide2.QtCore.QPointF, worldIntersection:PySide2.QtGui.QVector3D, localIntersection:PySide2.QtGui.QVector3D, distance:float): ...
        @typing.overload
        def __init__(self, position:PySide2.QtCore.QPointF, worldIntersection:PySide2.QtGui.QVector3D, localIntersection:PySide2.QtGui.QVector3D, distance:float, button:PySide2.Qt3DRender.Qt3DRender.QPickEvent.Buttons, buttons:int, modifiers:int): ...

        def button(self) -> PySide2.Qt3DRender.Qt3DRender.QPickEvent.Buttons: ...
        def buttons(self) -> int: ...
        def distance(self) -> float: ...
        def entity(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def isAccepted(self) -> bool: ...
        def localIntersection(self) -> PySide2.QtGui.QVector3D: ...
        def modifiers(self) -> int: ...
        def position(self) -> PySide2.QtCore.QPointF: ...
        def setAccepted(self, accepted:bool): ...
        def viewport(self) -> PySide2.Qt3DRender.Qt3DRender.QViewport: ...
        def worldIntersection(self) -> PySide2.QtGui.QVector3D: ...

    class QPickLineEvent(PySide2.Qt3DRender.Qt3DRender.QPickEvent):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, position:PySide2.QtCore.QPointF, worldIntersection:PySide2.QtGui.QVector3D, localIntersection:PySide2.QtGui.QVector3D, distance:float, edgeIndex:int, vertex1Index:int, vertex2Index:int, button:PySide2.Qt3DRender.Qt3DRender.QPickEvent.Buttons, buttons:int, modifiers:int): ...

        def edgeIndex(self) -> int: ...
        def vertex1Index(self) -> int: ...
        def vertex2Index(self) -> int: ...

    class QPickPointEvent(PySide2.Qt3DRender.Qt3DRender.QPickEvent):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, position:PySide2.QtCore.QPointF, worldIntersection:PySide2.QtGui.QVector3D, localIntersection:PySide2.QtGui.QVector3D, distance:float, pointIndex:int, button:PySide2.Qt3DRender.Qt3DRender.QPickEvent.Buttons, buttons:int, modifiers:int): ...

        def pointIndex(self) -> int: ...

    class QPickTriangleEvent(PySide2.Qt3DRender.Qt3DRender.QPickEvent):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, position:PySide2.QtCore.QPointF, worldIntersection:PySide2.QtGui.QVector3D, localIntersection:PySide2.QtGui.QVector3D, distance:float, triangleIndex:int, vertex1Index:int, vertex2Index:int, vertex3Index:int): ...
        @typing.overload
        def __init__(self, position:PySide2.QtCore.QPointF, worldIntersection:PySide2.QtGui.QVector3D, localIntersection:PySide2.QtGui.QVector3D, distance:float, triangleIndex:int, vertex1Index:int, vertex2Index:int, vertex3Index:int, button:PySide2.Qt3DRender.Qt3DRender.QPickEvent.Buttons, buttons:int, modifiers:int, uvw:PySide2.QtGui.QVector3D): ...

        def triangleIndex(self) -> int: ...
        def uvw(self) -> PySide2.QtGui.QVector3D: ...
        def vertex1Index(self) -> int: ...
        def vertex2Index(self) -> int: ...
        def vertex3Index(self) -> int: ...

    class QPickingSettings(PySide2.Qt3DCore.Qt3DCore.QNode):
        BoundingVolumePicking    : Qt3DRender.QPickingSettings = ... # 0x0
        NearestPick              : Qt3DRender.QPickingSettings = ... # 0x0
        AllPicks                 : Qt3DRender.QPickingSettings = ... # 0x1
        FrontFace                : Qt3DRender.QPickingSettings = ... # 0x1
        TrianglePicking          : Qt3DRender.QPickingSettings = ... # 0x1
        BackFace                 : Qt3DRender.QPickingSettings = ... # 0x2
        LinePicking              : Qt3DRender.QPickingSettings = ... # 0x2
        NearestPriorityPick      : Qt3DRender.QPickingSettings = ... # 0x2
        FrontAndBackFace         : Qt3DRender.QPickingSettings = ... # 0x3
        PointPicking             : Qt3DRender.QPickingSettings = ... # 0x4
        PrimitivePicking         : Qt3DRender.QPickingSettings = ... # 0x7

        class FaceOrientationPickingMode(object):
            FrontFace                : Qt3DRender.QPickingSettings.FaceOrientationPickingMode = ... # 0x1
            BackFace                 : Qt3DRender.QPickingSettings.FaceOrientationPickingMode = ... # 0x2
            FrontAndBackFace         : Qt3DRender.QPickingSettings.FaceOrientationPickingMode = ... # 0x3

        class PickMethod(object):
            BoundingVolumePicking    : Qt3DRender.QPickingSettings.PickMethod = ... # 0x0
            TrianglePicking          : Qt3DRender.QPickingSettings.PickMethod = ... # 0x1
            LinePicking              : Qt3DRender.QPickingSettings.PickMethod = ... # 0x2
            PointPicking             : Qt3DRender.QPickingSettings.PickMethod = ... # 0x4
            PrimitivePicking         : Qt3DRender.QPickingSettings.PickMethod = ... # 0x7

        class PickResultMode(object):
            NearestPick              : Qt3DRender.QPickingSettings.PickResultMode = ... # 0x0
            AllPicks                 : Qt3DRender.QPickingSettings.PickResultMode = ... # 0x1
            NearestPriorityPick      : Qt3DRender.QPickingSettings.PickResultMode = ... # 0x2

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def faceOrientationPickingMode(self) -> PySide2.Qt3DRender.Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
        def pickMethod(self) -> PySide2.Qt3DRender.Qt3DRender.QPickingSettings.PickMethod: ...
        def pickResultMode(self) -> PySide2.Qt3DRender.Qt3DRender.QPickingSettings.PickResultMode: ...
        def setFaceOrientationPickingMode(self, faceOrientationPickingMode:PySide2.Qt3DRender.Qt3DRender.QPickingSettings.FaceOrientationPickingMode): ...
        def setPickMethod(self, pickMethod:PySide2.Qt3DRender.Qt3DRender.QPickingSettings.PickMethod): ...
        def setPickResultMode(self, pickResultMode:PySide2.Qt3DRender.Qt3DRender.QPickingSettings.PickResultMode): ...
        def setWorldSpaceTolerance(self, worldSpaceTolerance:float): ...
        def worldSpaceTolerance(self) -> float: ...

    class QPointLight(PySide2.Qt3DRender.Qt3DRender.QAbstractLight):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def constantAttenuation(self) -> float: ...
        def linearAttenuation(self) -> float: ...
        def quadraticAttenuation(self) -> float: ...
        def setConstantAttenuation(self, value:float): ...
        def setLinearAttenuation(self, value:float): ...
        def setQuadraticAttenuation(self, value:float): ...

    class QPointSize(PySide2.Qt3DRender.Qt3DRender.QRenderState):
        Fixed                    : Qt3DRender.QPointSize = ... # 0x0
        Programmable             : Qt3DRender.QPointSize = ... # 0x1

        class SizeMode(object):
            Fixed                    : Qt3DRender.QPointSize.SizeMode = ... # 0x0
            Programmable             : Qt3DRender.QPointSize.SizeMode = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def setSizeMode(self, sizeMode:PySide2.Qt3DRender.Qt3DRender.QPointSize.SizeMode): ...
        def setValue(self, value:float): ...
        def sizeMode(self) -> PySide2.Qt3DRender.Qt3DRender.QPointSize.SizeMode: ...
        def value(self) -> float: ...

    class QPolygonOffset(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def depthSteps(self) -> float: ...
        def scaleFactor(self) -> float: ...
        def setDepthSteps(self, depthSteps:float): ...
        def setScaleFactor(self, scaleFactor:float): ...

    class QProximityFilter(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def distanceThreshold(self) -> float: ...
        def entity(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def setDistanceThreshold(self, distanceThreshold:float): ...
        def setEntity(self, entity:PySide2.Qt3DCore.Qt3DCore.QEntity): ...

    class QRayCaster(PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def direction(self) -> PySide2.QtGui.QVector3D: ...
        def length(self) -> float: ...
        def origin(self) -> PySide2.QtGui.QVector3D: ...
        def setDirection(self, direction:PySide2.QtGui.QVector3D): ...
        def setLength(self, length:float): ...
        def setOrigin(self, origin:PySide2.QtGui.QVector3D): ...
        @typing.overload
        def trigger(self): ...
        @typing.overload
        def trigger(self, origin:PySide2.QtGui.QVector3D, direction:PySide2.QtGui.QVector3D, length:float): ...

    class QRayCasterHit(Shiboken.Object):
        TriangleHit              : Qt3DRender.QRayCasterHit = ... # 0x0
        LineHit                  : Qt3DRender.QRayCasterHit = ... # 0x1
        PointHit                 : Qt3DRender.QRayCasterHit = ... # 0x2
        EntityHit                : Qt3DRender.QRayCasterHit = ... # 0x3

        class HitType(object):
            TriangleHit              : Qt3DRender.QRayCasterHit.HitType = ... # 0x0
            LineHit                  : Qt3DRender.QRayCasterHit.HitType = ... # 0x1
            PointHit                 : Qt3DRender.QRayCasterHit.HitType = ... # 0x2
            EntityHit                : Qt3DRender.QRayCasterHit.HitType = ... # 0x3

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, other:PySide2.Qt3DRender.Qt3DRender.QRayCasterHit): ...
        @typing.overload
        def __init__(self, type:PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.HitType, id:PySide2.Qt3DCore.Qt3DCore.QNodeId, distance:float, localIntersect:PySide2.QtGui.QVector3D, worldIntersect:PySide2.QtGui.QVector3D, primitiveIndex:int, v1:int, v2:int, v3:int): ...

        def __copy__(self): ...
        def distance(self) -> float: ...
        def entity(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def entityId(self) -> PySide2.Qt3DCore.Qt3DCore.QNodeId: ...
        def localIntersection(self) -> PySide2.QtGui.QVector3D: ...
        def primitiveIndex(self) -> int: ...
        def type(self) -> PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.HitType: ...
        def vertex1Index(self) -> int: ...
        def vertex2Index(self) -> int: ...
        def vertex3Index(self) -> int: ...
        def worldIntersection(self) -> PySide2.QtGui.QVector3D: ...

    class QRenderAspect(PySide2.Qt3DCore.Qt3DCore.QAbstractAspect):
        Synchronous              : Qt3DRender.QRenderAspect = ... # 0x0
        Threaded                 : Qt3DRender.QRenderAspect = ... # 0x1

        class RenderType(object):
            Synchronous              : Qt3DRender.QRenderAspect.RenderType = ... # 0x0
            Threaded                 : Qt3DRender.QRenderAspect.RenderType = ... # 0x1

        @typing.overload
        def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
        @typing.overload
        def __init__(self, type:PySide2.Qt3DRender.Qt3DRender.QRenderAspect.RenderType, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...


    class QRenderCapture(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        @typing.overload
        def requestCapture(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderCaptureReply: ...
        @typing.overload
        def requestCapture(self, captureId:int) -> PySide2.Qt3DRender.Qt3DRender.QRenderCaptureReply: ...
        @typing.overload
        def requestCapture(self, rect:PySide2.QtCore.QRect) -> PySide2.Qt3DRender.Qt3DRender.QRenderCaptureReply: ...

    class QRenderCaptureReply(PySide2.QtCore.QObject):
        def captureId(self) -> int: ...
        def image(self) -> PySide2.QtGui.QImage: ...
        def isComplete(self) -> bool: ...
        def saveImage(self, fileName:str) -> bool: ...
        def saveToFile(self, fileName:str): ...

    class QRenderPass(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addFilterKey(self, filterKey:PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def addParameter(self, p:PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def addRenderState(self, state:PySide2.Qt3DRender.Qt3DRender.QRenderState): ...
        def filterKeys(self) -> typing.List: ...
        def parameters(self) -> typing.List: ...
        def removeFilterKey(self, filterKey:PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def removeParameter(self, p:PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def removeRenderState(self, state:PySide2.Qt3DRender.Qt3DRender.QRenderState): ...
        def renderStates(self) -> typing.List: ...
        def setShaderProgram(self, shaderProgram:PySide2.Qt3DRender.Qt3DRender.QShaderProgram): ...
        def shaderProgram(self) -> PySide2.Qt3DRender.Qt3DRender.QShaderProgram: ...

    class QRenderPassFilter(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addMatch(self, filterKey:PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def addParameter(self, parameter:PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def matchAny(self) -> typing.List: ...
        def parameters(self) -> typing.List: ...
        def removeMatch(self, filterKey:PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def removeParameter(self, parameter:PySide2.Qt3DRender.Qt3DRender.QParameter): ...

    class QRenderSettings(PySide2.Qt3DCore.Qt3DCore.QComponent):
        OnDemand                 : Qt3DRender.QRenderSettings = ... # 0x0
        Always                   : Qt3DRender.QRenderSettings = ... # 0x1

        class RenderPolicy(object):
            OnDemand                 : Qt3DRender.QRenderSettings.RenderPolicy = ... # 0x0
            Always                   : Qt3DRender.QRenderSettings.RenderPolicy = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def activeFrameGraph(self) -> PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode: ...
        def pickingSettings(self) -> PySide2.Qt3DRender.Qt3DRender.QPickingSettings: ...
        def renderPolicy(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderSettings.RenderPolicy: ...
        def setActiveFrameGraph(self, activeFrameGraph:PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode): ...
        def setRenderPolicy(self, renderPolicy:PySide2.Qt3DRender.Qt3DRender.QRenderSettings.RenderPolicy): ...

    class QRenderState(PySide2.Qt3DCore.Qt3DCore.QNode): ...

    class QRenderStateSet(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addRenderState(self, state:PySide2.Qt3DRender.Qt3DRender.QRenderState): ...
        def removeRenderState(self, state:PySide2.Qt3DRender.Qt3DRender.QRenderState): ...
        def renderStates(self) -> typing.List: ...

    class QRenderSurfaceSelector(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def externalRenderTargetSize(self) -> PySide2.QtCore.QSize: ...
        def setExternalRenderTargetSize(self, size:PySide2.QtCore.QSize): ...
        def setSurface(self, surfaceObject:PySide2.QtCore.QObject): ...
        def setSurfacePixelRatio(self, ratio:float): ...
        def surface(self) -> PySide2.QtCore.QObject: ...
        def surfacePixelRatio(self) -> float: ...

    class QRenderTarget(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addOutput(self, output:PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput): ...
        def outputs(self) -> typing.List: ...
        def removeOutput(self, output:PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput): ...

    class QRenderTargetOutput(PySide2.Qt3DCore.Qt3DCore.QNode):
        Color0                   : Qt3DRender.QRenderTargetOutput = ... # 0x0
        Color1                   : Qt3DRender.QRenderTargetOutput = ... # 0x1
        Color2                   : Qt3DRender.QRenderTargetOutput = ... # 0x2
        Color3                   : Qt3DRender.QRenderTargetOutput = ... # 0x3
        Color4                   : Qt3DRender.QRenderTargetOutput = ... # 0x4
        Color5                   : Qt3DRender.QRenderTargetOutput = ... # 0x5
        Color6                   : Qt3DRender.QRenderTargetOutput = ... # 0x6
        Color7                   : Qt3DRender.QRenderTargetOutput = ... # 0x7
        Color8                   : Qt3DRender.QRenderTargetOutput = ... # 0x8
        Color9                   : Qt3DRender.QRenderTargetOutput = ... # 0x9
        Color10                  : Qt3DRender.QRenderTargetOutput = ... # 0xa
        Color11                  : Qt3DRender.QRenderTargetOutput = ... # 0xb
        Color12                  : Qt3DRender.QRenderTargetOutput = ... # 0xc
        Color13                  : Qt3DRender.QRenderTargetOutput = ... # 0xd
        Color14                  : Qt3DRender.QRenderTargetOutput = ... # 0xe
        Color15                  : Qt3DRender.QRenderTargetOutput = ... # 0xf
        Depth                    : Qt3DRender.QRenderTargetOutput = ... # 0x10
        Stencil                  : Qt3DRender.QRenderTargetOutput = ... # 0x11
        DepthStencil             : Qt3DRender.QRenderTargetOutput = ... # 0x12

        class AttachmentPoint(object):
            Color0                   : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x0
            Color1                   : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x1
            Color2                   : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x2
            Color3                   : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x3
            Color4                   : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x4
            Color5                   : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x5
            Color6                   : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x6
            Color7                   : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x7
            Color8                   : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x8
            Color9                   : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x9
            Color10                  : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0xa
            Color11                  : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0xb
            Color12                  : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0xc
            Color13                  : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0xd
            Color14                  : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0xe
            Color15                  : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0xf
            Depth                    : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x10
            Stencil                  : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x11
            DepthStencil             : Qt3DRender.QRenderTargetOutput.AttachmentPoint = ... # 0x12

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def attachmentPoint(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        def face(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace: ...
        def layer(self) -> int: ...
        def mipLevel(self) -> int: ...
        def setAttachmentPoint(self, attachmentPoint:PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint): ...
        def setFace(self, face:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace): ...
        def setLayer(self, layer:int): ...
        def setMipLevel(self, level:int): ...
        def setTexture(self, texture:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture): ...
        def texture(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...

    class QRenderTargetSelector(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def outputs(self) -> typing.List: ...
        def setOutputs(self, buffers:typing.List): ...
        def setTarget(self, target:PySide2.Qt3DRender.Qt3DRender.QRenderTarget): ...
        def target(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTarget: ...

    class QSceneLoader(PySide2.Qt3DCore.Qt3DCore.QComponent):
        None_                    : Qt3DRender.QSceneLoader = ... # 0x0
        UnknownComponent         : Qt3DRender.QSceneLoader = ... # 0x0
        GeometryRendererComponent: Qt3DRender.QSceneLoader = ... # 0x1
        Loading                  : Qt3DRender.QSceneLoader = ... # 0x1
        Ready                    : Qt3DRender.QSceneLoader = ... # 0x2
        TransformComponent       : Qt3DRender.QSceneLoader = ... # 0x2
        Error                    : Qt3DRender.QSceneLoader = ... # 0x3
        MaterialComponent        : Qt3DRender.QSceneLoader = ... # 0x3
        LightComponent           : Qt3DRender.QSceneLoader = ... # 0x4
        CameraLensComponent      : Qt3DRender.QSceneLoader = ... # 0x5

        class ComponentType(object):
            UnknownComponent         : Qt3DRender.QSceneLoader.ComponentType = ... # 0x0
            GeometryRendererComponent: Qt3DRender.QSceneLoader.ComponentType = ... # 0x1
            TransformComponent       : Qt3DRender.QSceneLoader.ComponentType = ... # 0x2
            MaterialComponent        : Qt3DRender.QSceneLoader.ComponentType = ... # 0x3
            LightComponent           : Qt3DRender.QSceneLoader.ComponentType = ... # 0x4
            CameraLensComponent      : Qt3DRender.QSceneLoader.ComponentType = ... # 0x5

        class Status(object):
            None_                    : Qt3DRender.QSceneLoader.Status = ... # 0x0
            Loading                  : Qt3DRender.QSceneLoader.Status = ... # 0x1
            Ready                    : Qt3DRender.QSceneLoader.Status = ... # 0x2
            Error                    : Qt3DRender.QSceneLoader.Status = ... # 0x3

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def component(self, entityName:str, componentType:PySide2.Qt3DRender.Qt3DRender.QSceneLoader.ComponentType) -> PySide2.Qt3DCore.Qt3DCore.QComponent: ...
        def entity(self, entityName:str) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def entityNames(self) -> typing.List: ...
        def setSource(self, arg:PySide2.QtCore.QUrl): ...
        def setStatus(self, status:PySide2.Qt3DRender.Qt3DRender.QSceneLoader.Status): ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> PySide2.Qt3DRender.Qt3DRender.QSceneLoader.Status: ...

    class QScissorTest(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def bottom(self) -> int: ...
        def height(self) -> int: ...
        def left(self) -> int: ...
        def setBottom(self, bottom:int): ...
        def setHeight(self, height:int): ...
        def setLeft(self, left:int): ...
        def setWidth(self, width:int): ...
        def width(self) -> int: ...

    class QScreenRayCaster(PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def position(self) -> PySide2.QtCore.QPoint: ...
        def setPosition(self, position:PySide2.QtCore.QPoint): ...
        @typing.overload
        def trigger(self): ...
        @typing.overload
        def trigger(self, position:PySide2.QtCore.QPoint): ...

    class QSeamlessCubemap(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QSetFence(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):
        NoHandle                 : Qt3DRender.QSetFence = ... # 0x0
        OpenGLFenceId            : Qt3DRender.QSetFence = ... # 0x1

        class HandleType(object):
            NoHandle                 : Qt3DRender.QSetFence.HandleType = ... # 0x0
            OpenGLFenceId            : Qt3DRender.QSetFence.HandleType = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def handle(self) -> typing.Any: ...
        def handleType(self) -> PySide2.Qt3DRender.Qt3DRender.QSetFence.HandleType: ...

    class QShaderData(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def event(self, event:PySide2.QtCore.QEvent) -> bool: ...

    class QShaderImage(PySide2.Qt3DCore.Qt3DCore.QNode):
        NoFormat                 : Qt3DRender.QShaderImage = ... # 0x0
        ReadOnly                 : Qt3DRender.QShaderImage = ... # 0x0
        Automatic                : Qt3DRender.QShaderImage = ... # 0x1
        WriteOnly                : Qt3DRender.QShaderImage = ... # 0x1
        ReadWrite                : Qt3DRender.QShaderImage = ... # 0x2
        RGBA8_UNorm              : Qt3DRender.QShaderImage = ... # 0x8058
        RGB10A2                  : Qt3DRender.QShaderImage = ... # 0x8059
        RGBA16_UNorm             : Qt3DRender.QShaderImage = ... # 0x805b
        R8_UNorm                 : Qt3DRender.QShaderImage = ... # 0x8229
        R16_UNorm                : Qt3DRender.QShaderImage = ... # 0x822a
        RG8_UNorm                : Qt3DRender.QShaderImage = ... # 0x822b
        RG16_UNorm               : Qt3DRender.QShaderImage = ... # 0x822c
        R16F                     : Qt3DRender.QShaderImage = ... # 0x822d
        R32F                     : Qt3DRender.QShaderImage = ... # 0x822e
        RG16F                    : Qt3DRender.QShaderImage = ... # 0x822f
        RG32F                    : Qt3DRender.QShaderImage = ... # 0x8230
        R8I                      : Qt3DRender.QShaderImage = ... # 0x8231
        R8U                      : Qt3DRender.QShaderImage = ... # 0x8232
        R16I                     : Qt3DRender.QShaderImage = ... # 0x8233
        R16U                     : Qt3DRender.QShaderImage = ... # 0x8234
        R32I                     : Qt3DRender.QShaderImage = ... # 0x8235
        R32U                     : Qt3DRender.QShaderImage = ... # 0x8236
        RG8I                     : Qt3DRender.QShaderImage = ... # 0x8237
        RG8U                     : Qt3DRender.QShaderImage = ... # 0x8238
        RG16I                    : Qt3DRender.QShaderImage = ... # 0x8239
        RG16U                    : Qt3DRender.QShaderImage = ... # 0x823a
        RG32I                    : Qt3DRender.QShaderImage = ... # 0x823b
        RG32U                    : Qt3DRender.QShaderImage = ... # 0x823c
        RGBA32F                  : Qt3DRender.QShaderImage = ... # 0x8814
        RGBA16F                  : Qt3DRender.QShaderImage = ... # 0x881a
        RG11B10F                 : Qt3DRender.QShaderImage = ... # 0x8c3a
        RGBA32U                  : Qt3DRender.QShaderImage = ... # 0x8d70
        RGBA16U                  : Qt3DRender.QShaderImage = ... # 0x8d76
        RGBA8U                   : Qt3DRender.QShaderImage = ... # 0x8d7c
        RGBA32I                  : Qt3DRender.QShaderImage = ... # 0x8d82
        RGBA16I                  : Qt3DRender.QShaderImage = ... # 0x8d88
        RGBA8I                   : Qt3DRender.QShaderImage = ... # 0x8d8e
        R8_SNorm                 : Qt3DRender.QShaderImage = ... # 0x8f94
        RG8_SNorm                : Qt3DRender.QShaderImage = ... # 0x8f95
        RGBA8_SNorm              : Qt3DRender.QShaderImage = ... # 0x8f97
        R16_SNorm                : Qt3DRender.QShaderImage = ... # 0x8f98
        RG16_SNorm               : Qt3DRender.QShaderImage = ... # 0x8f99
        RGBA16_SNorm             : Qt3DRender.QShaderImage = ... # 0x8f9b
        RGB10A2U                 : Qt3DRender.QShaderImage = ... # 0x906f

        class Access(object):
            ReadOnly                 : Qt3DRender.QShaderImage.Access = ... # 0x0
            WriteOnly                : Qt3DRender.QShaderImage.Access = ... # 0x1
            ReadWrite                : Qt3DRender.QShaderImage.Access = ... # 0x2

        class ImageFormat(object):
            NoFormat                 : Qt3DRender.QShaderImage.ImageFormat = ... # 0x0
            Automatic                : Qt3DRender.QShaderImage.ImageFormat = ... # 0x1
            RGBA8_UNorm              : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8058
            RGB10A2                  : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8059
            RGBA16_UNorm             : Qt3DRender.QShaderImage.ImageFormat = ... # 0x805b
            R8_UNorm                 : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8229
            R16_UNorm                : Qt3DRender.QShaderImage.ImageFormat = ... # 0x822a
            RG8_UNorm                : Qt3DRender.QShaderImage.ImageFormat = ... # 0x822b
            RG16_UNorm               : Qt3DRender.QShaderImage.ImageFormat = ... # 0x822c
            R16F                     : Qt3DRender.QShaderImage.ImageFormat = ... # 0x822d
            R32F                     : Qt3DRender.QShaderImage.ImageFormat = ... # 0x822e
            RG16F                    : Qt3DRender.QShaderImage.ImageFormat = ... # 0x822f
            RG32F                    : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8230
            R8I                      : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8231
            R8U                      : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8232
            R16I                     : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8233
            R16U                     : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8234
            R32I                     : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8235
            R32U                     : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8236
            RG8I                     : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8237
            RG8U                     : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8238
            RG16I                    : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8239
            RG16U                    : Qt3DRender.QShaderImage.ImageFormat = ... # 0x823a
            RG32I                    : Qt3DRender.QShaderImage.ImageFormat = ... # 0x823b
            RG32U                    : Qt3DRender.QShaderImage.ImageFormat = ... # 0x823c
            RGBA32F                  : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8814
            RGBA16F                  : Qt3DRender.QShaderImage.ImageFormat = ... # 0x881a
            RG11B10F                 : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8c3a
            RGBA32U                  : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8d70
            RGBA16U                  : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8d76
            RGBA8U                   : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8d7c
            RGBA32I                  : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8d82
            RGBA16I                  : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8d88
            RGBA8I                   : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8d8e
            R8_SNorm                 : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8f94
            RG8_SNorm                : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8f95
            RGBA8_SNorm              : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8f97
            R16_SNorm                : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8f98
            RG16_SNorm               : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8f99
            RGBA16_SNorm             : Qt3DRender.QShaderImage.ImageFormat = ... # 0x8f9b
            RGB10A2U                 : Qt3DRender.QShaderImage.ImageFormat = ... # 0x906f

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def access(self) -> PySide2.Qt3DRender.Qt3DRender.QShaderImage.Access: ...
        def format(self) -> PySide2.Qt3DRender.Qt3DRender.QShaderImage.ImageFormat: ...
        def layer(self) -> int: ...
        def layered(self) -> bool: ...
        def mipLevel(self) -> int: ...
        def setAccess(self, access:PySide2.Qt3DRender.Qt3DRender.QShaderImage.Access): ...
        def setFormat(self, format:PySide2.Qt3DRender.Qt3DRender.QShaderImage.ImageFormat): ...
        def setLayer(self, layer:int): ...
        def setLayered(self, layered:bool): ...
        def setMipLevel(self, mipLevel:int): ...
        def setTexture(self, texture:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture): ...
        def texture(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...

    class QShaderProgram(PySide2.Qt3DCore.Qt3DCore.QNode):
        NotReady                 : Qt3DRender.QShaderProgram = ... # 0x0
        Vertex                   : Qt3DRender.QShaderProgram = ... # 0x0
        Fragment                 : Qt3DRender.QShaderProgram = ... # 0x1
        Ready                    : Qt3DRender.QShaderProgram = ... # 0x1
        Error                    : Qt3DRender.QShaderProgram = ... # 0x2
        TessellationControl      : Qt3DRender.QShaderProgram = ... # 0x2
        TessellationEvaluation   : Qt3DRender.QShaderProgram = ... # 0x3
        Geometry                 : Qt3DRender.QShaderProgram = ... # 0x4
        Compute                  : Qt3DRender.QShaderProgram = ... # 0x5

        class ShaderType(object):
            Vertex                   : Qt3DRender.QShaderProgram.ShaderType = ... # 0x0
            Fragment                 : Qt3DRender.QShaderProgram.ShaderType = ... # 0x1
            TessellationControl      : Qt3DRender.QShaderProgram.ShaderType = ... # 0x2
            TessellationEvaluation   : Qt3DRender.QShaderProgram.ShaderType = ... # 0x3
            Geometry                 : Qt3DRender.QShaderProgram.ShaderType = ... # 0x4
            Compute                  : Qt3DRender.QShaderProgram.ShaderType = ... # 0x5

        class Status(object):
            NotReady                 : Qt3DRender.QShaderProgram.Status = ... # 0x0
            Ready                    : Qt3DRender.QShaderProgram.Status = ... # 0x1
            Error                    : Qt3DRender.QShaderProgram.Status = ... # 0x2

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def computeShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def fragmentShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def geometryShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        @staticmethod
        def loadSource(sourceUrl:PySide2.QtCore.QUrl) -> PySide2.QtCore.QByteArray: ...
        def log(self) -> str: ...
        def setComputeShaderCode(self, computeShaderCode:PySide2.QtCore.QByteArray): ...
        def setFragmentShaderCode(self, fragmentShaderCode:PySide2.QtCore.QByteArray): ...
        def setGeometryShaderCode(self, geometryShaderCode:PySide2.QtCore.QByteArray): ...
        def setShaderCode(self, type:PySide2.Qt3DRender.Qt3DRender.QShaderProgram.ShaderType, shaderCode:PySide2.QtCore.QByteArray): ...
        def setTessellationControlShaderCode(self, tessellationControlShaderCode:PySide2.QtCore.QByteArray): ...
        def setTessellationEvaluationShaderCode(self, tessellationEvaluationShaderCode:PySide2.QtCore.QByteArray): ...
        def setVertexShaderCode(self, vertexShaderCode:PySide2.QtCore.QByteArray): ...
        def shaderCode(self, type:PySide2.Qt3DRender.Qt3DRender.QShaderProgram.ShaderType) -> PySide2.QtCore.QByteArray: ...
        def status(self) -> PySide2.Qt3DRender.Qt3DRender.QShaderProgram.Status: ...
        def tessellationControlShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def tessellationEvaluationShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def vertexShaderCode(self) -> PySide2.QtCore.QByteArray: ...

    class QShaderProgramBuilder(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def computeShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def computeShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def enabledLayers(self) -> typing.List: ...
        def fragmentShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def fragmentShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def geometryShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def geometryShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def setComputeShaderGraph(self, computeShaderGraph:PySide2.QtCore.QUrl): ...
        def setEnabledLayers(self, layers:typing.Sequence): ...
        def setFragmentShaderGraph(self, fragmentShaderGraph:PySide2.QtCore.QUrl): ...
        def setGeometryShaderGraph(self, geometryShaderGraph:PySide2.QtCore.QUrl): ...
        def setShaderProgram(self, program:PySide2.Qt3DRender.Qt3DRender.QShaderProgram): ...
        def setTessellationControlShaderGraph(self, tessellationControlShaderGraph:PySide2.QtCore.QUrl): ...
        def setTessellationEvaluationShaderGraph(self, tessellationEvaluationShaderGraph:PySide2.QtCore.QUrl): ...
        def setVertexShaderGraph(self, vertexShaderGraph:PySide2.QtCore.QUrl): ...
        def shaderProgram(self) -> PySide2.Qt3DRender.Qt3DRender.QShaderProgram: ...
        def tessellationControlShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def tessellationControlShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def tessellationEvaluationShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def tessellationEvaluationShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def vertexShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def vertexShaderGraph(self) -> PySide2.QtCore.QUrl: ...

    class QSharedGLTexture(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def setTextureId(self, id:int): ...
        def textureId(self) -> int: ...

    class QSortPolicy(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):
        StateChangeCost          : Qt3DRender.QSortPolicy = ... # 0x1
        BackToFront              : Qt3DRender.QSortPolicy = ... # 0x2
        Material                 : Qt3DRender.QSortPolicy = ... # 0x4
        FrontToBack              : Qt3DRender.QSortPolicy = ... # 0x8
        Texture                  : Qt3DRender.QSortPolicy = ... # 0x10

        class SortType(object):
            StateChangeCost          : Qt3DRender.QSortPolicy.SortType = ... # 0x1
            BackToFront              : Qt3DRender.QSortPolicy.SortType = ... # 0x2
            Material                 : Qt3DRender.QSortPolicy.SortType = ... # 0x4
            FrontToBack              : Qt3DRender.QSortPolicy.SortType = ... # 0x8
            Texture                  : Qt3DRender.QSortPolicy.SortType = ... # 0x10

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        @typing.overload
        def setSortTypes(self, sortTypes:typing.List): ...
        @typing.overload
        def setSortTypes(self, sortTypesInt:typing.List): ...
        def sortTypes(self) -> typing.List: ...
        def sortTypesInt(self) -> typing.List: ...

    class QSpotLight(PySide2.Qt3DRender.Qt3DRender.QAbstractLight):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def constantAttenuation(self) -> float: ...
        def cutOffAngle(self) -> float: ...
        def linearAttenuation(self) -> float: ...
        def localDirection(self) -> PySide2.QtGui.QVector3D: ...
        def quadraticAttenuation(self) -> float: ...
        def setConstantAttenuation(self, value:float): ...
        def setCutOffAngle(self, cutOffAngle:float): ...
        def setLinearAttenuation(self, value:float): ...
        def setLocalDirection(self, localDirection:PySide2.QtGui.QVector3D): ...
        def setQuadraticAttenuation(self, value:float): ...

    class QStencilMask(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def backOutputMask(self) -> int: ...
        def frontOutputMask(self) -> int: ...
        def setBackOutputMask(self, backOutputMask:int): ...
        def setFrontOutputMask(self, frontOutputMask:int): ...

    class QStencilOperation(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def back(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments: ...
        def front(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments: ...

    class QStencilOperationArguments(PySide2.QtCore.QObject):
        Zero                     : Qt3DRender.QStencilOperationArguments = ... # 0x0
        Front                    : Qt3DRender.QStencilOperationArguments = ... # 0x404
        Back                     : Qt3DRender.QStencilOperationArguments = ... # 0x405
        FrontAndBack             : Qt3DRender.QStencilOperationArguments = ... # 0x408
        Invert                   : Qt3DRender.QStencilOperationArguments = ... # 0x150a
        Keep                     : Qt3DRender.QStencilOperationArguments = ... # 0x1e00
        Replace                  : Qt3DRender.QStencilOperationArguments = ... # 0x1e01
        Increment                : Qt3DRender.QStencilOperationArguments = ... # 0x1e02
        Decrement                : Qt3DRender.QStencilOperationArguments = ... # 0x1e03
        IncrementWrap            : Qt3DRender.QStencilOperationArguments = ... # 0x8507
        DecrementWrap            : Qt3DRender.QStencilOperationArguments = ... # 0x8508

        class FaceMode(object):
            Front                    : Qt3DRender.QStencilOperationArguments.FaceMode = ... # 0x404
            Back                     : Qt3DRender.QStencilOperationArguments.FaceMode = ... # 0x405
            FrontAndBack             : Qt3DRender.QStencilOperationArguments.FaceMode = ... # 0x408

        class Operation(object):
            Zero                     : Qt3DRender.QStencilOperationArguments.Operation = ... # 0x0
            Invert                   : Qt3DRender.QStencilOperationArguments.Operation = ... # 0x150a
            Keep                     : Qt3DRender.QStencilOperationArguments.Operation = ... # 0x1e00
            Replace                  : Qt3DRender.QStencilOperationArguments.Operation = ... # 0x1e01
            Increment                : Qt3DRender.QStencilOperationArguments.Operation = ... # 0x1e02
            Decrement                : Qt3DRender.QStencilOperationArguments.Operation = ... # 0x1e03
            IncrementWrap            : Qt3DRender.QStencilOperationArguments.Operation = ... # 0x8507
            DecrementWrap            : Qt3DRender.QStencilOperationArguments.Operation = ... # 0x8508
        def allTestsPassOperation(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation: ...
        def depthTestFailureOperation(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation: ...
        def faceMode(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.FaceMode: ...
        def setAllTestsPassOperation(self, operation:PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation): ...
        def setDepthTestFailureOperation(self, operation:PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation): ...
        def setStencilTestFailureOperation(self, operation:PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation): ...
        def stencilTestFailureOperation(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation: ...

    class QStencilTest(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def back(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments: ...
        def front(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments: ...

    class QStencilTestArguments(PySide2.QtCore.QObject):
        Never                    : Qt3DRender.QStencilTestArguments = ... # 0x200
        Less                     : Qt3DRender.QStencilTestArguments = ... # 0x201
        Equal                    : Qt3DRender.QStencilTestArguments = ... # 0x202
        LessOrEqual              : Qt3DRender.QStencilTestArguments = ... # 0x203
        Greater                  : Qt3DRender.QStencilTestArguments = ... # 0x204
        NotEqual                 : Qt3DRender.QStencilTestArguments = ... # 0x205
        GreaterOrEqual           : Qt3DRender.QStencilTestArguments = ... # 0x206
        Always                   : Qt3DRender.QStencilTestArguments = ... # 0x207
        Front                    : Qt3DRender.QStencilTestArguments = ... # 0x404
        Back                     : Qt3DRender.QStencilTestArguments = ... # 0x405
        FrontAndBack             : Qt3DRender.QStencilTestArguments = ... # 0x408

        class StencilFaceMode(object):
            Front                    : Qt3DRender.QStencilTestArguments.StencilFaceMode = ... # 0x404
            Back                     : Qt3DRender.QStencilTestArguments.StencilFaceMode = ... # 0x405
            FrontAndBack             : Qt3DRender.QStencilTestArguments.StencilFaceMode = ... # 0x408

        class StencilFunction(object):
            Never                    : Qt3DRender.QStencilTestArguments.StencilFunction = ... # 0x200
            Less                     : Qt3DRender.QStencilTestArguments.StencilFunction = ... # 0x201
            Equal                    : Qt3DRender.QStencilTestArguments.StencilFunction = ... # 0x202
            LessOrEqual              : Qt3DRender.QStencilTestArguments.StencilFunction = ... # 0x203
            Greater                  : Qt3DRender.QStencilTestArguments.StencilFunction = ... # 0x204
            NotEqual                 : Qt3DRender.QStencilTestArguments.StencilFunction = ... # 0x205
            GreaterOrEqual           : Qt3DRender.QStencilTestArguments.StencilFunction = ... # 0x206
            Always                   : Qt3DRender.QStencilTestArguments.StencilFunction = ... # 0x207
        def comparisonMask(self) -> int: ...
        def faceMode(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
        def referenceValue(self) -> int: ...
        def setComparisonMask(self, comparisonMask:int): ...
        def setReferenceValue(self, referenceValue:int): ...
        def setStencilFunction(self, stencilFunction:PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFunction): ...
        def stencilFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFunction: ...

    class QTechnique(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addFilterKey(self, filterKey:PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def addParameter(self, p:PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def addRenderPass(self, pass_:PySide2.Qt3DRender.Qt3DRender.QRenderPass): ...
        def filterKeys(self) -> typing.List: ...
        def graphicsApiFilter(self) -> PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter: ...
        def parameters(self) -> typing.List: ...
        def removeFilterKey(self, filterKey:PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def removeParameter(self, p:PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def removeRenderPass(self, pass_:PySide2.Qt3DRender.Qt3DRender.QRenderPass): ...
        def renderPasses(self) -> typing.List: ...

    class QTechniqueFilter(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def addMatch(self, filterKey:PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def addParameter(self, p:PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def matchAll(self) -> typing.List: ...
        def parameters(self) -> typing.List: ...
        def removeMatch(self, filterKey:PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def removeParameter(self, p:PySide2.Qt3DRender.Qt3DRender.QParameter): ...

    class QTexture1D(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTexture1DArray(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTexture2D(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTexture2DArray(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTexture2DMultisample(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTexture2DMultisampleArray(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTexture3D(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTextureBuffer(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTextureCubeMap(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTextureCubeMapArray(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTextureData(Shiboken.Object):

        def __init__(self): ...

        def comparisonFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction: ...
        def comparisonMode(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode: ...
        def depth(self) -> int: ...
        def format(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat: ...
        def height(self) -> int: ...
        def isAutoMipMapGenerationEnabled(self) -> bool: ...
        def layers(self) -> int: ...
        def magnificationFilter(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter: ...
        def maximumAnisotropy(self) -> float: ...
        def minificationFilter(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter: ...
        def setAutoMipMapGenerationEnabled(self, isAutoMipMapGenerationEnabled:bool): ...
        def setComparisonFunction(self, comparisonFunction:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction): ...
        def setComparisonMode(self, comparisonMode:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode): ...
        def setDepth(self, depth:int): ...
        def setFormat(self, arg__1:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat): ...
        def setHeight(self, height:int): ...
        def setLayers(self, layers:int): ...
        def setMagnificationFilter(self, filter:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter): ...
        def setMaximumAnisotropy(self, maximumAnisotropy:float): ...
        def setMinificationFilter(self, filter:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter): ...
        def setTarget(self, target:PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target): ...
        def setWidth(self, width:int): ...
        def setWrapModeX(self, wrapModeX:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def setWrapModeY(self, wrapModeY:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def setWrapModeZ(self, wrapModeZ:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def target(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target: ...
        def width(self) -> int: ...
        def wrapModeX(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...
        def wrapModeY(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...
        def wrapModeZ(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...

    class QTextureGenerator(PySide2.Qt3DRender.Qt3DRender.QAbstractFunctor): ...

    class QTextureImage(PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage):
        None_                    : Qt3DRender.QTextureImage = ... # 0x0
        Loading                  : Qt3DRender.QTextureImage = ... # 0x1
        Ready                    : Qt3DRender.QTextureImage = ... # 0x2
        Error                    : Qt3DRender.QTextureImage = ... # 0x3

        class Status(object):
            None_                    : Qt3DRender.QTextureImage.Status = ... # 0x0
            Loading                  : Qt3DRender.QTextureImage.Status = ... # 0x1
            Ready                    : Qt3DRender.QTextureImage.Status = ... # 0x2
            Error                    : Qt3DRender.QTextureImage.Status = ... # 0x3

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def isMirrored(self) -> bool: ...
        def setMirrored(self, mirrored:bool): ...
        def setSource(self, source:PySide2.QtCore.QUrl): ...
        def setStatus(self, status:PySide2.Qt3DRender.Qt3DRender.QTextureImage.Status): ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureImage.Status: ...

    class QTextureImageData(Shiboken.Object):

        def __init__(self): ...

        def cleanup(self): ...
        def data(self, layer:int=..., face:int=..., mipmapLevel:int=...) -> PySide2.QtCore.QByteArray: ...
        def depth(self) -> int: ...
        def faces(self) -> int: ...
        def format(self) -> PySide2.QtGui.QOpenGLTexture.TextureFormat: ...
        def height(self) -> int: ...
        def isCompressed(self) -> bool: ...
        def layers(self) -> int: ...
        def mipLevels(self) -> int: ...
        def pixelFormat(self) -> PySide2.QtGui.QOpenGLTexture.PixelFormat: ...
        def pixelType(self) -> PySide2.QtGui.QOpenGLTexture.PixelType: ...
        def setData(self, data:PySide2.QtCore.QByteArray, blockSize:int, isCompressed:bool=...): ...
        def setDepth(self, depth:int): ...
        def setFaces(self, faces:int): ...
        def setFormat(self, format:PySide2.QtGui.QOpenGLTexture.TextureFormat): ...
        def setHeight(self, height:int): ...
        def setImage(self, arg__1:PySide2.QtGui.QImage): ...
        def setLayers(self, layers:int): ...
        def setMipLevels(self, mipLevels:int): ...
        def setPixelFormat(self, pixelFormat:PySide2.QtGui.QOpenGLTexture.PixelFormat): ...
        def setPixelType(self, pixelType:PySide2.QtGui.QOpenGLTexture.PixelType): ...
        def setTarget(self, target:PySide2.QtGui.QOpenGLTexture.Target): ...
        def setWidth(self, width:int): ...
        def target(self) -> PySide2.QtGui.QOpenGLTexture.Target: ...
        def width(self) -> int: ...

    class QTextureImageDataGenerator(PySide2.Qt3DRender.Qt3DRender.QAbstractFunctor): ...

    class QTextureLoader(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def isMirrored(self) -> bool: ...
        def setMirrored(self, mirrored:bool): ...
        def setSource(self, source:PySide2.QtCore.QUrl): ...
        def source(self) -> PySide2.QtCore.QUrl: ...

    class QTextureRectangle(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...


    class QTextureWrapMode(PySide2.QtCore.QObject):
        Repeat                   : Qt3DRender.QTextureWrapMode = ... # 0x2901
        ClampToBorder            : Qt3DRender.QTextureWrapMode = ... # 0x812d
        ClampToEdge              : Qt3DRender.QTextureWrapMode = ... # 0x812f
        MirroredRepeat           : Qt3DRender.QTextureWrapMode = ... # 0x8370

        class WrapMode(object):
            Repeat                   : Qt3DRender.QTextureWrapMode.WrapMode = ... # 0x2901
            ClampToBorder            : Qt3DRender.QTextureWrapMode.WrapMode = ... # 0x812d
            ClampToEdge              : Qt3DRender.QTextureWrapMode.WrapMode = ... # 0x812f
            MirroredRepeat           : Qt3DRender.QTextureWrapMode.WrapMode = ... # 0x8370

        @typing.overload
        def __init__(self, wrapMode:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode=..., parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
        @typing.overload
        def __init__(self, x:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode, y:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode, z:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

        def setX(self, x:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def setY(self, y:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def setZ(self, z:PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def x(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...
        def y(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...
        def z(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...

    class QViewport(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def gamma(self) -> float: ...
        def normalizedRect(self) -> PySide2.QtCore.QRectF: ...
        def setGamma(self, gamma:float): ...
        def setNormalizedRect(self, normalizedRect:PySide2.QtCore.QRectF): ...

    class QWaitFence(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):
        NoHandle                 : Qt3DRender.QWaitFence = ... # 0x0
        OpenGLFenceId            : Qt3DRender.QWaitFence = ... # 0x1

        class HandleType(object):
            NoHandle                 : Qt3DRender.QWaitFence.HandleType = ... # 0x0
            OpenGLFenceId            : Qt3DRender.QWaitFence.HandleType = ... # 0x1

        def __init__(self, parent:typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode]=...): ...

        def handle(self) -> typing.Any: ...
        def handleType(self) -> PySide2.Qt3DRender.Qt3DRender.QWaitFence.HandleType: ...
        def setHandle(self, handle:typing.Any): ...
        def setHandleType(self, type:PySide2.Qt3DRender.Qt3DRender.QWaitFence.HandleType): ...
        def setTimeout(self, timeout:int): ...
        def setWaitOnCPU(self, waitOnCPU:bool): ...
        def timeout(self) -> int: ...
        def waitOnCPU(self) -> bool: ...

# eof
