# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2019 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtLocation, except for defaults which are replaced by "...".
"""

# Module PySide2.QtLocation
import PySide2
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtCore
import PySide2.QtPositioning
import PySide2.QtLocation


class QGeoCodeReply(PySide2.QtCore.QObject):
    NoError                  : QGeoCodeReply = ... # 0x0
    EngineNotSetError        : QGeoCodeReply = ... # 0x1
    CommunicationError       : QGeoCodeReply = ... # 0x2
    ParseError               : QGeoCodeReply = ... # 0x3
    UnsupportedOptionError   : QGeoCodeReply = ... # 0x4
    CombinationError         : QGeoCodeReply = ... # 0x5
    UnknownError             : QGeoCodeReply = ... # 0x6

    class Error(object):
        NoError                  : QGeoCodeReply.Error = ... # 0x0
        EngineNotSetError        : QGeoCodeReply.Error = ... # 0x1
        CommunicationError       : QGeoCodeReply.Error = ... # 0x2
        ParseError               : QGeoCodeReply.Error = ... # 0x3
        UnsupportedOptionError   : QGeoCodeReply.Error = ... # 0x4
        CombinationError         : QGeoCodeReply.Error = ... # 0x5
        UnknownError             : QGeoCodeReply.Error = ... # 0x6

    @typing.overload
    def __init__(self, error:PySide2.QtLocation.QGeoCodeReply.Error, errorString:str, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def abort(self): ...
    def addLocation(self, location:PySide2.QtPositioning.QGeoLocation): ...
    def error(self) -> PySide2.QtLocation.QGeoCodeReply.Error: ...
    def errorString(self) -> str: ...
    def isFinished(self) -> bool: ...
    def limit(self) -> int: ...
    def locations(self) -> typing.List: ...
    def offset(self) -> int: ...
    def setError(self, error:PySide2.QtLocation.QGeoCodeReply.Error, errorString:str): ...
    def setFinished(self, finished:bool): ...
    def setLimit(self, limit:int): ...
    def setLocations(self, locations:typing.Sequence): ...
    def setOffset(self, offset:int): ...
    def setViewport(self, viewport:PySide2.QtPositioning.QGeoShape): ...
    def viewport(self) -> PySide2.QtPositioning.QGeoShape: ...


class QGeoCodingManager(PySide2.QtCore.QObject):
    @typing.overload
    def geocode(self, address:PySide2.QtPositioning.QGeoAddress, bounds:PySide2.QtPositioning.QGeoShape=...) -> PySide2.QtLocation.QGeoCodeReply: ...
    @typing.overload
    def geocode(self, searchString:str, limit:int=..., offset:int=..., bounds:PySide2.QtPositioning.QGeoShape=...) -> PySide2.QtLocation.QGeoCodeReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def reverseGeocode(self, coordinate:PySide2.QtPositioning.QGeoCoordinate, bounds:PySide2.QtPositioning.QGeoShape=...) -> PySide2.QtLocation.QGeoCodeReply: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale): ...


class QGeoCodingManagerEngine(PySide2.QtCore.QObject):

    def __init__(self, parameters:typing.Dict, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    @typing.overload
    def geocode(self, address:PySide2.QtPositioning.QGeoAddress, bounds:PySide2.QtPositioning.QGeoShape) -> PySide2.QtLocation.QGeoCodeReply: ...
    @typing.overload
    def geocode(self, address:str, limit:int, offset:int, bounds:PySide2.QtPositioning.QGeoShape) -> PySide2.QtLocation.QGeoCodeReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def reverseGeocode(self, coordinate:PySide2.QtPositioning.QGeoCoordinate, bounds:PySide2.QtPositioning.QGeoShape) -> PySide2.QtLocation.QGeoCodeReply: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale): ...


class QGeoManeuver(Shiboken.Object):
    NoDirection              : QGeoManeuver = ... # 0x0
    DirectionForward         : QGeoManeuver = ... # 0x1
    DirectionBearRight       : QGeoManeuver = ... # 0x2
    DirectionLightRight      : QGeoManeuver = ... # 0x3
    DirectionRight           : QGeoManeuver = ... # 0x4
    DirectionHardRight       : QGeoManeuver = ... # 0x5
    DirectionUTurnRight      : QGeoManeuver = ... # 0x6
    DirectionUTurnLeft       : QGeoManeuver = ... # 0x7
    DirectionHardLeft        : QGeoManeuver = ... # 0x8
    DirectionLeft            : QGeoManeuver = ... # 0x9
    DirectionLightLeft       : QGeoManeuver = ... # 0xa
    DirectionBearLeft        : QGeoManeuver = ... # 0xb

    class InstructionDirection(object):
        NoDirection              : QGeoManeuver.InstructionDirection = ... # 0x0
        DirectionForward         : QGeoManeuver.InstructionDirection = ... # 0x1
        DirectionBearRight       : QGeoManeuver.InstructionDirection = ... # 0x2
        DirectionLightRight      : QGeoManeuver.InstructionDirection = ... # 0x3
        DirectionRight           : QGeoManeuver.InstructionDirection = ... # 0x4
        DirectionHardRight       : QGeoManeuver.InstructionDirection = ... # 0x5
        DirectionUTurnRight      : QGeoManeuver.InstructionDirection = ... # 0x6
        DirectionUTurnLeft       : QGeoManeuver.InstructionDirection = ... # 0x7
        DirectionHardLeft        : QGeoManeuver.InstructionDirection = ... # 0x8
        DirectionLeft            : QGeoManeuver.InstructionDirection = ... # 0x9
        DirectionLightLeft       : QGeoManeuver.InstructionDirection = ... # 0xa
        DirectionBearLeft        : QGeoManeuver.InstructionDirection = ... # 0xb

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QGeoManeuver): ...

    def __copy__(self): ...
    def direction(self) -> PySide2.QtLocation.QGeoManeuver.InstructionDirection: ...
    def distanceToNextInstruction(self) -> float: ...
    def extendedAttributes(self) -> typing.Dict: ...
    def instructionText(self) -> str: ...
    def isValid(self) -> bool: ...
    def position(self) -> PySide2.QtPositioning.QGeoCoordinate: ...
    def setDirection(self, direction:PySide2.QtLocation.QGeoManeuver.InstructionDirection): ...
    def setDistanceToNextInstruction(self, distance:float): ...
    def setExtendedAttributes(self, extendedAttributes:typing.Dict): ...
    def setInstructionText(self, instructionText:str): ...
    def setPosition(self, position:PySide2.QtPositioning.QGeoCoordinate): ...
    def setTimeToNextInstruction(self, secs:int): ...
    def setWaypoint(self, coordinate:PySide2.QtPositioning.QGeoCoordinate): ...
    def timeToNextInstruction(self) -> int: ...
    def waypoint(self) -> PySide2.QtPositioning.QGeoCoordinate: ...


class QGeoRoute(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QGeoRoute): ...

    def __copy__(self): ...
    def bounds(self) -> PySide2.QtPositioning.QGeoRectangle: ...
    def distance(self) -> float: ...
    def extendedAttributes(self) -> typing.Dict: ...
    def firstRouteSegment(self) -> PySide2.QtLocation.QGeoRouteSegment: ...
    def path(self) -> typing.List: ...
    def request(self) -> PySide2.QtLocation.QGeoRouteRequest: ...
    def routeId(self) -> str: ...
    def setBounds(self, bounds:PySide2.QtPositioning.QGeoRectangle): ...
    def setDistance(self, distance:float): ...
    def setExtendedAttributes(self, extendedAttributes:typing.Dict): ...
    def setFirstRouteSegment(self, routeSegment:PySide2.QtLocation.QGeoRouteSegment): ...
    def setPath(self, path:typing.Sequence): ...
    def setRequest(self, request:PySide2.QtLocation.QGeoRouteRequest): ...
    def setRouteId(self, id:str): ...
    def setTravelMode(self, mode:PySide2.QtLocation.QGeoRouteRequest.TravelMode): ...
    def setTravelTime(self, secs:int): ...
    def travelMode(self) -> PySide2.QtLocation.QGeoRouteRequest.TravelMode: ...
    def travelTime(self) -> int: ...


class QGeoRouteReply(PySide2.QtCore.QObject):
    NoError                  : QGeoRouteReply = ... # 0x0
    EngineNotSetError        : QGeoRouteReply = ... # 0x1
    CommunicationError       : QGeoRouteReply = ... # 0x2
    ParseError               : QGeoRouteReply = ... # 0x3
    UnsupportedOptionError   : QGeoRouteReply = ... # 0x4
    UnknownError             : QGeoRouteReply = ... # 0x5

    class Error(object):
        NoError                  : QGeoRouteReply.Error = ... # 0x0
        EngineNotSetError        : QGeoRouteReply.Error = ... # 0x1
        CommunicationError       : QGeoRouteReply.Error = ... # 0x2
        ParseError               : QGeoRouteReply.Error = ... # 0x3
        UnsupportedOptionError   : QGeoRouteReply.Error = ... # 0x4
        UnknownError             : QGeoRouteReply.Error = ... # 0x5

    @typing.overload
    def __init__(self, error:PySide2.QtLocation.QGeoRouteReply.Error, errorString:str, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, request:PySide2.QtLocation.QGeoRouteRequest, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def abort(self): ...
    def addRoutes(self, routes:typing.Sequence): ...
    def error(self) -> PySide2.QtLocation.QGeoRouteReply.Error: ...
    def errorString(self) -> str: ...
    def isFinished(self) -> bool: ...
    def request(self) -> PySide2.QtLocation.QGeoRouteRequest: ...
    def routes(self) -> typing.List: ...
    def setError(self, error:PySide2.QtLocation.QGeoRouteReply.Error, errorString:str): ...
    def setFinished(self, finished:bool): ...
    def setRoutes(self, routes:typing.Sequence): ...


class QGeoRouteRequest(Shiboken.Object):
    NeutralFeatureWeight     : QGeoRouteRequest = ... # 0x0
    NoFeature                : QGeoRouteRequest = ... # 0x0
    NoManeuvers              : QGeoRouteRequest = ... # 0x0
    NoSegmentData            : QGeoRouteRequest = ... # 0x0
    BasicManeuvers           : QGeoRouteRequest = ... # 0x1
    BasicSegmentData         : QGeoRouteRequest = ... # 0x1
    CarTravel                : QGeoRouteRequest = ... # 0x1
    PreferFeatureWeight      : QGeoRouteRequest = ... # 0x1
    ShortestRoute            : QGeoRouteRequest = ... # 0x1
    TollFeature              : QGeoRouteRequest = ... # 0x1
    FastestRoute             : QGeoRouteRequest = ... # 0x2
    HighwayFeature           : QGeoRouteRequest = ... # 0x2
    PedestrianTravel         : QGeoRouteRequest = ... # 0x2
    RequireFeatureWeight     : QGeoRouteRequest = ... # 0x2
    AvoidFeatureWeight       : QGeoRouteRequest = ... # 0x4
    BicycleTravel            : QGeoRouteRequest = ... # 0x4
    MostEconomicRoute        : QGeoRouteRequest = ... # 0x4
    PublicTransitFeature     : QGeoRouteRequest = ... # 0x4
    DisallowFeatureWeight    : QGeoRouteRequest = ... # 0x8
    FerryFeature             : QGeoRouteRequest = ... # 0x8
    MostScenicRoute          : QGeoRouteRequest = ... # 0x8
    PublicTransitTravel      : QGeoRouteRequest = ... # 0x8
    TruckTravel              : QGeoRouteRequest = ... # 0x10
    TunnelFeature            : QGeoRouteRequest = ... # 0x10
    DirtRoadFeature          : QGeoRouteRequest = ... # 0x20
    ParksFeature             : QGeoRouteRequest = ... # 0x40
    MotorPoolLaneFeature     : QGeoRouteRequest = ... # 0x80
    TrafficFeature           : QGeoRouteRequest = ... # 0x100

    class FeatureType(object):
        NoFeature                : QGeoRouteRequest.FeatureType = ... # 0x0
        TollFeature              : QGeoRouteRequest.FeatureType = ... # 0x1
        HighwayFeature           : QGeoRouteRequest.FeatureType = ... # 0x2
        PublicTransitFeature     : QGeoRouteRequest.FeatureType = ... # 0x4
        FerryFeature             : QGeoRouteRequest.FeatureType = ... # 0x8
        TunnelFeature            : QGeoRouteRequest.FeatureType = ... # 0x10
        DirtRoadFeature          : QGeoRouteRequest.FeatureType = ... # 0x20
        ParksFeature             : QGeoRouteRequest.FeatureType = ... # 0x40
        MotorPoolLaneFeature     : QGeoRouteRequest.FeatureType = ... # 0x80
        TrafficFeature           : QGeoRouteRequest.FeatureType = ... # 0x100

    class FeatureTypes(object): ...

    class FeatureWeight(object):
        NeutralFeatureWeight     : QGeoRouteRequest.FeatureWeight = ... # 0x0
        PreferFeatureWeight      : QGeoRouteRequest.FeatureWeight = ... # 0x1
        RequireFeatureWeight     : QGeoRouteRequest.FeatureWeight = ... # 0x2
        AvoidFeatureWeight       : QGeoRouteRequest.FeatureWeight = ... # 0x4
        DisallowFeatureWeight    : QGeoRouteRequest.FeatureWeight = ... # 0x8

    class FeatureWeights(object): ...

    class ManeuverDetail(object):
        NoManeuvers              : QGeoRouteRequest.ManeuverDetail = ... # 0x0
        BasicManeuvers           : QGeoRouteRequest.ManeuverDetail = ... # 0x1

    class ManeuverDetails(object): ...

    class RouteOptimization(object):
        ShortestRoute            : QGeoRouteRequest.RouteOptimization = ... # 0x1
        FastestRoute             : QGeoRouteRequest.RouteOptimization = ... # 0x2
        MostEconomicRoute        : QGeoRouteRequest.RouteOptimization = ... # 0x4
        MostScenicRoute          : QGeoRouteRequest.RouteOptimization = ... # 0x8

    class RouteOptimizations(object): ...

    class SegmentDetail(object):
        NoSegmentData            : QGeoRouteRequest.SegmentDetail = ... # 0x0
        BasicSegmentData         : QGeoRouteRequest.SegmentDetail = ... # 0x1

    class SegmentDetails(object): ...

    class TravelMode(object):
        CarTravel                : QGeoRouteRequest.TravelMode = ... # 0x1
        PedestrianTravel         : QGeoRouteRequest.TravelMode = ... # 0x2
        BicycleTravel            : QGeoRouteRequest.TravelMode = ... # 0x4
        PublicTransitTravel      : QGeoRouteRequest.TravelMode = ... # 0x8
        TruckTravel              : QGeoRouteRequest.TravelMode = ... # 0x10

    class TravelModes(object): ...

    @typing.overload
    def __init__(self, origin:PySide2.QtPositioning.QGeoCoordinate, destination:PySide2.QtPositioning.QGeoCoordinate): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QGeoRouteRequest): ...
    @typing.overload
    def __init__(self, waypoints:typing.Sequence=...): ...

    def departureTime(self) -> PySide2.QtCore.QDateTime: ...
    def excludeAreas(self) -> typing.List: ...
    def extraParameters(self) -> typing.Dict: ...
    def featureTypes(self) -> typing.List: ...
    def featureWeight(self, featureType:PySide2.QtLocation.QGeoRouteRequest.FeatureType) -> PySide2.QtLocation.QGeoRouteRequest.FeatureWeight: ...
    def maneuverDetail(self) -> PySide2.QtLocation.QGeoRouteRequest.ManeuverDetail: ...
    def numberAlternativeRoutes(self) -> int: ...
    def routeOptimization(self) -> PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations: ...
    def segmentDetail(self) -> PySide2.QtLocation.QGeoRouteRequest.SegmentDetail: ...
    def setDepartureTime(self, departureTime:PySide2.QtCore.QDateTime): ...
    def setExcludeAreas(self, areas:typing.Sequence): ...
    def setExtraParameters(self, extraParameters:typing.Dict): ...
    def setFeatureWeight(self, featureType:PySide2.QtLocation.QGeoRouteRequest.FeatureType, featureWeight:PySide2.QtLocation.QGeoRouteRequest.FeatureWeight): ...
    def setManeuverDetail(self, maneuverDetail:PySide2.QtLocation.QGeoRouteRequest.ManeuverDetail): ...
    def setNumberAlternativeRoutes(self, alternatives:int): ...
    def setRouteOptimization(self, optimization:PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations): ...
    def setSegmentDetail(self, segmentDetail:PySide2.QtLocation.QGeoRouteRequest.SegmentDetail): ...
    def setTravelModes(self, travelModes:PySide2.QtLocation.QGeoRouteRequest.TravelModes): ...
    def setWaypoints(self, waypoints:typing.Sequence): ...
    def setWaypointsMetadata(self, waypointMetadata:typing.Sequence): ...
    def travelModes(self) -> PySide2.QtLocation.QGeoRouteRequest.TravelModes: ...
    def waypoints(self) -> typing.List: ...
    def waypointsMetadata(self) -> typing.List: ...


class QGeoRouteSegment(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QGeoRouteSegment): ...

    def __copy__(self): ...
    def distance(self) -> float: ...
    def isLegLastSegment(self) -> bool: ...
    def isValid(self) -> bool: ...
    def maneuver(self) -> PySide2.QtLocation.QGeoManeuver: ...
    def nextRouteSegment(self) -> PySide2.QtLocation.QGeoRouteSegment: ...
    def path(self) -> typing.List: ...
    def setDistance(self, distance:float): ...
    def setManeuver(self, maneuver:PySide2.QtLocation.QGeoManeuver): ...
    def setNextRouteSegment(self, routeSegment:PySide2.QtLocation.QGeoRouteSegment): ...
    def setPath(self, path:typing.Sequence): ...
    def setTravelTime(self, secs:int): ...
    def travelTime(self) -> int: ...


class QGeoRoutingManager(PySide2.QtCore.QObject):
    def calculateRoute(self, request:PySide2.QtLocation.QGeoRouteRequest) -> PySide2.QtLocation.QGeoRouteReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def measurementSystem(self) -> PySide2.QtCore.QLocale.MeasurementSystem: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale): ...
    def setMeasurementSystem(self, system:PySide2.QtCore.QLocale.MeasurementSystem): ...
    def supportedFeatureTypes(self) -> PySide2.QtLocation.QGeoRouteRequest.FeatureTypes: ...
    def supportedFeatureWeights(self) -> PySide2.QtLocation.QGeoRouteRequest.FeatureWeights: ...
    def supportedManeuverDetails(self) -> PySide2.QtLocation.QGeoRouteRequest.ManeuverDetails: ...
    def supportedRouteOptimizations(self) -> PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations: ...
    def supportedSegmentDetails(self) -> PySide2.QtLocation.QGeoRouteRequest.SegmentDetails: ...
    def supportedTravelModes(self) -> PySide2.QtLocation.QGeoRouteRequest.TravelModes: ...
    def updateRoute(self, route:PySide2.QtLocation.QGeoRoute, position:PySide2.QtPositioning.QGeoCoordinate) -> PySide2.QtLocation.QGeoRouteReply: ...


class QGeoRoutingManagerEngine(PySide2.QtCore.QObject):

    def __init__(self, parameters:typing.Dict, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def calculateRoute(self, request:PySide2.QtLocation.QGeoRouteRequest) -> PySide2.QtLocation.QGeoRouteReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def measurementSystem(self) -> PySide2.QtCore.QLocale.MeasurementSystem: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale): ...
    def setMeasurementSystem(self, system:PySide2.QtCore.QLocale.MeasurementSystem): ...
    def setSupportedFeatureTypes(self, featureTypes:PySide2.QtLocation.QGeoRouteRequest.FeatureTypes): ...
    def setSupportedFeatureWeights(self, featureWeights:PySide2.QtLocation.QGeoRouteRequest.FeatureWeights): ...
    def setSupportedManeuverDetails(self, maneuverDetails:PySide2.QtLocation.QGeoRouteRequest.ManeuverDetails): ...
    def setSupportedRouteOptimizations(self, optimizations:PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations): ...
    def setSupportedSegmentDetails(self, segmentDetails:PySide2.QtLocation.QGeoRouteRequest.SegmentDetails): ...
    def setSupportedTravelModes(self, travelModes:PySide2.QtLocation.QGeoRouteRequest.TravelModes): ...
    def supportedFeatureTypes(self) -> PySide2.QtLocation.QGeoRouteRequest.FeatureTypes: ...
    def supportedFeatureWeights(self) -> PySide2.QtLocation.QGeoRouteRequest.FeatureWeights: ...
    def supportedManeuverDetails(self) -> PySide2.QtLocation.QGeoRouteRequest.ManeuverDetails: ...
    def supportedRouteOptimizations(self) -> PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations: ...
    def supportedSegmentDetails(self) -> PySide2.QtLocation.QGeoRouteRequest.SegmentDetails: ...
    def supportedTravelModes(self) -> PySide2.QtLocation.QGeoRouteRequest.TravelModes: ...
    def updateRoute(self, route:PySide2.QtLocation.QGeoRoute, position:PySide2.QtPositioning.QGeoCoordinate) -> PySide2.QtLocation.QGeoRouteReply: ...


class QGeoServiceProvider(PySide2.QtCore.QObject):
    AnyGeocodingFeatures     : QGeoServiceProvider = ... # -0x1
    AnyMappingFeatures       : QGeoServiceProvider = ... # -0x1
    AnyNavigationFeatures    : QGeoServiceProvider = ... # -0x1
    AnyPlacesFeatures        : QGeoServiceProvider = ... # -0x1
    AnyRoutingFeatures       : QGeoServiceProvider = ... # -0x1
    NoError                  : QGeoServiceProvider = ... # 0x0
    NoGeocodingFeatures      : QGeoServiceProvider = ... # 0x0
    NoMappingFeatures        : QGeoServiceProvider = ... # 0x0
    NoNavigationFeatures     : QGeoServiceProvider = ... # 0x0
    NoPlacesFeatures         : QGeoServiceProvider = ... # 0x0
    NoRoutingFeatures        : QGeoServiceProvider = ... # 0x0
    NotSupportedError        : QGeoServiceProvider = ... # 0x1
    OnlineGeocodingFeature   : QGeoServiceProvider = ... # 0x1
    OnlineMappingFeature     : QGeoServiceProvider = ... # 0x1
    OnlineNavigationFeature  : QGeoServiceProvider = ... # 0x1
    OnlinePlacesFeature      : QGeoServiceProvider = ... # 0x1
    OnlineRoutingFeature     : QGeoServiceProvider = ... # 0x1
    OfflineGeocodingFeature  : QGeoServiceProvider = ... # 0x2
    OfflineMappingFeature    : QGeoServiceProvider = ... # 0x2
    OfflineNavigationFeature : QGeoServiceProvider = ... # 0x2
    OfflinePlacesFeature     : QGeoServiceProvider = ... # 0x2
    OfflineRoutingFeature    : QGeoServiceProvider = ... # 0x2
    UnknownParameterError    : QGeoServiceProvider = ... # 0x2
    MissingRequiredParameterError: QGeoServiceProvider = ... # 0x3
    ConnectionError          : QGeoServiceProvider = ... # 0x4
    LocalizedMappingFeature  : QGeoServiceProvider = ... # 0x4
    LocalizedRoutingFeature  : QGeoServiceProvider = ... # 0x4
    ReverseGeocodingFeature  : QGeoServiceProvider = ... # 0x4
    SavePlaceFeature         : QGeoServiceProvider = ... # 0x4
    LoaderError              : QGeoServiceProvider = ... # 0x5
    LocalizedGeocodingFeature: QGeoServiceProvider = ... # 0x8
    RemovePlaceFeature       : QGeoServiceProvider = ... # 0x8
    RouteUpdatesFeature      : QGeoServiceProvider = ... # 0x8
    AlternativeRoutesFeature : QGeoServiceProvider = ... # 0x10
    SaveCategoryFeature      : QGeoServiceProvider = ... # 0x10
    ExcludeAreasRoutingFeature: QGeoServiceProvider = ... # 0x20
    RemoveCategoryFeature    : QGeoServiceProvider = ... # 0x20
    PlaceRecommendationsFeature: QGeoServiceProvider = ... # 0x40
    SearchSuggestionsFeature : QGeoServiceProvider = ... # 0x80
    LocalizedPlacesFeature   : QGeoServiceProvider = ... # 0x100
    NotificationsFeature     : QGeoServiceProvider = ... # 0x200
    PlaceMatchingFeature     : QGeoServiceProvider = ... # 0x400

    class Error(object):
        NoError                  : QGeoServiceProvider.Error = ... # 0x0
        NotSupportedError        : QGeoServiceProvider.Error = ... # 0x1
        UnknownParameterError    : QGeoServiceProvider.Error = ... # 0x2
        MissingRequiredParameterError: QGeoServiceProvider.Error = ... # 0x3
        ConnectionError          : QGeoServiceProvider.Error = ... # 0x4
        LoaderError              : QGeoServiceProvider.Error = ... # 0x5

    class GeocodingFeature(object):
        AnyGeocodingFeatures     : QGeoServiceProvider.GeocodingFeature = ... # -0x1
        NoGeocodingFeatures      : QGeoServiceProvider.GeocodingFeature = ... # 0x0
        OnlineGeocodingFeature   : QGeoServiceProvider.GeocodingFeature = ... # 0x1
        OfflineGeocodingFeature  : QGeoServiceProvider.GeocodingFeature = ... # 0x2
        ReverseGeocodingFeature  : QGeoServiceProvider.GeocodingFeature = ... # 0x4
        LocalizedGeocodingFeature: QGeoServiceProvider.GeocodingFeature = ... # 0x8

    class GeocodingFeatures(object): ...

    class MappingFeature(object):
        AnyMappingFeatures       : QGeoServiceProvider.MappingFeature = ... # -0x1
        NoMappingFeatures        : QGeoServiceProvider.MappingFeature = ... # 0x0
        OnlineMappingFeature     : QGeoServiceProvider.MappingFeature = ... # 0x1
        OfflineMappingFeature    : QGeoServiceProvider.MappingFeature = ... # 0x2
        LocalizedMappingFeature  : QGeoServiceProvider.MappingFeature = ... # 0x4

    class MappingFeatures(object): ...

    class NavigationFeature(object):
        AnyNavigationFeatures    : QGeoServiceProvider.NavigationFeature = ... # -0x1
        NoNavigationFeatures     : QGeoServiceProvider.NavigationFeature = ... # 0x0
        OnlineNavigationFeature  : QGeoServiceProvider.NavigationFeature = ... # 0x1
        OfflineNavigationFeature : QGeoServiceProvider.NavigationFeature = ... # 0x2

    class NavigationFeatures(object): ...

    class PlacesFeature(object):
        AnyPlacesFeatures        : QGeoServiceProvider.PlacesFeature = ... # -0x1
        NoPlacesFeatures         : QGeoServiceProvider.PlacesFeature = ... # 0x0
        OnlinePlacesFeature      : QGeoServiceProvider.PlacesFeature = ... # 0x1
        OfflinePlacesFeature     : QGeoServiceProvider.PlacesFeature = ... # 0x2
        SavePlaceFeature         : QGeoServiceProvider.PlacesFeature = ... # 0x4
        RemovePlaceFeature       : QGeoServiceProvider.PlacesFeature = ... # 0x8
        SaveCategoryFeature      : QGeoServiceProvider.PlacesFeature = ... # 0x10
        RemoveCategoryFeature    : QGeoServiceProvider.PlacesFeature = ... # 0x20
        PlaceRecommendationsFeature: QGeoServiceProvider.PlacesFeature = ... # 0x40
        SearchSuggestionsFeature : QGeoServiceProvider.PlacesFeature = ... # 0x80
        LocalizedPlacesFeature   : QGeoServiceProvider.PlacesFeature = ... # 0x100
        NotificationsFeature     : QGeoServiceProvider.PlacesFeature = ... # 0x200
        PlaceMatchingFeature     : QGeoServiceProvider.PlacesFeature = ... # 0x400

    class PlacesFeatures(object): ...

    class RoutingFeature(object):
        AnyRoutingFeatures       : QGeoServiceProvider.RoutingFeature = ... # -0x1
        NoRoutingFeatures        : QGeoServiceProvider.RoutingFeature = ... # 0x0
        OnlineRoutingFeature     : QGeoServiceProvider.RoutingFeature = ... # 0x1
        OfflineRoutingFeature    : QGeoServiceProvider.RoutingFeature = ... # 0x2
        LocalizedRoutingFeature  : QGeoServiceProvider.RoutingFeature = ... # 0x4
        RouteUpdatesFeature      : QGeoServiceProvider.RoutingFeature = ... # 0x8
        AlternativeRoutesFeature : QGeoServiceProvider.RoutingFeature = ... # 0x10
        ExcludeAreasRoutingFeature: QGeoServiceProvider.RoutingFeature = ... # 0x20

    class RoutingFeatures(object): ...

    def __init__(self, providerName:str, parameters:typing.Dict=..., allowExperimental:bool=...): ...

    @staticmethod
    def availableServiceProviders() -> typing.List: ...
    def error(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def errorString(self) -> str: ...
    def geocodingError(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def geocodingErrorString(self) -> str: ...
    def geocodingFeatures(self) -> PySide2.QtLocation.QGeoServiceProvider.GeocodingFeatures: ...
    def geocodingManager(self) -> PySide2.QtLocation.QGeoCodingManager: ...
    def mappingError(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def mappingErrorString(self) -> str: ...
    def mappingFeatures(self) -> PySide2.QtLocation.QGeoServiceProvider.MappingFeatures: ...
    def navigationError(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def navigationErrorString(self) -> str: ...
    def navigationFeatures(self) -> PySide2.QtLocation.QGeoServiceProvider.NavigationFeatures: ...
    def placeManager(self) -> PySide2.QtLocation.QPlaceManager: ...
    def placesError(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def placesErrorString(self) -> str: ...
    def placesFeatures(self) -> PySide2.QtLocation.QGeoServiceProvider.PlacesFeatures: ...
    def routingError(self) -> PySide2.QtLocation.QGeoServiceProvider.Error: ...
    def routingErrorString(self) -> str: ...
    def routingFeatures(self) -> PySide2.QtLocation.QGeoServiceProvider.RoutingFeatures: ...
    def routingManager(self) -> PySide2.QtLocation.QGeoRoutingManager: ...
    def setAllowExperimental(self, allow:bool): ...
    def setLocale(self, locale:PySide2.QtCore.QLocale): ...
    def setParameters(self, parameters:typing.Dict): ...


class QGeoServiceProviderFactory(Shiboken.Object):

    def __init__(self): ...

    def createGeocodingManagerEngine(self, parameters:typing.Dict, error:PySide2.QtLocation.QGeoServiceProvider.Error) -> typing.Tuple: ...
    def createPlaceManagerEngine(self, parameters:typing.Dict, error:PySide2.QtLocation.QGeoServiceProvider.Error) -> typing.Tuple: ...
    def createRoutingManagerEngine(self, parameters:typing.Dict, error:PySide2.QtLocation.QGeoServiceProvider.Error) -> typing.Tuple: ...


class QGeoServiceProviderFactoryV2(PySide2.QtLocation.QGeoServiceProviderFactory):

    def __init__(self): ...


class QPlace(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlace): ...

    def __copy__(self): ...
    def appendContactDetail(self, contactType:str, detail:PySide2.QtLocation.QPlaceContactDetail): ...
    def attribution(self) -> str: ...
    def categories(self) -> typing.List: ...
    def contactDetails(self, contactType:str) -> typing.List: ...
    def contactTypes(self) -> typing.List: ...
    def content(self, type:PySide2.QtLocation.QPlaceContent.Type) -> typing.Dict: ...
    def detailsFetched(self) -> bool: ...
    def extendedAttribute(self, attributeType:str) -> PySide2.QtLocation.QPlaceAttribute: ...
    def extendedAttributeTypes(self) -> typing.List: ...
    def icon(self) -> PySide2.QtLocation.QPlaceIcon: ...
    def insertContent(self, type:PySide2.QtLocation.QPlaceContent.Type, content:typing.Dict): ...
    def isEmpty(self) -> bool: ...
    def location(self) -> PySide2.QtPositioning.QGeoLocation: ...
    def name(self) -> str: ...
    def placeId(self) -> str: ...
    def primaryEmail(self) -> str: ...
    def primaryFax(self) -> str: ...
    def primaryPhone(self) -> str: ...
    def primaryWebsite(self) -> PySide2.QtCore.QUrl: ...
    def ratings(self) -> PySide2.QtLocation.QPlaceRatings: ...
    def removeContactDetails(self, contactType:str): ...
    def removeExtendedAttribute(self, attributeType:str): ...
    def setAttribution(self, attribution:str): ...
    def setCategories(self, categories:typing.Sequence): ...
    def setCategory(self, category:PySide2.QtLocation.QPlaceCategory): ...
    def setContactDetails(self, contactType:str, details:typing.Sequence): ...
    def setContent(self, type:PySide2.QtLocation.QPlaceContent.Type, content:typing.Dict): ...
    def setDetailsFetched(self, fetched:bool): ...
    def setExtendedAttribute(self, attributeType:str, attribute:PySide2.QtLocation.QPlaceAttribute): ...
    def setIcon(self, icon:PySide2.QtLocation.QPlaceIcon): ...
    def setLocation(self, location:PySide2.QtPositioning.QGeoLocation): ...
    def setName(self, name:str): ...
    def setPlaceId(self, identifier:str): ...
    def setRatings(self, ratings:PySide2.QtLocation.QPlaceRatings): ...
    def setSupplier(self, supplier:PySide2.QtLocation.QPlaceSupplier): ...
    def setTotalContentCount(self, type:PySide2.QtLocation.QPlaceContent.Type, total:int): ...
    def supplier(self) -> PySide2.QtLocation.QPlaceSupplier: ...
    def totalContentCount(self, type:PySide2.QtLocation.QPlaceContent.Type) -> int: ...


class QPlaceAttribute(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceAttribute): ...

    def __copy__(self): ...
    def isEmpty(self) -> bool: ...
    def label(self) -> str: ...
    def setLabel(self, label:str): ...
    def setText(self, text:str): ...
    def text(self) -> str: ...


class QPlaceCategory(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceCategory): ...

    def __copy__(self): ...
    def categoryId(self) -> str: ...
    def icon(self) -> PySide2.QtLocation.QPlaceIcon: ...
    def isEmpty(self) -> bool: ...
    def name(self) -> str: ...
    def setCategoryId(self, identifier:str): ...
    def setIcon(self, icon:PySide2.QtLocation.QPlaceIcon): ...
    def setName(self, name:str): ...


class QPlaceContactDetail(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContactDetail): ...

    def __copy__(self): ...
    def clear(self): ...
    def label(self) -> str: ...
    def setLabel(self, label:str): ...
    def setValue(self, value:str): ...
    def value(self) -> str: ...


class QPlaceContent(Shiboken.Object):
    NoType                   : QPlaceContent = ... # 0x0
    ImageType                : QPlaceContent = ... # 0x1
    ReviewType               : QPlaceContent = ... # 0x2
    EditorialType            : QPlaceContent = ... # 0x3
    CustomType               : QPlaceContent = ... # 0x100

    class Type(object):
        NoType                   : QPlaceContent.Type = ... # 0x0
        ImageType                : QPlaceContent.Type = ... # 0x1
        ReviewType               : QPlaceContent.Type = ... # 0x2
        EditorialType            : QPlaceContent.Type = ... # 0x3
        CustomType               : QPlaceContent.Type = ... # 0x100

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContent): ...

    def __copy__(self): ...
    def attribution(self) -> str: ...
    def setAttribution(self, attribution:str): ...
    def setSupplier(self, supplier:PySide2.QtLocation.QPlaceSupplier): ...
    def setUser(self, user:PySide2.QtLocation.QPlaceUser): ...
    def supplier(self) -> PySide2.QtLocation.QPlaceSupplier: ...
    def type(self) -> PySide2.QtLocation.QPlaceContent.Type: ...
    def user(self) -> PySide2.QtLocation.QPlaceUser: ...


class QPlaceContentReply(PySide2.QtLocation.QPlaceReply):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def content(self) -> typing.Dict: ...
    def nextPageRequest(self) -> PySide2.QtLocation.QPlaceContentRequest: ...
    def previousPageRequest(self) -> PySide2.QtLocation.QPlaceContentRequest: ...
    def request(self) -> PySide2.QtLocation.QPlaceContentRequest: ...
    def setContent(self, content:typing.Dict): ...
    def setNextPageRequest(self, next:PySide2.QtLocation.QPlaceContentRequest): ...
    def setPreviousPageRequest(self, previous:PySide2.QtLocation.QPlaceContentRequest): ...
    def setRequest(self, request:PySide2.QtLocation.QPlaceContentRequest): ...
    def setTotalCount(self, total:int): ...
    def totalCount(self) -> int: ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceContentRequest(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContentRequest): ...

    def __copy__(self): ...
    def clear(self): ...
    def contentContext(self) -> typing.Any: ...
    def contentType(self) -> PySide2.QtLocation.QPlaceContent.Type: ...
    def limit(self) -> int: ...
    def placeId(self) -> str: ...
    def setContentContext(self, context:typing.Any): ...
    def setContentType(self, type:PySide2.QtLocation.QPlaceContent.Type): ...
    def setLimit(self, limit:int): ...
    def setPlaceId(self, identifier:str): ...


class QPlaceDetailsReply(PySide2.QtLocation.QPlaceReply):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def place(self) -> PySide2.QtLocation.QPlace: ...
    def setPlace(self, place:PySide2.QtLocation.QPlace): ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceEditorial(PySide2.QtLocation.QPlaceContent):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContent): ...

    def language(self) -> str: ...
    def setLanguage(self, data:str): ...
    def setText(self, text:str): ...
    def setTitle(self, data:str): ...
    def text(self) -> str: ...
    def title(self) -> str: ...


class QPlaceIcon(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceIcon): ...

    def __copy__(self): ...
    def isEmpty(self) -> bool: ...
    def manager(self) -> PySide2.QtLocation.QPlaceManager: ...
    def parameters(self) -> typing.Dict: ...
    def setManager(self, manager:PySide2.QtLocation.QPlaceManager): ...
    def setParameters(self, parameters:typing.Dict): ...
    def url(self, size:PySide2.QtCore.QSize=...) -> PySide2.QtCore.QUrl: ...


class QPlaceIdReply(PySide2.QtLocation.QPlaceReply):
    SavePlace                : QPlaceIdReply = ... # 0x0
    SaveCategory             : QPlaceIdReply = ... # 0x1
    RemovePlace              : QPlaceIdReply = ... # 0x2
    RemoveCategory           : QPlaceIdReply = ... # 0x3

    class OperationType(object):
        SavePlace                : QPlaceIdReply.OperationType = ... # 0x0
        SaveCategory             : QPlaceIdReply.OperationType = ... # 0x1
        RemovePlace              : QPlaceIdReply.OperationType = ... # 0x2
        RemoveCategory           : QPlaceIdReply.OperationType = ... # 0x3

    def __init__(self, operationType:PySide2.QtLocation.QPlaceIdReply.OperationType, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def id(self) -> str: ...
    def operationType(self) -> PySide2.QtLocation.QPlaceIdReply.OperationType: ...
    def setId(self, identifier:str): ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceImage(PySide2.QtLocation.QPlaceContent):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContent): ...

    def imageId(self) -> str: ...
    def mimeType(self) -> str: ...
    def setImageId(self, identifier:str): ...
    def setMimeType(self, data:str): ...
    def setUrl(self, url:PySide2.QtCore.QUrl): ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QPlaceManager(PySide2.QtCore.QObject):
    def category(self, categoryId:str) -> PySide2.QtLocation.QPlaceCategory: ...
    def childCategories(self, parentId:str=...) -> typing.List: ...
    def childCategoryIds(self, parentId:str=...) -> typing.List: ...
    def compatiblePlace(self, place:PySide2.QtLocation.QPlace) -> PySide2.QtLocation.QPlace: ...
    def getPlaceContent(self, request:PySide2.QtLocation.QPlaceContentRequest) -> PySide2.QtLocation.QPlaceContentReply: ...
    def getPlaceDetails(self, placeId:str) -> PySide2.QtLocation.QPlaceDetailsReply: ...
    def initializeCategories(self) -> PySide2.QtLocation.QPlaceReply: ...
    def locales(self) -> typing.List: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def matchingPlaces(self, request:PySide2.QtLocation.QPlaceMatchRequest) -> PySide2.QtLocation.QPlaceMatchReply: ...
    def parentCategoryId(self, categoryId:str) -> str: ...
    def removeCategory(self, categoryId:str) -> PySide2.QtLocation.QPlaceIdReply: ...
    def removePlace(self, placeId:str) -> PySide2.QtLocation.QPlaceIdReply: ...
    def saveCategory(self, category:PySide2.QtLocation.QPlaceCategory, parentId:str=...) -> PySide2.QtLocation.QPlaceIdReply: ...
    def savePlace(self, place:PySide2.QtLocation.QPlace) -> PySide2.QtLocation.QPlaceIdReply: ...
    def search(self, query:PySide2.QtLocation.QPlaceSearchRequest) -> PySide2.QtLocation.QPlaceSearchReply: ...
    def searchSuggestions(self, request:PySide2.QtLocation.QPlaceSearchRequest) -> PySide2.QtLocation.QPlaceSearchSuggestionReply: ...
    def setLocale(self, locale:PySide2.QtCore.QLocale): ...
    def setLocales(self, locale:typing.Sequence): ...


class QPlaceManagerEngine(PySide2.QtCore.QObject):

    def __init__(self, parameters:typing.Dict, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def category(self, categoryId:str) -> PySide2.QtLocation.QPlaceCategory: ...
    def childCategories(self, parentId:str) -> typing.List: ...
    def childCategoryIds(self, categoryId:str) -> typing.List: ...
    def compatiblePlace(self, original:PySide2.QtLocation.QPlace) -> PySide2.QtLocation.QPlace: ...
    def constructIconUrl(self, icon:PySide2.QtLocation.QPlaceIcon, size:PySide2.QtCore.QSize) -> PySide2.QtCore.QUrl: ...
    def getPlaceContent(self, request:PySide2.QtLocation.QPlaceContentRequest) -> PySide2.QtLocation.QPlaceContentReply: ...
    def getPlaceDetails(self, placeId:str) -> PySide2.QtLocation.QPlaceDetailsReply: ...
    def initializeCategories(self) -> PySide2.QtLocation.QPlaceReply: ...
    def locales(self) -> typing.List: ...
    def manager(self) -> PySide2.QtLocation.QPlaceManager: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def matchingPlaces(self, request:PySide2.QtLocation.QPlaceMatchRequest) -> PySide2.QtLocation.QPlaceMatchReply: ...
    def parentCategoryId(self, categoryId:str) -> str: ...
    def removeCategory(self, categoryId:str) -> PySide2.QtLocation.QPlaceIdReply: ...
    def removePlace(self, placeId:str) -> PySide2.QtLocation.QPlaceIdReply: ...
    def saveCategory(self, category:PySide2.QtLocation.QPlaceCategory, parentId:str) -> PySide2.QtLocation.QPlaceIdReply: ...
    def savePlace(self, place:PySide2.QtLocation.QPlace) -> PySide2.QtLocation.QPlaceIdReply: ...
    def search(self, request:PySide2.QtLocation.QPlaceSearchRequest) -> PySide2.QtLocation.QPlaceSearchReply: ...
    def searchSuggestions(self, request:PySide2.QtLocation.QPlaceSearchRequest) -> PySide2.QtLocation.QPlaceSearchSuggestionReply: ...
    def setLocales(self, locales:typing.Sequence): ...


class QPlaceMatchReply(PySide2.QtLocation.QPlaceReply):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def places(self) -> typing.List: ...
    def request(self) -> PySide2.QtLocation.QPlaceMatchRequest: ...
    def setPlaces(self, results:typing.Sequence): ...
    def setRequest(self, request:PySide2.QtLocation.QPlaceMatchRequest): ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceMatchRequest(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceMatchRequest): ...

    def __copy__(self): ...
    def clear(self): ...
    def parameters(self) -> typing.Dict: ...
    def places(self) -> typing.List: ...
    def setParameters(self, parameters:typing.Dict): ...
    def setPlaces(self, places:typing.Sequence): ...
    def setResults(self, results:typing.Sequence): ...


class QPlaceProposedSearchResult(PySide2.QtLocation.QPlaceSearchResult):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceSearchResult): ...

    def searchRequest(self) -> PySide2.QtLocation.QPlaceSearchRequest: ...
    def setSearchRequest(self, request:PySide2.QtLocation.QPlaceSearchRequest): ...


class QPlaceRatings(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceRatings): ...

    def __copy__(self): ...
    def average(self) -> float: ...
    def count(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def maximum(self) -> float: ...
    def setAverage(self, average:float): ...
    def setCount(self, count:int): ...
    def setMaximum(self, max:float): ...


class QPlaceReply(PySide2.QtCore.QObject):
    NoError                  : QPlaceReply = ... # 0x0
    Reply                    : QPlaceReply = ... # 0x0
    DetailsReply             : QPlaceReply = ... # 0x1
    PlaceDoesNotExistError   : QPlaceReply = ... # 0x1
    CategoryDoesNotExistError: QPlaceReply = ... # 0x2
    SearchReply              : QPlaceReply = ... # 0x2
    CommunicationError       : QPlaceReply = ... # 0x3
    SearchSuggestionReply    : QPlaceReply = ... # 0x3
    ContentReply             : QPlaceReply = ... # 0x4
    ParseError               : QPlaceReply = ... # 0x4
    IdReply                  : QPlaceReply = ... # 0x5
    PermissionsError         : QPlaceReply = ... # 0x5
    MatchReply               : QPlaceReply = ... # 0x6
    UnsupportedError         : QPlaceReply = ... # 0x6
    BadArgumentError         : QPlaceReply = ... # 0x7
    CancelError              : QPlaceReply = ... # 0x8
    UnknownError             : QPlaceReply = ... # 0x9

    class Error(object):
        NoError                  : QPlaceReply.Error = ... # 0x0
        PlaceDoesNotExistError   : QPlaceReply.Error = ... # 0x1
        CategoryDoesNotExistError: QPlaceReply.Error = ... # 0x2
        CommunicationError       : QPlaceReply.Error = ... # 0x3
        ParseError               : QPlaceReply.Error = ... # 0x4
        PermissionsError         : QPlaceReply.Error = ... # 0x5
        UnsupportedError         : QPlaceReply.Error = ... # 0x6
        BadArgumentError         : QPlaceReply.Error = ... # 0x7
        CancelError              : QPlaceReply.Error = ... # 0x8
        UnknownError             : QPlaceReply.Error = ... # 0x9

    class Type(object):
        Reply                    : QPlaceReply.Type = ... # 0x0
        DetailsReply             : QPlaceReply.Type = ... # 0x1
        SearchReply              : QPlaceReply.Type = ... # 0x2
        SearchSuggestionReply    : QPlaceReply.Type = ... # 0x3
        ContentReply             : QPlaceReply.Type = ... # 0x4
        IdReply                  : QPlaceReply.Type = ... # 0x5
        MatchReply               : QPlaceReply.Type = ... # 0x6

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def abort(self): ...
    def error(self) -> PySide2.QtLocation.QPlaceReply.Error: ...
    def errorString(self) -> str: ...
    def isFinished(self) -> bool: ...
    def setError(self, error:PySide2.QtLocation.QPlaceReply.Error, errorString:str): ...
    def setFinished(self, finished:bool): ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceResult(PySide2.QtLocation.QPlaceSearchResult):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceSearchResult): ...

    def distance(self) -> float: ...
    def isSponsored(self) -> bool: ...
    def place(self) -> PySide2.QtLocation.QPlace: ...
    def setDistance(self, distance:float): ...
    def setPlace(self, place:PySide2.QtLocation.QPlace): ...
    def setSponsored(self, sponsored:bool): ...


class QPlaceReview(PySide2.QtLocation.QPlaceContent):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceContent): ...

    def dateTime(self) -> PySide2.QtCore.QDateTime: ...
    def language(self) -> str: ...
    def rating(self) -> float: ...
    def reviewId(self) -> str: ...
    def setDateTime(self, dt:PySide2.QtCore.QDateTime): ...
    def setLanguage(self, data:str): ...
    def setRating(self, data:float): ...
    def setReviewId(self, identifier:str): ...
    def setText(self, text:str): ...
    def setTitle(self, data:str): ...
    def text(self) -> str: ...
    def title(self) -> str: ...


class QPlaceSearchReply(PySide2.QtLocation.QPlaceReply):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def nextPageRequest(self) -> PySide2.QtLocation.QPlaceSearchRequest: ...
    def previousPageRequest(self) -> PySide2.QtLocation.QPlaceSearchRequest: ...
    def request(self) -> PySide2.QtLocation.QPlaceSearchRequest: ...
    def results(self) -> typing.List: ...
    def setNextPageRequest(self, next:PySide2.QtLocation.QPlaceSearchRequest): ...
    def setPreviousPageRequest(self, previous:PySide2.QtLocation.QPlaceSearchRequest): ...
    def setRequest(self, request:PySide2.QtLocation.QPlaceSearchRequest): ...
    def setResults(self, results:typing.Sequence): ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceSearchRequest(Shiboken.Object):
    UnspecifiedHint          : QPlaceSearchRequest = ... # 0x0
    DistanceHint             : QPlaceSearchRequest = ... # 0x1
    LexicalPlaceNameHint     : QPlaceSearchRequest = ... # 0x2

    class RelevanceHint(object):
        UnspecifiedHint          : QPlaceSearchRequest.RelevanceHint = ... # 0x0
        DistanceHint             : QPlaceSearchRequest.RelevanceHint = ... # 0x1
        LexicalPlaceNameHint     : QPlaceSearchRequest.RelevanceHint = ... # 0x2

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceSearchRequest): ...

    def categories(self) -> typing.List: ...
    def clear(self): ...
    def limit(self) -> int: ...
    def recommendationId(self) -> str: ...
    def relevanceHint(self) -> PySide2.QtLocation.QPlaceSearchRequest.RelevanceHint: ...
    def searchArea(self) -> PySide2.QtPositioning.QGeoShape: ...
    def searchContext(self) -> typing.Any: ...
    def searchTerm(self) -> str: ...
    def setCategories(self, categories:typing.Sequence): ...
    def setCategory(self, category:PySide2.QtLocation.QPlaceCategory): ...
    def setLimit(self, limit:int): ...
    def setRecommendationId(self, recommendationId:str): ...
    def setRelevanceHint(self, hint:PySide2.QtLocation.QPlaceSearchRequest.RelevanceHint): ...
    def setSearchArea(self, area:PySide2.QtPositioning.QGeoShape): ...
    def setSearchContext(self, context:typing.Any): ...
    def setSearchTerm(self, term:str): ...


class QPlaceSearchResult(Shiboken.Object):
    UnknownSearchResult      : QPlaceSearchResult = ... # 0x0
    PlaceResult              : QPlaceSearchResult = ... # 0x1
    ProposedSearchResult     : QPlaceSearchResult = ... # 0x2

    class SearchResultType(object):
        UnknownSearchResult      : QPlaceSearchResult.SearchResultType = ... # 0x0
        PlaceResult              : QPlaceSearchResult.SearchResultType = ... # 0x1
        ProposedSearchResult     : QPlaceSearchResult.SearchResultType = ... # 0x2

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceSearchResult): ...

    def icon(self) -> PySide2.QtLocation.QPlaceIcon: ...
    def setIcon(self, icon:PySide2.QtLocation.QPlaceIcon): ...
    def setTitle(self, title:str): ...
    def title(self) -> str: ...
    def type(self) -> PySide2.QtLocation.QPlaceSearchResult.SearchResultType: ...


class QPlaceSearchSuggestionReply(PySide2.QtLocation.QPlaceReply):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def setSuggestions(self, suggestions:typing.Sequence): ...
    def suggestions(self) -> typing.List: ...
    def type(self) -> PySide2.QtLocation.QPlaceReply.Type: ...


class QPlaceSupplier(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceSupplier): ...

    def __copy__(self): ...
    def icon(self) -> PySide2.QtLocation.QPlaceIcon: ...
    def isEmpty(self) -> bool: ...
    def name(self) -> str: ...
    def setIcon(self, icon:PySide2.QtLocation.QPlaceIcon): ...
    def setName(self, data:str): ...
    def setSupplierId(self, identifier:str): ...
    def setUrl(self, data:PySide2.QtCore.QUrl): ...
    def supplierId(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QPlaceUser(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtLocation.QPlaceUser): ...

    def __copy__(self): ...
    def name(self) -> str: ...
    def setName(self, name:str): ...
    def setUserId(self, identifier:str): ...
    def userId(self) -> str: ...

# eof
