# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2019 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtNetwork, except for defaults which are replaced by "...".
"""

# Module PySide2.QtNetwork
import PySide2
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtCore
import PySide2.QtNetwork


class QAbstractNetworkCache(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def cacheSize(self) -> int: ...
    def clear(self): ...
    def data(self, url:PySide2.QtCore.QUrl) -> PySide2.QtCore.QIODevice: ...
    def insert(self, device:PySide2.QtCore.QIODevice): ...
    def metaData(self, url:PySide2.QtCore.QUrl) -> PySide2.QtNetwork.QNetworkCacheMetaData: ...
    def prepare(self, metaData:PySide2.QtNetwork.QNetworkCacheMetaData) -> PySide2.QtCore.QIODevice: ...
    def remove(self, url:PySide2.QtCore.QUrl) -> bool: ...
    def updateMetaData(self, metaData:PySide2.QtNetwork.QNetworkCacheMetaData): ...


class QAbstractSocket(PySide2.QtCore.QIODevice):
    UnknownNetworkLayerProtocol: QAbstractSocket = ... # -0x1
    UnknownSocketError       : QAbstractSocket = ... # -0x1
    UnknownSocketType        : QAbstractSocket = ... # -0x1
    ConnectionRefusedError   : QAbstractSocket = ... # 0x0
    DefaultForPlatform       : QAbstractSocket = ... # 0x0
    IPv4Protocol             : QAbstractSocket = ... # 0x0
    LowDelayOption           : QAbstractSocket = ... # 0x0
    PauseNever               : QAbstractSocket = ... # 0x0
    TcpSocket                : QAbstractSocket = ... # 0x0
    UnconnectedState         : QAbstractSocket = ... # 0x0
    HostLookupState          : QAbstractSocket = ... # 0x1
    IPv6Protocol             : QAbstractSocket = ... # 0x1
    KeepAliveOption          : QAbstractSocket = ... # 0x1
    PauseOnSslErrors         : QAbstractSocket = ... # 0x1
    RemoteHostClosedError    : QAbstractSocket = ... # 0x1
    ShareAddress             : QAbstractSocket = ... # 0x1
    UdpSocket                : QAbstractSocket = ... # 0x1
    AnyIPProtocol            : QAbstractSocket = ... # 0x2
    ConnectingState          : QAbstractSocket = ... # 0x2
    DontShareAddress         : QAbstractSocket = ... # 0x2
    HostNotFoundError        : QAbstractSocket = ... # 0x2
    MulticastTtlOption       : QAbstractSocket = ... # 0x2
    SctpSocket               : QAbstractSocket = ... # 0x2
    ConnectedState           : QAbstractSocket = ... # 0x3
    MulticastLoopbackOption  : QAbstractSocket = ... # 0x3
    SocketAccessError        : QAbstractSocket = ... # 0x3
    BoundState               : QAbstractSocket = ... # 0x4
    ReuseAddressHint         : QAbstractSocket = ... # 0x4
    SocketResourceError      : QAbstractSocket = ... # 0x4
    TypeOfServiceOption      : QAbstractSocket = ... # 0x4
    ListeningState           : QAbstractSocket = ... # 0x5
    SendBufferSizeSocketOption: QAbstractSocket = ... # 0x5
    SocketTimeoutError       : QAbstractSocket = ... # 0x5
    ClosingState             : QAbstractSocket = ... # 0x6
    DatagramTooLargeError    : QAbstractSocket = ... # 0x6
    ReceiveBufferSizeSocketOption: QAbstractSocket = ... # 0x6
    NetworkError             : QAbstractSocket = ... # 0x7
    PathMtuSocketOption      : QAbstractSocket = ... # 0x7
    AddressInUseError        : QAbstractSocket = ... # 0x8
    SocketAddressNotAvailableError: QAbstractSocket = ... # 0x9
    UnsupportedSocketOperationError: QAbstractSocket = ... # 0xa
    UnfinishedSocketOperationError: QAbstractSocket = ... # 0xb
    ProxyAuthenticationRequiredError: QAbstractSocket = ... # 0xc
    SslHandshakeFailedError  : QAbstractSocket = ... # 0xd
    ProxyConnectionRefusedError: QAbstractSocket = ... # 0xe
    ProxyConnectionClosedError: QAbstractSocket = ... # 0xf
    ProxyConnectionTimeoutError: QAbstractSocket = ... # 0x10
    ProxyNotFoundError       : QAbstractSocket = ... # 0x11
    ProxyProtocolError       : QAbstractSocket = ... # 0x12
    OperationError           : QAbstractSocket = ... # 0x13
    SslInternalError         : QAbstractSocket = ... # 0x14
    SslInvalidUserDataError  : QAbstractSocket = ... # 0x15
    TemporaryError           : QAbstractSocket = ... # 0x16

    class BindFlag(object):
        DefaultForPlatform       : QAbstractSocket.BindFlag = ... # 0x0
        ShareAddress             : QAbstractSocket.BindFlag = ... # 0x1
        DontShareAddress         : QAbstractSocket.BindFlag = ... # 0x2
        ReuseAddressHint         : QAbstractSocket.BindFlag = ... # 0x4

    class BindMode(object): ...

    class NetworkLayerProtocol(object):
        UnknownNetworkLayerProtocol: QAbstractSocket.NetworkLayerProtocol = ... # -0x1
        IPv4Protocol             : QAbstractSocket.NetworkLayerProtocol = ... # 0x0
        IPv6Protocol             : QAbstractSocket.NetworkLayerProtocol = ... # 0x1
        AnyIPProtocol            : QAbstractSocket.NetworkLayerProtocol = ... # 0x2

    class PauseMode(object):
        PauseNever               : QAbstractSocket.PauseMode = ... # 0x0
        PauseOnSslErrors         : QAbstractSocket.PauseMode = ... # 0x1

    class PauseModes(object): ...

    class SocketError(object):
        UnknownSocketError       : QAbstractSocket.SocketError = ... # -0x1
        ConnectionRefusedError   : QAbstractSocket.SocketError = ... # 0x0
        RemoteHostClosedError    : QAbstractSocket.SocketError = ... # 0x1
        HostNotFoundError        : QAbstractSocket.SocketError = ... # 0x2
        SocketAccessError        : QAbstractSocket.SocketError = ... # 0x3
        SocketResourceError      : QAbstractSocket.SocketError = ... # 0x4
        SocketTimeoutError       : QAbstractSocket.SocketError = ... # 0x5
        DatagramTooLargeError    : QAbstractSocket.SocketError = ... # 0x6
        NetworkError             : QAbstractSocket.SocketError = ... # 0x7
        AddressInUseError        : QAbstractSocket.SocketError = ... # 0x8
        SocketAddressNotAvailableError: QAbstractSocket.SocketError = ... # 0x9
        UnsupportedSocketOperationError: QAbstractSocket.SocketError = ... # 0xa
        UnfinishedSocketOperationError: QAbstractSocket.SocketError = ... # 0xb
        ProxyAuthenticationRequiredError: QAbstractSocket.SocketError = ... # 0xc
        SslHandshakeFailedError  : QAbstractSocket.SocketError = ... # 0xd
        ProxyConnectionRefusedError: QAbstractSocket.SocketError = ... # 0xe
        ProxyConnectionClosedError: QAbstractSocket.SocketError = ... # 0xf
        ProxyConnectionTimeoutError: QAbstractSocket.SocketError = ... # 0x10
        ProxyNotFoundError       : QAbstractSocket.SocketError = ... # 0x11
        ProxyProtocolError       : QAbstractSocket.SocketError = ... # 0x12
        OperationError           : QAbstractSocket.SocketError = ... # 0x13
        SslInternalError         : QAbstractSocket.SocketError = ... # 0x14
        SslInvalidUserDataError  : QAbstractSocket.SocketError = ... # 0x15
        TemporaryError           : QAbstractSocket.SocketError = ... # 0x16

    class SocketOption(object):
        LowDelayOption           : QAbstractSocket.SocketOption = ... # 0x0
        KeepAliveOption          : QAbstractSocket.SocketOption = ... # 0x1
        MulticastTtlOption       : QAbstractSocket.SocketOption = ... # 0x2
        MulticastLoopbackOption  : QAbstractSocket.SocketOption = ... # 0x3
        TypeOfServiceOption      : QAbstractSocket.SocketOption = ... # 0x4
        SendBufferSizeSocketOption: QAbstractSocket.SocketOption = ... # 0x5
        ReceiveBufferSizeSocketOption: QAbstractSocket.SocketOption = ... # 0x6
        PathMtuSocketOption      : QAbstractSocket.SocketOption = ... # 0x7

    class SocketState(object):
        UnconnectedState         : QAbstractSocket.SocketState = ... # 0x0
        HostLookupState          : QAbstractSocket.SocketState = ... # 0x1
        ConnectingState          : QAbstractSocket.SocketState = ... # 0x2
        ConnectedState           : QAbstractSocket.SocketState = ... # 0x3
        BoundState               : QAbstractSocket.SocketState = ... # 0x4
        ListeningState           : QAbstractSocket.SocketState = ... # 0x5
        ClosingState             : QAbstractSocket.SocketState = ... # 0x6

    class SocketType(object):
        UnknownSocketType        : QAbstractSocket.SocketType = ... # -0x1
        TcpSocket                : QAbstractSocket.SocketType = ... # 0x0
        UdpSocket                : QAbstractSocket.SocketType = ... # 0x1
        SctpSocket               : QAbstractSocket.SocketType = ... # 0x2

    def __init__(self, socketType:PySide2.QtNetwork.QAbstractSocket.SocketType, parent:PySide2.QtCore.QObject): ...

    def abort(self): ...
    def atEnd(self) -> bool: ...
    @typing.overload
    def bind(self, address:PySide2.QtNetwork.QHostAddress, port:int=..., mode:PySide2.QtNetwork.QAbstractSocket.BindMode=...) -> bool: ...
    @typing.overload
    def bind(self, port:int=..., mode:PySide2.QtNetwork.QAbstractSocket.BindMode=...) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self): ...
    @typing.overload
    def connectToHost(self, address:PySide2.QtNetwork.QHostAddress, port:int, mode:PySide2.QtCore.QIODevice.OpenMode=...): ...
    @typing.overload
    def connectToHost(self, hostName:str, port:int, mode:PySide2.QtCore.QIODevice.OpenMode=..., protocol:PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol=...): ...
    def disconnectFromHost(self): ...
    def error(self) -> PySide2.QtNetwork.QAbstractSocket.SocketError: ...
    def flush(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def isValid(self) -> bool: ...
    def localAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def localPort(self) -> int: ...
    def pauseMode(self) -> PySide2.QtNetwork.QAbstractSocket.PauseModes: ...
    def peerAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def peerName(self) -> str: ...
    def peerPort(self) -> int: ...
    def protocolTag(self) -> str: ...
    def proxy(self) -> PySide2.QtNetwork.QNetworkProxy: ...
    def readBufferSize(self) -> int: ...
    def readData(self, data:bytes, maxlen:int) -> int: ...
    def readLineData(self, data:bytes, maxlen:int) -> int: ...
    def resume(self): ...
    def setLocalAddress(self, address:PySide2.QtNetwork.QHostAddress): ...
    def setLocalPort(self, port:int): ...
    def setPauseMode(self, pauseMode:PySide2.QtNetwork.QAbstractSocket.PauseModes): ...
    def setPeerAddress(self, address:PySide2.QtNetwork.QHostAddress): ...
    def setPeerName(self, name:str): ...
    def setPeerPort(self, port:int): ...
    def setProtocolTag(self, tag:str): ...
    def setProxy(self, networkProxy:PySide2.QtNetwork.QNetworkProxy): ...
    def setReadBufferSize(self, size:int): ...
    def setSocketDescriptor(self, socketDescriptor:int, state:PySide2.QtNetwork.QAbstractSocket.SocketState=..., openMode:PySide2.QtCore.QIODevice.OpenMode=...) -> bool: ...
    def setSocketError(self, socketError:PySide2.QtNetwork.QAbstractSocket.SocketError): ...
    def setSocketOption(self, option:PySide2.QtNetwork.QAbstractSocket.SocketOption, value:typing.Any): ...
    def setSocketState(self, state:PySide2.QtNetwork.QAbstractSocket.SocketState): ...
    def socketDescriptor(self) -> int: ...
    def socketOption(self, option:PySide2.QtNetwork.QAbstractSocket.SocketOption) -> typing.Any: ...
    def socketType(self) -> PySide2.QtNetwork.QAbstractSocket.SocketType: ...
    def state(self) -> PySide2.QtNetwork.QAbstractSocket.SocketState: ...
    def waitForBytesWritten(self, msecs:int=...) -> bool: ...
    def waitForConnected(self, msecs:int=...) -> bool: ...
    def waitForDisconnected(self, msecs:int=...) -> bool: ...
    def waitForReadyRead(self, msecs:int=...) -> bool: ...
    def writeData(self, data:bytes, len:int) -> int: ...


class QAuthenticator(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QAuthenticator): ...

    def __copy__(self): ...
    def isNull(self) -> bool: ...
    def option(self, opt:str) -> typing.Any: ...
    def options(self) -> typing.Dict: ...
    def password(self) -> str: ...
    def realm(self) -> str: ...
    def setOption(self, opt:str, value:typing.Any): ...
    def setPassword(self, password:str): ...
    def setRealm(self, realm:str): ...
    def setUser(self, user:str): ...
    def user(self) -> str: ...


class QDnsDomainNameRecord(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QDnsDomainNameRecord): ...

    def __copy__(self): ...
    def name(self) -> str: ...
    def swap(self, other:PySide2.QtNetwork.QDnsDomainNameRecord): ...
    def timeToLive(self) -> int: ...
    def value(self) -> str: ...


class QDnsHostAddressRecord(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QDnsHostAddressRecord): ...

    def __copy__(self): ...
    def name(self) -> str: ...
    def swap(self, other:PySide2.QtNetwork.QDnsHostAddressRecord): ...
    def timeToLive(self) -> int: ...
    def value(self) -> PySide2.QtNetwork.QHostAddress: ...


class QDnsLookup(PySide2.QtCore.QObject):
    NoError                  : QDnsLookup = ... # 0x0
    A                        : QDnsLookup = ... # 0x1
    ResolverError            : QDnsLookup = ... # 0x1
    NS                       : QDnsLookup = ... # 0x2
    OperationCancelledError  : QDnsLookup = ... # 0x2
    InvalidRequestError      : QDnsLookup = ... # 0x3
    InvalidReplyError        : QDnsLookup = ... # 0x4
    CNAME                    : QDnsLookup = ... # 0x5
    ServerFailureError       : QDnsLookup = ... # 0x5
    ServerRefusedError       : QDnsLookup = ... # 0x6
    NotFoundError            : QDnsLookup = ... # 0x7
    PTR                      : QDnsLookup = ... # 0xc
    MX                       : QDnsLookup = ... # 0xf
    TXT                      : QDnsLookup = ... # 0x10
    AAAA                     : QDnsLookup = ... # 0x1c
    SRV                      : QDnsLookup = ... # 0x21
    ANY                      : QDnsLookup = ... # 0xff

    class Error(object):
        NoError                  : QDnsLookup.Error = ... # 0x0
        ResolverError            : QDnsLookup.Error = ... # 0x1
        OperationCancelledError  : QDnsLookup.Error = ... # 0x2
        InvalidRequestError      : QDnsLookup.Error = ... # 0x3
        InvalidReplyError        : QDnsLookup.Error = ... # 0x4
        ServerFailureError       : QDnsLookup.Error = ... # 0x5
        ServerRefusedError       : QDnsLookup.Error = ... # 0x6
        NotFoundError            : QDnsLookup.Error = ... # 0x7

    class Type(object):
        A                        : QDnsLookup.Type = ... # 0x1
        NS                       : QDnsLookup.Type = ... # 0x2
        CNAME                    : QDnsLookup.Type = ... # 0x5
        PTR                      : QDnsLookup.Type = ... # 0xc
        MX                       : QDnsLookup.Type = ... # 0xf
        TXT                      : QDnsLookup.Type = ... # 0x10
        AAAA                     : QDnsLookup.Type = ... # 0x1c
        SRV                      : QDnsLookup.Type = ... # 0x21
        ANY                      : QDnsLookup.Type = ... # 0xff

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, type:PySide2.QtNetwork.QDnsLookup.Type, name:str, nameserver:PySide2.QtNetwork.QHostAddress, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, type:PySide2.QtNetwork.QDnsLookup.Type, name:str, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def abort(self): ...
    def canonicalNameRecords(self) -> typing.List: ...
    def error(self) -> PySide2.QtNetwork.QDnsLookup.Error: ...
    def errorString(self) -> str: ...
    def hostAddressRecords(self) -> typing.List: ...
    def isFinished(self) -> bool: ...
    def lookup(self): ...
    def mailExchangeRecords(self) -> typing.List: ...
    def name(self) -> str: ...
    def nameServerRecords(self) -> typing.List: ...
    def nameserver(self) -> PySide2.QtNetwork.QHostAddress: ...
    def pointerRecords(self) -> typing.List: ...
    def serviceRecords(self) -> typing.List: ...
    def setName(self, name:str): ...
    def setNameserver(self, nameserver:PySide2.QtNetwork.QHostAddress): ...
    def setType(self, arg__1:PySide2.QtNetwork.QDnsLookup.Type): ...
    def textRecords(self) -> typing.List: ...
    def type(self) -> PySide2.QtNetwork.QDnsLookup.Type: ...


class QDnsMailExchangeRecord(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QDnsMailExchangeRecord): ...

    def __copy__(self): ...
    def exchange(self) -> str: ...
    def name(self) -> str: ...
    def preference(self) -> int: ...
    def swap(self, other:PySide2.QtNetwork.QDnsMailExchangeRecord): ...
    def timeToLive(self) -> int: ...


class QDnsServiceRecord(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QDnsServiceRecord): ...

    def __copy__(self): ...
    def name(self) -> str: ...
    def port(self) -> int: ...
    def priority(self) -> int: ...
    def swap(self, other:PySide2.QtNetwork.QDnsServiceRecord): ...
    def target(self) -> str: ...
    def timeToLive(self) -> int: ...
    def weight(self) -> int: ...


class QDnsTextRecord(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QDnsTextRecord): ...

    def __copy__(self): ...
    def name(self) -> str: ...
    def swap(self, other:PySide2.QtNetwork.QDnsTextRecord): ...
    def timeToLive(self) -> int: ...
    def values(self) -> typing.List: ...


class QDtls(PySide2.QtCore.QObject):
    HandshakeNotStarted      : QDtls = ... # 0x0
    HandshakeInProgress      : QDtls = ... # 0x1
    PeerVerificationFailed   : QDtls = ... # 0x2
    HandshakeComplete        : QDtls = ... # 0x3

    class HandshakeState(object):
        HandshakeNotStarted      : QDtls.HandshakeState = ... # 0x0
        HandshakeInProgress      : QDtls.HandshakeState = ... # 0x1
        PeerVerificationFailed   : QDtls.HandshakeState = ... # 0x2
        HandshakeComplete        : QDtls.HandshakeState = ... # 0x3

    def __init__(self, mode:PySide2.QtNetwork.QSslSocket.SslMode, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def abortHandshake(self, socket:PySide2.QtNetwork.QUdpSocket) -> bool: ...
    def decryptDatagram(self, socket:PySide2.QtNetwork.QUdpSocket, dgram:PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def doHandshake(self, socket:PySide2.QtNetwork.QUdpSocket, dgram:PySide2.QtCore.QByteArray=...) -> bool: ...
    def dtlsConfiguration(self) -> PySide2.QtNetwork.QSslConfiguration: ...
    def dtlsError(self) -> PySide2.QtNetwork.QDtlsError: ...
    def dtlsErrorString(self) -> str: ...
    def handleTimeout(self, socket:PySide2.QtNetwork.QUdpSocket) -> bool: ...
    def handshakeState(self) -> PySide2.QtNetwork.QDtls.HandshakeState: ...
    def ignoreVerificationErrors(self, errorsToIgnore:typing.List): ...
    def isConnectionEncrypted(self) -> bool: ...
    def mtuHint(self) -> int: ...
    def peerAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def peerPort(self) -> int: ...
    def peerVerificationErrors(self) -> typing.List: ...
    def peerVerificationName(self) -> str: ...
    def resumeHandshake(self, socket:PySide2.QtNetwork.QUdpSocket) -> bool: ...
    def sessionCipher(self) -> PySide2.QtNetwork.QSslCipher: ...
    def sessionProtocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def setDtlsConfiguration(self, configuration:PySide2.QtNetwork.QSslConfiguration) -> bool: ...
    def setMtuHint(self, mtuHint:int): ...
    def setPeer(self, address:PySide2.QtNetwork.QHostAddress, port:int, verificationName:str=...) -> bool: ...
    def setPeerVerificationName(self, name:str) -> bool: ...
    def shutdown(self, socket:PySide2.QtNetwork.QUdpSocket) -> bool: ...
    def sslMode(self) -> PySide2.QtNetwork.QSslSocket.SslMode: ...
    def writeDatagramEncrypted(self, socket:PySide2.QtNetwork.QUdpSocket, dgram:PySide2.QtCore.QByteArray) -> int: ...


class QDtlsError(object):
    NoError                  : QDtlsError = ... # 0x0
    InvalidInputParameters   : QDtlsError = ... # 0x1
    InvalidOperation         : QDtlsError = ... # 0x2
    UnderlyingSocketError    : QDtlsError = ... # 0x3
    RemoteClosedConnectionError: QDtlsError = ... # 0x4
    PeerVerificationError    : QDtlsError = ... # 0x5
    TlsInitializationError   : QDtlsError = ... # 0x6
    TlsFatalError            : QDtlsError = ... # 0x7
    TlsNonFatalError         : QDtlsError = ... # 0x8


class QHostAddress(Shiboken.Object):
    Null                     : QHostAddress = ... # 0x0
    StrictConversion         : QHostAddress = ... # 0x0
    Broadcast                : QHostAddress = ... # 0x1
    ConvertV4MappedToIPv4    : QHostAddress = ... # 0x1
    ConvertV4CompatToIPv4    : QHostAddress = ... # 0x2
    LocalHost                : QHostAddress = ... # 0x2
    LocalHostIPv6            : QHostAddress = ... # 0x3
    Any                      : QHostAddress = ... # 0x4
    ConvertUnspecifiedAddress: QHostAddress = ... # 0x4
    AnyIPv6                  : QHostAddress = ... # 0x5
    AnyIPv4                  : QHostAddress = ... # 0x6
    ConvertLocalHost         : QHostAddress = ... # 0x8
    TolerantConversion       : QHostAddress = ... # 0xff

    class ConversionMode(object): ...

    class ConversionModeFlag(object):
        StrictConversion         : QHostAddress.ConversionModeFlag = ... # 0x0
        ConvertV4MappedToIPv4    : QHostAddress.ConversionModeFlag = ... # 0x1
        ConvertV4CompatToIPv4    : QHostAddress.ConversionModeFlag = ... # 0x2
        ConvertUnspecifiedAddress: QHostAddress.ConversionModeFlag = ... # 0x4
        ConvertLocalHost         : QHostAddress.ConversionModeFlag = ... # 0x8
        TolerantConversion       : QHostAddress.ConversionModeFlag = ... # 0xff

    class SpecialAddress(object):
        Null                     : QHostAddress.SpecialAddress = ... # 0x0
        Broadcast                : QHostAddress.SpecialAddress = ... # 0x1
        LocalHost                : QHostAddress.SpecialAddress = ... # 0x2
        LocalHostIPv6            : QHostAddress.SpecialAddress = ... # 0x3
        Any                      : QHostAddress.SpecialAddress = ... # 0x4
        AnyIPv6                  : QHostAddress.SpecialAddress = ... # 0x5
        AnyIPv4                  : QHostAddress.SpecialAddress = ... # 0x6

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, address:PySide2.QtNetwork.QHostAddress.SpecialAddress): ...
    @typing.overload
    def __init__(self, address:str): ...
    @typing.overload
    def __init__(self, copy:PySide2.QtNetwork.QHostAddress): ...
    @typing.overload
    def __init__(self, ip4Addr:int): ...
    @typing.overload
    def __init__(self, ip6Addr:PySide2.QtNetwork.QIPv6Address): ...

    def __copy__(self): ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def clear(self): ...
    def isBroadcast(self) -> bool: ...
    def isEqual(self, address:PySide2.QtNetwork.QHostAddress, mode:PySide2.QtNetwork.QHostAddress.ConversionMode=...) -> bool: ...
    def isGlobal(self) -> bool: ...
    @typing.overload
    def isInSubnet(self, subnet:PySide2.QtNetwork.QHostAddress, netmask:int) -> bool: ...
    @typing.overload
    def isInSubnet(self, subnet:typing.Tuple) -> bool: ...
    def isLinkLocal(self) -> bool: ...
    def isLoopback(self) -> bool: ...
    def isMulticast(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isSiteLocal(self) -> bool: ...
    def isUniqueLocalUnicast(self) -> bool: ...
    @staticmethod
    def parseSubnet(subnet:str) -> typing.Tuple: ...
    def protocol(self) -> PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol: ...
    def scopeId(self) -> str: ...
    @typing.overload
    def setAddress(self, address:PySide2.QtNetwork.QHostAddress.SpecialAddress): ...
    @typing.overload
    def setAddress(self, address:str) -> bool: ...
    @typing.overload
    def setAddress(self, ip4Addr:int): ...
    @typing.overload
    def setAddress(self, ip6Addr:PySide2.QtNetwork.QIPv6Address): ...
    def setScopeId(self, id:str): ...
    def swap(self, other:PySide2.QtNetwork.QHostAddress): ...
    @typing.overload
    def toIPv4Address(self) -> int: ...
    @typing.overload
    def toIPv4Address(self) -> typing.Tuple: ...
    def toIPv6Address(self) -> PySide2.QtNetwork.QIPv6Address: ...
    def toString(self) -> str: ...


class QHostInfo(Shiboken.Object):
    NoError                  : QHostInfo = ... # 0x0
    HostNotFound             : QHostInfo = ... # 0x1
    UnknownError             : QHostInfo = ... # 0x2

    class HostInfoError(object):
        NoError                  : QHostInfo.HostInfoError = ... # 0x0
        HostNotFound             : QHostInfo.HostInfoError = ... # 0x1
        UnknownError             : QHostInfo.HostInfoError = ... # 0x2

    @typing.overload
    def __init__(self, d:PySide2.QtNetwork.QHostInfo): ...
    @typing.overload
    def __init__(self, lookupId:int=...): ...

    def __copy__(self): ...
    @staticmethod
    def abortHostLookup(lookupId:int): ...
    def addresses(self) -> typing.List: ...
    def error(self) -> PySide2.QtNetwork.QHostInfo.HostInfoError: ...
    def errorString(self) -> str: ...
    @staticmethod
    def fromName(name:str) -> PySide2.QtNetwork.QHostInfo: ...
    def hostName(self) -> str: ...
    @staticmethod
    def localDomainName() -> str: ...
    @staticmethod
    def localHostName() -> str: ...
    def lookupId(self) -> int: ...
    def setAddresses(self, addresses:typing.Sequence): ...
    def setError(self, error:PySide2.QtNetwork.QHostInfo.HostInfoError): ...
    def setErrorString(self, errorString:str): ...
    def setHostName(self, name:str): ...
    def setLookupId(self, id:int): ...
    def swap(self, other:PySide2.QtNetwork.QHostInfo): ...


class QHstsPolicy(Shiboken.Object):
    IncludeSubDomains        : QHstsPolicy = ... # 0x1

    class PolicyFlag(object):
        IncludeSubDomains        : QHstsPolicy.PolicyFlag = ... # 0x1

    class PolicyFlags(object): ...

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, expiry:PySide2.QtCore.QDateTime, flags:PySide2.QtNetwork.QHstsPolicy.PolicyFlags, host:str, mode:PySide2.QtCore.QUrl.ParsingMode=...): ...
    @typing.overload
    def __init__(self, rhs:PySide2.QtNetwork.QHstsPolicy): ...

    def __copy__(self): ...
    def expiry(self) -> PySide2.QtCore.QDateTime: ...
    def host(self, options:PySide2.QtCore.QUrl.ComponentFormattingOption=...) -> str: ...
    def includesSubDomains(self) -> bool: ...
    def isExpired(self) -> bool: ...
    def setExpiry(self, expiry:PySide2.QtCore.QDateTime): ...
    def setHost(self, host:str, mode:PySide2.QtCore.QUrl.ParsingMode=...): ...
    def setIncludesSubDomains(self, include:bool): ...
    def swap(self, other:PySide2.QtNetwork.QHstsPolicy): ...


class QHttpMultiPart(PySide2.QtCore.QObject):
    MixedType                : QHttpMultiPart = ... # 0x0
    RelatedType              : QHttpMultiPart = ... # 0x1
    FormDataType             : QHttpMultiPart = ... # 0x2
    AlternativeType          : QHttpMultiPart = ... # 0x3

    class ContentType(object):
        MixedType                : QHttpMultiPart.ContentType = ... # 0x0
        RelatedType              : QHttpMultiPart.ContentType = ... # 0x1
        FormDataType             : QHttpMultiPart.ContentType = ... # 0x2
        AlternativeType          : QHttpMultiPart.ContentType = ... # 0x3

    @typing.overload
    def __init__(self, contentType:PySide2.QtNetwork.QHttpMultiPart.ContentType, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def append(self, httpPart:PySide2.QtNetwork.QHttpPart): ...
    def boundary(self) -> PySide2.QtCore.QByteArray: ...
    def setBoundary(self, boundary:PySide2.QtCore.QByteArray): ...
    def setContentType(self, contentType:PySide2.QtNetwork.QHttpMultiPart.ContentType): ...


class QHttpPart(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QHttpPart): ...

    def __copy__(self): ...
    def setBody(self, body:PySide2.QtCore.QByteArray): ...
    def setBodyDevice(self, device:PySide2.QtCore.QIODevice): ...
    def setHeader(self, header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders, value:typing.Any): ...
    def setRawHeader(self, headerName:PySide2.QtCore.QByteArray, headerValue:PySide2.QtCore.QByteArray): ...
    def swap(self, other:PySide2.QtNetwork.QHttpPart): ...


class QIPv6Address(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QIPv6Address:PySide2.QtNetwork.QIPv6Address): ...

    def __copy__(self): ...


class QLocalServer(PySide2.QtCore.QObject):
    NoOptions                : QLocalServer = ... # 0x0
    UserAccessOption         : QLocalServer = ... # 0x1
    GroupAccessOption        : QLocalServer = ... # 0x2
    OtherAccessOption        : QLocalServer = ... # 0x4
    WorldAccessOption        : QLocalServer = ... # 0x7

    class SocketOption(object):
        NoOptions                : QLocalServer.SocketOption = ... # 0x0
        UserAccessOption         : QLocalServer.SocketOption = ... # 0x1
        GroupAccessOption        : QLocalServer.SocketOption = ... # 0x2
        OtherAccessOption        : QLocalServer.SocketOption = ... # 0x4
        WorldAccessOption        : QLocalServer.SocketOption = ... # 0x7

    class SocketOptions(object): ...

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def close(self): ...
    def errorString(self) -> str: ...
    def fullServerName(self) -> str: ...
    def hasPendingConnections(self) -> bool: ...
    def incomingConnection(self, socketDescriptor:int): ...
    def isListening(self) -> bool: ...
    @typing.overload
    def listen(self, name:str) -> bool: ...
    @typing.overload
    def listen(self, socketDescriptor:int) -> bool: ...
    def maxPendingConnections(self) -> int: ...
    def nextPendingConnection(self) -> PySide2.QtNetwork.QLocalSocket: ...
    @staticmethod
    def removeServer(name:str) -> bool: ...
    def serverError(self) -> PySide2.QtNetwork.QAbstractSocket.SocketError: ...
    def serverName(self) -> str: ...
    def setMaxPendingConnections(self, numConnections:int): ...
    def setSocketOptions(self, options:PySide2.QtNetwork.QLocalServer.SocketOptions): ...
    def socketDescriptor(self) -> int: ...
    def socketOptions(self) -> PySide2.QtNetwork.QLocalServer.SocketOptions: ...
    def waitForNewConnection(self, msec:int) -> typing.Tuple: ...


class QLocalSocket(PySide2.QtCore.QIODevice):
    UnknownSocketError       : QLocalSocket = ... # -0x1
    ConnectionRefusedError   : QLocalSocket = ... # 0x0
    UnconnectedState         : QLocalSocket = ... # 0x0
    PeerClosedError          : QLocalSocket = ... # 0x1
    ConnectingState          : QLocalSocket = ... # 0x2
    ServerNotFoundError      : QLocalSocket = ... # 0x2
    ConnectedState           : QLocalSocket = ... # 0x3
    SocketAccessError        : QLocalSocket = ... # 0x3
    SocketResourceError      : QLocalSocket = ... # 0x4
    SocketTimeoutError       : QLocalSocket = ... # 0x5
    ClosingState             : QLocalSocket = ... # 0x6
    DatagramTooLargeError    : QLocalSocket = ... # 0x6
    ConnectionError          : QLocalSocket = ... # 0x7
    UnsupportedSocketOperationError: QLocalSocket = ... # 0xa
    OperationError           : QLocalSocket = ... # 0x13

    class LocalSocketError(object):
        UnknownSocketError       : QLocalSocket.LocalSocketError = ... # -0x1
        ConnectionRefusedError   : QLocalSocket.LocalSocketError = ... # 0x0
        PeerClosedError          : QLocalSocket.LocalSocketError = ... # 0x1
        ServerNotFoundError      : QLocalSocket.LocalSocketError = ... # 0x2
        SocketAccessError        : QLocalSocket.LocalSocketError = ... # 0x3
        SocketResourceError      : QLocalSocket.LocalSocketError = ... # 0x4
        SocketTimeoutError       : QLocalSocket.LocalSocketError = ... # 0x5
        DatagramTooLargeError    : QLocalSocket.LocalSocketError = ... # 0x6
        ConnectionError          : QLocalSocket.LocalSocketError = ... # 0x7
        UnsupportedSocketOperationError: QLocalSocket.LocalSocketError = ... # 0xa
        OperationError           : QLocalSocket.LocalSocketError = ... # 0x13

    class LocalSocketState(object):
        UnconnectedState         : QLocalSocket.LocalSocketState = ... # 0x0
        ConnectingState          : QLocalSocket.LocalSocketState = ... # 0x2
        ConnectedState           : QLocalSocket.LocalSocketState = ... # 0x3
        ClosingState             : QLocalSocket.LocalSocketState = ... # 0x6

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def abort(self): ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self): ...
    @typing.overload
    def connectToServer(self, name:str, openMode:PySide2.QtCore.QIODevice.OpenMode=...): ...
    @typing.overload
    def connectToServer(self, openMode:PySide2.QtCore.QIODevice.OpenMode=...): ...
    def disconnectFromServer(self): ...
    def error(self) -> PySide2.QtNetwork.QLocalSocket.LocalSocketError: ...
    def flush(self) -> bool: ...
    def fullServerName(self) -> str: ...
    def isSequential(self) -> bool: ...
    def isValid(self) -> bool: ...
    def open(self, openMode:PySide2.QtCore.QIODevice.OpenMode=...) -> bool: ...
    def readBufferSize(self) -> int: ...
    def readData(self, arg__1:bytes, arg__2:int) -> int: ...
    def serverName(self) -> str: ...
    def setReadBufferSize(self, size:int): ...
    def setServerName(self, name:str): ...
    def setSocketDescriptor(self, socketDescriptor:int, socketState:PySide2.QtNetwork.QLocalSocket.LocalSocketState=..., openMode:PySide2.QtCore.QIODevice.OpenMode=...) -> bool: ...
    def socketDescriptor(self) -> int: ...
    def state(self) -> PySide2.QtNetwork.QLocalSocket.LocalSocketState: ...
    def waitForBytesWritten(self, msecs:int=...) -> bool: ...
    def waitForConnected(self, msecs:int=...) -> bool: ...
    def waitForDisconnected(self, msecs:int=...) -> bool: ...
    def waitForReadyRead(self, msecs:int=...) -> bool: ...
    def writeData(self, arg__1:bytes, arg__2:int) -> int: ...


class QNetworkAccessManager(PySide2.QtCore.QObject):
    UnknownAccessibility     : QNetworkAccessManager = ... # -0x1
    NotAccessible            : QNetworkAccessManager = ... # 0x0
    UnknownOperation         : QNetworkAccessManager = ... # 0x0
    Accessible               : QNetworkAccessManager = ... # 0x1
    HeadOperation            : QNetworkAccessManager = ... # 0x1
    GetOperation             : QNetworkAccessManager = ... # 0x2
    PutOperation             : QNetworkAccessManager = ... # 0x3
    PostOperation            : QNetworkAccessManager = ... # 0x4
    DeleteOperation          : QNetworkAccessManager = ... # 0x5
    CustomOperation          : QNetworkAccessManager = ... # 0x6

    class NetworkAccessibility(object):
        UnknownAccessibility     : QNetworkAccessManager.NetworkAccessibility = ... # -0x1
        NotAccessible            : QNetworkAccessManager.NetworkAccessibility = ... # 0x0
        Accessible               : QNetworkAccessManager.NetworkAccessibility = ... # 0x1

    class Operation(object):
        UnknownOperation         : QNetworkAccessManager.Operation = ... # 0x0
        HeadOperation            : QNetworkAccessManager.Operation = ... # 0x1
        GetOperation             : QNetworkAccessManager.Operation = ... # 0x2
        PutOperation             : QNetworkAccessManager.Operation = ... # 0x3
        PostOperation            : QNetworkAccessManager.Operation = ... # 0x4
        DeleteOperation          : QNetworkAccessManager.Operation = ... # 0x5
        CustomOperation          : QNetworkAccessManager.Operation = ... # 0x6

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def activeConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def addStrictTransportSecurityHosts(self, knownHosts:typing.List): ...
    def autoDeleteReplies(self) -> bool: ...
    def cache(self) -> PySide2.QtNetwork.QAbstractNetworkCache: ...
    def clearAccessCache(self): ...
    def clearConnectionCache(self): ...
    def configuration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def connectToHost(self, hostName:str, port:int=...): ...
    @typing.overload
    def connectToHostEncrypted(self, hostName:str, port:int, sslConfiguration:PySide2.QtNetwork.QSslConfiguration, peerName:str): ...
    @typing.overload
    def connectToHostEncrypted(self, hostName:str, port:int=..., sslConfiguration:PySide2.QtNetwork.QSslConfiguration=...): ...
    def cookieJar(self) -> PySide2.QtNetwork.QNetworkCookieJar: ...
    def createRequest(self, op:PySide2.QtNetwork.QNetworkAccessManager.Operation, request:PySide2.QtNetwork.QNetworkRequest, outgoingData:typing.Optional[PySide2.QtCore.QIODevice]=...) -> PySide2.QtNetwork.QNetworkReply: ...
    def deleteResource(self, request:PySide2.QtNetwork.QNetworkRequest) -> PySide2.QtNetwork.QNetworkReply: ...
    def enableStrictTransportSecurityStore(self, enabled:bool, storeDir:str=...): ...
    def get(self, request:PySide2.QtNetwork.QNetworkRequest) -> PySide2.QtNetwork.QNetworkReply: ...
    def head(self, request:PySide2.QtNetwork.QNetworkRequest) -> PySide2.QtNetwork.QNetworkReply: ...
    def isStrictTransportSecurityEnabled(self) -> bool: ...
    def isStrictTransportSecurityStoreEnabled(self) -> bool: ...
    def networkAccessible(self) -> PySide2.QtNetwork.QNetworkAccessManager.NetworkAccessibility: ...
    @typing.overload
    def post(self, request:PySide2.QtNetwork.QNetworkRequest, data:PySide2.QtCore.QByteArray) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def post(self, request:PySide2.QtNetwork.QNetworkRequest, data:PySide2.QtCore.QIODevice) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def post(self, request:PySide2.QtNetwork.QNetworkRequest, multiPart:PySide2.QtNetwork.QHttpMultiPart) -> PySide2.QtNetwork.QNetworkReply: ...
    def proxy(self) -> PySide2.QtNetwork.QNetworkProxy: ...
    def proxyFactory(self) -> PySide2.QtNetwork.QNetworkProxyFactory: ...
    @typing.overload
    def put(self, request:PySide2.QtNetwork.QNetworkRequest, data:PySide2.QtCore.QByteArray) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def put(self, request:PySide2.QtNetwork.QNetworkRequest, data:PySide2.QtCore.QIODevice) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def put(self, request:PySide2.QtNetwork.QNetworkRequest, multiPart:PySide2.QtNetwork.QHttpMultiPart) -> PySide2.QtNetwork.QNetworkReply: ...
    def redirectPolicy(self) -> PySide2.QtNetwork.QNetworkRequest.RedirectPolicy: ...
    @typing.overload
    def sendCustomRequest(self, request:PySide2.QtNetwork.QNetworkRequest, verb:PySide2.QtCore.QByteArray, data:PySide2.QtCore.QByteArray) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def sendCustomRequest(self, request:PySide2.QtNetwork.QNetworkRequest, verb:PySide2.QtCore.QByteArray, data:typing.Optional[PySide2.QtCore.QIODevice]=...) -> PySide2.QtNetwork.QNetworkReply: ...
    @typing.overload
    def sendCustomRequest(self, request:PySide2.QtNetwork.QNetworkRequest, verb:PySide2.QtCore.QByteArray, multiPart:PySide2.QtNetwork.QHttpMultiPart) -> PySide2.QtNetwork.QNetworkReply: ...
    def setAutoDeleteReplies(self, autoDelete:bool): ...
    def setCache(self, cache:PySide2.QtNetwork.QAbstractNetworkCache): ...
    def setConfiguration(self, config:PySide2.QtNetwork.QNetworkConfiguration): ...
    def setCookieJar(self, cookieJar:PySide2.QtNetwork.QNetworkCookieJar): ...
    def setNetworkAccessible(self, accessible:PySide2.QtNetwork.QNetworkAccessManager.NetworkAccessibility): ...
    def setProxy(self, proxy:PySide2.QtNetwork.QNetworkProxy): ...
    def setProxyFactory(self, factory:PySide2.QtNetwork.QNetworkProxyFactory): ...
    def setRedirectPolicy(self, policy:PySide2.QtNetwork.QNetworkRequest.RedirectPolicy): ...
    def setStrictTransportSecurityEnabled(self, enabled:bool): ...
    def strictTransportSecurityHosts(self) -> typing.List: ...
    def supportedSchemes(self) -> typing.List: ...
    def supportedSchemesImplementation(self) -> typing.List: ...


class QNetworkAddressEntry(Shiboken.Object):
    DnsEligibilityUnknown    : QNetworkAddressEntry = ... # -0x1
    DnsIneligible            : QNetworkAddressEntry = ... # 0x0
    DnsEligible              : QNetworkAddressEntry = ... # 0x1

    class DnsEligibilityStatus(object):
        DnsEligibilityUnknown    : QNetworkAddressEntry.DnsEligibilityStatus = ... # -0x1
        DnsIneligible            : QNetworkAddressEntry.DnsEligibilityStatus = ... # 0x0
        DnsEligible              : QNetworkAddressEntry.DnsEligibilityStatus = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QNetworkAddressEntry): ...

    def __copy__(self): ...
    def broadcast(self) -> PySide2.QtNetwork.QHostAddress: ...
    def clearAddressLifetime(self): ...
    def dnsEligibility(self) -> PySide2.QtNetwork.QNetworkAddressEntry.DnsEligibilityStatus: ...
    def ip(self) -> PySide2.QtNetwork.QHostAddress: ...
    def isLifetimeKnown(self) -> bool: ...
    def isPermanent(self) -> bool: ...
    def isTemporary(self) -> bool: ...
    def netmask(self) -> PySide2.QtNetwork.QHostAddress: ...
    def prefixLength(self) -> int: ...
    def setBroadcast(self, newBroadcast:PySide2.QtNetwork.QHostAddress): ...
    def setDnsEligibility(self, status:PySide2.QtNetwork.QNetworkAddressEntry.DnsEligibilityStatus): ...
    def setIp(self, newIp:PySide2.QtNetwork.QHostAddress): ...
    def setNetmask(self, newNetmask:PySide2.QtNetwork.QHostAddress): ...
    def setPrefixLength(self, length:int): ...
    def swap(self, other:PySide2.QtNetwork.QNetworkAddressEntry): ...


class QNetworkCacheMetaData(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QNetworkCacheMetaData): ...

    def __copy__(self): ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def attributes(self) -> typing.Dict: ...
    def expirationDate(self) -> PySide2.QtCore.QDateTime: ...
    def isValid(self) -> bool: ...
    def lastModified(self) -> PySide2.QtCore.QDateTime: ...
    def rawHeaders(self) -> typing.List: ...
    def saveToDisk(self) -> bool: ...
    def setAttributes(self, attributes:typing.Dict): ...
    def setExpirationDate(self, dateTime:PySide2.QtCore.QDateTime): ...
    def setLastModified(self, dateTime:PySide2.QtCore.QDateTime): ...
    def setRawHeaders(self, headers:typing.Sequence): ...
    def setSaveToDisk(self, allow:bool): ...
    def setUrl(self, url:PySide2.QtCore.QUrl): ...
    def swap(self, other:PySide2.QtNetwork.QNetworkCacheMetaData): ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QNetworkConfiguration(Shiboken.Object):
    BearerUnknown            : QNetworkConfiguration = ... # 0x0
    InternetAccessPoint      : QNetworkConfiguration = ... # 0x0
    UnknownPurpose           : QNetworkConfiguration = ... # 0x0
    BearerEthernet           : QNetworkConfiguration = ... # 0x1
    PublicPurpose            : QNetworkConfiguration = ... # 0x1
    ServiceNetwork           : QNetworkConfiguration = ... # 0x1
    Undefined                : QNetworkConfiguration = ... # 0x1
    BearerWLAN               : QNetworkConfiguration = ... # 0x2
    Defined                  : QNetworkConfiguration = ... # 0x2
    PrivatePurpose           : QNetworkConfiguration = ... # 0x2
    UserChoice               : QNetworkConfiguration = ... # 0x2
    Bearer2G                 : QNetworkConfiguration = ... # 0x3
    Invalid                  : QNetworkConfiguration = ... # 0x3
    ServiceSpecificPurpose   : QNetworkConfiguration = ... # 0x3
    BearerCDMA2000           : QNetworkConfiguration = ... # 0x4
    BearerWCDMA              : QNetworkConfiguration = ... # 0x5
    BearerHSPA               : QNetworkConfiguration = ... # 0x6
    Discovered               : QNetworkConfiguration = ... # 0x6
    BearerBluetooth          : QNetworkConfiguration = ... # 0x7
    BearerWiMAX              : QNetworkConfiguration = ... # 0x8
    BearerEVDO               : QNetworkConfiguration = ... # 0x9
    BearerLTE                : QNetworkConfiguration = ... # 0xa
    Bearer3G                 : QNetworkConfiguration = ... # 0xb
    Bearer4G                 : QNetworkConfiguration = ... # 0xc
    Active                   : QNetworkConfiguration = ... # 0xe

    class BearerType(object):
        BearerUnknown            : QNetworkConfiguration.BearerType = ... # 0x0
        BearerEthernet           : QNetworkConfiguration.BearerType = ... # 0x1
        BearerWLAN               : QNetworkConfiguration.BearerType = ... # 0x2
        Bearer2G                 : QNetworkConfiguration.BearerType = ... # 0x3
        BearerCDMA2000           : QNetworkConfiguration.BearerType = ... # 0x4
        BearerWCDMA              : QNetworkConfiguration.BearerType = ... # 0x5
        BearerHSPA               : QNetworkConfiguration.BearerType = ... # 0x6
        BearerBluetooth          : QNetworkConfiguration.BearerType = ... # 0x7
        BearerWiMAX              : QNetworkConfiguration.BearerType = ... # 0x8
        BearerEVDO               : QNetworkConfiguration.BearerType = ... # 0x9
        BearerLTE                : QNetworkConfiguration.BearerType = ... # 0xa
        Bearer3G                 : QNetworkConfiguration.BearerType = ... # 0xb
        Bearer4G                 : QNetworkConfiguration.BearerType = ... # 0xc

    class Purpose(object):
        UnknownPurpose           : QNetworkConfiguration.Purpose = ... # 0x0
        PublicPurpose            : QNetworkConfiguration.Purpose = ... # 0x1
        PrivatePurpose           : QNetworkConfiguration.Purpose = ... # 0x2
        ServiceSpecificPurpose   : QNetworkConfiguration.Purpose = ... # 0x3

    class StateFlag(object):
        Undefined                : QNetworkConfiguration.StateFlag = ... # 0x1
        Defined                  : QNetworkConfiguration.StateFlag = ... # 0x2
        Discovered               : QNetworkConfiguration.StateFlag = ... # 0x6
        Active                   : QNetworkConfiguration.StateFlag = ... # 0xe

    class StateFlags(object): ...

    class Type(object):
        InternetAccessPoint      : QNetworkConfiguration.Type = ... # 0x0
        ServiceNetwork           : QNetworkConfiguration.Type = ... # 0x1
        UserChoice               : QNetworkConfiguration.Type = ... # 0x2
        Invalid                  : QNetworkConfiguration.Type = ... # 0x3

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QNetworkConfiguration): ...

    def __copy__(self): ...
    def bearerType(self) -> PySide2.QtNetwork.QNetworkConfiguration.BearerType: ...
    def bearerTypeFamily(self) -> PySide2.QtNetwork.QNetworkConfiguration.BearerType: ...
    def bearerTypeName(self) -> str: ...
    def children(self) -> typing.List: ...
    def connectTimeout(self) -> int: ...
    def identifier(self) -> str: ...
    def isRoamingAvailable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def purpose(self) -> PySide2.QtNetwork.QNetworkConfiguration.Purpose: ...
    def setConnectTimeout(self, timeout:int) -> bool: ...
    def state(self) -> PySide2.QtNetwork.QNetworkConfiguration.StateFlags: ...
    def swap(self, other:PySide2.QtNetwork.QNetworkConfiguration): ...
    def type(self) -> PySide2.QtNetwork.QNetworkConfiguration.Type: ...


class QNetworkConfigurationManager(PySide2.QtCore.QObject):
    CanStartAndStopInterfaces: QNetworkConfigurationManager = ... # 0x1
    DirectConnectionRouting  : QNetworkConfigurationManager = ... # 0x2
    SystemSessionSupport     : QNetworkConfigurationManager = ... # 0x4
    ApplicationLevelRoaming  : QNetworkConfigurationManager = ... # 0x8
    ForcedRoaming            : QNetworkConfigurationManager = ... # 0x10
    DataStatistics           : QNetworkConfigurationManager = ... # 0x20
    NetworkSessionRequired   : QNetworkConfigurationManager = ... # 0x40

    class Capabilities(object): ...

    class Capability(object):
        CanStartAndStopInterfaces: QNetworkConfigurationManager.Capability = ... # 0x1
        DirectConnectionRouting  : QNetworkConfigurationManager.Capability = ... # 0x2
        SystemSessionSupport     : QNetworkConfigurationManager.Capability = ... # 0x4
        ApplicationLevelRoaming  : QNetworkConfigurationManager.Capability = ... # 0x8
        ForcedRoaming            : QNetworkConfigurationManager.Capability = ... # 0x10
        DataStatistics           : QNetworkConfigurationManager.Capability = ... # 0x20
        NetworkSessionRequired   : QNetworkConfigurationManager.Capability = ... # 0x40

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def allConfigurations(self, flags:PySide2.QtNetwork.QNetworkConfiguration.StateFlags=...) -> typing.List: ...
    def capabilities(self) -> PySide2.QtNetwork.QNetworkConfigurationManager.Capabilities: ...
    def configurationFromIdentifier(self, identifier:str) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def defaultConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def isOnline(self) -> bool: ...
    def updateConfigurations(self): ...


class QNetworkCookie(Shiboken.Object):
    NameAndValueOnly         : QNetworkCookie = ... # 0x0
    Full                     : QNetworkCookie = ... # 0x1

    class RawForm(object):
        NameAndValueOnly         : QNetworkCookie.RawForm = ... # 0x0
        Full                     : QNetworkCookie.RawForm = ... # 0x1

    @typing.overload
    def __init__(self, name:PySide2.QtCore.QByteArray=..., value:PySide2.QtCore.QByteArray=...): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QNetworkCookie): ...

    def __copy__(self): ...
    def domain(self) -> str: ...
    def expirationDate(self) -> PySide2.QtCore.QDateTime: ...
    def hasSameIdentifier(self, other:PySide2.QtNetwork.QNetworkCookie) -> bool: ...
    def isHttpOnly(self) -> bool: ...
    def isSecure(self) -> bool: ...
    def isSessionCookie(self) -> bool: ...
    def name(self) -> PySide2.QtCore.QByteArray: ...
    def normalize(self, url:PySide2.QtCore.QUrl): ...
    @staticmethod
    def parseCookies(cookieString:PySide2.QtCore.QByteArray) -> typing.List: ...
    def path(self) -> str: ...
    def setDomain(self, domain:str): ...
    def setExpirationDate(self, date:PySide2.QtCore.QDateTime): ...
    def setHttpOnly(self, enable:bool): ...
    def setName(self, cookieName:PySide2.QtCore.QByteArray): ...
    def setPath(self, path:str): ...
    def setSecure(self, enable:bool): ...
    def setValue(self, value:PySide2.QtCore.QByteArray): ...
    def swap(self, other:PySide2.QtNetwork.QNetworkCookie): ...
    def toRawForm(self, form:PySide2.QtNetwork.QNetworkCookie.RawForm=...) -> PySide2.QtCore.QByteArray: ...
    def value(self) -> PySide2.QtCore.QByteArray: ...


class QNetworkCookieJar(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def allCookies(self) -> typing.List: ...
    def cookiesForUrl(self, url:PySide2.QtCore.QUrl) -> typing.List: ...
    def deleteCookie(self, cookie:PySide2.QtNetwork.QNetworkCookie) -> bool: ...
    def insertCookie(self, cookie:PySide2.QtNetwork.QNetworkCookie) -> bool: ...
    def setAllCookies(self, cookieList:typing.Sequence): ...
    def setCookiesFromUrl(self, cookieList:typing.Sequence, url:PySide2.QtCore.QUrl) -> bool: ...
    def updateCookie(self, cookie:PySide2.QtNetwork.QNetworkCookie) -> bool: ...
    def validateCookie(self, cookie:PySide2.QtNetwork.QNetworkCookie, url:PySide2.QtCore.QUrl) -> bool: ...


class QNetworkDatagram(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, data:PySide2.QtCore.QByteArray, destinationAddress:PySide2.QtNetwork.QHostAddress=..., port:int=...): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QNetworkDatagram): ...

    def __copy__(self): ...
    def clear(self): ...
    def data(self) -> PySide2.QtCore.QByteArray: ...
    def destinationAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def destinationPort(self) -> int: ...
    def hopLimit(self) -> int: ...
    def interfaceIndex(self) -> int: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeReply(self, payload:PySide2.QtCore.QByteArray) -> PySide2.QtNetwork.QNetworkDatagram: ...
    def senderAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def senderPort(self) -> int: ...
    def setData(self, data:PySide2.QtCore.QByteArray): ...
    def setDestination(self, address:PySide2.QtNetwork.QHostAddress, port:int): ...
    def setHopLimit(self, count:int): ...
    def setInterfaceIndex(self, index:int): ...
    def setSender(self, address:PySide2.QtNetwork.QHostAddress, port:int=...): ...
    def swap(self, other:PySide2.QtNetwork.QNetworkDatagram): ...


class QNetworkDiskCache(PySide2.QtNetwork.QAbstractNetworkCache):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def cacheDirectory(self) -> str: ...
    def cacheSize(self) -> int: ...
    def clear(self): ...
    def data(self, url:PySide2.QtCore.QUrl) -> PySide2.QtCore.QIODevice: ...
    def expire(self) -> int: ...
    def fileMetaData(self, fileName:str) -> PySide2.QtNetwork.QNetworkCacheMetaData: ...
    def insert(self, device:PySide2.QtCore.QIODevice): ...
    def maximumCacheSize(self) -> int: ...
    def metaData(self, url:PySide2.QtCore.QUrl) -> PySide2.QtNetwork.QNetworkCacheMetaData: ...
    def prepare(self, metaData:PySide2.QtNetwork.QNetworkCacheMetaData) -> PySide2.QtCore.QIODevice: ...
    def remove(self, url:PySide2.QtCore.QUrl) -> bool: ...
    def setCacheDirectory(self, cacheDir:str): ...
    def setMaximumCacheSize(self, size:int): ...
    def updateMetaData(self, metaData:PySide2.QtNetwork.QNetworkCacheMetaData): ...


class QNetworkInterface(Shiboken.Object):
    Unknown                  : QNetworkInterface = ... # 0x0
    IsUp                     : QNetworkInterface = ... # 0x1
    Loopback                 : QNetworkInterface = ... # 0x1
    IsRunning                : QNetworkInterface = ... # 0x2
    Virtual                  : QNetworkInterface = ... # 0x2
    Ethernet                 : QNetworkInterface = ... # 0x3
    CanBroadcast             : QNetworkInterface = ... # 0x4
    Slip                     : QNetworkInterface = ... # 0x4
    CanBus                   : QNetworkInterface = ... # 0x5
    Ppp                      : QNetworkInterface = ... # 0x6
    Fddi                     : QNetworkInterface = ... # 0x7
    Ieee80211                : QNetworkInterface = ... # 0x8
    IsLoopBack               : QNetworkInterface = ... # 0x8
    Wifi                     : QNetworkInterface = ... # 0x8
    Phonet                   : QNetworkInterface = ... # 0x9
    Ieee802154               : QNetworkInterface = ... # 0xa
    SixLoWPAN                : QNetworkInterface = ... # 0xb
    Ieee80216                : QNetworkInterface = ... # 0xc
    Ieee1394                 : QNetworkInterface = ... # 0xd
    IsPointToPoint           : QNetworkInterface = ... # 0x10
    CanMulticast             : QNetworkInterface = ... # 0x20

    class InterfaceFlag(object):
        IsUp                     : QNetworkInterface.InterfaceFlag = ... # 0x1
        IsRunning                : QNetworkInterface.InterfaceFlag = ... # 0x2
        CanBroadcast             : QNetworkInterface.InterfaceFlag = ... # 0x4
        IsLoopBack               : QNetworkInterface.InterfaceFlag = ... # 0x8
        IsPointToPoint           : QNetworkInterface.InterfaceFlag = ... # 0x10
        CanMulticast             : QNetworkInterface.InterfaceFlag = ... # 0x20

    class InterfaceFlags(object): ...

    class InterfaceType(object):
        Unknown                  : QNetworkInterface.InterfaceType = ... # 0x0
        Loopback                 : QNetworkInterface.InterfaceType = ... # 0x1
        Virtual                  : QNetworkInterface.InterfaceType = ... # 0x2
        Ethernet                 : QNetworkInterface.InterfaceType = ... # 0x3
        Slip                     : QNetworkInterface.InterfaceType = ... # 0x4
        CanBus                   : QNetworkInterface.InterfaceType = ... # 0x5
        Ppp                      : QNetworkInterface.InterfaceType = ... # 0x6
        Fddi                     : QNetworkInterface.InterfaceType = ... # 0x7
        Ieee80211                : QNetworkInterface.InterfaceType = ... # 0x8
        Wifi                     : QNetworkInterface.InterfaceType = ... # 0x8
        Phonet                   : QNetworkInterface.InterfaceType = ... # 0x9
        Ieee802154               : QNetworkInterface.InterfaceType = ... # 0xa
        SixLoWPAN                : QNetworkInterface.InterfaceType = ... # 0xb
        Ieee80216                : QNetworkInterface.InterfaceType = ... # 0xc
        Ieee1394                 : QNetworkInterface.InterfaceType = ... # 0xd

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QNetworkInterface): ...

    def __copy__(self): ...
    def addressEntries(self) -> typing.List: ...
    @staticmethod
    def allAddresses() -> typing.List: ...
    @staticmethod
    def allInterfaces() -> typing.List: ...
    def flags(self) -> PySide2.QtNetwork.QNetworkInterface.InterfaceFlags: ...
    def hardwareAddress(self) -> str: ...
    def humanReadableName(self) -> str: ...
    def index(self) -> int: ...
    @staticmethod
    def interfaceFromIndex(index:int) -> PySide2.QtNetwork.QNetworkInterface: ...
    @staticmethod
    def interfaceFromName(name:str) -> PySide2.QtNetwork.QNetworkInterface: ...
    @staticmethod
    def interfaceIndexFromName(name:str) -> int: ...
    @staticmethod
    def interfaceNameFromIndex(index:int) -> str: ...
    def isValid(self) -> bool: ...
    def maximumTransmissionUnit(self) -> int: ...
    def name(self) -> str: ...
    def swap(self, other:PySide2.QtNetwork.QNetworkInterface): ...
    def type(self) -> PySide2.QtNetwork.QNetworkInterface.InterfaceType: ...


class QNetworkProxy(Shiboken.Object):
    DefaultProxy             : QNetworkProxy = ... # 0x0
    Socks5Proxy              : QNetworkProxy = ... # 0x1
    TunnelingCapability      : QNetworkProxy = ... # 0x1
    ListeningCapability      : QNetworkProxy = ... # 0x2
    NoProxy                  : QNetworkProxy = ... # 0x2
    HttpProxy                : QNetworkProxy = ... # 0x3
    HttpCachingProxy         : QNetworkProxy = ... # 0x4
    UdpTunnelingCapability   : QNetworkProxy = ... # 0x4
    FtpCachingProxy          : QNetworkProxy = ... # 0x5
    CachingCapability        : QNetworkProxy = ... # 0x8
    HostNameLookupCapability : QNetworkProxy = ... # 0x10
    SctpTunnelingCapability  : QNetworkProxy = ... # 0x20
    SctpListeningCapability  : QNetworkProxy = ... # 0x40

    class Capabilities(object): ...

    class Capability(object):
        TunnelingCapability      : QNetworkProxy.Capability = ... # 0x1
        ListeningCapability      : QNetworkProxy.Capability = ... # 0x2
        UdpTunnelingCapability   : QNetworkProxy.Capability = ... # 0x4
        CachingCapability        : QNetworkProxy.Capability = ... # 0x8
        HostNameLookupCapability : QNetworkProxy.Capability = ... # 0x10
        SctpTunnelingCapability  : QNetworkProxy.Capability = ... # 0x20
        SctpListeningCapability  : QNetworkProxy.Capability = ... # 0x40

    class ProxyType(object):
        DefaultProxy             : QNetworkProxy.ProxyType = ... # 0x0
        Socks5Proxy              : QNetworkProxy.ProxyType = ... # 0x1
        NoProxy                  : QNetworkProxy.ProxyType = ... # 0x2
        HttpProxy                : QNetworkProxy.ProxyType = ... # 0x3
        HttpCachingProxy         : QNetworkProxy.ProxyType = ... # 0x4
        FtpCachingProxy          : QNetworkProxy.ProxyType = ... # 0x5

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QNetworkProxy): ...
    @typing.overload
    def __init__(self, type:PySide2.QtNetwork.QNetworkProxy.ProxyType, hostName:str=..., port:int=..., user:str=..., password:str=...): ...

    def __copy__(self): ...
    @staticmethod
    def applicationProxy() -> PySide2.QtNetwork.QNetworkProxy: ...
    def capabilities(self) -> PySide2.QtNetwork.QNetworkProxy.Capabilities: ...
    def hasRawHeader(self, headerName:PySide2.QtCore.QByteArray) -> bool: ...
    def header(self, header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders) -> typing.Any: ...
    def hostName(self) -> str: ...
    def isCachingProxy(self) -> bool: ...
    def isTransparentProxy(self) -> bool: ...
    def password(self) -> str: ...
    def port(self) -> int: ...
    def rawHeader(self, headerName:PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List: ...
    @staticmethod
    def setApplicationProxy(proxy:PySide2.QtNetwork.QNetworkProxy): ...
    def setCapabilities(self, capab:PySide2.QtNetwork.QNetworkProxy.Capabilities): ...
    def setHeader(self, header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders, value:typing.Any): ...
    def setHostName(self, hostName:str): ...
    def setPassword(self, password:str): ...
    def setPort(self, port:int): ...
    def setRawHeader(self, headerName:PySide2.QtCore.QByteArray, value:PySide2.QtCore.QByteArray): ...
    def setType(self, type:PySide2.QtNetwork.QNetworkProxy.ProxyType): ...
    def setUser(self, userName:str): ...
    def swap(self, other:PySide2.QtNetwork.QNetworkProxy): ...
    def type(self) -> PySide2.QtNetwork.QNetworkProxy.ProxyType: ...
    def user(self) -> str: ...


class QNetworkProxyFactory(Shiboken.Object):

    def __init__(self): ...

    @staticmethod
    def proxyForQuery(query:PySide2.QtNetwork.QNetworkProxyQuery) -> typing.List: ...
    def queryProxy(self, query:PySide2.QtNetwork.QNetworkProxyQuery=...) -> typing.List: ...
    @staticmethod
    def setApplicationProxyFactory(factory:PySide2.QtNetwork.QNetworkProxyFactory): ...
    @staticmethod
    def setUseSystemConfiguration(enable:bool): ...
    @staticmethod
    def systemProxyForQuery(query:PySide2.QtNetwork.QNetworkProxyQuery=...) -> typing.List: ...
    @staticmethod
    def usesSystemConfiguration() -> bool: ...


class QNetworkProxyQuery(Shiboken.Object):
    TcpSocket                : QNetworkProxyQuery = ... # 0x0
    UdpSocket                : QNetworkProxyQuery = ... # 0x1
    SctpSocket               : QNetworkProxyQuery = ... # 0x2
    TcpServer                : QNetworkProxyQuery = ... # 0x64
    UrlRequest               : QNetworkProxyQuery = ... # 0x65
    SctpServer               : QNetworkProxyQuery = ... # 0x66

    class QueryType(object):
        TcpSocket                : QNetworkProxyQuery.QueryType = ... # 0x0
        UdpSocket                : QNetworkProxyQuery.QueryType = ... # 0x1
        SctpSocket               : QNetworkProxyQuery.QueryType = ... # 0x2
        TcpServer                : QNetworkProxyQuery.QueryType = ... # 0x64
        UrlRequest               : QNetworkProxyQuery.QueryType = ... # 0x65
        SctpServer               : QNetworkProxyQuery.QueryType = ... # 0x66

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, bindPort:int, protocolTag:str=..., queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=...): ...
    @typing.overload
    def __init__(self, hostname:str, port:int, protocolTag:str=..., queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=...): ...
    @typing.overload
    def __init__(self, networkConfiguration:PySide2.QtNetwork.QNetworkConfiguration, bindPort:int, protocolTag:str=..., queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=...): ...
    @typing.overload
    def __init__(self, networkConfiguration:PySide2.QtNetwork.QNetworkConfiguration, hostname:str, port:int, protocolTag:str=..., queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=...): ...
    @typing.overload
    def __init__(self, networkConfiguration:PySide2.QtNetwork.QNetworkConfiguration, requestUrl:PySide2.QtCore.QUrl, queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=...): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QNetworkProxyQuery): ...
    @typing.overload
    def __init__(self, requestUrl:PySide2.QtCore.QUrl, queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=...): ...

    def __copy__(self): ...
    def localPort(self) -> int: ...
    def networkConfiguration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def peerHostName(self) -> str: ...
    def peerPort(self) -> int: ...
    def protocolTag(self) -> str: ...
    def queryType(self) -> PySide2.QtNetwork.QNetworkProxyQuery.QueryType: ...
    def setLocalPort(self, port:int): ...
    def setNetworkConfiguration(self, networkConfiguration:PySide2.QtNetwork.QNetworkConfiguration): ...
    def setPeerHostName(self, hostname:str): ...
    def setPeerPort(self, port:int): ...
    def setProtocolTag(self, protocolTag:str): ...
    def setQueryType(self, type:PySide2.QtNetwork.QNetworkProxyQuery.QueryType): ...
    def setUrl(self, url:PySide2.QtCore.QUrl): ...
    def swap(self, other:PySide2.QtNetwork.QNetworkProxyQuery): ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QNetworkReply(PySide2.QtCore.QIODevice):
    NoError                  : QNetworkReply = ... # 0x0
    ConnectionRefusedError   : QNetworkReply = ... # 0x1
    RemoteHostClosedError    : QNetworkReply = ... # 0x2
    HostNotFoundError        : QNetworkReply = ... # 0x3
    TimeoutError             : QNetworkReply = ... # 0x4
    OperationCanceledError   : QNetworkReply = ... # 0x5
    SslHandshakeFailedError  : QNetworkReply = ... # 0x6
    TemporaryNetworkFailureError: QNetworkReply = ... # 0x7
    NetworkSessionFailedError: QNetworkReply = ... # 0x8
    BackgroundRequestNotAllowedError: QNetworkReply = ... # 0x9
    TooManyRedirectsError    : QNetworkReply = ... # 0xa
    InsecureRedirectError    : QNetworkReply = ... # 0xb
    UnknownNetworkError      : QNetworkReply = ... # 0x63
    ProxyConnectionRefusedError: QNetworkReply = ... # 0x65
    ProxyConnectionClosedError: QNetworkReply = ... # 0x66
    ProxyNotFoundError       : QNetworkReply = ... # 0x67
    ProxyTimeoutError        : QNetworkReply = ... # 0x68
    ProxyAuthenticationRequiredError: QNetworkReply = ... # 0x69
    UnknownProxyError        : QNetworkReply = ... # 0xc7
    ContentAccessDenied      : QNetworkReply = ... # 0xc9
    ContentOperationNotPermittedError: QNetworkReply = ... # 0xca
    ContentNotFoundError     : QNetworkReply = ... # 0xcb
    AuthenticationRequiredError: QNetworkReply = ... # 0xcc
    ContentReSendError       : QNetworkReply = ... # 0xcd
    ContentConflictError     : QNetworkReply = ... # 0xce
    ContentGoneError         : QNetworkReply = ... # 0xcf
    UnknownContentError      : QNetworkReply = ... # 0x12b
    ProtocolUnknownError     : QNetworkReply = ... # 0x12d
    ProtocolInvalidOperationError: QNetworkReply = ... # 0x12e
    ProtocolFailure          : QNetworkReply = ... # 0x18f
    InternalServerError      : QNetworkReply = ... # 0x191
    OperationNotImplementedError: QNetworkReply = ... # 0x192
    ServiceUnavailableError  : QNetworkReply = ... # 0x193
    UnknownServerError       : QNetworkReply = ... # 0x1f3

    class NetworkError(object):
        NoError                  : QNetworkReply.NetworkError = ... # 0x0
        ConnectionRefusedError   : QNetworkReply.NetworkError = ... # 0x1
        RemoteHostClosedError    : QNetworkReply.NetworkError = ... # 0x2
        HostNotFoundError        : QNetworkReply.NetworkError = ... # 0x3
        TimeoutError             : QNetworkReply.NetworkError = ... # 0x4
        OperationCanceledError   : QNetworkReply.NetworkError = ... # 0x5
        SslHandshakeFailedError  : QNetworkReply.NetworkError = ... # 0x6
        TemporaryNetworkFailureError: QNetworkReply.NetworkError = ... # 0x7
        NetworkSessionFailedError: QNetworkReply.NetworkError = ... # 0x8
        BackgroundRequestNotAllowedError: QNetworkReply.NetworkError = ... # 0x9
        TooManyRedirectsError    : QNetworkReply.NetworkError = ... # 0xa
        InsecureRedirectError    : QNetworkReply.NetworkError = ... # 0xb
        UnknownNetworkError      : QNetworkReply.NetworkError = ... # 0x63
        ProxyConnectionRefusedError: QNetworkReply.NetworkError = ... # 0x65
        ProxyConnectionClosedError: QNetworkReply.NetworkError = ... # 0x66
        ProxyNotFoundError       : QNetworkReply.NetworkError = ... # 0x67
        ProxyTimeoutError        : QNetworkReply.NetworkError = ... # 0x68
        ProxyAuthenticationRequiredError: QNetworkReply.NetworkError = ... # 0x69
        UnknownProxyError        : QNetworkReply.NetworkError = ... # 0xc7
        ContentAccessDenied      : QNetworkReply.NetworkError = ... # 0xc9
        ContentOperationNotPermittedError: QNetworkReply.NetworkError = ... # 0xca
        ContentNotFoundError     : QNetworkReply.NetworkError = ... # 0xcb
        AuthenticationRequiredError: QNetworkReply.NetworkError = ... # 0xcc
        ContentReSendError       : QNetworkReply.NetworkError = ... # 0xcd
        ContentConflictError     : QNetworkReply.NetworkError = ... # 0xce
        ContentGoneError         : QNetworkReply.NetworkError = ... # 0xcf
        UnknownContentError      : QNetworkReply.NetworkError = ... # 0x12b
        ProtocolUnknownError     : QNetworkReply.NetworkError = ... # 0x12d
        ProtocolInvalidOperationError: QNetworkReply.NetworkError = ... # 0x12e
        ProtocolFailure          : QNetworkReply.NetworkError = ... # 0x18f
        InternalServerError      : QNetworkReply.NetworkError = ... # 0x191
        OperationNotImplementedError: QNetworkReply.NetworkError = ... # 0x192
        ServiceUnavailableError  : QNetworkReply.NetworkError = ... # 0x193
        UnknownServerError       : QNetworkReply.NetworkError = ... # 0x1f3

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def abort(self): ...
    def attribute(self, code:PySide2.QtNetwork.QNetworkRequest.Attribute) -> typing.Any: ...
    def close(self): ...
    def error(self) -> PySide2.QtNetwork.QNetworkReply.NetworkError: ...
    def hasRawHeader(self, headerName:PySide2.QtCore.QByteArray) -> bool: ...
    def header(self, header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders) -> typing.Any: ...
    @typing.overload
    def ignoreSslErrors(self): ...
    @typing.overload
    def ignoreSslErrors(self, errors:typing.Sequence): ...
    def ignoreSslErrorsImplementation(self, arg__1:typing.Sequence): ...
    def isFinished(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def manager(self) -> PySide2.QtNetwork.QNetworkAccessManager: ...
    def operation(self) -> PySide2.QtNetwork.QNetworkAccessManager.Operation: ...
    def rawHeader(self, headerName:PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List: ...
    def rawHeaderPairs(self) -> typing.List: ...
    def readBufferSize(self) -> int: ...
    def request(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def setAttribute(self, code:PySide2.QtNetwork.QNetworkRequest.Attribute, value:typing.Any): ...
    def setError(self, errorCode:PySide2.QtNetwork.QNetworkReply.NetworkError, errorString:str): ...
    def setFinished(self, arg__1:bool): ...
    def setHeader(self, header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders, value:typing.Any): ...
    def setOperation(self, operation:PySide2.QtNetwork.QNetworkAccessManager.Operation): ...
    def setRawHeader(self, headerName:PySide2.QtCore.QByteArray, value:PySide2.QtCore.QByteArray): ...
    def setReadBufferSize(self, size:int): ...
    def setRequest(self, request:PySide2.QtNetwork.QNetworkRequest): ...
    def setSslConfiguration(self, configuration:PySide2.QtNetwork.QSslConfiguration): ...
    def setSslConfigurationImplementation(self, arg__1:PySide2.QtNetwork.QSslConfiguration): ...
    def setUrl(self, url:PySide2.QtCore.QUrl): ...
    def sslConfiguration(self) -> PySide2.QtNetwork.QSslConfiguration: ...
    def sslConfigurationImplementation(self, arg__1:PySide2.QtNetwork.QSslConfiguration): ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def writeData(self, data:bytes, len:int) -> int: ...


class QNetworkRequest(Shiboken.Object):
    AlwaysNetwork            : QNetworkRequest = ... # 0x0
    Automatic                : QNetworkRequest = ... # 0x0
    ContentTypeHeader        : QNetworkRequest = ... # 0x0
    HttpStatusCodeAttribute  : QNetworkRequest = ... # 0x0
    ManualRedirectPolicy     : QNetworkRequest = ... # 0x0
    ContentLengthHeader      : QNetworkRequest = ... # 0x1
    HighPriority             : QNetworkRequest = ... # 0x1
    HttpReasonPhraseAttribute: QNetworkRequest = ... # 0x1
    Manual                   : QNetworkRequest = ... # 0x1
    NoLessSafeRedirectPolicy : QNetworkRequest = ... # 0x1
    PreferNetwork            : QNetworkRequest = ... # 0x1
    LocationHeader           : QNetworkRequest = ... # 0x2
    PreferCache              : QNetworkRequest = ... # 0x2
    RedirectionTargetAttribute: QNetworkRequest = ... # 0x2
    SameOriginRedirectPolicy : QNetworkRequest = ... # 0x2
    AlwaysCache              : QNetworkRequest = ... # 0x3
    ConnectionEncryptedAttribute: QNetworkRequest = ... # 0x3
    LastModifiedHeader       : QNetworkRequest = ... # 0x3
    NormalPriority           : QNetworkRequest = ... # 0x3
    UserVerifiedRedirectPolicy: QNetworkRequest = ... # 0x3
    CacheLoadControlAttribute: QNetworkRequest = ... # 0x4
    CookieHeader             : QNetworkRequest = ... # 0x4
    CacheSaveControlAttribute: QNetworkRequest = ... # 0x5
    LowPriority              : QNetworkRequest = ... # 0x5
    SetCookieHeader          : QNetworkRequest = ... # 0x5
    ContentDispositionHeader : QNetworkRequest = ... # 0x6
    SourceIsFromCacheAttribute: QNetworkRequest = ... # 0x6
    DoNotBufferUploadDataAttribute: QNetworkRequest = ... # 0x7
    UserAgentHeader          : QNetworkRequest = ... # 0x7
    HttpPipeliningAllowedAttribute: QNetworkRequest = ... # 0x8
    ServerHeader             : QNetworkRequest = ... # 0x8
    HttpPipeliningWasUsedAttribute: QNetworkRequest = ... # 0x9
    IfModifiedSinceHeader    : QNetworkRequest = ... # 0x9
    CustomVerbAttribute      : QNetworkRequest = ... # 0xa
    ETagHeader               : QNetworkRequest = ... # 0xa
    CookieLoadControlAttribute: QNetworkRequest = ... # 0xb
    IfMatchHeader            : QNetworkRequest = ... # 0xb
    AuthenticationReuseAttribute: QNetworkRequest = ... # 0xc
    IfNoneMatchHeader        : QNetworkRequest = ... # 0xc
    CookieSaveControlAttribute: QNetworkRequest = ... # 0xd
    MaximumDownloadBufferSizeAttribute: QNetworkRequest = ... # 0xe
    DownloadBufferAttribute  : QNetworkRequest = ... # 0xf
    SynchronousRequestAttribute: QNetworkRequest = ... # 0x10
    BackgroundRequestAttribute: QNetworkRequest = ... # 0x11
    SpdyAllowedAttribute     : QNetworkRequest = ... # 0x12
    SpdyWasUsedAttribute     : QNetworkRequest = ... # 0x13
    EmitAllUploadProgressSignalsAttribute: QNetworkRequest = ... # 0x14
    FollowRedirectsAttribute : QNetworkRequest = ... # 0x15
    HTTP2AllowedAttribute    : QNetworkRequest = ... # 0x16
    HTTP2WasUsedAttribute    : QNetworkRequest = ... # 0x17
    OriginalContentLengthAttribute: QNetworkRequest = ... # 0x18
    RedirectPolicyAttribute  : QNetworkRequest = ... # 0x19
    Http2DirectAttribute     : QNetworkRequest = ... # 0x1a
    ResourceTypeAttribute    : QNetworkRequest = ... # 0x1b
    AutoDeleteReplyOnFinishAttribute: QNetworkRequest = ... # 0x1c
    User                     : QNetworkRequest = ... # 0x3e8
    UserMax                  : QNetworkRequest = ... # 0x7fff

    class Attribute(object):
        HttpStatusCodeAttribute  : QNetworkRequest.Attribute = ... # 0x0
        HttpReasonPhraseAttribute: QNetworkRequest.Attribute = ... # 0x1
        RedirectionTargetAttribute: QNetworkRequest.Attribute = ... # 0x2
        ConnectionEncryptedAttribute: QNetworkRequest.Attribute = ... # 0x3
        CacheLoadControlAttribute: QNetworkRequest.Attribute = ... # 0x4
        CacheSaveControlAttribute: QNetworkRequest.Attribute = ... # 0x5
        SourceIsFromCacheAttribute: QNetworkRequest.Attribute = ... # 0x6
        DoNotBufferUploadDataAttribute: QNetworkRequest.Attribute = ... # 0x7
        HttpPipeliningAllowedAttribute: QNetworkRequest.Attribute = ... # 0x8
        HttpPipeliningWasUsedAttribute: QNetworkRequest.Attribute = ... # 0x9
        CustomVerbAttribute      : QNetworkRequest.Attribute = ... # 0xa
        CookieLoadControlAttribute: QNetworkRequest.Attribute = ... # 0xb
        AuthenticationReuseAttribute: QNetworkRequest.Attribute = ... # 0xc
        CookieSaveControlAttribute: QNetworkRequest.Attribute = ... # 0xd
        MaximumDownloadBufferSizeAttribute: QNetworkRequest.Attribute = ... # 0xe
        DownloadBufferAttribute  : QNetworkRequest.Attribute = ... # 0xf
        SynchronousRequestAttribute: QNetworkRequest.Attribute = ... # 0x10
        BackgroundRequestAttribute: QNetworkRequest.Attribute = ... # 0x11
        SpdyAllowedAttribute     : QNetworkRequest.Attribute = ... # 0x12
        SpdyWasUsedAttribute     : QNetworkRequest.Attribute = ... # 0x13
        EmitAllUploadProgressSignalsAttribute: QNetworkRequest.Attribute = ... # 0x14
        FollowRedirectsAttribute : QNetworkRequest.Attribute = ... # 0x15
        HTTP2AllowedAttribute    : QNetworkRequest.Attribute = ... # 0x16
        HTTP2WasUsedAttribute    : QNetworkRequest.Attribute = ... # 0x17
        OriginalContentLengthAttribute: QNetworkRequest.Attribute = ... # 0x18
        RedirectPolicyAttribute  : QNetworkRequest.Attribute = ... # 0x19
        Http2DirectAttribute     : QNetworkRequest.Attribute = ... # 0x1a
        ResourceTypeAttribute    : QNetworkRequest.Attribute = ... # 0x1b
        AutoDeleteReplyOnFinishAttribute: QNetworkRequest.Attribute = ... # 0x1c
        User                     : QNetworkRequest.Attribute = ... # 0x3e8
        UserMax                  : QNetworkRequest.Attribute = ... # 0x7fff

    class CacheLoadControl(object):
        AlwaysNetwork            : QNetworkRequest.CacheLoadControl = ... # 0x0
        PreferNetwork            : QNetworkRequest.CacheLoadControl = ... # 0x1
        PreferCache              : QNetworkRequest.CacheLoadControl = ... # 0x2
        AlwaysCache              : QNetworkRequest.CacheLoadControl = ... # 0x3

    class KnownHeaders(object):
        ContentTypeHeader        : QNetworkRequest.KnownHeaders = ... # 0x0
        ContentLengthHeader      : QNetworkRequest.KnownHeaders = ... # 0x1
        LocationHeader           : QNetworkRequest.KnownHeaders = ... # 0x2
        LastModifiedHeader       : QNetworkRequest.KnownHeaders = ... # 0x3
        CookieHeader             : QNetworkRequest.KnownHeaders = ... # 0x4
        SetCookieHeader          : QNetworkRequest.KnownHeaders = ... # 0x5
        ContentDispositionHeader : QNetworkRequest.KnownHeaders = ... # 0x6
        UserAgentHeader          : QNetworkRequest.KnownHeaders = ... # 0x7
        ServerHeader             : QNetworkRequest.KnownHeaders = ... # 0x8
        IfModifiedSinceHeader    : QNetworkRequest.KnownHeaders = ... # 0x9
        ETagHeader               : QNetworkRequest.KnownHeaders = ... # 0xa
        IfMatchHeader            : QNetworkRequest.KnownHeaders = ... # 0xb
        IfNoneMatchHeader        : QNetworkRequest.KnownHeaders = ... # 0xc

    class LoadControl(object):
        Automatic                : QNetworkRequest.LoadControl = ... # 0x0
        Manual                   : QNetworkRequest.LoadControl = ... # 0x1

    class Priority(object):
        HighPriority             : QNetworkRequest.Priority = ... # 0x1
        NormalPriority           : QNetworkRequest.Priority = ... # 0x3
        LowPriority              : QNetworkRequest.Priority = ... # 0x5

    class RedirectPolicy(object):
        ManualRedirectPolicy     : QNetworkRequest.RedirectPolicy = ... # 0x0
        NoLessSafeRedirectPolicy : QNetworkRequest.RedirectPolicy = ... # 0x1
        SameOriginRedirectPolicy : QNetworkRequest.RedirectPolicy = ... # 0x2
        UserVerifiedRedirectPolicy: QNetworkRequest.RedirectPolicy = ... # 0x3

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QNetworkRequest): ...
    @typing.overload
    def __init__(self, url:PySide2.QtCore.QUrl): ...

    def __copy__(self): ...
    def attribute(self, code:PySide2.QtNetwork.QNetworkRequest.Attribute, defaultValue:typing.Any=...) -> typing.Any: ...
    def hasRawHeader(self, headerName:PySide2.QtCore.QByteArray) -> bool: ...
    def header(self, header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders) -> typing.Any: ...
    def maximumRedirectsAllowed(self) -> int: ...
    def originatingObject(self) -> PySide2.QtCore.QObject: ...
    def peerVerifyName(self) -> str: ...
    def priority(self) -> PySide2.QtNetwork.QNetworkRequest.Priority: ...
    def rawHeader(self, headerName:PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List: ...
    def setAttribute(self, code:PySide2.QtNetwork.QNetworkRequest.Attribute, value:typing.Any): ...
    def setHeader(self, header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders, value:typing.Any): ...
    def setMaximumRedirectsAllowed(self, maximumRedirectsAllowed:int): ...
    def setOriginatingObject(self, object:PySide2.QtCore.QObject): ...
    def setPeerVerifyName(self, peerName:str): ...
    def setPriority(self, priority:PySide2.QtNetwork.QNetworkRequest.Priority): ...
    def setRawHeader(self, headerName:PySide2.QtCore.QByteArray, value:PySide2.QtCore.QByteArray): ...
    def setSslConfiguration(self, configuration:PySide2.QtNetwork.QSslConfiguration): ...
    def setUrl(self, url:PySide2.QtCore.QUrl): ...
    def sslConfiguration(self) -> PySide2.QtNetwork.QSslConfiguration: ...
    def swap(self, other:PySide2.QtNetwork.QNetworkRequest): ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QNetworkSession(PySide2.QtCore.QObject):
    Invalid                  : QNetworkSession = ... # 0x0
    NoPolicy                 : QNetworkSession = ... # 0x0
    UnknownSessionError      : QNetworkSession = ... # 0x0
    NoBackgroundTrafficPolicy: QNetworkSession = ... # 0x1
    NotAvailable             : QNetworkSession = ... # 0x1
    SessionAbortedError      : QNetworkSession = ... # 0x1
    Connecting               : QNetworkSession = ... # 0x2
    RoamingError             : QNetworkSession = ... # 0x2
    Connected                : QNetworkSession = ... # 0x3
    OperationNotSupportedError: QNetworkSession = ... # 0x3
    Closing                  : QNetworkSession = ... # 0x4
    InvalidConfigurationError: QNetworkSession = ... # 0x4
    Disconnected             : QNetworkSession = ... # 0x5
    Roaming                  : QNetworkSession = ... # 0x6

    class SessionError(object):
        UnknownSessionError      : QNetworkSession.SessionError = ... # 0x0
        SessionAbortedError      : QNetworkSession.SessionError = ... # 0x1
        RoamingError             : QNetworkSession.SessionError = ... # 0x2
        OperationNotSupportedError: QNetworkSession.SessionError = ... # 0x3
        InvalidConfigurationError: QNetworkSession.SessionError = ... # 0x4

    class State(object):
        Invalid                  : QNetworkSession.State = ... # 0x0
        NotAvailable             : QNetworkSession.State = ... # 0x1
        Connecting               : QNetworkSession.State = ... # 0x2
        Connected                : QNetworkSession.State = ... # 0x3
        Closing                  : QNetworkSession.State = ... # 0x4
        Disconnected             : QNetworkSession.State = ... # 0x5
        Roaming                  : QNetworkSession.State = ... # 0x6

    class UsagePolicies(object): ...

    class UsagePolicy(object):
        NoPolicy                 : QNetworkSession.UsagePolicy = ... # 0x0
        NoBackgroundTrafficPolicy: QNetworkSession.UsagePolicy = ... # 0x1

    def __init__(self, connConfig:PySide2.QtNetwork.QNetworkConfiguration, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def accept(self): ...
    def activeTime(self) -> int: ...
    def bytesReceived(self) -> int: ...
    def bytesWritten(self) -> int: ...
    def close(self): ...
    def configuration(self) -> PySide2.QtNetwork.QNetworkConfiguration: ...
    def connectNotify(self, signal:PySide2.QtCore.QMetaMethod): ...
    def disconnectNotify(self, signal:PySide2.QtCore.QMetaMethod): ...
    def error(self) -> PySide2.QtNetwork.QNetworkSession.SessionError: ...
    def errorString(self) -> str: ...
    def ignore(self): ...
    def interface(self) -> PySide2.QtNetwork.QNetworkInterface: ...
    def isOpen(self) -> bool: ...
    def migrate(self): ...
    def open(self): ...
    def reject(self): ...
    def sessionProperty(self, key:str) -> typing.Any: ...
    def setSessionProperty(self, key:str, value:typing.Any): ...
    def state(self) -> PySide2.QtNetwork.QNetworkSession.State: ...
    def stop(self): ...
    def usagePolicies(self) -> PySide2.QtNetwork.QNetworkSession.UsagePolicies: ...
    def waitForOpened(self, msecs:int=...) -> bool: ...


class QOcspCertificateStatus(object):
    Good                     : QOcspCertificateStatus = ... # 0x0
    Revoked                  : QOcspCertificateStatus = ... # 0x1
    Unknown                  : QOcspCertificateStatus = ... # 0x2


class QOcspResponse(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QOcspResponse): ...

    def __copy__(self): ...
    def certificateStatus(self) -> PySide2.QtNetwork.QOcspCertificateStatus: ...
    def revocationReason(self) -> PySide2.QtNetwork.QOcspRevocationReason: ...
    def subject(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def swap(self, other:PySide2.QtNetwork.QOcspResponse): ...


class QOcspRevocationReason(object):
    None_                    : QOcspRevocationReason = ... # -0x1
    Unspecified              : QOcspRevocationReason = ... # 0x0
    KeyCompromise            : QOcspRevocationReason = ... # 0x1
    CACompromise             : QOcspRevocationReason = ... # 0x2
    AffiliationChanged       : QOcspRevocationReason = ... # 0x3
    Superseded               : QOcspRevocationReason = ... # 0x4
    CessationOfOperation     : QOcspRevocationReason = ... # 0x5
    CertificateHold          : QOcspRevocationReason = ... # 0x6
    RemoveFromCRL            : QOcspRevocationReason = ... # 0x7


class QPasswordDigestor(Shiboken.Object):
    @staticmethod
    def deriveKeyPbkdf1(algorithm:PySide2.QtCore.QCryptographicHash.Algorithm, password:PySide2.QtCore.QByteArray, salt:PySide2.QtCore.QByteArray, iterations:int, dkLen:int) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def deriveKeyPbkdf2(algorithm:PySide2.QtCore.QCryptographicHash.Algorithm, password:PySide2.QtCore.QByteArray, salt:PySide2.QtCore.QByteArray, iterations:int, dkLen:int) -> PySide2.QtCore.QByteArray: ...


class QSsl(Shiboken.Object):
    UnknownProtocol          : QSsl = ... # -0x1
    EmailEntry               : QSsl = ... # 0x0
    Opaque                   : QSsl = ... # 0x0
    Pem                      : QSsl = ... # 0x0
    PrivateKey               : QSsl = ... # 0x0
    SslV3                    : QSsl = ... # 0x0
    Der                      : QSsl = ... # 0x1
    DnsEntry                 : QSsl = ... # 0x1
    PublicKey                : QSsl = ... # 0x1
    Rsa                      : QSsl = ... # 0x1
    SslOptionDisableEmptyFragments: QSsl = ... # 0x1
    SslV2                    : QSsl = ... # 0x1
    Dsa                      : QSsl = ... # 0x2
    IpAddressEntry           : QSsl = ... # 0x2
    SslOptionDisableSessionTickets: QSsl = ... # 0x2
    TlsV1_0                  : QSsl = ... # 0x2
    Ec                       : QSsl = ... # 0x3
    TlsV1_1                  : QSsl = ... # 0x3
    Dh                       : QSsl = ... # 0x4
    SslOptionDisableCompression: QSsl = ... # 0x4
    TlsV1_2                  : QSsl = ... # 0x4
    AnyProtocol              : QSsl = ... # 0x5
    TlsV1SslV3               : QSsl = ... # 0x6
    SecureProtocols          : QSsl = ... # 0x7
    SslOptionDisableServerNameIndication: QSsl = ... # 0x8
    TlsV1_0OrLater           : QSsl = ... # 0x8
    TlsV1_1OrLater           : QSsl = ... # 0x9
    TlsV1_2OrLater           : QSsl = ... # 0xa
    DtlsV1_0                 : QSsl = ... # 0xb
    DtlsV1_0OrLater          : QSsl = ... # 0xc
    DtlsV1_2                 : QSsl = ... # 0xd
    DtlsV1_2OrLater          : QSsl = ... # 0xe
    TlsV1_3                  : QSsl = ... # 0xf
    SslOptionDisableLegacyRenegotiation: QSsl = ... # 0x10
    TlsV1_3OrLater           : QSsl = ... # 0x10
    SslOptionDisableSessionSharing: QSsl = ... # 0x20
    SslOptionDisableSessionPersistence: QSsl = ... # 0x40
    SslOptionDisableServerCipherPreference: QSsl = ... # 0x80

    class AlternativeNameEntryType(object):
        EmailEntry               : QSsl.AlternativeNameEntryType = ... # 0x0
        DnsEntry                 : QSsl.AlternativeNameEntryType = ... # 0x1
        IpAddressEntry           : QSsl.AlternativeNameEntryType = ... # 0x2

    class EncodingFormat(object):
        Pem                      : QSsl.EncodingFormat = ... # 0x0
        Der                      : QSsl.EncodingFormat = ... # 0x1

    class KeyAlgorithm(object):
        Opaque                   : QSsl.KeyAlgorithm = ... # 0x0
        Rsa                      : QSsl.KeyAlgorithm = ... # 0x1
        Dsa                      : QSsl.KeyAlgorithm = ... # 0x2
        Ec                       : QSsl.KeyAlgorithm = ... # 0x3
        Dh                       : QSsl.KeyAlgorithm = ... # 0x4

    class KeyType(object):
        PrivateKey               : QSsl.KeyType = ... # 0x0
        PublicKey                : QSsl.KeyType = ... # 0x1

    class SslOption(object):
        SslOptionDisableEmptyFragments: QSsl.SslOption = ... # 0x1
        SslOptionDisableSessionTickets: QSsl.SslOption = ... # 0x2
        SslOptionDisableCompression: QSsl.SslOption = ... # 0x4
        SslOptionDisableServerNameIndication: QSsl.SslOption = ... # 0x8
        SslOptionDisableLegacyRenegotiation: QSsl.SslOption = ... # 0x10
        SslOptionDisableSessionSharing: QSsl.SslOption = ... # 0x20
        SslOptionDisableSessionPersistence: QSsl.SslOption = ... # 0x40
        SslOptionDisableServerCipherPreference: QSsl.SslOption = ... # 0x80

    class SslOptions(object): ...

    class SslProtocol(object):
        UnknownProtocol          : QSsl.SslProtocol = ... # -0x1
        SslV3                    : QSsl.SslProtocol = ... # 0x0
        SslV2                    : QSsl.SslProtocol = ... # 0x1
        TlsV1_0                  : QSsl.SslProtocol = ... # 0x2
        TlsV1_1                  : QSsl.SslProtocol = ... # 0x3
        TlsV1_2                  : QSsl.SslProtocol = ... # 0x4
        AnyProtocol              : QSsl.SslProtocol = ... # 0x5
        TlsV1SslV3               : QSsl.SslProtocol = ... # 0x6
        SecureProtocols          : QSsl.SslProtocol = ... # 0x7
        TlsV1_0OrLater           : QSsl.SslProtocol = ... # 0x8
        TlsV1_1OrLater           : QSsl.SslProtocol = ... # 0x9
        TlsV1_2OrLater           : QSsl.SslProtocol = ... # 0xa
        DtlsV1_0                 : QSsl.SslProtocol = ... # 0xb
        DtlsV1_0OrLater          : QSsl.SslProtocol = ... # 0xc
        DtlsV1_2                 : QSsl.SslProtocol = ... # 0xd
        DtlsV1_2OrLater          : QSsl.SslProtocol = ... # 0xe
        TlsV1_3                  : QSsl.SslProtocol = ... # 0xf
        TlsV1_3OrLater           : QSsl.SslProtocol = ... # 0x10


class QSslCertificate(Shiboken.Object):
    Organization             : QSslCertificate = ... # 0x0
    CommonName               : QSslCertificate = ... # 0x1
    LocalityName             : QSslCertificate = ... # 0x2
    OrganizationalUnitName   : QSslCertificate = ... # 0x3
    CountryName              : QSslCertificate = ... # 0x4
    StateOrProvinceName      : QSslCertificate = ... # 0x5
    DistinguishedNameQualifier: QSslCertificate = ... # 0x6
    SerialNumber             : QSslCertificate = ... # 0x7
    EmailAddress             : QSslCertificate = ... # 0x8

    class SubjectInfo(object):
        Organization             : QSslCertificate.SubjectInfo = ... # 0x0
        CommonName               : QSslCertificate.SubjectInfo = ... # 0x1
        LocalityName             : QSslCertificate.SubjectInfo = ... # 0x2
        OrganizationalUnitName   : QSslCertificate.SubjectInfo = ... # 0x3
        CountryName              : QSslCertificate.SubjectInfo = ... # 0x4
        StateOrProvinceName      : QSslCertificate.SubjectInfo = ... # 0x5
        DistinguishedNameQualifier: QSslCertificate.SubjectInfo = ... # 0x6
        SerialNumber             : QSslCertificate.SubjectInfo = ... # 0x7
        EmailAddress             : QSslCertificate.SubjectInfo = ... # 0x8

    @typing.overload
    def __init__(self, data:PySide2.QtCore.QByteArray=..., format:PySide2.QtNetwork.QSsl.EncodingFormat=...): ...
    @typing.overload
    def __init__(self, device:PySide2.QtCore.QIODevice, format:PySide2.QtNetwork.QSsl.EncodingFormat=...): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QSslCertificate): ...

    def __copy__(self): ...
    def clear(self): ...
    def digest(self, algorithm:PySide2.QtCore.QCryptographicHash.Algorithm=...) -> PySide2.QtCore.QByteArray: ...
    def effectiveDate(self) -> PySide2.QtCore.QDateTime: ...
    def expiryDate(self) -> PySide2.QtCore.QDateTime: ...
    def extensions(self) -> typing.List: ...
    @staticmethod
    def fromData(data:PySide2.QtCore.QByteArray, format:PySide2.QtNetwork.QSsl.EncodingFormat=...) -> typing.List: ...
    @staticmethod
    def fromDevice(device:PySide2.QtCore.QIODevice, format:PySide2.QtNetwork.QSsl.EncodingFormat=...) -> typing.List: ...
    @staticmethod
    def fromPath(path:str, format:PySide2.QtNetwork.QSsl.EncodingFormat=..., syntax:PySide2.QtCore.QRegExp.PatternSyntax=...) -> typing.List: ...
    def handle(self) -> int: ...
    @staticmethod
    def importPkcs12(device:PySide2.QtCore.QIODevice, key:PySide2.QtNetwork.QSslKey, cert:PySide2.QtNetwork.QSslCertificate, caCertificates:typing.Optional[typing.Sequence[PySide2.QtNetwork.QSslCertificate]]=..., passPhrase:PySide2.QtCore.QByteArray=...) -> bool: ...
    def isBlacklisted(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isSelfSigned(self) -> bool: ...
    def issuerDisplayName(self) -> str: ...
    @typing.overload
    def issuerInfo(self, attribute:PySide2.QtCore.QByteArray) -> typing.List: ...
    @typing.overload
    def issuerInfo(self, info:PySide2.QtNetwork.QSslCertificate.SubjectInfo) -> typing.List: ...
    def issuerInfoAttributes(self) -> typing.List: ...
    def publicKey(self) -> PySide2.QtNetwork.QSslKey: ...
    def serialNumber(self) -> PySide2.QtCore.QByteArray: ...
    def subjectAlternativeNames(self) -> typing.Dict: ...
    def subjectDisplayName(self) -> str: ...
    @typing.overload
    def subjectInfo(self, attribute:PySide2.QtCore.QByteArray) -> typing.List: ...
    @typing.overload
    def subjectInfo(self, info:PySide2.QtNetwork.QSslCertificate.SubjectInfo) -> typing.List: ...
    def subjectInfoAttributes(self) -> typing.List: ...
    def swap(self, other:PySide2.QtNetwork.QSslCertificate): ...
    def toDer(self) -> PySide2.QtCore.QByteArray: ...
    def toPem(self) -> PySide2.QtCore.QByteArray: ...
    def toText(self) -> str: ...
    @staticmethod
    def verify(certificateChain:typing.Sequence, hostName:str=...) -> typing.List: ...
    def version(self) -> PySide2.QtCore.QByteArray: ...


class QSslCertificateExtension(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QSslCertificateExtension): ...

    def __copy__(self): ...
    def isCritical(self) -> bool: ...
    def isSupported(self) -> bool: ...
    def name(self) -> str: ...
    def oid(self) -> str: ...
    def swap(self, other:PySide2.QtNetwork.QSslCertificateExtension): ...
    def value(self) -> typing.Any: ...


class QSslCipher(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, name:str): ...
    @typing.overload
    def __init__(self, name:str, protocol:PySide2.QtNetwork.QSsl.SslProtocol): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QSslCipher): ...

    def __copy__(self): ...
    def authenticationMethod(self) -> str: ...
    def encryptionMethod(self) -> str: ...
    def isNull(self) -> bool: ...
    def keyExchangeMethod(self) -> str: ...
    def name(self) -> str: ...
    def protocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def protocolString(self) -> str: ...
    def supportedBits(self) -> int: ...
    def swap(self, other:PySide2.QtNetwork.QSslCipher): ...
    def usedBits(self) -> int: ...


class QSslConfiguration(Shiboken.Object):
    NextProtocolNegotiationNone: QSslConfiguration = ... # 0x0
    NextProtocolNegotiationNegotiated: QSslConfiguration = ... # 0x1
    NextProtocolNegotiationUnsupported: QSslConfiguration = ... # 0x2

    class NextProtocolNegotiationStatus(object):
        NextProtocolNegotiationNone: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x0
        NextProtocolNegotiationNegotiated: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x1
        NextProtocolNegotiationUnsupported: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x2

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QSslConfiguration): ...

    def __copy__(self): ...
    def allowedNextProtocols(self) -> typing.List: ...
    def backendConfiguration(self) -> typing.Dict: ...
    def caCertificates(self) -> typing.List: ...
    def ciphers(self) -> typing.List: ...
    @staticmethod
    def defaultConfiguration() -> PySide2.QtNetwork.QSslConfiguration: ...
    @staticmethod
    def defaultDtlsConfiguration() -> PySide2.QtNetwork.QSslConfiguration: ...
    def diffieHellmanParameters(self) -> PySide2.QtNetwork.QSslDiffieHellmanParameters: ...
    def dtlsCookieVerificationEnabled(self) -> bool: ...
    def ephemeralServerKey(self) -> PySide2.QtNetwork.QSslKey: ...
    def isNull(self) -> bool: ...
    def localCertificate(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def localCertificateChain(self) -> typing.List: ...
    def nextNegotiatedProtocol(self) -> PySide2.QtCore.QByteArray: ...
    def nextProtocolNegotiationStatus(self) -> PySide2.QtNetwork.QSslConfiguration.NextProtocolNegotiationStatus: ...
    def ocspStaplingEnabled(self) -> bool: ...
    def peerCertificate(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def peerCertificateChain(self) -> typing.List: ...
    def peerVerifyDepth(self) -> int: ...
    def peerVerifyMode(self) -> PySide2.QtNetwork.QSslSocket.PeerVerifyMode: ...
    def preSharedKeyIdentityHint(self) -> PySide2.QtCore.QByteArray: ...
    def privateKey(self) -> PySide2.QtNetwork.QSslKey: ...
    def protocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def sessionCipher(self) -> PySide2.QtNetwork.QSslCipher: ...
    def sessionProtocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def sessionTicket(self) -> PySide2.QtCore.QByteArray: ...
    def sessionTicketLifeTimeHint(self) -> int: ...
    def setAllowedNextProtocols(self, protocols:typing.Sequence): ...
    def setBackendConfiguration(self, backendConfiguration:typing.Dict=...): ...
    def setBackendConfigurationOption(self, name:PySide2.QtCore.QByteArray, value:typing.Any): ...
    def setCaCertificates(self, certificates:typing.Sequence): ...
    def setCiphers(self, ciphers:typing.Sequence): ...
    @staticmethod
    def setDefaultConfiguration(configuration:PySide2.QtNetwork.QSslConfiguration): ...
    @staticmethod
    def setDefaultDtlsConfiguration(configuration:PySide2.QtNetwork.QSslConfiguration): ...
    def setDiffieHellmanParameters(self, dhparams:PySide2.QtNetwork.QSslDiffieHellmanParameters): ...
    def setDtlsCookieVerificationEnabled(self, enable:bool): ...
    def setLocalCertificate(self, certificate:PySide2.QtNetwork.QSslCertificate): ...
    def setLocalCertificateChain(self, localChain:typing.Sequence): ...
    def setOcspStaplingEnabled(self, enable:bool): ...
    def setPeerVerifyDepth(self, depth:int): ...
    def setPeerVerifyMode(self, mode:PySide2.QtNetwork.QSslSocket.PeerVerifyMode): ...
    def setPreSharedKeyIdentityHint(self, hint:PySide2.QtCore.QByteArray): ...
    def setPrivateKey(self, key:PySide2.QtNetwork.QSslKey): ...
    def setProtocol(self, protocol:PySide2.QtNetwork.QSsl.SslProtocol): ...
    def setSessionTicket(self, sessionTicket:PySide2.QtCore.QByteArray): ...
    def setSslOption(self, option:PySide2.QtNetwork.QSsl.SslOption, on:bool): ...
    @staticmethod
    def supportedCiphers() -> typing.List: ...
    def swap(self, other:PySide2.QtNetwork.QSslConfiguration): ...
    @staticmethod
    def systemCaCertificates() -> typing.List: ...
    def testSslOption(self, option:PySide2.QtNetwork.QSsl.SslOption) -> bool: ...


class QSslDiffieHellmanParameters(Shiboken.Object):
    NoError                  : QSslDiffieHellmanParameters = ... # 0x0
    InvalidInputDataError    : QSslDiffieHellmanParameters = ... # 0x1
    UnsafeParametersError    : QSslDiffieHellmanParameters = ... # 0x2

    class Error(object):
        NoError                  : QSslDiffieHellmanParameters.Error = ... # 0x0
        InvalidInputDataError    : QSslDiffieHellmanParameters.Error = ... # 0x1
        UnsafeParametersError    : QSslDiffieHellmanParameters.Error = ... # 0x2

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QSslDiffieHellmanParameters): ...

    def __copy__(self): ...
    @staticmethod
    def defaultParameters() -> PySide2.QtNetwork.QSslDiffieHellmanParameters: ...
    def error(self) -> PySide2.QtNetwork.QSslDiffieHellmanParameters.Error: ...
    def errorString(self) -> str: ...
    @typing.overload
    @staticmethod
    def fromEncoded(device:PySide2.QtCore.QIODevice, format:PySide2.QtNetwork.QSsl.EncodingFormat=...) -> PySide2.QtNetwork.QSslDiffieHellmanParameters: ...
    @typing.overload
    @staticmethod
    def fromEncoded(encoded:PySide2.QtCore.QByteArray, format:PySide2.QtNetwork.QSsl.EncodingFormat=...) -> PySide2.QtNetwork.QSslDiffieHellmanParameters: ...
    def isEmpty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def swap(self, other:PySide2.QtNetwork.QSslDiffieHellmanParameters): ...


class QSslError(Shiboken.Object):
    UnspecifiedError         : QSslError = ... # -0x1
    NoError                  : QSslError = ... # 0x0
    UnableToGetIssuerCertificate: QSslError = ... # 0x1
    UnableToDecryptCertificateSignature: QSslError = ... # 0x2
    UnableToDecodeIssuerPublicKey: QSslError = ... # 0x3
    CertificateSignatureFailed: QSslError = ... # 0x4
    CertificateNotYetValid   : QSslError = ... # 0x5
    CertificateExpired       : QSslError = ... # 0x6
    InvalidNotBeforeField    : QSslError = ... # 0x7
    InvalidNotAfterField     : QSslError = ... # 0x8
    SelfSignedCertificate    : QSslError = ... # 0x9
    SelfSignedCertificateInChain: QSslError = ... # 0xa
    UnableToGetLocalIssuerCertificate: QSslError = ... # 0xb
    UnableToVerifyFirstCertificate: QSslError = ... # 0xc
    CertificateRevoked       : QSslError = ... # 0xd
    InvalidCaCertificate     : QSslError = ... # 0xe
    PathLengthExceeded       : QSslError = ... # 0xf
    InvalidPurpose           : QSslError = ... # 0x10
    CertificateUntrusted     : QSslError = ... # 0x11
    CertificateRejected      : QSslError = ... # 0x12
    SubjectIssuerMismatch    : QSslError = ... # 0x13
    AuthorityIssuerSerialNumberMismatch: QSslError = ... # 0x14
    NoPeerCertificate        : QSslError = ... # 0x15
    HostNameMismatch         : QSslError = ... # 0x16
    NoSslSupport             : QSslError = ... # 0x17
    CertificateBlacklisted   : QSslError = ... # 0x18
    CertificateStatusUnknown : QSslError = ... # 0x19
    OcspNoResponseFound      : QSslError = ... # 0x1a
    OcspMalformedRequest     : QSslError = ... # 0x1b
    OcspMalformedResponse    : QSslError = ... # 0x1c
    OcspInternalError        : QSslError = ... # 0x1d
    OcspTryLater             : QSslError = ... # 0x1e
    OcspSigRequred           : QSslError = ... # 0x1f
    OcspUnauthorized         : QSslError = ... # 0x20
    OcspResponseCannotBeTrusted: QSslError = ... # 0x21
    OcspResponseCertIdUnknown: QSslError = ... # 0x22
    OcspResponseExpired      : QSslError = ... # 0x23
    OcspStatusUnknown        : QSslError = ... # 0x24

    class SslError(object):
        UnspecifiedError         : QSslError.SslError = ... # -0x1
        NoError                  : QSslError.SslError = ... # 0x0
        UnableToGetIssuerCertificate: QSslError.SslError = ... # 0x1
        UnableToDecryptCertificateSignature: QSslError.SslError = ... # 0x2
        UnableToDecodeIssuerPublicKey: QSslError.SslError = ... # 0x3
        CertificateSignatureFailed: QSslError.SslError = ... # 0x4
        CertificateNotYetValid   : QSslError.SslError = ... # 0x5
        CertificateExpired       : QSslError.SslError = ... # 0x6
        InvalidNotBeforeField    : QSslError.SslError = ... # 0x7
        InvalidNotAfterField     : QSslError.SslError = ... # 0x8
        SelfSignedCertificate    : QSslError.SslError = ... # 0x9
        SelfSignedCertificateInChain: QSslError.SslError = ... # 0xa
        UnableToGetLocalIssuerCertificate: QSslError.SslError = ... # 0xb
        UnableToVerifyFirstCertificate: QSslError.SslError = ... # 0xc
        CertificateRevoked       : QSslError.SslError = ... # 0xd
        InvalidCaCertificate     : QSslError.SslError = ... # 0xe
        PathLengthExceeded       : QSslError.SslError = ... # 0xf
        InvalidPurpose           : QSslError.SslError = ... # 0x10
        CertificateUntrusted     : QSslError.SslError = ... # 0x11
        CertificateRejected      : QSslError.SslError = ... # 0x12
        SubjectIssuerMismatch    : QSslError.SslError = ... # 0x13
        AuthorityIssuerSerialNumberMismatch: QSslError.SslError = ... # 0x14
        NoPeerCertificate        : QSslError.SslError = ... # 0x15
        HostNameMismatch         : QSslError.SslError = ... # 0x16
        NoSslSupport             : QSslError.SslError = ... # 0x17
        CertificateBlacklisted   : QSslError.SslError = ... # 0x18
        CertificateStatusUnknown : QSslError.SslError = ... # 0x19
        OcspNoResponseFound      : QSslError.SslError = ... # 0x1a
        OcspMalformedRequest     : QSslError.SslError = ... # 0x1b
        OcspMalformedResponse    : QSslError.SslError = ... # 0x1c
        OcspInternalError        : QSslError.SslError = ... # 0x1d
        OcspTryLater             : QSslError.SslError = ... # 0x1e
        OcspSigRequred           : QSslError.SslError = ... # 0x1f
        OcspUnauthorized         : QSslError.SslError = ... # 0x20
        OcspResponseCannotBeTrusted: QSslError.SslError = ... # 0x21
        OcspResponseCertIdUnknown: QSslError.SslError = ... # 0x22
        OcspResponseExpired      : QSslError.SslError = ... # 0x23
        OcspStatusUnknown        : QSslError.SslError = ... # 0x24

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, error:PySide2.QtNetwork.QSslError.SslError): ...
    @typing.overload
    def __init__(self, error:PySide2.QtNetwork.QSslError.SslError, certificate:PySide2.QtNetwork.QSslCertificate): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QSslError): ...

    def __copy__(self): ...
    def certificate(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def error(self) -> PySide2.QtNetwork.QSslError.SslError: ...
    def errorString(self) -> str: ...
    def swap(self, other:PySide2.QtNetwork.QSslError): ...


class QSslKey(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, device:PySide2.QtCore.QIODevice, algorithm:PySide2.QtNetwork.QSsl.KeyAlgorithm, format:PySide2.QtNetwork.QSsl.EncodingFormat=..., type:PySide2.QtNetwork.QSsl.KeyType=..., passPhrase:PySide2.QtCore.QByteArray=...): ...
    @typing.overload
    def __init__(self, encoded:PySide2.QtCore.QByteArray, algorithm:PySide2.QtNetwork.QSsl.KeyAlgorithm, format:PySide2.QtNetwork.QSsl.EncodingFormat=..., type:PySide2.QtNetwork.QSsl.KeyType=..., passPhrase:PySide2.QtCore.QByteArray=...): ...
    @typing.overload
    def __init__(self, handle:int, type:PySide2.QtNetwork.QSsl.KeyType=...): ...
    @typing.overload
    def __init__(self, other:PySide2.QtNetwork.QSslKey): ...

    def __copy__(self): ...
    def algorithm(self) -> PySide2.QtNetwork.QSsl.KeyAlgorithm: ...
    def clear(self): ...
    def handle(self) -> int: ...
    def isNull(self) -> bool: ...
    def length(self) -> int: ...
    def swap(self, other:PySide2.QtNetwork.QSslKey): ...
    def toDer(self, passPhrase:PySide2.QtCore.QByteArray=...) -> PySide2.QtCore.QByteArray: ...
    def toPem(self, passPhrase:PySide2.QtCore.QByteArray=...) -> PySide2.QtCore.QByteArray: ...
    def type(self) -> PySide2.QtNetwork.QSsl.KeyType: ...


class QSslPreSharedKeyAuthenticator(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, authenticator:PySide2.QtNetwork.QSslPreSharedKeyAuthenticator): ...

    def __copy__(self): ...
    def identity(self) -> PySide2.QtCore.QByteArray: ...
    def identityHint(self) -> PySide2.QtCore.QByteArray: ...
    def maximumIdentityLength(self) -> int: ...
    def maximumPreSharedKeyLength(self) -> int: ...
    def preSharedKey(self) -> PySide2.QtCore.QByteArray: ...
    def setIdentity(self, identity:PySide2.QtCore.QByteArray): ...
    def setPreSharedKey(self, preSharedKey:PySide2.QtCore.QByteArray): ...
    def swap(self, other:PySide2.QtNetwork.QSslPreSharedKeyAuthenticator): ...


class QSslSocket(PySide2.QtNetwork.QTcpSocket):
    UnencryptedMode          : QSslSocket = ... # 0x0
    VerifyNone               : QSslSocket = ... # 0x0
    QueryPeer                : QSslSocket = ... # 0x1
    SslClientMode            : QSslSocket = ... # 0x1
    SslServerMode            : QSslSocket = ... # 0x2
    VerifyPeer               : QSslSocket = ... # 0x2
    AutoVerifyPeer           : QSslSocket = ... # 0x3

    class PeerVerifyMode(object):
        VerifyNone               : QSslSocket.PeerVerifyMode = ... # 0x0
        QueryPeer                : QSslSocket.PeerVerifyMode = ... # 0x1
        VerifyPeer               : QSslSocket.PeerVerifyMode = ... # 0x2
        AutoVerifyPeer           : QSslSocket.PeerVerifyMode = ... # 0x3

    class SslMode(object):
        UnencryptedMode          : QSslSocket.SslMode = ... # 0x0
        SslClientMode            : QSslSocket.SslMode = ... # 0x1
        SslServerMode            : QSslSocket.SslMode = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def abort(self): ...
    def addCaCertificate(self, certificate:PySide2.QtNetwork.QSslCertificate): ...
    @typing.overload
    def addCaCertificates(self, certificates:typing.Sequence): ...
    @typing.overload
    def addCaCertificates(self, path:str, format:PySide2.QtNetwork.QSsl.EncodingFormat=..., syntax:PySide2.QtCore.QRegExp.PatternSyntax=...) -> bool: ...
    @staticmethod
    def addDefaultCaCertificate(certificate:PySide2.QtNetwork.QSslCertificate): ...
    @typing.overload
    @staticmethod
    def addDefaultCaCertificates(certificates:typing.Sequence): ...
    @typing.overload
    @staticmethod
    def addDefaultCaCertificates(path:str, format:PySide2.QtNetwork.QSsl.EncodingFormat=..., syntax:PySide2.QtCore.QRegExp.PatternSyntax=...) -> bool: ...
    def atEnd(self) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def caCertificates(self) -> typing.List: ...
    def canReadLine(self) -> bool: ...
    def ciphers(self) -> typing.List: ...
    def close(self): ...
    @typing.overload
    def connectToHost(self, address:PySide2.QtNetwork.QHostAddress, port:int, mode:PySide2.QtCore.QIODevice.OpenMode=...): ...
    @typing.overload
    def connectToHost(self, hostName:str, port:int, openMode:PySide2.QtCore.QIODevice.OpenMode=..., protocol:PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol=...): ...
    @typing.overload
    def connectToHostEncrypted(self, hostName:str, port:int, mode:PySide2.QtCore.QIODevice.OpenMode=..., protocol:PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol=...): ...
    @typing.overload
    def connectToHostEncrypted(self, hostName:str, port:int, sslPeerName:str, mode:PySide2.QtCore.QIODevice.OpenMode=..., protocol:PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol=...): ...
    @staticmethod
    def defaultCaCertificates() -> typing.List: ...
    @staticmethod
    def defaultCiphers() -> typing.List: ...
    def disconnectFromHost(self): ...
    def encryptedBytesAvailable(self) -> int: ...
    def encryptedBytesToWrite(self) -> int: ...
    def flush(self) -> bool: ...
    @typing.overload
    def ignoreSslErrors(self): ...
    @typing.overload
    def ignoreSslErrors(self, errors:typing.Sequence): ...
    def isEncrypted(self) -> bool: ...
    def localCertificate(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def localCertificateChain(self) -> typing.List: ...
    def mode(self) -> PySide2.QtNetwork.QSslSocket.SslMode: ...
    def ocspResponses(self) -> typing.List: ...
    def peerCertificate(self) -> PySide2.QtNetwork.QSslCertificate: ...
    def peerCertificateChain(self) -> typing.List: ...
    def peerVerifyDepth(self) -> int: ...
    def peerVerifyMode(self) -> PySide2.QtNetwork.QSslSocket.PeerVerifyMode: ...
    def peerVerifyName(self) -> str: ...
    def privateKey(self) -> PySide2.QtNetwork.QSslKey: ...
    def protocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def readData(self, data:bytes, maxlen:int) -> int: ...
    def resume(self): ...
    def sessionCipher(self) -> PySide2.QtNetwork.QSslCipher: ...
    def sessionProtocol(self) -> PySide2.QtNetwork.QSsl.SslProtocol: ...
    def setCaCertificates(self, certificates:typing.Sequence): ...
    @typing.overload
    def setCiphers(self, ciphers:typing.Sequence): ...
    @typing.overload
    def setCiphers(self, ciphers:str): ...
    @staticmethod
    def setDefaultCaCertificates(certificates:typing.Sequence): ...
    @staticmethod
    def setDefaultCiphers(ciphers:typing.Sequence): ...
    @typing.overload
    def setLocalCertificate(self, certificate:PySide2.QtNetwork.QSslCertificate): ...
    @typing.overload
    def setLocalCertificate(self, fileName:str, format:PySide2.QtNetwork.QSsl.EncodingFormat=...): ...
    def setLocalCertificateChain(self, localChain:typing.Sequence): ...
    def setPeerVerifyDepth(self, depth:int): ...
    def setPeerVerifyMode(self, mode:PySide2.QtNetwork.QSslSocket.PeerVerifyMode): ...
    def setPeerVerifyName(self, hostName:str): ...
    @typing.overload
    def setPrivateKey(self, fileName:str, algorithm:PySide2.QtNetwork.QSsl.KeyAlgorithm=..., format:PySide2.QtNetwork.QSsl.EncodingFormat=..., passPhrase:PySide2.QtCore.QByteArray=...): ...
    @typing.overload
    def setPrivateKey(self, key:PySide2.QtNetwork.QSslKey): ...
    def setProtocol(self, protocol:PySide2.QtNetwork.QSsl.SslProtocol): ...
    def setReadBufferSize(self, size:int): ...
    def setSocketDescriptor(self, socketDescriptor:int, state:PySide2.QtNetwork.QAbstractSocket.SocketState=..., openMode:PySide2.QtCore.QIODevice.OpenMode=...) -> bool: ...
    def setSocketOption(self, option:PySide2.QtNetwork.QAbstractSocket.SocketOption, value:typing.Any): ...
    def setSslConfiguration(self, config:PySide2.QtNetwork.QSslConfiguration): ...
    def socketOption(self, option:PySide2.QtNetwork.QAbstractSocket.SocketOption) -> typing.Any: ...
    def sslConfiguration(self) -> PySide2.QtNetwork.QSslConfiguration: ...
    def sslErrors(self) -> typing.List: ...
    @staticmethod
    def sslLibraryBuildVersionNumber() -> int: ...
    @staticmethod
    def sslLibraryBuildVersionString() -> str: ...
    @staticmethod
    def sslLibraryVersionNumber() -> int: ...
    @staticmethod
    def sslLibraryVersionString() -> str: ...
    def startClientEncryption(self): ...
    def startServerEncryption(self): ...
    @staticmethod
    def supportedCiphers() -> typing.List: ...
    @staticmethod
    def supportsSsl() -> bool: ...
    @staticmethod
    def systemCaCertificates() -> typing.List: ...
    def waitForBytesWritten(self, msecs:int=...) -> bool: ...
    def waitForConnected(self, msecs:int=...) -> bool: ...
    def waitForDisconnected(self, msecs:int=...) -> bool: ...
    def waitForEncrypted(self, msecs:int=...) -> bool: ...
    def waitForReadyRead(self, msecs:int=...) -> bool: ...
    def writeData(self, data:bytes, len:int) -> int: ...


class QTcpServer(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def addPendingConnection(self, socket:PySide2.QtNetwork.QTcpSocket): ...
    def close(self): ...
    def errorString(self) -> str: ...
    def hasPendingConnections(self) -> bool: ...
    def incomingConnection(self, handle:int): ...
    def isListening(self) -> bool: ...
    def listen(self, address:PySide2.QtNetwork.QHostAddress=..., port:int=...) -> bool: ...
    def maxPendingConnections(self) -> int: ...
    def nextPendingConnection(self) -> PySide2.QtNetwork.QTcpSocket: ...
    def pauseAccepting(self): ...
    def proxy(self) -> PySide2.QtNetwork.QNetworkProxy: ...
    def resumeAccepting(self): ...
    def serverAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def serverError(self) -> PySide2.QtNetwork.QAbstractSocket.SocketError: ...
    def serverPort(self) -> int: ...
    def setMaxPendingConnections(self, numConnections:int): ...
    def setProxy(self, networkProxy:PySide2.QtNetwork.QNetworkProxy): ...
    def setSocketDescriptor(self, socketDescriptor:int) -> bool: ...
    def socketDescriptor(self) -> int: ...
    def waitForNewConnection(self, msec:int) -> typing.Tuple: ...


class QTcpSocket(PySide2.QtNetwork.QAbstractSocket):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...


class QUdpSocket(PySide2.QtNetwork.QAbstractSocket):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def hasPendingDatagrams(self) -> bool: ...
    @typing.overload
    def joinMulticastGroup(self, groupAddress:PySide2.QtNetwork.QHostAddress) -> bool: ...
    @typing.overload
    def joinMulticastGroup(self, groupAddress:PySide2.QtNetwork.QHostAddress, iface:PySide2.QtNetwork.QNetworkInterface) -> bool: ...
    @typing.overload
    def leaveMulticastGroup(self, groupAddress:PySide2.QtNetwork.QHostAddress) -> bool: ...
    @typing.overload
    def leaveMulticastGroup(self, groupAddress:PySide2.QtNetwork.QHostAddress, iface:PySide2.QtNetwork.QNetworkInterface) -> bool: ...
    def multicastInterface(self) -> PySide2.QtNetwork.QNetworkInterface: ...
    def pendingDatagramSize(self) -> int: ...
    def readDatagram(self, data:bytes, maxlen:int, host:PySide2.QtNetwork.QHostAddress) -> typing.Tuple: ...
    def receiveDatagram(self, maxSize:int=...) -> PySide2.QtNetwork.QNetworkDatagram: ...
    def setMulticastInterface(self, iface:PySide2.QtNetwork.QNetworkInterface): ...
    @typing.overload
    def writeDatagram(self, datagram:PySide2.QtCore.QByteArray, host:PySide2.QtNetwork.QHostAddress, port:int) -> int: ...
    @typing.overload
    def writeDatagram(self, datagram:PySide2.QtNetwork.QNetworkDatagram) -> int: ...

# eof
