# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2019 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtOpenGLFunctions, except for defaults which are replaced by "...".
"""

# Module PySide2.QtOpenGLFunctions
import PySide2
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtGui
import PySide2.QtOpenGLFunctions


class QOpenGLFunctions_1_0(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glBegin(self, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCullFace(self, mode:int): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDisable(self, cap:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEnable(self, cap:int): ...
    def glEnd(self): ...
    def glEndList(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int): ...
    def glIndexMask(self, mask:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glInitNames(self): ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPopAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPushAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_1(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glBegin(self, mode:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCullFace(self, mode:int): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnd(self): ...
    def glEndList(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_2(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glBegin(self, mode:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCullFace(self, mode:int): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnd(self): ...
    def glEndList(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_3(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glBegin(self, mode:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCullFace(self, mode:int): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnd(self): ...
    def glEndList(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_4(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glBegin(self, mode:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCullFace(self, mode:int): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnd(self): ...
    def glEndList(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_1_5(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glBegin(self, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnd(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_2_0(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnd(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_2_1(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnd(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_0(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEnd(self): ...
    def glEndConditionalRender(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEndTransformFeedback(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_1(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glActiveTexture(self, texture:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearStencil(self, s:int): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glEnable(self, cap:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEndConditionalRender(self): ...
    def glEndQuery(self, target:int): ...
    def glEndTransformFeedback(self): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glReadBuffer(self, mode:int): ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_2_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEnd(self): ...
    def glEndConditionalRender(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEndTransformFeedback(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_2_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glActiveTexture(self, texture:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearStencil(self, s:int): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glEnable(self, cap:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEndConditionalRender(self): ...
    def glEndQuery(self, target:int): ...
    def glEndTransformFeedback(self): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glProvokingVertex(self, mode:int): ...
    def glReadBuffer(self, mode:int): ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_3_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEnd(self): ...
    def glEndConditionalRender(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEndTransformFeedback(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_3_3_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glActiveTexture(self, texture:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearStencil(self, s:int): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glEnable(self, cap:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEndConditionalRender(self): ...
    def glEndQuery(self, target:int): ...
    def glEndTransformFeedback(self): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glProvokingVertex(self, mode:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glReadBuffer(self, mode:int): ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_0_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEnd(self): ...
    def glEndConditionalRender(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinSampleShading(self, value:float): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glResumeTransformFeedback(self): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_0_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glActiveTexture(self, texture:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearStencil(self, s:int): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glEnable(self, cap:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEndConditionalRender(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMinSampleShading(self, value:float): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glProvokingVertex(self, mode:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glReadBuffer(self, mode:int): ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResumeTransformFeedback(self): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_1_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveShaderProgram(self, pipeline:int, program:int): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindProgramPipeline(self, pipeline:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearDepthf(self, dd:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float): ...
    def glDepthRangef(self, n:float, f:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEnd(self): ...
    def glEndConditionalRender(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMinSampleShading(self, value:float): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int): ...
    def glProgramParameteri(self, program:int, pname:int, value:int): ...
    def glProgramUniform1d(self, program:int, location:int, v0:float): ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1f(self, program:int, location:int, v0:float): ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1i(self, program:int, location:int, v0:int): ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int): ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glResumeTransformFeedback(self): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int): ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glValidateProgramPipeline(self, pipeline:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribL1d(self, index:int, x:float): ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL2d(self, index:int, x:float, y:float): ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float): ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_1_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glActiveShaderProgram(self, pipeline:int, program:int): ...
    def glActiveTexture(self, texture:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindProgramPipeline(self, pipeline:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearDepthf(self, dd:float): ...
    def glClearStencil(self, s:int): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float): ...
    def glDepthRangef(self, n:float, f:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glEnable(self, cap:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEndConditionalRender(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMinSampleShading(self, value:float): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int): ...
    def glProgramParameteri(self, program:int, pname:int, value:int): ...
    def glProgramUniform1d(self, program:int, location:int, v0:float): ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1f(self, program:int, location:int, v0:float): ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1i(self, program:int, location:int, v0:int): ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int): ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glReadBuffer(self, mode:int): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResumeTransformFeedback(self): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int): ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glValidateProgramPipeline(self, pipeline:int): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribL1d(self, index:int, x:float): ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL2d(self, index:int, x:float, y:float): ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float): ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_2_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveShaderProgram(self, pipeline:int, program:int): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:typing.Char, layer:int, access:int, format:int): ...
    def glBindProgramPipeline(self, pipeline:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearDepthf(self, dd:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float): ...
    def glDepthRangef(self, n:float, f:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEnd(self): ...
    def glEndConditionalRender(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMemoryBarrier(self, barriers:int): ...
    def glMinSampleShading(self, value:float): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int): ...
    def glProgramParameteri(self, program:int, pname:int, value:int): ...
    def glProgramUniform1d(self, program:int, location:int, v0:float): ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1f(self, program:int, location:int, v0:float): ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1i(self, program:int, location:int, v0:int): ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int): ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glResumeTransformFeedback(self): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int): ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int): ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int): ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glValidateProgramPipeline(self, pipeline:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribL1d(self, index:int, x:float): ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL2d(self, index:int, x:float, y:float): ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float): ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_2_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glActiveShaderProgram(self, pipeline:int, program:int): ...
    def glActiveTexture(self, texture:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:typing.Char, layer:int, access:int, format:int): ...
    def glBindProgramPipeline(self, pipeline:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearDepthf(self, dd:float): ...
    def glClearStencil(self, s:int): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float): ...
    def glDepthRangef(self, n:float, f:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int): ...
    def glEnable(self, cap:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEndConditionalRender(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMemoryBarrier(self, barriers:int): ...
    def glMinSampleShading(self, value:float): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int): ...
    def glProgramParameteri(self, program:int, pname:int, value:int): ...
    def glProgramUniform1d(self, program:int, location:int, v0:float): ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1f(self, program:int, location:int, v0:float): ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1i(self, program:int, location:int, v0:int): ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int): ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glReadBuffer(self, mode:int): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResumeTransformFeedback(self): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int): ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int): ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int): ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glValidateProgramPipeline(self, pipeline:int): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribL1d(self, index:int, x:float): ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL2d(self, index:int, x:float, y:float): ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float): ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_3_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveShaderProgram(self, pipeline:int, program:int): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:typing.Char, layer:int, access:int, format:int): ...
    def glBindProgramPipeline(self, pipeline:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearDepthf(self, dd:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float): ...
    def glDepthRangef(self, n:float, f:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEnd(self): ...
    def glEndConditionalRender(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glInvalidateBufferData(self, buffer:int): ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence): ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int): ...
    def glInvalidateTexImage(self, texture:int, level:int): ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMemoryBarrier(self, barriers:int): ...
    def glMinSampleShading(self, value:float): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int): ...
    def glProgramParameteri(self, program:int, pname:int, value:int): ...
    def glProgramUniform1d(self, program:int, location:int, v0:float): ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1f(self, program:int, location:int, v0:float): ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1i(self, program:int, location:int, v0:int): ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int): ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, mode:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glResumeTransformFeedback(self): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int): ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int): ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int): ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int): ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int): ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glValidateProgramPipeline(self, pipeline:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:typing.Char, relativeoffset:int): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribL1d(self, index:int, x:float): ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL2d(self, index:int, x:float, y:float): ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float): ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_3_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glActiveShaderProgram(self, pipeline:int, program:int): ...
    def glActiveTexture(self, texture:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:typing.Char, layer:int, access:int, format:int): ...
    def glBindProgramPipeline(self, pipeline:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearDepthf(self, dd:float): ...
    def glClearStencil(self, s:int): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float): ...
    def glDepthRangef(self, n:float, f:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int): ...
    def glDrawBuffer(self, mode:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int): ...
    def glEnable(self, cap:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEndConditionalRender(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInvalidateBufferData(self, buffer:int): ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence): ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int): ...
    def glInvalidateTexImage(self, texture:int, level:int): ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMemoryBarrier(self, barriers:int): ...
    def glMinSampleShading(self, value:float): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int): ...
    def glProgramParameteri(self, program:int, pname:int, value:int): ...
    def glProgramUniform1d(self, program:int, location:int, v0:float): ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1f(self, program:int, location:int, v0:float): ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1i(self, program:int, location:int, v0:int): ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int): ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glReadBuffer(self, mode:int): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResumeTransformFeedback(self): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, index:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int): ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int): ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int): ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int): ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int): ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glValidateProgramPipeline(self, pipeline:int): ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:typing.Char, relativeoffset:int): ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribL1d(self, index:int, x:float): ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL2d(self, index:int, x:float, y:float): ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float): ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_4_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveShaderProgram(self, pipeline:int, program:int): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindBuffersBase(self, target:int, first:int, count:int, buffers:typing.Sequence): ...
    def glBindBuffersRange(self, target:int, first:int, count:int) -> typing.Tuple: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:typing.Char, layer:int, access:int, format:int): ...
    def glBindImageTextures(self, first:int, count:int, textures:typing.Sequence): ...
    def glBindProgramPipeline(self, pipeline:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindSamplers(self, first:int, count:int, samplers:typing.Sequence): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTextures(self, first:int, count:int, textures:typing.Sequence): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBindVertexBuffers(self, first:int, count:int) -> typing.Tuple: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearDepthf(self, dd:float): ...
    def glClearIndex(self, c:float): ...
    def glClearStencil(self, s:int): ...
    def glClearTexImage(self, texture:int, level:int, format:int, type:int, data:int): ...
    def glClearTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, data:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDebugMessageControl(self, source:int, type:int, severity:int, count:int, ids:typing.Sequence, enabled:typing.Char): ...
    def glDebugMessageInsert(self, source:int, type:int, id:int, severity:int, length:int, buf:bytes): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float): ...
    def glDepthRangef(self, n:float, f:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int): ...
    def glDrawBuffer(self, buf:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEnd(self): ...
    def glEndConditionalRender(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetColorTable(self, target:int, format:int, type:int, table:int): ...
    def glGetCompressedTexImage(self, target:int, level:int, img:int): ...
    def glGetConvolutionFilter(self, target:int, format:int, type:int, image:int): ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetHistogram(self, target:int, reset:typing.Char, format:int, type:int, values:int): ...
    def glGetMinmax(self, target:int, reset:typing.Char, format:int, type:int, values:int): ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetSeparableFilter(self, target:int, format:int, type:int, row:int, column:int, span:int): ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetTexImage(self, target:int, level:int, format:int, type:int, pixels:int): ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glInvalidateBufferData(self, buffer:int): ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence): ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int): ...
    def glInvalidateTexImage(self, texture:int, level:int): ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMemoryBarrier(self, barriers:int): ...
    def glMinSampleShading(self, value:float): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glObjectLabel(self, identifier:int, name:int, length:int, label:bytes): ...
    def glObjectPtrLabel(self, ptr:int, length:int, label:bytes): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopDebugGroup(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int): ...
    def glProgramParameteri(self, program:int, pname:int, value:int): ...
    def glProgramUniform1d(self, program:int, location:int, v0:float): ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1f(self, program:int, location:int, v0:float): ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1i(self, program:int, location:int, v0:int): ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int): ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushDebugGroup(self, source:int, id:int, length:int, message:bytes): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, src:int): ...
    def glReadPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glResumeTransformFeedback(self): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, maskNumber:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int): ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int): ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int): ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int): ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int): ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glValidateProgramPipeline(self, pipeline:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:typing.Char, relativeoffset:int): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribL1d(self, index:int, x:float): ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL2d(self, index:int, x:float, y:float): ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float): ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_4_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glActiveShaderProgram(self, pipeline:int, program:int): ...
    def glActiveTexture(self, texture:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindBuffersBase(self, target:int, first:int, count:int, buffers:typing.Sequence): ...
    def glBindBuffersRange(self, target:int, first:int, count:int) -> typing.Tuple: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:typing.Char, layer:int, access:int, format:int): ...
    def glBindImageTextures(self, first:int, count:int, textures:typing.Sequence): ...
    def glBindProgramPipeline(self, pipeline:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindSamplers(self, first:int, count:int, samplers:typing.Sequence): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTextures(self, first:int, count:int, textures:typing.Sequence): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBindVertexBuffers(self, first:int, count:int) -> typing.Tuple: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearDepthf(self, dd:float): ...
    def glClearStencil(self, s:int): ...
    def glClearTexImage(self, texture:int, level:int, format:int, type:int, data:int): ...
    def glClearTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, data:int): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDebugMessageControl(self, source:int, type:int, severity:int, count:int, ids:typing.Sequence, enabled:typing.Char): ...
    def glDebugMessageInsert(self, source:int, type:int, id:int, severity:int, length:int, buf:bytes): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float): ...
    def glDepthRangef(self, n:float, f:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int): ...
    def glDrawBuffer(self, buf:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int): ...
    def glEnable(self, cap:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEndConditionalRender(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glGenerateMipmap(self, target:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetCompressedTexImage(self, target:int, level:int, img:int): ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetTexImage(self, target:int, level:int, format:int, type:int, pixels:int): ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glHint(self, target:int, mode:int): ...
    def glInvalidateBufferData(self, buffer:int): ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence): ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int): ...
    def glInvalidateTexImage(self, texture:int, level:int): ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMemoryBarrier(self, barriers:int): ...
    def glMinSampleShading(self, value:float): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int): ...
    def glObjectLabel(self, identifier:int, name:int, length:int, label:bytes): ...
    def glObjectPtrLabel(self, ptr:int, length:int, label:bytes): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopDebugGroup(self): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int): ...
    def glProgramParameteri(self, program:int, pname:int, value:int): ...
    def glProgramUniform1d(self, program:int, location:int, v0:float): ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1f(self, program:int, location:int, v0:float): ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1i(self, program:int, location:int, v0:int): ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int): ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glPushDebugGroup(self, source:int, id:int, length:int, message:bytes): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glReadBuffer(self, src:int): ...
    def glReadPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResumeTransformFeedback(self): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, maskNumber:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int): ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence): ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int): ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int): ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int): ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int): ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glValidateProgramPipeline(self, pipeline:int): ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:typing.Char, relativeoffset:int): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribL1d(self, index:int, x:float): ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL2d(self, index:int, x:float, y:float): ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float): ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_5_Compatibility(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glAccum(self, op:int, value:float): ...
    def glActiveShaderProgram(self, pipeline:int, program:int): ...
    def glActiveTexture(self, texture:int): ...
    def glAlphaFunc(self, func:int, ref:float): ...
    def glArrayElement(self, i:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBegin(self, mode:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindBuffersBase(self, target:int, first:int, count:int, buffers:typing.Sequence): ...
    def glBindBuffersRange(self, target:int, first:int, count:int) -> typing.Tuple: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:typing.Char, layer:int, access:int, format:int): ...
    def glBindImageTextures(self, first:int, count:int, textures:typing.Sequence): ...
    def glBindProgramPipeline(self, pipeline:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindSamplers(self, first:int, count:int, samplers:typing.Sequence): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTextureUnit(self, unit:int, texture:int): ...
    def glBindTextures(self, first:int, count:int, textures:typing.Sequence): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBindVertexBuffers(self, first:int, count:int) -> typing.Tuple: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glBlitNamedFramebuffer(self, readFramebuffer:int, drawFramebuffer:int, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCallList(self, list:int): ...
    def glCallLists(self, n:int, type:int, lists:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glCheckNamedFramebufferStatus(self, framebuffer:int, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearAccum(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearDepthf(self, dd:float): ...
    def glClearIndex(self, c:float): ...
    def glClearNamedBufferData(self, buffer:int, internalformat:int, format:int, type:int, data:int): ...
    def glClearNamedFramebufferfi(self, framebuffer:int, buffer:int, depth:float, stencil:int): ...
    def glClearNamedFramebufferfv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearNamedFramebufferiv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearNamedFramebufferuiv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearStencil(self, s:int): ...
    def glClearTexImage(self, texture:int, level:int, format:int, type:int, data:int): ...
    def glClearTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, data:int): ...
    def glClientActiveTexture(self, texture:int): ...
    def glClipControl(self, origin:int, depth:int): ...
    def glClipPlane(self, plane:int, equation:typing.Sequence): ...
    def glColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3bv(self, v:bytes): ...
    def glColor3d(self, red:float, green:float, blue:float): ...
    def glColor3dv(self, v:typing.Sequence): ...
    def glColor3f(self, red:float, green:float, blue:float): ...
    def glColor3fv(self, v:typing.Sequence): ...
    def glColor3i(self, red:int, green:int, blue:int): ...
    def glColor3iv(self, v:typing.Sequence): ...
    def glColor3s(self, red:int, green:int, blue:int): ...
    def glColor3sv(self, v:typing.Sequence): ...
    def glColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glColor3ubv(self, v:bytes): ...
    def glColor3ui(self, red:int, green:int, blue:int): ...
    def glColor3uiv(self, v:typing.Sequence): ...
    def glColor3us(self, red:int, green:int, blue:int): ...
    def glColor3usv(self, v:typing.Sequence): ...
    def glColor4b(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4bv(self, v:bytes): ...
    def glColor4d(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4dv(self, v:typing.Sequence): ...
    def glColor4f(self, red:float, green:float, blue:float, alpha:float): ...
    def glColor4fv(self, v:typing.Sequence): ...
    def glColor4i(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4iv(self, v:typing.Sequence): ...
    def glColor4s(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4sv(self, v:typing.Sequence): ...
    def glColor4ub(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColor4ubv(self, v:bytes): ...
    def glColor4ui(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4uiv(self, v:typing.Sequence): ...
    def glColor4us(self, red:int, green:int, blue:int, alpha:int): ...
    def glColor4usv(self, v:typing.Sequence): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glColorMaterial(self, face:int, mode:int): ...
    def glColorP3ui(self, type:int, color:int): ...
    def glColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glColorP4ui(self, type:int, color:int): ...
    def glColorP4uiv(self, type:int, color:typing.Sequence): ...
    def glColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glColorSubTable(self, target:int, start:int, count:int, format:int, type:int, data:int): ...
    def glColorTable(self, target:int, internalformat:int, width:int, format:int, type:int, table:int): ...
    def glColorTableParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glColorTableParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCompressedTextureSubImage1D(self, texture:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glConvolutionFilter1D(self, target:int, internalformat:int, width:int, format:int, type:int, image:int): ...
    def glConvolutionFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, image:int): ...
    def glConvolutionParameterf(self, target:int, pname:int, params:float): ...
    def glConvolutionParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glConvolutionParameteri(self, target:int, pname:int, params:int): ...
    def glConvolutionParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glCopyColorSubTable(self, target:int, start:int, x:int, y:int, width:int): ...
    def glCopyColorTable(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter1D(self, target:int, internalformat:int, x:int, y:int, width:int): ...
    def glCopyConvolutionFilter2D(self, target:int, internalformat:int, x:int, y:int, width:int, height:int): ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int): ...
    def glCopyPixels(self, x:int, y:int, width:int, height:int, type:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTextureSubImage1D(self, texture:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDebugMessageControl(self, source:int, type:int, severity:int, count:int, ids:typing.Sequence, enabled:typing.Char): ...
    def glDebugMessageInsert(self, source:int, type:int, id:int, severity:int, length:int, buf:bytes): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteLists(self, list:int, range:int): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float): ...
    def glDepthRangef(self, n:float, f:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableClientState(self, array:int): ...
    def glDisableVertexArrayAttrib(self, vaobj:int, index:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int): ...
    def glDrawBuffer(self, buf:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int): ...
    def glDrawPixels(self, width:int, height:int, format:int, type:int, pixels:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int): ...
    def glEdgeFlag(self, flag:typing.Char): ...
    def glEdgeFlagPointer(self, stride:int, pointer:int): ...
    def glEnable(self, cap:int): ...
    def glEnableClientState(self, array:int): ...
    def glEnableVertexArrayAttrib(self, vaobj:int, index:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEnd(self): ...
    def glEndConditionalRender(self): ...
    def glEndList(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glEvalCoord1d(self, u:float): ...
    def glEvalCoord1dv(self, u:typing.Sequence): ...
    def glEvalCoord1f(self, u:float): ...
    def glEvalCoord1fv(self, u:typing.Sequence): ...
    def glEvalCoord2d(self, u:float, v:float): ...
    def glEvalCoord2dv(self, u:typing.Sequence): ...
    def glEvalCoord2f(self, u:float, v:float): ...
    def glEvalCoord2fv(self, u:typing.Sequence): ...
    def glEvalMesh1(self, mode:int, i1:int, i2:int): ...
    def glEvalMesh2(self, mode:int, i1:int, i2:int, j1:int, j2:int): ...
    def glEvalPoint1(self, i:int): ...
    def glEvalPoint2(self, i:int, j:int): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFogCoordPointer(self, type:int, stride:int, pointer:int): ...
    def glFogCoordd(self, coord:float): ...
    def glFogCoorddv(self, coord:typing.Sequence): ...
    def glFogCoordf(self, coord:float): ...
    def glFogCoordfv(self, coord:typing.Sequence): ...
    def glFogf(self, pname:int, param:float): ...
    def glFogfv(self, pname:int, params:typing.Sequence): ...
    def glFogi(self, pname:int, param:int): ...
    def glFogiv(self, pname:int, params:typing.Sequence): ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glFrustum(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glGenLists(self, range:int) -> int: ...
    def glGenerateMipmap(self, target:int): ...
    def glGenerateTextureMipmap(self, texture:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetColorTable(self, target:int, format:int, type:int, table:int): ...
    def glGetCompressedTexImage(self, target:int, level:int, img:int): ...
    def glGetCompressedTextureImage(self, texture:int, level:int, bufSize:int, pixels:int): ...
    def glGetCompressedTextureSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, bufSize:int, pixels:int): ...
    def glGetConvolutionFilter(self, target:int, format:int, type:int, image:int): ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetGraphicsResetStatus(self) -> int: ...
    def glGetHistogram(self, target:int, reset:typing.Char, format:int, type:int, values:int): ...
    def glGetMinmax(self, target:int, reset:typing.Char, format:int, type:int, values:int): ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetSeparableFilter(self, target:int, format:int, type:int, row:int, column:int, span:int): ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetTexImage(self, target:int, level:int, format:int, type:int, pixels:int): ...
    def glGetTextureImage(self, texture:int, level:int, format:int, type:int, bufSize:int, pixels:int): ...
    def glGetTextureSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, bufSize:int, pixels:int): ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glGetnColorTable(self, target:int, format:int, type:int, bufSize:int, table:int): ...
    def glGetnCompressedTexImage(self, target:int, lod:int, bufSize:int, pixels:int): ...
    def glGetnConvolutionFilter(self, target:int, format:int, type:int, bufSize:int, image:int): ...
    def glGetnHistogram(self, target:int, reset:typing.Char, format:int, type:int, bufSize:int, values:int): ...
    def glGetnMinmax(self, target:int, reset:typing.Char, format:int, type:int, bufSize:int, values:int): ...
    def glGetnSeparableFilter(self, target:int, format:int, type:int, rowBufSize:int, row:int, columnBufSize:int, column:int, span:int): ...
    def glGetnTexImage(self, target:int, level:int, format:int, type:int, bufSize:int, pixels:int): ...
    def glHint(self, target:int, mode:int): ...
    def glHistogram(self, target:int, width:int, internalformat:int, sink:typing.Char): ...
    def glIndexMask(self, mask:int): ...
    def glIndexPointer(self, type:int, stride:int, pointer:int): ...
    def glIndexd(self, c:float): ...
    def glIndexdv(self, c:typing.Sequence): ...
    def glIndexf(self, c:float): ...
    def glIndexfv(self, c:typing.Sequence): ...
    def glIndexi(self, c:int): ...
    def glIndexiv(self, c:typing.Sequence): ...
    def glIndexs(self, c:int): ...
    def glIndexsv(self, c:typing.Sequence): ...
    def glIndexub(self, c:typing.Char): ...
    def glIndexubv(self, c:bytes): ...
    def glInitNames(self): ...
    def glInterleavedArrays(self, format:int, stride:int, pointer:int): ...
    def glInvalidateBufferData(self, buffer:int): ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence): ...
    def glInvalidateNamedFramebufferData(self, framebuffer:int, numAttachments:int, attachments:typing.Sequence): ...
    def glInvalidateNamedFramebufferSubData(self, framebuffer:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int): ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int): ...
    def glInvalidateTexImage(self, texture:int, level:int): ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsList(self, list:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLightModelf(self, pname:int, param:float): ...
    def glLightModelfv(self, pname:int, params:typing.Sequence): ...
    def glLightModeli(self, pname:int, param:int): ...
    def glLightModeliv(self, pname:int, params:typing.Sequence): ...
    def glLightf(self, light:int, pname:int, param:float): ...
    def glLightfv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLighti(self, light:int, pname:int, param:int): ...
    def glLightiv(self, light:int, pname:int, params:typing.Sequence): ...
    def glLineStipple(self, factor:int, pattern:int): ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glListBase(self, base:int): ...
    def glLoadIdentity(self): ...
    def glLoadMatrixd(self, m:typing.Sequence): ...
    def glLoadMatrixf(self, m:typing.Sequence): ...
    def glLoadName(self, name:int): ...
    def glLoadTransposeMatrixd(self, m:typing.Sequence): ...
    def glLoadTransposeMatrixf(self, m:typing.Sequence): ...
    def glLogicOp(self, opcode:int): ...
    def glMap1d(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap1f(self, target:int, u1:float, u2:float, stride:int, order:int, points:typing.Sequence): ...
    def glMap2d(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMap2f(self, target:int, u1:float, u2:float, ustride:int, uorder:int, v1:float, v2:float, vstride:int, vorder:int, points:typing.Sequence): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapGrid1d(self, un:int, u1:float, u2:float): ...
    def glMapGrid1f(self, un:int, u1:float, u2:float): ...
    def glMapGrid2d(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapGrid2f(self, un:int, u1:float, u2:float, vn:int, v1:float, v2:float): ...
    def glMapNamedBuffer(self, buffer:int, access:int) -> int: ...
    def glMaterialf(self, face:int, pname:int, param:float): ...
    def glMaterialfv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMateriali(self, face:int, pname:int, param:int): ...
    def glMaterialiv(self, face:int, pname:int, params:typing.Sequence): ...
    def glMatrixMode(self, mode:int): ...
    def glMemoryBarrier(self, barriers:int): ...
    def glMemoryBarrierByRegion(self, barriers:int): ...
    def glMinSampleShading(self, value:float): ...
    def glMinmax(self, target:int, internalformat:int, sink:typing.Char): ...
    def glMultMatrixd(self, m:typing.Sequence): ...
    def glMultMatrixf(self, m:typing.Sequence): ...
    def glMultTransposeMatrixd(self, m:typing.Sequence): ...
    def glMultTransposeMatrixf(self, m:typing.Sequence): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int): ...
    def glMultiTexCoord1d(self, target:int, s:float): ...
    def glMultiTexCoord1dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1f(self, target:int, s:float): ...
    def glMultiTexCoord1fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1i(self, target:int, s:int): ...
    def glMultiTexCoord1iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord1s(self, target:int, s:int): ...
    def glMultiTexCoord1sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2d(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2f(self, target:int, s:float, t:float): ...
    def glMultiTexCoord2fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2i(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord2s(self, target:int, s:int, t:int): ...
    def glMultiTexCoord2sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3d(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3f(self, target:int, s:float, t:float, r:float): ...
    def glMultiTexCoord3fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3i(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord3s(self, target:int, s:int, t:int, r:int): ...
    def glMultiTexCoord3sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4d(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4dv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4f(self, target:int, s:float, t:float, r:float, q:float): ...
    def glMultiTexCoord4fv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4i(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4iv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoord4s(self, target:int, s:int, t:int, r:int, q:int): ...
    def glMultiTexCoord4sv(self, target:int, v:typing.Sequence): ...
    def glMultiTexCoordP1ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP1uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP2ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP2uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP3ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP3uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glMultiTexCoordP4ui(self, texture:int, type:int, coords:int): ...
    def glMultiTexCoordP4uiv(self, texture:int, type:int, coords:typing.Sequence): ...
    def glNamedBufferData(self, buffer:int, size:int, data:int, usage:int): ...
    def glNamedBufferStorage(self, buffer:int, size:int, data:int, flags:int): ...
    def glNamedFramebufferDrawBuffer(self, framebuffer:int, buf:int): ...
    def glNamedFramebufferDrawBuffers(self, framebuffer:int, n:int, bufs:typing.Sequence): ...
    def glNamedFramebufferParameteri(self, framebuffer:int, pname:int, param:int): ...
    def glNamedFramebufferReadBuffer(self, framebuffer:int, src:int): ...
    def glNamedFramebufferRenderbuffer(self, framebuffer:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glNamedFramebufferTexture(self, framebuffer:int, attachment:int, texture:int, level:int): ...
    def glNamedFramebufferTextureLayer(self, framebuffer:int, attachment:int, texture:int, level:int, layer:int): ...
    def glNamedRenderbufferStorage(self, renderbuffer:int, internalformat:int, width:int, height:int): ...
    def glNamedRenderbufferStorageMultisample(self, renderbuffer:int, samples:int, internalformat:int, width:int, height:int): ...
    def glNewList(self, list:int, mode:int): ...
    def glNormal3b(self, nx:typing.Char, ny:typing.Char, nz:typing.Char): ...
    def glNormal3bv(self, v:bytes): ...
    def glNormal3d(self, nx:float, ny:float, nz:float): ...
    def glNormal3dv(self, v:typing.Sequence): ...
    def glNormal3f(self, nx:float, ny:float, nz:float): ...
    def glNormal3fv(self, v:typing.Sequence): ...
    def glNormal3i(self, nx:int, ny:int, nz:int): ...
    def glNormal3iv(self, v:typing.Sequence): ...
    def glNormal3s(self, nx:int, ny:int, nz:int): ...
    def glNormal3sv(self, v:typing.Sequence): ...
    def glNormalP3ui(self, type:int, coords:int): ...
    def glNormalP3uiv(self, type:int, coords:typing.Sequence): ...
    def glNormalPointer(self, type:int, stride:int, pointer:int): ...
    def glObjectLabel(self, identifier:int, name:int, length:int, label:bytes): ...
    def glObjectPtrLabel(self, ptr:int, length:int, label:bytes): ...
    def glOrtho(self, left:float, right:float, bottom:float, top:float, zNear:float, zFar:float): ...
    def glPassThrough(self, token:float): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelMapfv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapuiv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelMapusv(self, map:int, mapsize:int, values:typing.Sequence): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPixelTransferf(self, pname:int, param:float): ...
    def glPixelTransferi(self, pname:int, param:int): ...
    def glPixelZoom(self, xfactor:float, yfactor:float): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopAttrib(self): ...
    def glPopClientAttrib(self): ...
    def glPopDebugGroup(self): ...
    def glPopMatrix(self): ...
    def glPopName(self): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glPrioritizeTextures(self, n:int, textures:typing.Sequence, priorities:typing.Sequence): ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int): ...
    def glProgramParameteri(self, program:int, pname:int, value:int): ...
    def glProgramUniform1d(self, program:int, location:int, v0:float): ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1f(self, program:int, location:int, v0:float): ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1i(self, program:int, location:int, v0:int): ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int): ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glPushAttrib(self, mask:int): ...
    def glPushClientAttrib(self, mask:int): ...
    def glPushDebugGroup(self, source:int, id:int, length:int, message:bytes): ...
    def glPushMatrix(self): ...
    def glPushName(self, name:int): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glRasterPos2d(self, x:float, y:float): ...
    def glRasterPos2dv(self, v:typing.Sequence): ...
    def glRasterPos2f(self, x:float, y:float): ...
    def glRasterPos2fv(self, v:typing.Sequence): ...
    def glRasterPos2i(self, x:int, y:int): ...
    def glRasterPos2iv(self, v:typing.Sequence): ...
    def glRasterPos2s(self, x:int, y:int): ...
    def glRasterPos2sv(self, v:typing.Sequence): ...
    def glRasterPos3d(self, x:float, y:float, z:float): ...
    def glRasterPos3dv(self, v:typing.Sequence): ...
    def glRasterPos3f(self, x:float, y:float, z:float): ...
    def glRasterPos3fv(self, v:typing.Sequence): ...
    def glRasterPos3i(self, x:int, y:int, z:int): ...
    def glRasterPos3iv(self, v:typing.Sequence): ...
    def glRasterPos3s(self, x:int, y:int, z:int): ...
    def glRasterPos3sv(self, v:typing.Sequence): ...
    def glRasterPos4d(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4dv(self, v:typing.Sequence): ...
    def glRasterPos4f(self, x:float, y:float, z:float, w:float): ...
    def glRasterPos4fv(self, v:typing.Sequence): ...
    def glRasterPos4i(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4iv(self, v:typing.Sequence): ...
    def glRasterPos4s(self, x:int, y:int, z:int, w:int): ...
    def glRasterPos4sv(self, v:typing.Sequence): ...
    def glReadBuffer(self, src:int): ...
    def glReadPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glReadnPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, bufSize:int, data:int): ...
    def glRectd(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectdv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRectf(self, x1:float, y1:float, x2:float, y2:float): ...
    def glRectfv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRecti(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectiv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glRects(self, x1:int, y1:int, x2:int, y2:int): ...
    def glRectsv(self, v1:typing.Sequence, v2:typing.Sequence): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderMode(self, mode:int) -> int: ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResetHistogram(self, target:int): ...
    def glResetMinmax(self, target:int): ...
    def glResumeTransformFeedback(self): ...
    def glRotated(self, angle:float, x:float, y:float, z:float): ...
    def glRotatef(self, angle:float, x:float, y:float, z:float): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, maskNumber:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScaled(self, x:float, y:float, z:float): ...
    def glScalef(self, x:float, y:float, z:float): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int): ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence): ...
    def glSecondaryColor3b(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3bv(self, v:bytes): ...
    def glSecondaryColor3d(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3dv(self, v:typing.Sequence): ...
    def glSecondaryColor3f(self, red:float, green:float, blue:float): ...
    def glSecondaryColor3fv(self, v:typing.Sequence): ...
    def glSecondaryColor3i(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3iv(self, v:typing.Sequence): ...
    def glSecondaryColor3s(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3sv(self, v:typing.Sequence): ...
    def glSecondaryColor3ub(self, red:typing.Char, green:typing.Char, blue:typing.Char): ...
    def glSecondaryColor3ubv(self, v:bytes): ...
    def glSecondaryColor3ui(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3uiv(self, v:typing.Sequence): ...
    def glSecondaryColor3us(self, red:int, green:int, blue:int): ...
    def glSecondaryColor3usv(self, v:typing.Sequence): ...
    def glSecondaryColorP3ui(self, type:int, color:int): ...
    def glSecondaryColorP3uiv(self, type:int, color:typing.Sequence): ...
    def glSecondaryColorPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glSeparableFilter2D(self, target:int, internalformat:int, width:int, height:int, format:int, type:int, row:int, column:int): ...
    def glShadeModel(self, mode:int): ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int): ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexCoord1d(self, s:float): ...
    def glTexCoord1dv(self, v:typing.Sequence): ...
    def glTexCoord1f(self, s:float): ...
    def glTexCoord1fv(self, v:typing.Sequence): ...
    def glTexCoord1i(self, s:int): ...
    def glTexCoord1iv(self, v:typing.Sequence): ...
    def glTexCoord1s(self, s:int): ...
    def glTexCoord1sv(self, v:typing.Sequence): ...
    def glTexCoord2d(self, s:float, t:float): ...
    def glTexCoord2dv(self, v:typing.Sequence): ...
    def glTexCoord2f(self, s:float, t:float): ...
    def glTexCoord2fv(self, v:typing.Sequence): ...
    def glTexCoord2i(self, s:int, t:int): ...
    def glTexCoord2iv(self, v:typing.Sequence): ...
    def glTexCoord2s(self, s:int, t:int): ...
    def glTexCoord2sv(self, v:typing.Sequence): ...
    def glTexCoord3d(self, s:float, t:float, r:float): ...
    def glTexCoord3dv(self, v:typing.Sequence): ...
    def glTexCoord3f(self, s:float, t:float, r:float): ...
    def glTexCoord3fv(self, v:typing.Sequence): ...
    def glTexCoord3i(self, s:int, t:int, r:int): ...
    def glTexCoord3iv(self, v:typing.Sequence): ...
    def glTexCoord3s(self, s:int, t:int, r:int): ...
    def glTexCoord3sv(self, v:typing.Sequence): ...
    def glTexCoord4d(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4dv(self, v:typing.Sequence): ...
    def glTexCoord4f(self, s:float, t:float, r:float, q:float): ...
    def glTexCoord4fv(self, v:typing.Sequence): ...
    def glTexCoord4i(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4iv(self, v:typing.Sequence): ...
    def glTexCoord4s(self, s:int, t:int, r:int, q:int): ...
    def glTexCoord4sv(self, v:typing.Sequence): ...
    def glTexCoordP1ui(self, type:int, coords:int): ...
    def glTexCoordP1uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP2ui(self, type:int, coords:int): ...
    def glTexCoordP2uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP3ui(self, type:int, coords:int): ...
    def glTexCoordP3uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordP4ui(self, type:int, coords:int): ...
    def glTexCoordP4uiv(self, type:int, coords:typing.Sequence): ...
    def glTexCoordPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glTexEnvf(self, target:int, pname:int, param:float): ...
    def glTexEnvfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexEnvi(self, target:int, pname:int, param:int): ...
    def glTexEnviv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexGend(self, coord:int, pname:int, param:float): ...
    def glTexGendv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGenf(self, coord:int, pname:int, param:float): ...
    def glTexGenfv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexGeni(self, coord:int, pname:int, param:int): ...
    def glTexGeniv(self, coord:int, pname:int, params:typing.Sequence): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int): ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int): ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int): ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTextureBarrier(self): ...
    def glTextureBuffer(self, texture:int, internalformat:int, buffer:int): ...
    def glTextureParameterIiv(self, texture:int, pname:int, params:typing.Sequence): ...
    def glTextureParameterIuiv(self, texture:int, pname:int, params:typing.Sequence): ...
    def glTextureParameterf(self, texture:int, pname:int, param:float): ...
    def glTextureParameterfv(self, texture:int, pname:int, param:typing.Sequence): ...
    def glTextureParameteri(self, texture:int, pname:int, param:int): ...
    def glTextureParameteriv(self, texture:int, pname:int, param:typing.Sequence): ...
    def glTextureStorage1D(self, texture:int, levels:int, internalformat:int, width:int): ...
    def glTextureStorage2D(self, texture:int, levels:int, internalformat:int, width:int, height:int): ...
    def glTextureStorage2DMultisample(self, texture:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTextureStorage3D(self, texture:int, levels:int, internalformat:int, width:int, height:int, depth:int): ...
    def glTextureStorage3DMultisample(self, texture:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTextureSubImage1D(self, texture:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int): ...
    def glTransformFeedbackBufferBase(self, xfb:int, index:int, buffer:int): ...
    def glTranslated(self, x:float, y:float, z:float): ...
    def glTranslatef(self, x:float, y:float, z:float): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUnmapNamedBuffer(self, buffer:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glValidateProgramPipeline(self, pipeline:int): ...
    def glVertex2d(self, x:float, y:float): ...
    def glVertex2dv(self, v:typing.Sequence): ...
    def glVertex2f(self, x:float, y:float): ...
    def glVertex2fv(self, v:typing.Sequence): ...
    def glVertex2i(self, x:int, y:int): ...
    def glVertex2iv(self, v:typing.Sequence): ...
    def glVertex2s(self, x:int, y:int): ...
    def glVertex2sv(self, v:typing.Sequence): ...
    def glVertex3d(self, x:float, y:float, z:float): ...
    def glVertex3dv(self, v:typing.Sequence): ...
    def glVertex3f(self, x:float, y:float, z:float): ...
    def glVertex3fv(self, v:typing.Sequence): ...
    def glVertex3i(self, x:int, y:int, z:int): ...
    def glVertex3iv(self, v:typing.Sequence): ...
    def glVertex3s(self, x:int, y:int, z:int): ...
    def glVertex3sv(self, v:typing.Sequence): ...
    def glVertex4d(self, x:float, y:float, z:float, w:float): ...
    def glVertex4dv(self, v:typing.Sequence): ...
    def glVertex4f(self, x:float, y:float, z:float, w:float): ...
    def glVertex4fv(self, v:typing.Sequence): ...
    def glVertex4i(self, x:int, y:int, z:int, w:int): ...
    def glVertex4iv(self, v:typing.Sequence): ...
    def glVertex4s(self, x:int, y:int, z:int, w:int): ...
    def glVertex4sv(self, v:typing.Sequence): ...
    def glVertexArrayAttribBinding(self, vaobj:int, attribindex:int, bindingindex:int): ...
    def glVertexArrayAttribFormat(self, vaobj:int, attribindex:int, size:int, type:int, normalized:typing.Char, relativeoffset:int): ...
    def glVertexArrayAttribIFormat(self, vaobj:int, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexArrayAttribLFormat(self, vaobj:int, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexArrayBindingDivisor(self, vaobj:int, bindingindex:int, divisor:int): ...
    def glVertexArrayElementBuffer(self, vaobj:int, buffer:int): ...
    def glVertexArrayVertexBuffers(self, vaobj:int, first:int, count:int) -> typing.Tuple: ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:typing.Char, relativeoffset:int): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribL1d(self, index:int, x:float): ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL2d(self, index:int, x:float, y:float): ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int): ...
    def glVertexP2ui(self, type:int, value:int): ...
    def glVertexP2uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP3ui(self, type:int, value:int): ...
    def glVertexP3uiv(self, type:int, value:typing.Sequence): ...
    def glVertexP4ui(self, type:int, value:int): ...
    def glVertexP4uiv(self, type:int, value:typing.Sequence): ...
    def glVertexPointer(self, size:int, type:int, stride:int, pointer:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float): ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence): ...
    def glWindowPos2d(self, x:float, y:float): ...
    def glWindowPos2dv(self, v:typing.Sequence): ...
    def glWindowPos2f(self, x:float, y:float): ...
    def glWindowPos2fv(self, v:typing.Sequence): ...
    def glWindowPos2i(self, x:int, y:int): ...
    def glWindowPos2iv(self, v:typing.Sequence): ...
    def glWindowPos2s(self, x:int, y:int): ...
    def glWindowPos2sv(self, v:typing.Sequence): ...
    def glWindowPos3d(self, x:float, y:float, z:float): ...
    def glWindowPos3dv(self, v:typing.Sequence): ...
    def glWindowPos3f(self, x:float, y:float, z:float): ...
    def glWindowPos3fv(self, v:typing.Sequence): ...
    def glWindowPos3i(self, x:int, y:int, z:int): ...
    def glWindowPos3iv(self, v:typing.Sequence): ...
    def glWindowPos3s(self, x:int, y:int, z:int): ...
    def glWindowPos3sv(self, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...


class QOpenGLFunctions_4_5_Core(PySide2.QtGui.QAbstractOpenGLFunctions):

    def __init__(self): ...

    def glActiveShaderProgram(self, pipeline:int, program:int): ...
    def glActiveTexture(self, texture:int): ...
    def glAttachShader(self, program:int, shader:int): ...
    def glBeginConditionalRender(self, id:int, mode:int): ...
    def glBeginQuery(self, target:int, id:int): ...
    def glBeginQueryIndexed(self, target:int, index:int, id:int): ...
    def glBeginTransformFeedback(self, primitiveMode:int): ...
    def glBindAttribLocation(self, program:int, index:int, name:bytes): ...
    def glBindBuffer(self, target:int, buffer:int): ...
    def glBindBufferBase(self, target:int, index:int, buffer:int): ...
    def glBindBuffersBase(self, target:int, first:int, count:int, buffers:typing.Sequence): ...
    def glBindBuffersRange(self, target:int, first:int, count:int) -> typing.Tuple: ...
    def glBindFragDataLocation(self, program:int, color:int, name:bytes): ...
    def glBindFragDataLocationIndexed(self, program:int, colorNumber:int, index:int, name:bytes): ...
    def glBindFramebuffer(self, target:int, framebuffer:int): ...
    def glBindImageTexture(self, unit:int, texture:int, level:int, layered:typing.Char, layer:int, access:int, format:int): ...
    def glBindImageTextures(self, first:int, count:int, textures:typing.Sequence): ...
    def glBindProgramPipeline(self, pipeline:int): ...
    def glBindRenderbuffer(self, target:int, renderbuffer:int): ...
    def glBindSampler(self, unit:int, sampler:int): ...
    def glBindSamplers(self, first:int, count:int, samplers:typing.Sequence): ...
    def glBindTexture(self, target:int, texture:int): ...
    def glBindTextureUnit(self, unit:int, texture:int): ...
    def glBindTextures(self, first:int, count:int, textures:typing.Sequence): ...
    def glBindTransformFeedback(self, target:int, id:int): ...
    def glBindVertexArray(self, array:int): ...
    def glBindVertexBuffers(self, first:int, count:int) -> typing.Tuple: ...
    def glBlendColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glBlendEquation(self, mode:int): ...
    def glBlendEquationSeparate(self, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationSeparatei(self, buf:int, modeRGB:int, modeAlpha:int): ...
    def glBlendEquationi(self, buf:int, mode:int): ...
    def glBlendFunc(self, sfactor:int, dfactor:int): ...
    def glBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int): ...
    def glBlendFuncSeparatei(self, buf:int, srcRGB:int, dstRGB:int, srcAlpha:int, dstAlpha:int): ...
    def glBlendFunci(self, buf:int, src:int, dst:int): ...
    def glBlitFramebuffer(self, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glBlitNamedFramebuffer(self, readFramebuffer:int, drawFramebuffer:int, srcX0:int, srcY0:int, srcX1:int, srcY1:int, dstX0:int, dstY0:int, dstX1:int, dstY1:int, mask:int, filter:int): ...
    def glCheckFramebufferStatus(self, target:int) -> int: ...
    def glCheckNamedFramebufferStatus(self, framebuffer:int, target:int) -> int: ...
    def glClampColor(self, target:int, clamp:int): ...
    def glClear(self, mask:int): ...
    def glClearBufferData(self, target:int, internalformat:int, format:int, type:int, data:int): ...
    def glClearBufferfi(self, buffer:int, drawbuffer:int, depth:float, stencil:int): ...
    def glClearBufferfv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearBufferuiv(self, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearColor(self, red:float, green:float, blue:float, alpha:float): ...
    def glClearDepth(self, depth:float): ...
    def glClearDepthf(self, dd:float): ...
    def glClearNamedBufferData(self, buffer:int, internalformat:int, format:int, type:int, data:int): ...
    def glClearNamedFramebufferfi(self, framebuffer:int, buffer:int, depth:float, stencil:int): ...
    def glClearNamedFramebufferfv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearNamedFramebufferiv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearNamedFramebufferuiv(self, framebuffer:int, buffer:int, drawbuffer:int, value:typing.Sequence): ...
    def glClearStencil(self, s:int): ...
    def glClearTexImage(self, texture:int, level:int, format:int, type:int, data:int): ...
    def glClearTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, data:int): ...
    def glClipControl(self, origin:int, depth:int): ...
    def glColorMask(self, red:typing.Char, green:typing.Char, blue:typing.Char, alpha:typing.Char): ...
    def glColorMaski(self, index:int, r:typing.Char, g:typing.Char, b:typing.Char, a:typing.Char): ...
    def glCompileShader(self, shader:int): ...
    def glCompressedTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCompressedTextureSubImage1D(self, texture:int, level:int, xoffset:int, width:int, format:int, imageSize:int, data:int): ...
    def glCompressedTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, imageSize:int, data:int): ...
    def glCompressedTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, imageSize:int, data:int): ...
    def glCopyImageSubData(self, srcName:int, srcTarget:int, srcLevel:int, srcX:int, srcY:int, srcZ:int, dstName:int, dstTarget:int, dstLevel:int, dstX:int, dstY:int, dstZ:int, srcWidth:int, srcHeight:int, srcDepth:int): ...
    def glCopyTexImage1D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, border:int): ...
    def glCopyTexImage2D(self, target:int, level:int, internalformat:int, x:int, y:int, width:int, height:int, border:int): ...
    def glCopyTexSubImage1D(self, target:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTextureSubImage1D(self, texture:int, level:int, xoffset:int, x:int, y:int, width:int): ...
    def glCopyTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, x:int, y:int, width:int, height:int): ...
    def glCopyTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, x:int, y:int, width:int, height:int): ...
    def glCreateProgram(self) -> int: ...
    def glCreateShader(self, type:int) -> int: ...
    def glCullFace(self, mode:int): ...
    def glDebugMessageControl(self, source:int, type:int, severity:int, count:int, ids:typing.Sequence, enabled:typing.Char): ...
    def glDebugMessageInsert(self, source:int, type:int, id:int, severity:int, length:int, buf:bytes): ...
    def glDeleteBuffers(self, n:int, buffers:typing.Sequence): ...
    def glDeleteFramebuffers(self, n:int, framebuffers:typing.Sequence): ...
    def glDeleteProgram(self, program:int): ...
    def glDeleteProgramPipelines(self, n:int, pipelines:typing.Sequence): ...
    def glDeleteQueries(self, n:int, ids:typing.Sequence): ...
    def glDeleteRenderbuffers(self, n:int, renderbuffers:typing.Sequence): ...
    def glDeleteSamplers(self, count:int, samplers:typing.Sequence): ...
    def glDeleteShader(self, shader:int): ...
    def glDeleteTextures(self, n:int, textures:typing.Sequence): ...
    def glDeleteTransformFeedbacks(self, n:int, ids:typing.Sequence): ...
    def glDeleteVertexArrays(self, n:int, arrays:typing.Sequence): ...
    def glDepthFunc(self, func:int): ...
    def glDepthMask(self, flag:typing.Char): ...
    def glDepthRange(self, nearVal:float, farVal:float): ...
    def glDepthRangeArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glDepthRangeIndexed(self, index:int, n:float, f:float): ...
    def glDepthRangef(self, n:float, f:float): ...
    def glDetachShader(self, program:int, shader:int): ...
    def glDisable(self, cap:int): ...
    def glDisableVertexArrayAttrib(self, vaobj:int, index:int): ...
    def glDisableVertexAttribArray(self, index:int): ...
    def glDisablei(self, target:int, index:int): ...
    def glDispatchCompute(self, num_groups_x:int, num_groups_y:int, num_groups_z:int): ...
    def glDrawArrays(self, mode:int, first:int, count:int): ...
    def glDrawArraysIndirect(self, mode:int, indirect:int): ...
    def glDrawArraysInstanced(self, mode:int, first:int, count:int, instancecount:int): ...
    def glDrawArraysInstancedBaseInstance(self, mode:int, first:int, count:int, instancecount:int, baseinstance:int): ...
    def glDrawBuffer(self, buf:int): ...
    def glDrawBuffers(self, n:int, bufs:typing.Sequence): ...
    def glDrawElements(self, mode:int, count:int, type:int, indices:int): ...
    def glDrawElementsBaseVertex(self, mode:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawElementsIndirect(self, mode:int, type:int, indirect:int): ...
    def glDrawElementsInstanced(self, mode:int, count:int, type:int, indices:int, instancecount:int): ...
    def glDrawElementsInstancedBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, baseinstance:int): ...
    def glDrawElementsInstancedBaseVertex(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int): ...
    def glDrawElementsInstancedBaseVertexBaseInstance(self, mode:int, count:int, type:int, indices:int, instancecount:int, basevertex:int, baseinstance:int): ...
    def glDrawRangeElements(self, mode:int, start:int, end:int, count:int, type:int, indices:int): ...
    def glDrawRangeElementsBaseVertex(self, mode:int, start:int, end:int, count:int, type:int, indices:int, basevertex:int): ...
    def glDrawTransformFeedback(self, mode:int, id:int): ...
    def glDrawTransformFeedbackInstanced(self, mode:int, id:int, instancecount:int): ...
    def glDrawTransformFeedbackStream(self, mode:int, id:int, stream:int): ...
    def glDrawTransformFeedbackStreamInstanced(self, mode:int, id:int, stream:int, instancecount:int): ...
    def glEnable(self, cap:int): ...
    def glEnableVertexArrayAttrib(self, vaobj:int, index:int): ...
    def glEnableVertexAttribArray(self, index:int): ...
    def glEnablei(self, target:int, index:int): ...
    def glEndConditionalRender(self): ...
    def glEndQuery(self, target:int): ...
    def glEndQueryIndexed(self, target:int, index:int): ...
    def glEndTransformFeedback(self): ...
    def glFinish(self): ...
    def glFlush(self): ...
    def glFramebufferParameteri(self, target:int, pname:int, param:int): ...
    def glFramebufferRenderbuffer(self, target:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glFramebufferTexture(self, target:int, attachment:int, texture:int, level:int): ...
    def glFramebufferTexture1D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture2D(self, target:int, attachment:int, textarget:int, texture:int, level:int): ...
    def glFramebufferTexture3D(self, target:int, attachment:int, textarget:int, texture:int, level:int, zoffset:int): ...
    def glFramebufferTextureLayer(self, target:int, attachment:int, texture:int, level:int, layer:int): ...
    def glFrontFace(self, mode:int): ...
    def glGenerateMipmap(self, target:int): ...
    def glGenerateTextureMipmap(self, texture:int): ...
    def glGetAttribLocation(self, program:int, name:bytes) -> int: ...
    def glGetCompressedTexImage(self, target:int, level:int, img:int): ...
    def glGetCompressedTextureImage(self, texture:int, level:int, bufSize:int, pixels:int): ...
    def glGetCompressedTextureSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, bufSize:int, pixels:int): ...
    def glGetError(self) -> int: ...
    def glGetFragDataIndex(self, program:int, name:bytes) -> int: ...
    def glGetFragDataLocation(self, program:int, name:bytes) -> int: ...
    def glGetGraphicsResetStatus(self) -> int: ...
    def glGetProgramResourceIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocation(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetProgramResourceLocationIndex(self, program:int, programInterface:int, name:bytes) -> int: ...
    def glGetString(self, name:int) -> bytes: ...
    def glGetStringi(self, name:int, index:int) -> bytes: ...
    def glGetSubroutineIndex(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetSubroutineUniformLocation(self, program:int, shadertype:int, name:bytes) -> int: ...
    def glGetTexImage(self, target:int, level:int, format:int, type:int, pixels:int): ...
    def glGetTextureImage(self, texture:int, level:int, format:int, type:int, bufSize:int, pixels:int): ...
    def glGetTextureSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, bufSize:int, pixels:int): ...
    def glGetUniformBlockIndex(self, program:int, uniformBlockName:bytes) -> int: ...
    def glGetUniformLocation(self, program:int, name:bytes) -> int: ...
    def glGetnCompressedTexImage(self, target:int, lod:int, bufSize:int, pixels:int): ...
    def glGetnTexImage(self, target:int, level:int, format:int, type:int, bufSize:int, pixels:int): ...
    def glHint(self, target:int, mode:int): ...
    def glInvalidateBufferData(self, buffer:int): ...
    def glInvalidateFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence): ...
    def glInvalidateNamedFramebufferData(self, framebuffer:int, numAttachments:int, attachments:typing.Sequence): ...
    def glInvalidateNamedFramebufferSubData(self, framebuffer:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int): ...
    def glInvalidateSubFramebuffer(self, target:int, numAttachments:int, attachments:typing.Sequence, x:int, y:int, width:int, height:int): ...
    def glInvalidateTexImage(self, texture:int, level:int): ...
    def glInvalidateTexSubImage(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int): ...
    def glIsBuffer(self, buffer:int) -> typing.Char: ...
    def glIsEnabled(self, cap:int) -> typing.Char: ...
    def glIsEnabledi(self, target:int, index:int) -> typing.Char: ...
    def glIsFramebuffer(self, framebuffer:int) -> typing.Char: ...
    def glIsProgram(self, program:int) -> typing.Char: ...
    def glIsProgramPipeline(self, pipeline:int) -> typing.Char: ...
    def glIsQuery(self, id:int) -> typing.Char: ...
    def glIsRenderbuffer(self, renderbuffer:int) -> typing.Char: ...
    def glIsSampler(self, sampler:int) -> typing.Char: ...
    def glIsShader(self, shader:int) -> typing.Char: ...
    def glIsTexture(self, texture:int) -> typing.Char: ...
    def glIsTransformFeedback(self, id:int) -> typing.Char: ...
    def glIsVertexArray(self, array:int) -> typing.Char: ...
    def glLineWidth(self, width:float): ...
    def glLinkProgram(self, program:int): ...
    def glLogicOp(self, opcode:int): ...
    def glMapBuffer(self, target:int, access:int) -> int: ...
    def glMapNamedBuffer(self, buffer:int, access:int) -> int: ...
    def glMemoryBarrier(self, barriers:int): ...
    def glMemoryBarrierByRegion(self, barriers:int): ...
    def glMinSampleShading(self, value:float): ...
    def glMultiDrawArrays(self, mode:int, first:typing.Sequence, count:typing.Sequence, drawcount:int): ...
    def glMultiDrawArraysIndirect(self, mode:int, indirect:int, drawcount:int, stride:int): ...
    def glNamedBufferData(self, buffer:int, size:int, data:int, usage:int): ...
    def glNamedBufferStorage(self, buffer:int, size:int, data:int, flags:int): ...
    def glNamedFramebufferDrawBuffer(self, framebuffer:int, buf:int): ...
    def glNamedFramebufferDrawBuffers(self, framebuffer:int, n:int, bufs:typing.Sequence): ...
    def glNamedFramebufferParameteri(self, framebuffer:int, pname:int, param:int): ...
    def glNamedFramebufferReadBuffer(self, framebuffer:int, src:int): ...
    def glNamedFramebufferRenderbuffer(self, framebuffer:int, attachment:int, renderbuffertarget:int, renderbuffer:int): ...
    def glNamedFramebufferTexture(self, framebuffer:int, attachment:int, texture:int, level:int): ...
    def glNamedFramebufferTextureLayer(self, framebuffer:int, attachment:int, texture:int, level:int, layer:int): ...
    def glNamedRenderbufferStorage(self, renderbuffer:int, internalformat:int, width:int, height:int): ...
    def glNamedRenderbufferStorageMultisample(self, renderbuffer:int, samples:int, internalformat:int, width:int, height:int): ...
    def glObjectLabel(self, identifier:int, name:int, length:int, label:bytes): ...
    def glObjectPtrLabel(self, ptr:int, length:int, label:bytes): ...
    def glPatchParameterfv(self, pname:int, values:typing.Sequence): ...
    def glPatchParameteri(self, pname:int, value:int): ...
    def glPauseTransformFeedback(self): ...
    def glPixelStoref(self, pname:int, param:float): ...
    def glPixelStorei(self, pname:int, param:int): ...
    def glPointParameterf(self, pname:int, param:float): ...
    def glPointParameterfv(self, pname:int, params:typing.Sequence): ...
    def glPointParameteri(self, pname:int, param:int): ...
    def glPointParameteriv(self, pname:int, params:typing.Sequence): ...
    def glPointSize(self, size:float): ...
    def glPolygonMode(self, face:int, mode:int): ...
    def glPolygonOffset(self, factor:float, units:float): ...
    def glPopDebugGroup(self): ...
    def glPrimitiveRestartIndex(self, index:int): ...
    def glProgramBinary(self, program:int, binaryFormat:int, binary:int, length:int): ...
    def glProgramParameteri(self, program:int, pname:int, value:int): ...
    def glProgramUniform1d(self, program:int, location:int, v0:float): ...
    def glProgramUniform1dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1f(self, program:int, location:int, v0:float): ...
    def glProgramUniform1fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1i(self, program:int, location:int, v0:int): ...
    def glProgramUniform1iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform1ui(self, program:int, location:int, v0:int): ...
    def glProgramUniform1uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2d(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2f(self, program:int, location:int, v0:float, v1:float): ...
    def glProgramUniform2fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2i(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform2ui(self, program:int, location:int, v0:int, v1:int): ...
    def glProgramUniform2uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3d(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3f(self, program:int, location:int, v0:float, v1:float, v2:float): ...
    def glProgramUniform3fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3i(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform3ui(self, program:int, location:int, v0:int, v1:int, v2:int): ...
    def glProgramUniform3uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4d(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4dv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4f(self, program:int, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glProgramUniform4fv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4i(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4iv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniform4ui(self, program:int, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glProgramUniform4uiv(self, program:int, location:int, count:int, value:typing.Sequence): ...
    def glProgramUniformMatrix2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix2x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix3x4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x2fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3dv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProgramUniformMatrix4x3fv(self, program:int, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glProvokingVertex(self, mode:int): ...
    def glPushDebugGroup(self, source:int, id:int, length:int, message:bytes): ...
    def glQueryCounter(self, id:int, target:int): ...
    def glReadBuffer(self, src:int): ...
    def glReadPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glReadnPixels(self, x:int, y:int, width:int, height:int, format:int, type:int, bufSize:int, data:int): ...
    def glReleaseShaderCompiler(self): ...
    def glRenderbufferStorage(self, target:int, internalformat:int, width:int, height:int): ...
    def glRenderbufferStorageMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int): ...
    def glResumeTransformFeedback(self): ...
    def glSampleCoverage(self, value:float, invert:typing.Char): ...
    def glSampleMaski(self, maskNumber:int, mask:int): ...
    def glSamplerParameterIiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterIuiv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameterf(self, sampler:int, pname:int, param:float): ...
    def glSamplerParameterfv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glSamplerParameteri(self, sampler:int, pname:int, param:int): ...
    def glSamplerParameteriv(self, sampler:int, pname:int, param:typing.Sequence): ...
    def glScissor(self, x:int, y:int, width:int, height:int): ...
    def glScissorArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glScissorIndexed(self, index:int, left:int, bottom:int, width:int, height:int): ...
    def glScissorIndexedv(self, index:int, v:typing.Sequence): ...
    def glShaderBinary(self, count:int, shaders:typing.Sequence, binaryformat:int, binary:int, length:int): ...
    def glShaderStorageBlockBinding(self, program:int, storageBlockIndex:int, storageBlockBinding:int): ...
    def glStencilFunc(self, func:int, ref:int, mask:int): ...
    def glStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int): ...
    def glStencilMask(self, mask:int): ...
    def glStencilMaskSeparate(self, face:int, mask:int): ...
    def glStencilOp(self, fail:int, zfail:int, zpass:int): ...
    def glStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int): ...
    def glTexBuffer(self, target:int, internalformat:int, buffer:int): ...
    def glTexImage1D(self, target:int, level:int, internalformat:int, width:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2D(self, target:int, level:int, internalformat:int, width:int, height:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexImage3D(self, target:int, level:int, internalformat:int, width:int, height:int, depth:int, border:int, format:int, type:int, pixels:int): ...
    def glTexImage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexParameterIiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterIuiv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameterf(self, target:int, pname:int, param:float): ...
    def glTexParameterfv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexParameteri(self, target:int, pname:int, param:int): ...
    def glTexParameteriv(self, target:int, pname:int, params:typing.Sequence): ...
    def glTexStorage1D(self, target:int, levels:int, internalformat:int, width:int): ...
    def glTexStorage2D(self, target:int, levels:int, internalformat:int, width:int, height:int): ...
    def glTexStorage2DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTexStorage3D(self, target:int, levels:int, internalformat:int, width:int, height:int, depth:int): ...
    def glTexStorage3DMultisample(self, target:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTexSubImage1D(self, target:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTexSubImage2D(self, target:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTexSubImage3D(self, target:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTextureBarrier(self): ...
    def glTextureBuffer(self, texture:int, internalformat:int, buffer:int): ...
    def glTextureParameterIiv(self, texture:int, pname:int, params:typing.Sequence): ...
    def glTextureParameterIuiv(self, texture:int, pname:int, params:typing.Sequence): ...
    def glTextureParameterf(self, texture:int, pname:int, param:float): ...
    def glTextureParameterfv(self, texture:int, pname:int, param:typing.Sequence): ...
    def glTextureParameteri(self, texture:int, pname:int, param:int): ...
    def glTextureParameteriv(self, texture:int, pname:int, param:typing.Sequence): ...
    def glTextureStorage1D(self, texture:int, levels:int, internalformat:int, width:int): ...
    def glTextureStorage2D(self, texture:int, levels:int, internalformat:int, width:int, height:int): ...
    def glTextureStorage2DMultisample(self, texture:int, samples:int, internalformat:int, width:int, height:int, fixedsamplelocations:typing.Char): ...
    def glTextureStorage3D(self, texture:int, levels:int, internalformat:int, width:int, height:int, depth:int): ...
    def glTextureStorage3DMultisample(self, texture:int, samples:int, internalformat:int, width:int, height:int, depth:int, fixedsamplelocations:typing.Char): ...
    def glTextureSubImage1D(self, texture:int, level:int, xoffset:int, width:int, format:int, type:int, pixels:int): ...
    def glTextureSubImage2D(self, texture:int, level:int, xoffset:int, yoffset:int, width:int, height:int, format:int, type:int, pixels:int): ...
    def glTextureSubImage3D(self, texture:int, level:int, xoffset:int, yoffset:int, zoffset:int, width:int, height:int, depth:int, format:int, type:int, pixels:int): ...
    def glTextureView(self, texture:int, target:int, origtexture:int, internalformat:int, minlevel:int, numlevels:int, minlayer:int, numlayers:int): ...
    def glTransformFeedbackBufferBase(self, xfb:int, index:int, buffer:int): ...
    def glUniform1d(self, location:int, x:float): ...
    def glUniform1dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1f(self, location:int, v0:float): ...
    def glUniform1fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1i(self, location:int, v0:int): ...
    def glUniform1iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform1ui(self, location:int, v0:int): ...
    def glUniform1uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2d(self, location:int, x:float, y:float): ...
    def glUniform2dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2f(self, location:int, v0:float, v1:float): ...
    def glUniform2fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2i(self, location:int, v0:int, v1:int): ...
    def glUniform2iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform2ui(self, location:int, v0:int, v1:int): ...
    def glUniform2uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3d(self, location:int, x:float, y:float, z:float): ...
    def glUniform3dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3f(self, location:int, v0:float, v1:float, v2:float): ...
    def glUniform3fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3i(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform3ui(self, location:int, v0:int, v1:int, v2:int): ...
    def glUniform3uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4d(self, location:int, x:float, y:float, z:float, w:float): ...
    def glUniform4dv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4f(self, location:int, v0:float, v1:float, v2:float, v3:float): ...
    def glUniform4fv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4i(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4iv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniform4ui(self, location:int, v0:int, v1:int, v2:int, v3:int): ...
    def glUniform4uiv(self, location:int, count:int, value:typing.Sequence): ...
    def glUniformBlockBinding(self, program:int, uniformBlockIndex:int, uniformBlockBinding:int): ...
    def glUniformMatrix2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix2x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix3x4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x2fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3dv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformMatrix4x3fv(self, location:int, count:int, transpose:typing.Char, value:typing.Sequence): ...
    def glUniformSubroutinesuiv(self, shadertype:int, count:int, indices:typing.Sequence): ...
    def glUnmapBuffer(self, target:int) -> typing.Char: ...
    def glUnmapNamedBuffer(self, buffer:int) -> typing.Char: ...
    def glUseProgram(self, program:int): ...
    def glUseProgramStages(self, pipeline:int, stages:int, program:int): ...
    def glValidateProgram(self, program:int): ...
    def glValidateProgramPipeline(self, pipeline:int): ...
    def glVertexArrayAttribBinding(self, vaobj:int, attribindex:int, bindingindex:int): ...
    def glVertexArrayAttribFormat(self, vaobj:int, attribindex:int, size:int, type:int, normalized:typing.Char, relativeoffset:int): ...
    def glVertexArrayAttribIFormat(self, vaobj:int, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexArrayAttribLFormat(self, vaobj:int, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexArrayBindingDivisor(self, vaobj:int, bindingindex:int, divisor:int): ...
    def glVertexArrayElementBuffer(self, vaobj:int, buffer:int): ...
    def glVertexArrayVertexBuffers(self, vaobj:int, first:int, count:int) -> typing.Tuple: ...
    def glVertexAttrib1d(self, index:int, x:float): ...
    def glVertexAttrib1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1f(self, index:int, x:float): ...
    def glVertexAttrib1fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib1s(self, index:int, x:int): ...
    def glVertexAttrib1sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2d(self, index:int, x:float, y:float): ...
    def glVertexAttrib2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2f(self, index:int, x:float, y:float): ...
    def glVertexAttrib2fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib2s(self, index:int, x:int, y:int): ...
    def glVertexAttrib2sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3f(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttrib3fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib3s(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttrib3sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nbv(self, index:int, v:bytes): ...
    def glVertexAttrib4Niv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nsv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nub(self, index:int, x:typing.Char, y:typing.Char, z:typing.Char, w:typing.Char): ...
    def glVertexAttrib4Nubv(self, index:int, v:bytes): ...
    def glVertexAttrib4Nuiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4Nusv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4bv(self, index:int, v:bytes): ...
    def glVertexAttrib4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4f(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttrib4fv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4s(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttrib4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4ubv(self, index:int, v:bytes): ...
    def glVertexAttrib4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttrib4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribBinding(self, attribindex:int, bindingindex:int): ...
    def glVertexAttribDivisor(self, index:int, divisor:int): ...
    def glVertexAttribFormat(self, attribindex:int, size:int, type:int, normalized:typing.Char, relativeoffset:int): ...
    def glVertexAttribI1i(self, index:int, x:int): ...
    def glVertexAttribI1iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI1ui(self, index:int, x:int): ...
    def glVertexAttribI1uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2i(self, index:int, x:int, y:int): ...
    def glVertexAttribI2iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI2ui(self, index:int, x:int, y:int): ...
    def glVertexAttribI2uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3i(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI3ui(self, index:int, x:int, y:int, z:int): ...
    def glVertexAttribI3uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4bv(self, index:int, v:bytes): ...
    def glVertexAttribI4i(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4iv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4sv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4ubv(self, index:int, v:bytes): ...
    def glVertexAttribI4ui(self, index:int, x:int, y:int, z:int, w:int): ...
    def glVertexAttribI4uiv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribI4usv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribIFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribIPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribL1d(self, index:int, x:float): ...
    def glVertexAttribL1dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL2d(self, index:int, x:float, y:float): ...
    def glVertexAttribL2dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL3d(self, index:int, x:float, y:float, z:float): ...
    def glVertexAttribL3dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribL4d(self, index:int, x:float, y:float, z:float, w:float): ...
    def glVertexAttribL4dv(self, index:int, v:typing.Sequence): ...
    def glVertexAttribLFormat(self, attribindex:int, size:int, type:int, relativeoffset:int): ...
    def glVertexAttribLPointer(self, index:int, size:int, type:int, stride:int, pointer:int): ...
    def glVertexAttribP1ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP1uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP2ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP2uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP3ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP3uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribP4ui(self, index:int, type:int, normalized:typing.Char, value:int): ...
    def glVertexAttribP4uiv(self, index:int, type:int, normalized:typing.Char, value:typing.Sequence): ...
    def glVertexAttribPointer(self, index:int, size:int, type:int, normalized:typing.Char, stride:int, pointer:int): ...
    def glVertexBindingDivisor(self, bindingindex:int, divisor:int): ...
    def glViewport(self, x:int, y:int, width:int, height:int): ...
    def glViewportArrayv(self, first:int, count:int, v:typing.Sequence): ...
    def glViewportIndexedf(self, index:int, x:float, y:float, w:float, h:float): ...
    def glViewportIndexedfv(self, index:int, v:typing.Sequence): ...
    def initializeOpenGLFunctions(self) -> bool: ...

# eof
