# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2019 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtWidgets, except for defaults which are replaced by "...".
"""

# Module PySide2.QtWidgets
import PySide2
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets


class QAbstractButton(PySide2.QtWidgets.QWidget):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def animateClick(self, msec:int=...): ...
    def autoExclusive(self) -> bool: ...
    def autoRepeat(self) -> bool: ...
    def autoRepeatDelay(self) -> int: ...
    def autoRepeatInterval(self) -> int: ...
    def changeEvent(self, e:PySide2.QtCore.QEvent): ...
    def checkStateSet(self): ...
    def click(self): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, e:PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, e:PySide2.QtGui.QFocusEvent): ...
    def group(self) -> PySide2.QtWidgets.QButtonGroup: ...
    def hitButton(self, pos:PySide2.QtCore.QPoint) -> bool: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isDown(self) -> bool: ...
    def keyPressEvent(self, e:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, e:PySide2.QtGui.QKeyEvent): ...
    def mouseMoveEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def nextCheckState(self): ...
    def paintEvent(self, e:PySide2.QtGui.QPaintEvent): ...
    def setAutoExclusive(self, arg__1:bool): ...
    def setAutoRepeat(self, arg__1:bool): ...
    def setAutoRepeatDelay(self, arg__1:int): ...
    def setAutoRepeatInterval(self, arg__1:int): ...
    def setCheckable(self, arg__1:bool): ...
    def setChecked(self, arg__1:bool): ...
    def setDown(self, arg__1:bool): ...
    def setIcon(self, icon:PySide2.QtGui.QIcon): ...
    def setIconSize(self, size:PySide2.QtCore.QSize): ...
    def setShortcut(self, key:PySide2.QtGui.QKeySequence): ...
    def setText(self, text:str): ...
    def shortcut(self) -> PySide2.QtGui.QKeySequence: ...
    def text(self) -> str: ...
    def timerEvent(self, e:PySide2.QtCore.QTimerEvent): ...
    def toggle(self): ...


class QAbstractGraphicsShapeItem(PySide2.QtWidgets.QGraphicsItem):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def brush(self) -> PySide2.QtGui.QBrush: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    def setBrush(self, brush:PySide2.QtGui.QBrush): ...
    def setPen(self, pen:PySide2.QtGui.QPen): ...


class QAbstractItemDelegate(PySide2.QtCore.QObject):
    NoHint                   : QAbstractItemDelegate = ... # 0x0
    EditNextItem             : QAbstractItemDelegate = ... # 0x1
    EditPreviousItem         : QAbstractItemDelegate = ... # 0x2
    SubmitModelCache         : QAbstractItemDelegate = ... # 0x3
    RevertModelCache         : QAbstractItemDelegate = ... # 0x4

    class EndEditHint(object):
        NoHint                   : QAbstractItemDelegate.EndEditHint = ... # 0x0
        EditNextItem             : QAbstractItemDelegate.EndEditHint = ... # 0x1
        EditPreviousItem         : QAbstractItemDelegate.EndEditHint = ... # 0x2
        SubmitModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x3
        RevertModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x4

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def createEditor(self, parent:PySide2.QtWidgets.QWidget, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def destroyEditor(self, editor:PySide2.QtWidgets.QWidget, index:PySide2.QtCore.QModelIndex): ...
    def editorEvent(self, event:PySide2.QtCore.QEvent, model:PySide2.QtCore.QAbstractItemModel, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex) -> bool: ...
    @staticmethod
    def elidedText(fontMetrics:PySide2.QtGui.QFontMetrics, width:int, mode:PySide2.QtCore.Qt.TextElideMode, text:str) -> str: ...
    def helpEvent(self, event:PySide2.QtGui.QHelpEvent, view:PySide2.QtWidgets.QAbstractItemView, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex): ...
    def paintingRoles(self) -> typing.List: ...
    def setEditorData(self, editor:PySide2.QtWidgets.QWidget, index:PySide2.QtCore.QModelIndex): ...
    def setModelData(self, editor:PySide2.QtWidgets.QWidget, model:PySide2.QtCore.QAbstractItemModel, index:PySide2.QtCore.QModelIndex): ...
    def sizeHint(self, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def updateEditorGeometry(self, editor:PySide2.QtWidgets.QWidget, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex): ...


class QAbstractItemView(PySide2.QtWidgets.QAbstractScrollArea):
    EnsureVisible            : QAbstractItemView = ... # 0x0
    MoveUp                   : QAbstractItemView = ... # 0x0
    NoDragDrop               : QAbstractItemView = ... # 0x0
    NoEditTriggers           : QAbstractItemView = ... # 0x0
    NoSelection              : QAbstractItemView = ... # 0x0
    NoState                  : QAbstractItemView = ... # 0x0
    OnItem                   : QAbstractItemView = ... # 0x0
    ScrollPerItem            : QAbstractItemView = ... # 0x0
    SelectItems              : QAbstractItemView = ... # 0x0
    AboveItem                : QAbstractItemView = ... # 0x1
    CurrentChanged           : QAbstractItemView = ... # 0x1
    DragOnly                 : QAbstractItemView = ... # 0x1
    DraggingState            : QAbstractItemView = ... # 0x1
    MoveDown                 : QAbstractItemView = ... # 0x1
    PositionAtTop            : QAbstractItemView = ... # 0x1
    ScrollPerPixel           : QAbstractItemView = ... # 0x1
    SelectRows               : QAbstractItemView = ... # 0x1
    SingleSelection          : QAbstractItemView = ... # 0x1
    BelowItem                : QAbstractItemView = ... # 0x2
    DoubleClicked            : QAbstractItemView = ... # 0x2
    DragSelectingState       : QAbstractItemView = ... # 0x2
    DropOnly                 : QAbstractItemView = ... # 0x2
    MoveLeft                 : QAbstractItemView = ... # 0x2
    MultiSelection           : QAbstractItemView = ... # 0x2
    PositionAtBottom         : QAbstractItemView = ... # 0x2
    SelectColumns            : QAbstractItemView = ... # 0x2
    DragDrop                 : QAbstractItemView = ... # 0x3
    EditingState             : QAbstractItemView = ... # 0x3
    ExtendedSelection        : QAbstractItemView = ... # 0x3
    MoveRight                : QAbstractItemView = ... # 0x3
    OnViewport               : QAbstractItemView = ... # 0x3
    PositionAtCenter         : QAbstractItemView = ... # 0x3
    ContiguousSelection      : QAbstractItemView = ... # 0x4
    ExpandingState           : QAbstractItemView = ... # 0x4
    InternalMove             : QAbstractItemView = ... # 0x4
    MoveHome                 : QAbstractItemView = ... # 0x4
    SelectedClicked          : QAbstractItemView = ... # 0x4
    CollapsingState          : QAbstractItemView = ... # 0x5
    MoveEnd                  : QAbstractItemView = ... # 0x5
    AnimatingState           : QAbstractItemView = ... # 0x6
    MovePageUp               : QAbstractItemView = ... # 0x6
    MovePageDown             : QAbstractItemView = ... # 0x7
    EditKeyPressed           : QAbstractItemView = ... # 0x8
    MoveNext                 : QAbstractItemView = ... # 0x8
    MovePrevious             : QAbstractItemView = ... # 0x9
    AnyKeyPressed            : QAbstractItemView = ... # 0x10
    AllEditTriggers          : QAbstractItemView = ... # 0x1f

    class CursorAction(object):
        MoveUp                   : QAbstractItemView.CursorAction = ... # 0x0
        MoveDown                 : QAbstractItemView.CursorAction = ... # 0x1
        MoveLeft                 : QAbstractItemView.CursorAction = ... # 0x2
        MoveRight                : QAbstractItemView.CursorAction = ... # 0x3
        MoveHome                 : QAbstractItemView.CursorAction = ... # 0x4
        MoveEnd                  : QAbstractItemView.CursorAction = ... # 0x5
        MovePageUp               : QAbstractItemView.CursorAction = ... # 0x6
        MovePageDown             : QAbstractItemView.CursorAction = ... # 0x7
        MoveNext                 : QAbstractItemView.CursorAction = ... # 0x8
        MovePrevious             : QAbstractItemView.CursorAction = ... # 0x9

    class DragDropMode(object):
        NoDragDrop               : QAbstractItemView.DragDropMode = ... # 0x0
        DragOnly                 : QAbstractItemView.DragDropMode = ... # 0x1
        DropOnly                 : QAbstractItemView.DragDropMode = ... # 0x2
        DragDrop                 : QAbstractItemView.DragDropMode = ... # 0x3
        InternalMove             : QAbstractItemView.DragDropMode = ... # 0x4

    class DropIndicatorPosition(object):
        OnItem                   : QAbstractItemView.DropIndicatorPosition = ... # 0x0
        AboveItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x1
        BelowItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x2
        OnViewport               : QAbstractItemView.DropIndicatorPosition = ... # 0x3

    class EditTrigger(object):
        NoEditTriggers           : QAbstractItemView.EditTrigger = ... # 0x0
        CurrentChanged           : QAbstractItemView.EditTrigger = ... # 0x1
        DoubleClicked            : QAbstractItemView.EditTrigger = ... # 0x2
        SelectedClicked          : QAbstractItemView.EditTrigger = ... # 0x4
        EditKeyPressed           : QAbstractItemView.EditTrigger = ... # 0x8
        AnyKeyPressed            : QAbstractItemView.EditTrigger = ... # 0x10
        AllEditTriggers          : QAbstractItemView.EditTrigger = ... # 0x1f

    class EditTriggers(object): ...

    class ScrollHint(object):
        EnsureVisible            : QAbstractItemView.ScrollHint = ... # 0x0
        PositionAtTop            : QAbstractItemView.ScrollHint = ... # 0x1
        PositionAtBottom         : QAbstractItemView.ScrollHint = ... # 0x2
        PositionAtCenter         : QAbstractItemView.ScrollHint = ... # 0x3

    class ScrollMode(object):
        ScrollPerItem            : QAbstractItemView.ScrollMode = ... # 0x0
        ScrollPerPixel           : QAbstractItemView.ScrollMode = ... # 0x1

    class SelectionBehavior(object):
        SelectItems              : QAbstractItemView.SelectionBehavior = ... # 0x0
        SelectRows               : QAbstractItemView.SelectionBehavior = ... # 0x1
        SelectColumns            : QAbstractItemView.SelectionBehavior = ... # 0x2

    class SelectionMode(object):
        NoSelection              : QAbstractItemView.SelectionMode = ... # 0x0
        SingleSelection          : QAbstractItemView.SelectionMode = ... # 0x1
        MultiSelection           : QAbstractItemView.SelectionMode = ... # 0x2
        ExtendedSelection        : QAbstractItemView.SelectionMode = ... # 0x3
        ContiguousSelection      : QAbstractItemView.SelectionMode = ... # 0x4

    class State(object):
        NoState                  : QAbstractItemView.State = ... # 0x0
        DraggingState            : QAbstractItemView.State = ... # 0x1
        DragSelectingState       : QAbstractItemView.State = ... # 0x2
        EditingState             : QAbstractItemView.State = ... # 0x3
        ExpandingState           : QAbstractItemView.State = ... # 0x4
        CollapsingState          : QAbstractItemView.State = ... # 0x5
        AnimatingState           : QAbstractItemView.State = ... # 0x6

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def alternatingRowColors(self) -> bool: ...
    def autoScrollMargin(self) -> int: ...
    def clearSelection(self): ...
    def closeEditor(self, editor:PySide2.QtWidgets.QWidget, hint:PySide2.QtWidgets.QAbstractItemDelegate.EndEditHint): ...
    def closePersistentEditor(self, index:PySide2.QtCore.QModelIndex): ...
    def commitData(self, editor:PySide2.QtWidgets.QWidget): ...
    def currentChanged(self, current:PySide2.QtCore.QModelIndex, previous:PySide2.QtCore.QModelIndex): ...
    def currentIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def dataChanged(self, topLeft:PySide2.QtCore.QModelIndex, bottomRight:PySide2.QtCore.QModelIndex, roles:typing.List=...): ...
    def defaultDropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def dirtyRegionOffset(self) -> PySide2.QtCore.QPoint: ...
    def doAutoScroll(self): ...
    def doItemsLayout(self): ...
    def dragDropMode(self) -> PySide2.QtWidgets.QAbstractItemView.DragDropMode: ...
    def dragDropOverwriteMode(self) -> bool: ...
    def dragEnabled(self) -> bool: ...
    def dragEnterEvent(self, event:PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, event:PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, event:PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, event:PySide2.QtGui.QDropEvent): ...
    def dropIndicatorPosition(self) -> PySide2.QtWidgets.QAbstractItemView.DropIndicatorPosition: ...
    @typing.overload
    def edit(self, index:PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def edit(self, index:PySide2.QtCore.QModelIndex, trigger:PySide2.QtWidgets.QAbstractItemView.EditTrigger, event:PySide2.QtCore.QEvent) -> bool: ...
    def editTriggers(self) -> PySide2.QtWidgets.QAbstractItemView.EditTriggers: ...
    def editorDestroyed(self, editor:PySide2.QtCore.QObject): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object:PySide2.QtCore.QObject, event:PySide2.QtCore.QEvent) -> bool: ...
    def executeDelayedItemsLayout(self): ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def focusOutEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def hasAutoScroll(self) -> bool: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollMode(self) -> PySide2.QtWidgets.QAbstractItemView.ScrollMode: ...
    def horizontalScrollbarAction(self, action:int): ...
    def horizontalScrollbarValueChanged(self, value:int): ...
    def horizontalStepsPerItem(self) -> int: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def indexAt(self, point:PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def indexWidget(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def inputMethodEvent(self, event:PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodQuery(self, query:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isIndexHidden(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def isPersistentEditorOpen(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    @typing.overload
    def itemDelegate(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForColumn(self, column:int) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForRow(self, row:int) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def keyboardSearch(self, search:str): ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def mouseDoubleClickEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, cursorAction:PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def openPersistentEditor(self, index:PySide2.QtCore.QModelIndex): ...
    def reset(self): ...
    def resetHorizontalScrollMode(self): ...
    def resetVerticalScrollMode(self): ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent): ...
    def rootIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def rowsAboutToBeRemoved(self, parent:PySide2.QtCore.QModelIndex, start:int, end:int): ...
    def rowsInserted(self, parent:PySide2.QtCore.QModelIndex, start:int, end:int): ...
    def scheduleDelayedItemsLayout(self): ...
    def scrollDirtyRegion(self, dx:int, dy:int): ...
    def scrollTo(self, index:PySide2.QtCore.QModelIndex, hint:PySide2.QtWidgets.QAbstractItemView.ScrollHint=...): ...
    def scrollToBottom(self): ...
    def scrollToTop(self): ...
    def selectAll(self): ...
    def selectedIndexes(self) -> typing.List: ...
    def selectionBehavior(self) -> PySide2.QtWidgets.QAbstractItemView.SelectionBehavior: ...
    def selectionChanged(self, selected:PySide2.QtCore.QItemSelection, deselected:PySide2.QtCore.QItemSelection): ...
    def selectionCommand(self, index:PySide2.QtCore.QModelIndex, event:typing.Optional[PySide2.QtCore.QEvent]=...) -> PySide2.QtCore.QItemSelectionModel.SelectionFlags: ...
    def selectionMode(self) -> PySide2.QtWidgets.QAbstractItemView.SelectionMode: ...
    def selectionModel(self) -> PySide2.QtCore.QItemSelectionModel: ...
    def setAlternatingRowColors(self, enable:bool): ...
    def setAutoScroll(self, enable:bool): ...
    def setAutoScrollMargin(self, margin:int): ...
    def setCurrentIndex(self, index:PySide2.QtCore.QModelIndex): ...
    def setDefaultDropAction(self, dropAction:PySide2.QtCore.Qt.DropAction): ...
    def setDirtyRegion(self, region:PySide2.QtGui.QRegion): ...
    def setDragDropMode(self, behavior:PySide2.QtWidgets.QAbstractItemView.DragDropMode): ...
    def setDragDropOverwriteMode(self, overwrite:bool): ...
    def setDragEnabled(self, enable:bool): ...
    def setDropIndicatorShown(self, enable:bool): ...
    def setEditTriggers(self, triggers:PySide2.QtWidgets.QAbstractItemView.EditTriggers): ...
    def setHorizontalScrollMode(self, mode:PySide2.QtWidgets.QAbstractItemView.ScrollMode): ...
    def setHorizontalStepsPerItem(self, steps:int): ...
    def setIconSize(self, size:PySide2.QtCore.QSize): ...
    def setIndexWidget(self, index:PySide2.QtCore.QModelIndex, widget:PySide2.QtWidgets.QWidget): ...
    def setItemDelegate(self, delegate:PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setItemDelegateForColumn(self, column:int, delegate:PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setItemDelegateForRow(self, row:int, delegate:PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setModel(self, model:PySide2.QtCore.QAbstractItemModel): ...
    def setRootIndex(self, index:PySide2.QtCore.QModelIndex): ...
    def setSelection(self, rect:PySide2.QtCore.QRect, command:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSelectionBehavior(self, behavior:PySide2.QtWidgets.QAbstractItemView.SelectionBehavior): ...
    def setSelectionMode(self, mode:PySide2.QtWidgets.QAbstractItemView.SelectionMode): ...
    def setSelectionModel(self, selectionModel:PySide2.QtCore.QItemSelectionModel): ...
    def setState(self, state:PySide2.QtWidgets.QAbstractItemView.State): ...
    def setTabKeyNavigation(self, enable:bool): ...
    def setTextElideMode(self, mode:PySide2.QtCore.Qt.TextElideMode): ...
    def setVerticalScrollMode(self, mode:PySide2.QtWidgets.QAbstractItemView.ScrollMode): ...
    def setVerticalStepsPerItem(self, steps:int): ...
    def showDropIndicator(self) -> bool: ...
    def sizeHintForColumn(self, column:int) -> int: ...
    def sizeHintForIndex(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def sizeHintForRow(self, row:int) -> int: ...
    def startAutoScroll(self): ...
    def startDrag(self, supportedActions:PySide2.QtCore.Qt.DropActions): ...
    def state(self) -> PySide2.QtWidgets.QAbstractItemView.State: ...
    def stopAutoScroll(self): ...
    def tabKeyNavigation(self) -> bool: ...
    def textElideMode(self) -> PySide2.QtCore.Qt.TextElideMode: ...
    def timerEvent(self, event:PySide2.QtCore.QTimerEvent): ...
    @typing.overload
    def update(self): ...
    @typing.overload
    def update(self, index:PySide2.QtCore.QModelIndex): ...
    def updateEditorData(self): ...
    def updateEditorGeometries(self): ...
    def updateGeometries(self): ...
    def verticalOffset(self) -> int: ...
    def verticalScrollMode(self) -> PySide2.QtWidgets.QAbstractItemView.ScrollMode: ...
    def verticalScrollbarAction(self, action:int): ...
    def verticalScrollbarValueChanged(self, value:int): ...
    def verticalStepsPerItem(self) -> int: ...
    def viewOptions(self) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def viewportEvent(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection:PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...


class QAbstractScrollArea(PySide2.QtWidgets.QFrame):
    AdjustIgnored            : QAbstractScrollArea = ... # 0x0
    AdjustToContentsOnFirstShow: QAbstractScrollArea = ... # 0x1
    AdjustToContents         : QAbstractScrollArea = ... # 0x2

    class SizeAdjustPolicy(object):
        AdjustIgnored            : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x0
        AdjustToContentsOnFirstShow: QAbstractScrollArea.SizeAdjustPolicy = ... # 0x1
        AdjustToContents         : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def addScrollBarWidget(self, widget:PySide2.QtWidgets.QWidget, alignment:PySide2.QtCore.Qt.Alignment): ...
    def contextMenuEvent(self, arg__1:PySide2.QtGui.QContextMenuEvent): ...
    def cornerWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def dragEnterEvent(self, arg__1:PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, arg__1:PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, arg__1:PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, arg__1:PySide2.QtGui.QDropEvent): ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1:PySide2.QtCore.QObject, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    def horizontalScrollBar(self) -> PySide2.QtWidgets.QScrollBar: ...
    def horizontalScrollBarPolicy(self) -> PySide2.QtCore.Qt.ScrollBarPolicy: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent): ...
    def maximumViewportSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent): ...
    def scrollBarWidgets(self, alignment:PySide2.QtCore.Qt.Alignment) -> typing.List: ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def setCornerWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def setHorizontalScrollBar(self, scrollbar:PySide2.QtWidgets.QScrollBar): ...
    def setHorizontalScrollBarPolicy(self, arg__1:PySide2.QtCore.Qt.ScrollBarPolicy): ...
    def setSizeAdjustPolicy(self, policy:PySide2.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy): ...
    def setVerticalScrollBar(self, scrollbar:PySide2.QtWidgets.QScrollBar): ...
    def setVerticalScrollBarPolicy(self, arg__1:PySide2.QtCore.Qt.ScrollBarPolicy): ...
    def setViewport(self, widget:PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def setViewportMargins(self, left:int, top:int, right:int, bottom:int): ...
    @typing.overload
    def setViewportMargins(self, margins:PySide2.QtCore.QMargins): ...
    def setupViewport(self, viewport:PySide2.QtWidgets.QWidget): ...
    def sizeAdjustPolicy(self) -> PySide2.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def verticalScrollBar(self) -> PySide2.QtWidgets.QScrollBar: ...
    def verticalScrollBarPolicy(self) -> PySide2.QtCore.Qt.ScrollBarPolicy: ...
    def viewport(self) -> PySide2.QtWidgets.QWidget: ...
    def viewportEvent(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def viewportMargins(self) -> PySide2.QtCore.QMargins: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def wheelEvent(self, arg__1:PySide2.QtGui.QWheelEvent): ...


class QAbstractSlider(PySide2.QtWidgets.QWidget):
    SliderNoAction           : QAbstractSlider = ... # 0x0
    SliderRangeChange        : QAbstractSlider = ... # 0x0
    SliderOrientationChange  : QAbstractSlider = ... # 0x1
    SliderSingleStepAdd      : QAbstractSlider = ... # 0x1
    SliderSingleStepSub      : QAbstractSlider = ... # 0x2
    SliderStepsChange        : QAbstractSlider = ... # 0x2
    SliderPageStepAdd        : QAbstractSlider = ... # 0x3
    SliderValueChange        : QAbstractSlider = ... # 0x3
    SliderPageStepSub        : QAbstractSlider = ... # 0x4
    SliderToMinimum          : QAbstractSlider = ... # 0x5
    SliderToMaximum          : QAbstractSlider = ... # 0x6
    SliderMove               : QAbstractSlider = ... # 0x7

    class SliderAction(object):
        SliderNoAction           : QAbstractSlider.SliderAction = ... # 0x0
        SliderSingleStepAdd      : QAbstractSlider.SliderAction = ... # 0x1
        SliderSingleStepSub      : QAbstractSlider.SliderAction = ... # 0x2
        SliderPageStepAdd        : QAbstractSlider.SliderAction = ... # 0x3
        SliderPageStepSub        : QAbstractSlider.SliderAction = ... # 0x4
        SliderToMinimum          : QAbstractSlider.SliderAction = ... # 0x5
        SliderToMaximum          : QAbstractSlider.SliderAction = ... # 0x6
        SliderMove               : QAbstractSlider.SliderAction = ... # 0x7

    class SliderChange(object):
        SliderRangeChange        : QAbstractSlider.SliderChange = ... # 0x0
        SliderOrientationChange  : QAbstractSlider.SliderChange = ... # 0x1
        SliderStepsChange        : QAbstractSlider.SliderChange = ... # 0x2
        SliderValueChange        : QAbstractSlider.SliderChange = ... # 0x3

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def changeEvent(self, e:PySide2.QtCore.QEvent): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def hasTracking(self) -> bool: ...
    def invertedAppearance(self) -> bool: ...
    def invertedControls(self) -> bool: ...
    def isSliderDown(self) -> bool: ...
    def keyPressEvent(self, ev:PySide2.QtGui.QKeyEvent): ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def pageStep(self) -> int: ...
    def repeatAction(self) -> PySide2.QtWidgets.QAbstractSlider.SliderAction: ...
    def setInvertedAppearance(self, arg__1:bool): ...
    def setInvertedControls(self, arg__1:bool): ...
    def setMaximum(self, arg__1:int): ...
    def setMinimum(self, arg__1:int): ...
    def setOrientation(self, arg__1:PySide2.QtCore.Qt.Orientation): ...
    def setPageStep(self, arg__1:int): ...
    def setRange(self, min:int, max:int): ...
    def setRepeatAction(self, action:PySide2.QtWidgets.QAbstractSlider.SliderAction, thresholdTime:int=..., repeatTime:int=...): ...
    def setSingleStep(self, arg__1:int): ...
    def setSliderDown(self, arg__1:bool): ...
    def setSliderPosition(self, arg__1:int): ...
    def setTracking(self, enable:bool): ...
    def setValue(self, arg__1:int): ...
    def singleStep(self) -> int: ...
    def sliderChange(self, change:PySide2.QtWidgets.QAbstractSlider.SliderChange): ...
    def sliderPosition(self) -> int: ...
    def timerEvent(self, arg__1:PySide2.QtCore.QTimerEvent): ...
    def triggerAction(self, action:PySide2.QtWidgets.QAbstractSlider.SliderAction): ...
    def value(self) -> int: ...
    def wheelEvent(self, e:PySide2.QtGui.QWheelEvent): ...


class QAbstractSpinBox(PySide2.QtWidgets.QWidget):
    CorrectToPreviousValue   : QAbstractSpinBox = ... # 0x0
    DefaultStepType          : QAbstractSpinBox = ... # 0x0
    StepNone                 : QAbstractSpinBox = ... # 0x0
    UpDownArrows             : QAbstractSpinBox = ... # 0x0
    AdaptiveDecimalStepType  : QAbstractSpinBox = ... # 0x1
    CorrectToNearestValue    : QAbstractSpinBox = ... # 0x1
    PlusMinus                : QAbstractSpinBox = ... # 0x1
    StepUpEnabled            : QAbstractSpinBox = ... # 0x1
    NoButtons                : QAbstractSpinBox = ... # 0x2
    StepDownEnabled          : QAbstractSpinBox = ... # 0x2

    class ButtonSymbols(object):
        UpDownArrows             : QAbstractSpinBox.ButtonSymbols = ... # 0x0
        PlusMinus                : QAbstractSpinBox.ButtonSymbols = ... # 0x1
        NoButtons                : QAbstractSpinBox.ButtonSymbols = ... # 0x2

    class CorrectionMode(object):
        CorrectToPreviousValue   : QAbstractSpinBox.CorrectionMode = ... # 0x0
        CorrectToNearestValue    : QAbstractSpinBox.CorrectionMode = ... # 0x1

    class StepEnabled(object): ...

    class StepEnabledFlag(object):
        StepNone                 : QAbstractSpinBox.StepEnabledFlag = ... # 0x0
        StepUpEnabled            : QAbstractSpinBox.StepEnabledFlag = ... # 0x1
        StepDownEnabled          : QAbstractSpinBox.StepEnabledFlag = ... # 0x2

    class StepType(object):
        DefaultStepType          : QAbstractSpinBox.StepType = ... # 0x0
        AdaptiveDecimalStepType  : QAbstractSpinBox.StepType = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def buttonSymbols(self) -> PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols: ...
    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def closeEvent(self, event:PySide2.QtGui.QCloseEvent): ...
    def contextMenuEvent(self, event:PySide2.QtGui.QContextMenuEvent): ...
    def correctionMode(self) -> PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode: ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, input:str): ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def hasAcceptableInput(self) -> bool: ...
    def hasFrame(self) -> bool: ...
    def hideEvent(self, event:PySide2.QtGui.QHideEvent): ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionSpinBox): ...
    def inputMethodQuery(self, arg__1:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def interpretText(self): ...
    def isAccelerated(self) -> bool: ...
    def isGroupSeparatorShown(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def keyboardTracking(self) -> bool: ...
    def lineEdit(self) -> PySide2.QtWidgets.QLineEdit: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent): ...
    def selectAll(self): ...
    def setAccelerated(self, on:bool): ...
    def setAlignment(self, flag:PySide2.QtCore.Qt.Alignment): ...
    def setButtonSymbols(self, bs:PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols): ...
    def setCorrectionMode(self, cm:PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode): ...
    def setFrame(self, arg__1:bool): ...
    def setGroupSeparatorShown(self, shown:bool): ...
    def setKeyboardTracking(self, kt:bool): ...
    def setLineEdit(self, edit:PySide2.QtWidgets.QLineEdit): ...
    def setReadOnly(self, r:bool): ...
    def setSpecialValueText(self, txt:str): ...
    def setWrapping(self, w:bool): ...
    def showEvent(self, event:PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def specialValueText(self) -> str: ...
    def stepBy(self, steps:int): ...
    def stepDown(self): ...
    def stepEnabled(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepEnabled: ...
    def stepUp(self): ...
    def text(self) -> str: ...
    def timerEvent(self, event:PySide2.QtCore.QTimerEvent): ...
    def validate(self, input:str, pos:int) -> PySide2.QtGui.QValidator.State: ...
    def wheelEvent(self, event:PySide2.QtGui.QWheelEvent): ...
    def wrapping(self) -> bool: ...


class QAccessibleWidget(PySide2.QtGui.QAccessibleObject):

    def __init__(self, o:PySide2.QtWidgets.QWidget, r:PySide2.QtGui.QAccessible.Role=..., name:str=...): ...

    def actionNames(self) -> typing.List: ...
    def addControllingSignal(self, signal:str): ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def child(self, index:int) -> PySide2.QtGui.QAccessibleInterface: ...
    def childCount(self) -> int: ...
    def doAction(self, actionName:str): ...
    def focusChild(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def foregroundColor(self) -> PySide2.QtGui.QColor: ...
    def indexOfChild(self, child:PySide2.QtGui.QAccessibleInterface) -> int: ...
    def interface_cast(self, t:PySide2.QtGui.QAccessible.InterfaceType) -> int: ...
    def isValid(self) -> bool: ...
    def keyBindingsForAction(self, actionName:str) -> typing.List: ...
    def parent(self) -> PySide2.QtGui.QAccessibleInterface: ...
    def parentObject(self) -> PySide2.QtCore.QObject: ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def relations(self, match:PySide2.QtGui.QAccessible.Relation=...) -> typing.List: ...
    def role(self) -> PySide2.QtGui.QAccessible.Role: ...
    def state(self) -> PySide2.QtGui.QAccessible.State: ...
    def text(self, t:PySide2.QtGui.QAccessible.Text) -> str: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    def window(self) -> PySide2.QtGui.QWindow: ...


class QAction(PySide2.QtCore.QObject):
    LowPriority              : QAction = ... # 0x0
    NoRole                   : QAction = ... # 0x0
    Trigger                  : QAction = ... # 0x0
    Hover                    : QAction = ... # 0x1
    TextHeuristicRole        : QAction = ... # 0x1
    ApplicationSpecificRole  : QAction = ... # 0x2
    AboutQtRole              : QAction = ... # 0x3
    AboutRole                : QAction = ... # 0x4
    PreferencesRole          : QAction = ... # 0x5
    QuitRole                 : QAction = ... # 0x6
    NormalPriority           : QAction = ... # 0x80
    HighPriority             : QAction = ... # 0x100

    class ActionEvent(object):
        Trigger                  : QAction.ActionEvent = ... # 0x0
        Hover                    : QAction.ActionEvent = ... # 0x1

    class MenuRole(object):
        NoRole                   : QAction.MenuRole = ... # 0x0
        TextHeuristicRole        : QAction.MenuRole = ... # 0x1
        ApplicationSpecificRole  : QAction.MenuRole = ... # 0x2
        AboutQtRole              : QAction.MenuRole = ... # 0x3
        AboutRole                : QAction.MenuRole = ... # 0x4
        PreferencesRole          : QAction.MenuRole = ... # 0x5
        QuitRole                 : QAction.MenuRole = ... # 0x6

    class Priority(object):
        LowPriority              : QAction.Priority = ... # 0x0
        NormalPriority           : QAction.Priority = ... # 0x80
        HighPriority             : QAction.Priority = ... # 0x100

    @typing.overload
    def __init__(self, icon:PySide2.QtGui.QIcon, text:str, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def actionGroup(self) -> PySide2.QtWidgets.QActionGroup: ...
    def activate(self, event:PySide2.QtWidgets.QAction.ActionEvent): ...
    def associatedGraphicsWidgets(self) -> typing.List: ...
    def associatedWidgets(self) -> typing.List: ...
    def autoRepeat(self) -> bool: ...
    def data(self) -> typing.Any: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def hover(self): ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def iconText(self) -> str: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isIconVisibleInMenu(self) -> bool: ...
    def isSeparator(self) -> bool: ...
    def isShortcutVisibleInContextMenu(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def menu(self) -> PySide2.QtWidgets.QMenu: ...
    def menuRole(self) -> PySide2.QtWidgets.QAction.MenuRole: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def priority(self) -> PySide2.QtWidgets.QAction.Priority: ...
    def setActionGroup(self, group:PySide2.QtWidgets.QActionGroup): ...
    def setAutoRepeat(self, arg__1:bool): ...
    def setCheckable(self, arg__1:bool): ...
    def setChecked(self, arg__1:bool): ...
    def setData(self, var:typing.Any): ...
    def setDisabled(self, b:bool): ...
    def setEnabled(self, arg__1:bool): ...
    def setFont(self, font:PySide2.QtGui.QFont): ...
    def setIcon(self, icon:PySide2.QtGui.QIcon): ...
    def setIconText(self, text:str): ...
    def setIconVisibleInMenu(self, visible:bool): ...
    def setMenu(self, menu:PySide2.QtWidgets.QMenu): ...
    def setMenuRole(self, menuRole:PySide2.QtWidgets.QAction.MenuRole): ...
    def setPriority(self, priority:PySide2.QtWidgets.QAction.Priority): ...
    def setSeparator(self, b:bool): ...
    def setShortcut(self, shortcut:PySide2.QtGui.QKeySequence): ...
    def setShortcutContext(self, context:PySide2.QtCore.Qt.ShortcutContext): ...
    def setShortcutVisibleInContextMenu(self, show:bool): ...
    @typing.overload
    def setShortcuts(self, arg__1:PySide2.QtGui.QKeySequence.StandardKey): ...
    @typing.overload
    def setShortcuts(self, shortcuts:typing.Sequence): ...
    def setStatusTip(self, statusTip:str): ...
    def setText(self, text:str): ...
    def setToolTip(self, tip:str): ...
    def setVisible(self, arg__1:bool): ...
    def setWhatsThis(self, what:str): ...
    def shortcut(self) -> PySide2.QtGui.QKeySequence: ...
    def shortcutContext(self) -> PySide2.QtCore.Qt.ShortcutContext: ...
    def shortcuts(self) -> typing.List: ...
    def showStatusText(self, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> bool: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def toggle(self): ...
    def toolTip(self) -> str: ...
    def trigger(self): ...
    def whatsThis(self) -> str: ...


class QActionGroup(PySide2.QtCore.QObject):

    class ExclusionPolicy(object):
        None_                    : QActionGroup.ExclusionPolicy = ... # 0x0
        Exclusive                : QActionGroup.ExclusionPolicy = ... # 0x1
        ExclusiveOptional        : QActionGroup.ExclusionPolicy = ... # 0x2

    def __init__(self, parent:PySide2.QtCore.QObject): ...

    def actions(self) -> typing.List: ...
    @typing.overload
    def addAction(self, a:PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, icon:PySide2.QtGui.QIcon, text:str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text:str) -> PySide2.QtWidgets.QAction: ...
    def checkedAction(self) -> PySide2.QtWidgets.QAction: ...
    def exclusionPolicy(self) -> PySide2.QtWidgets.QActionGroup.ExclusionPolicy: ...
    def isEnabled(self) -> bool: ...
    def isExclusive(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def removeAction(self, a:PySide2.QtWidgets.QAction): ...
    def setDisabled(self, b:bool): ...
    def setEnabled(self, arg__1:bool): ...
    def setExclusionPolicy(self, policy:PySide2.QtWidgets.QActionGroup.ExclusionPolicy): ...
    def setExclusive(self, arg__1:bool): ...
    def setVisible(self, arg__1:bool): ...


class QApplication(PySide2.QtGui.QGuiApplication):
    NormalColor              : QApplication = ... # 0x0
    CustomColor              : QApplication = ... # 0x1
    ManyColor                : QApplication = ... # 0x2

    class ColorSpec(object):
        NormalColor              : QApplication.ColorSpec = ... # 0x0
        CustomColor              : QApplication.ColorSpec = ... # 0x1
        ManyColor                : QApplication.ColorSpec = ... # 0x2

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, arg__1:typing.Sequence): ...

    @staticmethod
    def aboutQt(): ...
    @staticmethod
    def activeModalWidget() -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def activePopupWidget() -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def activeWindow() -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def alert(widget:PySide2.QtWidgets.QWidget, duration:int=...): ...
    @staticmethod
    def allWidgets() -> typing.List: ...
    def autoSipEnabled(self) -> bool: ...
    @staticmethod
    def beep(): ...
    @staticmethod
    def closeAllWindows(): ...
    @staticmethod
    def colorSpec() -> int: ...
    @staticmethod
    def cursorFlashTime() -> int: ...
    @staticmethod
    def desktop() -> PySide2.QtWidgets.QDesktopWidget: ...
    @staticmethod
    def doubleClickInterval() -> int: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec_() -> int: ...
    @staticmethod
    def focusWidget() -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    @staticmethod
    def font() -> PySide2.QtGui.QFont: ...
    @typing.overload
    @staticmethod
    def font(arg__1:PySide2.QtWidgets.QWidget) -> PySide2.QtGui.QFont: ...
    @typing.overload
    @staticmethod
    def font(className:bytes) -> PySide2.QtGui.QFont: ...
    @staticmethod
    def fontMetrics() -> PySide2.QtGui.QFontMetrics: ...
    @staticmethod
    def globalStrut() -> PySide2.QtCore.QSize: ...
    @staticmethod
    def isEffectEnabled(arg__1:PySide2.QtCore.Qt.UIEffect) -> bool: ...
    @staticmethod
    def keyboardInputInterval() -> int: ...
    def notify(self, arg__1:PySide2.QtCore.QObject, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    @staticmethod
    def palette() -> PySide2.QtGui.QPalette: ...
    @typing.overload
    @staticmethod
    def palette(arg__1:PySide2.QtWidgets.QWidget) -> PySide2.QtGui.QPalette: ...
    @typing.overload
    @staticmethod
    def palette(className:bytes) -> PySide2.QtGui.QPalette: ...
    @staticmethod
    def setActiveWindow(act:PySide2.QtWidgets.QWidget): ...
    def setAutoSipEnabled(self, enabled:bool): ...
    @staticmethod
    def setColorSpec(arg__1:int): ...
    @staticmethod
    def setCursorFlashTime(arg__1:int): ...
    @staticmethod
    def setDoubleClickInterval(arg__1:int): ...
    @staticmethod
    def setEffectEnabled(arg__1:PySide2.QtCore.Qt.UIEffect, enable:bool=...): ...
    @typing.overload
    @staticmethod
    def setFont(arg__1:PySide2.QtGui.QFont): ...
    @typing.overload
    @staticmethod
    def setFont(arg__1:PySide2.QtGui.QFont, className:typing.Optional[bytes]=...): ...
    @staticmethod
    def setGlobalStrut(arg__1:PySide2.QtCore.QSize): ...
    @staticmethod
    def setKeyboardInputInterval(arg__1:int): ...
    @typing.overload
    @staticmethod
    def setPalette(arg__1:PySide2.QtGui.QPalette, className:typing.Optional[bytes]=...): ...
    @typing.overload
    @staticmethod
    def setPalette(pal:PySide2.QtGui.QPalette): ...
    @staticmethod
    def setStartDragDistance(l:int): ...
    @staticmethod
    def setStartDragTime(ms:int): ...
    @typing.overload
    @staticmethod
    def setStyle(arg__1:PySide2.QtWidgets.QStyle): ...
    @typing.overload
    @staticmethod
    def setStyle(arg__1:str) -> PySide2.QtWidgets.QStyle: ...
    def setStyleSheet(self, sheet:str): ...
    @staticmethod
    def setWheelScrollLines(arg__1:int): ...
    @staticmethod
    def setWindowIcon(icon:PySide2.QtGui.QIcon): ...
    @staticmethod
    def startDragDistance() -> int: ...
    @staticmethod
    def startDragTime() -> int: ...
    @staticmethod
    def style() -> PySide2.QtWidgets.QStyle: ...
    def styleSheet(self) -> str: ...
    @typing.overload
    @staticmethod
    def topLevelAt(p:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    @staticmethod
    def topLevelAt(x:int, y:int) -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def topLevelWidgets() -> typing.List: ...
    @staticmethod
    def wheelScrollLines() -> int: ...
    @typing.overload
    @staticmethod
    def widgetAt(p:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    @staticmethod
    def widgetAt(x:int, y:int) -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def windowIcon() -> PySide2.QtGui.QIcon: ...


class QBoxLayout(PySide2.QtWidgets.QLayout):
    LeftToRight              : QBoxLayout = ... # 0x0
    RightToLeft              : QBoxLayout = ... # 0x1
    Down                     : QBoxLayout = ... # 0x2
    TopToBottom              : QBoxLayout = ... # 0x2
    BottomToTop              : QBoxLayout = ... # 0x3
    Up                       : QBoxLayout = ... # 0x3

    class Direction(object):
        LeftToRight              : QBoxLayout.Direction = ... # 0x0
        RightToLeft              : QBoxLayout.Direction = ... # 0x1
        Down                     : QBoxLayout.Direction = ... # 0x2
        TopToBottom              : QBoxLayout.Direction = ... # 0x2
        BottomToTop              : QBoxLayout.Direction = ... # 0x3
        Up                       : QBoxLayout.Direction = ... # 0x3

    def __init__(self, arg__1:PySide2.QtWidgets.QBoxLayout.Direction, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def addItem(self, arg__1:PySide2.QtWidgets.QLayoutItem): ...
    def addLayout(self, layout:PySide2.QtWidgets.QLayout, stretch:int=...): ...
    def addSpacerItem(self, spacerItem:PySide2.QtWidgets.QSpacerItem): ...
    def addSpacing(self, size:int): ...
    def addStretch(self, stretch:int=...): ...
    def addStrut(self, arg__1:int): ...
    @typing.overload
    def addWidget(self, arg__1:PySide2.QtWidgets.QWidget, stretch:int=..., alignment:PySide2.QtCore.Qt.Alignment=...): ...
    @typing.overload
    def addWidget(self, w:PySide2.QtWidgets.QWidget): ...
    def count(self) -> int: ...
    def direction(self) -> PySide2.QtWidgets.QBoxLayout.Direction: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1:int) -> int: ...
    def insertItem(self, index:int, arg__2:PySide2.QtWidgets.QLayoutItem): ...
    def insertLayout(self, index:int, layout:PySide2.QtWidgets.QLayout, stretch:int=...): ...
    def insertSpacerItem(self, index:int, spacerItem:PySide2.QtWidgets.QSpacerItem): ...
    def insertSpacing(self, index:int, size:int): ...
    def insertStretch(self, index:int, stretch:int=...): ...
    def insertWidget(self, index:int, widget:PySide2.QtWidgets.QWidget, stretch:int=..., alignment:PySide2.QtCore.Qt.Alignment=...): ...
    def invalidate(self): ...
    def itemAt(self, arg__1:int) -> PySide2.QtWidgets.QLayoutItem: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1:int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setDirection(self, arg__1:PySide2.QtWidgets.QBoxLayout.Direction): ...
    def setGeometry(self, arg__1:PySide2.QtCore.QRect): ...
    def setSpacing(self, spacing:int): ...
    def setStretch(self, index:int, stretch:int): ...
    @typing.overload
    def setStretchFactor(self, l:PySide2.QtWidgets.QLayout, stretch:int) -> bool: ...
    @typing.overload
    def setStretchFactor(self, w:PySide2.QtWidgets.QWidget, stretch:int) -> bool: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def stretch(self, index:int) -> int: ...
    def takeAt(self, arg__1:int) -> PySide2.QtWidgets.QLayoutItem: ...


class QButtonGroup(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def addButton(self, arg__1:PySide2.QtWidgets.QAbstractButton, id:int=...): ...
    def button(self, id:int) -> PySide2.QtWidgets.QAbstractButton: ...
    def buttons(self) -> typing.List: ...
    def checkedButton(self) -> PySide2.QtWidgets.QAbstractButton: ...
    def checkedId(self) -> int: ...
    def exclusive(self) -> bool: ...
    def id(self, button:PySide2.QtWidgets.QAbstractButton) -> int: ...
    def removeButton(self, arg__1:PySide2.QtWidgets.QAbstractButton): ...
    def setExclusive(self, arg__1:bool): ...
    def setId(self, button:PySide2.QtWidgets.QAbstractButton, id:int): ...


class QCalendarWidget(PySide2.QtWidgets.QWidget):
    NoHorizontalHeader       : QCalendarWidget = ... # 0x0
    NoSelection              : QCalendarWidget = ... # 0x0
    NoVerticalHeader         : QCalendarWidget = ... # 0x0
    ISOWeekNumbers           : QCalendarWidget = ... # 0x1
    SingleLetterDayNames     : QCalendarWidget = ... # 0x1
    SingleSelection          : QCalendarWidget = ... # 0x1
    ShortDayNames            : QCalendarWidget = ... # 0x2
    LongDayNames             : QCalendarWidget = ... # 0x3

    class HorizontalHeaderFormat(object):
        NoHorizontalHeader       : QCalendarWidget.HorizontalHeaderFormat = ... # 0x0
        SingleLetterDayNames     : QCalendarWidget.HorizontalHeaderFormat = ... # 0x1
        ShortDayNames            : QCalendarWidget.HorizontalHeaderFormat = ... # 0x2
        LongDayNames             : QCalendarWidget.HorizontalHeaderFormat = ... # 0x3

    class SelectionMode(object):
        NoSelection              : QCalendarWidget.SelectionMode = ... # 0x0
        SingleSelection          : QCalendarWidget.SelectionMode = ... # 0x1

    class VerticalHeaderFormat(object):
        NoVerticalHeader         : QCalendarWidget.VerticalHeaderFormat = ... # 0x0
        ISOWeekNumbers           : QCalendarWidget.VerticalHeaderFormat = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def calendar(self) -> PySide2.QtCore.QCalendar: ...
    def dateEditAcceptDelay(self) -> int: ...
    @typing.overload
    def dateTextFormat(self) -> typing.Dict: ...
    @typing.overload
    def dateTextFormat(self, date:PySide2.QtCore.QDate) -> PySide2.QtGui.QTextCharFormat: ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched:PySide2.QtCore.QObject, event:PySide2.QtCore.QEvent) -> bool: ...
    def firstDayOfWeek(self) -> PySide2.QtCore.Qt.DayOfWeek: ...
    def headerTextFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def horizontalHeaderFormat(self) -> PySide2.QtWidgets.QCalendarWidget.HorizontalHeaderFormat: ...
    def isDateEditEnabled(self) -> bool: ...
    def isGridVisible(self) -> bool: ...
    def isNavigationBarVisible(self) -> bool: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def maximumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def monthShown(self) -> int: ...
    def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def paintCell(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRect, date:PySide2.QtCore.QDate): ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent): ...
    def selectedDate(self) -> PySide2.QtCore.QDate: ...
    def selectionMode(self) -> PySide2.QtWidgets.QCalendarWidget.SelectionMode: ...
    def setCalendar(self, calendar:PySide2.QtCore.QCalendar): ...
    def setCurrentPage(self, year:int, month:int): ...
    def setDateEditAcceptDelay(self, delay:int): ...
    def setDateEditEnabled(self, enable:bool): ...
    def setDateRange(self, min:PySide2.QtCore.QDate, max:PySide2.QtCore.QDate): ...
    def setDateTextFormat(self, date:PySide2.QtCore.QDate, format:PySide2.QtGui.QTextCharFormat): ...
    def setFirstDayOfWeek(self, dayOfWeek:PySide2.QtCore.Qt.DayOfWeek): ...
    def setGridVisible(self, show:bool): ...
    def setHeaderTextFormat(self, format:PySide2.QtGui.QTextCharFormat): ...
    def setHorizontalHeaderFormat(self, format:PySide2.QtWidgets.QCalendarWidget.HorizontalHeaderFormat): ...
    def setMaximumDate(self, date:PySide2.QtCore.QDate): ...
    def setMinimumDate(self, date:PySide2.QtCore.QDate): ...
    def setNavigationBarVisible(self, visible:bool): ...
    def setSelectedDate(self, date:PySide2.QtCore.QDate): ...
    def setSelectionMode(self, mode:PySide2.QtWidgets.QCalendarWidget.SelectionMode): ...
    def setVerticalHeaderFormat(self, format:PySide2.QtWidgets.QCalendarWidget.VerticalHeaderFormat): ...
    def setWeekdayTextFormat(self, dayOfWeek:PySide2.QtCore.Qt.DayOfWeek, format:PySide2.QtGui.QTextCharFormat): ...
    def showNextMonth(self): ...
    def showNextYear(self): ...
    def showPreviousMonth(self): ...
    def showPreviousYear(self): ...
    def showSelectedDate(self): ...
    def showToday(self): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def updateCell(self, date:PySide2.QtCore.QDate): ...
    def updateCells(self): ...
    def verticalHeaderFormat(self) -> PySide2.QtWidgets.QCalendarWidget.VerticalHeaderFormat: ...
    def weekdayTextFormat(self, dayOfWeek:PySide2.QtCore.Qt.DayOfWeek) -> PySide2.QtGui.QTextCharFormat: ...
    def yearShown(self) -> int: ...


class QCheckBox(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def checkStateSet(self): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, pos:PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionButton): ...
    def isTristate(self) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def nextCheckState(self): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def setCheckState(self, state:PySide2.QtCore.Qt.CheckState): ...
    def setTristate(self, y:bool=...): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QColorDialog(PySide2.QtWidgets.QDialog):
    ShowAlphaChannel         : QColorDialog = ... # 0x1
    NoButtons                : QColorDialog = ... # 0x2
    DontUseNativeDialog      : QColorDialog = ... # 0x4

    class ColorDialogOption(object):
        ShowAlphaChannel         : QColorDialog.ColorDialogOption = ... # 0x1
        NoButtons                : QColorDialog.ColorDialogOption = ... # 0x2
        DontUseNativeDialog      : QColorDialog.ColorDialogOption = ... # 0x4

    class ColorDialogOptions(object): ...

    @typing.overload
    def __init__(self, initial:PySide2.QtGui.QColor, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    def currentColor(self) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def customColor(index:int) -> PySide2.QtGui.QColor: ...
    @staticmethod
    def customCount() -> int: ...
    def done(self, result:int): ...
    @staticmethod
    def getColor(initial:PySide2.QtGui.QColor=..., parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., title:str=..., options:PySide2.QtWidgets.QColorDialog.ColorDialogOptions=...) -> PySide2.QtGui.QColor: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver:PySide2.QtCore.QObject, member:bytes): ...
    def options(self) -> PySide2.QtWidgets.QColorDialog.ColorDialogOptions: ...
    def selectedColor(self) -> PySide2.QtGui.QColor: ...
    def setCurrentColor(self, color:PySide2.QtGui.QColor): ...
    @staticmethod
    def setCustomColor(index:int, color:PySide2.QtGui.QColor): ...
    def setOption(self, option:PySide2.QtWidgets.QColorDialog.ColorDialogOption, on:bool=...): ...
    def setOptions(self, options:PySide2.QtWidgets.QColorDialog.ColorDialogOptions): ...
    @staticmethod
    def setStandardColor(index:int, color:PySide2.QtGui.QColor): ...
    def setVisible(self, visible:bool): ...
    @staticmethod
    def standardColor(index:int) -> PySide2.QtGui.QColor: ...
    def testOption(self, option:PySide2.QtWidgets.QColorDialog.ColorDialogOption) -> bool: ...


class QColormap(Shiboken.Object):
    Direct                   : QColormap = ... # 0x0
    Indexed                  : QColormap = ... # 0x1
    Gray                     : QColormap = ... # 0x2

    class Mode(object):
        Direct                   : QColormap.Mode = ... # 0x0
        Indexed                  : QColormap.Mode = ... # 0x1
        Gray                     : QColormap.Mode = ... # 0x2

    def __init__(self, colormap:PySide2.QtWidgets.QColormap): ...

    def __copy__(self): ...
    @staticmethod
    def cleanup(): ...
    def colorAt(self, pixel:int) -> PySide2.QtGui.QColor: ...
    def colormap(self) -> typing.List: ...
    def depth(self) -> int: ...
    @staticmethod
    def initialize(): ...
    @staticmethod
    def instance(screen:int=...) -> PySide2.QtWidgets.QColormap: ...
    def mode(self) -> PySide2.QtWidgets.QColormap.Mode: ...
    def pixel(self, color:PySide2.QtGui.QColor) -> int: ...
    def size(self) -> int: ...


class QColumnView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def columnWidths(self) -> typing.List: ...
    def createColumn(self, rootIndex:PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QAbstractItemView: ...
    def currentChanged(self, current:PySide2.QtCore.QModelIndex, previous:PySide2.QtCore.QModelIndex): ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, point:PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def initializeColumn(self, column:PySide2.QtWidgets.QAbstractItemView): ...
    def isIndexHidden(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def moveCursor(self, cursorAction:PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def previewWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent): ...
    def resizeGripsVisible(self) -> bool: ...
    def rowsInserted(self, parent:PySide2.QtCore.QModelIndex, start:int, end:int): ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def scrollTo(self, index:PySide2.QtCore.QModelIndex, hint:PySide2.QtWidgets.QAbstractItemView.ScrollHint=...): ...
    def selectAll(self): ...
    def setColumnWidths(self, list:typing.Sequence): ...
    def setModel(self, model:PySide2.QtCore.QAbstractItemModel): ...
    def setPreviewWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def setResizeGripsVisible(self, visible:bool): ...
    def setRootIndex(self, index:PySide2.QtCore.QModelIndex): ...
    def setSelection(self, rect:PySide2.QtCore.QRect, command:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSelectionModel(self, selectionModel:PySide2.QtCore.QItemSelectionModel): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def verticalOffset(self) -> int: ...
    def visualRect(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection:PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...


class QComboBox(PySide2.QtWidgets.QWidget):
    AdjustToContents         : QComboBox = ... # 0x0
    NoInsert                 : QComboBox = ... # 0x0
    AdjustToContentsOnFirstShow: QComboBox = ... # 0x1
    InsertAtTop              : QComboBox = ... # 0x1
    AdjustToMinimumContentsLength: QComboBox = ... # 0x2
    InsertAtCurrent          : QComboBox = ... # 0x2
    AdjustToMinimumContentsLengthWithIcon: QComboBox = ... # 0x3
    InsertAtBottom           : QComboBox = ... # 0x3
    InsertAfterCurrent       : QComboBox = ... # 0x4
    InsertBeforeCurrent      : QComboBox = ... # 0x5
    InsertAlphabetically     : QComboBox = ... # 0x6

    class InsertPolicy(object):
        NoInsert                 : QComboBox.InsertPolicy = ... # 0x0
        InsertAtTop              : QComboBox.InsertPolicy = ... # 0x1
        InsertAtCurrent          : QComboBox.InsertPolicy = ... # 0x2
        InsertAtBottom           : QComboBox.InsertPolicy = ... # 0x3
        InsertAfterCurrent       : QComboBox.InsertPolicy = ... # 0x4
        InsertBeforeCurrent      : QComboBox.InsertPolicy = ... # 0x5
        InsertAlphabetically     : QComboBox.InsertPolicy = ... # 0x6

    class SizeAdjustPolicy(object):
        AdjustToContents         : QComboBox.SizeAdjustPolicy = ... # 0x0
        AdjustToContentsOnFirstShow: QComboBox.SizeAdjustPolicy = ... # 0x1
        AdjustToMinimumContentsLength: QComboBox.SizeAdjustPolicy = ... # 0x2
        AdjustToMinimumContentsLengthWithIcon: QComboBox.SizeAdjustPolicy = ... # 0x3

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    @typing.overload
    def addItem(self, icon:PySide2.QtGui.QIcon, text:str, userData:typing.Any=...): ...
    @typing.overload
    def addItem(self, text:str, userData:typing.Any=...): ...
    def addItems(self, texts:typing.Sequence): ...
    def autoCompletion(self) -> bool: ...
    def autoCompletionCaseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def changeEvent(self, e:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def clearEditText(self): ...
    def completer(self) -> PySide2.QtWidgets.QCompleter: ...
    def contextMenuEvent(self, e:PySide2.QtGui.QContextMenuEvent): ...
    def count(self) -> int: ...
    def currentData(self, role:int=...) -> typing.Any: ...
    def currentIndex(self) -> int: ...
    def currentText(self) -> str: ...
    def duplicatesEnabled(self) -> bool: ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def findData(self, data:typing.Any, role:int=..., flags:PySide2.QtCore.Qt.MatchFlags=...) -> int: ...
    def findText(self, text:str, flags:PySide2.QtCore.Qt.MatchFlags=...) -> int: ...
    def focusInEvent(self, e:PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, e:PySide2.QtGui.QFocusEvent): ...
    def hasFrame(self) -> bool: ...
    def hideEvent(self, e:PySide2.QtGui.QHideEvent): ...
    def hidePopup(self): ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionComboBox): ...
    def inputMethodEvent(self, arg__1:PySide2.QtGui.QInputMethodEvent): ...
    @typing.overload
    def inputMethodQuery(self, arg__1:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query:PySide2.QtCore.Qt.InputMethodQuery, argument:typing.Any) -> typing.Any: ...
    @typing.overload
    def insertItem(self, index:int, icon:PySide2.QtGui.QIcon, text:str, userData:typing.Any=...): ...
    @typing.overload
    def insertItem(self, index:int, text:str, userData:typing.Any=...): ...
    def insertItems(self, index:int, texts:typing.Sequence): ...
    def insertPolicy(self) -> PySide2.QtWidgets.QComboBox.InsertPolicy: ...
    def insertSeparator(self, index:int): ...
    def isEditable(self) -> bool: ...
    def itemData(self, index:int, role:int=...) -> typing.Any: ...
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def itemIcon(self, index:int) -> PySide2.QtGui.QIcon: ...
    def itemText(self, index:int) -> str: ...
    def keyPressEvent(self, e:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, e:PySide2.QtGui.QKeyEvent): ...
    def lineEdit(self) -> PySide2.QtWidgets.QLineEdit: ...
    def maxCount(self) -> int: ...
    def maxVisibleItems(self) -> int: ...
    def minimumContentsLength(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def modelColumn(self) -> int: ...
    def mousePressEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, e:PySide2.QtGui.QPaintEvent): ...
    def removeItem(self, index:int): ...
    def resizeEvent(self, e:PySide2.QtGui.QResizeEvent): ...
    def rootModelIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def setAutoCompletion(self, enable:bool): ...
    def setAutoCompletionCaseSensitivity(self, sensitivity:PySide2.QtCore.Qt.CaseSensitivity): ...
    def setCompleter(self, c:PySide2.QtWidgets.QCompleter): ...
    def setCurrentIndex(self, index:int): ...
    def setCurrentText(self, text:str): ...
    def setDuplicatesEnabled(self, enable:bool): ...
    def setEditText(self, text:str): ...
    def setEditable(self, editable:bool): ...
    def setFrame(self, arg__1:bool): ...
    def setIconSize(self, size:PySide2.QtCore.QSize): ...
    def setInsertPolicy(self, policy:PySide2.QtWidgets.QComboBox.InsertPolicy): ...
    def setItemData(self, index:int, value:typing.Any, role:int=...): ...
    def setItemDelegate(self, delegate:PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setItemIcon(self, index:int, icon:PySide2.QtGui.QIcon): ...
    def setItemText(self, index:int, text:str): ...
    def setLineEdit(self, edit:PySide2.QtWidgets.QLineEdit): ...
    def setMaxCount(self, max:int): ...
    def setMaxVisibleItems(self, maxItems:int): ...
    def setMinimumContentsLength(self, characters:int): ...
    def setModel(self, model:PySide2.QtCore.QAbstractItemModel): ...
    def setModelColumn(self, visibleColumn:int): ...
    def setRootModelIndex(self, index:PySide2.QtCore.QModelIndex): ...
    def setSizeAdjustPolicy(self, policy:PySide2.QtWidgets.QComboBox.SizeAdjustPolicy): ...
    def setValidator(self, v:PySide2.QtGui.QValidator): ...
    def setView(self, itemView:PySide2.QtWidgets.QAbstractItemView): ...
    def showEvent(self, e:PySide2.QtGui.QShowEvent): ...
    def showPopup(self): ...
    def sizeAdjustPolicy(self) -> PySide2.QtWidgets.QComboBox.SizeAdjustPolicy: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def validator(self) -> PySide2.QtGui.QValidator: ...
    def view(self) -> PySide2.QtWidgets.QAbstractItemView: ...
    def wheelEvent(self, e:PySide2.QtGui.QWheelEvent): ...


class QCommandLinkButton(PySide2.QtWidgets.QPushButton):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, text:str, description:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def description(self) -> str: ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def heightForWidth(self, arg__1:int) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def setDescription(self, description:str): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QCommonStyle(PySide2.QtWidgets.QStyle):

    def __init__(self): ...

    def drawComplexControl(self, cc:PySide2.QtWidgets.QStyle.ComplexControl, opt:PySide2.QtWidgets.QStyleOptionComplex, p:PySide2.QtGui.QPainter, w:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def drawControl(self, element:PySide2.QtWidgets.QStyle.ControlElement, opt:PySide2.QtWidgets.QStyleOption, p:PySide2.QtGui.QPainter, w:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def drawPrimitive(self, pe:PySide2.QtWidgets.QStyle.PrimitiveElement, opt:PySide2.QtWidgets.QStyleOption, p:PySide2.QtGui.QPainter, w:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def generatedIconPixmap(self, iconMode:PySide2.QtGui.QIcon.Mode, pixmap:PySide2.QtGui.QPixmap, opt:PySide2.QtWidgets.QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc:PySide2.QtWidgets.QStyle.ComplexControl, opt:PySide2.QtWidgets.QStyleOptionComplex, pt:PySide2.QtCore.QPoint, w:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtWidgets.QStyle.SubControl: ...
    def layoutSpacing(self, control1:PySide2.QtWidgets.QSizePolicy.ControlType, control2:PySide2.QtWidgets.QSizePolicy.ControlType, orientation:PySide2.QtCore.Qt.Orientation, option:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> int: ...
    def pixelMetric(self, m:PySide2.QtWidgets.QStyle.PixelMetric, opt:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> int: ...
    @typing.overload
    def polish(self, app:PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def polish(self, application:PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def polish(self, arg__1:PySide2.QtGui.QPalette): ...
    @typing.overload
    def polish(self, widget:PySide2.QtWidgets.QWidget): ...
    def sizeFromContents(self, ct:PySide2.QtWidgets.QStyle.ContentsType, opt:PySide2.QtWidgets.QStyleOption, contentsSize:PySide2.QtCore.QSize, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtCore.QSize: ...
    def standardIcon(self, standardIcon:PySide2.QtWidgets.QStyle.StandardPixmap, opt:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtGui.QIcon: ...
    def standardPixmap(self, sp:PySide2.QtWidgets.QStyle.StandardPixmap, opt:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtGui.QPixmap: ...
    def styleHint(self, sh:PySide2.QtWidgets.QStyle.StyleHint, opt:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., w:typing.Optional[PySide2.QtWidgets.QWidget]=..., shret:typing.Optional[PySide2.QtWidgets.QStyleHintReturn]=...) -> int: ...
    def subControlRect(self, cc:PySide2.QtWidgets.QStyle.ComplexControl, opt:PySide2.QtWidgets.QStyleOptionComplex, sc:PySide2.QtWidgets.QStyle.SubControl, w:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtCore.QRect: ...
    def subElementRect(self, r:PySide2.QtWidgets.QStyle.SubElement, opt:PySide2.QtWidgets.QStyleOption, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, application:PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def unpolish(self, widget:PySide2.QtWidgets.QWidget): ...


class QCompleter(PySide2.QtCore.QObject):
    PopupCompletion          : QCompleter = ... # 0x0
    UnsortedModel            : QCompleter = ... # 0x0
    CaseSensitivelySortedModel: QCompleter = ... # 0x1
    UnfilteredPopupCompletion: QCompleter = ... # 0x1
    CaseInsensitivelySortedModel: QCompleter = ... # 0x2
    InlineCompletion         : QCompleter = ... # 0x2

    class CompletionMode(object):
        PopupCompletion          : QCompleter.CompletionMode = ... # 0x0
        UnfilteredPopupCompletion: QCompleter.CompletionMode = ... # 0x1
        InlineCompletion         : QCompleter.CompletionMode = ... # 0x2

    class ModelSorting(object):
        UnsortedModel            : QCompleter.ModelSorting = ... # 0x0
        CaseSensitivelySortedModel: QCompleter.ModelSorting = ... # 0x1
        CaseInsensitivelySortedModel: QCompleter.ModelSorting = ... # 0x2

    @typing.overload
    def __init__(self, completions:typing.Sequence, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, model:PySide2.QtCore.QAbstractItemModel, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def caseSensitivity(self) -> PySide2.QtCore.Qt.CaseSensitivity: ...
    def complete(self, rect:PySide2.QtCore.QRect=...): ...
    def completionColumn(self) -> int: ...
    def completionCount(self) -> int: ...
    def completionMode(self) -> PySide2.QtWidgets.QCompleter.CompletionMode: ...
    def completionModel(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def completionPrefix(self) -> str: ...
    def completionRole(self) -> int: ...
    def currentCompletion(self) -> str: ...
    def currentIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def currentRow(self) -> int: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, o:PySide2.QtCore.QObject, e:PySide2.QtCore.QEvent) -> bool: ...
    def filterMode(self) -> PySide2.QtCore.Qt.MatchFlags: ...
    def maxVisibleItems(self) -> int: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def modelSorting(self) -> PySide2.QtWidgets.QCompleter.ModelSorting: ...
    def pathFromIndex(self, index:PySide2.QtCore.QModelIndex) -> str: ...
    def popup(self) -> PySide2.QtWidgets.QAbstractItemView: ...
    def setCaseSensitivity(self, caseSensitivity:PySide2.QtCore.Qt.CaseSensitivity): ...
    def setCompletionColumn(self, column:int): ...
    def setCompletionMode(self, mode:PySide2.QtWidgets.QCompleter.CompletionMode): ...
    def setCompletionPrefix(self, prefix:str): ...
    def setCompletionRole(self, role:int): ...
    def setCurrentRow(self, row:int) -> bool: ...
    def setFilterMode(self, filterMode:PySide2.QtCore.Qt.MatchFlags): ...
    def setMaxVisibleItems(self, maxItems:int): ...
    def setModel(self, c:PySide2.QtCore.QAbstractItemModel): ...
    def setModelSorting(self, sorting:PySide2.QtWidgets.QCompleter.ModelSorting): ...
    def setPopup(self, popup:PySide2.QtWidgets.QAbstractItemView): ...
    def setWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def setWrapAround(self, wrap:bool): ...
    def splitPath(self, path:str) -> typing.List: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    def wrapAround(self) -> bool: ...


class QDataWidgetMapper(PySide2.QtCore.QObject):
    AutoSubmit               : QDataWidgetMapper = ... # 0x0
    ManualSubmit             : QDataWidgetMapper = ... # 0x1

    class SubmitPolicy(object):
        AutoSubmit               : QDataWidgetMapper.SubmitPolicy = ... # 0x0
        ManualSubmit             : QDataWidgetMapper.SubmitPolicy = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    @typing.overload
    def addMapping(self, widget:PySide2.QtWidgets.QWidget, section:int): ...
    @typing.overload
    def addMapping(self, widget:PySide2.QtWidgets.QWidget, section:int, propertyName:PySide2.QtCore.QByteArray): ...
    def clearMapping(self): ...
    def currentIndex(self) -> int: ...
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def mappedPropertyName(self, widget:PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QByteArray: ...
    def mappedSection(self, widget:PySide2.QtWidgets.QWidget) -> int: ...
    def mappedWidgetAt(self, section:int) -> PySide2.QtWidgets.QWidget: ...
    def model(self) -> PySide2.QtCore.QAbstractItemModel: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeMapping(self, widget:PySide2.QtWidgets.QWidget): ...
    def revert(self): ...
    def rootIndex(self) -> PySide2.QtCore.QModelIndex: ...
    def setCurrentIndex(self, index:int): ...
    def setCurrentModelIndex(self, index:PySide2.QtCore.QModelIndex): ...
    def setItemDelegate(self, delegate:PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setModel(self, model:PySide2.QtCore.QAbstractItemModel): ...
    def setOrientation(self, aOrientation:PySide2.QtCore.Qt.Orientation): ...
    def setRootIndex(self, index:PySide2.QtCore.QModelIndex): ...
    def setSubmitPolicy(self, policy:PySide2.QtWidgets.QDataWidgetMapper.SubmitPolicy): ...
    def submit(self) -> bool: ...
    def submitPolicy(self) -> PySide2.QtWidgets.QDataWidgetMapper.SubmitPolicy: ...
    def toFirst(self): ...
    def toLast(self): ...
    def toNext(self): ...
    def toPrevious(self): ...


class QDateEdit(PySide2.QtWidgets.QDateTimeEdit):

    @typing.overload
    def __init__(self, date:PySide2.QtCore.QDate, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...


class QDateTimeEdit(PySide2.QtWidgets.QAbstractSpinBox):
    NoSection                : QDateTimeEdit = ... # 0x0
    AmPmSection              : QDateTimeEdit = ... # 0x1
    MSecSection              : QDateTimeEdit = ... # 0x2
    SecondSection            : QDateTimeEdit = ... # 0x4
    MinuteSection            : QDateTimeEdit = ... # 0x8
    HourSection              : QDateTimeEdit = ... # 0x10
    TimeSections_Mask        : QDateTimeEdit = ... # 0x1f
    DaySection               : QDateTimeEdit = ... # 0x100
    MonthSection             : QDateTimeEdit = ... # 0x200
    YearSection              : QDateTimeEdit = ... # 0x400
    DateSections_Mask        : QDateTimeEdit = ... # 0x700

    class Section(object):
        NoSection                : QDateTimeEdit.Section = ... # 0x0
        AmPmSection              : QDateTimeEdit.Section = ... # 0x1
        MSecSection              : QDateTimeEdit.Section = ... # 0x2
        SecondSection            : QDateTimeEdit.Section = ... # 0x4
        MinuteSection            : QDateTimeEdit.Section = ... # 0x8
        HourSection              : QDateTimeEdit.Section = ... # 0x10
        TimeSections_Mask        : QDateTimeEdit.Section = ... # 0x1f
        DaySection               : QDateTimeEdit.Section = ... # 0x100
        MonthSection             : QDateTimeEdit.Section = ... # 0x200
        YearSection              : QDateTimeEdit.Section = ... # 0x400
        DateSections_Mask        : QDateTimeEdit.Section = ... # 0x700

    class Sections(object): ...

    @typing.overload
    def __init__(self, d:PySide2.QtCore.QDate, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, dt:PySide2.QtCore.QDateTime, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, t:PySide2.QtCore.QTime, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, val:typing.Any, parserType:type, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def calendar(self) -> PySide2.QtCore.QCalendar: ...
    def calendarPopup(self) -> bool: ...
    def calendarWidget(self) -> PySide2.QtWidgets.QCalendarWidget: ...
    def clear(self): ...
    def clearMaximumDate(self): ...
    def clearMaximumDateTime(self): ...
    def clearMaximumTime(self): ...
    def clearMinimumDate(self): ...
    def clearMinimumDateTime(self): ...
    def clearMinimumTime(self): ...
    def currentSection(self) -> PySide2.QtWidgets.QDateTimeEdit.Section: ...
    def currentSectionIndex(self) -> int: ...
    def date(self) -> PySide2.QtCore.QDate: ...
    def dateTime(self) -> PySide2.QtCore.QDateTime: ...
    def dateTimeFromText(self, text:str) -> PySide2.QtCore.QDateTime: ...
    def displayFormat(self) -> str: ...
    def displayedSections(self) -> PySide2.QtWidgets.QDateTimeEdit.Sections: ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, input:str): ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionSpinBox): ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def maximumDate(self) -> PySide2.QtCore.QDate: ...
    def maximumDateTime(self) -> PySide2.QtCore.QDateTime: ...
    def maximumTime(self) -> PySide2.QtCore.QTime: ...
    def minimumDate(self) -> PySide2.QtCore.QDate: ...
    def minimumDateTime(self) -> PySide2.QtCore.QDateTime: ...
    def minimumTime(self) -> PySide2.QtCore.QTime: ...
    def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent): ...
    def sectionAt(self, index:int) -> PySide2.QtWidgets.QDateTimeEdit.Section: ...
    def sectionCount(self) -> int: ...
    def sectionText(self, section:PySide2.QtWidgets.QDateTimeEdit.Section) -> str: ...
    def setCalendar(self, calendar:PySide2.QtCore.QCalendar): ...
    def setCalendarPopup(self, enable:bool): ...
    def setCalendarWidget(self, calendarWidget:PySide2.QtWidgets.QCalendarWidget): ...
    def setCurrentSection(self, section:PySide2.QtWidgets.QDateTimeEdit.Section): ...
    def setCurrentSectionIndex(self, index:int): ...
    def setDate(self, date:PySide2.QtCore.QDate): ...
    def setDateRange(self, min:PySide2.QtCore.QDate, max:PySide2.QtCore.QDate): ...
    def setDateTime(self, dateTime:PySide2.QtCore.QDateTime): ...
    def setDateTimeRange(self, min:PySide2.QtCore.QDateTime, max:PySide2.QtCore.QDateTime): ...
    def setDisplayFormat(self, format:str): ...
    def setMaximumDate(self, max:PySide2.QtCore.QDate): ...
    def setMaximumDateTime(self, dt:PySide2.QtCore.QDateTime): ...
    def setMaximumTime(self, max:PySide2.QtCore.QTime): ...
    def setMinimumDate(self, min:PySide2.QtCore.QDate): ...
    def setMinimumDateTime(self, dt:PySide2.QtCore.QDateTime): ...
    def setMinimumTime(self, min:PySide2.QtCore.QTime): ...
    def setSelectedSection(self, section:PySide2.QtWidgets.QDateTimeEdit.Section): ...
    def setTime(self, time:PySide2.QtCore.QTime): ...
    def setTimeRange(self, min:PySide2.QtCore.QTime, max:PySide2.QtCore.QTime): ...
    def setTimeSpec(self, spec:PySide2.QtCore.Qt.TimeSpec): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def stepBy(self, steps:int): ...
    def stepEnabled(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepEnabled: ...
    def textFromDateTime(self, dt:PySide2.QtCore.QDateTime) -> str: ...
    def time(self) -> PySide2.QtCore.QTime: ...
    def timeSpec(self) -> PySide2.QtCore.Qt.TimeSpec: ...
    def validate(self, input:str, pos:int) -> PySide2.QtGui.QValidator.State: ...
    def wheelEvent(self, event:PySide2.QtGui.QWheelEvent): ...


class QDesktopWidget(PySide2.QtWidgets.QWidget):

    def __init__(self): ...

    @typing.overload
    def availableGeometry(self, point:PySide2.QtCore.QPoint) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def availableGeometry(self, screen:int=...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def availableGeometry(self, widget:PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRect: ...
    def isVirtualDesktop(self) -> bool: ...
    def numScreens(self) -> int: ...
    def primaryScreen(self) -> int: ...
    def resizeEvent(self, e:PySide2.QtGui.QResizeEvent): ...
    @typing.overload
    def screen(self) -> PySide2.QtGui.QScreen: ...
    @typing.overload
    def screen(self, screen:int=...) -> PySide2.QtWidgets.QWidget: ...
    def screenCount(self) -> int: ...
    @typing.overload
    def screenGeometry(self, point:PySide2.QtCore.QPoint) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def screenGeometry(self, screen:int=...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def screenGeometry(self, widget:PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def screenNumber(self, arg__1:PySide2.QtCore.QPoint) -> int: ...
    @typing.overload
    def screenNumber(self, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> int: ...


class QDial(PySide2.QtWidgets.QAbstractSlider):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionSlider): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, me:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, me:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, me:PySide2.QtGui.QMouseEvent): ...
    def notchSize(self) -> int: ...
    def notchTarget(self) -> float: ...
    def notchesVisible(self) -> bool: ...
    def paintEvent(self, pe:PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, re:PySide2.QtGui.QResizeEvent): ...
    def setNotchTarget(self, target:float): ...
    def setNotchesVisible(self, visible:bool): ...
    def setWrapping(self, on:bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sliderChange(self, change:PySide2.QtWidgets.QAbstractSlider.SliderChange): ...
    def wrapping(self) -> bool: ...


class QDialog(PySide2.QtWidgets.QWidget):
    Rejected                 : QDialog = ... # 0x0
    Accepted                 : QDialog = ... # 0x1

    class DialogCode(object):
        Rejected                 : QDialog.DialogCode = ... # 0x0
        Accepted                 : QDialog.DialogCode = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., f:PySide2.QtCore.Qt.WindowFlags=...): ...

    def accept(self): ...
    def adjustPosition(self, arg__1:PySide2.QtWidgets.QWidget): ...
    def closeEvent(self, arg__1:PySide2.QtGui.QCloseEvent): ...
    def contextMenuEvent(self, arg__1:PySide2.QtGui.QContextMenuEvent): ...
    def done(self, arg__1:int): ...
    def eventFilter(self, arg__1:PySide2.QtCore.QObject, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    def exec_(self) -> int: ...
    def extension(self) -> PySide2.QtWidgets.QWidget: ...
    def isSizeGripEnabled(self) -> bool: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def open(self): ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def reject(self): ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent): ...
    def result(self) -> int: ...
    def setExtension(self, extension:PySide2.QtWidgets.QWidget): ...
    def setModal(self, modal:bool): ...
    def setOrientation(self, orientation:PySide2.QtCore.Qt.Orientation): ...
    def setResult(self, r:int): ...
    def setSizeGripEnabled(self, arg__1:bool): ...
    def setVisible(self, visible:bool): ...
    def showEvent(self, arg__1:PySide2.QtGui.QShowEvent): ...
    def showExtension(self, arg__1:bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QDialogButtonBox(PySide2.QtWidgets.QWidget):
    InvalidRole              : QDialogButtonBox = ... # -0x1
    AcceptRole               : QDialogButtonBox = ... # 0x0
    NoButton                 : QDialogButtonBox = ... # 0x0
    WinLayout                : QDialogButtonBox = ... # 0x0
    MacLayout                : QDialogButtonBox = ... # 0x1
    RejectRole               : QDialogButtonBox = ... # 0x1
    DestructiveRole          : QDialogButtonBox = ... # 0x2
    KdeLayout                : QDialogButtonBox = ... # 0x2
    ActionRole               : QDialogButtonBox = ... # 0x3
    GnomeLayout              : QDialogButtonBox = ... # 0x3
    HelpRole                 : QDialogButtonBox = ... # 0x4
    AndroidLayout            : QDialogButtonBox = ... # 0x5
    YesRole                  : QDialogButtonBox = ... # 0x5
    NoRole                   : QDialogButtonBox = ... # 0x6
    ResetRole                : QDialogButtonBox = ... # 0x7
    ApplyRole                : QDialogButtonBox = ... # 0x8
    NRoles                   : QDialogButtonBox = ... # 0x9
    FirstButton              : QDialogButtonBox = ... # 0x400
    Ok                       : QDialogButtonBox = ... # 0x400
    Save                     : QDialogButtonBox = ... # 0x800
    SaveAll                  : QDialogButtonBox = ... # 0x1000
    Open                     : QDialogButtonBox = ... # 0x2000
    Yes                      : QDialogButtonBox = ... # 0x4000
    YesToAll                 : QDialogButtonBox = ... # 0x8000
    No                       : QDialogButtonBox = ... # 0x10000
    NoToAll                  : QDialogButtonBox = ... # 0x20000
    Abort                    : QDialogButtonBox = ... # 0x40000
    Retry                    : QDialogButtonBox = ... # 0x80000
    Ignore                   : QDialogButtonBox = ... # 0x100000
    Close                    : QDialogButtonBox = ... # 0x200000
    Cancel                   : QDialogButtonBox = ... # 0x400000
    Discard                  : QDialogButtonBox = ... # 0x800000
    Help                     : QDialogButtonBox = ... # 0x1000000
    Apply                    : QDialogButtonBox = ... # 0x2000000
    Reset                    : QDialogButtonBox = ... # 0x4000000
    LastButton               : QDialogButtonBox = ... # 0x8000000
    RestoreDefaults          : QDialogButtonBox = ... # 0x8000000

    class ButtonLayout(object):
        WinLayout                : QDialogButtonBox.ButtonLayout = ... # 0x0
        MacLayout                : QDialogButtonBox.ButtonLayout = ... # 0x1
        KdeLayout                : QDialogButtonBox.ButtonLayout = ... # 0x2
        GnomeLayout              : QDialogButtonBox.ButtonLayout = ... # 0x3
        AndroidLayout            : QDialogButtonBox.ButtonLayout = ... # 0x5

    class ButtonRole(object):
        InvalidRole              : QDialogButtonBox.ButtonRole = ... # -0x1
        AcceptRole               : QDialogButtonBox.ButtonRole = ... # 0x0
        RejectRole               : QDialogButtonBox.ButtonRole = ... # 0x1
        DestructiveRole          : QDialogButtonBox.ButtonRole = ... # 0x2
        ActionRole               : QDialogButtonBox.ButtonRole = ... # 0x3
        HelpRole                 : QDialogButtonBox.ButtonRole = ... # 0x4
        YesRole                  : QDialogButtonBox.ButtonRole = ... # 0x5
        NoRole                   : QDialogButtonBox.ButtonRole = ... # 0x6
        ResetRole                : QDialogButtonBox.ButtonRole = ... # 0x7
        ApplyRole                : QDialogButtonBox.ButtonRole = ... # 0x8
        NRoles                   : QDialogButtonBox.ButtonRole = ... # 0x9

    class StandardButton(object):
        NoButton                 : QDialogButtonBox.StandardButton = ... # 0x0
        FirstButton              : QDialogButtonBox.StandardButton = ... # 0x400
        Ok                       : QDialogButtonBox.StandardButton = ... # 0x400
        Save                     : QDialogButtonBox.StandardButton = ... # 0x800
        SaveAll                  : QDialogButtonBox.StandardButton = ... # 0x1000
        Open                     : QDialogButtonBox.StandardButton = ... # 0x2000
        Yes                      : QDialogButtonBox.StandardButton = ... # 0x4000
        YesToAll                 : QDialogButtonBox.StandardButton = ... # 0x8000
        No                       : QDialogButtonBox.StandardButton = ... # 0x10000
        NoToAll                  : QDialogButtonBox.StandardButton = ... # 0x20000
        Abort                    : QDialogButtonBox.StandardButton = ... # 0x40000
        Retry                    : QDialogButtonBox.StandardButton = ... # 0x80000
        Ignore                   : QDialogButtonBox.StandardButton = ... # 0x100000
        Close                    : QDialogButtonBox.StandardButton = ... # 0x200000
        Cancel                   : QDialogButtonBox.StandardButton = ... # 0x400000
        Discard                  : QDialogButtonBox.StandardButton = ... # 0x800000
        Help                     : QDialogButtonBox.StandardButton = ... # 0x1000000
        Apply                    : QDialogButtonBox.StandardButton = ... # 0x2000000
        Reset                    : QDialogButtonBox.StandardButton = ... # 0x4000000
        LastButton               : QDialogButtonBox.StandardButton = ... # 0x8000000
        RestoreDefaults          : QDialogButtonBox.StandardButton = ... # 0x8000000

    class StandardButtons(object): ...

    @typing.overload
    def __init__(self, buttons:PySide2.QtWidgets.QDialogButtonBox.StandardButtons, orientation:PySide2.QtCore.Qt.Orientation, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, buttons:PySide2.QtWidgets.QDialogButtonBox.StandardButtons, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, orientation:PySide2.QtCore.Qt.Orientation, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    @typing.overload
    def addButton(self, button:PySide2.QtWidgets.QAbstractButton, role:PySide2.QtWidgets.QDialogButtonBox.ButtonRole): ...
    @typing.overload
    def addButton(self, button:PySide2.QtWidgets.QDialogButtonBox.StandardButton) -> PySide2.QtWidgets.QPushButton: ...
    @typing.overload
    def addButton(self, text:str, role:PySide2.QtWidgets.QDialogButtonBox.ButtonRole) -> PySide2.QtWidgets.QPushButton: ...
    def button(self, which:PySide2.QtWidgets.QDialogButtonBox.StandardButton) -> PySide2.QtWidgets.QPushButton: ...
    def buttonRole(self, button:PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QDialogButtonBox.ButtonRole: ...
    def buttons(self) -> typing.List: ...
    def centerButtons(self) -> bool: ...
    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeButton(self, button:PySide2.QtWidgets.QAbstractButton): ...
    def setCenterButtons(self, center:bool): ...
    def setOrientation(self, orientation:PySide2.QtCore.Qt.Orientation): ...
    def setStandardButtons(self, buttons:PySide2.QtWidgets.QDialogButtonBox.StandardButtons): ...
    def standardButton(self, button:PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QDialogButtonBox.StandardButton: ...
    def standardButtons(self) -> PySide2.QtWidgets.QDialogButtonBox.StandardButtons: ...


class QDirModel(PySide2.QtCore.QAbstractItemModel):
    FileIconRole             : QDirModel = ... # 0x1
    FilePathRole             : QDirModel = ... # 0x101
    FileNameRole             : QDirModel = ... # 0x102

    class Roles(object):
        FileIconRole             : QDirModel.Roles = ... # 0x1
        FilePathRole             : QDirModel.Roles = ... # 0x101
        FileNameRole             : QDirModel.Roles = ... # 0x102

    @typing.overload
    def __init__(self, nameFilters:typing.Sequence, filters:PySide2.QtCore.QDir.Filters, sort:PySide2.QtCore.QDir.SortFlags, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def columnCount(self, parent:PySide2.QtCore.QModelIndex=...) -> int: ...
    def data(self, index:PySide2.QtCore.QModelIndex, role:int=...) -> typing.Any: ...
    def dropMimeData(self, data:PySide2.QtCore.QMimeData, action:PySide2.QtCore.Qt.DropAction, row:int, column:int, parent:PySide2.QtCore.QModelIndex) -> bool: ...
    def fileIcon(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtGui.QIcon: ...
    def fileInfo(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QFileInfo: ...
    def fileName(self, index:PySide2.QtCore.QModelIndex) -> str: ...
    def filePath(self, index:PySide2.QtCore.QModelIndex) -> str: ...
    def filter(self) -> PySide2.QtCore.QDir.Filters: ...
    def flags(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, index:PySide2.QtCore.QModelIndex=...) -> bool: ...
    def headerData(self, section:int, orientation:PySide2.QtCore.Qt.Orientation, role:int=...) -> typing.Any: ...
    def iconProvider(self) -> PySide2.QtWidgets.QFileIconProvider: ...
    @typing.overload
    def index(self, path:str, column:int=...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def index(self, row:int, column:int, parent:PySide2.QtCore.QModelIndex=...) -> PySide2.QtCore.QModelIndex: ...
    def isDir(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def lazyChildCount(self) -> bool: ...
    def mimeData(self, indexes:typing.List) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List: ...
    def mkdir(self, parent:PySide2.QtCore.QModelIndex, name:str) -> PySide2.QtCore.QModelIndex: ...
    def nameFilters(self) -> typing.List: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def refresh(self, parent:PySide2.QtCore.QModelIndex=...): ...
    def remove(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def resolveSymlinks(self) -> bool: ...
    def rmdir(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def rowCount(self, parent:PySide2.QtCore.QModelIndex=...) -> int: ...
    def setData(self, index:PySide2.QtCore.QModelIndex, value:typing.Any, role:int=...) -> bool: ...
    def setFilter(self, filters:PySide2.QtCore.QDir.Filters): ...
    def setIconProvider(self, provider:PySide2.QtWidgets.QFileIconProvider): ...
    def setLazyChildCount(self, enable:bool): ...
    def setNameFilters(self, filters:typing.Sequence): ...
    def setReadOnly(self, enable:bool): ...
    def setResolveSymlinks(self, enable:bool): ...
    def setSorting(self, sort:PySide2.QtCore.QDir.SortFlags): ...
    def sort(self, column:int, order:PySide2.QtCore.Qt.SortOrder=...): ...
    def sorting(self) -> PySide2.QtCore.QDir.SortFlags: ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...


class QDockWidget(PySide2.QtWidgets.QWidget):
    NoDockWidgetFeatures     : QDockWidget = ... # 0x0
    DockWidgetClosable       : QDockWidget = ... # 0x1
    DockWidgetMovable        : QDockWidget = ... # 0x2
    DockWidgetFloatable      : QDockWidget = ... # 0x4
    AllDockWidgetFeatures    : QDockWidget = ... # 0x7
    DockWidgetVerticalTitleBar: QDockWidget = ... # 0x8
    DockWidgetFeatureMask    : QDockWidget = ... # 0xf
    Reserved                 : QDockWidget = ... # 0xff

    class DockWidgetFeature(object):
        NoDockWidgetFeatures     : QDockWidget.DockWidgetFeature = ... # 0x0
        DockWidgetClosable       : QDockWidget.DockWidgetFeature = ... # 0x1
        DockWidgetMovable        : QDockWidget.DockWidgetFeature = ... # 0x2
        DockWidgetFloatable      : QDockWidget.DockWidgetFeature = ... # 0x4
        AllDockWidgetFeatures    : QDockWidget.DockWidgetFeature = ... # 0x7
        DockWidgetVerticalTitleBar: QDockWidget.DockWidgetFeature = ... # 0x8
        DockWidgetFeatureMask    : QDockWidget.DockWidgetFeature = ... # 0xf
        Reserved                 : QDockWidget.DockWidgetFeature = ... # 0xff

    class DockWidgetFeatures(object): ...

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., flags:PySide2.QtCore.Qt.WindowFlags=...): ...
    @typing.overload
    def __init__(self, title:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., flags:PySide2.QtCore.Qt.WindowFlags=...): ...

    def allowedAreas(self) -> PySide2.QtCore.Qt.DockWidgetAreas: ...
    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    def closeEvent(self, event:PySide2.QtGui.QCloseEvent): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def features(self) -> PySide2.QtWidgets.QDockWidget.DockWidgetFeatures: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionDockWidget): ...
    def isAreaAllowed(self, area:PySide2.QtCore.Qt.DockWidgetArea) -> bool: ...
    def isFloating(self) -> bool: ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent): ...
    def setAllowedAreas(self, areas:PySide2.QtCore.Qt.DockWidgetAreas): ...
    def setFeatures(self, features:PySide2.QtWidgets.QDockWidget.DockWidgetFeatures): ...
    def setFloating(self, floating:bool): ...
    def setTitleBarWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def setWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def titleBarWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def toggleViewAction(self) -> PySide2.QtWidgets.QAction: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QDoubleSpinBox(PySide2.QtWidgets.QAbstractSpinBox):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def cleanText(self) -> str: ...
    def decimals(self) -> int: ...
    def fixup(self, str:str): ...
    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def prefix(self) -> str: ...
    def setDecimals(self, prec:int): ...
    def setMaximum(self, max:float): ...
    def setMinimum(self, min:float): ...
    def setPrefix(self, prefix:str): ...
    def setRange(self, min:float, max:float): ...
    def setSingleStep(self, val:float): ...
    def setStepType(self, stepType:PySide2.QtWidgets.QAbstractSpinBox.StepType): ...
    def setSuffix(self, suffix:str): ...
    def setValue(self, val:float): ...
    def singleStep(self) -> float: ...
    def stepType(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepType: ...
    def suffix(self) -> str: ...
    def textFromValue(self, val:float) -> str: ...
    def validate(self, input:str, pos:int) -> PySide2.QtGui.QValidator.State: ...
    def value(self) -> float: ...
    def valueFromText(self, text:str) -> float: ...


class QErrorMessage(PySide2.QtWidgets.QDialog):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def changeEvent(self, e:PySide2.QtCore.QEvent): ...
    def done(self, arg__1:int): ...
    @staticmethod
    def qtHandler() -> PySide2.QtWidgets.QErrorMessage: ...
    @typing.overload
    def showMessage(self, message:str): ...
    @typing.overload
    def showMessage(self, message:str, type:str): ...


class QFileDialog(PySide2.QtWidgets.QDialog):
    AcceptOpen               : QFileDialog = ... # 0x0
    AnyFile                  : QFileDialog = ... # 0x0
    Detail                   : QFileDialog = ... # 0x0
    LookIn                   : QFileDialog = ... # 0x0
    AcceptSave               : QFileDialog = ... # 0x1
    ExistingFile             : QFileDialog = ... # 0x1
    FileName                 : QFileDialog = ... # 0x1
    List                     : QFileDialog = ... # 0x1
    ShowDirsOnly             : QFileDialog = ... # 0x1
    Directory                : QFileDialog = ... # 0x2
    DontResolveSymlinks      : QFileDialog = ... # 0x2
    FileType                 : QFileDialog = ... # 0x2
    Accept                   : QFileDialog = ... # 0x3
    ExistingFiles            : QFileDialog = ... # 0x3
    DirectoryOnly            : QFileDialog = ... # 0x4
    DontConfirmOverwrite     : QFileDialog = ... # 0x4
    Reject                   : QFileDialog = ... # 0x4
    DontUseSheet             : QFileDialog = ... # 0x8
    DontUseNativeDialog      : QFileDialog = ... # 0x10
    ReadOnly                 : QFileDialog = ... # 0x20
    HideNameFilterDetails    : QFileDialog = ... # 0x40
    DontUseCustomDirectoryIcons: QFileDialog = ... # 0x80

    class AcceptMode(object):
        AcceptOpen               : QFileDialog.AcceptMode = ... # 0x0
        AcceptSave               : QFileDialog.AcceptMode = ... # 0x1

    class DialogLabel(object):
        LookIn                   : QFileDialog.DialogLabel = ... # 0x0
        FileName                 : QFileDialog.DialogLabel = ... # 0x1
        FileType                 : QFileDialog.DialogLabel = ... # 0x2
        Accept                   : QFileDialog.DialogLabel = ... # 0x3
        Reject                   : QFileDialog.DialogLabel = ... # 0x4

    class FileMode(object):
        AnyFile                  : QFileDialog.FileMode = ... # 0x0
        ExistingFile             : QFileDialog.FileMode = ... # 0x1
        Directory                : QFileDialog.FileMode = ... # 0x2
        ExistingFiles            : QFileDialog.FileMode = ... # 0x3
        DirectoryOnly            : QFileDialog.FileMode = ... # 0x4

    class Option(object):
        ShowDirsOnly             : QFileDialog.Option = ... # 0x1
        DontResolveSymlinks      : QFileDialog.Option = ... # 0x2
        DontConfirmOverwrite     : QFileDialog.Option = ... # 0x4
        DontUseSheet             : QFileDialog.Option = ... # 0x8
        DontUseNativeDialog      : QFileDialog.Option = ... # 0x10
        ReadOnly                 : QFileDialog.Option = ... # 0x20
        HideNameFilterDetails    : QFileDialog.Option = ... # 0x40
        DontUseCustomDirectoryIcons: QFileDialog.Option = ... # 0x80

    class Options(object): ...

    class ViewMode(object):
        Detail                   : QFileDialog.ViewMode = ... # 0x0
        List                     : QFileDialog.ViewMode = ... # 0x1

    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QWidget, f:PySide2.QtCore.Qt.WindowFlags): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., caption:str=..., directory:str=..., filter:str=...): ...

    def accept(self): ...
    def acceptMode(self) -> PySide2.QtWidgets.QFileDialog.AcceptMode: ...
    def changeEvent(self, e:PySide2.QtCore.QEvent): ...
    def confirmOverwrite(self) -> bool: ...
    def defaultSuffix(self) -> str: ...
    def directory(self) -> PySide2.QtCore.QDir: ...
    def directoryUrl(self) -> PySide2.QtCore.QUrl: ...
    def done(self, result:int): ...
    def fileMode(self) -> PySide2.QtWidgets.QFileDialog.FileMode: ...
    def filter(self) -> PySide2.QtCore.QDir.Filters: ...
    @staticmethod
    def getExistingDirectory(parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., caption:str=..., dir:str=..., options:PySide2.QtWidgets.QFileDialog.Options=...) -> str: ...
    @staticmethod
    def getExistingDirectoryUrl(parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., caption:str=..., dir:PySide2.QtCore.QUrl=..., options:PySide2.QtWidgets.QFileDialog.Options=..., supportedSchemes:typing.Sequence=...) -> PySide2.QtCore.QUrl: ...
    @staticmethod
    def getOpenFileName(parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., caption:str=..., dir:str=..., filter:str=..., options:PySide2.QtWidgets.QFileDialog.Options=...) -> typing.Tuple: ...
    @staticmethod
    def getOpenFileNames(parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., caption:str=..., dir:str=..., filter:str=..., options:PySide2.QtWidgets.QFileDialog.Options=...) -> typing.Tuple: ...
    @staticmethod
    def getOpenFileUrl(parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., caption:str=..., dir:PySide2.QtCore.QUrl=..., filter:str=..., options:PySide2.QtWidgets.QFileDialog.Options=..., supportedSchemes:typing.Sequence=...) -> typing.Tuple: ...
    @staticmethod
    def getOpenFileUrls(parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., caption:str=..., dir:PySide2.QtCore.QUrl=..., filter:str=..., options:PySide2.QtWidgets.QFileDialog.Options=..., supportedSchemes:typing.Sequence=...) -> typing.Tuple: ...
    @staticmethod
    def getSaveFileName(parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., caption:str=..., dir:str=..., filter:str=..., options:PySide2.QtWidgets.QFileDialog.Options=...) -> typing.Tuple: ...
    @staticmethod
    def getSaveFileUrl(parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., caption:str=..., dir:PySide2.QtCore.QUrl=..., filter:str=..., options:PySide2.QtWidgets.QFileDialog.Options=..., supportedSchemes:typing.Sequence=...) -> typing.Tuple: ...
    def history(self) -> typing.List: ...
    def iconProvider(self) -> PySide2.QtWidgets.QFileIconProvider: ...
    def isNameFilterDetailsVisible(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def itemDelegate(self) -> PySide2.QtWidgets.QAbstractItemDelegate: ...
    def labelText(self, label:PySide2.QtWidgets.QFileDialog.DialogLabel) -> str: ...
    def mimeTypeFilters(self) -> typing.List: ...
    def nameFilters(self) -> typing.List: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver:PySide2.QtCore.QObject, member:bytes): ...
    def options(self) -> PySide2.QtWidgets.QFileDialog.Options: ...
    def proxyModel(self) -> PySide2.QtCore.QAbstractProxyModel: ...
    def resolveSymlinks(self) -> bool: ...
    def restoreState(self, state:PySide2.QtCore.QByteArray) -> bool: ...
    @staticmethod
    def saveFileContent(fileContent:PySide2.QtCore.QByteArray, fileNameHint:str=...): ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def selectFile(self, filename:str): ...
    def selectMimeTypeFilter(self, filter:str): ...
    def selectNameFilter(self, filter:str): ...
    def selectUrl(self, url:PySide2.QtCore.QUrl): ...
    def selectedFiles(self) -> typing.List: ...
    def selectedMimeTypeFilter(self) -> str: ...
    def selectedNameFilter(self) -> str: ...
    def selectedUrls(self) -> typing.List: ...
    def setAcceptMode(self, mode:PySide2.QtWidgets.QFileDialog.AcceptMode): ...
    def setConfirmOverwrite(self, enabled:bool): ...
    def setDefaultSuffix(self, suffix:str): ...
    @typing.overload
    def setDirectory(self, directory:PySide2.QtCore.QDir): ...
    @typing.overload
    def setDirectory(self, directory:str): ...
    def setDirectoryUrl(self, directory:PySide2.QtCore.QUrl): ...
    def setFileMode(self, mode:PySide2.QtWidgets.QFileDialog.FileMode): ...
    def setFilter(self, filters:PySide2.QtCore.QDir.Filters): ...
    def setHistory(self, paths:typing.Sequence): ...
    def setIconProvider(self, provider:PySide2.QtWidgets.QFileIconProvider): ...
    def setItemDelegate(self, delegate:PySide2.QtWidgets.QAbstractItemDelegate): ...
    def setLabelText(self, label:PySide2.QtWidgets.QFileDialog.DialogLabel, text:str): ...
    def setMimeTypeFilters(self, filters:typing.Sequence): ...
    def setNameFilter(self, filter:str): ...
    def setNameFilterDetailsVisible(self, enabled:bool): ...
    def setNameFilters(self, filters:typing.Sequence): ...
    def setOption(self, option:PySide2.QtWidgets.QFileDialog.Option, on:bool=...): ...
    def setOptions(self, options:PySide2.QtWidgets.QFileDialog.Options): ...
    def setProxyModel(self, model:PySide2.QtCore.QAbstractProxyModel): ...
    def setReadOnly(self, enabled:bool): ...
    def setResolveSymlinks(self, enabled:bool): ...
    def setSidebarUrls(self, urls:typing.Sequence): ...
    def setSupportedSchemes(self, schemes:typing.Sequence): ...
    def setViewMode(self, mode:PySide2.QtWidgets.QFileDialog.ViewMode): ...
    def setVisible(self, visible:bool): ...
    def sidebarUrls(self) -> typing.List: ...
    def supportedSchemes(self) -> typing.List: ...
    def testOption(self, option:PySide2.QtWidgets.QFileDialog.Option) -> bool: ...
    def viewMode(self) -> PySide2.QtWidgets.QFileDialog.ViewMode: ...


class QFileIconProvider(Shiboken.Object):
    Computer                 : QFileIconProvider = ... # 0x0
    Desktop                  : QFileIconProvider = ... # 0x1
    DontUseCustomDirectoryIcons: QFileIconProvider = ... # 0x1
    Trashcan                 : QFileIconProvider = ... # 0x2
    Network                  : QFileIconProvider = ... # 0x3
    Drive                    : QFileIconProvider = ... # 0x4
    Folder                   : QFileIconProvider = ... # 0x5
    File                     : QFileIconProvider = ... # 0x6

    class IconType(object):
        Computer                 : QFileIconProvider.IconType = ... # 0x0
        Desktop                  : QFileIconProvider.IconType = ... # 0x1
        Trashcan                 : QFileIconProvider.IconType = ... # 0x2
        Network                  : QFileIconProvider.IconType = ... # 0x3
        Drive                    : QFileIconProvider.IconType = ... # 0x4
        Folder                   : QFileIconProvider.IconType = ... # 0x5
        File                     : QFileIconProvider.IconType = ... # 0x6

    class Option(object):
        DontUseCustomDirectoryIcons: QFileIconProvider.Option = ... # 0x1

    class Options(object): ...

    def __init__(self): ...

    @typing.overload
    def icon(self, info:PySide2.QtCore.QFileInfo) -> PySide2.QtGui.QIcon: ...
    @typing.overload
    def icon(self, type:PySide2.QtWidgets.QFileIconProvider.IconType) -> PySide2.QtGui.QIcon: ...
    def options(self) -> PySide2.QtWidgets.QFileIconProvider.Options: ...
    def setOptions(self, options:PySide2.QtWidgets.QFileIconProvider.Options): ...
    def type(self, info:PySide2.QtCore.QFileInfo) -> str: ...


class QFileSystemModel(PySide2.QtCore.QAbstractItemModel):
    DontWatchForChanges      : QFileSystemModel = ... # 0x1
    FileIconRole             : QFileSystemModel = ... # 0x1
    DontResolveSymlinks      : QFileSystemModel = ... # 0x2
    DontUseCustomDirectoryIcons: QFileSystemModel = ... # 0x4
    FilePathRole             : QFileSystemModel = ... # 0x101
    FileNameRole             : QFileSystemModel = ... # 0x102
    FilePermissions          : QFileSystemModel = ... # 0x103

    class Option(object):
        DontWatchForChanges      : QFileSystemModel.Option = ... # 0x1
        DontResolveSymlinks      : QFileSystemModel.Option = ... # 0x2
        DontUseCustomDirectoryIcons: QFileSystemModel.Option = ... # 0x4

    class Options(object): ...

    class Roles(object):
        FileIconRole             : QFileSystemModel.Roles = ... # 0x1
        FilePathRole             : QFileSystemModel.Roles = ... # 0x101
        FileNameRole             : QFileSystemModel.Roles = ... # 0x102
        FilePermissions          : QFileSystemModel.Roles = ... # 0x103

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def canFetchMore(self, parent:PySide2.QtCore.QModelIndex) -> bool: ...
    def columnCount(self, parent:PySide2.QtCore.QModelIndex=...) -> int: ...
    def data(self, index:PySide2.QtCore.QModelIndex, role:int=...) -> typing.Any: ...
    def dropMimeData(self, data:PySide2.QtCore.QMimeData, action:PySide2.QtCore.Qt.DropAction, row:int, column:int, parent:PySide2.QtCore.QModelIndex) -> bool: ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def fetchMore(self, parent:PySide2.QtCore.QModelIndex): ...
    def fileIcon(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtGui.QIcon: ...
    def fileInfo(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QFileInfo: ...
    def fileName(self, index:PySide2.QtCore.QModelIndex) -> str: ...
    def filePath(self, index:PySide2.QtCore.QModelIndex) -> str: ...
    def filter(self) -> PySide2.QtCore.QDir.Filters: ...
    def flags(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent:PySide2.QtCore.QModelIndex=...) -> bool: ...
    def headerData(self, section:int, orientation:PySide2.QtCore.Qt.Orientation, role:int=...) -> typing.Any: ...
    def iconProvider(self) -> PySide2.QtWidgets.QFileIconProvider: ...
    @typing.overload
    def index(self, path:str, column:int=...) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def index(self, row:int, column:int, parent:PySide2.QtCore.QModelIndex=...) -> PySide2.QtCore.QModelIndex: ...
    def isDir(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def lastModified(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QDateTime: ...
    def mimeData(self, indexes:typing.List) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List: ...
    def mkdir(self, parent:PySide2.QtCore.QModelIndex, name:str) -> PySide2.QtCore.QModelIndex: ...
    def myComputer(self, role:int=...) -> typing.Any: ...
    def nameFilterDisables(self) -> bool: ...
    def nameFilters(self) -> typing.List: ...
    def options(self) -> PySide2.QtWidgets.QFileSystemModel.Options: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, child:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def remove(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def resolveSymlinks(self) -> bool: ...
    def rmdir(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def rootDirectory(self) -> PySide2.QtCore.QDir: ...
    def rootPath(self) -> str: ...
    def rowCount(self, parent:PySide2.QtCore.QModelIndex=...) -> int: ...
    def setData(self, index:PySide2.QtCore.QModelIndex, value:typing.Any, role:int=...) -> bool: ...
    def setFilter(self, filters:PySide2.QtCore.QDir.Filters): ...
    def setIconProvider(self, provider:PySide2.QtWidgets.QFileIconProvider): ...
    def setNameFilterDisables(self, enable:bool): ...
    def setNameFilters(self, filters:typing.Sequence): ...
    def setOption(self, option:PySide2.QtWidgets.QFileSystemModel.Option, on:bool=...): ...
    def setOptions(self, options:PySide2.QtWidgets.QFileSystemModel.Options): ...
    def setReadOnly(self, enable:bool): ...
    def setResolveSymlinks(self, enable:bool): ...
    def setRootPath(self, path:str) -> PySide2.QtCore.QModelIndex: ...
    def sibling(self, row:int, column:int, idx:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def size(self, index:PySide2.QtCore.QModelIndex) -> int: ...
    def sort(self, column:int, order:PySide2.QtCore.Qt.SortOrder=...): ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def testOption(self, option:PySide2.QtWidgets.QFileSystemModel.Option) -> bool: ...
    def timerEvent(self, event:PySide2.QtCore.QTimerEvent): ...
    def type(self, index:PySide2.QtCore.QModelIndex) -> str: ...


class QFocusFrame(PySide2.QtWidgets.QWidget):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1:PySide2.QtCore.QObject, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOption): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def setWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QFontComboBox(PySide2.QtWidgets.QComboBox):
    AllFonts                 : QFontComboBox = ... # 0x0
    ScalableFonts            : QFontComboBox = ... # 0x1
    NonScalableFonts         : QFontComboBox = ... # 0x2
    MonospacedFonts          : QFontComboBox = ... # 0x4
    ProportionalFonts        : QFontComboBox = ... # 0x8

    class FontFilter(object):
        AllFonts                 : QFontComboBox.FontFilter = ... # 0x0
        ScalableFonts            : QFontComboBox.FontFilter = ... # 0x1
        NonScalableFonts         : QFontComboBox.FontFilter = ... # 0x2
        MonospacedFonts          : QFontComboBox.FontFilter = ... # 0x4
        ProportionalFonts        : QFontComboBox.FontFilter = ... # 0x8

    class FontFilters(object): ...

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def fontFilters(self) -> PySide2.QtWidgets.QFontComboBox.FontFilters: ...
    def setCurrentFont(self, f:PySide2.QtGui.QFont): ...
    def setFontFilters(self, filters:PySide2.QtWidgets.QFontComboBox.FontFilters): ...
    def setWritingSystem(self, arg__1:PySide2.QtGui.QFontDatabase.WritingSystem): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def writingSystem(self) -> PySide2.QtGui.QFontDatabase.WritingSystem: ...


class QFontDialog(PySide2.QtWidgets.QDialog):
    NoButtons                : QFontDialog = ... # 0x1
    DontUseNativeDialog      : QFontDialog = ... # 0x2
    ScalableFonts            : QFontDialog = ... # 0x4
    NonScalableFonts         : QFontDialog = ... # 0x8
    MonospacedFonts          : QFontDialog = ... # 0x10
    ProportionalFonts        : QFontDialog = ... # 0x20

    class FontDialogOption(object):
        NoButtons                : QFontDialog.FontDialogOption = ... # 0x1
        DontUseNativeDialog      : QFontDialog.FontDialogOption = ... # 0x2
        ScalableFonts            : QFontDialog.FontDialogOption = ... # 0x4
        NonScalableFonts         : QFontDialog.FontDialogOption = ... # 0x8
        MonospacedFonts          : QFontDialog.FontDialogOption = ... # 0x10
        ProportionalFonts        : QFontDialog.FontDialogOption = ... # 0x20

    class FontDialogOptions(object): ...

    @typing.overload
    def __init__(self, initial:PySide2.QtGui.QFont, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def done(self, result:int): ...
    def eventFilter(self, object:PySide2.QtCore.QObject, event:PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    @staticmethod
    def getFont(initial:PySide2.QtGui.QFont, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., title:str=..., options:PySide2.QtWidgets.QFontDialog.FontDialogOptions=...) -> typing.Tuple: ...
    @typing.overload
    @staticmethod
    def getFont(parent:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> typing.Tuple: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver:PySide2.QtCore.QObject, member:bytes): ...
    def options(self) -> PySide2.QtWidgets.QFontDialog.FontDialogOptions: ...
    def selectedFont(self) -> PySide2.QtGui.QFont: ...
    def setCurrentFont(self, font:PySide2.QtGui.QFont): ...
    def setOption(self, option:PySide2.QtWidgets.QFontDialog.FontDialogOption, on:bool=...): ...
    def setOptions(self, options:PySide2.QtWidgets.QFontDialog.FontDialogOptions): ...
    def setVisible(self, visible:bool): ...
    def testOption(self, option:PySide2.QtWidgets.QFontDialog.FontDialogOption) -> bool: ...


class QFormLayout(PySide2.QtWidgets.QLayout):
    DontWrapRows             : QFormLayout = ... # 0x0
    FieldsStayAtSizeHint     : QFormLayout = ... # 0x0
    LabelRole                : QFormLayout = ... # 0x0
    ExpandingFieldsGrow      : QFormLayout = ... # 0x1
    FieldRole                : QFormLayout = ... # 0x1
    WrapLongRows             : QFormLayout = ... # 0x1
    AllNonFixedFieldsGrow    : QFormLayout = ... # 0x2
    SpanningRole             : QFormLayout = ... # 0x2
    WrapAllRows              : QFormLayout = ... # 0x2

    class FieldGrowthPolicy(object):
        FieldsStayAtSizeHint     : QFormLayout.FieldGrowthPolicy = ... # 0x0
        ExpandingFieldsGrow      : QFormLayout.FieldGrowthPolicy = ... # 0x1
        AllNonFixedFieldsGrow    : QFormLayout.FieldGrowthPolicy = ... # 0x2

    class ItemRole(object):
        LabelRole                : QFormLayout.ItemRole = ... # 0x0
        FieldRole                : QFormLayout.ItemRole = ... # 0x1
        SpanningRole             : QFormLayout.ItemRole = ... # 0x2

    class RowWrapPolicy(object):
        DontWrapRows             : QFormLayout.RowWrapPolicy = ... # 0x0
        WrapLongRows             : QFormLayout.RowWrapPolicy = ... # 0x1
        WrapAllRows              : QFormLayout.RowWrapPolicy = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def addItem(self, item:PySide2.QtWidgets.QLayoutItem): ...
    @typing.overload
    def addRow(self, label:PySide2.QtWidgets.QWidget, field:PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def addRow(self, label:PySide2.QtWidgets.QWidget, field:PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def addRow(self, labelText:str, field:PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def addRow(self, labelText:str, field:PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def addRow(self, layout:PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def addRow(self, widget:PySide2.QtWidgets.QWidget): ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def fieldGrowthPolicy(self) -> PySide2.QtWidgets.QFormLayout.FieldGrowthPolicy: ...
    def formAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def getItemPosition(self, index:int, rolePtr:PySide2.QtWidgets.QFormLayout.ItemRole) -> int: ...
    def getLayoutPosition(self, layout:PySide2.QtWidgets.QLayout, rolePtr:PySide2.QtWidgets.QFormLayout.ItemRole) -> int: ...
    def getWidgetPosition(self, widget:PySide2.QtWidgets.QWidget, rolePtr:PySide2.QtWidgets.QFormLayout.ItemRole) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width:int) -> int: ...
    def horizontalSpacing(self) -> int: ...
    @typing.overload
    def insertRow(self, row:int, label:PySide2.QtWidgets.QWidget, field:PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def insertRow(self, row:int, label:PySide2.QtWidgets.QWidget, field:PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def insertRow(self, row:int, labelText:str, field:PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def insertRow(self, row:int, labelText:str, field:PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def insertRow(self, row:int, layout:PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def insertRow(self, row:int, widget:PySide2.QtWidgets.QWidget): ...
    def invalidate(self): ...
    @typing.overload
    def itemAt(self, index:int) -> PySide2.QtWidgets.QLayoutItem: ...
    @typing.overload
    def itemAt(self, row:int, role:PySide2.QtWidgets.QFormLayout.ItemRole) -> PySide2.QtWidgets.QLayoutItem: ...
    def labelAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    @typing.overload
    def labelForField(self, field:PySide2.QtWidgets.QLayout) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    def labelForField(self, field:PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    @typing.overload
    def removeRow(self, layout:PySide2.QtWidgets.QLayout): ...
    @typing.overload
    def removeRow(self, row:int): ...
    @typing.overload
    def removeRow(self, widget:PySide2.QtWidgets.QWidget): ...
    def rowCount(self) -> int: ...
    def rowWrapPolicy(self) -> PySide2.QtWidgets.QFormLayout.RowWrapPolicy: ...
    def setFieldGrowthPolicy(self, policy:PySide2.QtWidgets.QFormLayout.FieldGrowthPolicy): ...
    def setFormAlignment(self, alignment:PySide2.QtCore.Qt.Alignment): ...
    def setGeometry(self, rect:PySide2.QtCore.QRect): ...
    def setHorizontalSpacing(self, spacing:int): ...
    def setItem(self, row:int, role:PySide2.QtWidgets.QFormLayout.ItemRole, item:PySide2.QtWidgets.QLayoutItem): ...
    def setLabelAlignment(self, alignment:PySide2.QtCore.Qt.Alignment): ...
    def setLayout(self, row:int, role:PySide2.QtWidgets.QFormLayout.ItemRole, layout:PySide2.QtWidgets.QLayout): ...
    def setRowWrapPolicy(self, policy:PySide2.QtWidgets.QFormLayout.RowWrapPolicy): ...
    def setSpacing(self, arg__1:int): ...
    def setVerticalSpacing(self, spacing:int): ...
    def setWidget(self, row:int, role:PySide2.QtWidgets.QFormLayout.ItemRole, widget:PySide2.QtWidgets.QWidget): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def takeAt(self, index:int) -> PySide2.QtWidgets.QLayoutItem: ...
    def verticalSpacing(self) -> int: ...


class QFrame(PySide2.QtWidgets.QWidget):
    NoFrame                  : QFrame = ... # 0x0
    Box                      : QFrame = ... # 0x1
    Panel                    : QFrame = ... # 0x2
    WinPanel                 : QFrame = ... # 0x3
    HLine                    : QFrame = ... # 0x4
    VLine                    : QFrame = ... # 0x5
    StyledPanel              : QFrame = ... # 0x6
    Shape_Mask               : QFrame = ... # 0xf
    Plain                    : QFrame = ... # 0x10
    Raised                   : QFrame = ... # 0x20
    Sunken                   : QFrame = ... # 0x30
    Shadow_Mask              : QFrame = ... # 0xf0

    class Shadow(object):
        Plain                    : QFrame.Shadow = ... # 0x10
        Raised                   : QFrame.Shadow = ... # 0x20
        Sunken                   : QFrame.Shadow = ... # 0x30

    class Shape(object):
        NoFrame                  : QFrame.Shape = ... # 0x0
        Box                      : QFrame.Shape = ... # 0x1
        Panel                    : QFrame.Shape = ... # 0x2
        WinPanel                 : QFrame.Shape = ... # 0x3
        HLine                    : QFrame.Shape = ... # 0x4
        VLine                    : QFrame.Shape = ... # 0x5
        StyledPanel              : QFrame.Shape = ... # 0x6

    class StyleMask(object):
        Shape_Mask               : QFrame.StyleMask = ... # 0xf
        Shadow_Mask              : QFrame.StyleMask = ... # 0xf0

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., f:PySide2.QtCore.Qt.WindowFlags=...): ...

    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def drawFrame(self, arg__1:PySide2.QtGui.QPainter): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def frameRect(self) -> PySide2.QtCore.QRect: ...
    def frameShadow(self) -> PySide2.QtWidgets.QFrame.Shadow: ...
    def frameShape(self) -> PySide2.QtWidgets.QFrame.Shape: ...
    def frameStyle(self) -> int: ...
    def frameWidth(self) -> int: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionFrame): ...
    def lineWidth(self) -> int: ...
    def midLineWidth(self) -> int: ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def setFrameRect(self, arg__1:PySide2.QtCore.QRect): ...
    def setFrameShadow(self, arg__1:PySide2.QtWidgets.QFrame.Shadow): ...
    def setFrameShape(self, arg__1:PySide2.QtWidgets.QFrame.Shape): ...
    def setFrameStyle(self, arg__1:int): ...
    def setLineWidth(self, arg__1:int): ...
    def setMidLineWidth(self, arg__1:int): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QGesture(PySide2.QtCore.QObject):
    CancelNone               : QGesture = ... # 0x0
    CancelAllInContext       : QGesture = ... # 0x1

    class GestureCancelPolicy(object):
        CancelNone               : QGesture.GestureCancelPolicy = ... # 0x0
        CancelAllInContext       : QGesture.GestureCancelPolicy = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def gestureCancelPolicy(self) -> PySide2.QtWidgets.QGesture.GestureCancelPolicy: ...
    def gestureType(self) -> PySide2.QtCore.Qt.GestureType: ...
    def hasHotSpot(self) -> bool: ...
    def hotSpot(self) -> PySide2.QtCore.QPointF: ...
    def setGestureCancelPolicy(self, policy:PySide2.QtWidgets.QGesture.GestureCancelPolicy): ...
    def setHotSpot(self, value:PySide2.QtCore.QPointF): ...
    def state(self) -> PySide2.QtCore.Qt.GestureState: ...
    def unsetHotSpot(self): ...


class QGestureEvent(PySide2.QtCore.QEvent):

    def __init__(self, gestures:typing.Sequence): ...

    @typing.overload
    def accept(self): ...
    @typing.overload
    def accept(self, arg__1:PySide2.QtCore.Qt.GestureType): ...
    @typing.overload
    def accept(self, arg__1:PySide2.QtWidgets.QGesture): ...
    def activeGestures(self) -> typing.List: ...
    def canceledGestures(self) -> typing.List: ...
    def gesture(self, type:PySide2.QtCore.Qt.GestureType) -> PySide2.QtWidgets.QGesture: ...
    def gestures(self) -> typing.List: ...
    @typing.overload
    def ignore(self): ...
    @typing.overload
    def ignore(self, arg__1:PySide2.QtCore.Qt.GestureType): ...
    @typing.overload
    def ignore(self, arg__1:PySide2.QtWidgets.QGesture): ...
    @typing.overload
    def isAccepted(self) -> bool: ...
    @typing.overload
    def isAccepted(self, arg__1:PySide2.QtCore.Qt.GestureType) -> bool: ...
    @typing.overload
    def isAccepted(self, arg__1:PySide2.QtWidgets.QGesture) -> bool: ...
    def mapToGraphicsScene(self, gesturePoint:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def setAccepted(self, accepted:bool): ...
    @typing.overload
    def setAccepted(self, arg__1:PySide2.QtCore.Qt.GestureType, arg__2:bool): ...
    @typing.overload
    def setAccepted(self, arg__1:PySide2.QtWidgets.QGesture, arg__2:bool): ...
    def setWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QGestureRecognizer(Shiboken.Object):
    Ignore                   : QGestureRecognizer = ... # 0x1
    MayBeGesture             : QGestureRecognizer = ... # 0x2
    TriggerGesture           : QGestureRecognizer = ... # 0x4
    FinishGesture            : QGestureRecognizer = ... # 0x8
    CancelGesture            : QGestureRecognizer = ... # 0x10
    ResultState_Mask         : QGestureRecognizer = ... # 0xff
    ConsumeEventHint         : QGestureRecognizer = ... # 0x100
    ResultHint_Mask          : QGestureRecognizer = ... # 0xff00

    class Result(object): ...

    class ResultFlag(object):
        Ignore                   : QGestureRecognizer.ResultFlag = ... # 0x1
        MayBeGesture             : QGestureRecognizer.ResultFlag = ... # 0x2
        TriggerGesture           : QGestureRecognizer.ResultFlag = ... # 0x4
        FinishGesture            : QGestureRecognizer.ResultFlag = ... # 0x8
        CancelGesture            : QGestureRecognizer.ResultFlag = ... # 0x10
        ResultState_Mask         : QGestureRecognizer.ResultFlag = ... # 0xff
        ConsumeEventHint         : QGestureRecognizer.ResultFlag = ... # 0x100
        ResultHint_Mask          : QGestureRecognizer.ResultFlag = ... # 0xff00

    def __init__(self): ...

    def create(self, target:PySide2.QtCore.QObject) -> PySide2.QtWidgets.QGesture: ...
    def recognize(self, state:PySide2.QtWidgets.QGesture, watched:PySide2.QtCore.QObject, event:PySide2.QtCore.QEvent) -> PySide2.QtWidgets.QGestureRecognizer.Result: ...
    @staticmethod
    def registerRecognizer(recognizer:PySide2.QtWidgets.QGestureRecognizer) -> PySide2.QtCore.Qt.GestureType: ...
    def reset(self, state:PySide2.QtWidgets.QGesture): ...
    @staticmethod
    def unregisterRecognizer(type:PySide2.QtCore.Qt.GestureType): ...


class QGraphicsAnchor(PySide2.QtCore.QObject):
    def setSizePolicy(self, policy:PySide2.QtWidgets.QSizePolicy.Policy): ...
    def setSpacing(self, spacing:float): ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy.Policy: ...
    def spacing(self) -> float: ...
    def unsetSpacing(self): ...


class QGraphicsAnchorLayout(PySide2.QtWidgets.QGraphicsLayout):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem]=...): ...

    def addAnchor(self, firstItem:PySide2.QtWidgets.QGraphicsLayoutItem, firstEdge:PySide2.QtCore.Qt.AnchorPoint, secondItem:PySide2.QtWidgets.QGraphicsLayoutItem, secondEdge:PySide2.QtCore.Qt.AnchorPoint) -> PySide2.QtWidgets.QGraphicsAnchor: ...
    def addAnchors(self, firstItem:PySide2.QtWidgets.QGraphicsLayoutItem, secondItem:PySide2.QtWidgets.QGraphicsLayoutItem, orientations:PySide2.QtCore.Qt.Orientations=...): ...
    def addCornerAnchors(self, firstItem:PySide2.QtWidgets.QGraphicsLayoutItem, firstCorner:PySide2.QtCore.Qt.Corner, secondItem:PySide2.QtWidgets.QGraphicsLayoutItem, secondCorner:PySide2.QtCore.Qt.Corner): ...
    def anchor(self, firstItem:PySide2.QtWidgets.QGraphicsLayoutItem, firstEdge:PySide2.QtCore.Qt.AnchorPoint, secondItem:PySide2.QtWidgets.QGraphicsLayoutItem, secondEdge:PySide2.QtCore.Qt.AnchorPoint) -> PySide2.QtWidgets.QGraphicsAnchor: ...
    def count(self) -> int: ...
    def horizontalSpacing(self) -> float: ...
    def invalidate(self): ...
    def itemAt(self, index:int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index:int): ...
    def setGeometry(self, rect:PySide2.QtCore.QRectF): ...
    def setHorizontalSpacing(self, spacing:float): ...
    def setSpacing(self, spacing:float): ...
    def setVerticalSpacing(self, spacing:float): ...
    def sizeHint(self, which:PySide2.QtCore.Qt.SizeHint, constraint:PySide2.QtCore.QSizeF=...) -> PySide2.QtCore.QSizeF: ...
    def verticalSpacing(self) -> float: ...


class QGraphicsBlurEffect(PySide2.QtWidgets.QGraphicsEffect):
    PerformanceHint          : QGraphicsBlurEffect = ... # 0x0
    QualityHint              : QGraphicsBlurEffect = ... # 0x1
    AnimationHint            : QGraphicsBlurEffect = ... # 0x2

    class BlurHint(object):
        PerformanceHint          : QGraphicsBlurEffect.BlurHint = ... # 0x0
        QualityHint              : QGraphicsBlurEffect.BlurHint = ... # 0x1
        AnimationHint            : QGraphicsBlurEffect.BlurHint = ... # 0x2

    class BlurHints(object): ...

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def blurHints(self) -> PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints: ...
    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def draw(self, painter:PySide2.QtGui.QPainter): ...
    def setBlurHints(self, hints:PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints): ...
    def setBlurRadius(self, blurRadius:float): ...


class QGraphicsColorizeEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def color(self) -> PySide2.QtGui.QColor: ...
    def draw(self, painter:PySide2.QtGui.QPainter): ...
    def setColor(self, c:PySide2.QtGui.QColor): ...
    def setStrength(self, strength:float): ...
    def strength(self) -> float: ...


class QGraphicsDropShadowEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def color(self) -> PySide2.QtGui.QColor: ...
    def draw(self, painter:PySide2.QtGui.QPainter): ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def setBlurRadius(self, blurRadius:float): ...
    def setColor(self, color:PySide2.QtGui.QColor): ...
    @typing.overload
    def setOffset(self, d:float): ...
    @typing.overload
    def setOffset(self, dx:float, dy:float): ...
    @typing.overload
    def setOffset(self, ofs:PySide2.QtCore.QPointF): ...
    def setXOffset(self, dx:float): ...
    def setYOffset(self, dy:float): ...
    def xOffset(self) -> float: ...
    def yOffset(self) -> float: ...


class QGraphicsEffect(PySide2.QtCore.QObject):
    NoPad                    : QGraphicsEffect = ... # 0x0
    PadToTransparentBorder   : QGraphicsEffect = ... # 0x1
    SourceAttached           : QGraphicsEffect = ... # 0x1
    PadToEffectiveBoundingRect: QGraphicsEffect = ... # 0x2
    SourceDetached           : QGraphicsEffect = ... # 0x2
    SourceBoundingRectChanged: QGraphicsEffect = ... # 0x4
    SourceInvalidated        : QGraphicsEffect = ... # 0x8

    class ChangeFlag(object):
        SourceAttached           : QGraphicsEffect.ChangeFlag = ... # 0x1
        SourceDetached           : QGraphicsEffect.ChangeFlag = ... # 0x2
        SourceBoundingRectChanged: QGraphicsEffect.ChangeFlag = ... # 0x4
        SourceInvalidated        : QGraphicsEffect.ChangeFlag = ... # 0x8

    class ChangeFlags(object): ...

    class PixmapPadMode(object):
        NoPad                    : QGraphicsEffect.PixmapPadMode = ... # 0x0
        PadToTransparentBorder   : QGraphicsEffect.PixmapPadMode = ... # 0x1
        PadToEffectiveBoundingRect: QGraphicsEffect.PixmapPadMode = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def boundingRectFor(self, sourceRect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    def draw(self, painter:PySide2.QtGui.QPainter): ...
    def drawSource(self, painter:PySide2.QtGui.QPainter): ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, enable:bool): ...
    def sourceBoundingRect(self, system:PySide2.QtCore.Qt.CoordinateSystem=...) -> PySide2.QtCore.QRectF: ...
    def sourceChanged(self, flags:PySide2.QtWidgets.QGraphicsEffect.ChangeFlags): ...
    def sourceIsPixmap(self) -> bool: ...
    def sourcePixmap(self, system:PySide2.QtCore.Qt.CoordinateSystem=..., offset:typing.Optional[PySide2.QtCore.QPoint]=..., mode:PySide2.QtWidgets.QGraphicsEffect.PixmapPadMode=...) -> PySide2.QtGui.QPixmap: ...
    def update(self): ...
    def updateBoundingRect(self): ...


class QGraphicsEllipseItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, rect:PySide2.QtCore.QRectF, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, x:float, y:float, w:float, h:float, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point:PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant:typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect:PySide2.QtCore.QRectF): ...
    @typing.overload
    def setRect(self, x:float, y:float, w:float, h:float): ...
    def setSpanAngle(self, angle:int): ...
    def setStartAngle(self, angle:int): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def spanAngle(self) -> int: ...
    def startAngle(self) -> int: ...
    def type(self) -> int: ...


class QGraphicsGridLayout(PySide2.QtWidgets.QGraphicsLayout):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem]=...): ...

    @typing.overload
    def addItem(self, item:PySide2.QtWidgets.QGraphicsLayoutItem, row:int, column:int, alignment:PySide2.QtCore.Qt.Alignment=...): ...
    @typing.overload
    def addItem(self, item:PySide2.QtWidgets.QGraphicsLayoutItem, row:int, column:int, rowSpan:int, columnSpan:int, alignment:PySide2.QtCore.Qt.Alignment=...): ...
    def alignment(self, item:PySide2.QtWidgets.QGraphicsLayoutItem) -> PySide2.QtCore.Qt.Alignment: ...
    def columnAlignment(self, column:int) -> PySide2.QtCore.Qt.Alignment: ...
    def columnCount(self) -> int: ...
    def columnMaximumWidth(self, column:int) -> float: ...
    def columnMinimumWidth(self, column:int) -> float: ...
    def columnPreferredWidth(self, column:int) -> float: ...
    def columnSpacing(self, column:int) -> float: ...
    def columnStretchFactor(self, column:int) -> int: ...
    def count(self) -> int: ...
    def horizontalSpacing(self) -> float: ...
    def invalidate(self): ...
    @typing.overload
    def itemAt(self, index:int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    @typing.overload
    def itemAt(self, row:int, column:int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index:int): ...
    def removeItem(self, item:PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def rowAlignment(self, row:int) -> PySide2.QtCore.Qt.Alignment: ...
    def rowCount(self) -> int: ...
    def rowMaximumHeight(self, row:int) -> float: ...
    def rowMinimumHeight(self, row:int) -> float: ...
    def rowPreferredHeight(self, row:int) -> float: ...
    def rowSpacing(self, row:int) -> float: ...
    def rowStretchFactor(self, row:int) -> int: ...
    def setAlignment(self, item:PySide2.QtWidgets.QGraphicsLayoutItem, alignment:PySide2.QtCore.Qt.Alignment): ...
    def setColumnAlignment(self, column:int, alignment:PySide2.QtCore.Qt.Alignment): ...
    def setColumnFixedWidth(self, column:int, width:float): ...
    def setColumnMaximumWidth(self, column:int, width:float): ...
    def setColumnMinimumWidth(self, column:int, width:float): ...
    def setColumnPreferredWidth(self, column:int, width:float): ...
    def setColumnSpacing(self, column:int, spacing:float): ...
    def setColumnStretchFactor(self, column:int, stretch:int): ...
    def setGeometry(self, rect:PySide2.QtCore.QRectF): ...
    def setHorizontalSpacing(self, spacing:float): ...
    def setRowAlignment(self, row:int, alignment:PySide2.QtCore.Qt.Alignment): ...
    def setRowFixedHeight(self, row:int, height:float): ...
    def setRowMaximumHeight(self, row:int, height:float): ...
    def setRowMinimumHeight(self, row:int, height:float): ...
    def setRowPreferredHeight(self, row:int, height:float): ...
    def setRowSpacing(self, row:int, spacing:float): ...
    def setRowStretchFactor(self, row:int, stretch:int): ...
    def setSpacing(self, spacing:float): ...
    def setVerticalSpacing(self, spacing:float): ...
    def sizeHint(self, which:PySide2.QtCore.Qt.SizeHint, constraint:PySide2.QtCore.QSizeF=...) -> PySide2.QtCore.QSizeF: ...
    def verticalSpacing(self) -> float: ...


class QGraphicsItem(Shiboken.Object):
    UserExtension            : QGraphicsItem = ... # -0x80000000
    ItemPositionChange       : QGraphicsItem = ... # 0x0
    NoCache                  : QGraphicsItem = ... # 0x0
    NonModal                 : QGraphicsItem = ... # 0x0
    ItemCoordinateCache      : QGraphicsItem = ... # 0x1
    ItemIsMovable            : QGraphicsItem = ... # 0x1
    ItemMatrixChange         : QGraphicsItem = ... # 0x1
    PanelModal               : QGraphicsItem = ... # 0x1
    DeviceCoordinateCache    : QGraphicsItem = ... # 0x2
    ItemIsSelectable         : QGraphicsItem = ... # 0x2
    ItemVisibleChange        : QGraphicsItem = ... # 0x2
    SceneModal               : QGraphicsItem = ... # 0x2
    ItemEnabledChange        : QGraphicsItem = ... # 0x3
    ItemIsFocusable          : QGraphicsItem = ... # 0x4
    ItemSelectedChange       : QGraphicsItem = ... # 0x4
    ItemParentChange         : QGraphicsItem = ... # 0x5
    ItemChildAddedChange     : QGraphicsItem = ... # 0x6
    ItemChildRemovedChange   : QGraphicsItem = ... # 0x7
    ItemClipsToShape         : QGraphicsItem = ... # 0x8
    ItemTransformChange      : QGraphicsItem = ... # 0x8
    ItemPositionHasChanged   : QGraphicsItem = ... # 0x9
    ItemTransformHasChanged  : QGraphicsItem = ... # 0xa
    ItemSceneChange          : QGraphicsItem = ... # 0xb
    ItemVisibleHasChanged    : QGraphicsItem = ... # 0xc
    ItemEnabledHasChanged    : QGraphicsItem = ... # 0xd
    ItemSelectedHasChanged   : QGraphicsItem = ... # 0xe
    ItemParentHasChanged     : QGraphicsItem = ... # 0xf
    ItemClipsChildrenToShape : QGraphicsItem = ... # 0x10
    ItemSceneHasChanged      : QGraphicsItem = ... # 0x10
    ItemCursorChange         : QGraphicsItem = ... # 0x11
    ItemCursorHasChanged     : QGraphicsItem = ... # 0x12
    ItemToolTipChange        : QGraphicsItem = ... # 0x13
    ItemToolTipHasChanged    : QGraphicsItem = ... # 0x14
    ItemFlagsChange          : QGraphicsItem = ... # 0x15
    ItemFlagsHaveChanged     : QGraphicsItem = ... # 0x16
    ItemZValueChange         : QGraphicsItem = ... # 0x17
    ItemZValueHasChanged     : QGraphicsItem = ... # 0x18
    ItemOpacityChange        : QGraphicsItem = ... # 0x19
    ItemOpacityHasChanged    : QGraphicsItem = ... # 0x1a
    ItemScenePositionHasChanged: QGraphicsItem = ... # 0x1b
    ItemRotationChange       : QGraphicsItem = ... # 0x1c
    ItemRotationHasChanged   : QGraphicsItem = ... # 0x1d
    ItemScaleChange          : QGraphicsItem = ... # 0x1e
    ItemScaleHasChanged      : QGraphicsItem = ... # 0x1f
    ItemIgnoresTransformations: QGraphicsItem = ... # 0x20
    ItemTransformOriginPointChange: QGraphicsItem = ... # 0x20
    ItemTransformOriginPointHasChanged: QGraphicsItem = ... # 0x21
    ItemIgnoresParentOpacity : QGraphicsItem = ... # 0x40
    ItemDoesntPropagateOpacityToChildren: QGraphicsItem = ... # 0x80
    ItemStacksBehindParent   : QGraphicsItem = ... # 0x100
    ItemUsesExtendedStyleOption: QGraphicsItem = ... # 0x200
    ItemHasNoContents        : QGraphicsItem = ... # 0x400
    ItemSendsGeometryChanges : QGraphicsItem = ... # 0x800
    ItemAcceptsInputMethod   : QGraphicsItem = ... # 0x1000
    ItemNegativeZStacksBehindParent: QGraphicsItem = ... # 0x2000
    ItemIsPanel              : QGraphicsItem = ... # 0x4000
    ItemIsFocusScope         : QGraphicsItem = ... # 0x8000
    ItemSendsScenePositionChanges: QGraphicsItem = ... # 0x10000
    ItemStopsClickFocusPropagation: QGraphicsItem = ... # 0x20000
    ItemStopsFocusHandling   : QGraphicsItem = ... # 0x40000
    ItemContainsChildrenInShape: QGraphicsItem = ... # 0x80000

    class CacheMode(object):
        NoCache                  : QGraphicsItem.CacheMode = ... # 0x0
        ItemCoordinateCache      : QGraphicsItem.CacheMode = ... # 0x1
        DeviceCoordinateCache    : QGraphicsItem.CacheMode = ... # 0x2

    class Extension(object):
        UserExtension            : QGraphicsItem.Extension = ... # -0x80000000

    class GraphicsItemChange(object):
        ItemPositionChange       : QGraphicsItem.GraphicsItemChange = ... # 0x0
        ItemMatrixChange         : QGraphicsItem.GraphicsItemChange = ... # 0x1
        ItemVisibleChange        : QGraphicsItem.GraphicsItemChange = ... # 0x2
        ItemEnabledChange        : QGraphicsItem.GraphicsItemChange = ... # 0x3
        ItemSelectedChange       : QGraphicsItem.GraphicsItemChange = ... # 0x4
        ItemParentChange         : QGraphicsItem.GraphicsItemChange = ... # 0x5
        ItemChildAddedChange     : QGraphicsItem.GraphicsItemChange = ... # 0x6
        ItemChildRemovedChange   : QGraphicsItem.GraphicsItemChange = ... # 0x7
        ItemTransformChange      : QGraphicsItem.GraphicsItemChange = ... # 0x8
        ItemPositionHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x9
        ItemTransformHasChanged  : QGraphicsItem.GraphicsItemChange = ... # 0xa
        ItemSceneChange          : QGraphicsItem.GraphicsItemChange = ... # 0xb
        ItemVisibleHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xc
        ItemEnabledHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xd
        ItemSelectedHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0xe
        ItemParentHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0xf
        ItemSceneHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x10
        ItemCursorChange         : QGraphicsItem.GraphicsItemChange = ... # 0x11
        ItemCursorHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x12
        ItemToolTipChange        : QGraphicsItem.GraphicsItemChange = ... # 0x13
        ItemToolTipHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x14
        ItemFlagsChange          : QGraphicsItem.GraphicsItemChange = ... # 0x15
        ItemFlagsHaveChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x16
        ItemZValueChange         : QGraphicsItem.GraphicsItemChange = ... # 0x17
        ItemZValueHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x18
        ItemOpacityChange        : QGraphicsItem.GraphicsItemChange = ... # 0x19
        ItemOpacityHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x1a
        ItemScenePositionHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x1b
        ItemRotationChange       : QGraphicsItem.GraphicsItemChange = ... # 0x1c
        ItemRotationHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x1d
        ItemScaleChange          : QGraphicsItem.GraphicsItemChange = ... # 0x1e
        ItemScaleHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x1f
        ItemTransformOriginPointChange: QGraphicsItem.GraphicsItemChange = ... # 0x20
        ItemTransformOriginPointHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x21

    class GraphicsItemFlag(object):
        ItemIsMovable            : QGraphicsItem.GraphicsItemFlag = ... # 0x1
        ItemIsSelectable         : QGraphicsItem.GraphicsItemFlag = ... # 0x2
        ItemIsFocusable          : QGraphicsItem.GraphicsItemFlag = ... # 0x4
        ItemClipsToShape         : QGraphicsItem.GraphicsItemFlag = ... # 0x8
        ItemClipsChildrenToShape : QGraphicsItem.GraphicsItemFlag = ... # 0x10
        ItemIgnoresTransformations: QGraphicsItem.GraphicsItemFlag = ... # 0x20
        ItemIgnoresParentOpacity : QGraphicsItem.GraphicsItemFlag = ... # 0x40
        ItemDoesntPropagateOpacityToChildren: QGraphicsItem.GraphicsItemFlag = ... # 0x80
        ItemStacksBehindParent   : QGraphicsItem.GraphicsItemFlag = ... # 0x100
        ItemUsesExtendedStyleOption: QGraphicsItem.GraphicsItemFlag = ... # 0x200
        ItemHasNoContents        : QGraphicsItem.GraphicsItemFlag = ... # 0x400
        ItemSendsGeometryChanges : QGraphicsItem.GraphicsItemFlag = ... # 0x800
        ItemAcceptsInputMethod   : QGraphicsItem.GraphicsItemFlag = ... # 0x1000
        ItemNegativeZStacksBehindParent: QGraphicsItem.GraphicsItemFlag = ... # 0x2000
        ItemIsPanel              : QGraphicsItem.GraphicsItemFlag = ... # 0x4000
        ItemIsFocusScope         : QGraphicsItem.GraphicsItemFlag = ... # 0x8000
        ItemSendsScenePositionChanges: QGraphicsItem.GraphicsItemFlag = ... # 0x10000
        ItemStopsClickFocusPropagation: QGraphicsItem.GraphicsItemFlag = ... # 0x20000
        ItemStopsFocusHandling   : QGraphicsItem.GraphicsItemFlag = ... # 0x40000
        ItemContainsChildrenInShape: QGraphicsItem.GraphicsItemFlag = ... # 0x80000

    class GraphicsItemFlags(object): ...

    class PanelModality(object):
        NonModal                 : QGraphicsItem.PanelModality = ... # 0x0
        PanelModal               : QGraphicsItem.PanelModality = ... # 0x1
        SceneModal               : QGraphicsItem.PanelModality = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def acceptDrops(self) -> bool: ...
    def acceptHoverEvents(self) -> bool: ...
    def acceptTouchEvents(self) -> bool: ...
    def acceptedMouseButtons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def addToIndex(self): ...
    def advance(self, phase:int): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def boundingRegion(self, itemToDeviceTransform:PySide2.QtGui.QTransform) -> PySide2.QtGui.QRegion: ...
    def boundingRegionGranularity(self) -> float: ...
    def cacheMode(self) -> PySide2.QtWidgets.QGraphicsItem.CacheMode: ...
    def childItems(self) -> typing.List: ...
    def childrenBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def clearFocus(self): ...
    def clipPath(self) -> PySide2.QtGui.QPainterPath: ...
    def collidesWithItem(self, other:PySide2.QtWidgets.QGraphicsItem, mode:PySide2.QtCore.Qt.ItemSelectionMode=...) -> bool: ...
    def collidesWithPath(self, path:PySide2.QtGui.QPainterPath, mode:PySide2.QtCore.Qt.ItemSelectionMode=...) -> bool: ...
    def collidingItems(self, mode:PySide2.QtCore.Qt.ItemSelectionMode=...) -> typing.List: ...
    def commonAncestorItem(self, other:PySide2.QtWidgets.QGraphicsItem) -> PySide2.QtWidgets.QGraphicsItem: ...
    def contains(self, point:PySide2.QtCore.QPointF) -> bool: ...
    def contextMenuEvent(self, event:PySide2.QtWidgets.QGraphicsSceneContextMenuEvent): ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def data(self, key:int) -> typing.Any: ...
    def deviceTransform(self, viewportTransform:PySide2.QtGui.QTransform) -> PySide2.QtGui.QTransform: ...
    def dragEnterEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragLeaveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dropEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def effectiveOpacity(self) -> float: ...
    @typing.overload
    def ensureVisible(self, rect:PySide2.QtCore.QRectF=..., xmargin:int=..., ymargin:int=...): ...
    @typing.overload
    def ensureVisible(self, x:float, y:float, w:float, h:float, xmargin:int=..., ymargin:int=...): ...
    def extension(self, variant:typing.Any) -> typing.Any: ...
    def filtersChildEvents(self) -> bool: ...
    def flags(self) -> PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlags: ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def focusOutEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusProxy(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def focusScopeItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def grabKeyboard(self): ...
    def grabMouse(self): ...
    def graphicsEffect(self) -> PySide2.QtWidgets.QGraphicsEffect: ...
    def group(self) -> PySide2.QtWidgets.QGraphicsItemGroup: ...
    def handlesChildEvents(self) -> bool: ...
    def hasCursor(self) -> bool: ...
    def hasFocus(self) -> bool: ...
    def hide(self): ...
    def hoverEnterEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverLeaveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def inputMethodEvent(self, event:PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodHints(self) -> PySide2.QtCore.Qt.InputMethodHints: ...
    def inputMethodQuery(self, query:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def installSceneEventFilter(self, filterItem:PySide2.QtWidgets.QGraphicsItem): ...
    def isActive(self) -> bool: ...
    def isAncestorOf(self, child:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def isBlockedByModalPanel(self, blockingPanel:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...) -> bool: ...
    def isClipped(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    @typing.overload
    def isObscured(self, rect:PySide2.QtCore.QRectF=...) -> bool: ...
    @typing.overload
    def isObscured(self, x:float, y:float, w:float, h:float) -> bool: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def isPanel(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def isUnderMouse(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def isVisibleTo(self, parent:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def isWidget(self) -> bool: ...
    def isWindow(self) -> bool: ...
    def itemChange(self, change:PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange, value:typing.Any) -> typing.Any: ...
    def itemTransform(self, other:PySide2.QtWidgets.QGraphicsItem) -> typing.Tuple: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    @typing.overload
    def mapFromItem(self, item:PySide2.QtWidgets.QGraphicsItem, path:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromItem(self, item:PySide2.QtWidgets.QGraphicsItem, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromItem(self, item:PySide2.QtWidgets.QGraphicsItem, polygon:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromItem(self, item:PySide2.QtWidgets.QGraphicsItem, rect:PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromItem(self, item:PySide2.QtWidgets.QGraphicsItem, x:float, y:float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromItem(self, item:PySide2.QtWidgets.QGraphicsItem, x:float, y:float, w:float, h:float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, path:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromParent(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, polygon:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, x:float, y:float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, x:float, y:float, w:float, h:float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, path:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromScene(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromScene(self, polygon:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, x:float, y:float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapFromScene(self, x:float, y:float, w:float, h:float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapRectFromItem(self, item:PySide2.QtWidgets.QGraphicsItem, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromItem(self, item:PySide2.QtWidgets.QGraphicsItem, x:float, y:float, w:float, h:float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromParent(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromParent(self, x:float, y:float, w:float, h:float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromScene(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromScene(self, x:float, y:float, w:float, h:float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToItem(self, item:PySide2.QtWidgets.QGraphicsItem, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToItem(self, item:PySide2.QtWidgets.QGraphicsItem, x:float, y:float, w:float, h:float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToParent(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToParent(self, x:float, y:float, w:float, h:float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToScene(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapRectToScene(self, x:float, y:float, w:float, h:float) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def mapToItem(self, item:PySide2.QtWidgets.QGraphicsItem, path:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToItem(self, item:PySide2.QtWidgets.QGraphicsItem, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToItem(self, item:PySide2.QtWidgets.QGraphicsItem, polygon:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToItem(self, item:PySide2.QtWidgets.QGraphicsItem, rect:PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToItem(self, item:PySide2.QtWidgets.QGraphicsItem, x:float, y:float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToItem(self, item:PySide2.QtWidgets.QGraphicsItem, x:float, y:float, w:float, h:float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, path:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToParent(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, polygon:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, x:float, y:float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, x:float, y:float, w:float, h:float) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, path:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToScene(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, polygon:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, x:float, y:float) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, x:float, y:float, w:float, h:float) -> PySide2.QtGui.QPolygonF: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def mouseDoubleClickEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mousePressEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseReleaseEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def moveBy(self, dx:float, dy:float): ...
    def opacity(self) -> float: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def panel(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def panelModality(self) -> PySide2.QtWidgets.QGraphicsItem.PanelModality: ...
    def parentItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def parentObject(self) -> PySide2.QtWidgets.QGraphicsObject: ...
    def parentWidget(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def prepareGeometryChange(self): ...
    def removeFromIndex(self): ...
    def removeSceneEventFilter(self, filterItem:PySide2.QtWidgets.QGraphicsItem): ...
    def resetMatrix(self): ...
    def resetTransform(self): ...
    def rotation(self) -> float: ...
    def scale(self) -> float: ...
    def scene(self) -> PySide2.QtWidgets.QGraphicsScene: ...
    def sceneBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def sceneEvent(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def sceneEventFilter(self, watched:PySide2.QtWidgets.QGraphicsItem, event:PySide2.QtCore.QEvent) -> bool: ...
    def sceneMatrix(self) -> PySide2.QtGui.QMatrix: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def sceneTransform(self) -> PySide2.QtGui.QTransform: ...
    def scroll(self, dx:float, dy:float, rect:PySide2.QtCore.QRectF=...): ...
    def setAcceptDrops(self, on:bool): ...
    def setAcceptHoverEvents(self, enabled:bool): ...
    def setAcceptTouchEvents(self, enabled:bool): ...
    def setAcceptedMouseButtons(self, buttons:PySide2.QtCore.Qt.MouseButtons): ...
    def setActive(self, active:bool): ...
    def setBoundingRegionGranularity(self, granularity:float): ...
    def setCacheMode(self, mode:PySide2.QtWidgets.QGraphicsItem.CacheMode, cacheSize:PySide2.QtCore.QSize=...): ...
    def setCursor(self, cursor:PySide2.QtGui.QCursor): ...
    def setData(self, key:int, value:typing.Any): ...
    def setEnabled(self, enabled:bool): ...
    def setFiltersChildEvents(self, enabled:bool): ...
    def setFlag(self, flag:PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlag, enabled:bool=...): ...
    def setFlags(self, flags:PySide2.QtWidgets.QGraphicsItem.GraphicsItemFlags): ...
    def setFocus(self, focusReason:PySide2.QtCore.Qt.FocusReason=...): ...
    def setFocusProxy(self, item:PySide2.QtWidgets.QGraphicsItem): ...
    def setGraphicsEffect(self, effect:PySide2.QtWidgets.QGraphicsEffect): ...
    def setGroup(self, group:PySide2.QtWidgets.QGraphicsItemGroup): ...
    def setHandlesChildEvents(self, enabled:bool): ...
    def setInputMethodHints(self, hints:PySide2.QtCore.Qt.InputMethodHints): ...
    def setMatrix(self, matrix:PySide2.QtGui.QMatrix, combine:bool=...): ...
    def setOpacity(self, opacity:float): ...
    def setPanelModality(self, panelModality:PySide2.QtWidgets.QGraphicsItem.PanelModality): ...
    def setParentItem(self, parent:PySide2.QtWidgets.QGraphicsItem): ...
    @typing.overload
    def setPos(self, pos:PySide2.QtCore.QPointF): ...
    @typing.overload
    def setPos(self, x:float, y:float): ...
    def setRotation(self, angle:float): ...
    def setScale(self, scale:float): ...
    def setSelected(self, selected:bool): ...
    def setToolTip(self, toolTip:str): ...
    def setTransform(self, matrix:PySide2.QtGui.QTransform, combine:bool=...): ...
    @typing.overload
    def setTransformOriginPoint(self, ax:float, ay:float): ...
    @typing.overload
    def setTransformOriginPoint(self, origin:PySide2.QtCore.QPointF): ...
    def setTransformations(self, transformations:typing.Sequence): ...
    def setVisible(self, visible:bool): ...
    def setX(self, x:float): ...
    def setY(self, y:float): ...
    def setZValue(self, z:float): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def show(self): ...
    def stackBefore(self, sibling:PySide2.QtWidgets.QGraphicsItem): ...
    def toGraphicsObject(self) -> PySide2.QtWidgets.QGraphicsObject: ...
    def toolTip(self) -> str: ...
    def topLevelItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def topLevelWidget(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...
    def transformOriginPoint(self) -> PySide2.QtCore.QPointF: ...
    def transformations(self) -> typing.List: ...
    def type(self) -> int: ...
    def ungrabKeyboard(self): ...
    def ungrabMouse(self): ...
    def unsetCursor(self): ...
    @typing.overload
    def update(self, rect:PySide2.QtCore.QRectF=...): ...
    @typing.overload
    def update(self, x:float, y:float, width:float, height:float): ...
    def updateMicroFocus(self): ...
    def wheelEvent(self, event:PySide2.QtWidgets.QGraphicsSceneWheelEvent): ...
    def window(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def zValue(self) -> float: ...


class QGraphicsItemAnimation(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def afterAnimationStep(self, step:float): ...
    def beforeAnimationStep(self, step:float): ...
    def clear(self): ...
    def horizontalScaleAt(self, step:float) -> float: ...
    def horizontalShearAt(self, step:float) -> float: ...
    def item(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def matrixAt(self, step:float) -> PySide2.QtGui.QMatrix: ...
    def posAt(self, step:float) -> PySide2.QtCore.QPointF: ...
    def posList(self) -> typing.List: ...
    def reset(self): ...
    def rotationAt(self, step:float) -> float: ...
    def rotationList(self) -> typing.List: ...
    def scaleList(self) -> typing.List: ...
    def setItem(self, item:PySide2.QtWidgets.QGraphicsItem): ...
    def setPosAt(self, step:float, pos:PySide2.QtCore.QPointF): ...
    def setRotationAt(self, step:float, angle:float): ...
    def setScaleAt(self, step:float, sx:float, sy:float): ...
    def setShearAt(self, step:float, sh:float, sv:float): ...
    def setStep(self, x:float): ...
    def setTimeLine(self, timeLine:PySide2.QtCore.QTimeLine): ...
    def setTranslationAt(self, step:float, dx:float, dy:float): ...
    def shearList(self) -> typing.List: ...
    def timeLine(self) -> PySide2.QtCore.QTimeLine: ...
    def transformAt(self, step:float) -> PySide2.QtGui.QTransform: ...
    def translationList(self) -> typing.List: ...
    def verticalScaleAt(self, step:float) -> float: ...
    def verticalShearAt(self, step:float) -> float: ...
    def xTranslationAt(self, step:float) -> float: ...
    def yTranslationAt(self, step:float) -> float: ...


class QGraphicsItemGroup(PySide2.QtWidgets.QGraphicsItem):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def addToGroup(self, item:PySide2.QtWidgets.QGraphicsItem): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def removeFromGroup(self, item:PySide2.QtWidgets.QGraphicsItem): ...
    def type(self) -> int: ...


class QGraphicsLayout(PySide2.QtWidgets.QGraphicsLayoutItem):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem]=...): ...

    def activate(self): ...
    def addChildLayoutItem(self, layoutItem:PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def count(self) -> int: ...
    def getContentsMargins(self) -> typing.Tuple: ...
    @staticmethod
    def instantInvalidatePropagation() -> bool: ...
    def invalidate(self): ...
    def isActivated(self) -> bool: ...
    def itemAt(self, i:int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index:int): ...
    def setContentsMargins(self, left:float, top:float, right:float, bottom:float): ...
    @staticmethod
    def setInstantInvalidatePropagation(enable:bool): ...
    def updateGeometry(self): ...
    def widgetEvent(self, e:PySide2.QtCore.QEvent): ...


class QGraphicsLayoutItem(Shiboken.Object):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem]=..., isLayout:bool=...): ...

    def contentsRect(self) -> PySide2.QtCore.QRectF: ...
    def effectiveSizeHint(self, which:PySide2.QtCore.Qt.SizeHint, constraint:PySide2.QtCore.QSizeF=...) -> PySide2.QtCore.QSizeF: ...
    def geometry(self) -> PySide2.QtCore.QRectF: ...
    def getContentsMargins(self) -> typing.Tuple: ...
    def graphicsItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def isLayout(self) -> bool: ...
    def maximumHeight(self) -> float: ...
    def maximumSize(self) -> PySide2.QtCore.QSizeF: ...
    def maximumWidth(self) -> float: ...
    def minimumHeight(self) -> float: ...
    def minimumSize(self) -> PySide2.QtCore.QSizeF: ...
    def minimumWidth(self) -> float: ...
    def ownedByLayout(self) -> bool: ...
    def parentLayoutItem(self) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def preferredHeight(self) -> float: ...
    def preferredSize(self) -> PySide2.QtCore.QSizeF: ...
    def preferredWidth(self) -> float: ...
    def setGeometry(self, rect:PySide2.QtCore.QRectF): ...
    def setGraphicsItem(self, item:PySide2.QtWidgets.QGraphicsItem): ...
    def setMaximumHeight(self, height:float): ...
    @typing.overload
    def setMaximumSize(self, size:PySide2.QtCore.QSizeF): ...
    @typing.overload
    def setMaximumSize(self, w:float, h:float): ...
    def setMaximumWidth(self, width:float): ...
    def setMinimumHeight(self, height:float): ...
    @typing.overload
    def setMinimumSize(self, size:PySide2.QtCore.QSizeF): ...
    @typing.overload
    def setMinimumSize(self, w:float, h:float): ...
    def setMinimumWidth(self, width:float): ...
    def setOwnedByLayout(self, ownedByLayout:bool): ...
    def setParentLayoutItem(self, parent:PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def setPreferredHeight(self, height:float): ...
    @typing.overload
    def setPreferredSize(self, size:PySide2.QtCore.QSizeF): ...
    @typing.overload
    def setPreferredSize(self, w:float, h:float): ...
    def setPreferredWidth(self, width:float): ...
    @typing.overload
    def setSizePolicy(self, hPolicy:PySide2.QtWidgets.QSizePolicy.Policy, vPolicy:PySide2.QtWidgets.QSizePolicy.Policy, controlType:PySide2.QtWidgets.QSizePolicy.ControlType=...): ...
    @typing.overload
    def setSizePolicy(self, policy:PySide2.QtWidgets.QSizePolicy): ...
    def sizeHint(self, which:PySide2.QtCore.Qt.SizeHint, constraint:PySide2.QtCore.QSizeF=...) -> PySide2.QtCore.QSizeF: ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def updateGeometry(self): ...


class QGraphicsLineItem(PySide2.QtWidgets.QGraphicsItem):

    @typing.overload
    def __init__(self, line:PySide2.QtCore.QLineF, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, x1:float, y1:float, x2:float, y2:float, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point:PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant:typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def line(self) -> PySide2.QtCore.QLineF: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def pen(self) -> PySide2.QtGui.QPen: ...
    @typing.overload
    def setLine(self, line:PySide2.QtCore.QLineF): ...
    @typing.overload
    def setLine(self, x1:float, y1:float, x2:float, y2:float): ...
    def setPen(self, pen:PySide2.QtGui.QPen): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsLinearLayout(PySide2.QtWidgets.QGraphicsLayout):

    @typing.overload
    def __init__(self, orientation:PySide2.QtCore.Qt.Orientation, parent:typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsLayoutItem]=...): ...

    def addItem(self, item:PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def addStretch(self, stretch:int=...): ...
    def alignment(self, item:PySide2.QtWidgets.QGraphicsLayoutItem) -> PySide2.QtCore.Qt.Alignment: ...
    def count(self) -> int: ...
    def dump(self, indent:int=...): ...
    def insertItem(self, index:int, item:PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def insertStretch(self, index:int, stretch:int=...): ...
    def invalidate(self): ...
    def itemAt(self, index:int) -> PySide2.QtWidgets.QGraphicsLayoutItem: ...
    def itemSpacing(self, index:int) -> float: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def removeAt(self, index:int): ...
    def removeItem(self, item:PySide2.QtWidgets.QGraphicsLayoutItem): ...
    def setAlignment(self, item:PySide2.QtWidgets.QGraphicsLayoutItem, alignment:PySide2.QtCore.Qt.Alignment): ...
    def setGeometry(self, rect:PySide2.QtCore.QRectF): ...
    def setItemSpacing(self, index:int, spacing:float): ...
    def setOrientation(self, orientation:PySide2.QtCore.Qt.Orientation): ...
    def setSpacing(self, spacing:float): ...
    def setStretchFactor(self, item:PySide2.QtWidgets.QGraphicsLayoutItem, stretch:int): ...
    def sizeHint(self, which:PySide2.QtCore.Qt.SizeHint, constraint:PySide2.QtCore.QSizeF=...) -> PySide2.QtCore.QSizeF: ...
    def spacing(self) -> float: ...
    def stretchFactor(self, item:PySide2.QtWidgets.QGraphicsLayoutItem) -> int: ...


class QGraphicsObject(PySide2.QtWidgets.QGraphicsItem, PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def event(self, ev:PySide2.QtCore.QEvent) -> bool: ...
    def grabGesture(self, type:PySide2.QtCore.Qt.GestureType, flags:PySide2.QtCore.Qt.GestureFlags=...): ...
    def ungrabGesture(self, type:PySide2.QtCore.Qt.GestureType): ...
    def updateMicroFocus(self): ...


class QGraphicsOpacityEffect(PySide2.QtWidgets.QGraphicsEffect):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def draw(self, painter:PySide2.QtGui.QPainter): ...
    def opacity(self) -> float: ...
    def opacityMask(self) -> PySide2.QtGui.QBrush: ...
    def setOpacity(self, opacity:float): ...
    def setOpacityMask(self, mask:PySide2.QtGui.QBrush): ...


class QGraphicsPathItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, path:PySide2.QtGui.QPainterPath, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point:PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant:typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def path(self) -> PySide2.QtGui.QPainterPath: ...
    def setPath(self, path:PySide2.QtGui.QPainterPath): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsPixmapItem(PySide2.QtWidgets.QGraphicsItem):
    MaskShape                : QGraphicsPixmapItem = ... # 0x0
    BoundingRectShape        : QGraphicsPixmapItem = ... # 0x1
    HeuristicMaskShape       : QGraphicsPixmapItem = ... # 0x2

    class ShapeMode(object):
        MaskShape                : QGraphicsPixmapItem.ShapeMode = ... # 0x0
        BoundingRectShape        : QGraphicsPixmapItem.ShapeMode = ... # 0x1
        HeuristicMaskShape       : QGraphicsPixmapItem.ShapeMode = ... # 0x2

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, pixmap:PySide2.QtGui.QPixmap, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point:PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant:typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:PySide2.QtWidgets.QWidget): ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    def setOffset(self, offset:PySide2.QtCore.QPointF): ...
    @typing.overload
    def setOffset(self, x:float, y:float): ...
    def setPixmap(self, pixmap:PySide2.QtGui.QPixmap): ...
    def setShapeMode(self, mode:PySide2.QtWidgets.QGraphicsPixmapItem.ShapeMode): ...
    def setTransformationMode(self, mode:PySide2.QtCore.Qt.TransformationMode): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def shapeMode(self) -> PySide2.QtWidgets.QGraphicsPixmapItem.ShapeMode: ...
    def transformationMode(self) -> PySide2.QtCore.Qt.TransformationMode: ...
    def type(self) -> int: ...


class QGraphicsPolygonItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, polygon:PySide2.QtGui.QPolygonF, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point:PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant:typing.Any) -> typing.Any: ...
    def fillRule(self) -> PySide2.QtCore.Qt.FillRule: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def polygon(self) -> PySide2.QtGui.QPolygonF: ...
    def setFillRule(self, rule:PySide2.QtCore.Qt.FillRule): ...
    def setPolygon(self, polygon:PySide2.QtGui.QPolygonF): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsProxyWidget(PySide2.QtWidgets.QGraphicsWidget):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=..., wFlags:PySide2.QtCore.Qt.WindowFlags=...): ...

    def contextMenuEvent(self, event:PySide2.QtWidgets.QGraphicsSceneContextMenuEvent): ...
    def createProxyForChildWidget(self, child:PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def dragEnterEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragLeaveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dropEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object:PySide2.QtCore.QObject, event:PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def focusOutEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def grabMouseEvent(self, event:PySide2.QtCore.QEvent): ...
    def hideEvent(self, event:PySide2.QtGui.QHideEvent): ...
    def hoverEnterEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverLeaveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def inputMethodEvent(self, event:PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodQuery(self, query:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def itemChange(self, change:PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange, value:typing.Any) -> typing.Any: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def mouseDoubleClickEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mousePressEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseReleaseEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def newProxyWidget(self, arg__1:PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:PySide2.QtWidgets.QWidget): ...
    def resizeEvent(self, event:PySide2.QtWidgets.QGraphicsSceneResizeEvent): ...
    def setGeometry(self, rect:PySide2.QtCore.QRectF): ...
    def setWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def showEvent(self, event:PySide2.QtGui.QShowEvent): ...
    def sizeHint(self, which:PySide2.QtCore.Qt.SizeHint, constraint:PySide2.QtCore.QSizeF=...) -> PySide2.QtCore.QSizeF: ...
    def subWidgetRect(self, widget:PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRectF: ...
    def type(self) -> int: ...
    def ungrabMouseEvent(self, event:PySide2.QtCore.QEvent): ...
    def wheelEvent(self, event:PySide2.QtWidgets.QGraphicsSceneWheelEvent): ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QGraphicsRectItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, rect:PySide2.QtCore.QRectF, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, x:float, y:float, w:float, h:float, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point:PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant:typing.Any) -> typing.Any: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect:PySide2.QtCore.QRectF): ...
    @typing.overload
    def setRect(self, x:float, y:float, w:float, h:float): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsRotation(PySide2.QtWidgets.QGraphicsTransform):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def angle(self) -> float: ...
    def applyTo(self, matrix:PySide2.QtGui.QMatrix4x4): ...
    def axis(self) -> PySide2.QtGui.QVector3D: ...
    def origin(self) -> PySide2.QtGui.QVector3D: ...
    def setAngle(self, arg__1:float): ...
    @typing.overload
    def setAxis(self, axis:PySide2.QtCore.Qt.Axis): ...
    @typing.overload
    def setAxis(self, axis:PySide2.QtGui.QVector3D): ...
    def setOrigin(self, point:PySide2.QtGui.QVector3D): ...


class QGraphicsScale(PySide2.QtWidgets.QGraphicsTransform):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def applyTo(self, matrix:PySide2.QtGui.QMatrix4x4): ...
    def origin(self) -> PySide2.QtGui.QVector3D: ...
    def setOrigin(self, point:PySide2.QtGui.QVector3D): ...
    def setXScale(self, arg__1:float): ...
    def setYScale(self, arg__1:float): ...
    def setZScale(self, arg__1:float): ...
    def xScale(self) -> float: ...
    def yScale(self) -> float: ...
    def zScale(self) -> float: ...


class QGraphicsScene(PySide2.QtCore.QObject):
    NoIndex                  : QGraphicsScene = ... # -0x1
    BspTreeIndex             : QGraphicsScene = ... # 0x0
    ItemLayer                : QGraphicsScene = ... # 0x1
    BackgroundLayer          : QGraphicsScene = ... # 0x2
    ForegroundLayer          : QGraphicsScene = ... # 0x4
    AllLayers                : QGraphicsScene = ... # 0xffff

    class ItemIndexMethod(object):
        NoIndex                  : QGraphicsScene.ItemIndexMethod = ... # -0x1
        BspTreeIndex             : QGraphicsScene.ItemIndexMethod = ... # 0x0

    class SceneLayer(object):
        ItemLayer                : QGraphicsScene.SceneLayer = ... # 0x1
        BackgroundLayer          : QGraphicsScene.SceneLayer = ... # 0x2
        ForegroundLayer          : QGraphicsScene.SceneLayer = ... # 0x4
        AllLayers                : QGraphicsScene.SceneLayer = ... # 0xffff

    class SceneLayers(object): ...

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, sceneRect:PySide2.QtCore.QRectF, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, x:float, y:float, width:float, height:float, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def activePanel(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def activeWindow(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    @typing.overload
    def addEllipse(self, rect:PySide2.QtCore.QRectF, pen:PySide2.QtGui.QPen=..., brush:PySide2.QtGui.QBrush=...) -> PySide2.QtWidgets.QGraphicsEllipseItem: ...
    @typing.overload
    def addEllipse(self, x:float, y:float, w:float, h:float, pen:PySide2.QtGui.QPen=..., brush:PySide2.QtGui.QBrush=...) -> PySide2.QtWidgets.QGraphicsEllipseItem: ...
    def addItem(self, item:PySide2.QtWidgets.QGraphicsItem): ...
    @typing.overload
    def addLine(self, line:PySide2.QtCore.QLineF, pen:PySide2.QtGui.QPen=...) -> PySide2.QtWidgets.QGraphicsLineItem: ...
    @typing.overload
    def addLine(self, x1:float, y1:float, x2:float, y2:float, pen:PySide2.QtGui.QPen=...) -> PySide2.QtWidgets.QGraphicsLineItem: ...
    def addPath(self, path:PySide2.QtGui.QPainterPath, pen:PySide2.QtGui.QPen=..., brush:PySide2.QtGui.QBrush=...) -> PySide2.QtWidgets.QGraphicsPathItem: ...
    def addPixmap(self, pixmap:PySide2.QtGui.QPixmap) -> PySide2.QtWidgets.QGraphicsPixmapItem: ...
    def addPolygon(self, polygon:PySide2.QtGui.QPolygonF, pen:PySide2.QtGui.QPen=..., brush:PySide2.QtGui.QBrush=...) -> PySide2.QtWidgets.QGraphicsPolygonItem: ...
    @typing.overload
    def addRect(self, rect:PySide2.QtCore.QRectF, pen:PySide2.QtGui.QPen=..., brush:PySide2.QtGui.QBrush=...) -> PySide2.QtWidgets.QGraphicsRectItem: ...
    @typing.overload
    def addRect(self, x:float, y:float, w:float, h:float, pen:PySide2.QtGui.QPen=..., brush:PySide2.QtGui.QBrush=...) -> PySide2.QtWidgets.QGraphicsRectItem: ...
    def addSimpleText(self, text:str, font:PySide2.QtGui.QFont=...) -> PySide2.QtWidgets.QGraphicsSimpleTextItem: ...
    def addText(self, text:str, font:PySide2.QtGui.QFont=...) -> PySide2.QtWidgets.QGraphicsTextItem: ...
    def addWidget(self, widget:PySide2.QtWidgets.QWidget, wFlags:PySide2.QtCore.Qt.WindowFlags=...) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def advance(self): ...
    def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def bspTreeDepth(self) -> int: ...
    def clear(self): ...
    def clearFocus(self): ...
    def clearSelection(self): ...
    def collidingItems(self, item:PySide2.QtWidgets.QGraphicsItem, mode:PySide2.QtCore.Qt.ItemSelectionMode=...) -> typing.List: ...
    def contextMenuEvent(self, event:PySide2.QtWidgets.QGraphicsSceneContextMenuEvent): ...
    def createItemGroup(self, items:typing.Sequence) -> PySide2.QtWidgets.QGraphicsItemGroup: ...
    def destroyItemGroup(self, group:PySide2.QtWidgets.QGraphicsItemGroup): ...
    def dragEnterEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragLeaveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def drawBackground(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRectF): ...
    def drawForeground(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRectF): ...
    def dropEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched:PySide2.QtCore.QObject, event:PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def focusOnTouch(self) -> bool: ...
    def focusOutEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foregroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def hasFocus(self) -> bool: ...
    def height(self) -> float: ...
    def helpEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHelpEvent): ...
    def inputMethodEvent(self, event:PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodQuery(self, query:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def invalidate(self, rect:PySide2.QtCore.QRectF=..., layers:PySide2.QtWidgets.QGraphicsScene.SceneLayers=...): ...
    @typing.overload
    def invalidate(self, x:float, y:float, w:float, h:float, layers:PySide2.QtWidgets.QGraphicsScene.SceneLayers=...): ...
    def isActive(self) -> bool: ...
    def isSortCacheEnabled(self) -> bool: ...
    @typing.overload
    def itemAt(self, pos:PySide2.QtCore.QPointF, deviceTransform:PySide2.QtGui.QTransform) -> PySide2.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def itemAt(self, x:float, y:float, deviceTransform:PySide2.QtGui.QTransform) -> PySide2.QtWidgets.QGraphicsItem: ...
    def itemIndexMethod(self) -> PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod: ...
    @typing.overload
    def items(self, order:PySide2.QtCore.Qt.SortOrder=...) -> typing.List: ...
    @typing.overload
    def items(self, path:PySide2.QtGui.QPainterPath, mode:PySide2.QtCore.Qt.ItemSelectionMode=..., order:PySide2.QtCore.Qt.SortOrder=..., deviceTransform:PySide2.QtGui.QTransform=...) -> typing.List: ...
    @typing.overload
    def items(self, polygon:PySide2.QtGui.QPolygonF, mode:PySide2.QtCore.Qt.ItemSelectionMode=..., order:PySide2.QtCore.Qt.SortOrder=..., deviceTransform:PySide2.QtGui.QTransform=...) -> typing.List: ...
    @typing.overload
    def items(self, pos:PySide2.QtCore.QPointF, mode:PySide2.QtCore.Qt.ItemSelectionMode=..., order:PySide2.QtCore.Qt.SortOrder=..., deviceTransform:PySide2.QtGui.QTransform=...) -> typing.List: ...
    @typing.overload
    def items(self, rect:PySide2.QtCore.QRectF, mode:PySide2.QtCore.Qt.ItemSelectionMode=..., order:PySide2.QtCore.Qt.SortOrder=..., deviceTransform:PySide2.QtGui.QTransform=...) -> typing.List: ...
    @typing.overload
    def items(self, x:float, y:float, w:float, h:float, mode:PySide2.QtCore.Qt.ItemSelectionMode, order:PySide2.QtCore.Qt.SortOrder, deviceTransform:PySide2.QtGui.QTransform=...) -> typing.List: ...
    def itemsBoundingRect(self) -> PySide2.QtCore.QRectF: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def minimumRenderSize(self) -> float: ...
    def mouseDoubleClickEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseGrabberItem(self) -> PySide2.QtWidgets.QGraphicsItem: ...
    def mouseMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mousePressEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseReleaseEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def removeItem(self, item:PySide2.QtWidgets.QGraphicsItem): ...
    def render(self, painter:PySide2.QtGui.QPainter, target:PySide2.QtCore.QRectF=..., source:PySide2.QtCore.QRectF=..., aspectRatioMode:PySide2.QtCore.Qt.AspectRatioMode=...): ...
    def sceneRect(self) -> PySide2.QtCore.QRectF: ...
    def selectedItems(self) -> typing.List: ...
    def selectionArea(self) -> PySide2.QtGui.QPainterPath: ...
    def sendEvent(self, item:PySide2.QtWidgets.QGraphicsItem, event:PySide2.QtCore.QEvent) -> bool: ...
    def setActivePanel(self, item:PySide2.QtWidgets.QGraphicsItem): ...
    def setActiveWindow(self, widget:PySide2.QtWidgets.QGraphicsWidget): ...
    def setBackgroundBrush(self, brush:PySide2.QtGui.QBrush): ...
    def setBspTreeDepth(self, depth:int): ...
    def setFocus(self, focusReason:PySide2.QtCore.Qt.FocusReason=...): ...
    def setFocusItem(self, item:PySide2.QtWidgets.QGraphicsItem, focusReason:PySide2.QtCore.Qt.FocusReason=...): ...
    def setFocusOnTouch(self, enabled:bool): ...
    def setFont(self, font:PySide2.QtGui.QFont): ...
    def setForegroundBrush(self, brush:PySide2.QtGui.QBrush): ...
    def setItemIndexMethod(self, method:PySide2.QtWidgets.QGraphicsScene.ItemIndexMethod): ...
    def setMinimumRenderSize(self, minSize:float): ...
    def setPalette(self, palette:PySide2.QtGui.QPalette): ...
    @typing.overload
    def setSceneRect(self, rect:PySide2.QtCore.QRectF): ...
    @typing.overload
    def setSceneRect(self, x:float, y:float, w:float, h:float): ...
    @typing.overload
    def setSelectionArea(self, path:PySide2.QtGui.QPainterPath, deviceTransform:PySide2.QtGui.QTransform): ...
    @typing.overload
    def setSelectionArea(self, path:PySide2.QtGui.QPainterPath, mode:PySide2.QtCore.Qt.ItemSelectionMode=..., deviceTransform:PySide2.QtGui.QTransform=...): ...
    @typing.overload
    def setSelectionArea(self, path:PySide2.QtGui.QPainterPath, selectionOperation:PySide2.QtCore.Qt.ItemSelectionOperation, mode:PySide2.QtCore.Qt.ItemSelectionMode=..., deviceTransform:PySide2.QtGui.QTransform=...): ...
    def setSortCacheEnabled(self, enabled:bool): ...
    def setStickyFocus(self, enabled:bool): ...
    def setStyle(self, style:PySide2.QtWidgets.QStyle): ...
    def stickyFocus(self) -> bool: ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...
    @typing.overload
    def update(self, rect:PySide2.QtCore.QRectF=...): ...
    @typing.overload
    def update(self, x:float, y:float, w:float, h:float): ...
    def views(self) -> typing.List: ...
    def wheelEvent(self, event:PySide2.QtWidgets.QGraphicsSceneWheelEvent): ...
    def width(self) -> float: ...


class QGraphicsSceneContextMenuEvent(PySide2.QtWidgets.QGraphicsSceneEvent):
    Mouse                    : QGraphicsSceneContextMenuEvent = ... # 0x0
    Keyboard                 : QGraphicsSceneContextMenuEvent = ... # 0x1
    Other                    : QGraphicsSceneContextMenuEvent = ... # 0x2

    class Reason(object):
        Mouse                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x0
        Keyboard                 : QGraphicsSceneContextMenuEvent.Reason = ... # 0x1
        Other                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x2

    def __init__(self, type:typing.Optional[PySide2.QtCore.QEvent.Type]=...): ...

    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def reason(self) -> PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.Reason: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setModifiers(self, modifiers:PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setPos(self, pos:PySide2.QtCore.QPointF): ...
    def setReason(self, reason:PySide2.QtWidgets.QGraphicsSceneContextMenuEvent.Reason): ...
    def setScenePos(self, pos:PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos:PySide2.QtCore.QPoint): ...


class QGraphicsSceneDragDropEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type:typing.Optional[PySide2.QtCore.QEvent.Type]=...): ...

    def acceptProposedAction(self): ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def dropAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def mimeData(self) -> PySide2.QtCore.QMimeData: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def possibleActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def proposedAction(self) -> PySide2.QtCore.Qt.DropAction: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButtons(self, buttons:PySide2.QtCore.Qt.MouseButtons): ...
    def setDropAction(self, action:PySide2.QtCore.Qt.DropAction): ...
    def setModifiers(self, modifiers:PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setPos(self, pos:PySide2.QtCore.QPointF): ...
    def setPossibleActions(self, actions:PySide2.QtCore.Qt.DropActions): ...
    def setProposedAction(self, action:PySide2.QtCore.Qt.DropAction): ...
    def setScenePos(self, pos:PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos:PySide2.QtCore.QPoint): ...
    def source(self) -> PySide2.QtWidgets.QWidget: ...


class QGraphicsSceneEvent(PySide2.QtCore.QEvent):

    def __init__(self, type:PySide2.QtCore.QEvent.Type): ...

    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QGraphicsSceneHelpEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type:typing.Optional[PySide2.QtCore.QEvent.Type]=...): ...

    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setScenePos(self, pos:PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos:PySide2.QtCore.QPoint): ...


class QGraphicsSceneHoverEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type:typing.Optional[PySide2.QtCore.QEvent.Type]=...): ...

    def lastPos(self) -> PySide2.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide2.QtCore.QPoint: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setLastPos(self, pos:PySide2.QtCore.QPointF): ...
    def setLastScenePos(self, pos:PySide2.QtCore.QPointF): ...
    def setLastScreenPos(self, pos:PySide2.QtCore.QPoint): ...
    def setModifiers(self, modifiers:PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setPos(self, pos:PySide2.QtCore.QPointF): ...
    def setScenePos(self, pos:PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos:PySide2.QtCore.QPoint): ...


class QGraphicsSceneMouseEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type:typing.Optional[PySide2.QtCore.QEvent.Type]=...): ...

    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def buttonDownPos(self, button:PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPointF: ...
    def buttonDownScenePos(self, button:PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPointF: ...
    def buttonDownScreenPos(self, button:PySide2.QtCore.Qt.MouseButton) -> PySide2.QtCore.QPoint: ...
    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def flags(self) -> PySide2.QtCore.Qt.MouseEventFlags: ...
    def lastPos(self) -> PySide2.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide2.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide2.QtCore.QPoint: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButton(self, button:PySide2.QtCore.Qt.MouseButton): ...
    def setButtonDownPos(self, button:PySide2.QtCore.Qt.MouseButton, pos:PySide2.QtCore.QPointF): ...
    def setButtonDownScenePos(self, button:PySide2.QtCore.Qt.MouseButton, pos:PySide2.QtCore.QPointF): ...
    def setButtonDownScreenPos(self, button:PySide2.QtCore.Qt.MouseButton, pos:PySide2.QtCore.QPoint): ...
    def setButtons(self, buttons:PySide2.QtCore.Qt.MouseButtons): ...
    def setFlags(self, arg__1:PySide2.QtCore.Qt.MouseEventFlags): ...
    def setLastPos(self, pos:PySide2.QtCore.QPointF): ...
    def setLastScenePos(self, pos:PySide2.QtCore.QPointF): ...
    def setLastScreenPos(self, pos:PySide2.QtCore.QPoint): ...
    def setModifiers(self, modifiers:PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setPos(self, pos:PySide2.QtCore.QPointF): ...
    def setScenePos(self, pos:PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos:PySide2.QtCore.QPoint): ...
    def setSource(self, source:PySide2.QtCore.Qt.MouseEventSource): ...
    def source(self) -> PySide2.QtCore.Qt.MouseEventSource: ...


class QGraphicsSceneMoveEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self): ...

    def newPos(self) -> PySide2.QtCore.QPointF: ...
    def oldPos(self) -> PySide2.QtCore.QPointF: ...
    def setNewPos(self, pos:PySide2.QtCore.QPointF): ...
    def setOldPos(self, pos:PySide2.QtCore.QPointF): ...


class QGraphicsSceneResizeEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self): ...

    def newSize(self) -> PySide2.QtCore.QSizeF: ...
    def oldSize(self) -> PySide2.QtCore.QSizeF: ...
    def setNewSize(self, size:PySide2.QtCore.QSizeF): ...
    def setOldSize(self, size:PySide2.QtCore.QSizeF): ...


class QGraphicsSceneWheelEvent(PySide2.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type:typing.Optional[PySide2.QtCore.QEvent.Type]=...): ...

    def buttons(self) -> PySide2.QtCore.Qt.MouseButtons: ...
    def delta(self) -> int: ...
    def modifiers(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def pos(self) -> PySide2.QtCore.QPointF: ...
    def scenePos(self) -> PySide2.QtCore.QPointF: ...
    def screenPos(self) -> PySide2.QtCore.QPoint: ...
    def setButtons(self, buttons:PySide2.QtCore.Qt.MouseButtons): ...
    def setDelta(self, delta:int): ...
    def setModifiers(self, modifiers:PySide2.QtCore.Qt.KeyboardModifiers): ...
    def setOrientation(self, orientation:PySide2.QtCore.Qt.Orientation): ...
    def setPos(self, pos:PySide2.QtCore.QPointF): ...
    def setScenePos(self, pos:PySide2.QtCore.QPointF): ...
    def setScreenPos(self, pos:PySide2.QtCore.QPoint): ...


class QGraphicsSimpleTextItem(PySide2.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point:PySide2.QtCore.QPointF) -> bool: ...
    def extension(self, variant:typing.Any) -> typing.Any: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:PySide2.QtWidgets.QWidget): ...
    def setFont(self, font:PySide2.QtGui.QFont): ...
    def setText(self, text:str): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def text(self) -> str: ...
    def type(self) -> int: ...


class QGraphicsTextItem(PySide2.QtWidgets.QGraphicsObject):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=...): ...

    def adjustSize(self): ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def contains(self, point:PySide2.QtCore.QPointF) -> bool: ...
    def contextMenuEvent(self, event:PySide2.QtWidgets.QGraphicsSceneContextMenuEvent): ...
    def defaultTextColor(self) -> PySide2.QtGui.QColor: ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def dragEnterEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragLeaveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dragMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def dropEvent(self, event:PySide2.QtWidgets.QGraphicsSceneDragDropEvent): ...
    def extension(self, variant:typing.Any) -> typing.Any: ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def hoverEnterEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverLeaveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def inputMethodEvent(self, event:PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodQuery(self, query:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def isObscuredBy(self, item:PySide2.QtWidgets.QGraphicsItem) -> bool: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def mouseDoubleClickEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mousePressEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def mouseReleaseEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMouseEvent): ...
    def opaqueArea(self) -> PySide2.QtGui.QPainterPath: ...
    def openExternalLinks(self) -> bool: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:PySide2.QtWidgets.QWidget): ...
    def sceneEvent(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def setDefaultTextColor(self, c:PySide2.QtGui.QColor): ...
    def setDocument(self, document:PySide2.QtGui.QTextDocument): ...
    def setFont(self, font:PySide2.QtGui.QFont): ...
    def setHtml(self, html:str): ...
    def setOpenExternalLinks(self, open:bool): ...
    def setPlainText(self, text:str): ...
    def setTabChangesFocus(self, b:bool): ...
    def setTextCursor(self, cursor:PySide2.QtGui.QTextCursor): ...
    def setTextInteractionFlags(self, flags:PySide2.QtCore.Qt.TextInteractionFlags): ...
    def setTextWidth(self, width:float): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def tabChangesFocus(self) -> bool: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def textWidth(self) -> float: ...
    def toHtml(self) -> str: ...
    def toPlainText(self) -> str: ...
    def type(self) -> int: ...


class QGraphicsTransform(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def applyTo(self, matrix:PySide2.QtGui.QMatrix4x4): ...
    def update(self): ...


class QGraphicsView(PySide2.QtWidgets.QAbstractScrollArea):
    CacheNone                : QGraphicsView = ... # 0x0
    FullViewportUpdate       : QGraphicsView = ... # 0x0
    NoAnchor                 : QGraphicsView = ... # 0x0
    NoDrag                   : QGraphicsView = ... # 0x0
    AnchorViewCenter         : QGraphicsView = ... # 0x1
    CacheBackground          : QGraphicsView = ... # 0x1
    DontClipPainter          : QGraphicsView = ... # 0x1
    MinimalViewportUpdate    : QGraphicsView = ... # 0x1
    ScrollHandDrag           : QGraphicsView = ... # 0x1
    AnchorUnderMouse         : QGraphicsView = ... # 0x2
    DontSavePainterState     : QGraphicsView = ... # 0x2
    RubberBandDrag           : QGraphicsView = ... # 0x2
    SmartViewportUpdate      : QGraphicsView = ... # 0x2
    NoViewportUpdate         : QGraphicsView = ... # 0x3
    BoundingRectViewportUpdate: QGraphicsView = ... # 0x4
    DontAdjustForAntialiasing: QGraphicsView = ... # 0x4
    IndirectPainting         : QGraphicsView = ... # 0x8

    class CacheMode(object): ...

    class CacheModeFlag(object):
        CacheNone                : QGraphicsView.CacheModeFlag = ... # 0x0
        CacheBackground          : QGraphicsView.CacheModeFlag = ... # 0x1

    class DragMode(object):
        NoDrag                   : QGraphicsView.DragMode = ... # 0x0
        ScrollHandDrag           : QGraphicsView.DragMode = ... # 0x1
        RubberBandDrag           : QGraphicsView.DragMode = ... # 0x2

    class OptimizationFlag(object):
        DontClipPainter          : QGraphicsView.OptimizationFlag = ... # 0x1
        DontSavePainterState     : QGraphicsView.OptimizationFlag = ... # 0x2
        DontAdjustForAntialiasing: QGraphicsView.OptimizationFlag = ... # 0x4
        IndirectPainting         : QGraphicsView.OptimizationFlag = ... # 0x8

    class OptimizationFlags(object): ...

    class ViewportAnchor(object):
        NoAnchor                 : QGraphicsView.ViewportAnchor = ... # 0x0
        AnchorViewCenter         : QGraphicsView.ViewportAnchor = ... # 0x1
        AnchorUnderMouse         : QGraphicsView.ViewportAnchor = ... # 0x2

    class ViewportUpdateMode(object):
        FullViewportUpdate       : QGraphicsView.ViewportUpdateMode = ... # 0x0
        MinimalViewportUpdate    : QGraphicsView.ViewportUpdateMode = ... # 0x1
        SmartViewportUpdate      : QGraphicsView.ViewportUpdateMode = ... # 0x2
        NoViewportUpdate         : QGraphicsView.ViewportUpdateMode = ... # 0x3
        BoundingRectViewportUpdate: QGraphicsView.ViewportUpdateMode = ... # 0x4

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, scene:PySide2.QtWidgets.QGraphicsScene, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def backgroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def cacheMode(self) -> PySide2.QtWidgets.QGraphicsView.CacheMode: ...
    @typing.overload
    def centerOn(self, item:PySide2.QtWidgets.QGraphicsItem): ...
    @typing.overload
    def centerOn(self, pos:PySide2.QtCore.QPointF): ...
    @typing.overload
    def centerOn(self, x:float, y:float): ...
    def contextMenuEvent(self, event:PySide2.QtGui.QContextMenuEvent): ...
    def dragEnterEvent(self, event:PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, event:PySide2.QtGui.QDragLeaveEvent): ...
    def dragMode(self) -> PySide2.QtWidgets.QGraphicsView.DragMode: ...
    def dragMoveEvent(self, event:PySide2.QtGui.QDragMoveEvent): ...
    def drawBackground(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRectF): ...
    def drawForeground(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRectF): ...
    def drawItems(self, painter:PySide2.QtGui.QPainter, numItems:int, items:typing.Sequence, options:typing.Sequence): ...
    def dropEvent(self, event:PySide2.QtGui.QDropEvent): ...
    @typing.overload
    def ensureVisible(self, item:PySide2.QtWidgets.QGraphicsItem, xmargin:int=..., ymargin:int=...): ...
    @typing.overload
    def ensureVisible(self, rect:PySide2.QtCore.QRectF, xmargin:int=..., ymargin:int=...): ...
    @typing.overload
    def ensureVisible(self, x:float, y:float, w:float, h:float, xmargin:int=..., ymargin:int=...): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    def fitInView(self, item:PySide2.QtWidgets.QGraphicsItem, aspectRadioMode:PySide2.QtCore.Qt.AspectRatioMode=...): ...
    @typing.overload
    def fitInView(self, rect:PySide2.QtCore.QRectF, aspectRadioMode:PySide2.QtCore.Qt.AspectRatioMode=...): ...
    @typing.overload
    def fitInView(self, x:float, y:float, w:float, h:float, aspectRadioMode:PySide2.QtCore.Qt.AspectRatioMode=...): ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def focusOutEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def foregroundBrush(self) -> PySide2.QtGui.QBrush: ...
    def inputMethodEvent(self, event:PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodQuery(self, query:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def invalidateScene(self, rect:PySide2.QtCore.QRectF=..., layers:PySide2.QtWidgets.QGraphicsScene.SceneLayers=...): ...
    def isInteractive(self) -> bool: ...
    def isTransformed(self) -> bool: ...
    @typing.overload
    def itemAt(self, pos:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def itemAt(self, x:int, y:int) -> PySide2.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def items(self) -> typing.List: ...
    @typing.overload
    def items(self, path:PySide2.QtGui.QPainterPath, mode:PySide2.QtCore.Qt.ItemSelectionMode=...) -> typing.List: ...
    @typing.overload
    def items(self, polygon:PySide2.QtGui.QPolygon, mode:PySide2.QtCore.Qt.ItemSelectionMode=...) -> typing.List: ...
    @typing.overload
    def items(self, pos:PySide2.QtCore.QPoint) -> typing.List: ...
    @typing.overload
    def items(self, rect:PySide2.QtCore.QRect, mode:PySide2.QtCore.Qt.ItemSelectionMode=...) -> typing.List: ...
    @typing.overload
    def items(self, x:int, y:int) -> typing.List: ...
    @typing.overload
    def items(self, x:int, y:int, w:int, h:int, mode:PySide2.QtCore.Qt.ItemSelectionMode=...) -> typing.List: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    @typing.overload
    def mapFromScene(self, path:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromScene(self, point:PySide2.QtCore.QPointF) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def mapFromScene(self, polygon:PySide2.QtGui.QPolygonF) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def mapFromScene(self, rect:PySide2.QtCore.QRectF) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def mapFromScene(self, x:float, y:float) -> PySide2.QtCore.QPoint: ...
    @typing.overload
    def mapFromScene(self, x:float, y:float, w:float, h:float) -> PySide2.QtGui.QPolygon: ...
    @typing.overload
    def mapToScene(self, path:PySide2.QtGui.QPainterPath) -> PySide2.QtGui.QPainterPath: ...
    @typing.overload
    def mapToScene(self, point:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, polygon:PySide2.QtGui.QPolygon) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, rect:PySide2.QtCore.QRect) -> PySide2.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, x:int, y:int) -> PySide2.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, x:int, y:int, w:int, h:int) -> PySide2.QtGui.QPolygonF: ...
    def matrix(self) -> PySide2.QtGui.QMatrix: ...
    def mouseDoubleClickEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def optimizationFlags(self) -> PySide2.QtWidgets.QGraphicsView.OptimizationFlags: ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent): ...
    @typing.overload
    def render(self, painter:PySide2.QtGui.QPainter, target:PySide2.QtCore.QRectF=..., source:PySide2.QtCore.QRect=..., aspectRatioMode:PySide2.QtCore.Qt.AspectRatioMode=...): ...
    @typing.overload
    def render(self, target:PySide2.QtGui.QPaintDevice, targetOffset:PySide2.QtCore.QPoint=..., sourceRegion:PySide2.QtGui.QRegion=..., renderFlags:PySide2.QtWidgets.QWidget.RenderFlags=...): ...
    def renderHints(self) -> PySide2.QtGui.QPainter.RenderHints: ...
    def resetCachedContent(self): ...
    def resetMatrix(self): ...
    def resetTransform(self): ...
    def resizeAnchor(self) -> PySide2.QtWidgets.QGraphicsView.ViewportAnchor: ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent): ...
    def rotate(self, angle:float): ...
    def rubberBandRect(self) -> PySide2.QtCore.QRect: ...
    def rubberBandSelectionMode(self) -> PySide2.QtCore.Qt.ItemSelectionMode: ...
    def scale(self, sx:float, sy:float): ...
    def scene(self) -> PySide2.QtWidgets.QGraphicsScene: ...
    def sceneRect(self) -> PySide2.QtCore.QRectF: ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def setAlignment(self, alignment:PySide2.QtCore.Qt.Alignment): ...
    def setBackgroundBrush(self, brush:PySide2.QtGui.QBrush): ...
    def setCacheMode(self, mode:PySide2.QtWidgets.QGraphicsView.CacheMode): ...
    def setDragMode(self, mode:PySide2.QtWidgets.QGraphicsView.DragMode): ...
    def setForegroundBrush(self, brush:PySide2.QtGui.QBrush): ...
    def setInteractive(self, allowed:bool): ...
    def setMatrix(self, matrix:PySide2.QtGui.QMatrix, combine:bool=...): ...
    def setOptimizationFlag(self, flag:PySide2.QtWidgets.QGraphicsView.OptimizationFlag, enabled:bool=...): ...
    def setOptimizationFlags(self, flags:PySide2.QtWidgets.QGraphicsView.OptimizationFlags): ...
    def setRenderHint(self, hint:PySide2.QtGui.QPainter.RenderHint, enabled:bool=...): ...
    def setRenderHints(self, hints:PySide2.QtGui.QPainter.RenderHints): ...
    def setResizeAnchor(self, anchor:PySide2.QtWidgets.QGraphicsView.ViewportAnchor): ...
    def setRubberBandSelectionMode(self, mode:PySide2.QtCore.Qt.ItemSelectionMode): ...
    def setScene(self, scene:PySide2.QtWidgets.QGraphicsScene): ...
    @typing.overload
    def setSceneRect(self, rect:PySide2.QtCore.QRectF): ...
    @typing.overload
    def setSceneRect(self, x:float, y:float, w:float, h:float): ...
    def setTransform(self, matrix:PySide2.QtGui.QTransform, combine:bool=...): ...
    def setTransformationAnchor(self, anchor:PySide2.QtWidgets.QGraphicsView.ViewportAnchor): ...
    def setViewportUpdateMode(self, mode:PySide2.QtWidgets.QGraphicsView.ViewportUpdateMode): ...
    def setupViewport(self, widget:PySide2.QtWidgets.QWidget): ...
    def shear(self, sh:float, sv:float): ...
    def showEvent(self, event:PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def transform(self) -> PySide2.QtGui.QTransform: ...
    def transformationAnchor(self) -> PySide2.QtWidgets.QGraphicsView.ViewportAnchor: ...
    def translate(self, dx:float, dy:float): ...
    def updateScene(self, rects:typing.Sequence): ...
    def updateSceneRect(self, rect:PySide2.QtCore.QRectF): ...
    def viewportEvent(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def viewportTransform(self) -> PySide2.QtGui.QTransform: ...
    def viewportUpdateMode(self) -> PySide2.QtWidgets.QGraphicsView.ViewportUpdateMode: ...
    def wheelEvent(self, event:PySide2.QtGui.QWheelEvent): ...


class QGraphicsWidget(PySide2.QtWidgets.QGraphicsObject, PySide2.QtWidgets.QGraphicsLayoutItem):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QGraphicsItem]=..., wFlags:PySide2.QtCore.Qt.WindowFlags=...): ...

    def actions(self) -> typing.List: ...
    def addAction(self, action:PySide2.QtWidgets.QAction): ...
    def addActions(self, actions:typing.Sequence): ...
    def adjustSize(self): ...
    def autoFillBackground(self) -> bool: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    def close(self) -> bool: ...
    def closeEvent(self, event:PySide2.QtGui.QCloseEvent): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def focusOutEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusPolicy(self) -> PySide2.QtCore.Qt.FocusPolicy: ...
    def focusWidget(self) -> PySide2.QtWidgets.QGraphicsWidget: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def getContentsMargins(self) -> typing.Tuple: ...
    def getWindowFrameMargins(self) -> typing.Tuple: ...
    def grabKeyboardEvent(self, event:PySide2.QtCore.QEvent): ...
    def grabMouseEvent(self, event:PySide2.QtCore.QEvent): ...
    def grabShortcut(self, sequence:PySide2.QtGui.QKeySequence, context:PySide2.QtCore.Qt.ShortcutContext=...) -> int: ...
    def hideEvent(self, event:PySide2.QtGui.QHideEvent): ...
    def hoverLeaveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def hoverMoveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneHoverEvent): ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOption): ...
    def insertAction(self, before:PySide2.QtWidgets.QAction, action:PySide2.QtWidgets.QAction): ...
    def insertActions(self, before:PySide2.QtWidgets.QAction, actions:typing.Sequence): ...
    def isActiveWindow(self) -> bool: ...
    def itemChange(self, change:PySide2.QtWidgets.QGraphicsItem.GraphicsItemChange, value:typing.Any) -> typing.Any: ...
    def layout(self) -> PySide2.QtWidgets.QGraphicsLayout: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def moveEvent(self, event:PySide2.QtWidgets.QGraphicsSceneMoveEvent): ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def paintWindowFrame(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionGraphicsItem, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def polishEvent(self): ...
    def propertyChange(self, propertyName:str, value:typing.Any) -> typing.Any: ...
    def rect(self) -> PySide2.QtCore.QRectF: ...
    def releaseShortcut(self, id:int): ...
    def removeAction(self, action:PySide2.QtWidgets.QAction): ...
    @typing.overload
    def resize(self, size:PySide2.QtCore.QSizeF): ...
    @typing.overload
    def resize(self, w:float, h:float): ...
    def resizeEvent(self, event:PySide2.QtWidgets.QGraphicsSceneResizeEvent): ...
    def sceneEvent(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def setAttribute(self, attribute:PySide2.QtCore.Qt.WidgetAttribute, on:bool=...): ...
    def setAutoFillBackground(self, enabled:bool): ...
    @typing.overload
    def setContentsMargins(self, left:float, top:float, right:float, bottom:float): ...
    @typing.overload
    def setContentsMargins(self, margins:PySide2.QtCore.QMarginsF): ...
    def setFocusPolicy(self, policy:PySide2.QtCore.Qt.FocusPolicy): ...
    def setFont(self, font:PySide2.QtGui.QFont): ...
    @typing.overload
    def setGeometry(self, rect:PySide2.QtCore.QRectF): ...
    @typing.overload
    def setGeometry(self, x:float, y:float, w:float, h:float): ...
    def setLayout(self, layout:PySide2.QtWidgets.QGraphicsLayout): ...
    def setLayoutDirection(self, direction:PySide2.QtCore.Qt.LayoutDirection): ...
    def setPalette(self, palette:PySide2.QtGui.QPalette): ...
    def setShortcutAutoRepeat(self, id:int, enabled:bool=...): ...
    def setShortcutEnabled(self, id:int, enabled:bool=...): ...
    def setStyle(self, style:PySide2.QtWidgets.QStyle): ...
    @staticmethod
    def setTabOrder(first:PySide2.QtWidgets.QGraphicsWidget, second:PySide2.QtWidgets.QGraphicsWidget): ...
    def setWindowFlags(self, wFlags:PySide2.QtCore.Qt.WindowFlags): ...
    @typing.overload
    def setWindowFrameMargins(self, left:float, top:float, right:float, bottom:float): ...
    @typing.overload
    def setWindowFrameMargins(self, margins:PySide2.QtCore.QMarginsF): ...
    def setWindowTitle(self, title:str): ...
    def shape(self) -> PySide2.QtGui.QPainterPath: ...
    def showEvent(self, event:PySide2.QtGui.QShowEvent): ...
    def size(self) -> PySide2.QtCore.QSizeF: ...
    def sizeHint(self, which:PySide2.QtCore.Qt.SizeHint, constraint:PySide2.QtCore.QSizeF=...) -> PySide2.QtCore.QSizeF: ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...
    def testAttribute(self, attribute:PySide2.QtCore.Qt.WidgetAttribute) -> bool: ...
    def type(self) -> int: ...
    def ungrabKeyboardEvent(self, event:PySide2.QtCore.QEvent): ...
    def ungrabMouseEvent(self, event:PySide2.QtCore.QEvent): ...
    def unsetLayoutDirection(self): ...
    def unsetWindowFrameMargins(self): ...
    def updateGeometry(self): ...
    def windowFlags(self) -> PySide2.QtCore.Qt.WindowFlags: ...
    def windowFrameEvent(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def windowFrameGeometry(self) -> PySide2.QtCore.QRectF: ...
    def windowFrameRect(self) -> PySide2.QtCore.QRectF: ...
    def windowFrameSectionAt(self, pos:PySide2.QtCore.QPointF) -> PySide2.QtCore.Qt.WindowFrameSection: ...
    def windowTitle(self) -> str: ...
    def windowType(self) -> PySide2.QtCore.Qt.WindowType: ...


class QGridLayout(PySide2.QtWidgets.QLayout):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QWidget): ...

    @typing.overload
    def addItem(self, arg__1:PySide2.QtWidgets.QLayoutItem): ...
    @typing.overload
    def addItem(self, item:PySide2.QtWidgets.QLayoutItem, row:int, column:int, rowSpan:int=..., columnSpan:int=..., alignment:PySide2.QtCore.Qt.Alignment=...): ...
    @typing.overload
    def addLayout(self, arg__1:PySide2.QtWidgets.QLayout, row:int, column:int, alignment:PySide2.QtCore.Qt.Alignment=...): ...
    @typing.overload
    def addLayout(self, arg__1:PySide2.QtWidgets.QLayout, row:int, column:int, rowSpan:int, columnSpan:int, alignment:PySide2.QtCore.Qt.Alignment=...): ...
    @typing.overload
    def addWidget(self, arg__1:PySide2.QtWidgets.QWidget, row:int, column:int, alignment:PySide2.QtCore.Qt.Alignment=...): ...
    @typing.overload
    def addWidget(self, arg__1:PySide2.QtWidgets.QWidget, row:int, column:int, rowSpan:int, columnSpan:int, alignment:PySide2.QtCore.Qt.Alignment=...): ...
    @typing.overload
    def addWidget(self, w:PySide2.QtWidgets.QWidget): ...
    def cellRect(self, row:int, column:int) -> PySide2.QtCore.QRect: ...
    def columnCount(self) -> int: ...
    def columnMinimumWidth(self, column:int) -> int: ...
    def columnStretch(self, column:int) -> int: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def getItemPosition(self, idx:int) -> typing.Tuple: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1:int) -> int: ...
    def horizontalSpacing(self) -> int: ...
    def invalidate(self): ...
    def itemAt(self, index:int) -> PySide2.QtWidgets.QLayoutItem: ...
    def itemAtPosition(self, row:int, column:int) -> PySide2.QtWidgets.QLayoutItem: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1:int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def originCorner(self) -> PySide2.QtCore.Qt.Corner: ...
    def rowCount(self) -> int: ...
    def rowMinimumHeight(self, row:int) -> int: ...
    def rowStretch(self, row:int) -> int: ...
    def setColumnMinimumWidth(self, column:int, minSize:int): ...
    def setColumnStretch(self, column:int, stretch:int): ...
    def setDefaultPositioning(self, n:int, orient:PySide2.QtCore.Qt.Orientation): ...
    def setGeometry(self, arg__1:PySide2.QtCore.QRect): ...
    def setHorizontalSpacing(self, spacing:int): ...
    def setOriginCorner(self, arg__1:PySide2.QtCore.Qt.Corner): ...
    def setRowMinimumHeight(self, row:int, minSize:int): ...
    def setRowStretch(self, row:int, stretch:int): ...
    def setSpacing(self, spacing:int): ...
    def setVerticalSpacing(self, spacing:int): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def takeAt(self, index:int) -> PySide2.QtWidgets.QLayoutItem: ...
    def verticalSpacing(self) -> int: ...


class QGroupBox(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, title:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    def childEvent(self, event:PySide2.QtCore.QChildEvent): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionGroupBox): ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isFlat(self) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent): ...
    def setAlignment(self, alignment:int): ...
    def setCheckable(self, checkable:bool): ...
    def setChecked(self, checked:bool): ...
    def setFlat(self, flat:bool): ...
    def setTitle(self, title:str): ...
    def title(self) -> str: ...


class QHBoxLayout(PySide2.QtWidgets.QBoxLayout):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QWidget): ...


class QHeaderView(PySide2.QtWidgets.QAbstractItemView):
    Interactive              : QHeaderView = ... # 0x0
    Stretch                  : QHeaderView = ... # 0x1
    Custom                   : QHeaderView = ... # 0x2
    Fixed                    : QHeaderView = ... # 0x2
    ResizeToContents         : QHeaderView = ... # 0x3

    class ResizeMode(object):
        Interactive              : QHeaderView.ResizeMode = ... # 0x0
        Stretch                  : QHeaderView.ResizeMode = ... # 0x1
        Custom                   : QHeaderView.ResizeMode = ... # 0x2
        Fixed                    : QHeaderView.ResizeMode = ... # 0x2
        ResizeToContents         : QHeaderView.ResizeMode = ... # 0x3

    def __init__(self, orientation:PySide2.QtCore.Qt.Orientation, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def cascadingSectionResizes(self) -> bool: ...
    def count(self) -> int: ...
    def currentChanged(self, current:PySide2.QtCore.QModelIndex, old:PySide2.QtCore.QModelIndex): ...
    def dataChanged(self, topLeft:PySide2.QtCore.QModelIndex, bottomRight:PySide2.QtCore.QModelIndex, roles:typing.List=...): ...
    def defaultAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def defaultSectionSize(self) -> int: ...
    def doItemsLayout(self): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def headerDataChanged(self, orientation:PySide2.QtCore.Qt.Orientation, logicalFirst:int, logicalLast:int): ...
    def hiddenSectionCount(self) -> int: ...
    def hideSection(self, logicalIndex:int): ...
    def highlightSections(self) -> bool: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, p:PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionFrame): ...
    @typing.overload
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionHeader): ...
    def initialize(self): ...
    @typing.overload
    def initializeSections(self): ...
    @typing.overload
    def initializeSections(self, start:int, end:int): ...
    def isFirstSectionMovable(self) -> bool: ...
    def isIndexHidden(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def isSectionHidden(self, logicalIndex:int) -> bool: ...
    def isSortIndicatorShown(self) -> bool: ...
    def length(self) -> int: ...
    def logicalIndex(self, visualIndex:int) -> int: ...
    @typing.overload
    def logicalIndexAt(self, pos:PySide2.QtCore.QPoint) -> int: ...
    @typing.overload
    def logicalIndexAt(self, position:int) -> int: ...
    @typing.overload
    def logicalIndexAt(self, x:int, y:int) -> int: ...
    def maximumSectionSize(self) -> int: ...
    def minimumSectionSize(self) -> int: ...
    def mouseDoubleClickEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, arg__1:PySide2.QtWidgets.QAbstractItemView.CursorAction, arg__2:PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def moveSection(self, from_:int, to:int): ...
    def offset(self) -> int: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, e:PySide2.QtGui.QPaintEvent): ...
    def paintSection(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRect, logicalIndex:int): ...
    def reset(self): ...
    def resetDefaultSectionSize(self): ...
    def resizeContentsPrecision(self) -> int: ...
    def resizeSection(self, logicalIndex:int, size:int): ...
    @typing.overload
    def resizeSections(self): ...
    @typing.overload
    def resizeSections(self, mode:PySide2.QtWidgets.QHeaderView.ResizeMode): ...
    def restoreState(self, state:PySide2.QtCore.QByteArray) -> bool: ...
    def rowsInserted(self, parent:PySide2.QtCore.QModelIndex, start:int, end:int): ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def scrollTo(self, index:PySide2.QtCore.QModelIndex, hint:PySide2.QtWidgets.QAbstractItemView.ScrollHint): ...
    def sectionPosition(self, logicalIndex:int) -> int: ...
    def sectionResizeMode(self, logicalIndex:int) -> PySide2.QtWidgets.QHeaderView.ResizeMode: ...
    def sectionSize(self, logicalIndex:int) -> int: ...
    def sectionSizeFromContents(self, logicalIndex:int) -> PySide2.QtCore.QSize: ...
    def sectionSizeHint(self, logicalIndex:int) -> int: ...
    def sectionViewportPosition(self, logicalIndex:int) -> int: ...
    def sectionsAboutToBeRemoved(self, parent:PySide2.QtCore.QModelIndex, logicalFirst:int, logicalLast:int): ...
    def sectionsClickable(self) -> bool: ...
    def sectionsHidden(self) -> bool: ...
    def sectionsInserted(self, parent:PySide2.QtCore.QModelIndex, logicalFirst:int, logicalLast:int): ...
    def sectionsMovable(self) -> bool: ...
    def sectionsMoved(self) -> bool: ...
    def setCascadingSectionResizes(self, enable:bool): ...
    def setDefaultAlignment(self, alignment:PySide2.QtCore.Qt.Alignment): ...
    def setDefaultSectionSize(self, size:int): ...
    def setFirstSectionMovable(self, movable:bool): ...
    def setHighlightSections(self, highlight:bool): ...
    def setMaximumSectionSize(self, size:int): ...
    def setMinimumSectionSize(self, size:int): ...
    def setModel(self, model:PySide2.QtCore.QAbstractItemModel): ...
    def setOffset(self, offset:int): ...
    def setOffsetToLastSection(self): ...
    def setOffsetToSectionPosition(self, visualIndex:int): ...
    def setResizeContentsPrecision(self, precision:int): ...
    def setSectionHidden(self, logicalIndex:int, hide:bool): ...
    @typing.overload
    def setSectionResizeMode(self, logicalIndex:int, mode:PySide2.QtWidgets.QHeaderView.ResizeMode): ...
    @typing.overload
    def setSectionResizeMode(self, mode:PySide2.QtWidgets.QHeaderView.ResizeMode): ...
    def setSectionsClickable(self, clickable:bool): ...
    def setSectionsMovable(self, movable:bool): ...
    def setSelection(self, rect:PySide2.QtCore.QRect, flags:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSortIndicator(self, logicalIndex:int, order:PySide2.QtCore.Qt.SortOrder): ...
    def setSortIndicatorShown(self, show:bool): ...
    def setStretchLastSection(self, stretch:bool): ...
    def setVisible(self, v:bool): ...
    def showSection(self, logicalIndex:int): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sortIndicatorOrder(self) -> PySide2.QtCore.Qt.SortOrder: ...
    def sortIndicatorSection(self) -> int: ...
    def stretchLastSection(self) -> bool: ...
    def stretchSectionCount(self) -> int: ...
    def swapSections(self, first:int, second:int): ...
    def updateGeometries(self): ...
    def updateSection(self, logicalIndex:int): ...
    def verticalOffset(self) -> int: ...
    def viewportEvent(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def visualIndex(self, logicalIndex:int) -> int: ...
    def visualIndexAt(self, position:int) -> int: ...
    def visualRect(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection:PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...


class QInputDialog(PySide2.QtWidgets.QDialog):
    TextInput                : QInputDialog = ... # 0x0
    IntInput                 : QInputDialog = ... # 0x1
    NoButtons                : QInputDialog = ... # 0x1
    DoubleInput              : QInputDialog = ... # 0x2
    UseListViewForComboBoxItems: QInputDialog = ... # 0x2
    UsePlainTextEditForTextInput: QInputDialog = ... # 0x4

    class InputDialogOption(object):
        NoButtons                : QInputDialog.InputDialogOption = ... # 0x1
        UseListViewForComboBoxItems: QInputDialog.InputDialogOption = ... # 0x2
        UsePlainTextEditForTextInput: QInputDialog.InputDialogOption = ... # 0x4

    class InputMode(object):
        TextInput                : QInputDialog.InputMode = ... # 0x0
        IntInput                 : QInputDialog.InputMode = ... # 0x1
        DoubleInput              : QInputDialog.InputMode = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., flags:PySide2.QtCore.Qt.WindowFlags=...): ...

    def cancelButtonText(self) -> str: ...
    def comboBoxItems(self) -> typing.List: ...
    def done(self, result:int): ...
    def doubleDecimals(self) -> int: ...
    def doubleMaximum(self) -> float: ...
    def doubleMinimum(self) -> float: ...
    def doubleStep(self) -> float: ...
    def doubleValue(self) -> float: ...
    @typing.overload
    @staticmethod
    def getDouble(parent:PySide2.QtWidgets.QWidget, title:str, label:str, value:float, minValue:float, maxValue:float, decimals:int, flags:PySide2.QtCore.Qt.WindowFlags, step:float) -> typing.Tuple: ...
    @typing.overload
    @staticmethod
    def getDouble(parent:PySide2.QtWidgets.QWidget, title:str, label:str, value:float, minValue:float=..., maxValue:float=..., decimals:int=..., flags:PySide2.QtCore.Qt.WindowFlags=...) -> typing.Tuple: ...
    @staticmethod
    def getInt(parent:PySide2.QtWidgets.QWidget, title:str, label:str, value:int, minValue:int=..., maxValue:int=..., step:int=..., flags:PySide2.QtCore.Qt.WindowFlags=...) -> typing.Tuple: ...
    @staticmethod
    def getItem(parent:PySide2.QtWidgets.QWidget, title:str, label:str, items:typing.Sequence, current:int, editable:bool=..., flags:PySide2.QtCore.Qt.WindowFlags=..., inputMethodHints:PySide2.QtCore.Qt.InputMethodHints=...) -> typing.Tuple: ...
    @staticmethod
    def getMultiLineText(parent:PySide2.QtWidgets.QWidget, title:str, label:str, text:str, flags:PySide2.QtCore.Qt.WindowFlags=..., inputMethodHints:PySide2.QtCore.Qt.InputMethodHints=...) -> typing.Tuple: ...
    @staticmethod
    def getText(parent:PySide2.QtWidgets.QWidget, title:str, label:str, echo:PySide2.QtWidgets.QLineEdit.EchoMode, text:str=..., flags:PySide2.QtCore.Qt.WindowFlags=..., inputMethodHints:PySide2.QtCore.Qt.InputMethodHints=...) -> typing.Tuple: ...
    def inputMode(self) -> PySide2.QtWidgets.QInputDialog.InputMode: ...
    def intMaximum(self) -> int: ...
    def intMinimum(self) -> int: ...
    def intStep(self) -> int: ...
    def intValue(self) -> int: ...
    def isComboBoxEditable(self) -> bool: ...
    def labelText(self) -> str: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def okButtonText(self) -> str: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver:PySide2.QtCore.QObject, member:bytes): ...
    def setCancelButtonText(self, text:str): ...
    def setComboBoxEditable(self, editable:bool): ...
    def setComboBoxItems(self, items:typing.Sequence): ...
    def setDoubleDecimals(self, decimals:int): ...
    def setDoubleMaximum(self, max:float): ...
    def setDoubleMinimum(self, min:float): ...
    def setDoubleRange(self, min:float, max:float): ...
    def setDoubleStep(self, step:float): ...
    def setDoubleValue(self, value:float): ...
    def setInputMode(self, mode:PySide2.QtWidgets.QInputDialog.InputMode): ...
    def setIntMaximum(self, max:int): ...
    def setIntMinimum(self, min:int): ...
    def setIntRange(self, min:int, max:int): ...
    def setIntStep(self, step:int): ...
    def setIntValue(self, value:int): ...
    def setLabelText(self, text:str): ...
    def setOkButtonText(self, text:str): ...
    def setOption(self, option:PySide2.QtWidgets.QInputDialog.InputDialogOption, on:bool=...): ...
    def setTextEchoMode(self, mode:PySide2.QtWidgets.QLineEdit.EchoMode): ...
    def setTextValue(self, text:str): ...
    def setVisible(self, visible:bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def testOption(self, option:PySide2.QtWidgets.QInputDialog.InputDialogOption) -> bool: ...
    def textEchoMode(self) -> PySide2.QtWidgets.QLineEdit.EchoMode: ...
    def textValue(self) -> str: ...


class QItemDelegate(PySide2.QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def createEditor(self, parent:PySide2.QtWidgets.QWidget, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def decoration(self, option:PySide2.QtWidgets.QStyleOptionViewItem, variant:typing.Any) -> PySide2.QtGui.QPixmap: ...
    def doCheck(self, option:PySide2.QtWidgets.QStyleOptionViewItem, bounding:PySide2.QtCore.QRect, variant:typing.Any) -> PySide2.QtCore.QRect: ...
    def drawBackground(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex): ...
    def drawCheck(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionViewItem, rect:PySide2.QtCore.QRect, state:PySide2.QtCore.Qt.CheckState): ...
    def drawDecoration(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionViewItem, rect:PySide2.QtCore.QRect, pixmap:PySide2.QtGui.QPixmap): ...
    def drawDisplay(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionViewItem, rect:PySide2.QtCore.QRect, text:str): ...
    def drawFocus(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionViewItem, rect:PySide2.QtCore.QRect): ...
    def editorEvent(self, event:PySide2.QtCore.QEvent, model:PySide2.QtCore.QAbstractItemModel, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object:PySide2.QtCore.QObject, event:PySide2.QtCore.QEvent) -> bool: ...
    def hasClipping(self) -> bool: ...
    def itemEditorFactory(self) -> PySide2.QtWidgets.QItemEditorFactory: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex): ...
    def rect(self, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex, role:int) -> PySide2.QtCore.QRect: ...
    @staticmethod
    def selectedPixmap(pixmap:PySide2.QtGui.QPixmap, palette:PySide2.QtGui.QPalette, enabled:bool) -> PySide2.QtGui.QPixmap: ...
    def setClipping(self, clip:bool): ...
    def setEditorData(self, editor:PySide2.QtWidgets.QWidget, index:PySide2.QtCore.QModelIndex): ...
    def setItemEditorFactory(self, factory:PySide2.QtWidgets.QItemEditorFactory): ...
    def setModelData(self, editor:PySide2.QtWidgets.QWidget, model:PySide2.QtCore.QAbstractItemModel, index:PySide2.QtCore.QModelIndex): ...
    def setOptions(self, index:PySide2.QtCore.QModelIndex, option:PySide2.QtWidgets.QStyleOptionViewItem) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def sizeHint(self, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def textRectangle(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRect, font:PySide2.QtGui.QFont, text:str) -> PySide2.QtCore.QRect: ...
    def updateEditorGeometry(self, editor:PySide2.QtWidgets.QWidget, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex): ...


class QItemEditorCreatorBase(Shiboken.Object):

    def __init__(self): ...

    def createWidget(self, parent:PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def valuePropertyName(self) -> PySide2.QtCore.QByteArray: ...


class QItemEditorFactory(Shiboken.Object):

    def __init__(self): ...

    def createEditor(self, userType:int, parent:PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    @staticmethod
    def defaultFactory() -> PySide2.QtWidgets.QItemEditorFactory: ...
    def registerEditor(self, userType:int, creator:PySide2.QtWidgets.QItemEditorCreatorBase): ...
    @staticmethod
    def setDefaultFactory(factory:PySide2.QtWidgets.QItemEditorFactory): ...
    def valuePropertyName(self, userType:int) -> PySide2.QtCore.QByteArray: ...


class QKeyEventTransition(PySide2.QtCore.QEventTransition):

    @typing.overload
    def __init__(self, object:PySide2.QtCore.QObject, type:PySide2.QtCore.QEvent.Type, key:int, sourceState:typing.Optional[PySide2.QtCore.QState]=...): ...
    @typing.overload
    def __init__(self, sourceState:typing.Optional[PySide2.QtCore.QState]=...): ...

    def eventTest(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def key(self) -> int: ...
    def modifierMask(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def onTransition(self, event:PySide2.QtCore.QEvent): ...
    def setKey(self, key:int): ...
    def setModifierMask(self, modifiers:PySide2.QtCore.Qt.KeyboardModifiers): ...


class QKeySequenceEdit(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, keySequence:PySide2.QtGui.QKeySequence, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def clear(self): ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, arg__1:PySide2.QtGui.QKeyEvent): ...
    def keySequence(self) -> PySide2.QtGui.QKeySequence: ...
    def setKeySequence(self, keySequence:PySide2.QtGui.QKeySequence): ...
    def timerEvent(self, arg__1:PySide2.QtCore.QTimerEvent): ...


class QLCDNumber(PySide2.QtWidgets.QFrame):
    Hex                      : QLCDNumber = ... # 0x0
    Outline                  : QLCDNumber = ... # 0x0
    Dec                      : QLCDNumber = ... # 0x1
    Filled                   : QLCDNumber = ... # 0x1
    Flat                     : QLCDNumber = ... # 0x2
    Oct                      : QLCDNumber = ... # 0x2
    Bin                      : QLCDNumber = ... # 0x3

    class Mode(object):
        Hex                      : QLCDNumber.Mode = ... # 0x0
        Dec                      : QLCDNumber.Mode = ... # 0x1
        Oct                      : QLCDNumber.Mode = ... # 0x2
        Bin                      : QLCDNumber.Mode = ... # 0x3

    class SegmentStyle(object):
        Outline                  : QLCDNumber.SegmentStyle = ... # 0x0
        Filled                   : QLCDNumber.SegmentStyle = ... # 0x1
        Flat                     : QLCDNumber.SegmentStyle = ... # 0x2

    @typing.overload
    def __init__(self, numDigits:int, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    @typing.overload
    def checkOverflow(self, num:float) -> bool: ...
    @typing.overload
    def checkOverflow(self, num:int) -> bool: ...
    def digitCount(self) -> int: ...
    @typing.overload
    def display(self, num:float): ...
    @typing.overload
    def display(self, num:int): ...
    @typing.overload
    def display(self, str:str): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def intValue(self) -> int: ...
    def mode(self) -> PySide2.QtWidgets.QLCDNumber.Mode: ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def segmentStyle(self) -> PySide2.QtWidgets.QLCDNumber.SegmentStyle: ...
    def setBinMode(self): ...
    def setDecMode(self): ...
    def setDigitCount(self, nDigits:int): ...
    def setHexMode(self): ...
    def setMode(self, arg__1:PySide2.QtWidgets.QLCDNumber.Mode): ...
    def setOctMode(self): ...
    def setSegmentStyle(self, arg__1:PySide2.QtWidgets.QLCDNumber.SegmentStyle): ...
    def setSmallDecimalPoint(self, arg__1:bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def smallDecimalPoint(self) -> bool: ...
    def value(self) -> float: ...


class QLabel(PySide2.QtWidgets.QFrame):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., f:PySide2.QtCore.Qt.WindowFlags=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., f:PySide2.QtCore.Qt.WindowFlags=...): ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def buddy(self) -> PySide2.QtWidgets.QWidget: ...
    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def contextMenuEvent(self, ev:PySide2.QtGui.QContextMenuEvent): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, ev:PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def focusOutEvent(self, ev:PySide2.QtGui.QFocusEvent): ...
    def hasScaledContents(self) -> bool: ...
    def hasSelectedText(self) -> bool: ...
    def heightForWidth(self, arg__1:int) -> int: ...
    def indent(self) -> int: ...
    def keyPressEvent(self, ev:PySide2.QtGui.QKeyEvent): ...
    def margin(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, ev:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, ev:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, ev:PySide2.QtGui.QMouseEvent): ...
    def movie(self) -> PySide2.QtGui.QMovie: ...
    def openExternalLinks(self) -> bool: ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def picture(self) -> PySide2.QtGui.QPicture: ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    def selectedText(self) -> str: ...
    def selectionStart(self) -> int: ...
    def setAlignment(self, arg__1:PySide2.QtCore.Qt.Alignment): ...
    def setBuddy(self, arg__1:PySide2.QtWidgets.QWidget): ...
    def setIndent(self, arg__1:int): ...
    def setMargin(self, arg__1:int): ...
    def setMovie(self, movie:PySide2.QtGui.QMovie): ...
    @typing.overload
    def setNum(self, arg__1:float): ...
    @typing.overload
    def setNum(self, arg__1:int): ...
    def setOpenExternalLinks(self, open:bool): ...
    def setPicture(self, arg__1:PySide2.QtGui.QPicture): ...
    def setPixmap(self, arg__1:PySide2.QtGui.QPixmap): ...
    def setScaledContents(self, arg__1:bool): ...
    def setSelection(self, arg__1:int, arg__2:int): ...
    def setText(self, arg__1:str): ...
    def setTextFormat(self, arg__1:PySide2.QtCore.Qt.TextFormat): ...
    def setTextInteractionFlags(self, flags:PySide2.QtCore.Qt.TextInteractionFlags): ...
    def setWordWrap(self, on:bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def wordWrap(self) -> bool: ...


class QLayout(PySide2.QtCore.QObject, PySide2.QtWidgets.QLayoutItem):
    SetDefaultConstraint     : QLayout = ... # 0x0
    SetNoConstraint          : QLayout = ... # 0x1
    SetMinimumSize           : QLayout = ... # 0x2
    SetFixedSize             : QLayout = ... # 0x3
    SetMaximumSize           : QLayout = ... # 0x4
    SetMinAndMaxSize         : QLayout = ... # 0x5

    class SizeConstraint(object):
        SetDefaultConstraint     : QLayout.SizeConstraint = ... # 0x0
        SetNoConstraint          : QLayout.SizeConstraint = ... # 0x1
        SetMinimumSize           : QLayout.SizeConstraint = ... # 0x2
        SetFixedSize             : QLayout.SizeConstraint = ... # 0x3
        SetMaximumSize           : QLayout.SizeConstraint = ... # 0x4
        SetMinAndMaxSize         : QLayout.SizeConstraint = ... # 0x5

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QWidget): ...

    def activate(self) -> bool: ...
    def addChildLayout(self, l:PySide2.QtWidgets.QLayout): ...
    def addChildWidget(self, w:PySide2.QtWidgets.QWidget): ...
    def addItem(self, arg__1:PySide2.QtWidgets.QLayoutItem): ...
    def addWidget(self, w:PySide2.QtWidgets.QWidget): ...
    def adoptLayout(self, layout:PySide2.QtWidgets.QLayout) -> bool: ...
    def alignmentRect(self, arg__1:PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def childEvent(self, e:PySide2.QtCore.QChildEvent): ...
    @staticmethod
    def closestAcceptableSize(w:PySide2.QtWidgets.QWidget, s:PySide2.QtCore.QSize) -> PySide2.QtCore.QSize: ...
    def contentsMargins(self) -> PySide2.QtCore.QMargins: ...
    def contentsRect(self) -> PySide2.QtCore.QRect: ...
    def controlTypes(self) -> PySide2.QtWidgets.QSizePolicy.ControlTypes: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def getContentsMargins(self) -> typing.Tuple: ...
    @typing.overload
    def indexOf(self, arg__1:PySide2.QtWidgets.QLayoutItem) -> int: ...
    @typing.overload
    def indexOf(self, arg__1:PySide2.QtWidgets.QWidget) -> int: ...
    def invalidate(self): ...
    def isEmpty(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def itemAt(self, index:int) -> PySide2.QtWidgets.QLayoutItem: ...
    def layout(self) -> PySide2.QtWidgets.QLayout: ...
    def margin(self) -> int: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def menuBar(self) -> PySide2.QtWidgets.QWidget: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def removeItem(self, arg__1:PySide2.QtWidgets.QLayoutItem): ...
    def removeWidget(self, w:PySide2.QtWidgets.QWidget): ...
    def replaceWidget(self, from_:PySide2.QtWidgets.QWidget, to:PySide2.QtWidgets.QWidget, options:PySide2.QtCore.Qt.FindChildOptions=...) -> PySide2.QtWidgets.QLayoutItem: ...
    @typing.overload
    def setAlignment(self, arg__1:PySide2.QtCore.Qt.Alignment): ...
    @typing.overload
    def setAlignment(self, l:PySide2.QtWidgets.QLayout, alignment:PySide2.QtCore.Qt.Alignment) -> bool: ...
    @typing.overload
    def setAlignment(self, w:PySide2.QtWidgets.QWidget, alignment:PySide2.QtCore.Qt.Alignment) -> bool: ...
    @typing.overload
    def setContentsMargins(self, left:int, top:int, right:int, bottom:int): ...
    @typing.overload
    def setContentsMargins(self, margins:PySide2.QtCore.QMargins): ...
    def setEnabled(self, arg__1:bool): ...
    def setGeometry(self, arg__1:PySide2.QtCore.QRect): ...
    def setMargin(self, arg__1:int): ...
    def setMenuBar(self, w:PySide2.QtWidgets.QWidget): ...
    def setSizeConstraint(self, arg__1:PySide2.QtWidgets.QLayout.SizeConstraint): ...
    def setSpacing(self, arg__1:int): ...
    def sizeConstraint(self) -> PySide2.QtWidgets.QLayout.SizeConstraint: ...
    def spacing(self) -> int: ...
    def takeAt(self, index:int) -> PySide2.QtWidgets.QLayoutItem: ...
    def totalHeightForWidth(self, w:int) -> int: ...
    def totalMaximumSize(self) -> PySide2.QtCore.QSize: ...
    def totalMinimumSize(self) -> PySide2.QtCore.QSize: ...
    def totalSizeHint(self) -> PySide2.QtCore.QSize: ...
    def update(self): ...
    def widgetEvent(self, arg__1:PySide2.QtCore.QEvent): ...


class QLayoutItem(Shiboken.Object):

    def __init__(self, alignment:PySide2.QtCore.Qt.Alignment=...): ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def controlTypes(self) -> PySide2.QtWidgets.QSizePolicy.ControlTypes: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1:int) -> int: ...
    def invalidate(self): ...
    def isEmpty(self) -> bool: ...
    def layout(self) -> PySide2.QtWidgets.QLayout: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1:int) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setAlignment(self, a:PySide2.QtCore.Qt.Alignment): ...
    def setGeometry(self, arg__1:PySide2.QtCore.QRect): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def spacerItem(self) -> PySide2.QtWidgets.QSpacerItem: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QLineEdit(PySide2.QtWidgets.QWidget):
    LeadingPosition          : QLineEdit = ... # 0x0
    Normal                   : QLineEdit = ... # 0x0
    NoEcho                   : QLineEdit = ... # 0x1
    TrailingPosition         : QLineEdit = ... # 0x1
    Password                 : QLineEdit = ... # 0x2
    PasswordEchoOnEdit       : QLineEdit = ... # 0x3

    class ActionPosition(object):
        LeadingPosition          : QLineEdit.ActionPosition = ... # 0x0
        TrailingPosition         : QLineEdit.ActionPosition = ... # 0x1

    class EchoMode(object):
        Normal                   : QLineEdit.EchoMode = ... # 0x0
        NoEcho                   : QLineEdit.EchoMode = ... # 0x1
        Password                 : QLineEdit.EchoMode = ... # 0x2
        PasswordEchoOnEdit       : QLineEdit.EchoMode = ... # 0x3

    @typing.overload
    def __init__(self, arg__1:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    @typing.overload
    def addAction(self, action:PySide2.QtWidgets.QAction): ...
    @typing.overload
    def addAction(self, action:PySide2.QtWidgets.QAction, position:PySide2.QtWidgets.QLineEdit.ActionPosition): ...
    @typing.overload
    def addAction(self, arg__1:PySide2.QtWidgets.QAction): ...
    @typing.overload
    def addAction(self, icon:PySide2.QtGui.QIcon, position:PySide2.QtWidgets.QLineEdit.ActionPosition) -> PySide2.QtWidgets.QAction: ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def backspace(self): ...
    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def completer(self) -> PySide2.QtWidgets.QCompleter: ...
    def contextMenuEvent(self, arg__1:PySide2.QtGui.QContextMenuEvent): ...
    def copy(self): ...
    def createStandardContextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def cursorBackward(self, mark:bool, steps:int=...): ...
    def cursorForward(self, mark:bool, steps:int=...): ...
    def cursorMoveStyle(self) -> PySide2.QtCore.Qt.CursorMoveStyle: ...
    def cursorPosition(self) -> int: ...
    def cursorPositionAt(self, pos:PySide2.QtCore.QPoint) -> int: ...
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    def cursorWordBackward(self, mark:bool): ...
    def cursorWordForward(self, mark:bool): ...
    def cut(self): ...
    def del_(self): ...
    def deselect(self): ...
    def displayText(self) -> str: ...
    def dragEnabled(self) -> bool: ...
    def dragEnterEvent(self, arg__1:PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, e:PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, e:PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, arg__1:PySide2.QtGui.QDropEvent): ...
    def echoMode(self) -> PySide2.QtWidgets.QLineEdit.EchoMode: ...
    def end(self, mark:bool): ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1:PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, arg__1:PySide2.QtGui.QFocusEvent): ...
    def getTextMargins(self) -> typing.Tuple: ...
    def hasAcceptableInput(self) -> bool: ...
    def hasFrame(self) -> bool: ...
    def hasSelectedText(self) -> bool: ...
    def home(self, mark:bool): ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionFrame): ...
    def inputMask(self) -> str: ...
    def inputMethodEvent(self, arg__1:PySide2.QtGui.QInputMethodEvent): ...
    @typing.overload
    def inputMethodQuery(self, arg__1:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, property:PySide2.QtCore.Qt.InputMethodQuery, argument:typing.Any) -> typing.Any: ...
    def insert(self, arg__1:str): ...
    def isClearButtonEnabled(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent): ...
    def maxLength(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def paste(self): ...
    def placeholderText(self) -> str: ...
    def redo(self): ...
    def selectAll(self): ...
    def selectedText(self) -> str: ...
    def selectionEnd(self) -> int: ...
    def selectionLength(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setAlignment(self, flag:PySide2.QtCore.Qt.Alignment): ...
    def setClearButtonEnabled(self, enable:bool): ...
    def setCompleter(self, completer:PySide2.QtWidgets.QCompleter): ...
    def setCursorMoveStyle(self, style:PySide2.QtCore.Qt.CursorMoveStyle): ...
    def setCursorPosition(self, arg__1:int): ...
    def setDragEnabled(self, b:bool): ...
    def setEchoMode(self, arg__1:PySide2.QtWidgets.QLineEdit.EchoMode): ...
    def setFrame(self, arg__1:bool): ...
    def setInputMask(self, inputMask:str): ...
    def setMaxLength(self, arg__1:int): ...
    def setModified(self, arg__1:bool): ...
    def setPlaceholderText(self, arg__1:str): ...
    def setReadOnly(self, arg__1:bool): ...
    def setSelection(self, arg__1:int, arg__2:int): ...
    def setText(self, arg__1:str): ...
    @typing.overload
    def setTextMargins(self, left:int, top:int, right:int, bottom:int): ...
    @typing.overload
    def setTextMargins(self, margins:PySide2.QtCore.QMargins): ...
    def setValidator(self, arg__1:PySide2.QtGui.QValidator): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textMargins(self) -> PySide2.QtCore.QMargins: ...
    def undo(self): ...
    def validator(self) -> PySide2.QtGui.QValidator: ...


class QListView(PySide2.QtWidgets.QAbstractItemView):
    Fixed                    : QListView = ... # 0x0
    LeftToRight              : QListView = ... # 0x0
    ListMode                 : QListView = ... # 0x0
    SinglePass               : QListView = ... # 0x0
    Static                   : QListView = ... # 0x0
    Adjust                   : QListView = ... # 0x1
    Batched                  : QListView = ... # 0x1
    Free                     : QListView = ... # 0x1
    IconMode                 : QListView = ... # 0x1
    TopToBottom              : QListView = ... # 0x1
    Snap                     : QListView = ... # 0x2

    class Flow(object):
        LeftToRight              : QListView.Flow = ... # 0x0
        TopToBottom              : QListView.Flow = ... # 0x1

    class LayoutMode(object):
        SinglePass               : QListView.LayoutMode = ... # 0x0
        Batched                  : QListView.LayoutMode = ... # 0x1

    class Movement(object):
        Static                   : QListView.Movement = ... # 0x0
        Free                     : QListView.Movement = ... # 0x1
        Snap                     : QListView.Movement = ... # 0x2

    class ResizeMode(object):
        Fixed                    : QListView.ResizeMode = ... # 0x0
        Adjust                   : QListView.ResizeMode = ... # 0x1

    class ViewMode(object):
        ListMode                 : QListView.ViewMode = ... # 0x0
        IconMode                 : QListView.ViewMode = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def batchSize(self) -> int: ...
    def clearPropertyFlags(self): ...
    def contentsSize(self) -> PySide2.QtCore.QSize: ...
    def currentChanged(self, current:PySide2.QtCore.QModelIndex, previous:PySide2.QtCore.QModelIndex): ...
    def dataChanged(self, topLeft:PySide2.QtCore.QModelIndex, bottomRight:PySide2.QtCore.QModelIndex, roles:typing.List=...): ...
    def doItemsLayout(self): ...
    def dragLeaveEvent(self, e:PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, e:PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, e:PySide2.QtGui.QDropEvent): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def flow(self) -> PySide2.QtWidgets.QListView.Flow: ...
    def gridSize(self) -> PySide2.QtCore.QSize: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, p:PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def isIndexHidden(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowHidden(self, row:int) -> bool: ...
    def isSelectionRectVisible(self) -> bool: ...
    def isWrapping(self) -> bool: ...
    def itemAlignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def layoutMode(self) -> PySide2.QtWidgets.QListView.LayoutMode: ...
    def modelColumn(self) -> int: ...
    def mouseMoveEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, cursorAction:PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def movement(self) -> PySide2.QtWidgets.QListView.Movement: ...
    def paintEvent(self, e:PySide2.QtGui.QPaintEvent): ...
    def rectForIndex(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def reset(self): ...
    def resizeContents(self, width:int, height:int): ...
    def resizeEvent(self, e:PySide2.QtGui.QResizeEvent): ...
    def resizeMode(self) -> PySide2.QtWidgets.QListView.ResizeMode: ...
    def rowsAboutToBeRemoved(self, parent:PySide2.QtCore.QModelIndex, start:int, end:int): ...
    def rowsInserted(self, parent:PySide2.QtCore.QModelIndex, start:int, end:int): ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def scrollTo(self, index:PySide2.QtCore.QModelIndex, hint:PySide2.QtWidgets.QAbstractItemView.ScrollHint=...): ...
    def selectedIndexes(self) -> typing.List: ...
    def selectionChanged(self, selected:PySide2.QtCore.QItemSelection, deselected:PySide2.QtCore.QItemSelection): ...
    def setBatchSize(self, batchSize:int): ...
    def setFlow(self, flow:PySide2.QtWidgets.QListView.Flow): ...
    def setGridSize(self, size:PySide2.QtCore.QSize): ...
    def setItemAlignment(self, alignment:PySide2.QtCore.Qt.Alignment): ...
    def setLayoutMode(self, mode:PySide2.QtWidgets.QListView.LayoutMode): ...
    def setModelColumn(self, column:int): ...
    def setMovement(self, movement:PySide2.QtWidgets.QListView.Movement): ...
    def setPositionForIndex(self, position:PySide2.QtCore.QPoint, index:PySide2.QtCore.QModelIndex): ...
    def setResizeMode(self, mode:PySide2.QtWidgets.QListView.ResizeMode): ...
    def setRootIndex(self, index:PySide2.QtCore.QModelIndex): ...
    def setRowHidden(self, row:int, hide:bool): ...
    def setSelection(self, rect:PySide2.QtCore.QRect, command:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSelectionRectVisible(self, show:bool): ...
    def setSpacing(self, space:int): ...
    def setUniformItemSizes(self, enable:bool): ...
    def setViewMode(self, mode:PySide2.QtWidgets.QListView.ViewMode): ...
    def setWordWrap(self, on:bool): ...
    def setWrapping(self, enable:bool): ...
    def spacing(self) -> int: ...
    def startDrag(self, supportedActions:PySide2.QtCore.Qt.DropActions): ...
    def timerEvent(self, e:PySide2.QtCore.QTimerEvent): ...
    def uniformItemSizes(self) -> bool: ...
    def updateGeometries(self): ...
    def verticalOffset(self) -> int: ...
    def viewMode(self) -> PySide2.QtWidgets.QListView.ViewMode: ...
    def viewOptions(self) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection:PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...
    def wheelEvent(self, e:PySide2.QtGui.QWheelEvent): ...
    def wordWrap(self) -> bool: ...


class QListWidget(PySide2.QtWidgets.QListView):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    @typing.overload
    def addItem(self, item:PySide2.QtWidgets.QListWidgetItem): ...
    @typing.overload
    def addItem(self, label:str): ...
    def addItems(self, labels:typing.Sequence): ...
    def clear(self): ...
    @typing.overload
    def closePersistentEditor(self, index:PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def closePersistentEditor(self, item:PySide2.QtWidgets.QListWidgetItem): ...
    def count(self) -> int: ...
    def currentItem(self) -> PySide2.QtWidgets.QListWidgetItem: ...
    def currentRow(self) -> int: ...
    def dropEvent(self, event:PySide2.QtGui.QDropEvent): ...
    def dropMimeData(self, index:int, data:PySide2.QtCore.QMimeData, action:PySide2.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item:PySide2.QtWidgets.QListWidgetItem): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def findItems(self, text:str, flags:PySide2.QtCore.Qt.MatchFlags) -> typing.List: ...
    def indexFromItem(self, item:PySide2.QtWidgets.QListWidgetItem) -> PySide2.QtCore.QModelIndex: ...
    @typing.overload
    def insertItem(self, row:int, item:PySide2.QtWidgets.QListWidgetItem): ...
    @typing.overload
    def insertItem(self, row:int, label:str): ...
    def insertItems(self, row:int, labels:typing.Sequence): ...
    def isItemHidden(self, item:PySide2.QtWidgets.QListWidgetItem) -> bool: ...
    def isItemSelected(self, item:PySide2.QtWidgets.QListWidgetItem) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, item:PySide2.QtWidgets.QListWidgetItem) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def item(self, row:int) -> PySide2.QtWidgets.QListWidgetItem: ...
    @typing.overload
    def itemAt(self, p:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QListWidgetItem: ...
    @typing.overload
    def itemAt(self, x:int, y:int) -> PySide2.QtWidgets.QListWidgetItem: ...
    def itemFromIndex(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QListWidgetItem: ...
    def itemWidget(self, item:PySide2.QtWidgets.QListWidgetItem) -> PySide2.QtWidgets.QWidget: ...
    def items(self, data:PySide2.QtCore.QMimeData) -> typing.List: ...
    def mimeData(self, items:typing.Sequence) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List: ...
    @typing.overload
    def openPersistentEditor(self, index:PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def openPersistentEditor(self, item:PySide2.QtWidgets.QListWidgetItem): ...
    def removeItemWidget(self, item:PySide2.QtWidgets.QListWidgetItem): ...
    def row(self, item:PySide2.QtWidgets.QListWidgetItem) -> int: ...
    def scrollToItem(self, item:PySide2.QtWidgets.QListWidgetItem, hint:PySide2.QtWidgets.QAbstractItemView.ScrollHint=...): ...
    def selectedItems(self) -> typing.List: ...
    @typing.overload
    def setCurrentItem(self, item:PySide2.QtWidgets.QListWidgetItem): ...
    @typing.overload
    def setCurrentItem(self, item:PySide2.QtWidgets.QListWidgetItem, command:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    @typing.overload
    def setCurrentRow(self, row:int): ...
    @typing.overload
    def setCurrentRow(self, row:int, command:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setItemHidden(self, item:PySide2.QtWidgets.QListWidgetItem, hide:bool): ...
    def setItemSelected(self, item:PySide2.QtWidgets.QListWidgetItem, select:bool): ...
    def setItemWidget(self, item:PySide2.QtWidgets.QListWidgetItem, widget:PySide2.QtWidgets.QWidget): ...
    def setModel(self, model:PySide2.QtCore.QAbstractItemModel): ...
    def setSelectionModel(self, selectionModel:PySide2.QtCore.QItemSelectionModel): ...
    def setSortingEnabled(self, enable:bool): ...
    def sortItems(self, order:PySide2.QtCore.Qt.SortOrder=...): ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeItem(self, row:int) -> PySide2.QtWidgets.QListWidgetItem: ...
    def visualItemRect(self, item:PySide2.QtWidgets.QListWidgetItem) -> PySide2.QtCore.QRect: ...


class QListWidgetItem(Shiboken.Object):
    Type                     : QListWidgetItem = ... # 0x0
    UserType                 : QListWidgetItem = ... # 0x3e8

    class ItemType(object):
        Type                     : QListWidgetItem.ItemType = ... # 0x0
        UserType                 : QListWidgetItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self, icon:PySide2.QtGui.QIcon, text:str, listview:typing.Optional[PySide2.QtWidgets.QListWidget]=..., type:int=...): ...
    @typing.overload
    def __init__(self, listview:typing.Optional[PySide2.QtWidgets.QListWidget]=..., type:int=...): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QListWidgetItem): ...
    @typing.overload
    def __init__(self, text:str, listview:typing.Optional[PySide2.QtWidgets.QListWidget]=..., type:int=...): ...

    def __lshift__(self, out:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def clone(self) -> PySide2.QtWidgets.QListWidgetItem: ...
    def data(self, role:int) -> typing.Any: ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def isHidden(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def listWidget(self) -> PySide2.QtWidgets.QListWidget: ...
    def read(self, in_:PySide2.QtCore.QDataStream): ...
    def setBackground(self, brush:PySide2.QtGui.QBrush): ...
    def setBackgroundColor(self, color:PySide2.QtGui.QColor): ...
    def setCheckState(self, state:PySide2.QtCore.Qt.CheckState): ...
    def setData(self, role:int, value:typing.Any): ...
    def setFlags(self, flags:PySide2.QtCore.Qt.ItemFlags): ...
    def setFont(self, font:PySide2.QtGui.QFont): ...
    def setForeground(self, brush:PySide2.QtGui.QBrush): ...
    def setHidden(self, hide:bool): ...
    def setIcon(self, icon:PySide2.QtGui.QIcon): ...
    def setSelected(self, select:bool): ...
    def setSizeHint(self, size:PySide2.QtCore.QSize): ...
    def setStatusTip(self, statusTip:str): ...
    def setText(self, text:str): ...
    def setTextAlignment(self, alignment:int): ...
    def setTextColor(self, color:PySide2.QtGui.QColor): ...
    def setToolTip(self, toolTip:str): ...
    def setWhatsThis(self, whatsThis:str): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def textAlignment(self) -> int: ...
    def textColor(self) -> PySide2.QtGui.QColor: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out:PySide2.QtCore.QDataStream): ...


class QMainWindow(PySide2.QtWidgets.QWidget):
    AnimatedDocks            : QMainWindow = ... # 0x1
    AllowNestedDocks         : QMainWindow = ... # 0x2
    AllowTabbedDocks         : QMainWindow = ... # 0x4
    ForceTabbedDocks         : QMainWindow = ... # 0x8
    VerticalTabs             : QMainWindow = ... # 0x10
    GroupedDragging          : QMainWindow = ... # 0x20

    class DockOption(object):
        AnimatedDocks            : QMainWindow.DockOption = ... # 0x1
        AllowNestedDocks         : QMainWindow.DockOption = ... # 0x2
        AllowTabbedDocks         : QMainWindow.DockOption = ... # 0x4
        ForceTabbedDocks         : QMainWindow.DockOption = ... # 0x8
        VerticalTabs             : QMainWindow.DockOption = ... # 0x10
        GroupedDragging          : QMainWindow.DockOption = ... # 0x20

    class DockOptions(object): ...

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., flags:PySide2.QtCore.Qt.WindowFlags=...): ...

    @typing.overload
    def addDockWidget(self, area:PySide2.QtCore.Qt.DockWidgetArea, dockwidget:PySide2.QtWidgets.QDockWidget): ...
    @typing.overload
    def addDockWidget(self, area:PySide2.QtCore.Qt.DockWidgetArea, dockwidget:PySide2.QtWidgets.QDockWidget, orientation:PySide2.QtCore.Qt.Orientation): ...
    @typing.overload
    def addToolBar(self, area:PySide2.QtCore.Qt.ToolBarArea, toolbar:PySide2.QtWidgets.QToolBar): ...
    @typing.overload
    def addToolBar(self, title:str) -> PySide2.QtWidgets.QToolBar: ...
    @typing.overload
    def addToolBar(self, toolbar:PySide2.QtWidgets.QToolBar): ...
    def addToolBarBreak(self, area:PySide2.QtCore.Qt.ToolBarArea=...): ...
    def centralWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def contextMenuEvent(self, event:PySide2.QtGui.QContextMenuEvent): ...
    def corner(self, corner:PySide2.QtCore.Qt.Corner) -> PySide2.QtCore.Qt.DockWidgetArea: ...
    def createPopupMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def dockOptions(self) -> PySide2.QtWidgets.QMainWindow.DockOptions: ...
    def dockWidgetArea(self, dockwidget:PySide2.QtWidgets.QDockWidget) -> PySide2.QtCore.Qt.DockWidgetArea: ...
    def documentMode(self) -> bool: ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def insertToolBar(self, before:PySide2.QtWidgets.QToolBar, toolbar:PySide2.QtWidgets.QToolBar): ...
    def insertToolBarBreak(self, before:PySide2.QtWidgets.QToolBar): ...
    def isAnimated(self) -> bool: ...
    def isDockNestingEnabled(self) -> bool: ...
    def isSeparator(self, pos:PySide2.QtCore.QPoint) -> bool: ...
    def menuBar(self) -> PySide2.QtWidgets.QMenuBar: ...
    def menuWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def removeDockWidget(self, dockwidget:PySide2.QtWidgets.QDockWidget): ...
    def removeToolBar(self, toolbar:PySide2.QtWidgets.QToolBar): ...
    def removeToolBarBreak(self, before:PySide2.QtWidgets.QToolBar): ...
    def resizeDocks(self, docks:typing.Sequence, sizes:typing.Sequence, orientation:PySide2.QtCore.Qt.Orientation): ...
    def restoreDockWidget(self, dockwidget:PySide2.QtWidgets.QDockWidget) -> bool: ...
    def restoreState(self, state:PySide2.QtCore.QByteArray, version:int=...) -> bool: ...
    def saveState(self, version:int=...) -> PySide2.QtCore.QByteArray: ...
    def setAnimated(self, enabled:bool): ...
    def setCentralWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def setCorner(self, corner:PySide2.QtCore.Qt.Corner, area:PySide2.QtCore.Qt.DockWidgetArea): ...
    def setDockNestingEnabled(self, enabled:bool): ...
    def setDockOptions(self, options:PySide2.QtWidgets.QMainWindow.DockOptions): ...
    def setDocumentMode(self, enabled:bool): ...
    def setIconSize(self, iconSize:PySide2.QtCore.QSize): ...
    def setMenuBar(self, menubar:PySide2.QtWidgets.QMenuBar): ...
    def setMenuWidget(self, menubar:PySide2.QtWidgets.QWidget): ...
    def setStatusBar(self, statusbar:PySide2.QtWidgets.QStatusBar): ...
    def setTabPosition(self, areas:PySide2.QtCore.Qt.DockWidgetAreas, tabPosition:PySide2.QtWidgets.QTabWidget.TabPosition): ...
    def setTabShape(self, tabShape:PySide2.QtWidgets.QTabWidget.TabShape): ...
    def setToolButtonStyle(self, toolButtonStyle:PySide2.QtCore.Qt.ToolButtonStyle): ...
    def setUnifiedTitleAndToolBarOnMac(self, set:bool): ...
    def splitDockWidget(self, after:PySide2.QtWidgets.QDockWidget, dockwidget:PySide2.QtWidgets.QDockWidget, orientation:PySide2.QtCore.Qt.Orientation): ...
    def statusBar(self) -> PySide2.QtWidgets.QStatusBar: ...
    def tabPosition(self, area:PySide2.QtCore.Qt.DockWidgetArea) -> PySide2.QtWidgets.QTabWidget.TabPosition: ...
    def tabShape(self) -> PySide2.QtWidgets.QTabWidget.TabShape: ...
    def tabifiedDockWidgets(self, dockwidget:PySide2.QtWidgets.QDockWidget) -> typing.List: ...
    def tabifyDockWidget(self, first:PySide2.QtWidgets.QDockWidget, second:PySide2.QtWidgets.QDockWidget): ...
    def takeCentralWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def toolBarArea(self, toolbar:PySide2.QtWidgets.QToolBar) -> PySide2.QtCore.Qt.ToolBarArea: ...
    def toolBarBreak(self, toolbar:PySide2.QtWidgets.QToolBar) -> bool: ...
    def toolButtonStyle(self) -> PySide2.QtCore.Qt.ToolButtonStyle: ...
    def unifiedTitleAndToolBarOnMac(self) -> bool: ...


class QMdiArea(PySide2.QtWidgets.QAbstractScrollArea):
    CreationOrder            : QMdiArea = ... # 0x0
    SubWindowView            : QMdiArea = ... # 0x0
    DontMaximizeSubWindowOnActivation: QMdiArea = ... # 0x1
    StackingOrder            : QMdiArea = ... # 0x1
    TabbedView               : QMdiArea = ... # 0x1
    ActivationHistoryOrder   : QMdiArea = ... # 0x2

    class AreaOption(object):
        DontMaximizeSubWindowOnActivation: QMdiArea.AreaOption = ... # 0x1

    class AreaOptions(object): ...

    class ViewMode(object):
        SubWindowView            : QMdiArea.ViewMode = ... # 0x0
        TabbedView               : QMdiArea.ViewMode = ... # 0x1

    class WindowOrder(object):
        CreationOrder            : QMdiArea.WindowOrder = ... # 0x0
        StackingOrder            : QMdiArea.WindowOrder = ... # 0x1
        ActivationHistoryOrder   : QMdiArea.WindowOrder = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def activateNextSubWindow(self): ...
    def activatePreviousSubWindow(self): ...
    def activationOrder(self) -> PySide2.QtWidgets.QMdiArea.WindowOrder: ...
    def activeSubWindow(self) -> PySide2.QtWidgets.QMdiSubWindow: ...
    def addSubWindow(self, widget:PySide2.QtWidgets.QWidget, flags:PySide2.QtCore.Qt.WindowFlags=...) -> PySide2.QtWidgets.QMdiSubWindow: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def cascadeSubWindows(self): ...
    def childEvent(self, childEvent:PySide2.QtCore.QChildEvent): ...
    def closeActiveSubWindow(self): ...
    def closeAllSubWindows(self): ...
    def currentSubWindow(self) -> PySide2.QtWidgets.QMdiSubWindow: ...
    def documentMode(self) -> bool: ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object:PySide2.QtCore.QObject, event:PySide2.QtCore.QEvent) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, paintEvent:PySide2.QtGui.QPaintEvent): ...
    def removeSubWindow(self, widget:PySide2.QtWidgets.QWidget): ...
    def resizeEvent(self, resizeEvent:PySide2.QtGui.QResizeEvent): ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def setActivationOrder(self, order:PySide2.QtWidgets.QMdiArea.WindowOrder): ...
    def setActiveSubWindow(self, window:PySide2.QtWidgets.QMdiSubWindow): ...
    def setBackground(self, background:PySide2.QtGui.QBrush): ...
    def setDocumentMode(self, enabled:bool): ...
    def setOption(self, option:PySide2.QtWidgets.QMdiArea.AreaOption, on:bool=...): ...
    def setTabPosition(self, position:PySide2.QtWidgets.QTabWidget.TabPosition): ...
    def setTabShape(self, shape:PySide2.QtWidgets.QTabWidget.TabShape): ...
    def setTabsClosable(self, closable:bool): ...
    def setTabsMovable(self, movable:bool): ...
    def setViewMode(self, mode:PySide2.QtWidgets.QMdiArea.ViewMode): ...
    def setupViewport(self, viewport:PySide2.QtWidgets.QWidget): ...
    def showEvent(self, showEvent:PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def subWindowList(self, order:PySide2.QtWidgets.QMdiArea.WindowOrder=...) -> typing.List: ...
    def tabPosition(self) -> PySide2.QtWidgets.QTabWidget.TabPosition: ...
    def tabShape(self) -> PySide2.QtWidgets.QTabWidget.TabShape: ...
    def tabsClosable(self) -> bool: ...
    def tabsMovable(self) -> bool: ...
    def testOption(self, opton:PySide2.QtWidgets.QMdiArea.AreaOption) -> bool: ...
    def tileSubWindows(self): ...
    def timerEvent(self, timerEvent:PySide2.QtCore.QTimerEvent): ...
    def viewMode(self) -> PySide2.QtWidgets.QMdiArea.ViewMode: ...
    def viewportEvent(self, event:PySide2.QtCore.QEvent) -> bool: ...


class QMdiSubWindow(PySide2.QtWidgets.QWidget):
    AllowOutsideAreaHorizontally: QMdiSubWindow = ... # 0x1
    AllowOutsideAreaVertically: QMdiSubWindow = ... # 0x2
    RubberBandResize         : QMdiSubWindow = ... # 0x4
    RubberBandMove           : QMdiSubWindow = ... # 0x8

    class SubWindowOption(object):
        AllowOutsideAreaHorizontally: QMdiSubWindow.SubWindowOption = ... # 0x1
        AllowOutsideAreaVertically: QMdiSubWindow.SubWindowOption = ... # 0x2
        RubberBandResize         : QMdiSubWindow.SubWindowOption = ... # 0x4
        RubberBandMove           : QMdiSubWindow.SubWindowOption = ... # 0x8

    class SubWindowOptions(object): ...

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., flags:PySide2.QtCore.Qt.WindowFlags=...): ...

    def changeEvent(self, changeEvent:PySide2.QtCore.QEvent): ...
    def childEvent(self, childEvent:PySide2.QtCore.QChildEvent): ...
    def closeEvent(self, closeEvent:PySide2.QtGui.QCloseEvent): ...
    def contextMenuEvent(self, contextMenuEvent:PySide2.QtGui.QContextMenuEvent): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object:PySide2.QtCore.QObject, event:PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, focusInEvent:PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, focusOutEvent:PySide2.QtGui.QFocusEvent): ...
    def hideEvent(self, hideEvent:PySide2.QtGui.QHideEvent): ...
    def isShaded(self) -> bool: ...
    def keyPressEvent(self, keyEvent:PySide2.QtGui.QKeyEvent): ...
    def keyboardPageStep(self) -> int: ...
    def keyboardSingleStep(self) -> int: ...
    def leaveEvent(self, leaveEvent:PySide2.QtCore.QEvent): ...
    def maximizedButtonsWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def maximizedSystemMenuIconWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def mdiArea(self) -> PySide2.QtWidgets.QMdiArea: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, mouseEvent:PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, mouseEvent:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, mouseEvent:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, mouseEvent:PySide2.QtGui.QMouseEvent): ...
    def moveEvent(self, moveEvent:PySide2.QtGui.QMoveEvent): ...
    def paintEvent(self, paintEvent:PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, resizeEvent:PySide2.QtGui.QResizeEvent): ...
    def setKeyboardPageStep(self, step:int): ...
    def setKeyboardSingleStep(self, step:int): ...
    def setOption(self, option:PySide2.QtWidgets.QMdiSubWindow.SubWindowOption, on:bool=...): ...
    def setSystemMenu(self, systemMenu:PySide2.QtWidgets.QMenu): ...
    def setWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def showEvent(self, showEvent:PySide2.QtGui.QShowEvent): ...
    def showShaded(self): ...
    def showSystemMenu(self): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def systemMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def testOption(self, arg__1:PySide2.QtWidgets.QMdiSubWindow.SubWindowOption) -> bool: ...
    def timerEvent(self, timerEvent:PySide2.QtCore.QTimerEvent): ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QMenu(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, title:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def actionAt(self, arg__1:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QAction: ...
    def actionEvent(self, arg__1:PySide2.QtGui.QActionEvent): ...
    def actionGeometry(self, arg__1:PySide2.QtWidgets.QAction) -> PySide2.QtCore.QRect: ...
    def activeAction(self) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, arg__1:PySide2.QtGui.QIcon, arg__2:str, arg__3:object, arg__4:typing.Optional[PySide2.QtGui.QKeySequence]=...): ...
    @typing.overload
    def addAction(self, arg__1:PySide2.QtWidgets.QAction): ...
    @typing.overload
    def addAction(self, arg__1:str, arg__2:object, arg__3:typing.Optional[PySide2.QtGui.QKeySequence]=...): ...
    @typing.overload
    def addAction(self, icon:PySide2.QtGui.QIcon, text:str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, icon:PySide2.QtGui.QIcon, text:str, receiver:PySide2.QtCore.QObject, member:bytes, shortcut:typing.Optional[PySide2.QtGui.QKeySequence]=...) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text:str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text:str, receiver:PySide2.QtCore.QObject, member:bytes, shortcut:typing.Optional[PySide2.QtGui.QKeySequence]=...) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, icon:PySide2.QtGui.QIcon, title:str) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def addMenu(self, menu:PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, title:str) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def addSection(self, icon:PySide2.QtGui.QIcon, text:str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addSection(self, text:str) -> PySide2.QtWidgets.QAction: ...
    def addSeparator(self) -> PySide2.QtWidgets.QAction: ...
    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def columnCount(self) -> int: ...
    def defaultAction(self) -> PySide2.QtWidgets.QAction: ...
    def enterEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    @typing.overload
    @staticmethod
    def exec_() -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    @staticmethod
    def exec_(actions:typing.Sequence, pos:PySide2.QtCore.QPoint, at:typing.Optional[PySide2.QtWidgets.QAction]=..., parent:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    @staticmethod
    def exec_(pos:PySide2.QtCore.QPoint, at:typing.Optional[PySide2.QtWidgets.QAction]=...) -> PySide2.QtWidgets.QAction: ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def hideEvent(self, arg__1:PySide2.QtGui.QHideEvent): ...
    def hideTearOffMenu(self): ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionMenuItem, action:PySide2.QtWidgets.QAction): ...
    def insertMenu(self, before:PySide2.QtWidgets.QAction, menu:PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def insertSection(self, before:PySide2.QtWidgets.QAction, icon:PySide2.QtGui.QIcon, text:str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def insertSection(self, before:PySide2.QtWidgets.QAction, text:str) -> PySide2.QtWidgets.QAction: ...
    def insertSeparator(self, before:PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    def isEmpty(self) -> bool: ...
    def isTearOffEnabled(self) -> bool: ...
    def isTearOffMenuVisible(self) -> bool: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent): ...
    def leaveEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def menuAction(self) -> PySide2.QtWidgets.QAction: ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def popup(self, pos:PySide2.QtCore.QPoint, at:typing.Optional[PySide2.QtWidgets.QAction]=...): ...
    def separatorsCollapsible(self) -> bool: ...
    def setActiveAction(self, act:PySide2.QtWidgets.QAction): ...
    def setDefaultAction(self, arg__1:PySide2.QtWidgets.QAction): ...
    def setIcon(self, icon:PySide2.QtGui.QIcon): ...
    def setSeparatorsCollapsible(self, collapse:bool): ...
    def setTearOffEnabled(self, arg__1:bool): ...
    def setTitle(self, title:str): ...
    def setToolTipsVisible(self, visible:bool): ...
    @typing.overload
    def showTearOffMenu(self): ...
    @typing.overload
    def showTearOffMenu(self, pos:PySide2.QtCore.QPoint): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1:PySide2.QtCore.QTimerEvent): ...
    def title(self) -> str: ...
    def toolTipsVisible(self) -> bool: ...
    def wheelEvent(self, arg__1:PySide2.QtGui.QWheelEvent): ...


class QMenuBar(PySide2.QtWidgets.QWidget):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def actionAt(self, arg__1:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QAction: ...
    def actionEvent(self, arg__1:PySide2.QtGui.QActionEvent): ...
    def actionGeometry(self, arg__1:PySide2.QtWidgets.QAction) -> PySide2.QtCore.QRect: ...
    def activeAction(self) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, arg__1:PySide2.QtWidgets.QAction): ...
    @typing.overload
    def addAction(self, arg__1:str, arg__2:object): ...
    @typing.overload
    def addAction(self, text:str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text:str, receiver:PySide2.QtCore.QObject, member:bytes) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, icon:PySide2.QtGui.QIcon, title:str) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def addMenu(self, menu:PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addMenu(self, title:str) -> PySide2.QtWidgets.QMenu: ...
    def addSeparator(self) -> PySide2.QtWidgets.QAction: ...
    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def cornerWidget(self, corner:PySide2.QtCore.Qt.Corner=...) -> PySide2.QtWidgets.QWidget: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1:PySide2.QtCore.QObject, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1:PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, arg__1:PySide2.QtGui.QFocusEvent): ...
    def heightForWidth(self, arg__1:int) -> int: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionMenuItem, action:PySide2.QtWidgets.QAction): ...
    def insertMenu(self, before:PySide2.QtWidgets.QAction, menu:PySide2.QtWidgets.QMenu) -> PySide2.QtWidgets.QAction: ...
    def insertSeparator(self, before:PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    def isDefaultUp(self) -> bool: ...
    def isNativeMenuBar(self) -> bool: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent): ...
    def leaveEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent): ...
    def setActiveAction(self, action:PySide2.QtWidgets.QAction): ...
    def setCornerWidget(self, w:PySide2.QtWidgets.QWidget, corner:PySide2.QtCore.Qt.Corner=...): ...
    def setDefaultUp(self, arg__1:bool): ...
    def setNativeMenuBar(self, nativeMenuBar:bool): ...
    def setVisible(self, visible:bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1:PySide2.QtCore.QTimerEvent): ...


class QMessageBox(PySide2.QtWidgets.QDialog):
    ButtonMask               : QMessageBox = ... # -0x301
    InvalidRole              : QMessageBox = ... # -0x1
    AcceptRole               : QMessageBox = ... # 0x0
    NoButton                 : QMessageBox = ... # 0x0
    NoIcon                   : QMessageBox = ... # 0x0
    Information              : QMessageBox = ... # 0x1
    RejectRole               : QMessageBox = ... # 0x1
    DestructiveRole          : QMessageBox = ... # 0x2
    Warning                  : QMessageBox = ... # 0x2
    ActionRole               : QMessageBox = ... # 0x3
    Critical                 : QMessageBox = ... # 0x3
    HelpRole                 : QMessageBox = ... # 0x4
    Question                 : QMessageBox = ... # 0x4
    YesRole                  : QMessageBox = ... # 0x5
    NoRole                   : QMessageBox = ... # 0x6
    ResetRole                : QMessageBox = ... # 0x7
    ApplyRole                : QMessageBox = ... # 0x8
    NRoles                   : QMessageBox = ... # 0x9
    Default                  : QMessageBox = ... # 0x100
    Escape                   : QMessageBox = ... # 0x200
    FlagMask                 : QMessageBox = ... # 0x300
    FirstButton              : QMessageBox = ... # 0x400
    Ok                       : QMessageBox = ... # 0x400
    Save                     : QMessageBox = ... # 0x800
    SaveAll                  : QMessageBox = ... # 0x1000
    Open                     : QMessageBox = ... # 0x2000
    Yes                      : QMessageBox = ... # 0x4000
    YesAll                   : QMessageBox = ... # 0x8000
    YesToAll                 : QMessageBox = ... # 0x8000
    No                       : QMessageBox = ... # 0x10000
    NoAll                    : QMessageBox = ... # 0x20000
    NoToAll                  : QMessageBox = ... # 0x20000
    Abort                    : QMessageBox = ... # 0x40000
    Retry                    : QMessageBox = ... # 0x80000
    Ignore                   : QMessageBox = ... # 0x100000
    Close                    : QMessageBox = ... # 0x200000
    Cancel                   : QMessageBox = ... # 0x400000
    Discard                  : QMessageBox = ... # 0x800000
    Help                     : QMessageBox = ... # 0x1000000
    Apply                    : QMessageBox = ... # 0x2000000
    Reset                    : QMessageBox = ... # 0x4000000
    LastButton               : QMessageBox = ... # 0x8000000
    RestoreDefaults          : QMessageBox = ... # 0x8000000

    class ButtonRole(object):
        InvalidRole              : QMessageBox.ButtonRole = ... # -0x1
        AcceptRole               : QMessageBox.ButtonRole = ... # 0x0
        RejectRole               : QMessageBox.ButtonRole = ... # 0x1
        DestructiveRole          : QMessageBox.ButtonRole = ... # 0x2
        ActionRole               : QMessageBox.ButtonRole = ... # 0x3
        HelpRole                 : QMessageBox.ButtonRole = ... # 0x4
        YesRole                  : QMessageBox.ButtonRole = ... # 0x5
        NoRole                   : QMessageBox.ButtonRole = ... # 0x6
        ResetRole                : QMessageBox.ButtonRole = ... # 0x7
        ApplyRole                : QMessageBox.ButtonRole = ... # 0x8
        NRoles                   : QMessageBox.ButtonRole = ... # 0x9

    class Icon(object):
        NoIcon                   : QMessageBox.Icon = ... # 0x0
        Information              : QMessageBox.Icon = ... # 0x1
        Warning                  : QMessageBox.Icon = ... # 0x2
        Critical                 : QMessageBox.Icon = ... # 0x3
        Question                 : QMessageBox.Icon = ... # 0x4

    class StandardButton(object):
        ButtonMask               : QMessageBox.StandardButton = ... # -0x301
        NoButton                 : QMessageBox.StandardButton = ... # 0x0
        Default                  : QMessageBox.StandardButton = ... # 0x100
        Escape                   : QMessageBox.StandardButton = ... # 0x200
        FlagMask                 : QMessageBox.StandardButton = ... # 0x300
        FirstButton              : QMessageBox.StandardButton = ... # 0x400
        Ok                       : QMessageBox.StandardButton = ... # 0x400
        Save                     : QMessageBox.StandardButton = ... # 0x800
        SaveAll                  : QMessageBox.StandardButton = ... # 0x1000
        Open                     : QMessageBox.StandardButton = ... # 0x2000
        Yes                      : QMessageBox.StandardButton = ... # 0x4000
        YesAll                   : QMessageBox.StandardButton = ... # 0x8000
        YesToAll                 : QMessageBox.StandardButton = ... # 0x8000
        No                       : QMessageBox.StandardButton = ... # 0x10000
        NoAll                    : QMessageBox.StandardButton = ... # 0x20000
        NoToAll                  : QMessageBox.StandardButton = ... # 0x20000
        Abort                    : QMessageBox.StandardButton = ... # 0x40000
        Retry                    : QMessageBox.StandardButton = ... # 0x80000
        Ignore                   : QMessageBox.StandardButton = ... # 0x100000
        Close                    : QMessageBox.StandardButton = ... # 0x200000
        Cancel                   : QMessageBox.StandardButton = ... # 0x400000
        Discard                  : QMessageBox.StandardButton = ... # 0x800000
        Help                     : QMessageBox.StandardButton = ... # 0x1000000
        Apply                    : QMessageBox.StandardButton = ... # 0x2000000
        Reset                    : QMessageBox.StandardButton = ... # 0x4000000
        LastButton               : QMessageBox.StandardButton = ... # 0x8000000
        RestoreDefaults          : QMessageBox.StandardButton = ... # 0x8000000

    class StandardButtons(object): ...

    @typing.overload
    def __init__(self, icon:PySide2.QtWidgets.QMessageBox.Icon, title:str, text:str, buttons:PySide2.QtWidgets.QMessageBox.StandardButtons=..., parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., flags:PySide2.QtCore.Qt.WindowFlags=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    @staticmethod
    def about(parent:PySide2.QtWidgets.QWidget, title:str, text:str): ...
    @staticmethod
    def aboutQt(parent:PySide2.QtWidgets.QWidget, title:str=...): ...
    @typing.overload
    def addButton(self, button:PySide2.QtWidgets.QAbstractButton, role:PySide2.QtWidgets.QMessageBox.ButtonRole): ...
    @typing.overload
    def addButton(self, button:PySide2.QtWidgets.QMessageBox.StandardButton) -> PySide2.QtWidgets.QPushButton: ...
    @typing.overload
    def addButton(self, text:str, role:PySide2.QtWidgets.QMessageBox.ButtonRole) -> PySide2.QtWidgets.QPushButton: ...
    def button(self, which:PySide2.QtWidgets.QMessageBox.StandardButton) -> PySide2.QtWidgets.QAbstractButton: ...
    def buttonRole(self, button:PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QMessageBox.ButtonRole: ...
    def buttonText(self, button:int) -> str: ...
    def buttons(self) -> typing.List: ...
    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    def checkBox(self) -> PySide2.QtWidgets.QCheckBox: ...
    def clickedButton(self) -> PySide2.QtWidgets.QAbstractButton: ...
    def closeEvent(self, event:PySide2.QtGui.QCloseEvent): ...
    @typing.overload
    @staticmethod
    def critical(parent:PySide2.QtWidgets.QWidget, title:str, text:str, button0:PySide2.QtWidgets.QMessageBox.StandardButton, button1:PySide2.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @typing.overload
    @staticmethod
    def critical(parent:PySide2.QtWidgets.QWidget, title:str, text:str, buttons:PySide2.QtWidgets.QMessageBox.StandardButtons=..., defaultButton:PySide2.QtWidgets.QMessageBox.StandardButton=...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def defaultButton(self) -> PySide2.QtWidgets.QPushButton: ...
    def detailedText(self) -> str: ...
    def escapeButton(self) -> PySide2.QtWidgets.QAbstractButton: ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def icon(self) -> PySide2.QtWidgets.QMessageBox.Icon: ...
    def iconPixmap(self) -> PySide2.QtGui.QPixmap: ...
    @typing.overload
    @staticmethod
    def information(parent:PySide2.QtWidgets.QWidget, title:str, text:str, button0:PySide2.QtWidgets.QMessageBox.StandardButton, button1:PySide2.QtWidgets.QMessageBox.StandardButton=...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    @typing.overload
    @staticmethod
    def information(parent:PySide2.QtWidgets.QWidget, title:str, text:str, buttons:PySide2.QtWidgets.QMessageBox.StandardButtons=..., defaultButton:PySide2.QtWidgets.QMessageBox.StandardButton=...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def informativeText(self) -> str: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver:PySide2.QtCore.QObject, member:bytes): ...
    @typing.overload
    @staticmethod
    def question(parent:PySide2.QtWidgets.QWidget, title:str, text:str, button0:PySide2.QtWidgets.QMessageBox.StandardButton, button1:PySide2.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @typing.overload
    @staticmethod
    def question(parent:PySide2.QtWidgets.QWidget, title:str, text:str, buttons:PySide2.QtWidgets.QMessageBox.StandardButtons=..., defaultButton:PySide2.QtWidgets.QMessageBox.StandardButton=...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def removeButton(self, button:PySide2.QtWidgets.QAbstractButton): ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent): ...
    def setButtonText(self, button:int, text:str): ...
    def setCheckBox(self, cb:PySide2.QtWidgets.QCheckBox): ...
    @typing.overload
    def setDefaultButton(self, button:PySide2.QtWidgets.QMessageBox.StandardButton): ...
    @typing.overload
    def setDefaultButton(self, button:PySide2.QtWidgets.QPushButton): ...
    def setDetailedText(self, text:str): ...
    @typing.overload
    def setEscapeButton(self, button:PySide2.QtWidgets.QAbstractButton): ...
    @typing.overload
    def setEscapeButton(self, button:PySide2.QtWidgets.QMessageBox.StandardButton): ...
    def setIcon(self, arg__1:PySide2.QtWidgets.QMessageBox.Icon): ...
    def setIconPixmap(self, pixmap:PySide2.QtGui.QPixmap): ...
    def setInformativeText(self, text:str): ...
    def setStandardButtons(self, buttons:PySide2.QtWidgets.QMessageBox.StandardButtons): ...
    def setText(self, text:str): ...
    def setTextFormat(self, format:PySide2.QtCore.Qt.TextFormat): ...
    def setTextInteractionFlags(self, flags:PySide2.QtCore.Qt.TextInteractionFlags): ...
    def setWindowModality(self, windowModality:PySide2.QtCore.Qt.WindowModality): ...
    def setWindowTitle(self, title:str): ...
    def showEvent(self, event:PySide2.QtGui.QShowEvent): ...
    def standardButton(self, button:PySide2.QtWidgets.QAbstractButton) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...
    def standardButtons(self) -> PySide2.QtWidgets.QMessageBox.StandardButtons: ...
    @staticmethod
    def standardIcon(icon:PySide2.QtWidgets.QMessageBox.Icon) -> PySide2.QtGui.QPixmap: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    @typing.overload
    @staticmethod
    def warning(parent:PySide2.QtWidgets.QWidget, title:str, text:str, button0:PySide2.QtWidgets.QMessageBox.StandardButton, button1:PySide2.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @typing.overload
    @staticmethod
    def warning(parent:PySide2.QtWidgets.QWidget, title:str, text:str, buttons:PySide2.QtWidgets.QMessageBox.StandardButtons=..., defaultButton:PySide2.QtWidgets.QMessageBox.StandardButton=...) -> PySide2.QtWidgets.QMessageBox.StandardButton: ...


class QMouseEventTransition(PySide2.QtCore.QEventTransition):

    @typing.overload
    def __init__(self, object:PySide2.QtCore.QObject, type:PySide2.QtCore.QEvent.Type, button:PySide2.QtCore.Qt.MouseButton, sourceState:typing.Optional[PySide2.QtCore.QState]=...): ...
    @typing.overload
    def __init__(self, sourceState:typing.Optional[PySide2.QtCore.QState]=...): ...

    def button(self) -> PySide2.QtCore.Qt.MouseButton: ...
    def eventTest(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def hitTestPath(self) -> PySide2.QtGui.QPainterPath: ...
    def modifierMask(self) -> PySide2.QtCore.Qt.KeyboardModifiers: ...
    def onTransition(self, event:PySide2.QtCore.QEvent): ...
    def setButton(self, button:PySide2.QtCore.Qt.MouseButton): ...
    def setHitTestPath(self, path:PySide2.QtGui.QPainterPath): ...
    def setModifierMask(self, modifiers:PySide2.QtCore.Qt.KeyboardModifiers): ...


class QOpenGLWidget(PySide2.QtWidgets.QWidget):
    NoPartialUpdate          : QOpenGLWidget = ... # 0x0
    PartialUpdate            : QOpenGLWidget = ... # 0x1

    class UpdateBehavior(object):
        NoPartialUpdate          : QOpenGLWidget.UpdateBehavior = ... # 0x0
        PartialUpdate            : QOpenGLWidget.UpdateBehavior = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., f:PySide2.QtCore.Qt.WindowFlags=...): ...

    def context(self) -> PySide2.QtGui.QOpenGLContext: ...
    def defaultFramebufferObject(self) -> int: ...
    def doneCurrent(self): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def format(self) -> PySide2.QtGui.QSurfaceFormat: ...
    def grabFramebuffer(self) -> PySide2.QtGui.QImage: ...
    def initializeGL(self): ...
    def isValid(self) -> bool: ...
    def makeCurrent(self): ...
    def metric(self, metric:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, e:PySide2.QtGui.QPaintEvent): ...
    def paintGL(self): ...
    def redirected(self, p:PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def resizeEvent(self, e:PySide2.QtGui.QResizeEvent): ...
    def resizeGL(self, w:int, h:int): ...
    def setFormat(self, format:PySide2.QtGui.QSurfaceFormat): ...
    def setTextureFormat(self, texFormat:int): ...
    def setUpdateBehavior(self, updateBehavior:PySide2.QtWidgets.QOpenGLWidget.UpdateBehavior): ...
    def textureFormat(self) -> int: ...
    def updateBehavior(self) -> PySide2.QtWidgets.QOpenGLWidget.UpdateBehavior: ...


class QPanGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def acceleration(self) -> float: ...
    def delta(self) -> PySide2.QtCore.QPointF: ...
    def lastOffset(self) -> PySide2.QtCore.QPointF: ...
    def offset(self) -> PySide2.QtCore.QPointF: ...
    def setAcceleration(self, value:float): ...
    def setLastOffset(self, value:PySide2.QtCore.QPointF): ...
    def setOffset(self, value:PySide2.QtCore.QPointF): ...


class QPinchGesture(PySide2.QtWidgets.QGesture):
    ScaleFactorChanged       : QPinchGesture = ... # 0x1
    RotationAngleChanged     : QPinchGesture = ... # 0x2
    CenterPointChanged       : QPinchGesture = ... # 0x4

    class ChangeFlag(object):
        ScaleFactorChanged       : QPinchGesture.ChangeFlag = ... # 0x1
        RotationAngleChanged     : QPinchGesture.ChangeFlag = ... # 0x2
        CenterPointChanged       : QPinchGesture.ChangeFlag = ... # 0x4

    class ChangeFlags(object): ...

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def centerPoint(self) -> PySide2.QtCore.QPointF: ...
    def changeFlags(self) -> PySide2.QtWidgets.QPinchGesture.ChangeFlags: ...
    def lastCenterPoint(self) -> PySide2.QtCore.QPointF: ...
    def lastRotationAngle(self) -> float: ...
    def lastScaleFactor(self) -> float: ...
    def rotationAngle(self) -> float: ...
    def scaleFactor(self) -> float: ...
    def setCenterPoint(self, value:PySide2.QtCore.QPointF): ...
    def setChangeFlags(self, value:PySide2.QtWidgets.QPinchGesture.ChangeFlags): ...
    def setLastCenterPoint(self, value:PySide2.QtCore.QPointF): ...
    def setLastRotationAngle(self, value:float): ...
    def setLastScaleFactor(self, value:float): ...
    def setRotationAngle(self, value:float): ...
    def setScaleFactor(self, value:float): ...
    def setStartCenterPoint(self, value:PySide2.QtCore.QPointF): ...
    def setTotalChangeFlags(self, value:PySide2.QtWidgets.QPinchGesture.ChangeFlags): ...
    def setTotalRotationAngle(self, value:float): ...
    def setTotalScaleFactor(self, value:float): ...
    def startCenterPoint(self) -> PySide2.QtCore.QPointF: ...
    def totalChangeFlags(self) -> PySide2.QtWidgets.QPinchGesture.ChangeFlags: ...
    def totalRotationAngle(self) -> float: ...
    def totalScaleFactor(self) -> float: ...


class QPlainTextDocumentLayout(PySide2.QtGui.QAbstractTextDocumentLayout):

    def __init__(self, document:PySide2.QtGui.QTextDocument): ...

    def blockBoundingRect(self, block:PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def cursorWidth(self) -> int: ...
    def documentChanged(self, from_:int, arg__2:int, charsAdded:int): ...
    def documentSize(self) -> PySide2.QtCore.QSizeF: ...
    def draw(self, arg__1:PySide2.QtGui.QPainter, arg__2:PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext): ...
    def ensureBlockLayout(self, block:PySide2.QtGui.QTextBlock): ...
    def frameBoundingRect(self, arg__1:PySide2.QtGui.QTextFrame) -> PySide2.QtCore.QRectF: ...
    def hitTest(self, arg__1:PySide2.QtCore.QPointF, arg__2:PySide2.QtCore.Qt.HitTestAccuracy) -> int: ...
    def pageCount(self) -> int: ...
    def requestUpdate(self): ...
    def setCursorWidth(self, width:int): ...


class QPlainTextEdit(PySide2.QtWidgets.QAbstractScrollArea):
    NoWrap                   : QPlainTextEdit = ... # 0x0
    WidgetWidth              : QPlainTextEdit = ... # 0x1

    class LineWrapMode(object):
        NoWrap                   : QPlainTextEdit.LineWrapMode = ... # 0x0
        WidgetWidth              : QPlainTextEdit.LineWrapMode = ... # 0x1

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def anchorAt(self, pos:PySide2.QtCore.QPoint) -> str: ...
    def appendHtml(self, html:str): ...
    def appendPlainText(self, text:str): ...
    def backgroundVisible(self) -> bool: ...
    def blockBoundingGeometry(self, block:PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def blockBoundingRect(self, block:PySide2.QtGui.QTextBlock) -> PySide2.QtCore.QRectF: ...
    def blockCount(self) -> int: ...
    def canInsertFromMimeData(self, source:PySide2.QtCore.QMimeData) -> bool: ...
    def canPaste(self) -> bool: ...
    def centerCursor(self): ...
    def centerOnScroll(self) -> bool: ...
    def changeEvent(self, e:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def contentOffset(self) -> PySide2.QtCore.QPointF: ...
    def contextMenuEvent(self, e:PySide2.QtGui.QContextMenuEvent): ...
    def copy(self): ...
    def createMimeDataFromSelection(self) -> PySide2.QtCore.QMimeData: ...
    @typing.overload
    def createStandardContextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def createStandardContextMenu(self, position:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QMenu: ...
    def currentCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def cursorForPosition(self, pos:PySide2.QtCore.QPoint) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def cursorRect(self, cursor:PySide2.QtGui.QTextCursor) -> PySide2.QtCore.QRect: ...
    def cursorWidth(self) -> int: ...
    def cut(self): ...
    def doSetTextCursor(self, cursor:PySide2.QtGui.QTextCursor): ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def documentTitle(self) -> str: ...
    def dragEnterEvent(self, e:PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, e:PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, e:PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, e:PySide2.QtGui.QDropEvent): ...
    def ensureCursorVisible(self): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def extraSelections(self) -> typing.List: ...
    @typing.overload
    def find(self, exp:PySide2.QtCore.QRegExp, options:PySide2.QtGui.QTextDocument.FindFlags=...) -> bool: ...
    @typing.overload
    def find(self, exp:PySide2.QtCore.QRegularExpression, options:PySide2.QtGui.QTextDocument.FindFlags=...) -> bool: ...
    @typing.overload
    def find(self, exp:str, options:PySide2.QtGui.QTextDocument.FindFlags=...) -> bool: ...
    def firstVisibleBlock(self) -> PySide2.QtGui.QTextBlock: ...
    def focusInEvent(self, e:PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def focusOutEvent(self, e:PySide2.QtGui.QFocusEvent): ...
    def getPaintContext(self) -> PySide2.QtGui.QAbstractTextDocumentLayout.PaintContext: ...
    def inputMethodEvent(self, arg__1:PySide2.QtGui.QInputMethodEvent): ...
    @typing.overload
    def inputMethodQuery(self, property:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query:PySide2.QtCore.Qt.InputMethodQuery, argument:typing.Any) -> typing.Any: ...
    def insertFromMimeData(self, source:PySide2.QtCore.QMimeData): ...
    def insertPlainText(self, text:str): ...
    def isReadOnly(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def keyPressEvent(self, e:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, e:PySide2.QtGui.QKeyEvent): ...
    def lineWrapMode(self) -> PySide2.QtWidgets.QPlainTextEdit.LineWrapMode: ...
    def loadResource(self, type:int, name:PySide2.QtCore.QUrl) -> typing.Any: ...
    def maximumBlockCount(self) -> int: ...
    def mergeCurrentCharFormat(self, modifier:PySide2.QtGui.QTextCharFormat): ...
    def mouseDoubleClickEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, operation:PySide2.QtGui.QTextCursor.MoveOperation, mode:PySide2.QtGui.QTextCursor.MoveMode=...): ...
    def overwriteMode(self) -> bool: ...
    def paintEvent(self, e:PySide2.QtGui.QPaintEvent): ...
    def paste(self): ...
    def placeholderText(self) -> str: ...
    def print_(self, printer:PySide2.QtGui.QPagedPaintDevice): ...
    def redo(self): ...
    def resizeEvent(self, e:PySide2.QtGui.QResizeEvent): ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def selectAll(self): ...
    def setBackgroundVisible(self, visible:bool): ...
    def setCenterOnScroll(self, enabled:bool): ...
    def setCurrentCharFormat(self, format:PySide2.QtGui.QTextCharFormat): ...
    def setCursorWidth(self, width:int): ...
    def setDocument(self, document:PySide2.QtGui.QTextDocument): ...
    def setDocumentTitle(self, title:str): ...
    def setExtraSelections(self, selections:typing.Sequence): ...
    def setLineWrapMode(self, mode:PySide2.QtWidgets.QPlainTextEdit.LineWrapMode): ...
    def setMaximumBlockCount(self, maximum:int): ...
    def setOverwriteMode(self, overwrite:bool): ...
    def setPlaceholderText(self, placeholderText:str): ...
    def setPlainText(self, text:str): ...
    def setReadOnly(self, ro:bool): ...
    def setTabChangesFocus(self, b:bool): ...
    def setTabStopDistance(self, distance:float): ...
    def setTabStopWidth(self, width:int): ...
    def setTextCursor(self, cursor:PySide2.QtGui.QTextCursor): ...
    def setTextInteractionFlags(self, flags:PySide2.QtCore.Qt.TextInteractionFlags): ...
    def setUndoRedoEnabled(self, enable:bool): ...
    def setWordWrapMode(self, policy:PySide2.QtGui.QTextOption.WrapMode): ...
    def showEvent(self, arg__1:PySide2.QtGui.QShowEvent): ...
    def tabChangesFocus(self) -> bool: ...
    def tabStopDistance(self) -> float: ...
    def tabStopWidth(self) -> int: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def timerEvent(self, e:PySide2.QtCore.QTimerEvent): ...
    def toPlainText(self) -> str: ...
    def undo(self): ...
    def wheelEvent(self, e:PySide2.QtGui.QWheelEvent): ...
    def wordWrapMode(self) -> PySide2.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, range:int=...): ...
    def zoomInF(self, range:float): ...
    def zoomOut(self, range:int=...): ...


class QProgressBar(PySide2.QtWidgets.QWidget):
    TopToBottom              : QProgressBar = ... # 0x0
    BottomToTop              : QProgressBar = ... # 0x1

    class Direction(object):
        TopToBottom              : QProgressBar.Direction = ... # 0x0
        BottomToTop              : QProgressBar.Direction = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def format(self) -> str: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionProgressBar): ...
    def invertedAppearance(self) -> bool: ...
    def isTextVisible(self) -> bool: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def reset(self): ...
    def resetFormat(self): ...
    def setAlignment(self, alignment:PySide2.QtCore.Qt.Alignment): ...
    def setFormat(self, format:str): ...
    def setInvertedAppearance(self, invert:bool): ...
    def setMaximum(self, maximum:int): ...
    def setMinimum(self, minimum:int): ...
    def setOrientation(self, arg__1:PySide2.QtCore.Qt.Orientation): ...
    def setRange(self, minimum:int, maximum:int): ...
    def setTextDirection(self, textDirection:PySide2.QtWidgets.QProgressBar.Direction): ...
    def setTextVisible(self, visible:bool): ...
    def setValue(self, value:int): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def text(self) -> str: ...
    def textDirection(self) -> PySide2.QtWidgets.QProgressBar.Direction: ...
    def value(self) -> int: ...


class QProgressDialog(PySide2.QtWidgets.QDialog):

    @typing.overload
    def __init__(self, labelText:str, cancelButtonText:str, minimum:int, maximum:int, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., flags:PySide2.QtCore.Qt.WindowFlags=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., flags:PySide2.QtCore.Qt.WindowFlags=...): ...

    def autoClose(self) -> bool: ...
    def autoReset(self) -> bool: ...
    def cancel(self): ...
    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    def closeEvent(self, event:PySide2.QtGui.QCloseEvent): ...
    def forceShow(self): ...
    def labelText(self) -> str: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def minimumDuration(self) -> int: ...
    @typing.overload
    def open(self): ...
    @typing.overload
    def open(self, receiver:PySide2.QtCore.QObject, member:bytes): ...
    def reset(self): ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent): ...
    def setAutoClose(self, close:bool): ...
    def setAutoReset(self, reset:bool): ...
    def setBar(self, bar:PySide2.QtWidgets.QProgressBar): ...
    def setCancelButton(self, button:PySide2.QtWidgets.QPushButton): ...
    def setCancelButtonText(self, text:str): ...
    def setLabel(self, label:PySide2.QtWidgets.QLabel): ...
    def setLabelText(self, text:str): ...
    def setMaximum(self, maximum:int): ...
    def setMinimum(self, minimum:int): ...
    def setMinimumDuration(self, ms:int): ...
    def setRange(self, minimum:int, maximum:int): ...
    def setValue(self, progress:int): ...
    def showEvent(self, event:PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def value(self) -> int: ...
    def wasCanceled(self) -> bool: ...


class QProxyStyle(PySide2.QtWidgets.QCommonStyle):

    @typing.overload
    def __init__(self, key:str): ...
    @typing.overload
    def __init__(self, style:typing.Optional[PySide2.QtWidgets.QStyle]=...): ...

    def baseStyle(self) -> PySide2.QtWidgets.QStyle: ...
    def drawComplexControl(self, control:PySide2.QtWidgets.QStyle.ComplexControl, option:PySide2.QtWidgets.QStyleOptionComplex, painter:PySide2.QtGui.QPainter, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def drawControl(self, element:PySide2.QtWidgets.QStyle.ControlElement, option:PySide2.QtWidgets.QStyleOption, painter:PySide2.QtGui.QPainter, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def drawItemPixmap(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRect, alignment:int, pixmap:PySide2.QtGui.QPixmap): ...
    def drawItemText(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRect, flags:int, pal:PySide2.QtGui.QPalette, enabled:bool, text:str, textRole:PySide2.QtGui.QPalette.ColorRole=...): ...
    def drawPrimitive(self, element:PySide2.QtWidgets.QStyle.PrimitiveElement, option:PySide2.QtWidgets.QStyleOption, painter:PySide2.QtGui.QPainter, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def generatedIconPixmap(self, iconMode:PySide2.QtGui.QIcon.Mode, pixmap:PySide2.QtGui.QPixmap, opt:PySide2.QtWidgets.QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def hitTestComplexControl(self, control:PySide2.QtWidgets.QStyle.ComplexControl, option:PySide2.QtWidgets.QStyleOptionComplex, pos:PySide2.QtCore.QPoint, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtWidgets.QStyle.SubControl: ...
    def itemPixmapRect(self, r:PySide2.QtCore.QRect, flags:int, pixmap:PySide2.QtGui.QPixmap) -> PySide2.QtCore.QRect: ...
    def itemTextRect(self, fm:PySide2.QtGui.QFontMetrics, r:PySide2.QtCore.QRect, flags:int, enabled:bool, text:str) -> PySide2.QtCore.QRect: ...
    def layoutSpacing(self, control1:PySide2.QtWidgets.QSizePolicy.ControlType, control2:PySide2.QtWidgets.QSizePolicy.ControlType, orientation:PySide2.QtCore.Qt.Orientation, option:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> int: ...
    def pixelMetric(self, metric:PySide2.QtWidgets.QStyle.PixelMetric, option:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> int: ...
    @typing.overload
    def polish(self, app:PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def polish(self, pal:PySide2.QtGui.QPalette): ...
    @typing.overload
    def polish(self, widget:PySide2.QtWidgets.QWidget): ...
    def setBaseStyle(self, style:PySide2.QtWidgets.QStyle): ...
    def sizeFromContents(self, type:PySide2.QtWidgets.QStyle.ContentsType, option:PySide2.QtWidgets.QStyleOption, size:PySide2.QtCore.QSize, widget:PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QSize: ...
    def standardIcon(self, standardIcon:PySide2.QtWidgets.QStyle.StandardPixmap, option:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtGui.QIcon: ...
    def standardPalette(self) -> PySide2.QtGui.QPalette: ...
    def standardPixmap(self, standardPixmap:PySide2.QtWidgets.QStyle.StandardPixmap, opt:PySide2.QtWidgets.QStyleOption, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtGui.QPixmap: ...
    def styleHint(self, hint:PySide2.QtWidgets.QStyle.StyleHint, option:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=..., returnData:typing.Optional[PySide2.QtWidgets.QStyleHintReturn]=...) -> int: ...
    def subControlRect(self, cc:PySide2.QtWidgets.QStyle.ComplexControl, opt:PySide2.QtWidgets.QStyleOptionComplex, sc:PySide2.QtWidgets.QStyle.SubControl, widget:PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRect: ...
    def subElementRect(self, element:PySide2.QtWidgets.QStyle.SubElement, option:PySide2.QtWidgets.QStyleOption, widget:PySide2.QtWidgets.QWidget) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, app:PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def unpolish(self, application:PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def unpolish(self, widget:PySide2.QtWidgets.QWidget): ...


class QPushButton(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, icon:PySide2.QtGui.QIcon, text:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def autoDefault(self) -> bool: ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1:PySide2.QtGui.QFocusEvent): ...
    def focusOutEvent(self, arg__1:PySide2.QtGui.QFocusEvent): ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionButton): ...
    def isDefault(self) -> bool: ...
    def isFlat(self) -> bool: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent): ...
    def menu(self) -> PySide2.QtWidgets.QMenu: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def setAutoDefault(self, arg__1:bool): ...
    def setDefault(self, arg__1:bool): ...
    def setFlat(self, arg__1:bool): ...
    def setMenu(self, menu:PySide2.QtWidgets.QMenu): ...
    def showMenu(self): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QRadioButton(PySide2.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, arg__1:PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, button:PySide2.QtWidgets.QStyleOptionButton): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QRubberBand(PySide2.QtWidgets.QWidget):
    Line                     : QRubberBand = ... # 0x0
    Rectangle                : QRubberBand = ... # 0x1

    class Shape(object):
        Line                     : QRubberBand.Shape = ... # 0x0
        Rectangle                : QRubberBand.Shape = ... # 0x1

    def __init__(self, arg__1:PySide2.QtWidgets.QRubberBand.Shape, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionRubberBand): ...
    @typing.overload
    def move(self, p:PySide2.QtCore.QPoint): ...
    @typing.overload
    def move(self, x:int, y:int): ...
    def moveEvent(self, arg__1:PySide2.QtGui.QMoveEvent): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    @typing.overload
    def resize(self, s:PySide2.QtCore.QSize): ...
    @typing.overload
    def resize(self, w:int, h:int): ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent): ...
    @typing.overload
    def setGeometry(self, r:PySide2.QtCore.QRect): ...
    @typing.overload
    def setGeometry(self, x:int, y:int, w:int, h:int): ...
    def shape(self) -> PySide2.QtWidgets.QRubberBand.Shape: ...
    def showEvent(self, arg__1:PySide2.QtGui.QShowEvent): ...


class QScrollArea(PySide2.QtWidgets.QAbstractScrollArea):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def ensureVisible(self, x:int, y:int, xmargin:int=..., ymargin:int=...): ...
    def ensureWidgetVisible(self, childWidget:PySide2.QtWidgets.QWidget, xmargin:int=..., ymargin:int=...): ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1:PySide2.QtCore.QObject, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent): ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def setAlignment(self, arg__1:PySide2.QtCore.Qt.Alignment): ...
    def setWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def setWidgetResizable(self, resizable:bool): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def takeWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    def widgetResizable(self) -> bool: ...


class QScrollBar(PySide2.QtWidgets.QAbstractSlider):

    @typing.overload
    def __init__(self, arg__1:PySide2.QtCore.Qt.Orientation, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def contextMenuEvent(self, arg__1:PySide2.QtGui.QContextMenuEvent): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def hideEvent(self, arg__1:PySide2.QtGui.QHideEvent): ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionSlider): ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sliderChange(self, change:PySide2.QtWidgets.QAbstractSlider.SliderChange): ...
    def wheelEvent(self, arg__1:PySide2.QtGui.QWheelEvent): ...


class QScroller(PySide2.QtCore.QObject):
    Inactive                 : QScroller = ... # 0x0
    TouchGesture             : QScroller = ... # 0x0
    InputPress               : QScroller = ... # 0x1
    LeftMouseButtonGesture   : QScroller = ... # 0x1
    Pressed                  : QScroller = ... # 0x1
    Dragging                 : QScroller = ... # 0x2
    InputMove                : QScroller = ... # 0x2
    RightMouseButtonGesture  : QScroller = ... # 0x2
    InputRelease             : QScroller = ... # 0x3
    MiddleMouseButtonGesture : QScroller = ... # 0x3
    Scrolling                : QScroller = ... # 0x3

    class Input(object):
        InputPress               : QScroller.Input = ... # 0x1
        InputMove                : QScroller.Input = ... # 0x2
        InputRelease             : QScroller.Input = ... # 0x3

    class ScrollerGestureType(object):
        TouchGesture             : QScroller.ScrollerGestureType = ... # 0x0
        LeftMouseButtonGesture   : QScroller.ScrollerGestureType = ... # 0x1
        RightMouseButtonGesture  : QScroller.ScrollerGestureType = ... # 0x2
        MiddleMouseButtonGesture : QScroller.ScrollerGestureType = ... # 0x3

    class State(object):
        Inactive                 : QScroller.State = ... # 0x0
        Pressed                  : QScroller.State = ... # 0x1
        Dragging                 : QScroller.State = ... # 0x2
        Scrolling                : QScroller.State = ... # 0x3
    @staticmethod
    def activeScrollers() -> typing.List: ...
    @typing.overload
    def ensureVisible(self, rect:PySide2.QtCore.QRectF, xmargin:float, ymargin:float): ...
    @typing.overload
    def ensureVisible(self, rect:PySide2.QtCore.QRectF, xmargin:float, ymargin:float, scrollTime:int): ...
    def finalPosition(self) -> PySide2.QtCore.QPointF: ...
    @staticmethod
    def grabGesture(target:PySide2.QtCore.QObject, gestureType:PySide2.QtWidgets.QScroller.ScrollerGestureType=...) -> PySide2.QtCore.Qt.GestureType: ...
    @staticmethod
    def grabbedGesture(target:PySide2.QtCore.QObject) -> PySide2.QtCore.Qt.GestureType: ...
    def handleInput(self, input:PySide2.QtWidgets.QScroller.Input, position:PySide2.QtCore.QPointF, timestamp:int=...) -> bool: ...
    @staticmethod
    def hasScroller(target:PySide2.QtCore.QObject) -> bool: ...
    def pixelPerMeter(self) -> PySide2.QtCore.QPointF: ...
    def resendPrepareEvent(self): ...
    @typing.overload
    def scrollTo(self, pos:PySide2.QtCore.QPointF): ...
    @typing.overload
    def scrollTo(self, pos:PySide2.QtCore.QPointF, scrollTime:int): ...
    @staticmethod
    def scroller(target:PySide2.QtCore.QObject) -> PySide2.QtWidgets.QScroller: ...
    def scrollerProperties(self) -> PySide2.QtWidgets.QScrollerProperties: ...
    def setScrollerProperties(self, prop:PySide2.QtWidgets.QScrollerProperties): ...
    @typing.overload
    def setSnapPositionsX(self, first:float, interval:float): ...
    @typing.overload
    def setSnapPositionsX(self, positions:typing.Sequence): ...
    @typing.overload
    def setSnapPositionsY(self, first:float, interval:float): ...
    @typing.overload
    def setSnapPositionsY(self, positions:typing.Sequence): ...
    def state(self) -> PySide2.QtWidgets.QScroller.State: ...
    def stop(self): ...
    def target(self) -> PySide2.QtCore.QObject: ...
    @staticmethod
    def ungrabGesture(target:PySide2.QtCore.QObject): ...
    def velocity(self) -> PySide2.QtCore.QPointF: ...


class QScrollerProperties(Shiboken.Object):
    MousePressEventDelay     : QScrollerProperties = ... # 0x0
    OvershootWhenScrollable  : QScrollerProperties = ... # 0x0
    Standard                 : QScrollerProperties = ... # 0x0
    DragStartDistance        : QScrollerProperties = ... # 0x1
    Fps60                    : QScrollerProperties = ... # 0x1
    OvershootAlwaysOff       : QScrollerProperties = ... # 0x1
    DragVelocitySmoothingFactor: QScrollerProperties = ... # 0x2
    Fps30                    : QScrollerProperties = ... # 0x2
    OvershootAlwaysOn        : QScrollerProperties = ... # 0x2
    AxisLockThreshold        : QScrollerProperties = ... # 0x3
    Fps20                    : QScrollerProperties = ... # 0x3
    ScrollingCurve           : QScrollerProperties = ... # 0x4
    DecelerationFactor       : QScrollerProperties = ... # 0x5
    MinimumVelocity          : QScrollerProperties = ... # 0x6
    MaximumVelocity          : QScrollerProperties = ... # 0x7
    MaximumClickThroughVelocity: QScrollerProperties = ... # 0x8
    AcceleratingFlickMaximumTime: QScrollerProperties = ... # 0x9
    AcceleratingFlickSpeedupFactor: QScrollerProperties = ... # 0xa
    SnapPositionRatio        : QScrollerProperties = ... # 0xb
    SnapTime                 : QScrollerProperties = ... # 0xc
    OvershootDragResistanceFactor: QScrollerProperties = ... # 0xd
    OvershootDragDistanceFactor: QScrollerProperties = ... # 0xe
    OvershootScrollDistanceFactor: QScrollerProperties = ... # 0xf
    OvershootScrollTime      : QScrollerProperties = ... # 0x10
    HorizontalOvershootPolicy: QScrollerProperties = ... # 0x11
    VerticalOvershootPolicy  : QScrollerProperties = ... # 0x12
    FrameRate                : QScrollerProperties = ... # 0x13
    ScrollMetricCount        : QScrollerProperties = ... # 0x14

    class FrameRates(object):
        Standard                 : QScrollerProperties.FrameRates = ... # 0x0
        Fps60                    : QScrollerProperties.FrameRates = ... # 0x1
        Fps30                    : QScrollerProperties.FrameRates = ... # 0x2
        Fps20                    : QScrollerProperties.FrameRates = ... # 0x3

    class OvershootPolicy(object):
        OvershootWhenScrollable  : QScrollerProperties.OvershootPolicy = ... # 0x0
        OvershootAlwaysOff       : QScrollerProperties.OvershootPolicy = ... # 0x1
        OvershootAlwaysOn        : QScrollerProperties.OvershootPolicy = ... # 0x2

    class ScrollMetric(object):
        MousePressEventDelay     : QScrollerProperties.ScrollMetric = ... # 0x0
        DragStartDistance        : QScrollerProperties.ScrollMetric = ... # 0x1
        DragVelocitySmoothingFactor: QScrollerProperties.ScrollMetric = ... # 0x2
        AxisLockThreshold        : QScrollerProperties.ScrollMetric = ... # 0x3
        ScrollingCurve           : QScrollerProperties.ScrollMetric = ... # 0x4
        DecelerationFactor       : QScrollerProperties.ScrollMetric = ... # 0x5
        MinimumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x6
        MaximumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x7
        MaximumClickThroughVelocity: QScrollerProperties.ScrollMetric = ... # 0x8
        AcceleratingFlickMaximumTime: QScrollerProperties.ScrollMetric = ... # 0x9
        AcceleratingFlickSpeedupFactor: QScrollerProperties.ScrollMetric = ... # 0xa
        SnapPositionRatio        : QScrollerProperties.ScrollMetric = ... # 0xb
        SnapTime                 : QScrollerProperties.ScrollMetric = ... # 0xc
        OvershootDragResistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xd
        OvershootDragDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xe
        OvershootScrollDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xf
        OvershootScrollTime      : QScrollerProperties.ScrollMetric = ... # 0x10
        HorizontalOvershootPolicy: QScrollerProperties.ScrollMetric = ... # 0x11
        VerticalOvershootPolicy  : QScrollerProperties.ScrollMetric = ... # 0x12
        FrameRate                : QScrollerProperties.ScrollMetric = ... # 0x13
        ScrollMetricCount        : QScrollerProperties.ScrollMetric = ... # 0x14

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, sp:PySide2.QtWidgets.QScrollerProperties): ...

    def __copy__(self): ...
    def scrollMetric(self, metric:PySide2.QtWidgets.QScrollerProperties.ScrollMetric) -> typing.Any: ...
    @staticmethod
    def setDefaultScrollerProperties(sp:PySide2.QtWidgets.QScrollerProperties): ...
    def setScrollMetric(self, metric:PySide2.QtWidgets.QScrollerProperties.ScrollMetric, value:typing.Any): ...
    @staticmethod
    def unsetDefaultScrollerProperties(): ...


class QShortcut(PySide2.QtCore.QObject):

    @typing.overload
    def __init__(self, arg__1:PySide2.QtGui.QKeySequence, arg__2:PySide2.QtWidgets.QWidget, arg__3:typing.Callable, arg__4:PySide2.QtCore.Qt.ShortcutContext=...): ...
    @typing.overload
    def __init__(self, key:PySide2.QtGui.QKeySequence, parent:PySide2.QtWidgets.QWidget, member:typing.Optional[bytes]=..., ambiguousMember:typing.Optional[bytes]=..., context:PySide2.QtCore.Qt.ShortcutContext=...): ...
    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QWidget): ...

    def autoRepeat(self) -> bool: ...
    def context(self) -> PySide2.QtCore.Qt.ShortcutContext: ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def id(self) -> int: ...
    def isEnabled(self) -> bool: ...
    def key(self) -> PySide2.QtGui.QKeySequence: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def setAutoRepeat(self, on:bool): ...
    def setContext(self, context:PySide2.QtCore.Qt.ShortcutContext): ...
    def setEnabled(self, enable:bool): ...
    def setKey(self, key:PySide2.QtGui.QKeySequence): ...
    def setWhatsThis(self, text:str): ...
    def whatsThis(self) -> str: ...


class QSizeGrip(PySide2.QtWidgets.QWidget):

    def __init__(self, parent:PySide2.QtWidgets.QWidget): ...

    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1:PySide2.QtCore.QObject, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    def hideEvent(self, hideEvent:PySide2.QtGui.QHideEvent): ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, mouseEvent:PySide2.QtGui.QMouseEvent): ...
    def moveEvent(self, moveEvent:PySide2.QtGui.QMoveEvent): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def setVisible(self, arg__1:bool): ...
    def showEvent(self, showEvent:PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...


class QSizePolicy(Shiboken.Object):
    Fixed                    : QSizePolicy = ... # 0x0
    DefaultType              : QSizePolicy = ... # 0x1
    GrowFlag                 : QSizePolicy = ... # 0x1
    Minimum                  : QSizePolicy = ... # 0x1
    ButtonBox                : QSizePolicy = ... # 0x2
    ExpandFlag               : QSizePolicy = ... # 0x2
    MinimumExpanding         : QSizePolicy = ... # 0x3
    CheckBox                 : QSizePolicy = ... # 0x4
    Maximum                  : QSizePolicy = ... # 0x4
    ShrinkFlag               : QSizePolicy = ... # 0x4
    Preferred                : QSizePolicy = ... # 0x5
    Expanding                : QSizePolicy = ... # 0x7
    ComboBox                 : QSizePolicy = ... # 0x8
    IgnoreFlag               : QSizePolicy = ... # 0x8
    Ignored                  : QSizePolicy = ... # 0xd
    Frame                    : QSizePolicy = ... # 0x10
    GroupBox                 : QSizePolicy = ... # 0x20
    Label                    : QSizePolicy = ... # 0x40
    Line                     : QSizePolicy = ... # 0x80
    LineEdit                 : QSizePolicy = ... # 0x100
    PushButton               : QSizePolicy = ... # 0x200
    RadioButton              : QSizePolicy = ... # 0x400
    Slider                   : QSizePolicy = ... # 0x800
    SpinBox                  : QSizePolicy = ... # 0x1000
    TabWidget                : QSizePolicy = ... # 0x2000
    ToolButton               : QSizePolicy = ... # 0x4000

    class ControlType(object):
        DefaultType              : QSizePolicy.ControlType = ... # 0x1
        ButtonBox                : QSizePolicy.ControlType = ... # 0x2
        CheckBox                 : QSizePolicy.ControlType = ... # 0x4
        ComboBox                 : QSizePolicy.ControlType = ... # 0x8
        Frame                    : QSizePolicy.ControlType = ... # 0x10
        GroupBox                 : QSizePolicy.ControlType = ... # 0x20
        Label                    : QSizePolicy.ControlType = ... # 0x40
        Line                     : QSizePolicy.ControlType = ... # 0x80
        LineEdit                 : QSizePolicy.ControlType = ... # 0x100
        PushButton               : QSizePolicy.ControlType = ... # 0x200
        RadioButton              : QSizePolicy.ControlType = ... # 0x400
        Slider                   : QSizePolicy.ControlType = ... # 0x800
        SpinBox                  : QSizePolicy.ControlType = ... # 0x1000
        TabWidget                : QSizePolicy.ControlType = ... # 0x2000
        ToolButton               : QSizePolicy.ControlType = ... # 0x4000

    class ControlTypes(object): ...

    class Policy(object):
        Fixed                    : QSizePolicy.Policy = ... # 0x0
        Minimum                  : QSizePolicy.Policy = ... # 0x1
        MinimumExpanding         : QSizePolicy.Policy = ... # 0x3
        Maximum                  : QSizePolicy.Policy = ... # 0x4
        Preferred                : QSizePolicy.Policy = ... # 0x5
        Expanding                : QSizePolicy.Policy = ... # 0x7
        Ignored                  : QSizePolicy.Policy = ... # 0xd

    class PolicyFlag(object):
        GrowFlag                 : QSizePolicy.PolicyFlag = ... # 0x1
        ExpandFlag               : QSizePolicy.PolicyFlag = ... # 0x2
        ShrinkFlag               : QSizePolicy.PolicyFlag = ... # 0x4
        IgnoreFlag               : QSizePolicy.PolicyFlag = ... # 0x8

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, horizontal:PySide2.QtWidgets.QSizePolicy.Policy, vertical:PySide2.QtWidgets.QSizePolicy.Policy, type:PySide2.QtWidgets.QSizePolicy.ControlType=...): ...

    def __copy__(self): ...
    def __lshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def controlType(self) -> PySide2.QtWidgets.QSizePolicy.ControlType: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def hasHeightForWidth(self) -> bool: ...
    def hasWidthForHeight(self) -> bool: ...
    def horizontalPolicy(self) -> PySide2.QtWidgets.QSizePolicy.Policy: ...
    def horizontalStretch(self) -> int: ...
    def retainSizeWhenHidden(self) -> bool: ...
    def setControlType(self, type:PySide2.QtWidgets.QSizePolicy.ControlType): ...
    def setHeightForWidth(self, b:bool): ...
    def setHorizontalPolicy(self, d:PySide2.QtWidgets.QSizePolicy.Policy): ...
    def setHorizontalStretch(self, stretchFactor:int): ...
    def setRetainSizeWhenHidden(self, retainSize:bool): ...
    def setVerticalPolicy(self, d:PySide2.QtWidgets.QSizePolicy.Policy): ...
    def setVerticalStretch(self, stretchFactor:int): ...
    def setWidthForHeight(self, b:bool): ...
    def transpose(self): ...
    def transposed(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def verticalPolicy(self) -> PySide2.QtWidgets.QSizePolicy.Policy: ...
    def verticalStretch(self) -> int: ...


class QSlider(PySide2.QtWidgets.QAbstractSlider):
    NoTicks                  : QSlider = ... # 0x0
    TicksAbove               : QSlider = ... # 0x1
    TicksLeft                : QSlider = ... # 0x1
    TicksBelow               : QSlider = ... # 0x2
    TicksRight               : QSlider = ... # 0x2
    TicksBothSides           : QSlider = ... # 0x3

    class TickPosition(object):
        NoTicks                  : QSlider.TickPosition = ... # 0x0
        TicksAbove               : QSlider.TickPosition = ... # 0x1
        TicksLeft                : QSlider.TickPosition = ... # 0x1
        TicksBelow               : QSlider.TickPosition = ... # 0x2
        TicksRight               : QSlider.TickPosition = ... # 0x2
        TicksBothSides           : QSlider.TickPosition = ... # 0x3

    @typing.overload
    def __init__(self, orientation:PySide2.QtCore.Qt.Orientation, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionSlider): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, ev:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, ev:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, ev:PySide2.QtGui.QMouseEvent): ...
    def paintEvent(self, ev:PySide2.QtGui.QPaintEvent): ...
    def setTickInterval(self, ti:int): ...
    def setTickPosition(self, position:PySide2.QtWidgets.QSlider.TickPosition): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def tickInterval(self) -> int: ...
    def tickPosition(self) -> PySide2.QtWidgets.QSlider.TickPosition: ...


class QSpacerItem(PySide2.QtWidgets.QLayoutItem):

    def __init__(self, w:int, h:int, hData:PySide2.QtWidgets.QSizePolicy.Policy=..., vData:PySide2.QtWidgets.QSizePolicy.Policy=...): ...

    def changeSize(self, w:int, h:int, hData:PySide2.QtWidgets.QSizePolicy.Policy=..., vData:PySide2.QtWidgets.QSizePolicy.Policy=...): ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def isEmpty(self) -> bool: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setGeometry(self, arg__1:PySide2.QtCore.QRect): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def spacerItem(self) -> PySide2.QtWidgets.QSpacerItem: ...


class QSpinBox(PySide2.QtWidgets.QAbstractSpinBox):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def cleanText(self) -> str: ...
    def displayIntegerBase(self) -> int: ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def fixup(self, str:str): ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def prefix(self) -> str: ...
    def setDisplayIntegerBase(self, base:int): ...
    def setMaximum(self, max:int): ...
    def setMinimum(self, min:int): ...
    def setPrefix(self, prefix:str): ...
    def setRange(self, min:int, max:int): ...
    def setSingleStep(self, val:int): ...
    def setStepType(self, stepType:PySide2.QtWidgets.QAbstractSpinBox.StepType): ...
    def setSuffix(self, suffix:str): ...
    def setValue(self, val:int): ...
    def singleStep(self) -> int: ...
    def stepType(self) -> PySide2.QtWidgets.QAbstractSpinBox.StepType: ...
    def suffix(self) -> str: ...
    def textFromValue(self, val:int) -> str: ...
    def validate(self, input:str, pos:int) -> PySide2.QtGui.QValidator.State: ...
    def value(self) -> int: ...
    def valueFromText(self, text:str) -> int: ...


class QSplashScreen(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QWidget, pixmap:PySide2.QtGui.QPixmap=..., f:PySide2.QtCore.Qt.WindowFlags=...): ...
    @typing.overload
    def __init__(self, pixmap:PySide2.QtGui.QPixmap=..., f:PySide2.QtCore.Qt.WindowFlags=...): ...

    def clearMessage(self): ...
    def drawContents(self, painter:PySide2.QtGui.QPainter): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def finish(self, w:PySide2.QtWidgets.QWidget): ...
    def message(self) -> str: ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def pixmap(self) -> PySide2.QtGui.QPixmap: ...
    def setPixmap(self, pixmap:PySide2.QtGui.QPixmap): ...
    def showMessage(self, message:str, alignment:int=..., color:PySide2.QtGui.QColor=...): ...


class QSplitter(PySide2.QtWidgets.QFrame):

    @typing.overload
    def __init__(self, arg__1:PySide2.QtCore.Qt.Orientation, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def __lshift__(self, arg__1:PySide2.QtCore.QTextStream) -> PySide2.QtCore.QTextStream: ...
    def __rshift__(self, arg__1:PySide2.QtCore.QTextStream) -> PySide2.QtCore.QTextStream: ...
    def addWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def childEvent(self, arg__1:PySide2.QtCore.QChildEvent): ...
    def childrenCollapsible(self) -> bool: ...
    def closestLegalPosition(self, arg__1:int, arg__2:int) -> int: ...
    def count(self) -> int: ...
    def createHandle(self) -> PySide2.QtWidgets.QSplitterHandle: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def getRange(self, index:int) -> typing.Tuple: ...
    def handle(self, index:int) -> PySide2.QtWidgets.QSplitterHandle: ...
    def handleWidth(self) -> int: ...
    def indexOf(self, w:PySide2.QtWidgets.QWidget) -> int: ...
    def insertWidget(self, index:int, widget:PySide2.QtWidgets.QWidget): ...
    def isCollapsible(self, index:int) -> bool: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def moveSplitter(self, pos:int, index:int): ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def refresh(self): ...
    def replaceWidget(self, index:int, widget:PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent): ...
    def restoreState(self, state:PySide2.QtCore.QByteArray) -> bool: ...
    def saveState(self) -> PySide2.QtCore.QByteArray: ...
    def setChildrenCollapsible(self, arg__1:bool): ...
    def setCollapsible(self, index:int, arg__2:bool): ...
    def setHandleWidth(self, arg__1:int): ...
    def setOpaqueResize(self, opaque:bool=...): ...
    def setOrientation(self, arg__1:PySide2.QtCore.Qt.Orientation): ...
    def setRubberBand(self, position:int): ...
    def setSizes(self, list:typing.Sequence): ...
    def setStretchFactor(self, index:int, stretch:int): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizes(self) -> typing.List: ...
    def widget(self, index:int) -> PySide2.QtWidgets.QWidget: ...


class QSplitterHandle(PySide2.QtWidgets.QWidget):

    def __init__(self, o:PySide2.QtCore.Qt.Orientation, parent:PySide2.QtWidgets.QSplitter): ...

    def closestLegalPosition(self, p:int) -> int: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def moveSplitter(self, p:int): ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent): ...
    def setOrientation(self, o:PySide2.QtCore.Qt.Orientation): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def splitter(self) -> PySide2.QtWidgets.QSplitter: ...


class QStackedLayout(PySide2.QtWidgets.QLayout):
    StackOne                 : QStackedLayout = ... # 0x0
    StackAll                 : QStackedLayout = ... # 0x1

    class StackingMode(object):
        StackOne                 : QStackedLayout.StackingMode = ... # 0x0
        StackAll                 : QStackedLayout.StackingMode = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def __init__(self, parentLayout:PySide2.QtWidgets.QLayout): ...

    def addItem(self, item:PySide2.QtWidgets.QLayoutItem): ...
    def addWidget(self, w:PySide2.QtWidgets.QWidget) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width:int) -> int: ...
    def insertWidget(self, index:int, w:PySide2.QtWidgets.QWidget) -> int: ...
    def itemAt(self, arg__1:int) -> PySide2.QtWidgets.QLayoutItem: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setCurrentIndex(self, index:int): ...
    def setCurrentWidget(self, w:PySide2.QtWidgets.QWidget): ...
    def setGeometry(self, rect:PySide2.QtCore.QRect): ...
    def setStackingMode(self, stackingMode:PySide2.QtWidgets.QStackedLayout.StackingMode): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def stackingMode(self) -> PySide2.QtWidgets.QStackedLayout.StackingMode: ...
    def takeAt(self, arg__1:int) -> PySide2.QtWidgets.QLayoutItem: ...
    @typing.overload
    def widget(self) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    def widget(self, arg__1:int) -> PySide2.QtWidgets.QWidget: ...


class QStackedWidget(PySide2.QtWidgets.QFrame):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def addWidget(self, w:PySide2.QtWidgets.QWidget) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def indexOf(self, arg__1:PySide2.QtWidgets.QWidget) -> int: ...
    def insertWidget(self, index:int, w:PySide2.QtWidgets.QWidget) -> int: ...
    def removeWidget(self, w:PySide2.QtWidgets.QWidget): ...
    def setCurrentIndex(self, index:int): ...
    def setCurrentWidget(self, w:PySide2.QtWidgets.QWidget): ...
    def widget(self, arg__1:int) -> PySide2.QtWidgets.QWidget: ...


class QStatusBar(PySide2.QtWidgets.QWidget):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def addPermanentWidget(self, widget:PySide2.QtWidgets.QWidget, stretch:int=...): ...
    def addWidget(self, widget:PySide2.QtWidgets.QWidget, stretch:int=...): ...
    def clearMessage(self): ...
    def currentMessage(self) -> str: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def hideOrShow(self): ...
    def insertPermanentWidget(self, index:int, widget:PySide2.QtWidgets.QWidget, stretch:int=...) -> int: ...
    def insertWidget(self, index:int, widget:PySide2.QtWidgets.QWidget, stretch:int=...) -> int: ...
    def isSizeGripEnabled(self) -> bool: ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def reformat(self): ...
    def removeWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent): ...
    def setSizeGripEnabled(self, arg__1:bool): ...
    def showEvent(self, arg__1:PySide2.QtGui.QShowEvent): ...
    def showMessage(self, text:str, timeout:int=...): ...


class QStyle(PySide2.QtCore.QObject):
    CC_CustomBase            : QStyle = ... # -0x10000000
    CE_CustomBase            : QStyle = ... # -0x10000000
    CT_CustomBase            : QStyle = ... # -0x10000000
    PM_CustomBase            : QStyle = ... # -0x10000000
    SC_CustomBase            : QStyle = ... # -0x10000000
    SE_CustomBase            : QStyle = ... # -0x10000000
    SH_CustomBase            : QStyle = ... # -0x10000000
    SP_CustomBase            : QStyle = ... # -0x10000000
    SC_All                   : QStyle = ... # -0x1
    CC_SpinBox               : QStyle = ... # 0x0
    CE_PushButton            : QStyle = ... # 0x0
    CT_PushButton            : QStyle = ... # 0x0
    PE_Frame                 : QStyle = ... # 0x0
    PM_ButtonMargin          : QStyle = ... # 0x0
    RSIP_OnMouseClickAndAlreadyFocused: QStyle = ... # 0x0
    SC_None                  : QStyle = ... # 0x0
    SE_PushButtonContents    : QStyle = ... # 0x0
    SH_EtchDisabledText      : QStyle = ... # 0x0
    SP_TitleBarMenuButton    : QStyle = ... # 0x0
    State_None               : QStyle = ... # 0x0
    CC_ComboBox              : QStyle = ... # 0x1
    CE_PushButtonBevel       : QStyle = ... # 0x1
    CT_CheckBox              : QStyle = ... # 0x1
    PE_FrameDefaultButton    : QStyle = ... # 0x1
    PM_ButtonDefaultIndicator: QStyle = ... # 0x1
    RSIP_OnMouseClick        : QStyle = ... # 0x1
    SC_ComboBoxFrame         : QStyle = ... # 0x1
    SC_DialGroove            : QStyle = ... # 0x1
    SC_GroupBoxCheckBox      : QStyle = ... # 0x1
    SC_MdiMinButton          : QStyle = ... # 0x1
    SC_ScrollBarAddLine      : QStyle = ... # 0x1
    SC_SliderGroove          : QStyle = ... # 0x1
    SC_SpinBoxUp             : QStyle = ... # 0x1
    SC_TitleBarSysMenu       : QStyle = ... # 0x1
    SC_ToolButton            : QStyle = ... # 0x1
    SE_PushButtonFocusRect   : QStyle = ... # 0x1
    SH_DitherDisabledText    : QStyle = ... # 0x1
    SP_TitleBarMinButton     : QStyle = ... # 0x1
    State_Enabled            : QStyle = ... # 0x1
    CC_ScrollBar             : QStyle = ... # 0x2
    CE_PushButtonLabel       : QStyle = ... # 0x2
    CT_RadioButton           : QStyle = ... # 0x2
    PE_FrameDockWidget       : QStyle = ... # 0x2
    PM_MenuButtonIndicator   : QStyle = ... # 0x2
    SC_ComboBoxEditField     : QStyle = ... # 0x2
    SC_DialHandle            : QStyle = ... # 0x2
    SC_GroupBoxLabel         : QStyle = ... # 0x2
    SC_MdiNormalButton       : QStyle = ... # 0x2
    SC_ScrollBarSubLine      : QStyle = ... # 0x2
    SC_SliderHandle          : QStyle = ... # 0x2
    SC_SpinBoxDown           : QStyle = ... # 0x2
    SC_TitleBarMinButton     : QStyle = ... # 0x2
    SC_ToolButtonMenu        : QStyle = ... # 0x2
    SE_CheckBoxIndicator     : QStyle = ... # 0x2
    SH_ScrollBar_MiddleClickAbsolutePosition: QStyle = ... # 0x2
    SP_TitleBarMaxButton     : QStyle = ... # 0x2
    State_Raised             : QStyle = ... # 0x2
    CC_Slider                : QStyle = ... # 0x3
    CE_CheckBox              : QStyle = ... # 0x3
    CT_ToolButton            : QStyle = ... # 0x3
    PE_FrameFocusRect        : QStyle = ... # 0x3
    PM_ButtonShiftHorizontal : QStyle = ... # 0x3
    SE_CheckBoxContents      : QStyle = ... # 0x3
    SH_ScrollBar_ScrollWhenPointerLeavesControl: QStyle = ... # 0x3
    SP_TitleBarCloseButton   : QStyle = ... # 0x3
    CC_ToolButton            : QStyle = ... # 0x4
    CE_CheckBoxLabel         : QStyle = ... # 0x4
    CT_ComboBox              : QStyle = ... # 0x4
    PE_FrameGroupBox         : QStyle = ... # 0x4
    PM_ButtonShiftVertical   : QStyle = ... # 0x4
    SC_ComboBoxArrow         : QStyle = ... # 0x4
    SC_DialTickmarks         : QStyle = ... # 0x4
    SC_GroupBoxContents      : QStyle = ... # 0x4
    SC_MdiCloseButton        : QStyle = ... # 0x4
    SC_ScrollBarAddPage      : QStyle = ... # 0x4
    SC_SliderTickmarks       : QStyle = ... # 0x4
    SC_SpinBoxFrame          : QStyle = ... # 0x4
    SC_TitleBarMaxButton     : QStyle = ... # 0x4
    SE_CheckBoxFocusRect     : QStyle = ... # 0x4
    SH_TabBar_SelectMouseType: QStyle = ... # 0x4
    SP_TitleBarNormalButton  : QStyle = ... # 0x4
    State_Sunken             : QStyle = ... # 0x4
    CC_TitleBar              : QStyle = ... # 0x5
    CE_RadioButton           : QStyle = ... # 0x5
    CT_Splitter              : QStyle = ... # 0x5
    PE_FrameLineEdit         : QStyle = ... # 0x5
    PM_DefaultFrameWidth     : QStyle = ... # 0x5
    SE_CheckBoxClickRect     : QStyle = ... # 0x5
    SH_TabBar_Alignment      : QStyle = ... # 0x5
    SP_TitleBarShadeButton   : QStyle = ... # 0x5
    CC_Dial                  : QStyle = ... # 0x6
    CE_RadioButtonLabel      : QStyle = ... # 0x6
    CT_ProgressBar           : QStyle = ... # 0x6
    PE_FrameMenu             : QStyle = ... # 0x6
    PM_SpinBoxFrameWidth     : QStyle = ... # 0x6
    SE_RadioButtonIndicator  : QStyle = ... # 0x6
    SH_Header_ArrowAlignment : QStyle = ... # 0x6
    SP_TitleBarUnshadeButton : QStyle = ... # 0x6
    CC_GroupBox              : QStyle = ... # 0x7
    CE_TabBarTab             : QStyle = ... # 0x7
    CT_MenuItem              : QStyle = ... # 0x7
    PE_FrameStatusBar        : QStyle = ... # 0x7
    PE_FrameStatusBarItem    : QStyle = ... # 0x7
    PM_ComboBoxFrameWidth    : QStyle = ... # 0x7
    SE_RadioButtonContents   : QStyle = ... # 0x7
    SH_Slider_SnapToValue    : QStyle = ... # 0x7
    SP_TitleBarContextHelpButton: QStyle = ... # 0x7
    CC_MdiControls           : QStyle = ... # 0x8
    CE_TabBarTabShape        : QStyle = ... # 0x8
    CT_MenuBarItem           : QStyle = ... # 0x8
    PE_FrameTabWidget        : QStyle = ... # 0x8
    PM_MaximumDragDistance   : QStyle = ... # 0x8
    SC_ComboBoxListBoxPopup  : QStyle = ... # 0x8
    SC_GroupBoxFrame         : QStyle = ... # 0x8
    SC_ScrollBarSubPage      : QStyle = ... # 0x8
    SC_SpinBoxEditField      : QStyle = ... # 0x8
    SC_TitleBarCloseButton   : QStyle = ... # 0x8
    SE_RadioButtonFocusRect  : QStyle = ... # 0x8
    SH_Slider_SloppyKeyEvents: QStyle = ... # 0x8
    SP_DockWidgetCloseButton : QStyle = ... # 0x8
    State_Off                : QStyle = ... # 0x8
    CE_TabBarTabLabel        : QStyle = ... # 0x9
    CT_MenuBar               : QStyle = ... # 0x9
    PE_FrameWindow           : QStyle = ... # 0x9
    PM_ScrollBarExtent       : QStyle = ... # 0x9
    SE_RadioButtonClickRect  : QStyle = ... # 0x9
    SH_ProgressDialog_CenterCancelButton: QStyle = ... # 0x9
    SP_MessageBoxInformation : QStyle = ... # 0x9
    CE_ProgressBar           : QStyle = ... # 0xa
    CT_Menu                  : QStyle = ... # 0xa
    PE_FrameButtonBevel      : QStyle = ... # 0xa
    PM_ScrollBarSliderMin    : QStyle = ... # 0xa
    SE_ComboBoxFocusRect     : QStyle = ... # 0xa
    SH_ProgressDialog_TextLabelAlignment: QStyle = ... # 0xa
    SP_MessageBoxWarning     : QStyle = ... # 0xa
    CE_ProgressBarGroove     : QStyle = ... # 0xb
    CT_TabBarTab             : QStyle = ... # 0xb
    PE_FrameButtonTool       : QStyle = ... # 0xb
    PM_SliderThickness       : QStyle = ... # 0xb
    SE_SliderFocusRect       : QStyle = ... # 0xb
    SH_PrintDialog_RightAlignButtons: QStyle = ... # 0xb
    SP_MessageBoxCritical    : QStyle = ... # 0xb
    CE_ProgressBarContents   : QStyle = ... # 0xc
    CT_Slider                : QStyle = ... # 0xc
    PE_FrameTabBarBase       : QStyle = ... # 0xc
    PM_SliderControlThickness: QStyle = ... # 0xc
    SE_ProgressBarGroove     : QStyle = ... # 0xc
    SH_MainWindow_SpaceBelowMenuBar: QStyle = ... # 0xc
    SP_MessageBoxQuestion    : QStyle = ... # 0xc
    CE_ProgressBarLabel      : QStyle = ... # 0xd
    CT_ScrollBar             : QStyle = ... # 0xd
    PE_PanelButtonCommand    : QStyle = ... # 0xd
    PM_SliderLength          : QStyle = ... # 0xd
    SE_ProgressBarContents   : QStyle = ... # 0xd
    SH_FontDialog_SelectAssociatedText: QStyle = ... # 0xd
    SP_DesktopIcon           : QStyle = ... # 0xd
    CE_MenuItem              : QStyle = ... # 0xe
    CT_LineEdit              : QStyle = ... # 0xe
    PE_PanelButtonBevel      : QStyle = ... # 0xe
    PM_SliderTickmarkOffset  : QStyle = ... # 0xe
    SE_ProgressBarLabel      : QStyle = ... # 0xe
    SH_Menu_AllowActiveAndDisabled: QStyle = ... # 0xe
    SP_TrashIcon             : QStyle = ... # 0xe
    CE_MenuScroller          : QStyle = ... # 0xf
    CT_SpinBox               : QStyle = ... # 0xf
    PE_PanelButtonTool       : QStyle = ... # 0xf
    PM_SliderSpaceAvailable  : QStyle = ... # 0xf
    SE_ToolBoxTabContents    : QStyle = ... # 0xf
    SH_Menu_SpaceActivatesItem: QStyle = ... # 0xf
    SP_ComputerIcon          : QStyle = ... # 0xf
    CE_MenuVMargin           : QStyle = ... # 0x10
    CT_SizeGrip              : QStyle = ... # 0x10
    PE_PanelMenuBar          : QStyle = ... # 0x10
    PM_DockWidgetSeparatorExtent: QStyle = ... # 0x10
    SC_ScrollBarFirst        : QStyle = ... # 0x10
    SC_TitleBarNormalButton  : QStyle = ... # 0x10
    SE_HeaderLabel           : QStyle = ... # 0x10
    SH_Menu_SubMenuPopupDelay: QStyle = ... # 0x10
    SP_DriveFDIcon           : QStyle = ... # 0x10
    State_NoChange           : QStyle = ... # 0x10
    CE_MenuHMargin           : QStyle = ... # 0x11
    CT_TabWidget             : QStyle = ... # 0x11
    PE_PanelToolBar          : QStyle = ... # 0x11
    PM_DockWidgetHandleExtent: QStyle = ... # 0x11
    SE_HeaderArrow           : QStyle = ... # 0x11
    SH_ScrollView_FrameOnlyAroundContents: QStyle = ... # 0x11
    SP_DriveHDIcon           : QStyle = ... # 0x11
    CE_MenuTearoff           : QStyle = ... # 0x12
    CT_DialogButtons         : QStyle = ... # 0x12
    PE_PanelLineEdit         : QStyle = ... # 0x12
    PM_DockWidgetFrameWidth  : QStyle = ... # 0x12
    SE_TabWidgetTabBar       : QStyle = ... # 0x12
    SH_MenuBar_AltKeyNavigation: QStyle = ... # 0x12
    SP_DriveCDIcon           : QStyle = ... # 0x12
    CE_MenuEmptyArea         : QStyle = ... # 0x13
    CT_HeaderSection         : QStyle = ... # 0x13
    PE_IndicatorArrowDown    : QStyle = ... # 0x13
    PM_TabBarTabOverlap      : QStyle = ... # 0x13
    SE_TabWidgetTabPane      : QStyle = ... # 0x13
    SH_ComboBox_ListMouseTracking: QStyle = ... # 0x13
    SP_DriveDVDIcon          : QStyle = ... # 0x13
    CE_MenuBarItem           : QStyle = ... # 0x14
    CT_GroupBox              : QStyle = ... # 0x14
    PE_IndicatorArrowLeft    : QStyle = ... # 0x14
    PM_TabBarTabHSpace       : QStyle = ... # 0x14
    SE_TabWidgetTabContents  : QStyle = ... # 0x14
    SH_Menu_MouseTracking    : QStyle = ... # 0x14
    SP_DriveNetIcon          : QStyle = ... # 0x14
    CE_MenuBarEmptyArea      : QStyle = ... # 0x15
    CT_MdiControls           : QStyle = ... # 0x15
    PE_IndicatorArrowRight   : QStyle = ... # 0x15
    PM_TabBarTabVSpace       : QStyle = ... # 0x15
    SE_TabWidgetLeftCorner   : QStyle = ... # 0x15
    SH_MenuBar_MouseTracking : QStyle = ... # 0x15
    SP_DirOpenIcon           : QStyle = ... # 0x15
    CE_ToolButtonLabel       : QStyle = ... # 0x16
    CT_ItemViewItem          : QStyle = ... # 0x16
    PE_IndicatorArrowUp      : QStyle = ... # 0x16
    PM_TabBarBaseHeight      : QStyle = ... # 0x16
    SE_TabWidgetRightCorner  : QStyle = ... # 0x16
    SH_ItemView_ChangeHighlightOnFocus: QStyle = ... # 0x16
    SP_DirClosedIcon         : QStyle = ... # 0x16
    CE_Header                : QStyle = ... # 0x17
    PE_IndicatorBranch       : QStyle = ... # 0x17
    PM_TabBarBaseOverlap     : QStyle = ... # 0x17
    SE_ItemViewItemCheckIndicator: QStyle = ... # 0x17
    SE_ViewItemCheckIndicator: QStyle = ... # 0x17
    SH_Widget_ShareActivation: QStyle = ... # 0x17
    SP_DirLinkIcon           : QStyle = ... # 0x17
    CE_HeaderSection         : QStyle = ... # 0x18
    PE_IndicatorButtonDropDown: QStyle = ... # 0x18
    PM_ProgressBarChunkWidth : QStyle = ... # 0x18
    SE_TabBarTearIndicator   : QStyle = ... # 0x18
    SE_TabBarTearIndicatorLeft: QStyle = ... # 0x18
    SH_Workspace_FillSpaceOnMaximize: QStyle = ... # 0x18
    SP_DirLinkOpenIcon       : QStyle = ... # 0x18
    CE_HeaderLabel           : QStyle = ... # 0x19
    PE_IndicatorItemViewItemCheck: QStyle = ... # 0x19
    PE_IndicatorViewItemCheck: QStyle = ... # 0x19
    PM_SplitterWidth         : QStyle = ... # 0x19
    SE_TreeViewDisclosureItem: QStyle = ... # 0x19
    SH_ComboBox_Popup        : QStyle = ... # 0x19
    SP_FileIcon              : QStyle = ... # 0x19
    CE_ToolBoxTab            : QStyle = ... # 0x1a
    PE_IndicatorCheckBox     : QStyle = ... # 0x1a
    PM_TitleBarHeight        : QStyle = ... # 0x1a
    SE_LineEditContents      : QStyle = ... # 0x1a
    SH_TitleBar_NoBorder     : QStyle = ... # 0x1a
    SP_FileLinkIcon          : QStyle = ... # 0x1a
    CE_SizeGrip              : QStyle = ... # 0x1b
    PE_IndicatorDockWidgetResizeHandle: QStyle = ... # 0x1b
    PM_MenuScrollerHeight    : QStyle = ... # 0x1b
    SE_FrameContents         : QStyle = ... # 0x1b
    SH_ScrollBar_StopMouseOverSlider: QStyle = ... # 0x1b
    SH_Slider_StopMouseOverSlider: QStyle = ... # 0x1b
    SP_ToolBarHorizontalExtensionButton: QStyle = ... # 0x1b
    CE_Splitter              : QStyle = ... # 0x1c
    PE_IndicatorHeaderArrow  : QStyle = ... # 0x1c
    PM_MenuHMargin           : QStyle = ... # 0x1c
    SE_DockWidgetCloseButton : QStyle = ... # 0x1c
    SH_BlinkCursorWhenTextSelected: QStyle = ... # 0x1c
    SP_ToolBarVerticalExtensionButton: QStyle = ... # 0x1c
    CE_RubberBand            : QStyle = ... # 0x1d
    PE_IndicatorMenuCheckMark: QStyle = ... # 0x1d
    PM_MenuVMargin           : QStyle = ... # 0x1d
    SE_DockWidgetFloatButton : QStyle = ... # 0x1d
    SH_RichText_FullWidthSelection: QStyle = ... # 0x1d
    SP_FileDialogStart       : QStyle = ... # 0x1d
    CE_DockWidgetTitle       : QStyle = ... # 0x1e
    PE_IndicatorProgressChunk: QStyle = ... # 0x1e
    PM_MenuPanelWidth        : QStyle = ... # 0x1e
    SE_DockWidgetTitleBarText: QStyle = ... # 0x1e
    SH_Menu_Scrollable       : QStyle = ... # 0x1e
    SP_FileDialogEnd         : QStyle = ... # 0x1e
    CE_ScrollBarAddLine      : QStyle = ... # 0x1f
    PE_IndicatorRadioButton  : QStyle = ... # 0x1f
    PM_MenuTearoffHeight     : QStyle = ... # 0x1f
    SE_DockWidgetIcon        : QStyle = ... # 0x1f
    SH_GroupBox_TextLabelVerticalAlignment: QStyle = ... # 0x1f
    SP_FileDialogToParent    : QStyle = ... # 0x1f
    CE_ScrollBarSubLine      : QStyle = ... # 0x20
    PE_IndicatorSpinDown     : QStyle = ... # 0x20
    PM_MenuDesktopFrameWidth : QStyle = ... # 0x20
    SC_ScrollBarLast         : QStyle = ... # 0x20
    SC_TitleBarShadeButton   : QStyle = ... # 0x20
    SE_CheckBoxLayoutItem    : QStyle = ... # 0x20
    SH_GroupBox_TextLabelColor: QStyle = ... # 0x20
    SP_FileDialogNewFolder   : QStyle = ... # 0x20
    State_On                 : QStyle = ... # 0x20
    CE_ScrollBarAddPage      : QStyle = ... # 0x21
    PE_IndicatorSpinMinus    : QStyle = ... # 0x21
    PM_MenuBarPanelWidth     : QStyle = ... # 0x21
    SE_ComboBoxLayoutItem    : QStyle = ... # 0x21
    SH_Menu_SloppySubMenus   : QStyle = ... # 0x21
    SP_FileDialogDetailedView: QStyle = ... # 0x21
    CE_ScrollBarSubPage      : QStyle = ... # 0x22
    PE_IndicatorSpinPlus     : QStyle = ... # 0x22
    PM_MenuBarItemSpacing    : QStyle = ... # 0x22
    SE_DateTimeEditLayoutItem: QStyle = ... # 0x22
    SH_Table_GridLineColor   : QStyle = ... # 0x22
    SP_FileDialogInfoView    : QStyle = ... # 0x22
    CE_ScrollBarSlider       : QStyle = ... # 0x23
    PE_IndicatorSpinUp       : QStyle = ... # 0x23
    PM_MenuBarVMargin        : QStyle = ... # 0x23
    SE_DialogButtonBoxLayoutItem: QStyle = ... # 0x23
    SH_LineEdit_PasswordCharacter: QStyle = ... # 0x23
    SP_FileDialogContentsView: QStyle = ... # 0x23
    CE_ScrollBarFirst        : QStyle = ... # 0x24
    PE_IndicatorToolBarHandle: QStyle = ... # 0x24
    PM_MenuBarHMargin        : QStyle = ... # 0x24
    SE_LabelLayoutItem       : QStyle = ... # 0x24
    SH_DialogButtons_DefaultButton: QStyle = ... # 0x24
    SP_FileDialogListView    : QStyle = ... # 0x24
    CE_ScrollBarLast         : QStyle = ... # 0x25
    PE_IndicatorToolBarSeparator: QStyle = ... # 0x25
    PM_IndicatorWidth        : QStyle = ... # 0x25
    SE_ProgressBarLayoutItem : QStyle = ... # 0x25
    SH_ToolBox_SelectedPageTitleBold: QStyle = ... # 0x25
    SP_FileDialogBack        : QStyle = ... # 0x25
    CE_FocusFrame            : QStyle = ... # 0x26
    PE_PanelTipLabel         : QStyle = ... # 0x26
    PM_IndicatorHeight       : QStyle = ... # 0x26
    SE_PushButtonLayoutItem  : QStyle = ... # 0x26
    SH_TabBar_PreferNoArrows : QStyle = ... # 0x26
    SP_DirIcon               : QStyle = ... # 0x26
    CE_ComboBoxLabel         : QStyle = ... # 0x27
    PE_IndicatorTabTear      : QStyle = ... # 0x27
    PE_IndicatorTabTearLeft  : QStyle = ... # 0x27
    PM_ExclusiveIndicatorWidth: QStyle = ... # 0x27
    SE_RadioButtonLayoutItem : QStyle = ... # 0x27
    SH_ScrollBar_LeftClickAbsolutePosition: QStyle = ... # 0x27
    SP_DialogOkButton        : QStyle = ... # 0x27
    CE_ToolBar               : QStyle = ... # 0x28
    PE_PanelScrollAreaCorner : QStyle = ... # 0x28
    PM_ExclusiveIndicatorHeight: QStyle = ... # 0x28
    SE_SliderLayoutItem      : QStyle = ... # 0x28
    SH_ListViewExpand_SelectMouseType: QStyle = ... # 0x28
    SP_DialogCancelButton    : QStyle = ... # 0x28
    CE_ToolBoxTabShape       : QStyle = ... # 0x29
    PE_Widget                : QStyle = ... # 0x29
    PM_DialogButtonsSeparator: QStyle = ... # 0x29
    SE_SpinBoxLayoutItem     : QStyle = ... # 0x29
    SH_UnderlineShortcut     : QStyle = ... # 0x29
    SP_DialogHelpButton      : QStyle = ... # 0x29
    CE_ToolBoxTabLabel       : QStyle = ... # 0x2a
    PE_IndicatorColumnViewArrow: QStyle = ... # 0x2a
    PM_DialogButtonsButtonWidth: QStyle = ... # 0x2a
    SE_ToolButtonLayoutItem  : QStyle = ... # 0x2a
    SH_SpinBox_AnimateButton : QStyle = ... # 0x2a
    SP_DialogOpenButton      : QStyle = ... # 0x2a
    CE_HeaderEmptyArea       : QStyle = ... # 0x2b
    PE_IndicatorItemViewItemDrop: QStyle = ... # 0x2b
    PM_DialogButtonsButtonHeight: QStyle = ... # 0x2b
    SE_FrameLayoutItem       : QStyle = ... # 0x2b
    SH_SpinBox_KeyPressAutoRepeatRate: QStyle = ... # 0x2b
    SP_DialogSaveButton      : QStyle = ... # 0x2b
    CE_ColumnViewGrip        : QStyle = ... # 0x2c
    PE_PanelItemViewItem     : QStyle = ... # 0x2c
    PM_MDIFrameWidth         : QStyle = ... # 0x2c
    PM_MdiSubWindowFrameWidth: QStyle = ... # 0x2c
    SE_GroupBoxLayoutItem    : QStyle = ... # 0x2c
    SH_SpinBox_ClickAutoRepeatRate: QStyle = ... # 0x2c
    SP_DialogCloseButton     : QStyle = ... # 0x2c
    CE_ItemViewItem          : QStyle = ... # 0x2d
    PE_PanelItemViewRow      : QStyle = ... # 0x2d
    PM_MDIMinimizedWidth     : QStyle = ... # 0x2d
    PM_MdiSubWindowMinimizedWidth: QStyle = ... # 0x2d
    SE_TabWidgetLayoutItem   : QStyle = ... # 0x2d
    SH_Menu_FillScreenWithScroll: QStyle = ... # 0x2d
    SP_DialogApplyButton     : QStyle = ... # 0x2d
    CE_ShapedFrame           : QStyle = ... # 0x2e
    PE_PanelStatusBar        : QStyle = ... # 0x2e
    PM_HeaderMargin          : QStyle = ... # 0x2e
    SE_ItemViewItemDecoration: QStyle = ... # 0x2e
    SH_ToolTipLabel_Opacity  : QStyle = ... # 0x2e
    SP_DialogResetButton     : QStyle = ... # 0x2e
    PE_IndicatorTabClose     : QStyle = ... # 0x2f
    PM_HeaderMarkSize        : QStyle = ... # 0x2f
    SE_ItemViewItemText      : QStyle = ... # 0x2f
    SH_DrawMenuBarSeparator  : QStyle = ... # 0x2f
    SP_DialogDiscardButton   : QStyle = ... # 0x2f
    PE_PanelMenu             : QStyle = ... # 0x30
    PM_HeaderGripMargin      : QStyle = ... # 0x30
    SE_ItemViewItemFocusRect : QStyle = ... # 0x30
    SH_TitleBar_ModifyNotification: QStyle = ... # 0x30
    SP_DialogYesButton       : QStyle = ... # 0x30
    PE_IndicatorTabTearRight : QStyle = ... # 0x31
    PM_TabBarTabShiftHorizontal: QStyle = ... # 0x31
    SE_TabBarTabLeftButton   : QStyle = ... # 0x31
    SH_Button_FocusPolicy    : QStyle = ... # 0x31
    SP_DialogNoButton        : QStyle = ... # 0x31
    PM_TabBarTabShiftVertical: QStyle = ... # 0x32
    SE_TabBarTabRightButton  : QStyle = ... # 0x32
    SH_MessageBox_UseBorderForButtonSpacing: QStyle = ... # 0x32
    SP_ArrowUp               : QStyle = ... # 0x32
    PM_TabBarScrollButtonWidth: QStyle = ... # 0x33
    SE_TabBarTabText         : QStyle = ... # 0x33
    SH_TitleBar_AutoRaise    : QStyle = ... # 0x33
    SP_ArrowDown             : QStyle = ... # 0x33
    PM_ToolBarFrameWidth     : QStyle = ... # 0x34
    SE_ShapedFrameContents   : QStyle = ... # 0x34
    SH_ToolButton_PopupDelay : QStyle = ... # 0x34
    SP_ArrowLeft             : QStyle = ... # 0x34
    PM_ToolBarHandleExtent   : QStyle = ... # 0x35
    SE_ToolBarHandle         : QStyle = ... # 0x35
    SH_FocusFrame_Mask       : QStyle = ... # 0x35
    SP_ArrowRight            : QStyle = ... # 0x35
    PM_ToolBarItemSpacing    : QStyle = ... # 0x36
    SE_TabBarScrollLeftButton: QStyle = ... # 0x36
    SH_RubberBand_Mask       : QStyle = ... # 0x36
    SP_ArrowBack             : QStyle = ... # 0x36
    PM_ToolBarItemMargin     : QStyle = ... # 0x37
    SE_TabBarScrollRightButton: QStyle = ... # 0x37
    SH_WindowFrame_Mask      : QStyle = ... # 0x37
    SP_ArrowForward          : QStyle = ... # 0x37
    PM_ToolBarSeparatorExtent: QStyle = ... # 0x38
    SE_TabBarTearIndicatorRight: QStyle = ... # 0x38
    SH_SpinControls_DisableOnBounds: QStyle = ... # 0x38
    SP_DirHomeIcon           : QStyle = ... # 0x38
    PM_ToolBarExtensionExtent: QStyle = ... # 0x39
    SH_Dial_BackgroundRole   : QStyle = ... # 0x39
    SP_CommandLink           : QStyle = ... # 0x39
    PM_SpinBoxSliderHeight   : QStyle = ... # 0x3a
    SH_ComboBox_LayoutDirection: QStyle = ... # 0x3a
    SP_VistaShield           : QStyle = ... # 0x3a
    PM_DefaultTopLevelMargin : QStyle = ... # 0x3b
    SH_ItemView_EllipsisLocation: QStyle = ... # 0x3b
    SP_BrowserReload         : QStyle = ... # 0x3b
    PM_DefaultChildMargin    : QStyle = ... # 0x3c
    SH_ItemView_ShowDecorationSelected: QStyle = ... # 0x3c
    SP_BrowserStop           : QStyle = ... # 0x3c
    PM_DefaultLayoutSpacing  : QStyle = ... # 0x3d
    SH_ItemView_ActivateItemOnSingleClick: QStyle = ... # 0x3d
    SP_MediaPlay             : QStyle = ... # 0x3d
    PM_ToolBarIconSize       : QStyle = ... # 0x3e
    SH_ScrollBar_ContextMenu : QStyle = ... # 0x3e
    SP_MediaStop             : QStyle = ... # 0x3e
    PM_ListViewIconSize      : QStyle = ... # 0x3f
    SH_ScrollBar_RollBetweenButtons: QStyle = ... # 0x3f
    SP_MediaPause            : QStyle = ... # 0x3f
    PM_IconViewIconSize      : QStyle = ... # 0x40
    SC_ScrollBarSlider       : QStyle = ... # 0x40
    SC_TitleBarUnshadeButton : QStyle = ... # 0x40
    SH_Slider_AbsoluteSetButtons: QStyle = ... # 0x40
    SP_MediaSkipForward      : QStyle = ... # 0x40
    State_DownArrow          : QStyle = ... # 0x40
    PM_SmallIconSize         : QStyle = ... # 0x41
    SH_Slider_PageSetButtons : QStyle = ... # 0x41
    SP_MediaSkipBackward     : QStyle = ... # 0x41
    PM_LargeIconSize         : QStyle = ... # 0x42
    SH_Menu_KeyboardSearch   : QStyle = ... # 0x42
    SP_MediaSeekForward      : QStyle = ... # 0x42
    PM_FocusFrameVMargin     : QStyle = ... # 0x43
    SH_TabBar_ElideMode      : QStyle = ... # 0x43
    SP_MediaSeekBackward     : QStyle = ... # 0x43
    PM_FocusFrameHMargin     : QStyle = ... # 0x44
    SH_DialogButtonLayout    : QStyle = ... # 0x44
    SP_MediaVolume           : QStyle = ... # 0x44
    PM_ToolTipLabelFrameWidth: QStyle = ... # 0x45
    SH_ComboBox_PopupFrameStyle: QStyle = ... # 0x45
    SP_MediaVolumeMuted      : QStyle = ... # 0x45
    PM_CheckBoxLabelSpacing  : QStyle = ... # 0x46
    SH_MessageBox_TextInteractionFlags: QStyle = ... # 0x46
    SP_LineEditClearButton   : QStyle = ... # 0x46
    PM_TabBarIconSize        : QStyle = ... # 0x47
    SH_DialogButtonBox_ButtonsHaveIcons: QStyle = ... # 0x47
    SP_DialogYesToAllButton  : QStyle = ... # 0x47
    PM_SizeGripSize          : QStyle = ... # 0x48
    SH_SpellCheckUnderlineStyle: QStyle = ... # 0x48
    SP_DialogNoToAllButton   : QStyle = ... # 0x48
    PM_DockWidgetTitleMargin : QStyle = ... # 0x49
    SH_MessageBox_CenterButtons: QStyle = ... # 0x49
    SP_DialogSaveAllButton   : QStyle = ... # 0x49
    PM_MessageBoxIconSize    : QStyle = ... # 0x4a
    SH_Menu_SelectionWrap    : QStyle = ... # 0x4a
    SP_DialogAbortButton     : QStyle = ... # 0x4a
    PM_ButtonIconSize        : QStyle = ... # 0x4b
    SH_ItemView_MovementWithoutUpdatingSelection: QStyle = ... # 0x4b
    SP_DialogRetryButton     : QStyle = ... # 0x4b
    PM_DockWidgetTitleBarButtonMargin: QStyle = ... # 0x4c
    SH_ToolTip_Mask          : QStyle = ... # 0x4c
    SP_DialogIgnoreButton    : QStyle = ... # 0x4c
    PM_RadioButtonLabelSpacing: QStyle = ... # 0x4d
    SH_FocusFrame_AboveWidget: QStyle = ... # 0x4d
    SP_RestoreDefaultsButton : QStyle = ... # 0x4d
    PM_LayoutLeftMargin      : QStyle = ... # 0x4e
    SH_TextControl_FocusIndicatorTextCharFormat: QStyle = ... # 0x4e
    PM_LayoutTopMargin       : QStyle = ... # 0x4f
    SH_WizardStyle           : QStyle = ... # 0x4f
    PM_LayoutRightMargin     : QStyle = ... # 0x50
    SH_ItemView_ArrowKeysNavigateIntoChildren: QStyle = ... # 0x50
    PM_LayoutBottomMargin    : QStyle = ... # 0x51
    SH_Menu_Mask             : QStyle = ... # 0x51
    PM_LayoutHorizontalSpacing: QStyle = ... # 0x52
    SH_Menu_FlashTriggeredItem: QStyle = ... # 0x52
    PM_LayoutVerticalSpacing : QStyle = ... # 0x53
    SH_Menu_FadeOutOnHide    : QStyle = ... # 0x53
    PM_TabBar_ScrollButtonOverlap: QStyle = ... # 0x54
    SH_SpinBox_ClickAutoRepeatThreshold: QStyle = ... # 0x54
    PM_TextCursorWidth       : QStyle = ... # 0x55
    SH_ItemView_PaintAlternatingRowColorsForEmptyArea: QStyle = ... # 0x55
    PM_TabCloseIndicatorWidth: QStyle = ... # 0x56
    SH_FormLayoutWrapPolicy  : QStyle = ... # 0x56
    PM_TabCloseIndicatorHeight: QStyle = ... # 0x57
    SH_TabWidget_DefaultTabPosition: QStyle = ... # 0x57
    PM_ScrollView_ScrollBarSpacing: QStyle = ... # 0x58
    SH_ToolBar_Movable       : QStyle = ... # 0x58
    PM_ScrollView_ScrollBarOverlap: QStyle = ... # 0x59
    SH_FormLayoutFieldGrowthPolicy: QStyle = ... # 0x59
    PM_SubMenuOverlap        : QStyle = ... # 0x5a
    SH_FormLayoutFormAlignment: QStyle = ... # 0x5a
    PM_TreeViewIndentation   : QStyle = ... # 0x5b
    SH_FormLayoutLabelAlignment: QStyle = ... # 0x5b
    PM_HeaderDefaultSectionSizeHorizontal: QStyle = ... # 0x5c
    SH_ItemView_DrawDelegateFrame: QStyle = ... # 0x5c
    PM_HeaderDefaultSectionSizeVertical: QStyle = ... # 0x5d
    SH_TabBar_CloseButtonPosition: QStyle = ... # 0x5d
    PM_TitleBarButtonIconSize: QStyle = ... # 0x5e
    SH_DockWidget_ButtonsHaveFrame: QStyle = ... # 0x5e
    PM_TitleBarButtonSize    : QStyle = ... # 0x5f
    SH_ToolButtonStyle       : QStyle = ... # 0x5f
    SH_RequestSoftwareInputPanel: QStyle = ... # 0x60
    SH_ScrollBar_Transient   : QStyle = ... # 0x61
    SH_Menu_SupportsSections : QStyle = ... # 0x62
    SH_ToolTip_WakeUpDelay   : QStyle = ... # 0x63
    SH_ToolTip_FallAsleepDelay: QStyle = ... # 0x64
    SH_Widget_Animate        : QStyle = ... # 0x65
    SH_Splitter_OpaqueResize : QStyle = ... # 0x66
    SH_ComboBox_UseNativePopup: QStyle = ... # 0x67
    SH_LineEdit_PasswordMaskDelay: QStyle = ... # 0x68
    SH_TabBar_ChangeCurrentDelay: QStyle = ... # 0x69
    SH_Menu_SubMenuUniDirection: QStyle = ... # 0x6a
    SH_Menu_SubMenuUniDirectionFailCount: QStyle = ... # 0x6b
    SH_Menu_SubMenuSloppySelectOtherActions: QStyle = ... # 0x6c
    SH_Menu_SubMenuSloppyCloseTimeout: QStyle = ... # 0x6d
    SH_Menu_SubMenuResetWhenReenteringParent: QStyle = ... # 0x6e
    SH_Menu_SubMenuDontStartSloppyOnLeave: QStyle = ... # 0x6f
    SH_ItemView_ScrollMode   : QStyle = ... # 0x70
    SH_TitleBar_ShowToolTipsOnButtons: QStyle = ... # 0x71
    SH_Widget_Animation_Duration: QStyle = ... # 0x72
    SH_ComboBox_AllowWheelScrolling: QStyle = ... # 0x73
    SH_SpinBox_ButtonsInsideFrame: QStyle = ... # 0x74
    SH_SpinBox_StepModifier  : QStyle = ... # 0x75
    SC_ScrollBarGroove       : QStyle = ... # 0x80
    SC_TitleBarContextHelpButton: QStyle = ... # 0x80
    State_Horizontal         : QStyle = ... # 0x80
    SC_TitleBarLabel         : QStyle = ... # 0x100
    State_HasFocus           : QStyle = ... # 0x100
    State_Top                : QStyle = ... # 0x200
    State_Bottom             : QStyle = ... # 0x400
    State_FocusAtBorder      : QStyle = ... # 0x800
    State_AutoRaise          : QStyle = ... # 0x1000
    State_MouseOver          : QStyle = ... # 0x2000
    State_UpArrow            : QStyle = ... # 0x4000
    State_Selected           : QStyle = ... # 0x8000
    State_Active             : QStyle = ... # 0x10000
    State_Window             : QStyle = ... # 0x20000
    State_Open               : QStyle = ... # 0x40000
    State_Children           : QStyle = ... # 0x80000
    State_Item               : QStyle = ... # 0x100000
    State_Sibling            : QStyle = ... # 0x200000
    State_Editing            : QStyle = ... # 0x400000
    State_KeyboardFocusChange: QStyle = ... # 0x800000
    State_ReadOnly           : QStyle = ... # 0x2000000
    State_Small              : QStyle = ... # 0x4000000
    State_Mini               : QStyle = ... # 0x8000000
    PE_CustomBase            : QStyle = ... # 0xf000000

    class ComplexControl(object):
        CC_CustomBase            : QStyle.ComplexControl = ... # -0x10000000
        CC_SpinBox               : QStyle.ComplexControl = ... # 0x0
        CC_ComboBox              : QStyle.ComplexControl = ... # 0x1
        CC_ScrollBar             : QStyle.ComplexControl = ... # 0x2
        CC_Slider                : QStyle.ComplexControl = ... # 0x3
        CC_ToolButton            : QStyle.ComplexControl = ... # 0x4
        CC_TitleBar              : QStyle.ComplexControl = ... # 0x5
        CC_Dial                  : QStyle.ComplexControl = ... # 0x6
        CC_GroupBox              : QStyle.ComplexControl = ... # 0x7
        CC_MdiControls           : QStyle.ComplexControl = ... # 0x8

    class ContentsType(object):
        CT_CustomBase            : QStyle.ContentsType = ... # -0x10000000
        CT_PushButton            : QStyle.ContentsType = ... # 0x0
        CT_CheckBox              : QStyle.ContentsType = ... # 0x1
        CT_RadioButton           : QStyle.ContentsType = ... # 0x2
        CT_ToolButton            : QStyle.ContentsType = ... # 0x3
        CT_ComboBox              : QStyle.ContentsType = ... # 0x4
        CT_Splitter              : QStyle.ContentsType = ... # 0x5
        CT_ProgressBar           : QStyle.ContentsType = ... # 0x6
        CT_MenuItem              : QStyle.ContentsType = ... # 0x7
        CT_MenuBarItem           : QStyle.ContentsType = ... # 0x8
        CT_MenuBar               : QStyle.ContentsType = ... # 0x9
        CT_Menu                  : QStyle.ContentsType = ... # 0xa
        CT_TabBarTab             : QStyle.ContentsType = ... # 0xb
        CT_Slider                : QStyle.ContentsType = ... # 0xc
        CT_ScrollBar             : QStyle.ContentsType = ... # 0xd
        CT_LineEdit              : QStyle.ContentsType = ... # 0xe
        CT_SpinBox               : QStyle.ContentsType = ... # 0xf
        CT_SizeGrip              : QStyle.ContentsType = ... # 0x10
        CT_TabWidget             : QStyle.ContentsType = ... # 0x11
        CT_DialogButtons         : QStyle.ContentsType = ... # 0x12
        CT_HeaderSection         : QStyle.ContentsType = ... # 0x13
        CT_GroupBox              : QStyle.ContentsType = ... # 0x14
        CT_MdiControls           : QStyle.ContentsType = ... # 0x15
        CT_ItemViewItem          : QStyle.ContentsType = ... # 0x16

    class ControlElement(object):
        CE_CustomBase            : QStyle.ControlElement = ... # -0x10000000
        CE_PushButton            : QStyle.ControlElement = ... # 0x0
        CE_PushButtonBevel       : QStyle.ControlElement = ... # 0x1
        CE_PushButtonLabel       : QStyle.ControlElement = ... # 0x2
        CE_CheckBox              : QStyle.ControlElement = ... # 0x3
        CE_CheckBoxLabel         : QStyle.ControlElement = ... # 0x4
        CE_RadioButton           : QStyle.ControlElement = ... # 0x5
        CE_RadioButtonLabel      : QStyle.ControlElement = ... # 0x6
        CE_TabBarTab             : QStyle.ControlElement = ... # 0x7
        CE_TabBarTabShape        : QStyle.ControlElement = ... # 0x8
        CE_TabBarTabLabel        : QStyle.ControlElement = ... # 0x9
        CE_ProgressBar           : QStyle.ControlElement = ... # 0xa
        CE_ProgressBarGroove     : QStyle.ControlElement = ... # 0xb
        CE_ProgressBarContents   : QStyle.ControlElement = ... # 0xc
        CE_ProgressBarLabel      : QStyle.ControlElement = ... # 0xd
        CE_MenuItem              : QStyle.ControlElement = ... # 0xe
        CE_MenuScroller          : QStyle.ControlElement = ... # 0xf
        CE_MenuVMargin           : QStyle.ControlElement = ... # 0x10
        CE_MenuHMargin           : QStyle.ControlElement = ... # 0x11
        CE_MenuTearoff           : QStyle.ControlElement = ... # 0x12
        CE_MenuEmptyArea         : QStyle.ControlElement = ... # 0x13
        CE_MenuBarItem           : QStyle.ControlElement = ... # 0x14
        CE_MenuBarEmptyArea      : QStyle.ControlElement = ... # 0x15
        CE_ToolButtonLabel       : QStyle.ControlElement = ... # 0x16
        CE_Header                : QStyle.ControlElement = ... # 0x17
        CE_HeaderSection         : QStyle.ControlElement = ... # 0x18
        CE_HeaderLabel           : QStyle.ControlElement = ... # 0x19
        CE_ToolBoxTab            : QStyle.ControlElement = ... # 0x1a
        CE_SizeGrip              : QStyle.ControlElement = ... # 0x1b
        CE_Splitter              : QStyle.ControlElement = ... # 0x1c
        CE_RubberBand            : QStyle.ControlElement = ... # 0x1d
        CE_DockWidgetTitle       : QStyle.ControlElement = ... # 0x1e
        CE_ScrollBarAddLine      : QStyle.ControlElement = ... # 0x1f
        CE_ScrollBarSubLine      : QStyle.ControlElement = ... # 0x20
        CE_ScrollBarAddPage      : QStyle.ControlElement = ... # 0x21
        CE_ScrollBarSubPage      : QStyle.ControlElement = ... # 0x22
        CE_ScrollBarSlider       : QStyle.ControlElement = ... # 0x23
        CE_ScrollBarFirst        : QStyle.ControlElement = ... # 0x24
        CE_ScrollBarLast         : QStyle.ControlElement = ... # 0x25
        CE_FocusFrame            : QStyle.ControlElement = ... # 0x26
        CE_ComboBoxLabel         : QStyle.ControlElement = ... # 0x27
        CE_ToolBar               : QStyle.ControlElement = ... # 0x28
        CE_ToolBoxTabShape       : QStyle.ControlElement = ... # 0x29
        CE_ToolBoxTabLabel       : QStyle.ControlElement = ... # 0x2a
        CE_HeaderEmptyArea       : QStyle.ControlElement = ... # 0x2b
        CE_ColumnViewGrip        : QStyle.ControlElement = ... # 0x2c
        CE_ItemViewItem          : QStyle.ControlElement = ... # 0x2d
        CE_ShapedFrame           : QStyle.ControlElement = ... # 0x2e

    class PixelMetric(object):
        PM_CustomBase            : QStyle.PixelMetric = ... # -0x10000000
        PM_ButtonMargin          : QStyle.PixelMetric = ... # 0x0
        PM_ButtonDefaultIndicator: QStyle.PixelMetric = ... # 0x1
        PM_MenuButtonIndicator   : QStyle.PixelMetric = ... # 0x2
        PM_ButtonShiftHorizontal : QStyle.PixelMetric = ... # 0x3
        PM_ButtonShiftVertical   : QStyle.PixelMetric = ... # 0x4
        PM_DefaultFrameWidth     : QStyle.PixelMetric = ... # 0x5
        PM_SpinBoxFrameWidth     : QStyle.PixelMetric = ... # 0x6
        PM_ComboBoxFrameWidth    : QStyle.PixelMetric = ... # 0x7
        PM_MaximumDragDistance   : QStyle.PixelMetric = ... # 0x8
        PM_ScrollBarExtent       : QStyle.PixelMetric = ... # 0x9
        PM_ScrollBarSliderMin    : QStyle.PixelMetric = ... # 0xa
        PM_SliderThickness       : QStyle.PixelMetric = ... # 0xb
        PM_SliderControlThickness: QStyle.PixelMetric = ... # 0xc
        PM_SliderLength          : QStyle.PixelMetric = ... # 0xd
        PM_SliderTickmarkOffset  : QStyle.PixelMetric = ... # 0xe
        PM_SliderSpaceAvailable  : QStyle.PixelMetric = ... # 0xf
        PM_DockWidgetSeparatorExtent: QStyle.PixelMetric = ... # 0x10
        PM_DockWidgetHandleExtent: QStyle.PixelMetric = ... # 0x11
        PM_DockWidgetFrameWidth  : QStyle.PixelMetric = ... # 0x12
        PM_TabBarTabOverlap      : QStyle.PixelMetric = ... # 0x13
        PM_TabBarTabHSpace       : QStyle.PixelMetric = ... # 0x14
        PM_TabBarTabVSpace       : QStyle.PixelMetric = ... # 0x15
        PM_TabBarBaseHeight      : QStyle.PixelMetric = ... # 0x16
        PM_TabBarBaseOverlap     : QStyle.PixelMetric = ... # 0x17
        PM_ProgressBarChunkWidth : QStyle.PixelMetric = ... # 0x18
        PM_SplitterWidth         : QStyle.PixelMetric = ... # 0x19
        PM_TitleBarHeight        : QStyle.PixelMetric = ... # 0x1a
        PM_MenuScrollerHeight    : QStyle.PixelMetric = ... # 0x1b
        PM_MenuHMargin           : QStyle.PixelMetric = ... # 0x1c
        PM_MenuVMargin           : QStyle.PixelMetric = ... # 0x1d
        PM_MenuPanelWidth        : QStyle.PixelMetric = ... # 0x1e
        PM_MenuTearoffHeight     : QStyle.PixelMetric = ... # 0x1f
        PM_MenuDesktopFrameWidth : QStyle.PixelMetric = ... # 0x20
        PM_MenuBarPanelWidth     : QStyle.PixelMetric = ... # 0x21
        PM_MenuBarItemSpacing    : QStyle.PixelMetric = ... # 0x22
        PM_MenuBarVMargin        : QStyle.PixelMetric = ... # 0x23
        PM_MenuBarHMargin        : QStyle.PixelMetric = ... # 0x24
        PM_IndicatorWidth        : QStyle.PixelMetric = ... # 0x25
        PM_IndicatorHeight       : QStyle.PixelMetric = ... # 0x26
        PM_ExclusiveIndicatorWidth: QStyle.PixelMetric = ... # 0x27
        PM_ExclusiveIndicatorHeight: QStyle.PixelMetric = ... # 0x28
        PM_DialogButtonsSeparator: QStyle.PixelMetric = ... # 0x29
        PM_DialogButtonsButtonWidth: QStyle.PixelMetric = ... # 0x2a
        PM_DialogButtonsButtonHeight: QStyle.PixelMetric = ... # 0x2b
        PM_MDIFrameWidth         : QStyle.PixelMetric = ... # 0x2c
        PM_MdiSubWindowFrameWidth: QStyle.PixelMetric = ... # 0x2c
        PM_MDIMinimizedWidth     : QStyle.PixelMetric = ... # 0x2d
        PM_MdiSubWindowMinimizedWidth: QStyle.PixelMetric = ... # 0x2d
        PM_HeaderMargin          : QStyle.PixelMetric = ... # 0x2e
        PM_HeaderMarkSize        : QStyle.PixelMetric = ... # 0x2f
        PM_HeaderGripMargin      : QStyle.PixelMetric = ... # 0x30
        PM_TabBarTabShiftHorizontal: QStyle.PixelMetric = ... # 0x31
        PM_TabBarTabShiftVertical: QStyle.PixelMetric = ... # 0x32
        PM_TabBarScrollButtonWidth: QStyle.PixelMetric = ... # 0x33
        PM_ToolBarFrameWidth     : QStyle.PixelMetric = ... # 0x34
        PM_ToolBarHandleExtent   : QStyle.PixelMetric = ... # 0x35
        PM_ToolBarItemSpacing    : QStyle.PixelMetric = ... # 0x36
        PM_ToolBarItemMargin     : QStyle.PixelMetric = ... # 0x37
        PM_ToolBarSeparatorExtent: QStyle.PixelMetric = ... # 0x38
        PM_ToolBarExtensionExtent: QStyle.PixelMetric = ... # 0x39
        PM_SpinBoxSliderHeight   : QStyle.PixelMetric = ... # 0x3a
        PM_DefaultTopLevelMargin : QStyle.PixelMetric = ... # 0x3b
        PM_DefaultChildMargin    : QStyle.PixelMetric = ... # 0x3c
        PM_DefaultLayoutSpacing  : QStyle.PixelMetric = ... # 0x3d
        PM_ToolBarIconSize       : QStyle.PixelMetric = ... # 0x3e
        PM_ListViewIconSize      : QStyle.PixelMetric = ... # 0x3f
        PM_IconViewIconSize      : QStyle.PixelMetric = ... # 0x40
        PM_SmallIconSize         : QStyle.PixelMetric = ... # 0x41
        PM_LargeIconSize         : QStyle.PixelMetric = ... # 0x42
        PM_FocusFrameVMargin     : QStyle.PixelMetric = ... # 0x43
        PM_FocusFrameHMargin     : QStyle.PixelMetric = ... # 0x44
        PM_ToolTipLabelFrameWidth: QStyle.PixelMetric = ... # 0x45
        PM_CheckBoxLabelSpacing  : QStyle.PixelMetric = ... # 0x46
        PM_TabBarIconSize        : QStyle.PixelMetric = ... # 0x47
        PM_SizeGripSize          : QStyle.PixelMetric = ... # 0x48
        PM_DockWidgetTitleMargin : QStyle.PixelMetric = ... # 0x49
        PM_MessageBoxIconSize    : QStyle.PixelMetric = ... # 0x4a
        PM_ButtonIconSize        : QStyle.PixelMetric = ... # 0x4b
        PM_DockWidgetTitleBarButtonMargin: QStyle.PixelMetric = ... # 0x4c
        PM_RadioButtonLabelSpacing: QStyle.PixelMetric = ... # 0x4d
        PM_LayoutLeftMargin      : QStyle.PixelMetric = ... # 0x4e
        PM_LayoutTopMargin       : QStyle.PixelMetric = ... # 0x4f
        PM_LayoutRightMargin     : QStyle.PixelMetric = ... # 0x50
        PM_LayoutBottomMargin    : QStyle.PixelMetric = ... # 0x51
        PM_LayoutHorizontalSpacing: QStyle.PixelMetric = ... # 0x52
        PM_LayoutVerticalSpacing : QStyle.PixelMetric = ... # 0x53
        PM_TabBar_ScrollButtonOverlap: QStyle.PixelMetric = ... # 0x54
        PM_TextCursorWidth       : QStyle.PixelMetric = ... # 0x55
        PM_TabCloseIndicatorWidth: QStyle.PixelMetric = ... # 0x56
        PM_TabCloseIndicatorHeight: QStyle.PixelMetric = ... # 0x57
        PM_ScrollView_ScrollBarSpacing: QStyle.PixelMetric = ... # 0x58
        PM_ScrollView_ScrollBarOverlap: QStyle.PixelMetric = ... # 0x59
        PM_SubMenuOverlap        : QStyle.PixelMetric = ... # 0x5a
        PM_TreeViewIndentation   : QStyle.PixelMetric = ... # 0x5b
        PM_HeaderDefaultSectionSizeHorizontal: QStyle.PixelMetric = ... # 0x5c
        PM_HeaderDefaultSectionSizeVertical: QStyle.PixelMetric = ... # 0x5d
        PM_TitleBarButtonIconSize: QStyle.PixelMetric = ... # 0x5e
        PM_TitleBarButtonSize    : QStyle.PixelMetric = ... # 0x5f

    class PrimitiveElement(object):
        PE_Frame                 : QStyle.PrimitiveElement = ... # 0x0
        PE_FrameDefaultButton    : QStyle.PrimitiveElement = ... # 0x1
        PE_FrameDockWidget       : QStyle.PrimitiveElement = ... # 0x2
        PE_FrameFocusRect        : QStyle.PrimitiveElement = ... # 0x3
        PE_FrameGroupBox         : QStyle.PrimitiveElement = ... # 0x4
        PE_FrameLineEdit         : QStyle.PrimitiveElement = ... # 0x5
        PE_FrameMenu             : QStyle.PrimitiveElement = ... # 0x6
        PE_FrameStatusBar        : QStyle.PrimitiveElement = ... # 0x7
        PE_FrameStatusBarItem    : QStyle.PrimitiveElement = ... # 0x7
        PE_FrameTabWidget        : QStyle.PrimitiveElement = ... # 0x8
        PE_FrameWindow           : QStyle.PrimitiveElement = ... # 0x9
        PE_FrameButtonBevel      : QStyle.PrimitiveElement = ... # 0xa
        PE_FrameButtonTool       : QStyle.PrimitiveElement = ... # 0xb
        PE_FrameTabBarBase       : QStyle.PrimitiveElement = ... # 0xc
        PE_PanelButtonCommand    : QStyle.PrimitiveElement = ... # 0xd
        PE_PanelButtonBevel      : QStyle.PrimitiveElement = ... # 0xe
        PE_PanelButtonTool       : QStyle.PrimitiveElement = ... # 0xf
        PE_PanelMenuBar          : QStyle.PrimitiveElement = ... # 0x10
        PE_PanelToolBar          : QStyle.PrimitiveElement = ... # 0x11
        PE_PanelLineEdit         : QStyle.PrimitiveElement = ... # 0x12
        PE_IndicatorArrowDown    : QStyle.PrimitiveElement = ... # 0x13
        PE_IndicatorArrowLeft    : QStyle.PrimitiveElement = ... # 0x14
        PE_IndicatorArrowRight   : QStyle.PrimitiveElement = ... # 0x15
        PE_IndicatorArrowUp      : QStyle.PrimitiveElement = ... # 0x16
        PE_IndicatorBranch       : QStyle.PrimitiveElement = ... # 0x17
        PE_IndicatorButtonDropDown: QStyle.PrimitiveElement = ... # 0x18
        PE_IndicatorItemViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
        PE_IndicatorViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
        PE_IndicatorCheckBox     : QStyle.PrimitiveElement = ... # 0x1a
        PE_IndicatorDockWidgetResizeHandle: QStyle.PrimitiveElement = ... # 0x1b
        PE_IndicatorHeaderArrow  : QStyle.PrimitiveElement = ... # 0x1c
        PE_IndicatorMenuCheckMark: QStyle.PrimitiveElement = ... # 0x1d
        PE_IndicatorProgressChunk: QStyle.PrimitiveElement = ... # 0x1e
        PE_IndicatorRadioButton  : QStyle.PrimitiveElement = ... # 0x1f
        PE_IndicatorSpinDown     : QStyle.PrimitiveElement = ... # 0x20
        PE_IndicatorSpinMinus    : QStyle.PrimitiveElement = ... # 0x21
        PE_IndicatorSpinPlus     : QStyle.PrimitiveElement = ... # 0x22
        PE_IndicatorSpinUp       : QStyle.PrimitiveElement = ... # 0x23
        PE_IndicatorToolBarHandle: QStyle.PrimitiveElement = ... # 0x24
        PE_IndicatorToolBarSeparator: QStyle.PrimitiveElement = ... # 0x25
        PE_PanelTipLabel         : QStyle.PrimitiveElement = ... # 0x26
        PE_IndicatorTabTear      : QStyle.PrimitiveElement = ... # 0x27
        PE_IndicatorTabTearLeft  : QStyle.PrimitiveElement = ... # 0x27
        PE_PanelScrollAreaCorner : QStyle.PrimitiveElement = ... # 0x28
        PE_Widget                : QStyle.PrimitiveElement = ... # 0x29
        PE_IndicatorColumnViewArrow: QStyle.PrimitiveElement = ... # 0x2a
        PE_IndicatorItemViewItemDrop: QStyle.PrimitiveElement = ... # 0x2b
        PE_PanelItemViewItem     : QStyle.PrimitiveElement = ... # 0x2c
        PE_PanelItemViewRow      : QStyle.PrimitiveElement = ... # 0x2d
        PE_PanelStatusBar        : QStyle.PrimitiveElement = ... # 0x2e
        PE_IndicatorTabClose     : QStyle.PrimitiveElement = ... # 0x2f
        PE_PanelMenu             : QStyle.PrimitiveElement = ... # 0x30
        PE_IndicatorTabTearRight : QStyle.PrimitiveElement = ... # 0x31
        PE_CustomBase            : QStyle.PrimitiveElement = ... # 0xf000000

    class RequestSoftwareInputPanel(object):
        RSIP_OnMouseClickAndAlreadyFocused: QStyle.RequestSoftwareInputPanel = ... # 0x0
        RSIP_OnMouseClick        : QStyle.RequestSoftwareInputPanel = ... # 0x1

    class StandardPixmap(object):
        SP_CustomBase            : QStyle.StandardPixmap = ... # -0x10000000
        SP_TitleBarMenuButton    : QStyle.StandardPixmap = ... # 0x0
        SP_TitleBarMinButton     : QStyle.StandardPixmap = ... # 0x1
        SP_TitleBarMaxButton     : QStyle.StandardPixmap = ... # 0x2
        SP_TitleBarCloseButton   : QStyle.StandardPixmap = ... # 0x3
        SP_TitleBarNormalButton  : QStyle.StandardPixmap = ... # 0x4
        SP_TitleBarShadeButton   : QStyle.StandardPixmap = ... # 0x5
        SP_TitleBarUnshadeButton : QStyle.StandardPixmap = ... # 0x6
        SP_TitleBarContextHelpButton: QStyle.StandardPixmap = ... # 0x7
        SP_DockWidgetCloseButton : QStyle.StandardPixmap = ... # 0x8
        SP_MessageBoxInformation : QStyle.StandardPixmap = ... # 0x9
        SP_MessageBoxWarning     : QStyle.StandardPixmap = ... # 0xa
        SP_MessageBoxCritical    : QStyle.StandardPixmap = ... # 0xb
        SP_MessageBoxQuestion    : QStyle.StandardPixmap = ... # 0xc
        SP_DesktopIcon           : QStyle.StandardPixmap = ... # 0xd
        SP_TrashIcon             : QStyle.StandardPixmap = ... # 0xe
        SP_ComputerIcon          : QStyle.StandardPixmap = ... # 0xf
        SP_DriveFDIcon           : QStyle.StandardPixmap = ... # 0x10
        SP_DriveHDIcon           : QStyle.StandardPixmap = ... # 0x11
        SP_DriveCDIcon           : QStyle.StandardPixmap = ... # 0x12
        SP_DriveDVDIcon          : QStyle.StandardPixmap = ... # 0x13
        SP_DriveNetIcon          : QStyle.StandardPixmap = ... # 0x14
        SP_DirOpenIcon           : QStyle.StandardPixmap = ... # 0x15
        SP_DirClosedIcon         : QStyle.StandardPixmap = ... # 0x16
        SP_DirLinkIcon           : QStyle.StandardPixmap = ... # 0x17
        SP_DirLinkOpenIcon       : QStyle.StandardPixmap = ... # 0x18
        SP_FileIcon              : QStyle.StandardPixmap = ... # 0x19
        SP_FileLinkIcon          : QStyle.StandardPixmap = ... # 0x1a
        SP_ToolBarHorizontalExtensionButton: QStyle.StandardPixmap = ... # 0x1b
        SP_ToolBarVerticalExtensionButton: QStyle.StandardPixmap = ... # 0x1c
        SP_FileDialogStart       : QStyle.StandardPixmap = ... # 0x1d
        SP_FileDialogEnd         : QStyle.StandardPixmap = ... # 0x1e
        SP_FileDialogToParent    : QStyle.StandardPixmap = ... # 0x1f
        SP_FileDialogNewFolder   : QStyle.StandardPixmap = ... # 0x20
        SP_FileDialogDetailedView: QStyle.StandardPixmap = ... # 0x21
        SP_FileDialogInfoView    : QStyle.StandardPixmap = ... # 0x22
        SP_FileDialogContentsView: QStyle.StandardPixmap = ... # 0x23
        SP_FileDialogListView    : QStyle.StandardPixmap = ... # 0x24
        SP_FileDialogBack        : QStyle.StandardPixmap = ... # 0x25
        SP_DirIcon               : QStyle.StandardPixmap = ... # 0x26
        SP_DialogOkButton        : QStyle.StandardPixmap = ... # 0x27
        SP_DialogCancelButton    : QStyle.StandardPixmap = ... # 0x28
        SP_DialogHelpButton      : QStyle.StandardPixmap = ... # 0x29
        SP_DialogOpenButton      : QStyle.StandardPixmap = ... # 0x2a
        SP_DialogSaveButton      : QStyle.StandardPixmap = ... # 0x2b
        SP_DialogCloseButton     : QStyle.StandardPixmap = ... # 0x2c
        SP_DialogApplyButton     : QStyle.StandardPixmap = ... # 0x2d
        SP_DialogResetButton     : QStyle.StandardPixmap = ... # 0x2e
        SP_DialogDiscardButton   : QStyle.StandardPixmap = ... # 0x2f
        SP_DialogYesButton       : QStyle.StandardPixmap = ... # 0x30
        SP_DialogNoButton        : QStyle.StandardPixmap = ... # 0x31
        SP_ArrowUp               : QStyle.StandardPixmap = ... # 0x32
        SP_ArrowDown             : QStyle.StandardPixmap = ... # 0x33
        SP_ArrowLeft             : QStyle.StandardPixmap = ... # 0x34
        SP_ArrowRight            : QStyle.StandardPixmap = ... # 0x35
        SP_ArrowBack             : QStyle.StandardPixmap = ... # 0x36
        SP_ArrowForward          : QStyle.StandardPixmap = ... # 0x37
        SP_DirHomeIcon           : QStyle.StandardPixmap = ... # 0x38
        SP_CommandLink           : QStyle.StandardPixmap = ... # 0x39
        SP_VistaShield           : QStyle.StandardPixmap = ... # 0x3a
        SP_BrowserReload         : QStyle.StandardPixmap = ... # 0x3b
        SP_BrowserStop           : QStyle.StandardPixmap = ... # 0x3c
        SP_MediaPlay             : QStyle.StandardPixmap = ... # 0x3d
        SP_MediaStop             : QStyle.StandardPixmap = ... # 0x3e
        SP_MediaPause            : QStyle.StandardPixmap = ... # 0x3f
        SP_MediaSkipForward      : QStyle.StandardPixmap = ... # 0x40
        SP_MediaSkipBackward     : QStyle.StandardPixmap = ... # 0x41
        SP_MediaSeekForward      : QStyle.StandardPixmap = ... # 0x42
        SP_MediaSeekBackward     : QStyle.StandardPixmap = ... # 0x43
        SP_MediaVolume           : QStyle.StandardPixmap = ... # 0x44
        SP_MediaVolumeMuted      : QStyle.StandardPixmap = ... # 0x45
        SP_LineEditClearButton   : QStyle.StandardPixmap = ... # 0x46
        SP_DialogYesToAllButton  : QStyle.StandardPixmap = ... # 0x47
        SP_DialogNoToAllButton   : QStyle.StandardPixmap = ... # 0x48
        SP_DialogSaveAllButton   : QStyle.StandardPixmap = ... # 0x49
        SP_DialogAbortButton     : QStyle.StandardPixmap = ... # 0x4a
        SP_DialogRetryButton     : QStyle.StandardPixmap = ... # 0x4b
        SP_DialogIgnoreButton    : QStyle.StandardPixmap = ... # 0x4c
        SP_RestoreDefaultsButton : QStyle.StandardPixmap = ... # 0x4d

    class State(object): ...

    class StateFlag(object):
        State_None               : QStyle.StateFlag = ... # 0x0
        State_Enabled            : QStyle.StateFlag = ... # 0x1
        State_Raised             : QStyle.StateFlag = ... # 0x2
        State_Sunken             : QStyle.StateFlag = ... # 0x4
        State_Off                : QStyle.StateFlag = ... # 0x8
        State_NoChange           : QStyle.StateFlag = ... # 0x10
        State_On                 : QStyle.StateFlag = ... # 0x20
        State_DownArrow          : QStyle.StateFlag = ... # 0x40
        State_Horizontal         : QStyle.StateFlag = ... # 0x80
        State_HasFocus           : QStyle.StateFlag = ... # 0x100
        State_Top                : QStyle.StateFlag = ... # 0x200
        State_Bottom             : QStyle.StateFlag = ... # 0x400
        State_FocusAtBorder      : QStyle.StateFlag = ... # 0x800
        State_AutoRaise          : QStyle.StateFlag = ... # 0x1000
        State_MouseOver          : QStyle.StateFlag = ... # 0x2000
        State_UpArrow            : QStyle.StateFlag = ... # 0x4000
        State_Selected           : QStyle.StateFlag = ... # 0x8000
        State_Active             : QStyle.StateFlag = ... # 0x10000
        State_Window             : QStyle.StateFlag = ... # 0x20000
        State_Open               : QStyle.StateFlag = ... # 0x40000
        State_Children           : QStyle.StateFlag = ... # 0x80000
        State_Item               : QStyle.StateFlag = ... # 0x100000
        State_Sibling            : QStyle.StateFlag = ... # 0x200000
        State_Editing            : QStyle.StateFlag = ... # 0x400000
        State_KeyboardFocusChange: QStyle.StateFlag = ... # 0x800000
        State_ReadOnly           : QStyle.StateFlag = ... # 0x2000000
        State_Small              : QStyle.StateFlag = ... # 0x4000000
        State_Mini               : QStyle.StateFlag = ... # 0x8000000

    class StyleHint(object):
        SH_CustomBase            : QStyle.StyleHint = ... # -0x10000000
        SH_EtchDisabledText      : QStyle.StyleHint = ... # 0x0
        SH_DitherDisabledText    : QStyle.StyleHint = ... # 0x1
        SH_ScrollBar_MiddleClickAbsolutePosition: QStyle.StyleHint = ... # 0x2
        SH_ScrollBar_ScrollWhenPointerLeavesControl: QStyle.StyleHint = ... # 0x3
        SH_TabBar_SelectMouseType: QStyle.StyleHint = ... # 0x4
        SH_TabBar_Alignment      : QStyle.StyleHint = ... # 0x5
        SH_Header_ArrowAlignment : QStyle.StyleHint = ... # 0x6
        SH_Slider_SnapToValue    : QStyle.StyleHint = ... # 0x7
        SH_Slider_SloppyKeyEvents: QStyle.StyleHint = ... # 0x8
        SH_ProgressDialog_CenterCancelButton: QStyle.StyleHint = ... # 0x9
        SH_ProgressDialog_TextLabelAlignment: QStyle.StyleHint = ... # 0xa
        SH_PrintDialog_RightAlignButtons: QStyle.StyleHint = ... # 0xb
        SH_MainWindow_SpaceBelowMenuBar: QStyle.StyleHint = ... # 0xc
        SH_FontDialog_SelectAssociatedText: QStyle.StyleHint = ... # 0xd
        SH_Menu_AllowActiveAndDisabled: QStyle.StyleHint = ... # 0xe
        SH_Menu_SpaceActivatesItem: QStyle.StyleHint = ... # 0xf
        SH_Menu_SubMenuPopupDelay: QStyle.StyleHint = ... # 0x10
        SH_ScrollView_FrameOnlyAroundContents: QStyle.StyleHint = ... # 0x11
        SH_MenuBar_AltKeyNavigation: QStyle.StyleHint = ... # 0x12
        SH_ComboBox_ListMouseTracking: QStyle.StyleHint = ... # 0x13
        SH_Menu_MouseTracking    : QStyle.StyleHint = ... # 0x14
        SH_MenuBar_MouseTracking : QStyle.StyleHint = ... # 0x15
        SH_ItemView_ChangeHighlightOnFocus: QStyle.StyleHint = ... # 0x16
        SH_Widget_ShareActivation: QStyle.StyleHint = ... # 0x17
        SH_Workspace_FillSpaceOnMaximize: QStyle.StyleHint = ... # 0x18
        SH_ComboBox_Popup        : QStyle.StyleHint = ... # 0x19
        SH_TitleBar_NoBorder     : QStyle.StyleHint = ... # 0x1a
        SH_ScrollBar_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
        SH_Slider_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
        SH_BlinkCursorWhenTextSelected: QStyle.StyleHint = ... # 0x1c
        SH_RichText_FullWidthSelection: QStyle.StyleHint = ... # 0x1d
        SH_Menu_Scrollable       : QStyle.StyleHint = ... # 0x1e
        SH_GroupBox_TextLabelVerticalAlignment: QStyle.StyleHint = ... # 0x1f
        SH_GroupBox_TextLabelColor: QStyle.StyleHint = ... # 0x20
        SH_Menu_SloppySubMenus   : QStyle.StyleHint = ... # 0x21
        SH_Table_GridLineColor   : QStyle.StyleHint = ... # 0x22
        SH_LineEdit_PasswordCharacter: QStyle.StyleHint = ... # 0x23
        SH_DialogButtons_DefaultButton: QStyle.StyleHint = ... # 0x24
        SH_ToolBox_SelectedPageTitleBold: QStyle.StyleHint = ... # 0x25
        SH_TabBar_PreferNoArrows : QStyle.StyleHint = ... # 0x26
        SH_ScrollBar_LeftClickAbsolutePosition: QStyle.StyleHint = ... # 0x27
        SH_ListViewExpand_SelectMouseType: QStyle.StyleHint = ... # 0x28
        SH_UnderlineShortcut     : QStyle.StyleHint = ... # 0x29
        SH_SpinBox_AnimateButton : QStyle.StyleHint = ... # 0x2a
        SH_SpinBox_KeyPressAutoRepeatRate: QStyle.StyleHint = ... # 0x2b
        SH_SpinBox_ClickAutoRepeatRate: QStyle.StyleHint = ... # 0x2c
        SH_Menu_FillScreenWithScroll: QStyle.StyleHint = ... # 0x2d
        SH_ToolTipLabel_Opacity  : QStyle.StyleHint = ... # 0x2e
        SH_DrawMenuBarSeparator  : QStyle.StyleHint = ... # 0x2f
        SH_TitleBar_ModifyNotification: QStyle.StyleHint = ... # 0x30
        SH_Button_FocusPolicy    : QStyle.StyleHint = ... # 0x31
        SH_MessageBox_UseBorderForButtonSpacing: QStyle.StyleHint = ... # 0x32
        SH_TitleBar_AutoRaise    : QStyle.StyleHint = ... # 0x33
        SH_ToolButton_PopupDelay : QStyle.StyleHint = ... # 0x34
        SH_FocusFrame_Mask       : QStyle.StyleHint = ... # 0x35
        SH_RubberBand_Mask       : QStyle.StyleHint = ... # 0x36
        SH_WindowFrame_Mask      : QStyle.StyleHint = ... # 0x37
        SH_SpinControls_DisableOnBounds: QStyle.StyleHint = ... # 0x38
        SH_Dial_BackgroundRole   : QStyle.StyleHint = ... # 0x39
        SH_ComboBox_LayoutDirection: QStyle.StyleHint = ... # 0x3a
        SH_ItemView_EllipsisLocation: QStyle.StyleHint = ... # 0x3b
        SH_ItemView_ShowDecorationSelected: QStyle.StyleHint = ... # 0x3c
        SH_ItemView_ActivateItemOnSingleClick: QStyle.StyleHint = ... # 0x3d
        SH_ScrollBar_ContextMenu : QStyle.StyleHint = ... # 0x3e
        SH_ScrollBar_RollBetweenButtons: QStyle.StyleHint = ... # 0x3f
        SH_Slider_AbsoluteSetButtons: QStyle.StyleHint = ... # 0x40
        SH_Slider_PageSetButtons : QStyle.StyleHint = ... # 0x41
        SH_Menu_KeyboardSearch   : QStyle.StyleHint = ... # 0x42
        SH_TabBar_ElideMode      : QStyle.StyleHint = ... # 0x43
        SH_DialogButtonLayout    : QStyle.StyleHint = ... # 0x44
        SH_ComboBox_PopupFrameStyle: QStyle.StyleHint = ... # 0x45
        SH_MessageBox_TextInteractionFlags: QStyle.StyleHint = ... # 0x46
        SH_DialogButtonBox_ButtonsHaveIcons: QStyle.StyleHint = ... # 0x47
        SH_SpellCheckUnderlineStyle: QStyle.StyleHint = ... # 0x48
        SH_MessageBox_CenterButtons: QStyle.StyleHint = ... # 0x49
        SH_Menu_SelectionWrap    : QStyle.StyleHint = ... # 0x4a
        SH_ItemView_MovementWithoutUpdatingSelection: QStyle.StyleHint = ... # 0x4b
        SH_ToolTip_Mask          : QStyle.StyleHint = ... # 0x4c
        SH_FocusFrame_AboveWidget: QStyle.StyleHint = ... # 0x4d
        SH_TextControl_FocusIndicatorTextCharFormat: QStyle.StyleHint = ... # 0x4e
        SH_WizardStyle           : QStyle.StyleHint = ... # 0x4f
        SH_ItemView_ArrowKeysNavigateIntoChildren: QStyle.StyleHint = ... # 0x50
        SH_Menu_Mask             : QStyle.StyleHint = ... # 0x51
        SH_Menu_FlashTriggeredItem: QStyle.StyleHint = ... # 0x52
        SH_Menu_FadeOutOnHide    : QStyle.StyleHint = ... # 0x53
        SH_SpinBox_ClickAutoRepeatThreshold: QStyle.StyleHint = ... # 0x54
        SH_ItemView_PaintAlternatingRowColorsForEmptyArea: QStyle.StyleHint = ... # 0x55
        SH_FormLayoutWrapPolicy  : QStyle.StyleHint = ... # 0x56
        SH_TabWidget_DefaultTabPosition: QStyle.StyleHint = ... # 0x57
        SH_ToolBar_Movable       : QStyle.StyleHint = ... # 0x58
        SH_FormLayoutFieldGrowthPolicy: QStyle.StyleHint = ... # 0x59
        SH_FormLayoutFormAlignment: QStyle.StyleHint = ... # 0x5a
        SH_FormLayoutLabelAlignment: QStyle.StyleHint = ... # 0x5b
        SH_ItemView_DrawDelegateFrame: QStyle.StyleHint = ... # 0x5c
        SH_TabBar_CloseButtonPosition: QStyle.StyleHint = ... # 0x5d
        SH_DockWidget_ButtonsHaveFrame: QStyle.StyleHint = ... # 0x5e
        SH_ToolButtonStyle       : QStyle.StyleHint = ... # 0x5f
        SH_RequestSoftwareInputPanel: QStyle.StyleHint = ... # 0x60
        SH_ScrollBar_Transient   : QStyle.StyleHint = ... # 0x61
        SH_Menu_SupportsSections : QStyle.StyleHint = ... # 0x62
        SH_ToolTip_WakeUpDelay   : QStyle.StyleHint = ... # 0x63
        SH_ToolTip_FallAsleepDelay: QStyle.StyleHint = ... # 0x64
        SH_Widget_Animate        : QStyle.StyleHint = ... # 0x65
        SH_Splitter_OpaqueResize : QStyle.StyleHint = ... # 0x66
        SH_ComboBox_UseNativePopup: QStyle.StyleHint = ... # 0x67
        SH_LineEdit_PasswordMaskDelay: QStyle.StyleHint = ... # 0x68
        SH_TabBar_ChangeCurrentDelay: QStyle.StyleHint = ... # 0x69
        SH_Menu_SubMenuUniDirection: QStyle.StyleHint = ... # 0x6a
        SH_Menu_SubMenuUniDirectionFailCount: QStyle.StyleHint = ... # 0x6b
        SH_Menu_SubMenuSloppySelectOtherActions: QStyle.StyleHint = ... # 0x6c
        SH_Menu_SubMenuSloppyCloseTimeout: QStyle.StyleHint = ... # 0x6d
        SH_Menu_SubMenuResetWhenReenteringParent: QStyle.StyleHint = ... # 0x6e
        SH_Menu_SubMenuDontStartSloppyOnLeave: QStyle.StyleHint = ... # 0x6f
        SH_ItemView_ScrollMode   : QStyle.StyleHint = ... # 0x70
        SH_TitleBar_ShowToolTipsOnButtons: QStyle.StyleHint = ... # 0x71
        SH_Widget_Animation_Duration: QStyle.StyleHint = ... # 0x72
        SH_ComboBox_AllowWheelScrolling: QStyle.StyleHint = ... # 0x73
        SH_SpinBox_ButtonsInsideFrame: QStyle.StyleHint = ... # 0x74
        SH_SpinBox_StepModifier  : QStyle.StyleHint = ... # 0x75

    class SubControl(object):
        SC_CustomBase            : QStyle.SubControl = ... # -0x10000000
        SC_All                   : QStyle.SubControl = ... # -0x1
        SC_None                  : QStyle.SubControl = ... # 0x0
        SC_ComboBoxFrame         : QStyle.SubControl = ... # 0x1
        SC_DialGroove            : QStyle.SubControl = ... # 0x1
        SC_GroupBoxCheckBox      : QStyle.SubControl = ... # 0x1
        SC_MdiMinButton          : QStyle.SubControl = ... # 0x1
        SC_ScrollBarAddLine      : QStyle.SubControl = ... # 0x1
        SC_SliderGroove          : QStyle.SubControl = ... # 0x1
        SC_SpinBoxUp             : QStyle.SubControl = ... # 0x1
        SC_TitleBarSysMenu       : QStyle.SubControl = ... # 0x1
        SC_ToolButton            : QStyle.SubControl = ... # 0x1
        SC_ComboBoxEditField     : QStyle.SubControl = ... # 0x2
        SC_DialHandle            : QStyle.SubControl = ... # 0x2
        SC_GroupBoxLabel         : QStyle.SubControl = ... # 0x2
        SC_MdiNormalButton       : QStyle.SubControl = ... # 0x2
        SC_ScrollBarSubLine      : QStyle.SubControl = ... # 0x2
        SC_SliderHandle          : QStyle.SubControl = ... # 0x2
        SC_SpinBoxDown           : QStyle.SubControl = ... # 0x2
        SC_TitleBarMinButton     : QStyle.SubControl = ... # 0x2
        SC_ToolButtonMenu        : QStyle.SubControl = ... # 0x2
        SC_ComboBoxArrow         : QStyle.SubControl = ... # 0x4
        SC_DialTickmarks         : QStyle.SubControl = ... # 0x4
        SC_GroupBoxContents      : QStyle.SubControl = ... # 0x4
        SC_MdiCloseButton        : QStyle.SubControl = ... # 0x4
        SC_ScrollBarAddPage      : QStyle.SubControl = ... # 0x4
        SC_SliderTickmarks       : QStyle.SubControl = ... # 0x4
        SC_SpinBoxFrame          : QStyle.SubControl = ... # 0x4
        SC_TitleBarMaxButton     : QStyle.SubControl = ... # 0x4
        SC_ComboBoxListBoxPopup  : QStyle.SubControl = ... # 0x8
        SC_GroupBoxFrame         : QStyle.SubControl = ... # 0x8
        SC_ScrollBarSubPage      : QStyle.SubControl = ... # 0x8
        SC_SpinBoxEditField      : QStyle.SubControl = ... # 0x8
        SC_TitleBarCloseButton   : QStyle.SubControl = ... # 0x8
        SC_ScrollBarFirst        : QStyle.SubControl = ... # 0x10
        SC_TitleBarNormalButton  : QStyle.SubControl = ... # 0x10
        SC_ScrollBarLast         : QStyle.SubControl = ... # 0x20
        SC_TitleBarShadeButton   : QStyle.SubControl = ... # 0x20
        SC_ScrollBarSlider       : QStyle.SubControl = ... # 0x40
        SC_TitleBarUnshadeButton : QStyle.SubControl = ... # 0x40
        SC_ScrollBarGroove       : QStyle.SubControl = ... # 0x80
        SC_TitleBarContextHelpButton: QStyle.SubControl = ... # 0x80
        SC_TitleBarLabel         : QStyle.SubControl = ... # 0x100

    class SubControls(object): ...

    class SubElement(object):
        SE_CustomBase            : QStyle.SubElement = ... # -0x10000000
        SE_PushButtonContents    : QStyle.SubElement = ... # 0x0
        SE_PushButtonFocusRect   : QStyle.SubElement = ... # 0x1
        SE_CheckBoxIndicator     : QStyle.SubElement = ... # 0x2
        SE_CheckBoxContents      : QStyle.SubElement = ... # 0x3
        SE_CheckBoxFocusRect     : QStyle.SubElement = ... # 0x4
        SE_CheckBoxClickRect     : QStyle.SubElement = ... # 0x5
        SE_RadioButtonIndicator  : QStyle.SubElement = ... # 0x6
        SE_RadioButtonContents   : QStyle.SubElement = ... # 0x7
        SE_RadioButtonFocusRect  : QStyle.SubElement = ... # 0x8
        SE_RadioButtonClickRect  : QStyle.SubElement = ... # 0x9
        SE_ComboBoxFocusRect     : QStyle.SubElement = ... # 0xa
        SE_SliderFocusRect       : QStyle.SubElement = ... # 0xb
        SE_ProgressBarGroove     : QStyle.SubElement = ... # 0xc
        SE_ProgressBarContents   : QStyle.SubElement = ... # 0xd
        SE_ProgressBarLabel      : QStyle.SubElement = ... # 0xe
        SE_ToolBoxTabContents    : QStyle.SubElement = ... # 0xf
        SE_HeaderLabel           : QStyle.SubElement = ... # 0x10
        SE_HeaderArrow           : QStyle.SubElement = ... # 0x11
        SE_TabWidgetTabBar       : QStyle.SubElement = ... # 0x12
        SE_TabWidgetTabPane      : QStyle.SubElement = ... # 0x13
        SE_TabWidgetTabContents  : QStyle.SubElement = ... # 0x14
        SE_TabWidgetLeftCorner   : QStyle.SubElement = ... # 0x15
        SE_TabWidgetRightCorner  : QStyle.SubElement = ... # 0x16
        SE_ItemViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
        SE_ViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
        SE_TabBarTearIndicator   : QStyle.SubElement = ... # 0x18
        SE_TabBarTearIndicatorLeft: QStyle.SubElement = ... # 0x18
        SE_TreeViewDisclosureItem: QStyle.SubElement = ... # 0x19
        SE_LineEditContents      : QStyle.SubElement = ... # 0x1a
        SE_FrameContents         : QStyle.SubElement = ... # 0x1b
        SE_DockWidgetCloseButton : QStyle.SubElement = ... # 0x1c
        SE_DockWidgetFloatButton : QStyle.SubElement = ... # 0x1d
        SE_DockWidgetTitleBarText: QStyle.SubElement = ... # 0x1e
        SE_DockWidgetIcon        : QStyle.SubElement = ... # 0x1f
        SE_CheckBoxLayoutItem    : QStyle.SubElement = ... # 0x20
        SE_ComboBoxLayoutItem    : QStyle.SubElement = ... # 0x21
        SE_DateTimeEditLayoutItem: QStyle.SubElement = ... # 0x22
        SE_DialogButtonBoxLayoutItem: QStyle.SubElement = ... # 0x23
        SE_LabelLayoutItem       : QStyle.SubElement = ... # 0x24
        SE_ProgressBarLayoutItem : QStyle.SubElement = ... # 0x25
        SE_PushButtonLayoutItem  : QStyle.SubElement = ... # 0x26
        SE_RadioButtonLayoutItem : QStyle.SubElement = ... # 0x27
        SE_SliderLayoutItem      : QStyle.SubElement = ... # 0x28
        SE_SpinBoxLayoutItem     : QStyle.SubElement = ... # 0x29
        SE_ToolButtonLayoutItem  : QStyle.SubElement = ... # 0x2a
        SE_FrameLayoutItem       : QStyle.SubElement = ... # 0x2b
        SE_GroupBoxLayoutItem    : QStyle.SubElement = ... # 0x2c
        SE_TabWidgetLayoutItem   : QStyle.SubElement = ... # 0x2d
        SE_ItemViewItemDecoration: QStyle.SubElement = ... # 0x2e
        SE_ItemViewItemText      : QStyle.SubElement = ... # 0x2f
        SE_ItemViewItemFocusRect : QStyle.SubElement = ... # 0x30
        SE_TabBarTabLeftButton   : QStyle.SubElement = ... # 0x31
        SE_TabBarTabRightButton  : QStyle.SubElement = ... # 0x32
        SE_TabBarTabText         : QStyle.SubElement = ... # 0x33
        SE_ShapedFrameContents   : QStyle.SubElement = ... # 0x34
        SE_ToolBarHandle         : QStyle.SubElement = ... # 0x35
        SE_TabBarScrollLeftButton: QStyle.SubElement = ... # 0x36
        SE_TabBarScrollRightButton: QStyle.SubElement = ... # 0x37
        SE_TabBarTearIndicatorRight: QStyle.SubElement = ... # 0x38

    def __init__(self): ...

    @staticmethod
    def alignedRect(direction:PySide2.QtCore.Qt.LayoutDirection, alignment:PySide2.QtCore.Qt.Alignment, size:PySide2.QtCore.QSize, rectangle:PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...
    def combinedLayoutSpacing(self, controls1:PySide2.QtWidgets.QSizePolicy.ControlTypes, controls2:PySide2.QtWidgets.QSizePolicy.ControlTypes, orientation:PySide2.QtCore.Qt.Orientation, option:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> int: ...
    def drawComplexControl(self, cc:PySide2.QtWidgets.QStyle.ComplexControl, opt:PySide2.QtWidgets.QStyleOptionComplex, p:PySide2.QtGui.QPainter, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def drawControl(self, element:PySide2.QtWidgets.QStyle.ControlElement, opt:PySide2.QtWidgets.QStyleOption, p:PySide2.QtGui.QPainter, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def drawItemPixmap(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRect, alignment:int, pixmap:PySide2.QtGui.QPixmap): ...
    def drawItemText(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRect, flags:int, pal:PySide2.QtGui.QPalette, enabled:bool, text:str, textRole:PySide2.QtGui.QPalette.ColorRole=...): ...
    def drawPrimitive(self, pe:PySide2.QtWidgets.QStyle.PrimitiveElement, opt:PySide2.QtWidgets.QStyleOption, p:PySide2.QtGui.QPainter, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    def generatedIconPixmap(self, iconMode:PySide2.QtGui.QIcon.Mode, pixmap:PySide2.QtGui.QPixmap, opt:PySide2.QtWidgets.QStyleOption) -> PySide2.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc:PySide2.QtWidgets.QStyle.ComplexControl, opt:PySide2.QtWidgets.QStyleOptionComplex, pt:PySide2.QtCore.QPoint, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtWidgets.QStyle.SubControl: ...
    def itemPixmapRect(self, r:PySide2.QtCore.QRect, flags:int, pixmap:PySide2.QtGui.QPixmap) -> PySide2.QtCore.QRect: ...
    def itemTextRect(self, fm:PySide2.QtGui.QFontMetrics, r:PySide2.QtCore.QRect, flags:int, enabled:bool, text:str) -> PySide2.QtCore.QRect: ...
    def layoutSpacing(self, control1:PySide2.QtWidgets.QSizePolicy.ControlType, control2:PySide2.QtWidgets.QSizePolicy.ControlType, orientation:PySide2.QtCore.Qt.Orientation, option:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> int: ...
    def pixelMetric(self, metric:PySide2.QtWidgets.QStyle.PixelMetric, option:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> int: ...
    @typing.overload
    def polish(self, application:PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def polish(self, palette:PySide2.QtGui.QPalette): ...
    @typing.overload
    def polish(self, widget:PySide2.QtWidgets.QWidget): ...
    def proxy(self) -> PySide2.QtWidgets.QStyle: ...
    def sizeFromContents(self, ct:PySide2.QtWidgets.QStyle.ContentsType, opt:PySide2.QtWidgets.QStyleOption, contentsSize:PySide2.QtCore.QSize, w:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtCore.QSize: ...
    @staticmethod
    def sliderPositionFromValue(min:int, max:int, val:int, space:int, upsideDown:bool=...) -> int: ...
    @staticmethod
    def sliderValueFromPosition(min:int, max:int, pos:int, space:int, upsideDown:bool=...) -> int: ...
    def standardIcon(self, standardIcon:PySide2.QtWidgets.QStyle.StandardPixmap, option:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtGui.QIcon: ...
    def standardPalette(self) -> PySide2.QtGui.QPalette: ...
    def standardPixmap(self, standardPixmap:PySide2.QtWidgets.QStyle.StandardPixmap, opt:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtGui.QPixmap: ...
    def styleHint(self, stylehint:PySide2.QtWidgets.QStyle.StyleHint, opt:typing.Optional[PySide2.QtWidgets.QStyleOption]=..., widget:typing.Optional[PySide2.QtWidgets.QWidget]=..., returnData:typing.Optional[PySide2.QtWidgets.QStyleHintReturn]=...) -> int: ...
    def subControlRect(self, cc:PySide2.QtWidgets.QStyle.ComplexControl, opt:PySide2.QtWidgets.QStyleOptionComplex, sc:PySide2.QtWidgets.QStyle.SubControl, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtCore.QRect: ...
    def subElementRect(self, subElement:PySide2.QtWidgets.QStyle.SubElement, option:PySide2.QtWidgets.QStyleOption, widget:typing.Optional[PySide2.QtWidgets.QWidget]=...) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, application:PySide2.QtWidgets.QApplication): ...
    @typing.overload
    def unpolish(self, widget:PySide2.QtWidgets.QWidget): ...
    @staticmethod
    def visualAlignment(direction:PySide2.QtCore.Qt.LayoutDirection, alignment:PySide2.QtCore.Qt.Alignment) -> PySide2.QtCore.Qt.Alignment: ...
    @staticmethod
    def visualPos(direction:PySide2.QtCore.Qt.LayoutDirection, boundingRect:PySide2.QtCore.QRect, logicalPos:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    @staticmethod
    def visualRect(direction:PySide2.QtCore.Qt.LayoutDirection, boundingRect:PySide2.QtCore.QRect, logicalRect:PySide2.QtCore.QRect) -> PySide2.QtCore.QRect: ...


class QStyleFactory(Shiboken.Object):

    def __init__(self): ...

    @staticmethod
    def create(arg__1:str) -> PySide2.QtWidgets.QStyle: ...
    @staticmethod
    def keys() -> typing.List: ...


class QStyleHintReturn(Shiboken.Object):
    Version                  : QStyleHintReturn = ... # 0x1
    SH_Default               : QStyleHintReturn = ... # 0xf000
    Type                     : QStyleHintReturn = ... # 0xf000
    SH_Mask                  : QStyleHintReturn = ... # 0xf001
    SH_Variant               : QStyleHintReturn = ... # 0xf002

    class HintReturnType(object):
        SH_Default               : QStyleHintReturn.HintReturnType = ... # 0xf000
        SH_Mask                  : QStyleHintReturn.HintReturnType = ... # 0xf001
        SH_Variant               : QStyleHintReturn.HintReturnType = ... # 0xf002

    class StyleOptionType(object):
        Type                     : QStyleHintReturn.StyleOptionType = ... # 0xf000

    class StyleOptionVersion(object):
        Version                  : QStyleHintReturn.StyleOptionVersion = ... # 0x1

    def __init__(self, version:int=..., type:int=...): ...


class QStyleHintReturnMask(PySide2.QtWidgets.QStyleHintReturn):
    Version                  : QStyleHintReturnMask = ... # 0x1
    Type                     : QStyleHintReturnMask = ... # 0xf001

    class StyleOptionType(object):
        Type                     : QStyleHintReturnMask.StyleOptionType = ... # 0xf001

    class StyleOptionVersion(object):
        Version                  : QStyleHintReturnMask.StyleOptionVersion = ... # 0x1

    def __init__(self): ...


class QStyleHintReturnVariant(PySide2.QtWidgets.QStyleHintReturn):
    Version                  : QStyleHintReturnVariant = ... # 0x1
    Type                     : QStyleHintReturnVariant = ... # 0xf002

    class StyleOptionType(object):
        Type                     : QStyleHintReturnVariant.StyleOptionType = ... # 0xf002

    class StyleOptionVersion(object):
        Version                  : QStyleHintReturnVariant.StyleOptionVersion = ... # 0x1

    def __init__(self): ...


class QStyleOption(Shiboken.Object):
    SO_Default               : QStyleOption = ... # 0x0
    Type                     : QStyleOption = ... # 0x0
    SO_FocusRect             : QStyleOption = ... # 0x1
    Version                  : QStyleOption = ... # 0x1
    SO_Button                : QStyleOption = ... # 0x2
    SO_Tab                   : QStyleOption = ... # 0x3
    SO_MenuItem              : QStyleOption = ... # 0x4
    SO_Frame                 : QStyleOption = ... # 0x5
    SO_ProgressBar           : QStyleOption = ... # 0x6
    SO_ToolBox               : QStyleOption = ... # 0x7
    SO_Header                : QStyleOption = ... # 0x8
    SO_DockWidget            : QStyleOption = ... # 0x9
    SO_ViewItem              : QStyleOption = ... # 0xa
    SO_TabWidgetFrame        : QStyleOption = ... # 0xb
    SO_TabBarBase            : QStyleOption = ... # 0xc
    SO_RubberBand            : QStyleOption = ... # 0xd
    SO_ToolBar               : QStyleOption = ... # 0xe
    SO_GraphicsItem          : QStyleOption = ... # 0xf
    SO_CustomBase            : QStyleOption = ... # 0xf00
    SO_Complex               : QStyleOption = ... # 0xf0000
    SO_Slider                : QStyleOption = ... # 0xf0001
    SO_SpinBox               : QStyleOption = ... # 0xf0002
    SO_ToolButton            : QStyleOption = ... # 0xf0003
    SO_ComboBox              : QStyleOption = ... # 0xf0004
    SO_TitleBar              : QStyleOption = ... # 0xf0005
    SO_GroupBox              : QStyleOption = ... # 0xf0006
    SO_SizeGrip              : QStyleOption = ... # 0xf0007
    SO_ComplexCustomBase     : QStyleOption = ... # 0xf000000

    class OptionType(object):
        SO_Default               : QStyleOption.OptionType = ... # 0x0
        SO_FocusRect             : QStyleOption.OptionType = ... # 0x1
        SO_Button                : QStyleOption.OptionType = ... # 0x2
        SO_Tab                   : QStyleOption.OptionType = ... # 0x3
        SO_MenuItem              : QStyleOption.OptionType = ... # 0x4
        SO_Frame                 : QStyleOption.OptionType = ... # 0x5
        SO_ProgressBar           : QStyleOption.OptionType = ... # 0x6
        SO_ToolBox               : QStyleOption.OptionType = ... # 0x7
        SO_Header                : QStyleOption.OptionType = ... # 0x8
        SO_DockWidget            : QStyleOption.OptionType = ... # 0x9
        SO_ViewItem              : QStyleOption.OptionType = ... # 0xa
        SO_TabWidgetFrame        : QStyleOption.OptionType = ... # 0xb
        SO_TabBarBase            : QStyleOption.OptionType = ... # 0xc
        SO_RubberBand            : QStyleOption.OptionType = ... # 0xd
        SO_ToolBar               : QStyleOption.OptionType = ... # 0xe
        SO_GraphicsItem          : QStyleOption.OptionType = ... # 0xf
        SO_CustomBase            : QStyleOption.OptionType = ... # 0xf00
        SO_Complex               : QStyleOption.OptionType = ... # 0xf0000
        SO_Slider                : QStyleOption.OptionType = ... # 0xf0001
        SO_SpinBox               : QStyleOption.OptionType = ... # 0xf0002
        SO_ToolButton            : QStyleOption.OptionType = ... # 0xf0003
        SO_ComboBox              : QStyleOption.OptionType = ... # 0xf0004
        SO_TitleBar              : QStyleOption.OptionType = ... # 0xf0005
        SO_GroupBox              : QStyleOption.OptionType = ... # 0xf0006
        SO_SizeGrip              : QStyleOption.OptionType = ... # 0xf0007
        SO_ComplexCustomBase     : QStyleOption.OptionType = ... # 0xf000000

    class StyleOptionType(object):
        Type                     : QStyleOption.StyleOptionType = ... # 0x0

    class StyleOptionVersion(object):
        Version                  : QStyleOption.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOption): ...
    @typing.overload
    def __init__(self, version:int=..., type:int=...): ...

    def init(self, w:PySide2.QtWidgets.QWidget): ...
    def initFrom(self, w:PySide2.QtWidgets.QWidget): ...


class QStyleOptionButton(PySide2.QtWidgets.QStyleOption):
    None_                    : QStyleOptionButton = ... # 0x0
    Flat                     : QStyleOptionButton = ... # 0x1
    Version                  : QStyleOptionButton = ... # 0x1
    HasMenu                  : QStyleOptionButton = ... # 0x2
    Type                     : QStyleOptionButton = ... # 0x2
    DefaultButton            : QStyleOptionButton = ... # 0x4
    AutoDefaultButton        : QStyleOptionButton = ... # 0x8
    CommandLinkButton        : QStyleOptionButton = ... # 0x10

    class ButtonFeature(object):
        None_                    : QStyleOptionButton.ButtonFeature = ... # 0x0
        Flat                     : QStyleOptionButton.ButtonFeature = ... # 0x1
        HasMenu                  : QStyleOptionButton.ButtonFeature = ... # 0x2
        DefaultButton            : QStyleOptionButton.ButtonFeature = ... # 0x4
        AutoDefaultButton        : QStyleOptionButton.ButtonFeature = ... # 0x8
        CommandLinkButton        : QStyleOptionButton.ButtonFeature = ... # 0x10

    class ButtonFeatures(object): ...

    class StyleOptionType(object):
        Type                     : QStyleOptionButton.StyleOptionType = ... # 0x2

    class StyleOptionVersion(object):
        Version                  : QStyleOptionButton.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionButton): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionComboBox(PySide2.QtWidgets.QStyleOptionComplex):
    Version                  : QStyleOptionComboBox = ... # 0x1
    Type                     : QStyleOptionComboBox = ... # 0xf0004

    class StyleOptionType(object):
        Type                     : QStyleOptionComboBox.StyleOptionType = ... # 0xf0004

    class StyleOptionVersion(object):
        Version                  : QStyleOptionComboBox.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionComboBox): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionComplex(PySide2.QtWidgets.QStyleOption):
    Version                  : QStyleOptionComplex = ... # 0x1
    Type                     : QStyleOptionComplex = ... # 0xf0000

    class StyleOptionType(object):
        Type                     : QStyleOptionComplex.StyleOptionType = ... # 0xf0000

    class StyleOptionVersion(object):
        Version                  : QStyleOptionComplex.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionComplex): ...
    @typing.overload
    def __init__(self, version:int=..., type:int=...): ...


class QStyleOptionDockWidget(PySide2.QtWidgets.QStyleOption):
    Version                  : QStyleOptionDockWidget = ... # 0x2
    Type                     : QStyleOptionDockWidget = ... # 0x9

    class StyleOptionType(object):
        Type                     : QStyleOptionDockWidget.StyleOptionType = ... # 0x9

    class StyleOptionVersion(object):
        Version                  : QStyleOptionDockWidget.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionDockWidget): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionFocusRect(PySide2.QtWidgets.QStyleOption):
    Type                     : QStyleOptionFocusRect = ... # 0x1
    Version                  : QStyleOptionFocusRect = ... # 0x1

    class StyleOptionType(object):
        Type                     : QStyleOptionFocusRect.StyleOptionType = ... # 0x1

    class StyleOptionVersion(object):
        Version                  : QStyleOptionFocusRect.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionFocusRect): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionFrame(PySide2.QtWidgets.QStyleOption):
    None_                    : QStyleOptionFrame = ... # 0x0
    Flat                     : QStyleOptionFrame = ... # 0x1
    Rounded                  : QStyleOptionFrame = ... # 0x2
    Version                  : QStyleOptionFrame = ... # 0x3
    Type                     : QStyleOptionFrame = ... # 0x5

    class FrameFeature(object):
        None_                    : QStyleOptionFrame.FrameFeature = ... # 0x0
        Flat                     : QStyleOptionFrame.FrameFeature = ... # 0x1
        Rounded                  : QStyleOptionFrame.FrameFeature = ... # 0x2

    class FrameFeatures(object): ...

    class StyleOptionType(object):
        Type                     : QStyleOptionFrame.StyleOptionType = ... # 0x5

    class StyleOptionVersion(object):
        Version                  : QStyleOptionFrame.StyleOptionVersion = ... # 0x3

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionFrame): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionGraphicsItem(PySide2.QtWidgets.QStyleOption):
    Version                  : QStyleOptionGraphicsItem = ... # 0x1
    Type                     : QStyleOptionGraphicsItem = ... # 0xf

    class StyleOptionType(object):
        Type                     : QStyleOptionGraphicsItem.StyleOptionType = ... # 0xf

    class StyleOptionVersion(object):
        Version                  : QStyleOptionGraphicsItem.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionGraphicsItem): ...
    @typing.overload
    def __init__(self, version:int): ...

    @staticmethod
    def levelOfDetailFromTransform(worldTransform:PySide2.QtGui.QTransform) -> float: ...


class QStyleOptionGroupBox(PySide2.QtWidgets.QStyleOptionComplex):
    Version                  : QStyleOptionGroupBox = ... # 0x1
    Type                     : QStyleOptionGroupBox = ... # 0xf0006

    class StyleOptionType(object):
        Type                     : QStyleOptionGroupBox.StyleOptionType = ... # 0xf0006

    class StyleOptionVersion(object):
        Version                  : QStyleOptionGroupBox.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionGroupBox): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionHeader(PySide2.QtWidgets.QStyleOption):
    Beginning                : QStyleOptionHeader = ... # 0x0
    None_                    : QStyleOptionHeader = ... # 0x0
    NotAdjacent              : QStyleOptionHeader = ... # 0x0
    Middle                   : QStyleOptionHeader = ... # 0x1
    NextIsSelected           : QStyleOptionHeader = ... # 0x1
    SortUp                   : QStyleOptionHeader = ... # 0x1
    Version                  : QStyleOptionHeader = ... # 0x1
    End                      : QStyleOptionHeader = ... # 0x2
    PreviousIsSelected       : QStyleOptionHeader = ... # 0x2
    SortDown                 : QStyleOptionHeader = ... # 0x2
    NextAndPreviousAreSelected: QStyleOptionHeader = ... # 0x3
    OnlyOneSection           : QStyleOptionHeader = ... # 0x3
    Type                     : QStyleOptionHeader = ... # 0x8

    class SectionPosition(object):
        Beginning                : QStyleOptionHeader.SectionPosition = ... # 0x0
        Middle                   : QStyleOptionHeader.SectionPosition = ... # 0x1
        End                      : QStyleOptionHeader.SectionPosition = ... # 0x2
        OnlyOneSection           : QStyleOptionHeader.SectionPosition = ... # 0x3

    class SelectedPosition(object):
        NotAdjacent              : QStyleOptionHeader.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionHeader.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionHeader.SelectedPosition = ... # 0x2
        NextAndPreviousAreSelected: QStyleOptionHeader.SelectedPosition = ... # 0x3

    class SortIndicator(object):
        None_                    : QStyleOptionHeader.SortIndicator = ... # 0x0
        SortUp                   : QStyleOptionHeader.SortIndicator = ... # 0x1
        SortDown                 : QStyleOptionHeader.SortIndicator = ... # 0x2

    class StyleOptionType(object):
        Type                     : QStyleOptionHeader.StyleOptionType = ... # 0x8

    class StyleOptionVersion(object):
        Version                  : QStyleOptionHeader.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionHeader): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionMenuItem(PySide2.QtWidgets.QStyleOption):
    Normal                   : QStyleOptionMenuItem = ... # 0x0
    NotCheckable             : QStyleOptionMenuItem = ... # 0x0
    DefaultItem              : QStyleOptionMenuItem = ... # 0x1
    Exclusive                : QStyleOptionMenuItem = ... # 0x1
    Version                  : QStyleOptionMenuItem = ... # 0x1
    NonExclusive             : QStyleOptionMenuItem = ... # 0x2
    Separator                : QStyleOptionMenuItem = ... # 0x2
    SubMenu                  : QStyleOptionMenuItem = ... # 0x3
    Scroller                 : QStyleOptionMenuItem = ... # 0x4
    Type                     : QStyleOptionMenuItem = ... # 0x4
    TearOff                  : QStyleOptionMenuItem = ... # 0x5
    Margin                   : QStyleOptionMenuItem = ... # 0x6
    EmptyArea                : QStyleOptionMenuItem = ... # 0x7

    class CheckType(object):
        NotCheckable             : QStyleOptionMenuItem.CheckType = ... # 0x0
        Exclusive                : QStyleOptionMenuItem.CheckType = ... # 0x1
        NonExclusive             : QStyleOptionMenuItem.CheckType = ... # 0x2

    class MenuItemType(object):
        Normal                   : QStyleOptionMenuItem.MenuItemType = ... # 0x0
        DefaultItem              : QStyleOptionMenuItem.MenuItemType = ... # 0x1
        Separator                : QStyleOptionMenuItem.MenuItemType = ... # 0x2
        SubMenu                  : QStyleOptionMenuItem.MenuItemType = ... # 0x3
        Scroller                 : QStyleOptionMenuItem.MenuItemType = ... # 0x4
        TearOff                  : QStyleOptionMenuItem.MenuItemType = ... # 0x5
        Margin                   : QStyleOptionMenuItem.MenuItemType = ... # 0x6
        EmptyArea                : QStyleOptionMenuItem.MenuItemType = ... # 0x7

    class StyleOptionType(object):
        Type                     : QStyleOptionMenuItem.StyleOptionType = ... # 0x4

    class StyleOptionVersion(object):
        Version                  : QStyleOptionMenuItem.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionMenuItem): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionProgressBar(PySide2.QtWidgets.QStyleOption):
    Version                  : QStyleOptionProgressBar = ... # 0x2
    Type                     : QStyleOptionProgressBar = ... # 0x6

    class StyleOptionType(object):
        Type                     : QStyleOptionProgressBar.StyleOptionType = ... # 0x6

    class StyleOptionVersion(object):
        Version                  : QStyleOptionProgressBar.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionProgressBar): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionRubberBand(PySide2.QtWidgets.QStyleOption):
    Version                  : QStyleOptionRubberBand = ... # 0x1
    Type                     : QStyleOptionRubberBand = ... # 0xd

    class StyleOptionType(object):
        Type                     : QStyleOptionRubberBand.StyleOptionType = ... # 0xd

    class StyleOptionVersion(object):
        Version                  : QStyleOptionRubberBand.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionRubberBand): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionSizeGrip(PySide2.QtWidgets.QStyleOptionComplex):
    Version                  : QStyleOptionSizeGrip = ... # 0x1
    Type                     : QStyleOptionSizeGrip = ... # 0xf0007

    class StyleOptionType(object):
        Type                     : QStyleOptionSizeGrip.StyleOptionType = ... # 0xf0007

    class StyleOptionVersion(object):
        Version                  : QStyleOptionSizeGrip.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionSizeGrip): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionSlider(PySide2.QtWidgets.QStyleOptionComplex):
    Version                  : QStyleOptionSlider = ... # 0x1
    Type                     : QStyleOptionSlider = ... # 0xf0001

    class StyleOptionType(object):
        Type                     : QStyleOptionSlider.StyleOptionType = ... # 0xf0001

    class StyleOptionVersion(object):
        Version                  : QStyleOptionSlider.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionSlider): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionSpinBox(PySide2.QtWidgets.QStyleOptionComplex):
    Version                  : QStyleOptionSpinBox = ... # 0x1
    Type                     : QStyleOptionSpinBox = ... # 0xf0002

    class StyleOptionType(object):
        Type                     : QStyleOptionSpinBox.StyleOptionType = ... # 0xf0002

    class StyleOptionVersion(object):
        Version                  : QStyleOptionSpinBox.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionSpinBox): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionTab(PySide2.QtWidgets.QStyleOption):
    Beginning                : QStyleOptionTab = ... # 0x0
    NoCornerWidgets          : QStyleOptionTab = ... # 0x0
    None_                    : QStyleOptionTab = ... # 0x0
    NotAdjacent              : QStyleOptionTab = ... # 0x0
    HasFrame                 : QStyleOptionTab = ... # 0x1
    LeftCornerWidget         : QStyleOptionTab = ... # 0x1
    Middle                   : QStyleOptionTab = ... # 0x1
    NextIsSelected           : QStyleOptionTab = ... # 0x1
    End                      : QStyleOptionTab = ... # 0x2
    PreviousIsSelected       : QStyleOptionTab = ... # 0x2
    RightCornerWidget        : QStyleOptionTab = ... # 0x2
    OnlyOneTab               : QStyleOptionTab = ... # 0x3
    Type                     : QStyleOptionTab = ... # 0x3
    Version                  : QStyleOptionTab = ... # 0x3

    class CornerWidget(object):
        NoCornerWidgets          : QStyleOptionTab.CornerWidget = ... # 0x0
        LeftCornerWidget         : QStyleOptionTab.CornerWidget = ... # 0x1
        RightCornerWidget        : QStyleOptionTab.CornerWidget = ... # 0x2

    class CornerWidgets(object): ...

    class SelectedPosition(object):
        NotAdjacent              : QStyleOptionTab.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionTab.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionTab.SelectedPosition = ... # 0x2

    class StyleOptionType(object):
        Type                     : QStyleOptionTab.StyleOptionType = ... # 0x3

    class StyleOptionVersion(object):
        Version                  : QStyleOptionTab.StyleOptionVersion = ... # 0x3

    class TabFeature(object):
        None_                    : QStyleOptionTab.TabFeature = ... # 0x0
        HasFrame                 : QStyleOptionTab.TabFeature = ... # 0x1

    class TabFeatures(object): ...

    class TabPosition(object):
        Beginning                : QStyleOptionTab.TabPosition = ... # 0x0
        Middle                   : QStyleOptionTab.TabPosition = ... # 0x1
        End                      : QStyleOptionTab.TabPosition = ... # 0x2
        OnlyOneTab               : QStyleOptionTab.TabPosition = ... # 0x3

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionTab): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionTabBarBase(PySide2.QtWidgets.QStyleOption):
    Version                  : QStyleOptionTabBarBase = ... # 0x2
    Type                     : QStyleOptionTabBarBase = ... # 0xc

    class StyleOptionType(object):
        Type                     : QStyleOptionTabBarBase.StyleOptionType = ... # 0xc

    class StyleOptionVersion(object):
        Version                  : QStyleOptionTabBarBase.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionTabBarBase): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionTabWidgetFrame(PySide2.QtWidgets.QStyleOption):
    Version                  : QStyleOptionTabWidgetFrame = ... # 0x2
    Type                     : QStyleOptionTabWidgetFrame = ... # 0xb

    class StyleOptionType(object):
        Type                     : QStyleOptionTabWidgetFrame.StyleOptionType = ... # 0xb

    class StyleOptionVersion(object):
        Version                  : QStyleOptionTabWidgetFrame.StyleOptionVersion = ... # 0x2

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionTabWidgetFrame): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionTitleBar(PySide2.QtWidgets.QStyleOptionComplex):
    Version                  : QStyleOptionTitleBar = ... # 0x1
    Type                     : QStyleOptionTitleBar = ... # 0xf0005

    class StyleOptionType(object):
        Type                     : QStyleOptionTitleBar.StyleOptionType = ... # 0xf0005

    class StyleOptionVersion(object):
        Version                  : QStyleOptionTitleBar.StyleOptionVersion = ... # 0x1

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionTitleBar): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionToolBar(PySide2.QtWidgets.QStyleOption):
    Beginning                : QStyleOptionToolBar = ... # 0x0
    None_                    : QStyleOptionToolBar = ... # 0x0
    Middle                   : QStyleOptionToolBar = ... # 0x1
    Movable                  : QStyleOptionToolBar = ... # 0x1
    Version                  : QStyleOptionToolBar = ... # 0x1
    End                      : QStyleOptionToolBar = ... # 0x2
    OnlyOne                  : QStyleOptionToolBar = ... # 0x3
    Type                     : QStyleOptionToolBar = ... # 0xe

    class StyleOptionType(object):
        Type                     : QStyleOptionToolBar.StyleOptionType = ... # 0xe

    class StyleOptionVersion(object):
        Version                  : QStyleOptionToolBar.StyleOptionVersion = ... # 0x1

    class ToolBarFeature(object):
        None_                    : QStyleOptionToolBar.ToolBarFeature = ... # 0x0
        Movable                  : QStyleOptionToolBar.ToolBarFeature = ... # 0x1

    class ToolBarFeatures(object): ...

    class ToolBarPosition(object):
        Beginning                : QStyleOptionToolBar.ToolBarPosition = ... # 0x0
        Middle                   : QStyleOptionToolBar.ToolBarPosition = ... # 0x1
        End                      : QStyleOptionToolBar.ToolBarPosition = ... # 0x2
        OnlyOne                  : QStyleOptionToolBar.ToolBarPosition = ... # 0x3

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionToolBar): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionToolBox(PySide2.QtWidgets.QStyleOption):
    Beginning                : QStyleOptionToolBox = ... # 0x0
    NotAdjacent              : QStyleOptionToolBox = ... # 0x0
    Middle                   : QStyleOptionToolBox = ... # 0x1
    NextIsSelected           : QStyleOptionToolBox = ... # 0x1
    End                      : QStyleOptionToolBox = ... # 0x2
    PreviousIsSelected       : QStyleOptionToolBox = ... # 0x2
    Version                  : QStyleOptionToolBox = ... # 0x2
    OnlyOneTab               : QStyleOptionToolBox = ... # 0x3
    Type                     : QStyleOptionToolBox = ... # 0x7

    class SelectedPosition(object):
        NotAdjacent              : QStyleOptionToolBox.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionToolBox.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionToolBox.SelectedPosition = ... # 0x2

    class StyleOptionType(object):
        Type                     : QStyleOptionToolBox.StyleOptionType = ... # 0x7

    class StyleOptionVersion(object):
        Version                  : QStyleOptionToolBox.StyleOptionVersion = ... # 0x2

    class TabPosition(object):
        Beginning                : QStyleOptionToolBox.TabPosition = ... # 0x0
        Middle                   : QStyleOptionToolBox.TabPosition = ... # 0x1
        End                      : QStyleOptionToolBox.TabPosition = ... # 0x2
        OnlyOneTab               : QStyleOptionToolBox.TabPosition = ... # 0x3

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionToolBox): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionToolButton(PySide2.QtWidgets.QStyleOptionComplex):
    None_                    : QStyleOptionToolButton = ... # 0x0
    Arrow                    : QStyleOptionToolButton = ... # 0x1
    Version                  : QStyleOptionToolButton = ... # 0x1
    Menu                     : QStyleOptionToolButton = ... # 0x4
    MenuButtonPopup          : QStyleOptionToolButton = ... # 0x4
    PopupDelay               : QStyleOptionToolButton = ... # 0x8
    HasMenu                  : QStyleOptionToolButton = ... # 0x10
    Type                     : QStyleOptionToolButton = ... # 0xf0003

    class StyleOptionType(object):
        Type                     : QStyleOptionToolButton.StyleOptionType = ... # 0xf0003

    class StyleOptionVersion(object):
        Version                  : QStyleOptionToolButton.StyleOptionVersion = ... # 0x1

    class ToolButtonFeature(object):
        None_                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x0
        Arrow                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x1
        Menu                     : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
        MenuButtonPopup          : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
        PopupDelay               : QStyleOptionToolButton.ToolButtonFeature = ... # 0x8
        HasMenu                  : QStyleOptionToolButton.ToolButtonFeature = ... # 0x10

    class ToolButtonFeatures(object): ...

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionToolButton): ...
    @typing.overload
    def __init__(self, version:int): ...


class QStyleOptionViewItem(PySide2.QtWidgets.QStyleOption):
    Invalid                  : QStyleOptionViewItem = ... # 0x0
    Left                     : QStyleOptionViewItem = ... # 0x0
    None_                    : QStyleOptionViewItem = ... # 0x0
    Beginning                : QStyleOptionViewItem = ... # 0x1
    Right                    : QStyleOptionViewItem = ... # 0x1
    WrapText                 : QStyleOptionViewItem = ... # 0x1
    Alternate                : QStyleOptionViewItem = ... # 0x2
    Middle                   : QStyleOptionViewItem = ... # 0x2
    Top                      : QStyleOptionViewItem = ... # 0x2
    Bottom                   : QStyleOptionViewItem = ... # 0x3
    End                      : QStyleOptionViewItem = ... # 0x3
    HasCheckIndicator        : QStyleOptionViewItem = ... # 0x4
    OnlyOne                  : QStyleOptionViewItem = ... # 0x4
    Version                  : QStyleOptionViewItem = ... # 0x4
    HasDisplay               : QStyleOptionViewItem = ... # 0x8
    Type                     : QStyleOptionViewItem = ... # 0xa
    HasDecoration            : QStyleOptionViewItem = ... # 0x10

    class Position(object):
        Left                     : QStyleOptionViewItem.Position = ... # 0x0
        Right                    : QStyleOptionViewItem.Position = ... # 0x1
        Top                      : QStyleOptionViewItem.Position = ... # 0x2
        Bottom                   : QStyleOptionViewItem.Position = ... # 0x3

    class StyleOptionType(object):
        Type                     : QStyleOptionViewItem.StyleOptionType = ... # 0xa

    class StyleOptionVersion(object):
        Version                  : QStyleOptionViewItem.StyleOptionVersion = ... # 0x4

    class ViewItemFeature(object):
        None_                    : QStyleOptionViewItem.ViewItemFeature = ... # 0x0
        WrapText                 : QStyleOptionViewItem.ViewItemFeature = ... # 0x1
        Alternate                : QStyleOptionViewItem.ViewItemFeature = ... # 0x2
        HasCheckIndicator        : QStyleOptionViewItem.ViewItemFeature = ... # 0x4
        HasDisplay               : QStyleOptionViewItem.ViewItemFeature = ... # 0x8
        HasDecoration            : QStyleOptionViewItem.ViewItemFeature = ... # 0x10

    class ViewItemFeatures(object): ...

    class ViewItemPosition(object):
        Invalid                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x0
        Beginning                : QStyleOptionViewItem.ViewItemPosition = ... # 0x1
        Middle                   : QStyleOptionViewItem.ViewItemPosition = ... # 0x2
        End                      : QStyleOptionViewItem.ViewItemPosition = ... # 0x3
        OnlyOne                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x4

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QStyleOptionViewItem): ...
    @typing.overload
    def __init__(self, version:int): ...

    def __copy__(self): ...


class QStylePainter(PySide2.QtGui.QPainter):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, pd:PySide2.QtGui.QPaintDevice, w:PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def __init__(self, w:PySide2.QtWidgets.QWidget): ...

    @typing.overload
    def begin(self, arg__1:PySide2.QtGui.QPaintDevice) -> bool: ...
    @typing.overload
    def begin(self, pd:PySide2.QtGui.QPaintDevice, w:PySide2.QtWidgets.QWidget) -> bool: ...
    @typing.overload
    def begin(self, w:PySide2.QtWidgets.QWidget) -> bool: ...
    def drawComplexControl(self, cc:PySide2.QtWidgets.QStyle.ComplexControl, opt:PySide2.QtWidgets.QStyleOptionComplex): ...
    def drawControl(self, ce:PySide2.QtWidgets.QStyle.ControlElement, opt:PySide2.QtWidgets.QStyleOption): ...
    def drawItemPixmap(self, r:PySide2.QtCore.QRect, flags:int, pixmap:PySide2.QtGui.QPixmap): ...
    def drawItemText(self, r:PySide2.QtCore.QRect, flags:int, pal:PySide2.QtGui.QPalette, enabled:bool, text:str, textRole:PySide2.QtGui.QPalette.ColorRole=...): ...
    def drawPrimitive(self, pe:PySide2.QtWidgets.QStyle.PrimitiveElement, opt:PySide2.QtWidgets.QStyleOption): ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...


class QStyledItemDelegate(PySide2.QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def createEditor(self, parent:PySide2.QtWidgets.QWidget, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QWidget: ...
    def displayText(self, value:typing.Any, locale:PySide2.QtCore.QLocale) -> str: ...
    def editorEvent(self, event:PySide2.QtCore.QEvent, model:PySide2.QtCore.QAbstractItemModel, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object:PySide2.QtCore.QObject, event:PySide2.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex): ...
    def itemEditorFactory(self) -> PySide2.QtWidgets.QItemEditorFactory: ...
    def paint(self, painter:PySide2.QtGui.QPainter, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex): ...
    def setEditorData(self, editor:PySide2.QtWidgets.QWidget, index:PySide2.QtCore.QModelIndex): ...
    def setItemEditorFactory(self, factory:PySide2.QtWidgets.QItemEditorFactory): ...
    def setModelData(self, editor:PySide2.QtWidgets.QWidget, model:PySide2.QtCore.QAbstractItemModel, index:PySide2.QtCore.QModelIndex): ...
    def sizeHint(self, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QSize: ...
    def updateEditorGeometry(self, editor:PySide2.QtWidgets.QWidget, option:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex): ...


class QSwipeGesture(PySide2.QtWidgets.QGesture):
    NoDirection              : QSwipeGesture = ... # 0x0
    Left                     : QSwipeGesture = ... # 0x1
    Right                    : QSwipeGesture = ... # 0x2
    Up                       : QSwipeGesture = ... # 0x3
    Down                     : QSwipeGesture = ... # 0x4

    class SwipeDirection(object):
        NoDirection              : QSwipeGesture.SwipeDirection = ... # 0x0
        Left                     : QSwipeGesture.SwipeDirection = ... # 0x1
        Right                    : QSwipeGesture.SwipeDirection = ... # 0x2
        Up                       : QSwipeGesture.SwipeDirection = ... # 0x3
        Down                     : QSwipeGesture.SwipeDirection = ... # 0x4

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def horizontalDirection(self) -> PySide2.QtWidgets.QSwipeGesture.SwipeDirection: ...
    def setSwipeAngle(self, value:float): ...
    def swipeAngle(self) -> float: ...
    def verticalDirection(self) -> PySide2.QtWidgets.QSwipeGesture.SwipeDirection: ...


class QSystemTrayIcon(PySide2.QtCore.QObject):
    NoIcon                   : QSystemTrayIcon = ... # 0x0
    Unknown                  : QSystemTrayIcon = ... # 0x0
    Context                  : QSystemTrayIcon = ... # 0x1
    Information              : QSystemTrayIcon = ... # 0x1
    DoubleClick              : QSystemTrayIcon = ... # 0x2
    Warning                  : QSystemTrayIcon = ... # 0x2
    Critical                 : QSystemTrayIcon = ... # 0x3
    Trigger                  : QSystemTrayIcon = ... # 0x3
    MiddleClick              : QSystemTrayIcon = ... # 0x4

    class ActivationReason(object):
        Unknown                  : QSystemTrayIcon.ActivationReason = ... # 0x0
        Context                  : QSystemTrayIcon.ActivationReason = ... # 0x1
        DoubleClick              : QSystemTrayIcon.ActivationReason = ... # 0x2
        Trigger                  : QSystemTrayIcon.ActivationReason = ... # 0x3
        MiddleClick              : QSystemTrayIcon.ActivationReason = ... # 0x4

    class MessageIcon(object):
        NoIcon                   : QSystemTrayIcon.MessageIcon = ... # 0x0
        Information              : QSystemTrayIcon.MessageIcon = ... # 0x1
        Warning                  : QSystemTrayIcon.MessageIcon = ... # 0x2
        Critical                 : QSystemTrayIcon.MessageIcon = ... # 0x3

    @typing.overload
    def __init__(self, icon:PySide2.QtGui.QIcon, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def contextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def hide(self): ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    @staticmethod
    def isSystemTrayAvailable() -> bool: ...
    def isVisible(self) -> bool: ...
    def setContextMenu(self, menu:PySide2.QtWidgets.QMenu): ...
    def setIcon(self, icon:PySide2.QtGui.QIcon): ...
    def setToolTip(self, tip:str): ...
    def setVisible(self, visible:bool): ...
    def show(self): ...
    @typing.overload
    def showMessage(self, title:str, msg:str, icon:PySide2.QtGui.QIcon, msecs:int=...): ...
    @typing.overload
    def showMessage(self, title:str, msg:str, icon:PySide2.QtWidgets.QSystemTrayIcon.MessageIcon=..., msecs:int=...): ...
    @staticmethod
    def supportsMessages() -> bool: ...
    def toolTip(self) -> str: ...


class QTabBar(PySide2.QtWidgets.QWidget):
    LeftSide                 : QTabBar = ... # 0x0
    RoundedNorth             : QTabBar = ... # 0x0
    SelectLeftTab            : QTabBar = ... # 0x0
    RightSide                : QTabBar = ... # 0x1
    RoundedSouth             : QTabBar = ... # 0x1
    SelectRightTab           : QTabBar = ... # 0x1
    RoundedWest              : QTabBar = ... # 0x2
    SelectPreviousTab        : QTabBar = ... # 0x2
    RoundedEast              : QTabBar = ... # 0x3
    TriangularNorth          : QTabBar = ... # 0x4
    TriangularSouth          : QTabBar = ... # 0x5
    TriangularWest           : QTabBar = ... # 0x6
    TriangularEast           : QTabBar = ... # 0x7

    class ButtonPosition(object):
        LeftSide                 : QTabBar.ButtonPosition = ... # 0x0
        RightSide                : QTabBar.ButtonPosition = ... # 0x1

    class SelectionBehavior(object):
        SelectLeftTab            : QTabBar.SelectionBehavior = ... # 0x0
        SelectRightTab           : QTabBar.SelectionBehavior = ... # 0x1
        SelectPreviousTab        : QTabBar.SelectionBehavior = ... # 0x2

    class Shape(object):
        RoundedNorth             : QTabBar.Shape = ... # 0x0
        RoundedSouth             : QTabBar.Shape = ... # 0x1
        RoundedWest              : QTabBar.Shape = ... # 0x2
        RoundedEast              : QTabBar.Shape = ... # 0x3
        TriangularNorth          : QTabBar.Shape = ... # 0x4
        TriangularSouth          : QTabBar.Shape = ... # 0x5
        TriangularWest           : QTabBar.Shape = ... # 0x6
        TriangularEast           : QTabBar.Shape = ... # 0x7

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def accessibleTabName(self, index:int) -> str: ...
    @typing.overload
    def addTab(self, icon:PySide2.QtGui.QIcon, text:str) -> int: ...
    @typing.overload
    def addTab(self, text:str) -> int: ...
    def autoHide(self) -> bool: ...
    def changeCurrentOnDrag(self) -> bool: ...
    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def documentMode(self) -> bool: ...
    def drawBase(self) -> bool: ...
    def elideMode(self) -> PySide2.QtCore.Qt.TextElideMode: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def expanding(self) -> bool: ...
    def hideEvent(self, arg__1:PySide2.QtGui.QHideEvent): ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionTab, tabIndex:int): ...
    @typing.overload
    def insertTab(self, index:int, icon:PySide2.QtGui.QIcon, text:str) -> int: ...
    @typing.overload
    def insertTab(self, index:int, text:str) -> int: ...
    def isMovable(self) -> bool: ...
    def isTabEnabled(self, index:int) -> bool: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def minimumTabSizeHint(self, index:int) -> PySide2.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def moveTab(self, from_:int, to:int): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def removeTab(self, index:int): ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent): ...
    def selectionBehaviorOnRemove(self) -> PySide2.QtWidgets.QTabBar.SelectionBehavior: ...
    def setAccessibleTabName(self, index:int, name:str): ...
    def setAutoHide(self, hide:bool): ...
    def setChangeCurrentOnDrag(self, change:bool): ...
    def setCurrentIndex(self, index:int): ...
    def setDocumentMode(self, set:bool): ...
    def setDrawBase(self, drawTheBase:bool): ...
    def setElideMode(self, arg__1:PySide2.QtCore.Qt.TextElideMode): ...
    def setExpanding(self, enabled:bool): ...
    def setIconSize(self, size:PySide2.QtCore.QSize): ...
    def setMovable(self, movable:bool): ...
    def setSelectionBehaviorOnRemove(self, behavior:PySide2.QtWidgets.QTabBar.SelectionBehavior): ...
    def setShape(self, shape:PySide2.QtWidgets.QTabBar.Shape): ...
    def setTabButton(self, index:int, position:PySide2.QtWidgets.QTabBar.ButtonPosition, widget:PySide2.QtWidgets.QWidget): ...
    def setTabData(self, index:int, data:typing.Any): ...
    def setTabEnabled(self, index:int, arg__2:bool): ...
    def setTabIcon(self, index:int, icon:PySide2.QtGui.QIcon): ...
    def setTabText(self, index:int, text:str): ...
    def setTabTextColor(self, index:int, color:PySide2.QtGui.QColor): ...
    def setTabToolTip(self, index:int, tip:str): ...
    def setTabWhatsThis(self, index:int, text:str): ...
    def setTabsClosable(self, closable:bool): ...
    def setUsesScrollButtons(self, useButtons:bool): ...
    def shape(self) -> PySide2.QtWidgets.QTabBar.Shape: ...
    def showEvent(self, arg__1:PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def tabAt(self, pos:PySide2.QtCore.QPoint) -> int: ...
    def tabButton(self, index:int, position:PySide2.QtWidgets.QTabBar.ButtonPosition) -> PySide2.QtWidgets.QWidget: ...
    def tabData(self, index:int) -> typing.Any: ...
    def tabIcon(self, index:int) -> PySide2.QtGui.QIcon: ...
    def tabInserted(self, index:int): ...
    def tabLayoutChange(self): ...
    def tabRect(self, index:int) -> PySide2.QtCore.QRect: ...
    def tabRemoved(self, index:int): ...
    def tabSizeHint(self, index:int) -> PySide2.QtCore.QSize: ...
    def tabText(self, index:int) -> str: ...
    def tabTextColor(self, index:int) -> PySide2.QtGui.QColor: ...
    def tabToolTip(self, index:int) -> str: ...
    def tabWhatsThis(self, index:int) -> str: ...
    def tabsClosable(self) -> bool: ...
    def timerEvent(self, event:PySide2.QtCore.QTimerEvent): ...
    def usesScrollButtons(self) -> bool: ...
    def wheelEvent(self, event:PySide2.QtGui.QWheelEvent): ...


class QTabWidget(PySide2.QtWidgets.QWidget):
    North                    : QTabWidget = ... # 0x0
    Rounded                  : QTabWidget = ... # 0x0
    South                    : QTabWidget = ... # 0x1
    Triangular               : QTabWidget = ... # 0x1
    West                     : QTabWidget = ... # 0x2
    East                     : QTabWidget = ... # 0x3

    class TabPosition(object):
        North                    : QTabWidget.TabPosition = ... # 0x0
        South                    : QTabWidget.TabPosition = ... # 0x1
        West                     : QTabWidget.TabPosition = ... # 0x2
        East                     : QTabWidget.TabPosition = ... # 0x3

    class TabShape(object):
        Rounded                  : QTabWidget.TabShape = ... # 0x0
        Triangular               : QTabWidget.TabShape = ... # 0x1

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    @typing.overload
    def addTab(self, widget:PySide2.QtWidgets.QWidget, arg__2:str) -> int: ...
    @typing.overload
    def addTab(self, widget:PySide2.QtWidgets.QWidget, icon:PySide2.QtGui.QIcon, label:str) -> int: ...
    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def cornerWidget(self, corner:PySide2.QtCore.Qt.Corner=...) -> PySide2.QtWidgets.QWidget: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def documentMode(self) -> bool: ...
    def elideMode(self) -> PySide2.QtCore.Qt.TextElideMode: ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width:int) -> int: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def indexOf(self, widget:PySide2.QtWidgets.QWidget) -> int: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionTabWidgetFrame): ...
    @typing.overload
    def insertTab(self, index:int, widget:PySide2.QtWidgets.QWidget, arg__3:str) -> int: ...
    @typing.overload
    def insertTab(self, index:int, widget:PySide2.QtWidgets.QWidget, icon:PySide2.QtGui.QIcon, label:str) -> int: ...
    def isMovable(self) -> bool: ...
    def isTabEnabled(self, index:int) -> bool: ...
    def keyPressEvent(self, arg__1:PySide2.QtGui.QKeyEvent): ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def removeTab(self, index:int): ...
    def resizeEvent(self, arg__1:PySide2.QtGui.QResizeEvent): ...
    def setCornerWidget(self, w:PySide2.QtWidgets.QWidget, corner:PySide2.QtCore.Qt.Corner=...): ...
    def setCurrentIndex(self, index:int): ...
    def setCurrentWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def setDocumentMode(self, set:bool): ...
    def setElideMode(self, arg__1:PySide2.QtCore.Qt.TextElideMode): ...
    def setIconSize(self, size:PySide2.QtCore.QSize): ...
    def setMovable(self, movable:bool): ...
    def setTabBar(self, arg__1:PySide2.QtWidgets.QTabBar): ...
    def setTabBarAutoHide(self, enabled:bool): ...
    def setTabEnabled(self, index:int, arg__2:bool): ...
    def setTabIcon(self, index:int, icon:PySide2.QtGui.QIcon): ...
    def setTabPosition(self, arg__1:PySide2.QtWidgets.QTabWidget.TabPosition): ...
    def setTabShape(self, s:PySide2.QtWidgets.QTabWidget.TabShape): ...
    def setTabText(self, index:int, arg__2:str): ...
    def setTabToolTip(self, index:int, tip:str): ...
    def setTabWhatsThis(self, index:int, text:str): ...
    def setTabsClosable(self, closeable:bool): ...
    def setUsesScrollButtons(self, useButtons:bool): ...
    def showEvent(self, arg__1:PySide2.QtGui.QShowEvent): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def tabBar(self) -> PySide2.QtWidgets.QTabBar: ...
    def tabBarAutoHide(self) -> bool: ...
    def tabIcon(self, index:int) -> PySide2.QtGui.QIcon: ...
    def tabInserted(self, index:int): ...
    def tabPosition(self) -> PySide2.QtWidgets.QTabWidget.TabPosition: ...
    def tabRemoved(self, index:int): ...
    def tabShape(self) -> PySide2.QtWidgets.QTabWidget.TabShape: ...
    def tabText(self, index:int) -> str: ...
    def tabToolTip(self, index:int) -> str: ...
    def tabWhatsThis(self, index:int) -> str: ...
    def tabsClosable(self) -> bool: ...
    def usesScrollButtons(self) -> bool: ...
    def widget(self, index:int) -> PySide2.QtWidgets.QWidget: ...


class QTableView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def clearSpans(self): ...
    def columnAt(self, x:int) -> int: ...
    def columnCountChanged(self, oldCount:int, newCount:int): ...
    def columnMoved(self, column:int, oldIndex:int, newIndex:int): ...
    def columnResized(self, column:int, oldWidth:int, newWidth:int): ...
    def columnSpan(self, row:int, column:int) -> int: ...
    def columnViewportPosition(self, column:int) -> int: ...
    def columnWidth(self, column:int) -> int: ...
    def currentChanged(self, current:PySide2.QtCore.QModelIndex, previous:PySide2.QtCore.QModelIndex): ...
    def doItemsLayout(self): ...
    def gridStyle(self) -> PySide2.QtCore.Qt.PenStyle: ...
    def hideColumn(self, column:int): ...
    def hideRow(self, row:int): ...
    def horizontalHeader(self) -> PySide2.QtWidgets.QHeaderView: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollbarAction(self, action:int): ...
    def indexAt(self, p:PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def isColumnHidden(self, column:int) -> bool: ...
    def isCornerButtonEnabled(self) -> bool: ...
    def isIndexHidden(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowHidden(self, row:int) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def moveCursor(self, cursorAction:PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def paintEvent(self, e:PySide2.QtGui.QPaintEvent): ...
    def resizeColumnToContents(self, column:int): ...
    def resizeColumnsToContents(self): ...
    def resizeRowToContents(self, row:int): ...
    def resizeRowsToContents(self): ...
    def rowAt(self, y:int) -> int: ...
    def rowCountChanged(self, oldCount:int, newCount:int): ...
    def rowHeight(self, row:int) -> int: ...
    def rowMoved(self, row:int, oldIndex:int, newIndex:int): ...
    def rowResized(self, row:int, oldHeight:int, newHeight:int): ...
    def rowSpan(self, row:int, column:int) -> int: ...
    def rowViewportPosition(self, row:int) -> int: ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def scrollTo(self, index:PySide2.QtCore.QModelIndex, hint:PySide2.QtWidgets.QAbstractItemView.ScrollHint=...): ...
    def selectColumn(self, column:int): ...
    def selectRow(self, row:int): ...
    def selectedIndexes(self) -> typing.List: ...
    def selectionChanged(self, selected:PySide2.QtCore.QItemSelection, deselected:PySide2.QtCore.QItemSelection): ...
    def setColumnHidden(self, column:int, hide:bool): ...
    def setColumnWidth(self, column:int, width:int): ...
    def setCornerButtonEnabled(self, enable:bool): ...
    def setGridStyle(self, style:PySide2.QtCore.Qt.PenStyle): ...
    def setHorizontalHeader(self, header:PySide2.QtWidgets.QHeaderView): ...
    def setModel(self, model:PySide2.QtCore.QAbstractItemModel): ...
    def setRootIndex(self, index:PySide2.QtCore.QModelIndex): ...
    def setRowHeight(self, row:int, height:int): ...
    def setRowHidden(self, row:int, hide:bool): ...
    def setSelection(self, rect:PySide2.QtCore.QRect, command:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSelectionModel(self, selectionModel:PySide2.QtCore.QItemSelectionModel): ...
    def setShowGrid(self, show:bool): ...
    def setSortingEnabled(self, enable:bool): ...
    def setSpan(self, row:int, column:int, rowSpan:int, columnSpan:int): ...
    def setVerticalHeader(self, header:PySide2.QtWidgets.QHeaderView): ...
    def setWordWrap(self, on:bool): ...
    def showColumn(self, column:int): ...
    def showGrid(self) -> bool: ...
    def showRow(self, row:int): ...
    def sizeHintForColumn(self, column:int) -> int: ...
    def sizeHintForRow(self, row:int) -> int: ...
    @typing.overload
    def sortByColumn(self, column:int): ...
    @typing.overload
    def sortByColumn(self, column:int, order:PySide2.QtCore.Qt.SortOrder): ...
    def timerEvent(self, event:PySide2.QtCore.QTimerEvent): ...
    def updateGeometries(self): ...
    def verticalHeader(self) -> PySide2.QtWidgets.QHeaderView: ...
    def verticalOffset(self) -> int: ...
    def verticalScrollbarAction(self, action:int): ...
    def viewOptions(self) -> PySide2.QtWidgets.QStyleOptionViewItem: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection:PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...
    def wordWrap(self) -> bool: ...


class QTableWidget(PySide2.QtWidgets.QTableView):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, rows:int, columns:int, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def cellWidget(self, row:int, column:int) -> PySide2.QtWidgets.QWidget: ...
    def clear(self): ...
    def clearContents(self): ...
    @typing.overload
    def closePersistentEditor(self, index:PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def closePersistentEditor(self, item:PySide2.QtWidgets.QTableWidgetItem): ...
    def column(self, item:PySide2.QtWidgets.QTableWidgetItem) -> int: ...
    def columnCount(self) -> int: ...
    def currentColumn(self) -> int: ...
    def currentItem(self) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def currentRow(self) -> int: ...
    def dropEvent(self, event:PySide2.QtGui.QDropEvent): ...
    def dropMimeData(self, row:int, column:int, data:PySide2.QtCore.QMimeData, action:PySide2.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item:PySide2.QtWidgets.QTableWidgetItem): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def findItems(self, text:str, flags:PySide2.QtCore.Qt.MatchFlags) -> typing.List: ...
    def horizontalHeaderItem(self, column:int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def indexFromItem(self, item:PySide2.QtWidgets.QTableWidgetItem) -> PySide2.QtCore.QModelIndex: ...
    def insertColumn(self, column:int): ...
    def insertRow(self, row:int): ...
    def isItemSelected(self, item:PySide2.QtWidgets.QTableWidgetItem) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, item:PySide2.QtWidgets.QTableWidgetItem) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def item(self, row:int, column:int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    @typing.overload
    def itemAt(self, p:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QTableWidgetItem: ...
    @typing.overload
    def itemAt(self, x:int, y:int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def itemFromIndex(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def itemPrototype(self) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def items(self, data:PySide2.QtCore.QMimeData) -> typing.List: ...
    def mimeData(self, items:typing.Sequence) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List: ...
    @typing.overload
    def openPersistentEditor(self, index:PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def openPersistentEditor(self, item:PySide2.QtWidgets.QTableWidgetItem): ...
    def removeCellWidget(self, row:int, column:int): ...
    def removeColumn(self, column:int): ...
    def removeRow(self, row:int): ...
    def row(self, item:PySide2.QtWidgets.QTableWidgetItem) -> int: ...
    def rowCount(self) -> int: ...
    def scrollToItem(self, item:PySide2.QtWidgets.QTableWidgetItem, hint:PySide2.QtWidgets.QAbstractItemView.ScrollHint=...): ...
    def selectedItems(self) -> typing.List: ...
    def selectedRanges(self) -> typing.List: ...
    def setCellWidget(self, row:int, column:int, widget:PySide2.QtWidgets.QWidget): ...
    def setColumnCount(self, columns:int): ...
    @typing.overload
    def setCurrentCell(self, row:int, column:int): ...
    @typing.overload
    def setCurrentCell(self, row:int, column:int, command:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    @typing.overload
    def setCurrentItem(self, item:PySide2.QtWidgets.QTableWidgetItem): ...
    @typing.overload
    def setCurrentItem(self, item:PySide2.QtWidgets.QTableWidgetItem, command:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setHorizontalHeaderItem(self, column:int, item:PySide2.QtWidgets.QTableWidgetItem): ...
    def setHorizontalHeaderLabels(self, labels:typing.Sequence): ...
    def setItem(self, row:int, column:int, item:PySide2.QtWidgets.QTableWidgetItem): ...
    def setItemPrototype(self, item:PySide2.QtWidgets.QTableWidgetItem): ...
    def setItemSelected(self, item:PySide2.QtWidgets.QTableWidgetItem, select:bool): ...
    def setModel(self, model:PySide2.QtCore.QAbstractItemModel): ...
    def setRangeSelected(self, range:PySide2.QtWidgets.QTableWidgetSelectionRange, select:bool): ...
    def setRowCount(self, rows:int): ...
    def setSortingEnabled(self, enable:bool): ...
    def setVerticalHeaderItem(self, row:int, item:PySide2.QtWidgets.QTableWidgetItem): ...
    def setVerticalHeaderLabels(self, labels:typing.Sequence): ...
    def sortItems(self, column:int, order:PySide2.QtCore.Qt.SortOrder=...): ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeHorizontalHeaderItem(self, column:int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def takeItem(self, row:int, column:int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def takeVerticalHeaderItem(self, row:int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def verticalHeaderItem(self, row:int) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def visualColumn(self, logicalColumn:int) -> int: ...
    def visualItemRect(self, item:PySide2.QtWidgets.QTableWidgetItem) -> PySide2.QtCore.QRect: ...
    def visualRow(self, logicalRow:int) -> int: ...


class QTableWidgetItem(Shiboken.Object):
    Type                     : QTableWidgetItem = ... # 0x0
    UserType                 : QTableWidgetItem = ... # 0x3e8

    class ItemType(object):
        Type                     : QTableWidgetItem.ItemType = ... # 0x0
        UserType                 : QTableWidgetItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self, icon:PySide2.QtGui.QIcon, text:str, type:int=...): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QTableWidgetItem): ...
    @typing.overload
    def __init__(self, text:str, type:int=...): ...
    @typing.overload
    def __init__(self, type:int=...): ...

    def __lshift__(self, out:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def background(self) -> PySide2.QtGui.QBrush: ...
    def backgroundColor(self) -> PySide2.QtGui.QColor: ...
    def checkState(self) -> PySide2.QtCore.Qt.CheckState: ...
    def clone(self) -> PySide2.QtWidgets.QTableWidgetItem: ...
    def column(self) -> int: ...
    def data(self, role:int) -> typing.Any: ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def foreground(self) -> PySide2.QtGui.QBrush: ...
    def icon(self) -> PySide2.QtGui.QIcon: ...
    def isSelected(self) -> bool: ...
    def read(self, in_:PySide2.QtCore.QDataStream): ...
    def row(self) -> int: ...
    def setBackground(self, brush:PySide2.QtGui.QBrush): ...
    def setBackgroundColor(self, color:PySide2.QtGui.QColor): ...
    def setCheckState(self, state:PySide2.QtCore.Qt.CheckState): ...
    def setData(self, role:int, value:typing.Any): ...
    def setFlags(self, flags:PySide2.QtCore.Qt.ItemFlags): ...
    def setFont(self, font:PySide2.QtGui.QFont): ...
    def setForeground(self, brush:PySide2.QtGui.QBrush): ...
    def setIcon(self, icon:PySide2.QtGui.QIcon): ...
    def setSelected(self, select:bool): ...
    def setSizeHint(self, size:PySide2.QtCore.QSize): ...
    def setStatusTip(self, statusTip:str): ...
    def setText(self, text:str): ...
    def setTextAlignment(self, alignment:int): ...
    def setTextColor(self, color:PySide2.QtGui.QColor): ...
    def setToolTip(self, toolTip:str): ...
    def setWhatsThis(self, whatsThis:str): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def statusTip(self) -> str: ...
    def tableWidget(self) -> PySide2.QtWidgets.QTableWidget: ...
    def text(self) -> str: ...
    def textAlignment(self) -> int: ...
    def textColor(self) -> PySide2.QtGui.QColor: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out:PySide2.QtCore.QDataStream): ...


class QTableWidgetSelectionRange(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QTableWidgetSelectionRange): ...
    @typing.overload
    def __init__(self, top:int, left:int, bottom:int, right:int): ...

    def __copy__(self): ...
    def bottomRow(self) -> int: ...
    def columnCount(self) -> int: ...
    def leftColumn(self) -> int: ...
    def rightColumn(self) -> int: ...
    def rowCount(self) -> int: ...
    def topRow(self) -> int: ...


class QTapAndHoldGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def position(self) -> PySide2.QtCore.QPointF: ...
    def setPosition(self, pos:PySide2.QtCore.QPointF): ...
    @staticmethod
    def setTimeout(msecs:int): ...
    @staticmethod
    def timeout() -> int: ...


class QTapGesture(PySide2.QtWidgets.QGesture):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def position(self) -> PySide2.QtCore.QPointF: ...
    def setPosition(self, pos:PySide2.QtCore.QPointF): ...


class QTextBrowser(PySide2.QtWidgets.QTextEdit):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def backward(self): ...
    def backwardHistoryCount(self) -> int: ...
    def clearHistory(self): ...
    def doSetSource(self, name:PySide2.QtCore.QUrl, type:PySide2.QtGui.QTextDocument.ResourceType=...): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def focusOutEvent(self, ev:PySide2.QtGui.QFocusEvent): ...
    def forward(self): ...
    def forwardHistoryCount(self) -> int: ...
    def historyTitle(self, arg__1:int) -> str: ...
    def historyUrl(self, arg__1:int) -> PySide2.QtCore.QUrl: ...
    def home(self): ...
    def isBackwardAvailable(self) -> bool: ...
    def isForwardAvailable(self) -> bool: ...
    def keyPressEvent(self, ev:PySide2.QtGui.QKeyEvent): ...
    def loadResource(self, type:int, name:PySide2.QtCore.QUrl) -> typing.Any: ...
    def mouseMoveEvent(self, ev:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, ev:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, ev:PySide2.QtGui.QMouseEvent): ...
    def openExternalLinks(self) -> bool: ...
    def openLinks(self) -> bool: ...
    def paintEvent(self, e:PySide2.QtGui.QPaintEvent): ...
    def reload(self): ...
    def searchPaths(self) -> typing.List: ...
    def setOpenExternalLinks(self, open:bool): ...
    def setOpenLinks(self, open:bool): ...
    def setSearchPaths(self, paths:typing.Sequence): ...
    @typing.overload
    def setSource(self, name:PySide2.QtCore.QUrl): ...
    @typing.overload
    def setSource(self, name:PySide2.QtCore.QUrl, type:PySide2.QtGui.QTextDocument.ResourceType): ...
    def source(self) -> PySide2.QtCore.QUrl: ...
    def sourceType(self) -> PySide2.QtGui.QTextDocument.ResourceType: ...


class QTextEdit(PySide2.QtWidgets.QAbstractScrollArea):
    AutoAll                  : QTextEdit = ... # -0x1
    AutoNone                 : QTextEdit = ... # 0x0
    NoWrap                   : QTextEdit = ... # 0x0
    AutoBulletList           : QTextEdit = ... # 0x1
    WidgetWidth              : QTextEdit = ... # 0x1
    FixedPixelWidth          : QTextEdit = ... # 0x2
    FixedColumnWidth         : QTextEdit = ... # 0x3

    class AutoFormatting(object): ...

    class AutoFormattingFlag(object):
        AutoAll                  : QTextEdit.AutoFormattingFlag = ... # -0x1
        AutoNone                 : QTextEdit.AutoFormattingFlag = ... # 0x0
        AutoBulletList           : QTextEdit.AutoFormattingFlag = ... # 0x1

    class ExtraSelection(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, ExtraSelection:PySide2.QtWidgets.QTextEdit.ExtraSelection): ...

        def __copy__(self): ...

    class LineWrapMode(object):
        NoWrap                   : QTextEdit.LineWrapMode = ... # 0x0
        WidgetWidth              : QTextEdit.LineWrapMode = ... # 0x1
        FixedPixelWidth          : QTextEdit.LineWrapMode = ... # 0x2
        FixedColumnWidth         : QTextEdit.LineWrapMode = ... # 0x3

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def acceptRichText(self) -> bool: ...
    def alignment(self) -> PySide2.QtCore.Qt.Alignment: ...
    def anchorAt(self, pos:PySide2.QtCore.QPoint) -> str: ...
    def append(self, text:str): ...
    def autoFormatting(self) -> PySide2.QtWidgets.QTextEdit.AutoFormatting: ...
    def canInsertFromMimeData(self, source:PySide2.QtCore.QMimeData) -> bool: ...
    def canPaste(self) -> bool: ...
    def changeEvent(self, e:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def contextMenuEvent(self, e:PySide2.QtGui.QContextMenuEvent): ...
    def copy(self): ...
    def createMimeDataFromSelection(self) -> PySide2.QtCore.QMimeData: ...
    @typing.overload
    def createStandardContextMenu(self) -> PySide2.QtWidgets.QMenu: ...
    @typing.overload
    def createStandardContextMenu(self, position:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QMenu: ...
    def currentCharFormat(self) -> PySide2.QtGui.QTextCharFormat: ...
    def currentFont(self) -> PySide2.QtGui.QFont: ...
    def cursorForPosition(self, pos:PySide2.QtCore.QPoint) -> PySide2.QtGui.QTextCursor: ...
    @typing.overload
    def cursorRect(self) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def cursorRect(self, cursor:PySide2.QtGui.QTextCursor) -> PySide2.QtCore.QRect: ...
    def cursorWidth(self) -> int: ...
    def cut(self): ...
    def doSetTextCursor(self, cursor:PySide2.QtGui.QTextCursor): ...
    def document(self) -> PySide2.QtGui.QTextDocument: ...
    def documentTitle(self) -> str: ...
    def dragEnterEvent(self, e:PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, e:PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, e:PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, e:PySide2.QtGui.QDropEvent): ...
    def ensureCursorVisible(self): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def extraSelections(self) -> typing.List: ...
    @typing.overload
    def find(self, exp:PySide2.QtCore.QRegExp, options:PySide2.QtGui.QTextDocument.FindFlags=...) -> bool: ...
    @typing.overload
    def find(self, exp:PySide2.QtCore.QRegularExpression, options:PySide2.QtGui.QTextDocument.FindFlags=...) -> bool: ...
    @typing.overload
    def find(self, exp:str, options:PySide2.QtGui.QTextDocument.FindFlags=...) -> bool: ...
    def focusInEvent(self, e:PySide2.QtGui.QFocusEvent): ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def focusOutEvent(self, e:PySide2.QtGui.QFocusEvent): ...
    def fontFamily(self) -> str: ...
    def fontItalic(self) -> bool: ...
    def fontPointSize(self) -> float: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def inputMethodEvent(self, arg__1:PySide2.QtGui.QInputMethodEvent): ...
    @typing.overload
    def inputMethodQuery(self, property:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query:PySide2.QtCore.Qt.InputMethodQuery, argument:typing.Any) -> typing.Any: ...
    def insertFromMimeData(self, source:PySide2.QtCore.QMimeData): ...
    def insertHtml(self, text:str): ...
    def insertPlainText(self, text:str): ...
    def isReadOnly(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def keyPressEvent(self, e:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, e:PySide2.QtGui.QKeyEvent): ...
    def lineWrapColumnOrWidth(self) -> int: ...
    def lineWrapMode(self) -> PySide2.QtWidgets.QTextEdit.LineWrapMode: ...
    def loadResource(self, type:int, name:PySide2.QtCore.QUrl) -> typing.Any: ...
    def mergeCurrentCharFormat(self, modifier:PySide2.QtGui.QTextCharFormat): ...
    def mouseDoubleClickEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, e:PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, operation:PySide2.QtGui.QTextCursor.MoveOperation, mode:PySide2.QtGui.QTextCursor.MoveMode=...): ...
    def overwriteMode(self) -> bool: ...
    def paintEvent(self, e:PySide2.QtGui.QPaintEvent): ...
    def paste(self): ...
    def placeholderText(self) -> str: ...
    def print_(self, printer:PySide2.QtGui.QPagedPaintDevice): ...
    def redo(self): ...
    def resizeEvent(self, e:PySide2.QtGui.QResizeEvent): ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def scrollToAnchor(self, name:str): ...
    def selectAll(self): ...
    def setAcceptRichText(self, accept:bool): ...
    def setAlignment(self, a:PySide2.QtCore.Qt.Alignment): ...
    def setAutoFormatting(self, features:PySide2.QtWidgets.QTextEdit.AutoFormatting): ...
    def setCurrentCharFormat(self, format:PySide2.QtGui.QTextCharFormat): ...
    def setCurrentFont(self, f:PySide2.QtGui.QFont): ...
    def setCursorWidth(self, width:int): ...
    def setDocument(self, document:PySide2.QtGui.QTextDocument): ...
    def setDocumentTitle(self, title:str): ...
    def setExtraSelections(self, selections:typing.Sequence): ...
    def setFontFamily(self, fontFamily:str): ...
    def setFontItalic(self, b:bool): ...
    def setFontPointSize(self, s:float): ...
    def setFontUnderline(self, b:bool): ...
    def setFontWeight(self, w:int): ...
    def setHtml(self, text:str): ...
    def setLineWrapColumnOrWidth(self, w:int): ...
    def setLineWrapMode(self, mode:PySide2.QtWidgets.QTextEdit.LineWrapMode): ...
    def setMarkdown(self, markdown:str): ...
    def setOverwriteMode(self, overwrite:bool): ...
    def setPlaceholderText(self, placeholderText:str): ...
    def setPlainText(self, text:str): ...
    def setReadOnly(self, ro:bool): ...
    def setTabChangesFocus(self, b:bool): ...
    def setTabStopDistance(self, distance:float): ...
    def setTabStopWidth(self, width:int): ...
    def setText(self, text:str): ...
    def setTextBackgroundColor(self, c:PySide2.QtGui.QColor): ...
    def setTextColor(self, c:PySide2.QtGui.QColor): ...
    def setTextCursor(self, cursor:PySide2.QtGui.QTextCursor): ...
    def setTextInteractionFlags(self, flags:PySide2.QtCore.Qt.TextInteractionFlags): ...
    def setUndoRedoEnabled(self, enable:bool): ...
    def setWordWrapMode(self, policy:PySide2.QtGui.QTextOption.WrapMode): ...
    def showEvent(self, arg__1:PySide2.QtGui.QShowEvent): ...
    def tabChangesFocus(self) -> bool: ...
    def tabStopDistance(self) -> float: ...
    def tabStopWidth(self) -> int: ...
    def textBackgroundColor(self) -> PySide2.QtGui.QColor: ...
    def textColor(self) -> PySide2.QtGui.QColor: ...
    def textCursor(self) -> PySide2.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide2.QtCore.Qt.TextInteractionFlags: ...
    def timerEvent(self, e:PySide2.QtCore.QTimerEvent): ...
    def toHtml(self) -> str: ...
    def toMarkdown(self, features:PySide2.QtGui.QTextDocument.MarkdownFeatures=...) -> str: ...
    def toPlainText(self) -> str: ...
    def undo(self): ...
    def wheelEvent(self, e:PySide2.QtGui.QWheelEvent): ...
    def wordWrapMode(self) -> PySide2.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, range:int=...): ...
    def zoomInF(self, range:float): ...
    def zoomOut(self, range:int=...): ...


class QTileRules(Shiboken.Object):

    @typing.overload
    def __init__(self, QTileRules:PySide2.QtWidgets.QTileRules): ...
    @typing.overload
    def __init__(self, horizontalRule:PySide2.QtCore.Qt.TileRule, verticalRule:PySide2.QtCore.Qt.TileRule): ...
    @typing.overload
    def __init__(self, rule:PySide2.QtCore.Qt.TileRule=...): ...

    def __copy__(self): ...


class QTimeEdit(PySide2.QtWidgets.QDateTimeEdit):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, time:PySide2.QtCore.QTime, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...


class QToolBar(PySide2.QtWidgets.QWidget):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, title:str, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    @typing.overload
    def actionAt(self, p:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def actionAt(self, x:int, y:int) -> PySide2.QtWidgets.QAction: ...
    def actionEvent(self, event:PySide2.QtGui.QActionEvent): ...
    def actionGeometry(self, action:PySide2.QtWidgets.QAction) -> PySide2.QtCore.QRect: ...
    @typing.overload
    def addAction(self, arg__1:PySide2.QtWidgets.QAction): ...
    @typing.overload
    def addAction(self, icon:PySide2.QtGui.QIcon, text:str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, icon:PySide2.QtGui.QIcon, text:str, receiver:PySide2.QtCore.QObject, member:bytes) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text:str) -> PySide2.QtWidgets.QAction: ...
    @typing.overload
    def addAction(self, text:str, receiver:PySide2.QtCore.QObject, member:bytes) -> PySide2.QtWidgets.QAction: ...
    def addSeparator(self) -> PySide2.QtWidgets.QAction: ...
    def addWidget(self, widget:PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QAction: ...
    def allowedAreas(self) -> PySide2.QtCore.Qt.ToolBarAreas: ...
    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    def clear(self): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def iconSize(self) -> PySide2.QtCore.QSize: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionToolBar): ...
    def insertSeparator(self, before:PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QAction: ...
    def insertWidget(self, before:PySide2.QtWidgets.QAction, widget:PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QAction: ...
    def isAreaAllowed(self, area:PySide2.QtCore.Qt.ToolBarArea) -> bool: ...
    def isFloatable(self) -> bool: ...
    def isFloating(self) -> bool: ...
    def isMovable(self) -> bool: ...
    def orientation(self) -> PySide2.QtCore.Qt.Orientation: ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent): ...
    def setAllowedAreas(self, areas:PySide2.QtCore.Qt.ToolBarAreas): ...
    def setFloatable(self, floatable:bool): ...
    def setIconSize(self, iconSize:PySide2.QtCore.QSize): ...
    def setMovable(self, movable:bool): ...
    def setOrientation(self, orientation:PySide2.QtCore.Qt.Orientation): ...
    def setToolButtonStyle(self, toolButtonStyle:PySide2.QtCore.Qt.ToolButtonStyle): ...
    def toggleViewAction(self) -> PySide2.QtWidgets.QAction: ...
    def toolButtonStyle(self) -> PySide2.QtCore.Qt.ToolButtonStyle: ...
    def widgetForAction(self, action:PySide2.QtWidgets.QAction) -> PySide2.QtWidgets.QWidget: ...


class QToolBox(PySide2.QtWidgets.QFrame):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., f:PySide2.QtCore.Qt.WindowFlags=...): ...

    @typing.overload
    def addItem(self, widget:PySide2.QtWidgets.QWidget, icon:PySide2.QtGui.QIcon, text:str) -> int: ...
    @typing.overload
    def addItem(self, widget:PySide2.QtWidgets.QWidget, text:str) -> int: ...
    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def indexOf(self, widget:PySide2.QtWidgets.QWidget) -> int: ...
    @typing.overload
    def insertItem(self, index:int, widget:PySide2.QtWidgets.QWidget, icon:PySide2.QtGui.QIcon, text:str) -> int: ...
    @typing.overload
    def insertItem(self, index:int, widget:PySide2.QtWidgets.QWidget, text:str) -> int: ...
    def isItemEnabled(self, index:int) -> bool: ...
    def itemIcon(self, index:int) -> PySide2.QtGui.QIcon: ...
    def itemInserted(self, index:int): ...
    def itemRemoved(self, index:int): ...
    def itemText(self, index:int) -> str: ...
    def itemToolTip(self, index:int) -> str: ...
    def removeItem(self, index:int): ...
    def setCurrentIndex(self, index:int): ...
    def setCurrentWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def setItemEnabled(self, index:int, enabled:bool): ...
    def setItemIcon(self, index:int, icon:PySide2.QtGui.QIcon): ...
    def setItemText(self, index:int, text:str): ...
    def setItemToolTip(self, index:int, toolTip:str): ...
    def showEvent(self, e:PySide2.QtGui.QShowEvent): ...
    def widget(self, index:int) -> PySide2.QtWidgets.QWidget: ...


class QToolButton(PySide2.QtWidgets.QAbstractButton):
    DelayedPopup             : QToolButton = ... # 0x0
    MenuButtonPopup          : QToolButton = ... # 0x1
    InstantPopup             : QToolButton = ... # 0x2

    class ToolButtonPopupMode(object):
        DelayedPopup             : QToolButton.ToolButtonPopupMode = ... # 0x0
        MenuButtonPopup          : QToolButton.ToolButtonPopupMode = ... # 0x1
        InstantPopup             : QToolButton.ToolButtonPopupMode = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def actionEvent(self, arg__1:PySide2.QtGui.QActionEvent): ...
    def arrowType(self) -> PySide2.QtCore.Qt.ArrowType: ...
    def autoRaise(self) -> bool: ...
    def changeEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def defaultAction(self) -> PySide2.QtWidgets.QAction: ...
    def enterEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def hitButton(self, pos:PySide2.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option:PySide2.QtWidgets.QStyleOptionToolButton): ...
    def leaveEvent(self, arg__1:PySide2.QtCore.QEvent): ...
    def menu(self) -> PySide2.QtWidgets.QMenu: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def mousePressEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, arg__1:PySide2.QtGui.QMouseEvent): ...
    def nextCheckState(self): ...
    def paintEvent(self, arg__1:PySide2.QtGui.QPaintEvent): ...
    def popupMode(self) -> PySide2.QtWidgets.QToolButton.ToolButtonPopupMode: ...
    def setArrowType(self, type:PySide2.QtCore.Qt.ArrowType): ...
    def setAutoRaise(self, enable:bool): ...
    def setDefaultAction(self, arg__1:PySide2.QtWidgets.QAction): ...
    def setMenu(self, menu:PySide2.QtWidgets.QMenu): ...
    def setPopupMode(self, mode:PySide2.QtWidgets.QToolButton.ToolButtonPopupMode): ...
    def setToolButtonStyle(self, style:PySide2.QtCore.Qt.ToolButtonStyle): ...
    def showMenu(self): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def timerEvent(self, arg__1:PySide2.QtCore.QTimerEvent): ...
    def toolButtonStyle(self) -> PySide2.QtCore.Qt.ToolButtonStyle: ...


class QToolTip(Shiboken.Object):
    @staticmethod
    def font() -> PySide2.QtGui.QFont: ...
    @staticmethod
    def hideText(): ...
    @staticmethod
    def isVisible() -> bool: ...
    @staticmethod
    def palette() -> PySide2.QtGui.QPalette: ...
    @staticmethod
    def setFont(arg__1:PySide2.QtGui.QFont): ...
    @staticmethod
    def setPalette(arg__1:PySide2.QtGui.QPalette): ...
    @typing.overload
    @staticmethod
    def showText(pos:PySide2.QtCore.QPoint, text:str, w:PySide2.QtWidgets.QWidget, rect:PySide2.QtCore.QRect): ...
    @typing.overload
    @staticmethod
    def showText(pos:PySide2.QtCore.QPoint, text:str, w:PySide2.QtWidgets.QWidget, rect:PySide2.QtCore.QRect, msecShowTime:int): ...
    @typing.overload
    @staticmethod
    def showText(pos:PySide2.QtCore.QPoint, text:str, w:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @staticmethod
    def text() -> str: ...


class QTreeView(PySide2.QtWidgets.QAbstractItemView):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def allColumnsShowFocus(self) -> bool: ...
    def autoExpandDelay(self) -> int: ...
    def collapse(self, index:PySide2.QtCore.QModelIndex): ...
    def collapseAll(self): ...
    def columnAt(self, x:int) -> int: ...
    def columnCountChanged(self, oldCount:int, newCount:int): ...
    def columnMoved(self): ...
    def columnResized(self, column:int, oldSize:int, newSize:int): ...
    def columnViewportPosition(self, column:int) -> int: ...
    def columnWidth(self, column:int) -> int: ...
    def currentChanged(self, current:PySide2.QtCore.QModelIndex, previous:PySide2.QtCore.QModelIndex): ...
    def dataChanged(self, topLeft:PySide2.QtCore.QModelIndex, bottomRight:PySide2.QtCore.QModelIndex, roles:typing.List=...): ...
    def doItemsLayout(self): ...
    def dragMoveEvent(self, event:PySide2.QtGui.QDragMoveEvent): ...
    def drawBranches(self, painter:PySide2.QtGui.QPainter, rect:PySide2.QtCore.QRect, index:PySide2.QtCore.QModelIndex): ...
    def drawRow(self, painter:PySide2.QtGui.QPainter, options:PySide2.QtWidgets.QStyleOptionViewItem, index:PySide2.QtCore.QModelIndex): ...
    def drawTree(self, painter:PySide2.QtGui.QPainter, region:PySide2.QtGui.QRegion): ...
    def expand(self, index:PySide2.QtCore.QModelIndex): ...
    def expandAll(self): ...
    def expandRecursively(self, index:PySide2.QtCore.QModelIndex, depth:int=...): ...
    def expandToDepth(self, depth:int): ...
    def expandsOnDoubleClick(self) -> bool: ...
    def header(self) -> PySide2.QtWidgets.QHeaderView: ...
    def hideColumn(self, column:int): ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollbarAction(self, action:int): ...
    def indentation(self) -> int: ...
    def indexAbove(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def indexAt(self, p:PySide2.QtCore.QPoint) -> PySide2.QtCore.QModelIndex: ...
    def indexBelow(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def indexRowSizeHint(self, index:PySide2.QtCore.QModelIndex) -> int: ...
    def isAnimated(self) -> bool: ...
    def isColumnHidden(self, column:int) -> bool: ...
    def isExpanded(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def isFirstColumnSpanned(self, row:int, parent:PySide2.QtCore.QModelIndex) -> bool: ...
    def isHeaderHidden(self) -> bool: ...
    def isIndexHidden(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    def isRowHidden(self, row:int, parent:PySide2.QtCore.QModelIndex) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def itemsExpandable(self) -> bool: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def keyboardSearch(self, search:str): ...
    def mouseDoubleClickEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def moveCursor(self, cursorAction:PySide2.QtWidgets.QAbstractItemView.CursorAction, modifiers:PySide2.QtCore.Qt.KeyboardModifiers) -> PySide2.QtCore.QModelIndex: ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent): ...
    def reexpand(self): ...
    def reset(self): ...
    def resetIndentation(self): ...
    def resizeColumnToContents(self, column:int): ...
    def rootIsDecorated(self) -> bool: ...
    def rowHeight(self, index:PySide2.QtCore.QModelIndex) -> int: ...
    def rowsAboutToBeRemoved(self, parent:PySide2.QtCore.QModelIndex, start:int, end:int): ...
    def rowsInserted(self, parent:PySide2.QtCore.QModelIndex, start:int, end:int): ...
    def rowsRemoved(self, parent:PySide2.QtCore.QModelIndex, first:int, last:int): ...
    def scrollContentsBy(self, dx:int, dy:int): ...
    def scrollTo(self, index:PySide2.QtCore.QModelIndex, hint:PySide2.QtWidgets.QAbstractItemView.ScrollHint=...): ...
    def selectAll(self): ...
    def selectedIndexes(self) -> typing.List: ...
    def selectionChanged(self, selected:PySide2.QtCore.QItemSelection, deselected:PySide2.QtCore.QItemSelection): ...
    def setAllColumnsShowFocus(self, enable:bool): ...
    def setAnimated(self, enable:bool): ...
    def setAutoExpandDelay(self, delay:int): ...
    def setColumnHidden(self, column:int, hide:bool): ...
    def setColumnWidth(self, column:int, width:int): ...
    def setExpanded(self, index:PySide2.QtCore.QModelIndex, expand:bool): ...
    def setExpandsOnDoubleClick(self, enable:bool): ...
    def setFirstColumnSpanned(self, row:int, parent:PySide2.QtCore.QModelIndex, span:bool): ...
    def setHeader(self, header:PySide2.QtWidgets.QHeaderView): ...
    def setHeaderHidden(self, hide:bool): ...
    def setIndentation(self, i:int): ...
    def setItemsExpandable(self, enable:bool): ...
    def setModel(self, model:PySide2.QtCore.QAbstractItemModel): ...
    def setRootIndex(self, index:PySide2.QtCore.QModelIndex): ...
    def setRootIsDecorated(self, show:bool): ...
    def setRowHidden(self, row:int, parent:PySide2.QtCore.QModelIndex, hide:bool): ...
    def setSelection(self, rect:PySide2.QtCore.QRect, command:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setSelectionModel(self, selectionModel:PySide2.QtCore.QItemSelectionModel): ...
    def setSortingEnabled(self, enable:bool): ...
    def setTreePosition(self, logicalIndex:int): ...
    def setUniformRowHeights(self, uniform:bool): ...
    def setWordWrap(self, on:bool): ...
    def showColumn(self, column:int): ...
    def sizeHintForColumn(self, column:int) -> int: ...
    @typing.overload
    def sortByColumn(self, column:int): ...
    @typing.overload
    def sortByColumn(self, column:int, order:PySide2.QtCore.Qt.SortOrder): ...
    def timerEvent(self, event:PySide2.QtCore.QTimerEvent): ...
    def treePosition(self) -> int: ...
    def uniformRowHeights(self) -> bool: ...
    def updateGeometries(self): ...
    def verticalOffset(self) -> int: ...
    def verticalScrollbarValueChanged(self, value:int): ...
    def viewportEvent(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> PySide2.QtCore.QSize: ...
    def visualRect(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QRect: ...
    def visualRegionForSelection(self, selection:PySide2.QtCore.QItemSelection) -> PySide2.QtGui.QRegion: ...
    def wordWrap(self) -> bool: ...


class QTreeWidget(PySide2.QtWidgets.QTreeView):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def addTopLevelItem(self, item:PySide2.QtWidgets.QTreeWidgetItem): ...
    def addTopLevelItems(self, items:typing.Sequence): ...
    def clear(self): ...
    @typing.overload
    def closePersistentEditor(self, index:PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def closePersistentEditor(self, item:PySide2.QtWidgets.QTreeWidgetItem, column:int=...): ...
    def collapseItem(self, item:PySide2.QtWidgets.QTreeWidgetItem): ...
    def columnCount(self) -> int: ...
    def currentColumn(self) -> int: ...
    def currentItem(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def dropEvent(self, event:PySide2.QtGui.QDropEvent): ...
    def dropMimeData(self, parent:PySide2.QtWidgets.QTreeWidgetItem, index:int, data:PySide2.QtCore.QMimeData, action:PySide2.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item:PySide2.QtWidgets.QTreeWidgetItem, column:int=...): ...
    def event(self, e:PySide2.QtCore.QEvent) -> bool: ...
    def expandItem(self, item:PySide2.QtWidgets.QTreeWidgetItem): ...
    def findItems(self, text:str, flags:PySide2.QtCore.Qt.MatchFlags, column:int=...) -> typing.List: ...
    def headerItem(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def indexFromItem(self, item:PySide2.QtWidgets.QTreeWidgetItem, column:int=...) -> PySide2.QtCore.QModelIndex: ...
    def indexOfTopLevelItem(self, item:PySide2.QtWidgets.QTreeWidgetItem) -> int: ...
    def insertTopLevelItem(self, index:int, item:PySide2.QtWidgets.QTreeWidgetItem): ...
    def insertTopLevelItems(self, index:int, items:typing.Sequence): ...
    def invisibleRootItem(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def isFirstItemColumnSpanned(self, item:PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    def isItemExpanded(self, item:PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    def isItemHidden(self, item:PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    def isItemSelected(self, item:PySide2.QtWidgets.QTreeWidgetItem) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index:PySide2.QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, item:PySide2.QtWidgets.QTreeWidgetItem, column:int=...) -> bool: ...
    def itemAbove(self, item:PySide2.QtWidgets.QTreeWidgetItem) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    @typing.overload
    def itemAt(self, p:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    @typing.overload
    def itemAt(self, x:int, y:int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def itemBelow(self, item:PySide2.QtWidgets.QTreeWidgetItem) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def itemFromIndex(self, index:PySide2.QtCore.QModelIndex) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def itemWidget(self, item:PySide2.QtWidgets.QTreeWidgetItem, column:int) -> PySide2.QtWidgets.QWidget: ...
    def items(self, data:PySide2.QtCore.QMimeData) -> typing.List: ...
    def mimeData(self, items:typing.Sequence) -> PySide2.QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List: ...
    @typing.overload
    def openPersistentEditor(self, index:PySide2.QtCore.QModelIndex): ...
    @typing.overload
    def openPersistentEditor(self, item:PySide2.QtWidgets.QTreeWidgetItem, column:int=...): ...
    def removeItemWidget(self, item:PySide2.QtWidgets.QTreeWidgetItem, column:int): ...
    def scrollToItem(self, item:PySide2.QtWidgets.QTreeWidgetItem, hint:PySide2.QtWidgets.QAbstractItemView.ScrollHint=...): ...
    def selectedItems(self) -> typing.List: ...
    def setColumnCount(self, columns:int): ...
    @typing.overload
    def setCurrentItem(self, item:PySide2.QtWidgets.QTreeWidgetItem): ...
    @typing.overload
    def setCurrentItem(self, item:PySide2.QtWidgets.QTreeWidgetItem, column:int): ...
    @typing.overload
    def setCurrentItem(self, item:PySide2.QtWidgets.QTreeWidgetItem, column:int, command:PySide2.QtCore.QItemSelectionModel.SelectionFlags): ...
    def setFirstItemColumnSpanned(self, item:PySide2.QtWidgets.QTreeWidgetItem, span:bool): ...
    def setHeaderItem(self, item:PySide2.QtWidgets.QTreeWidgetItem): ...
    def setHeaderLabel(self, label:str): ...
    def setHeaderLabels(self, labels:typing.Sequence): ...
    def setItemExpanded(self, item:PySide2.QtWidgets.QTreeWidgetItem, expand:bool): ...
    def setItemHidden(self, item:PySide2.QtWidgets.QTreeWidgetItem, hide:bool): ...
    def setItemSelected(self, item:PySide2.QtWidgets.QTreeWidgetItem, select:bool): ...
    def setItemWidget(self, item:PySide2.QtWidgets.QTreeWidgetItem, column:int, widget:PySide2.QtWidgets.QWidget): ...
    def setModel(self, model:PySide2.QtCore.QAbstractItemModel): ...
    def setSelectionModel(self, selectionModel:PySide2.QtCore.QItemSelectionModel): ...
    def sortColumn(self) -> int: ...
    def sortItems(self, column:int, order:PySide2.QtCore.Qt.SortOrder): ...
    def supportedDropActions(self) -> PySide2.QtCore.Qt.DropActions: ...
    def takeTopLevelItem(self, index:int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def topLevelItem(self, index:int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def topLevelItemCount(self) -> int: ...
    def visualItemRect(self, item:PySide2.QtWidgets.QTreeWidgetItem) -> PySide2.QtCore.QRect: ...


class QTreeWidgetItem(Shiboken.Object):
    ShowIndicator            : QTreeWidgetItem = ... # 0x0
    Type                     : QTreeWidgetItem = ... # 0x0
    DontShowIndicator        : QTreeWidgetItem = ... # 0x1
    DontShowIndicatorWhenChildless: QTreeWidgetItem = ... # 0x2
    UserType                 : QTreeWidgetItem = ... # 0x3e8

    class ChildIndicatorPolicy(object):
        ShowIndicator            : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x0
        DontShowIndicator        : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x1
        DontShowIndicatorWhenChildless: QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x2

    class ItemType(object):
        Type                     : QTreeWidgetItem.ItemType = ... # 0x0
        UserType                 : QTreeWidgetItem.ItemType = ... # 0x3e8

    @typing.overload
    def __init__(self, other:PySide2.QtWidgets.QTreeWidgetItem): ...
    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QTreeWidgetItem, after:PySide2.QtWidgets.QTreeWidgetItem, type:int=...): ...
    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QTreeWidgetItem, strings:typing.Sequence, type:int=...): ...
    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QTreeWidgetItem, type:int=...): ...
    @typing.overload
    def __init__(self, strings:typing.Sequence, type:int=...): ...
    @typing.overload
    def __init__(self, treeview:PySide2.QtWidgets.QTreeWidget, after:PySide2.QtWidgets.QTreeWidgetItem, type:int=...): ...
    @typing.overload
    def __init__(self, treeview:PySide2.QtWidgets.QTreeWidget, strings:typing.Sequence, type:int=...): ...
    @typing.overload
    def __init__(self, treeview:PySide2.QtWidgets.QTreeWidget, type:int=...): ...
    @typing.overload
    def __init__(self, type:int=...): ...

    def __lshift__(self, out:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __rshift__(self, in_:PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def addChild(self, child:PySide2.QtWidgets.QTreeWidgetItem): ...
    def addChildren(self, children:typing.Sequence): ...
    def background(self, column:int) -> PySide2.QtGui.QBrush: ...
    def backgroundColor(self, column:int) -> PySide2.QtGui.QColor: ...
    def checkState(self, column:int) -> PySide2.QtCore.Qt.CheckState: ...
    def child(self, index:int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def childCount(self) -> int: ...
    def childIndicatorPolicy(self) -> PySide2.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy: ...
    def clone(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def columnCount(self) -> int: ...
    def data(self, column:int, role:int) -> typing.Any: ...
    def emitDataChanged(self): ...
    def flags(self) -> PySide2.QtCore.Qt.ItemFlags: ...
    def font(self, column:int) -> PySide2.QtGui.QFont: ...
    def foreground(self, column:int) -> PySide2.QtGui.QBrush: ...
    def icon(self, column:int) -> PySide2.QtGui.QIcon: ...
    def indexOfChild(self, child:PySide2.QtWidgets.QTreeWidgetItem) -> int: ...
    def insertChild(self, index:int, child:PySide2.QtWidgets.QTreeWidgetItem): ...
    def insertChildren(self, index:int, children:typing.Sequence): ...
    def isDisabled(self) -> bool: ...
    def isExpanded(self) -> bool: ...
    def isFirstColumnSpanned(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def parent(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def read(self, in_:PySide2.QtCore.QDataStream): ...
    def removeChild(self, child:PySide2.QtWidgets.QTreeWidgetItem): ...
    def setBackground(self, column:int, brush:PySide2.QtGui.QBrush): ...
    def setBackgroundColor(self, column:int, color:PySide2.QtGui.QColor): ...
    def setCheckState(self, column:int, state:PySide2.QtCore.Qt.CheckState): ...
    def setChildIndicatorPolicy(self, policy:PySide2.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy): ...
    def setData(self, column:int, role:int, value:typing.Any): ...
    def setDisabled(self, disabled:bool): ...
    def setExpanded(self, expand:bool): ...
    def setFirstColumnSpanned(self, span:bool): ...
    def setFlags(self, flags:PySide2.QtCore.Qt.ItemFlags): ...
    def setFont(self, column:int, font:PySide2.QtGui.QFont): ...
    def setForeground(self, column:int, brush:PySide2.QtGui.QBrush): ...
    def setHidden(self, hide:bool): ...
    def setIcon(self, column:int, icon:PySide2.QtGui.QIcon): ...
    def setSelected(self, select:bool): ...
    def setSizeHint(self, column:int, size:PySide2.QtCore.QSize): ...
    def setStatusTip(self, column:int, statusTip:str): ...
    def setText(self, column:int, text:str): ...
    def setTextAlignment(self, column:int, alignment:int): ...
    def setTextColor(self, column:int, color:PySide2.QtGui.QColor): ...
    def setToolTip(self, column:int, toolTip:str): ...
    def setWhatsThis(self, column:int, whatsThis:str): ...
    def sizeHint(self, column:int) -> PySide2.QtCore.QSize: ...
    def sortChildren(self, column:int, order:PySide2.QtCore.Qt.SortOrder): ...
    def statusTip(self, column:int) -> str: ...
    def takeChild(self, index:int) -> PySide2.QtWidgets.QTreeWidgetItem: ...
    def takeChildren(self) -> typing.List: ...
    def text(self, column:int) -> str: ...
    def textAlignment(self, column:int) -> int: ...
    def textColor(self, column:int) -> PySide2.QtGui.QColor: ...
    def toolTip(self, column:int) -> str: ...
    def treeWidget(self) -> PySide2.QtWidgets.QTreeWidget: ...
    def type(self) -> int: ...
    def whatsThis(self, column:int) -> str: ...
    def write(self, out:PySide2.QtCore.QDataStream): ...


class QTreeWidgetItemIterator(Shiboken.Object):
    All                      : QTreeWidgetItemIterator = ... # 0x0
    Hidden                   : QTreeWidgetItemIterator = ... # 0x1
    NotHidden                : QTreeWidgetItemIterator = ... # 0x2
    Selected                 : QTreeWidgetItemIterator = ... # 0x4
    Unselected               : QTreeWidgetItemIterator = ... # 0x8
    Selectable               : QTreeWidgetItemIterator = ... # 0x10
    NotSelectable            : QTreeWidgetItemIterator = ... # 0x20
    DragEnabled              : QTreeWidgetItemIterator = ... # 0x40
    DragDisabled             : QTreeWidgetItemIterator = ... # 0x80
    DropEnabled              : QTreeWidgetItemIterator = ... # 0x100
    DropDisabled             : QTreeWidgetItemIterator = ... # 0x200
    HasChildren              : QTreeWidgetItemIterator = ... # 0x400
    NoChildren               : QTreeWidgetItemIterator = ... # 0x800
    Checked                  : QTreeWidgetItemIterator = ... # 0x1000
    NotChecked               : QTreeWidgetItemIterator = ... # 0x2000
    Enabled                  : QTreeWidgetItemIterator = ... # 0x4000
    Disabled                 : QTreeWidgetItemIterator = ... # 0x8000
    Editable                 : QTreeWidgetItemIterator = ... # 0x10000
    NotEditable              : QTreeWidgetItemIterator = ... # 0x20000
    UserFlag                 : QTreeWidgetItemIterator = ... # 0x1000000

    class IteratorFlag(object):
        All                      : QTreeWidgetItemIterator.IteratorFlag = ... # 0x0
        Hidden                   : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1
        NotHidden                : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2
        Selected                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4
        Unselected               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8
        Selectable               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10
        NotSelectable            : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20
        DragEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x40
        DragDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x80
        DropEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x100
        DropDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x200
        HasChildren              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x400
        NoChildren               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x800
        Checked                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000
        NotChecked               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2000
        Enabled                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4000
        Disabled                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8000
        Editable                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10000
        NotEditable              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20000
        UserFlag                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000000

    class IteratorFlags(object): ...

    @typing.overload
    def __init__(self, it:PySide2.QtWidgets.QTreeWidgetItemIterator): ...
    @typing.overload
    def __init__(self, item:PySide2.QtWidgets.QTreeWidgetItem, flags:PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags=...): ...
    @typing.overload
    def __init__(self, widget:PySide2.QtWidgets.QTreeWidget, flags:PySide2.QtWidgets.QTreeWidgetItemIterator.IteratorFlags=...): ...

    def __copy__(self): ...
    def __iadd__(self, n:int) -> PySide2.QtWidgets.QTreeWidgetItemIterator: ...
    def __isub__(self, n:int) -> PySide2.QtWidgets.QTreeWidgetItemIterator: ...
    def __iter__(self) -> object: ...
    def __next__(self) -> object: ...
    def value(self) -> PySide2.QtWidgets.QTreeWidgetItem: ...


class QUndoCommand(Shiboken.Object):

    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QUndoCommand]=...): ...
    @typing.overload
    def __init__(self, text:str, parent:typing.Optional[PySide2.QtWidgets.QUndoCommand]=...): ...

    def actionText(self) -> str: ...
    def child(self, index:int) -> PySide2.QtWidgets.QUndoCommand: ...
    def childCount(self) -> int: ...
    def id(self) -> int: ...
    def isObsolete(self) -> bool: ...
    def mergeWith(self, other:PySide2.QtWidgets.QUndoCommand) -> bool: ...
    def redo(self): ...
    def setObsolete(self, obsolete:bool): ...
    def setText(self, text:str): ...
    def text(self) -> str: ...
    def undo(self): ...


class QUndoGroup(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def activeStack(self) -> PySide2.QtWidgets.QUndoStack: ...
    def addStack(self, stack:PySide2.QtWidgets.QUndoStack): ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def createRedoAction(self, parent:PySide2.QtCore.QObject, prefix:str=...) -> PySide2.QtWidgets.QAction: ...
    def createUndoAction(self, parent:PySide2.QtCore.QObject, prefix:str=...) -> PySide2.QtWidgets.QAction: ...
    def isClean(self) -> bool: ...
    def redo(self): ...
    def redoText(self) -> str: ...
    def removeStack(self, stack:PySide2.QtWidgets.QUndoStack): ...
    def setActiveStack(self, stack:PySide2.QtWidgets.QUndoStack): ...
    def stacks(self) -> typing.List: ...
    def undo(self): ...
    def undoText(self) -> str: ...


class QUndoStack(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...): ...

    def beginMacro(self, text:str): ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def cleanIndex(self) -> int: ...
    def clear(self): ...
    def command(self, index:int) -> PySide2.QtWidgets.QUndoCommand: ...
    def count(self) -> int: ...
    def createRedoAction(self, parent:PySide2.QtCore.QObject, prefix:str=...) -> PySide2.QtWidgets.QAction: ...
    def createUndoAction(self, parent:PySide2.QtCore.QObject, prefix:str=...) -> PySide2.QtWidgets.QAction: ...
    def endMacro(self): ...
    def index(self) -> int: ...
    def isActive(self) -> bool: ...
    def isClean(self) -> bool: ...
    def push(self, cmd:PySide2.QtWidgets.QUndoCommand): ...
    def redo(self): ...
    def redoText(self) -> str: ...
    def resetClean(self): ...
    def setActive(self, active:bool=...): ...
    def setClean(self): ...
    def setIndex(self, idx:int): ...
    def setUndoLimit(self, limit:int): ...
    def text(self, idx:int) -> str: ...
    def undo(self): ...
    def undoLimit(self) -> int: ...
    def undoText(self) -> str: ...


class QUndoView(PySide2.QtWidgets.QListView):

    @typing.overload
    def __init__(self, group:PySide2.QtWidgets.QUndoGroup, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...
    @typing.overload
    def __init__(self, stack:PySide2.QtWidgets.QUndoStack, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def cleanIcon(self) -> PySide2.QtGui.QIcon: ...
    def emptyLabel(self) -> str: ...
    def group(self) -> PySide2.QtWidgets.QUndoGroup: ...
    def setCleanIcon(self, icon:PySide2.QtGui.QIcon): ...
    def setEmptyLabel(self, label:str): ...
    def setGroup(self, group:PySide2.QtWidgets.QUndoGroup): ...
    def setStack(self, stack:PySide2.QtWidgets.QUndoStack): ...
    def stack(self) -> PySide2.QtWidgets.QUndoStack: ...


class QVBoxLayout(PySide2.QtWidgets.QBoxLayout):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, parent:PySide2.QtWidgets.QWidget): ...


class QWhatsThis(Shiboken.Object):
    @staticmethod
    def createAction(parent:typing.Optional[PySide2.QtCore.QObject]=...) -> PySide2.QtWidgets.QAction: ...
    @staticmethod
    def enterWhatsThisMode(): ...
    @staticmethod
    def hideText(): ...
    @staticmethod
    def inWhatsThisMode() -> bool: ...
    @staticmethod
    def leaveWhatsThisMode(): ...
    @staticmethod
    def showText(pos:PySide2.QtCore.QPoint, text:str, w:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...


class QWidget(PySide2.QtCore.QObject, PySide2.QtGui.QPaintDevice):
    DrawWindowBackground     : QWidget = ... # 0x1
    DrawChildren             : QWidget = ... # 0x2
    IgnoreMask               : QWidget = ... # 0x4

    class RenderFlag(object):
        DrawWindowBackground     : QWidget.RenderFlag = ... # 0x1
        DrawChildren             : QWidget.RenderFlag = ... # 0x2
        IgnoreMask               : QWidget.RenderFlag = ... # 0x4

    class RenderFlags(object): ...

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., f:PySide2.QtCore.Qt.WindowFlags=...): ...

    def acceptDrops(self) -> bool: ...
    def accessibleDescription(self) -> str: ...
    def accessibleName(self) -> str: ...
    def actionEvent(self, event:PySide2.QtGui.QActionEvent): ...
    def actions(self) -> typing.List: ...
    def activateWindow(self): ...
    def addAction(self, action:PySide2.QtWidgets.QAction): ...
    def addActions(self, actions:typing.Sequence): ...
    def adjustSize(self): ...
    def autoFillBackground(self) -> bool: ...
    def backgroundRole(self) -> PySide2.QtGui.QPalette.ColorRole: ...
    def backingStore(self) -> PySide2.QtGui.QBackingStore: ...
    def baseSize(self) -> PySide2.QtCore.QSize: ...
    def changeEvent(self, event:PySide2.QtCore.QEvent): ...
    @typing.overload
    def childAt(self, p:PySide2.QtCore.QPoint) -> PySide2.QtWidgets.QWidget: ...
    @typing.overload
    def childAt(self, x:int, y:int) -> PySide2.QtWidgets.QWidget: ...
    def childrenRect(self) -> PySide2.QtCore.QRect: ...
    def childrenRegion(self) -> PySide2.QtGui.QRegion: ...
    def clearFocus(self): ...
    def clearMask(self): ...
    def close(self) -> bool: ...
    def closeEvent(self, event:PySide2.QtGui.QCloseEvent): ...
    def contentsMargins(self) -> PySide2.QtCore.QMargins: ...
    def contentsRect(self) -> PySide2.QtCore.QRect: ...
    def contextMenuEvent(self, event:PySide2.QtGui.QContextMenuEvent): ...
    def contextMenuPolicy(self) -> PySide2.QtCore.Qt.ContextMenuPolicy: ...
    def create(self, arg__1:int=..., initializeWindow:bool=..., destroyOldWindow:bool=...): ...
    def createWinId(self): ...
    @staticmethod
    def createWindowContainer(window:PySide2.QtGui.QWindow, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., flags:PySide2.QtCore.Qt.WindowFlags=...) -> PySide2.QtWidgets.QWidget: ...
    def cursor(self) -> PySide2.QtGui.QCursor: ...
    def destroy(self, destroyWindow:bool=..., destroySubWindows:bool=...): ...
    def devType(self) -> int: ...
    def dragEnterEvent(self, event:PySide2.QtGui.QDragEnterEvent): ...
    def dragLeaveEvent(self, event:PySide2.QtGui.QDragLeaveEvent): ...
    def dragMoveEvent(self, event:PySide2.QtGui.QDragMoveEvent): ...
    def dropEvent(self, event:PySide2.QtGui.QDropEvent): ...
    def effectiveWinId(self) -> int: ...
    def ensurePolished(self): ...
    def enterEvent(self, event:PySide2.QtCore.QEvent): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    @staticmethod
    def find(arg__1:int) -> PySide2.QtWidgets.QWidget: ...
    def focusInEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusNextChild(self) -> bool: ...
    def focusNextPrevChild(self, next:bool) -> bool: ...
    def focusOutEvent(self, event:PySide2.QtGui.QFocusEvent): ...
    def focusPolicy(self) -> PySide2.QtCore.Qt.FocusPolicy: ...
    def focusPreviousChild(self) -> bool: ...
    def focusProxy(self) -> PySide2.QtWidgets.QWidget: ...
    def focusWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def font(self) -> PySide2.QtGui.QFont: ...
    def fontInfo(self) -> PySide2.QtGui.QFontInfo: ...
    def fontMetrics(self) -> PySide2.QtGui.QFontMetrics: ...
    def foregroundRole(self) -> PySide2.QtGui.QPalette.ColorRole: ...
    def frameGeometry(self) -> PySide2.QtCore.QRect: ...
    def frameSize(self) -> PySide2.QtCore.QSize: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def getContentsMargins(self) -> typing.Tuple: ...
    def grab(self, rectangle:PySide2.QtCore.QRect=...) -> PySide2.QtGui.QPixmap: ...
    def grabGesture(self, type:PySide2.QtCore.Qt.GestureType, flags:PySide2.QtCore.Qt.GestureFlags=...): ...
    def grabKeyboard(self): ...
    @typing.overload
    def grabMouse(self): ...
    @typing.overload
    def grabMouse(self, arg__1:PySide2.QtGui.QCursor): ...
    def grabShortcut(self, key:PySide2.QtGui.QKeySequence, context:PySide2.QtCore.Qt.ShortcutContext=...) -> int: ...
    def graphicsEffect(self) -> PySide2.QtWidgets.QGraphicsEffect: ...
    def graphicsProxyWidget(self) -> PySide2.QtWidgets.QGraphicsProxyWidget: ...
    def hasFocus(self) -> bool: ...
    def hasHeightForWidth(self) -> bool: ...
    def hasMouseTracking(self) -> bool: ...
    def hasTabletTracking(self) -> bool: ...
    def height(self) -> int: ...
    def heightForWidth(self, arg__1:int) -> int: ...
    def hide(self): ...
    def hideEvent(self, event:PySide2.QtGui.QHideEvent): ...
    def initPainter(self, painter:PySide2.QtGui.QPainter): ...
    def inputMethodEvent(self, event:PySide2.QtGui.QInputMethodEvent): ...
    def inputMethodHints(self) -> PySide2.QtCore.Qt.InputMethodHints: ...
    def inputMethodQuery(self, arg__1:PySide2.QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def insertAction(self, before:PySide2.QtWidgets.QAction, action:PySide2.QtWidgets.QAction): ...
    def insertActions(self, before:PySide2.QtWidgets.QAction, actions:typing.Sequence): ...
    def internalWinId(self) -> int: ...
    def isActiveWindow(self) -> bool: ...
    def isAncestorOf(self, child:PySide2.QtWidgets.QWidget) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isEnabledTo(self, arg__1:PySide2.QtWidgets.QWidget) -> bool: ...
    def isEnabledToTLW(self) -> bool: ...
    def isFullScreen(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isLeftToRight(self) -> bool: ...
    def isMaximized(self) -> bool: ...
    def isMinimized(self) -> bool: ...
    def isModal(self) -> bool: ...
    def isRightToLeft(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def isVisibleTo(self, arg__1:PySide2.QtWidgets.QWidget) -> bool: ...
    def isWindow(self) -> bool: ...
    def isWindowModified(self) -> bool: ...
    def keyPressEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    def keyReleaseEvent(self, event:PySide2.QtGui.QKeyEvent): ...
    @staticmethod
    def keyboardGrabber() -> PySide2.QtWidgets.QWidget: ...
    def layout(self) -> PySide2.QtWidgets.QLayout: ...
    def layoutDirection(self) -> PySide2.QtCore.Qt.LayoutDirection: ...
    def leaveEvent(self, event:PySide2.QtCore.QEvent): ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def lower(self): ...
    def mapFrom(self, arg__1:PySide2.QtWidgets.QWidget, arg__2:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapFromGlobal(self, arg__1:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapFromParent(self, arg__1:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapTo(self, arg__1:PySide2.QtWidgets.QWidget, arg__2:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapToGlobal(self, arg__1:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mapToParent(self, arg__1:PySide2.QtCore.QPoint) -> PySide2.QtCore.QPoint: ...
    def mask(self) -> PySide2.QtGui.QRegion: ...
    def maximumHeight(self) -> int: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def maximumWidth(self) -> int: ...
    def metric(self, arg__1:PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSizeHint(self) -> PySide2.QtCore.QSize: ...
    def minimumWidth(self) -> int: ...
    def mouseDoubleClickEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    @staticmethod
    def mouseGrabber() -> PySide2.QtWidgets.QWidget: ...
    def mouseMoveEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mousePressEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    def mouseReleaseEvent(self, event:PySide2.QtGui.QMouseEvent): ...
    @typing.overload
    def move(self, arg__1:PySide2.QtCore.QPoint): ...
    @typing.overload
    def move(self, x:int, y:int): ...
    def moveEvent(self, event:PySide2.QtGui.QMoveEvent): ...
    def nativeEvent(self, eventType:PySide2.QtCore.QByteArray, message:int) -> typing.Tuple: ...
    def nativeParentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def nextInFocusChain(self) -> PySide2.QtWidgets.QWidget: ...
    def normalGeometry(self) -> PySide2.QtCore.QRect: ...
    def overrideWindowFlags(self, type:PySide2.QtCore.Qt.WindowFlags): ...
    def overrideWindowState(self, state:PySide2.QtCore.Qt.WindowStates): ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent): ...
    def palette(self) -> PySide2.QtGui.QPalette: ...
    def parentWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def pos(self) -> PySide2.QtCore.QPoint: ...
    def previousInFocusChain(self) -> PySide2.QtWidgets.QWidget: ...
    def raise_(self): ...
    def rect(self) -> PySide2.QtCore.QRect: ...
    def redirected(self, offset:PySide2.QtCore.QPoint) -> PySide2.QtGui.QPaintDevice: ...
    def releaseKeyboard(self): ...
    def releaseMouse(self): ...
    def releaseShortcut(self, id:int): ...
    def removeAction(self, action:PySide2.QtWidgets.QAction): ...
    @typing.overload
    def render(self, painter:PySide2.QtGui.QPainter, targetOffset:PySide2.QtCore.QPoint, sourceRegion:PySide2.QtGui.QRegion=..., renderFlags:PySide2.QtWidgets.QWidget.RenderFlags=...): ...
    @typing.overload
    def render(self, target:PySide2.QtGui.QPaintDevice, targetOffset:PySide2.QtCore.QPoint=..., sourceRegion:PySide2.QtGui.QRegion=..., renderFlags:PySide2.QtWidgets.QWidget.RenderFlags=...): ...
    @typing.overload
    def repaint(self): ...
    @typing.overload
    def repaint(self, arg__1:PySide2.QtCore.QRect): ...
    @typing.overload
    def repaint(self, arg__1:PySide2.QtGui.QRegion): ...
    @typing.overload
    def repaint(self, x:int, y:int, w:int, h:int): ...
    @typing.overload
    def resize(self, arg__1:PySide2.QtCore.QSize): ...
    @typing.overload
    def resize(self, w:int, h:int): ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent): ...
    def restoreGeometry(self, geometry:PySide2.QtCore.QByteArray) -> bool: ...
    def saveGeometry(self) -> PySide2.QtCore.QByteArray: ...
    def screen(self) -> PySide2.QtGui.QScreen: ...
    @typing.overload
    def scroll(self, dx:int, dy:int): ...
    @typing.overload
    def scroll(self, dx:int, dy:int, arg__3:PySide2.QtCore.QRect): ...
    def setAcceptDrops(self, on:bool): ...
    def setAccessibleDescription(self, description:str): ...
    def setAccessibleName(self, name:str): ...
    def setAttribute(self, arg__1:PySide2.QtCore.Qt.WidgetAttribute, on:bool=...): ...
    def setAutoFillBackground(self, enabled:bool): ...
    def setBackgroundRole(self, arg__1:PySide2.QtGui.QPalette.ColorRole): ...
    @typing.overload
    def setBaseSize(self, arg__1:PySide2.QtCore.QSize): ...
    @typing.overload
    def setBaseSize(self, basew:int, baseh:int): ...
    @typing.overload
    def setContentsMargins(self, left:int, top:int, right:int, bottom:int): ...
    @typing.overload
    def setContentsMargins(self, margins:PySide2.QtCore.QMargins): ...
    def setContextMenuPolicy(self, policy:PySide2.QtCore.Qt.ContextMenuPolicy): ...
    def setCursor(self, arg__1:PySide2.QtGui.QCursor): ...
    def setDisabled(self, arg__1:bool): ...
    def setEnabled(self, arg__1:bool): ...
    def setFixedHeight(self, h:int): ...
    @typing.overload
    def setFixedSize(self, arg__1:PySide2.QtCore.QSize): ...
    @typing.overload
    def setFixedSize(self, w:int, h:int): ...
    def setFixedWidth(self, w:int): ...
    @typing.overload
    def setFocus(self): ...
    @typing.overload
    def setFocus(self, reason:PySide2.QtCore.Qt.FocusReason): ...
    def setFocusPolicy(self, policy:PySide2.QtCore.Qt.FocusPolicy): ...
    def setFocusProxy(self, arg__1:PySide2.QtWidgets.QWidget): ...
    def setFont(self, arg__1:PySide2.QtGui.QFont): ...
    def setForegroundRole(self, arg__1:PySide2.QtGui.QPalette.ColorRole): ...
    @typing.overload
    def setGeometry(self, arg__1:PySide2.QtCore.QRect): ...
    @typing.overload
    def setGeometry(self, x:int, y:int, w:int, h:int): ...
    def setGraphicsEffect(self, effect:PySide2.QtWidgets.QGraphicsEffect): ...
    def setHidden(self, hidden:bool): ...
    def setInputMethodHints(self, hints:PySide2.QtCore.Qt.InputMethodHints): ...
    def setLayout(self, arg__1:PySide2.QtWidgets.QLayout): ...
    def setLayoutDirection(self, direction:PySide2.QtCore.Qt.LayoutDirection): ...
    def setLocale(self, locale:PySide2.QtCore.QLocale): ...
    @typing.overload
    def setMask(self, arg__1:PySide2.QtGui.QBitmap): ...
    @typing.overload
    def setMask(self, arg__1:PySide2.QtGui.QRegion): ...
    def setMaximumHeight(self, maxh:int): ...
    @typing.overload
    def setMaximumSize(self, arg__1:PySide2.QtCore.QSize): ...
    @typing.overload
    def setMaximumSize(self, maxw:int, maxh:int): ...
    def setMaximumWidth(self, maxw:int): ...
    def setMinimumHeight(self, minh:int): ...
    @typing.overload
    def setMinimumSize(self, arg__1:PySide2.QtCore.QSize): ...
    @typing.overload
    def setMinimumSize(self, minw:int, minh:int): ...
    def setMinimumWidth(self, minw:int): ...
    def setMouseTracking(self, enable:bool): ...
    def setPalette(self, arg__1:PySide2.QtGui.QPalette): ...
    @typing.overload
    def setParent(self, parent:PySide2.QtWidgets.QWidget): ...
    @typing.overload
    def setParent(self, parent:PySide2.QtWidgets.QWidget, f:PySide2.QtCore.Qt.WindowFlags): ...
    def setShortcutAutoRepeat(self, id:int, enable:bool=...): ...
    def setShortcutEnabled(self, id:int, enable:bool=...): ...
    @typing.overload
    def setSizeIncrement(self, arg__1:PySide2.QtCore.QSize): ...
    @typing.overload
    def setSizeIncrement(self, w:int, h:int): ...
    @typing.overload
    def setSizePolicy(self, arg__1:PySide2.QtWidgets.QSizePolicy): ...
    @typing.overload
    def setSizePolicy(self, horizontal:PySide2.QtWidgets.QSizePolicy.Policy, vertical:PySide2.QtWidgets.QSizePolicy.Policy): ...
    def setStatusTip(self, arg__1:str): ...
    def setStyle(self, arg__1:PySide2.QtWidgets.QStyle): ...
    def setStyleSheet(self, styleSheet:str): ...
    @staticmethod
    def setTabOrder(arg__1:PySide2.QtWidgets.QWidget, arg__2:PySide2.QtWidgets.QWidget): ...
    def setTabletTracking(self, enable:bool): ...
    def setToolTip(self, arg__1:str): ...
    def setToolTipDuration(self, msec:int): ...
    def setUpdatesEnabled(self, enable:bool): ...
    def setVisible(self, visible:bool): ...
    def setWhatsThis(self, arg__1:str): ...
    def setWindowFilePath(self, filePath:str): ...
    def setWindowFlag(self, arg__1:PySide2.QtCore.Qt.WindowType, on:bool=...): ...
    def setWindowFlags(self, type:PySide2.QtCore.Qt.WindowFlags): ...
    def setWindowIcon(self, icon:PySide2.QtGui.QIcon): ...
    def setWindowIconText(self, arg__1:str): ...
    def setWindowModality(self, windowModality:PySide2.QtCore.Qt.WindowModality): ...
    def setWindowModified(self, arg__1:bool): ...
    def setWindowOpacity(self, level:float): ...
    def setWindowRole(self, arg__1:str): ...
    def setWindowState(self, state:PySide2.QtCore.Qt.WindowStates): ...
    def setWindowTitle(self, arg__1:str): ...
    def sharedPainter(self) -> PySide2.QtGui.QPainter: ...
    def show(self): ...
    def showEvent(self, event:PySide2.QtGui.QShowEvent): ...
    def showFullScreen(self): ...
    def showMaximized(self): ...
    def showMinimized(self): ...
    def showNormal(self): ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def sizeIncrement(self) -> PySide2.QtCore.QSize: ...
    def sizePolicy(self) -> PySide2.QtWidgets.QSizePolicy: ...
    def stackUnder(self, arg__1:PySide2.QtWidgets.QWidget): ...
    def statusTip(self) -> str: ...
    def style(self) -> PySide2.QtWidgets.QStyle: ...
    def styleSheet(self) -> str: ...
    def tabletEvent(self, event:PySide2.QtGui.QTabletEvent): ...
    def testAttribute(self, arg__1:PySide2.QtCore.Qt.WidgetAttribute) -> bool: ...
    def toolTip(self) -> str: ...
    def toolTipDuration(self) -> int: ...
    def topLevelWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def underMouse(self) -> bool: ...
    def ungrabGesture(self, type:PySide2.QtCore.Qt.GestureType): ...
    def unsetCursor(self): ...
    def unsetLayoutDirection(self): ...
    def unsetLocale(self): ...
    @typing.overload
    def update(self): ...
    @typing.overload
    def update(self, arg__1:PySide2.QtCore.QRect): ...
    @typing.overload
    def update(self, arg__1:PySide2.QtGui.QRegion): ...
    @typing.overload
    def update(self, x:int, y:int, w:int, h:int): ...
    def updateGeometry(self): ...
    def updateMicroFocus(self): ...
    def updatesEnabled(self) -> bool: ...
    def visibleRegion(self) -> PySide2.QtGui.QRegion: ...
    def whatsThis(self) -> str: ...
    def wheelEvent(self, event:PySide2.QtGui.QWheelEvent): ...
    def width(self) -> int: ...
    def winId(self) -> int: ...
    def window(self) -> PySide2.QtWidgets.QWidget: ...
    def windowFilePath(self) -> str: ...
    def windowFlags(self) -> PySide2.QtCore.Qt.WindowFlags: ...
    def windowHandle(self) -> PySide2.QtGui.QWindow: ...
    def windowIcon(self) -> PySide2.QtGui.QIcon: ...
    def windowIconText(self) -> str: ...
    def windowModality(self) -> PySide2.QtCore.Qt.WindowModality: ...
    def windowOpacity(self) -> float: ...
    def windowRole(self) -> str: ...
    def windowState(self) -> PySide2.QtCore.Qt.WindowStates: ...
    def windowTitle(self) -> str: ...
    def windowType(self) -> PySide2.QtCore.Qt.WindowType: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QWidgetAction(PySide2.QtWidgets.QAction):

    def __init__(self, parent:PySide2.QtCore.QObject): ...

    def createWidget(self, parent:PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def createdWidgets(self) -> typing.List: ...
    def defaultWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def deleteWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def event(self, arg__1:PySide2.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1:PySide2.QtCore.QObject, arg__2:PySide2.QtCore.QEvent) -> bool: ...
    def releaseWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def requestWidget(self, parent:PySide2.QtWidgets.QWidget) -> PySide2.QtWidgets.QWidget: ...
    def setDefaultWidget(self, w:PySide2.QtWidgets.QWidget): ...


class QWidgetItem(PySide2.QtWidgets.QLayoutItem):

    def __init__(self, w:PySide2.QtWidgets.QWidget): ...

    def controlTypes(self) -> PySide2.QtWidgets.QSizePolicy.ControlTypes: ...
    def expandingDirections(self) -> PySide2.QtCore.Qt.Orientations: ...
    def geometry(self) -> PySide2.QtCore.QRect: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1:int) -> int: ...
    def isEmpty(self) -> bool: ...
    def maximumSize(self) -> PySide2.QtCore.QSize: ...
    def minimumSize(self) -> PySide2.QtCore.QSize: ...
    def setGeometry(self, arg__1:PySide2.QtCore.QRect): ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def widget(self) -> PySide2.QtWidgets.QWidget: ...


class QWizard(PySide2.QtWidgets.QDialog):
    NoButton                 : QWizard = ... # -0x1
    BackButton               : QWizard = ... # 0x0
    ClassicStyle             : QWizard = ... # 0x0
    WatermarkPixmap          : QWizard = ... # 0x0
    IndependentPages         : QWizard = ... # 0x1
    LogoPixmap               : QWizard = ... # 0x1
    ModernStyle              : QWizard = ... # 0x1
    NextButton               : QWizard = ... # 0x1
    BannerPixmap             : QWizard = ... # 0x2
    CommitButton             : QWizard = ... # 0x2
    IgnoreSubTitles          : QWizard = ... # 0x2
    MacStyle                 : QWizard = ... # 0x2
    AeroStyle                : QWizard = ... # 0x3
    BackgroundPixmap         : QWizard = ... # 0x3
    FinishButton             : QWizard = ... # 0x3
    CancelButton             : QWizard = ... # 0x4
    ExtendedWatermarkPixmap  : QWizard = ... # 0x4
    NPixmaps                 : QWizard = ... # 0x4
    NStyles                  : QWizard = ... # 0x4
    HelpButton               : QWizard = ... # 0x5
    CustomButton1            : QWizard = ... # 0x6
    NStandardButtons         : QWizard = ... # 0x6
    CustomButton2            : QWizard = ... # 0x7
    CustomButton3            : QWizard = ... # 0x8
    NoDefaultButton          : QWizard = ... # 0x8
    NButtons                 : QWizard = ... # 0x9
    Stretch                  : QWizard = ... # 0x9
    NoBackButtonOnStartPage  : QWizard = ... # 0x10
    NoBackButtonOnLastPage   : QWizard = ... # 0x20
    DisabledBackButtonOnLastPage: QWizard = ... # 0x40
    HaveNextButtonOnLastPage : QWizard = ... # 0x80
    HaveFinishButtonOnEarlyPages: QWizard = ... # 0x100
    NoCancelButton           : QWizard = ... # 0x200
    CancelButtonOnLeft       : QWizard = ... # 0x400
    HaveHelpButton           : QWizard = ... # 0x800
    HelpButtonOnRight        : QWizard = ... # 0x1000
    HaveCustomButton1        : QWizard = ... # 0x2000
    HaveCustomButton2        : QWizard = ... # 0x4000
    HaveCustomButton3        : QWizard = ... # 0x8000
    NoCancelButtonOnLastPage : QWizard = ... # 0x10000

    class WizardButton(object):
        NoButton                 : QWizard.WizardButton = ... # -0x1
        BackButton               : QWizard.WizardButton = ... # 0x0
        NextButton               : QWizard.WizardButton = ... # 0x1
        CommitButton             : QWizard.WizardButton = ... # 0x2
        FinishButton             : QWizard.WizardButton = ... # 0x3
        CancelButton             : QWizard.WizardButton = ... # 0x4
        HelpButton               : QWizard.WizardButton = ... # 0x5
        CustomButton1            : QWizard.WizardButton = ... # 0x6
        NStandardButtons         : QWizard.WizardButton = ... # 0x6
        CustomButton2            : QWizard.WizardButton = ... # 0x7
        CustomButton3            : QWizard.WizardButton = ... # 0x8
        NButtons                 : QWizard.WizardButton = ... # 0x9
        Stretch                  : QWizard.WizardButton = ... # 0x9

    class WizardOption(object):
        IndependentPages         : QWizard.WizardOption = ... # 0x1
        IgnoreSubTitles          : QWizard.WizardOption = ... # 0x2
        ExtendedWatermarkPixmap  : QWizard.WizardOption = ... # 0x4
        NoDefaultButton          : QWizard.WizardOption = ... # 0x8
        NoBackButtonOnStartPage  : QWizard.WizardOption = ... # 0x10
        NoBackButtonOnLastPage   : QWizard.WizardOption = ... # 0x20
        DisabledBackButtonOnLastPage: QWizard.WizardOption = ... # 0x40
        HaveNextButtonOnLastPage : QWizard.WizardOption = ... # 0x80
        HaveFinishButtonOnEarlyPages: QWizard.WizardOption = ... # 0x100
        NoCancelButton           : QWizard.WizardOption = ... # 0x200
        CancelButtonOnLeft       : QWizard.WizardOption = ... # 0x400
        HaveHelpButton           : QWizard.WizardOption = ... # 0x800
        HelpButtonOnRight        : QWizard.WizardOption = ... # 0x1000
        HaveCustomButton1        : QWizard.WizardOption = ... # 0x2000
        HaveCustomButton2        : QWizard.WizardOption = ... # 0x4000
        HaveCustomButton3        : QWizard.WizardOption = ... # 0x8000
        NoCancelButtonOnLastPage : QWizard.WizardOption = ... # 0x10000

    class WizardOptions(object): ...

    class WizardPixmap(object):
        WatermarkPixmap          : QWizard.WizardPixmap = ... # 0x0
        LogoPixmap               : QWizard.WizardPixmap = ... # 0x1
        BannerPixmap             : QWizard.WizardPixmap = ... # 0x2
        BackgroundPixmap         : QWizard.WizardPixmap = ... # 0x3
        NPixmaps                 : QWizard.WizardPixmap = ... # 0x4

    class WizardStyle(object):
        ClassicStyle             : QWizard.WizardStyle = ... # 0x0
        ModernStyle              : QWizard.WizardStyle = ... # 0x1
        MacStyle                 : QWizard.WizardStyle = ... # 0x2
        AeroStyle                : QWizard.WizardStyle = ... # 0x3
        NStyles                  : QWizard.WizardStyle = ... # 0x4

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=..., flags:PySide2.QtCore.Qt.WindowFlags=...): ...

    def addPage(self, page:PySide2.QtWidgets.QWizardPage) -> int: ...
    def back(self): ...
    def button(self, which:PySide2.QtWidgets.QWizard.WizardButton) -> PySide2.QtWidgets.QAbstractButton: ...
    def buttonText(self, which:PySide2.QtWidgets.QWizard.WizardButton) -> str: ...
    def cleanupPage(self, id:int): ...
    def currentId(self) -> int: ...
    def currentPage(self) -> PySide2.QtWidgets.QWizardPage: ...
    def done(self, result:int): ...
    def event(self, event:PySide2.QtCore.QEvent) -> bool: ...
    def field(self, name:str) -> typing.Any: ...
    def hasVisitedPage(self, id:int) -> bool: ...
    def initializePage(self, id:int): ...
    def nativeEvent(self, eventType:PySide2.QtCore.QByteArray, message:int) -> typing.Tuple: ...
    def next(self): ...
    def nextId(self) -> int: ...
    def options(self) -> PySide2.QtWidgets.QWizard.WizardOptions: ...
    def page(self, id:int) -> PySide2.QtWidgets.QWizardPage: ...
    def pageIds(self) -> typing.List: ...
    def paintEvent(self, event:PySide2.QtGui.QPaintEvent): ...
    def pixmap(self, which:PySide2.QtWidgets.QWizard.WizardPixmap) -> PySide2.QtGui.QPixmap: ...
    def removePage(self, id:int): ...
    def resizeEvent(self, event:PySide2.QtGui.QResizeEvent): ...
    def restart(self): ...
    def setButton(self, which:PySide2.QtWidgets.QWizard.WizardButton, button:PySide2.QtWidgets.QAbstractButton): ...
    def setButtonLayout(self, layout:typing.Sequence): ...
    def setButtonText(self, which:PySide2.QtWidgets.QWizard.WizardButton, text:str): ...
    def setDefaultProperty(self, className:bytes, property:bytes, changedSignal:bytes): ...
    def setField(self, name:str, value:typing.Any): ...
    def setOption(self, option:PySide2.QtWidgets.QWizard.WizardOption, on:bool=...): ...
    def setOptions(self, options:PySide2.QtWidgets.QWizard.WizardOptions): ...
    def setPage(self, id:int, page:PySide2.QtWidgets.QWizardPage): ...
    def setPixmap(self, which:PySide2.QtWidgets.QWizard.WizardPixmap, pixmap:PySide2.QtGui.QPixmap): ...
    def setSideWidget(self, widget:PySide2.QtWidgets.QWidget): ...
    def setStartId(self, id:int): ...
    def setSubTitleFormat(self, format:PySide2.QtCore.Qt.TextFormat): ...
    def setTitleFormat(self, format:PySide2.QtCore.Qt.TextFormat): ...
    def setVisible(self, visible:bool): ...
    def setWizardStyle(self, style:PySide2.QtWidgets.QWizard.WizardStyle): ...
    def sideWidget(self) -> PySide2.QtWidgets.QWidget: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
    def startId(self) -> int: ...
    def subTitleFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def testOption(self, option:PySide2.QtWidgets.QWizard.WizardOption) -> bool: ...
    def titleFormat(self) -> PySide2.QtCore.Qt.TextFormat: ...
    def validateCurrentPage(self) -> bool: ...
    def visitedPages(self) -> typing.List: ...
    def wizardStyle(self) -> PySide2.QtWidgets.QWizard.WizardStyle: ...


class QWizardPage(PySide2.QtWidgets.QWidget):

    def __init__(self, parent:typing.Optional[PySide2.QtWidgets.QWidget]=...): ...

    def buttonText(self, which:PySide2.QtWidgets.QWizard.WizardButton) -> str: ...
    def cleanupPage(self): ...
    def field(self, name:str) -> typing.Any: ...
    def initializePage(self): ...
    def isCommitPage(self) -> bool: ...
    def isComplete(self) -> bool: ...
    def isFinalPage(self) -> bool: ...
    def nextId(self) -> int: ...
    def pixmap(self, which:PySide2.QtWidgets.QWizard.WizardPixmap) -> PySide2.QtGui.QPixmap: ...
    def registerField(self, name:str, widget:PySide2.QtWidgets.QWidget, property:typing.Optional[bytes]=..., changedSignal:typing.Optional[bytes]=...): ...
    def setButtonText(self, which:PySide2.QtWidgets.QWizard.WizardButton, text:str): ...
    def setCommitPage(self, commitPage:bool): ...
    def setField(self, name:str, value:typing.Any): ...
    def setFinalPage(self, finalPage:bool): ...
    def setPixmap(self, which:PySide2.QtWidgets.QWizard.WizardPixmap, pixmap:PySide2.QtGui.QPixmap): ...
    def setSubTitle(self, subTitle:str): ...
    def setTitle(self, title:str): ...
    def subTitle(self) -> str: ...
    def title(self) -> str: ...
    def validatePage(self) -> bool: ...
    def wizard(self) -> PySide2.QtWidgets.QWizard: ...

# eof
