/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2020 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

// Please update this list when adding new pins to Marlin.
// The order doesn't matter.
// Following this pattern is a must.
// If the new pin name is over 28 characters long then pinsDebug.h will need to be modified.

#if TARGET_LPC1768
  #define ANALOG_OK(PN) (WITHIN(PN, P0_02, P0_03) || WITHIN(PN, P0_23, P0_26) || WITHIN(PN, P1_30, P1_31))
#else
  #define ANALOG_OK(PN) WITHIN(PN, 0, NUM_ANALOG_INPUTS - 1)
#endif

#line 35 // set __LINE__ to a known value for both passes

//
// Analog Pin Assignments
//

#define _EXISTS(PN,V...) (defined(PN##V) && PN##V >= 0)

#if _EXISTS(EXT_AUX_A0)
  #if ANALOG_OK(EXT_AUX_A0)
  REPORT_NAME_ANALOG(__LINE__, EXT_AUX_A0)
#endif
#endif
#if _EXISTS(EXT_AUX_A1)
  #if ANALOG_OK(EXT_AUX_A0)
    REPORT_NAME_ANALOG(__LINE__, EXT_AUX_A0)
  #endif
#endif
#if _EXISTS(EXT_AUX_A2)
  #if ANALOG_OK(EXT_AUX_A0)
    REPORT_NAME_ANALOG(__LINE__, EXT_AUX_A0)
  #endif
#endif
#if _EXISTS(EXT_AUX_A3)
  #if ANALOG_OK(EXT_AUX_A0)
    REPORT_NAME_ANALOG(__LINE__, EXT_AUX_A0)
  #endif
#endif
#if _EXISTS(EXT_AUX_A4)
  #if ANALOG_OK(EXT_AUX_A0)
    REPORT_NAME_ANALOG(__LINE__, EXT_AUX_A0)
  #endif
#endif
#if PIN_EXISTS(FILWIDTH)
  #if ANALOG_OK(FILWIDTH_PIN)
    REPORT_NAME_ANALOG(__LINE__, FILWIDTH_PIN)
  #endif
#endif
#if PIN_EXISTS(MAIN_VOLTAGE_MEASURE)
  #if ANALOG_OK(MAIN_VOLTAGE_MEASURE_PIN)
    REPORT_NAME_ANALOG(__LINE__, MAIN_VOLTAGE_MEASURE_PIN)
  #endif
#endif
#if PIN_EXISTS(POWER_MONITOR_CURRENT)
  #if ANALOG_OK(POWER_MONITOR_CURRENT_PIN)
    REPORT_NAME_ANALOG(__LINE__, POWER_MONITOR_CURRENT_PIN)
  #endif
#endif
#if PIN_EXISTS(POWER_MONITOR_VOLTAGE)
  #if ANALOG_OK(POWER_MONITOR_VOLTAGE_PIN)
    REPORT_NAME_ANALOG(__LINE__, POWER_MONITOR_VOLTAGE_PIN)
  #endif
#endif
#if !defined(ARDUINO_ARCH_SAM) && !defined(ARDUINO_ARCH_SAMD)  // TC1 & TC2 are macros in the SAM/SAMD tool chain
  #if _EXISTS(TC1)
    #if ANALOG_OK(TC1)
    REPORT_NAME_ANALOG(__LINE__, TC1)
  #endif
  #endif
  #if _EXISTS(TC2)
    #if ANALOG_OK(TC1)
      REPORT_NAME_ANALOG(__LINE__, TC1)
    #endif
  #endif
#endif
#if PIN_EXISTS(TEMP_0)
  #if ANALOG_OK(TEMP_0_PIN)
      REPORT_NAME_ANALOG(__LINE__, TEMP_0_PIN)
    #endif
#endif
#if PIN_EXISTS(TEMP_1)
  #if ANALOG_OK(TEMP_1_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_1_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_2)
  #if ANALOG_OK(TEMP_2_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_2_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_3)
  #if ANALOG_OK(TEMP_3_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_3_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_4)
  #if ANALOG_OK(TEMP_4_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_4_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_5)
  #if ANALOG_OK(TEMP_5_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_5_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_6)
  #if ANALOG_OK(TEMP_6_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_6_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_7)
  #if ANALOG_OK(TEMP_7_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_7_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_BED)
  #if ANALOG_OK(TEMP_BED_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_BED_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_CHAMBER)
  #if ANALOG_OK(TEMP_CHAMBER_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_CHAMBER_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_PROBE)
  #if ANALOG_OK(TEMP_PROBE_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_PROBE_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_COOLER)
  #if ANALOG_OK(TEMP_COOLER_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_COOLER_PIN)
  #endif
#endif
#if PIN_EXISTS(TEMP_BOARD)
  #if ANALOG_OK(TEMP_BOARD_PIN)
    REPORT_NAME_ANALOG(__LINE__, TEMP_BOARD_PIN)
  #endif
#endif
#if PIN_EXISTS(ADC_KEYPAD)
  #if ANALOG_OK(ADC_KEYPAD_PIN)
    REPORT_NAME_ANALOG(__LINE__, ADC_KEYPAD_PIN)
  #endif
#endif

//
// Digital Pin Assignments
//

#if _EXISTS(__FD)
  REPORT_NAME_DIGITAL(__LINE__, __FD)
#endif
#if _EXISTS(__FS)
  REPORT_NAME_DIGITAL(__LINE__, __FS)
#endif
#if _EXISTS(__GD)
  REPORT_NAME_DIGITAL(__LINE__, __GD)
#endif
#if _EXISTS(__GS)
  REPORT_NAME_DIGITAL(__LINE__, __GS)
#endif
#if PIN_EXISTS(AVR_MISO)
  REPORT_NAME_DIGITAL(__LINE__, AVR_MISO_PIN)
#endif
#if PIN_EXISTS(AVR_MOSI)
  REPORT_NAME_DIGITAL(__LINE__, AVR_MOSI_PIN)
#endif
#if PIN_EXISTS(AVR_SCK)
  REPORT_NAME_DIGITAL(__LINE__, AVR_SCK_PIN)
#endif
#if PIN_EXISTS(ALARM)
  REPORT_NAME_DIGITAL(__LINE__, ALARM_PIN)
#endif
#if PIN_EXISTS(AVR_SS)
  REPORT_NAME_DIGITAL(__LINE__, AVR_SS_PIN)
#endif
#if PIN_EXISTS(BEEPER)
  REPORT_NAME_DIGITAL(__LINE__, BEEPER_PIN)
#endif
#if _EXISTS(BTN_BACK)
  REPORT_NAME_DIGITAL(__LINE__, BTN_BACK)
#endif
#if _EXISTS(BTN_CENTER)
  REPORT_NAME_DIGITAL(__LINE__, BTN_CENTER)
#endif
#if _EXISTS(BTN_DOWN)
  REPORT_NAME_DIGITAL(__LINE__, BTN_DOWN)
#endif
#if _EXISTS(BTN_DWN)
  REPORT_NAME_DIGITAL(__LINE__, BTN_DWN)
#endif
#if _EXISTS(BTN_EN1)
  REPORT_NAME_DIGITAL(__LINE__, BTN_EN1)
#endif
#if _EXISTS(BTN_EN2)
  REPORT_NAME_DIGITAL(__LINE__, BTN_EN2)
#endif
#if _EXISTS(BTN_ENC_EN)
  REPORT_NAME_DIGITAL(__LINE__, BTN_ENC_EN)
#endif
#if _EXISTS(BTN_ENC)
  REPORT_NAME_DIGITAL(__LINE__, BTN_ENC)
#endif
#if _EXISTS(BTN_HOME)
  REPORT_NAME_DIGITAL(__LINE__, BTN_HOME)
#endif
#if _EXISTS(BTN_LEFT)
  REPORT_NAME_DIGITAL(__LINE__, BTN_LEFT)
#endif
#if _EXISTS(BTN_LFT)
  REPORT_NAME_DIGITAL(__LINE__, BTN_LFT)
#endif
#if _EXISTS(BTN_RIGHT)
  REPORT_NAME_DIGITAL(__LINE__, BTN_RIGHT)
#endif
#if _EXISTS(BTN_RT)
  REPORT_NAME_DIGITAL(__LINE__, BTN_RT)
#endif
#if _EXISTS(BTN_UP)
  REPORT_NAME_DIGITAL(__LINE__, BTN_UP)
#endif
#if PIN_EXISTS(JOY_X)
  REPORT_NAME_DIGITAL(__LINE__, JOY_X_PIN)
#endif
#if PIN_EXISTS(JOY_Y)
  REPORT_NAME_DIGITAL(__LINE__, JOY_Y_PIN)
#endif
#if PIN_EXISTS(JOY_Z)
  REPORT_NAME_DIGITAL(__LINE__, JOY_Z_PIN)
#endif
#if PIN_EXISTS(JOY_EN)
  REPORT_NAME_DIGITAL(__LINE__, JOY_EN_PIN)
#endif
#if PIN_EXISTS(BUTTON1)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON1_PIN)
#endif
#if PIN_EXISTS(BUTTON2)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON2_PIN)
#endif
#if PIN_EXISTS(BUTTON3)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON3_PIN)
#endif
#if PIN_EXISTS(BUTTON4)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON4_PIN)
#endif
#if PIN_EXISTS(BUTTON5)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON5_PIN)
#endif
#if PIN_EXISTS(BUTTON6)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON6_PIN)
#endif
#if PIN_EXISTS(BUTTON7)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON7_PIN)
#endif
#if PIN_EXISTS(BUTTON8)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON8_PIN)
#endif
#if PIN_EXISTS(BUTTON9)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON9_PIN)
#endif
#if PIN_EXISTS(BUTTON10)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON10_PIN)
#endif
#if PIN_EXISTS(BUTTON11)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON11_PIN)
#endif
#if PIN_EXISTS(BUTTON12)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON12_PIN)
#endif
#if PIN_EXISTS(BUTTON13)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON13_PIN)
#endif
#if PIN_EXISTS(BUTTON14)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON14_PIN)
#endif
#if PIN_EXISTS(BUTTON15)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON15_PIN)
#endif
#if PIN_EXISTS(BUTTON16)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON16_PIN)
#endif
#if PIN_EXISTS(BUTTON17)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON17_PIN)
#endif
#if PIN_EXISTS(BUTTON18)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON18_PIN)
#endif
#if PIN_EXISTS(BUTTON19)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON19_PIN)
#endif
#if PIN_EXISTS(BUTTON20)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON20_PIN)
#endif
#if PIN_EXISTS(BUTTON21)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON21_PIN)
#endif
#if PIN_EXISTS(BUTTON22)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON22_PIN)
#endif
#if PIN_EXISTS(BUTTON23)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON23_PIN)
#endif
#if PIN_EXISTS(BUTTON24)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON24_PIN)
#endif
#if PIN_EXISTS(BUTTON25)
  REPORT_NAME_DIGITAL(__LINE__, BUTTON25_PIN)
#endif
#if PIN_EXISTS(CASE_LIGHT)
  REPORT_NAME_DIGITAL(__LINE__, CASE_LIGHT_PIN)
#endif
#if PIN_EXISTS(CHAMBER_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, CHAMBER_AUTO_FAN_PIN)
#endif
#if PIN_EXISTS(CONTROLLER_FAN)
  REPORT_NAME_DIGITAL(__LINE__, CONTROLLER_FAN_PIN)
#endif
#if PIN_EXISTS(COOLANT_FLOOD)
  REPORT_NAME_DIGITAL(__LINE__, COOLANT_FLOOD_PIN)
#endif
#if PIN_EXISTS(COOLANT_MIST)
  REPORT_NAME_DIGITAL(__LINE__, COOLANT_MIST_PIN)
#endif
#if PIN_EXISTS(CUTOFF_RESET)
  REPORT_NAME_DIGITAL(__LINE__, CUTOFF_RESET_PIN)
#endif
#if PIN_EXISTS(CUTOFF_TEST)
  REPORT_NAME_DIGITAL(__LINE__, CUTOFF_TEST_PIN)
#endif
#if _EXISTS(D57)
  REPORT_NAME_DIGITAL(__LINE__, D57)
#endif
#if _EXISTS(D58)
  REPORT_NAME_DIGITAL(__LINE__, D58)
#endif
#if PIN_EXISTS(DAC_DISABLE)
  REPORT_NAME_DIGITAL(__LINE__, DAC_DISABLE_PIN)
#endif
#if PIN_EXISTS(DAC0_SYNC)
  REPORT_NAME_DIGITAL(__LINE__, DAC0_SYNC_PIN)
#endif
#if PIN_EXISTS(DAC1_SYNC)
  REPORT_NAME_DIGITAL(__LINE__, DAC1_SYNC_PIN)
#endif
#if PIN_EXISTS(DEBUG)
  REPORT_NAME_DIGITAL(__LINE__, DEBUG_PIN)
#endif
#if _EXISTS(DIGIPOTS_I2C_SCL)
  REPORT_NAME_DIGITAL(__LINE__, DIGIPOTS_I2C_SCL)
#endif
#if _EXISTS(DIGIPOTS_I2C_SDA_E0)
  REPORT_NAME_DIGITAL(__LINE__, DIGIPOTS_I2C_SDA_E0)
#endif
#if _EXISTS(DIGIPOTS_I2C_SDA_E1)
  REPORT_NAME_DIGITAL(__LINE__, DIGIPOTS_I2C_SDA_E1)
#endif
#if _EXISTS(DIGIPOTS_I2C_SDA_X)
  REPORT_NAME_DIGITAL(__LINE__, DIGIPOTS_I2C_SDA_X)
#endif
#if _EXISTS(DIGIPOTS_I2C_SDA_Y)
  REPORT_NAME_DIGITAL(__LINE__, DIGIPOTS_I2C_SDA_Y)
#endif
#if _EXISTS(DIGIPOTS_I2C_SDA_Z)
  REPORT_NAME_DIGITAL(__LINE__, DIGIPOTS_I2C_SDA_Z)
#endif
#if PIN_EXISTS(DIGIPOTSS)
  REPORT_NAME_DIGITAL(__LINE__, DIGIPOTSS_PIN)
#endif
#if PIN_EXISTS(LCD_RESET)
  REPORT_NAME_DIGITAL(__LINE__, LCD_RESET_PIN)
#endif
#if _EXISTS(DOGLCD_A0)
  REPORT_NAME_DIGITAL(__LINE__, DOGLCD_A0)
#endif
#if _EXISTS(DOGLCD_CS)
  REPORT_NAME_DIGITAL(__LINE__, DOGLCD_CS)
#endif
#if _EXISTS(DOGLCD_MOSI)
  REPORT_NAME_DIGITAL(__LINE__, DOGLCD_MOSI)
#endif
#if _EXISTS(DOGLCD_SCK)
  REPORT_NAME_DIGITAL(__LINE__, DOGLCD_SCK)
#endif
#if _EXISTS(TMC_SW_MISO)
  REPORT_NAME_DIGITAL(__LINE__, TMC_SW_MISO)
#endif
#if _EXISTS(TMC_SW_MOSI)
  REPORT_NAME_DIGITAL(__LINE__, TMC_SW_MOSI)
#endif
#if _EXISTS(TMC_SW_SCK)
  REPORT_NAME_DIGITAL(__LINE__, TMC_SW_SCK)
#endif
#if _EXISTS(TFTGLCD_CS)
  REPORT_NAME_DIGITAL(__LINE__, TFTGLCD_CS)
#endif
#if PIN_EXISTS(E_MUX0)
  REPORT_NAME_DIGITAL(__LINE__, E_MUX0_PIN)
#endif
#if PIN_EXISTS(E_MUX1)
  REPORT_NAME_DIGITAL(__LINE__, E_MUX1_PIN)
#endif
#if PIN_EXISTS(E_MUX2)
  REPORT_NAME_DIGITAL(__LINE__, E_MUX2_PIN)
#endif
#if PIN_EXISTS(E_STOP)
  REPORT_NAME_DIGITAL(__LINE__, E_STOP_PIN)
#endif
#if PIN_EXISTS(E0_ATT)
  REPORT_NAME_DIGITAL(__LINE__, E0_ATT_PIN)
#endif
#if PIN_EXISTS(E0_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, E0_AUTO_FAN_PIN)
#endif
#if PIN_EXISTS(E0_CS)
  REPORT_NAME_DIGITAL(__LINE__, E0_CS_PIN)
#endif
#if PIN_EXISTS(E0_DIR)
  REPORT_NAME_DIGITAL(__LINE__, E0_DIR_PIN)
#endif
#if PIN_EXISTS(E0_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, E0_ENABLE_PIN)
#endif
#if PIN_EXISTS(E0_MS1)
  REPORT_NAME_DIGITAL(__LINE__, E0_MS1_PIN)
#endif
#if PIN_EXISTS(E0_MS2)
  REPORT_NAME_DIGITAL(__LINE__, E0_MS2_PIN)
#endif
#if PIN_EXISTS(E0_MS3)
  REPORT_NAME_DIGITAL(__LINE__, E0_MS3_PIN)
#endif
#if PIN_EXISTS(E0_STEP)
  REPORT_NAME_DIGITAL(__LINE__, E0_STEP_PIN)
#endif
#if PIN_EXISTS(E0_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, E0_STDBY_PIN)
#endif
#if PIN_EXISTS(E1_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, E1_AUTO_FAN_PIN)
#endif
#if PIN_EXISTS(E1_CS)
  REPORT_NAME_DIGITAL(__LINE__, E1_CS_PIN)
#endif
#if PIN_EXISTS(E1_DIR)
  REPORT_NAME_DIGITAL(__LINE__, E1_DIR_PIN)
#endif
#if PIN_EXISTS(E1_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, E1_ENABLE_PIN)
#endif
#if PIN_EXISTS(E1_MS1)
  REPORT_NAME_DIGITAL(__LINE__, E1_MS1_PIN)
#endif
#if PIN_EXISTS(E1_MS2)
  REPORT_NAME_DIGITAL(__LINE__, E1_MS2_PIN)
#endif
#if PIN_EXISTS(E1_MS3)
  REPORT_NAME_DIGITAL(__LINE__, E1_MS3_PIN)
#endif
#if PIN_EXISTS(E1_STEP)
  REPORT_NAME_DIGITAL(__LINE__, E1_STEP_PIN)
#endif
#if PIN_EXISTS(E1_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, E1_STDBY_PIN)
#endif
#if PIN_EXISTS(E2_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, E2_AUTO_FAN_PIN)
#endif
#if PIN_EXISTS(E2_CS)
  REPORT_NAME_DIGITAL(__LINE__, E2_CS_PIN)
#endif
#if PIN_EXISTS(E2_DIR)
  REPORT_NAME_DIGITAL(__LINE__, E2_DIR_PIN)
#endif
#if PIN_EXISTS(E2_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, E2_ENABLE_PIN)
#endif
#if PIN_EXISTS(E2_MS1)
  REPORT_NAME_DIGITAL(__LINE__, E2_MS1_PIN)
#endif
#if PIN_EXISTS(E2_MS2)
  REPORT_NAME_DIGITAL(__LINE__, E2_MS2_PIN)
#endif
#if PIN_EXISTS(E2_MS3)
  REPORT_NAME_DIGITAL(__LINE__, E2_MS3_PIN)
#endif
#if PIN_EXISTS(E2_STEP)
  REPORT_NAME_DIGITAL(__LINE__, E2_STEP_PIN)
#endif
#if PIN_EXISTS(E2_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, E2_STDBY_PIN)
#endif
#if PIN_EXISTS(E3_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, E3_AUTO_FAN_PIN)
#endif
#if PIN_EXISTS(E3_CS)
  REPORT_NAME_DIGITAL(__LINE__, E3_CS_PIN)
#endif
#if PIN_EXISTS(E3_DIR)
  REPORT_NAME_DIGITAL(__LINE__, E3_DIR_PIN)
#endif
#if PIN_EXISTS(E3_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, E3_ENABLE_PIN)
#endif
#if PIN_EXISTS(E3_MS1)
  REPORT_NAME_DIGITAL(__LINE__, E3_MS1_PIN)
#endif
#if PIN_EXISTS(E3_MS2)
  REPORT_NAME_DIGITAL(__LINE__, E3_MS2_PIN)
#endif
#if PIN_EXISTS(E3_MS3)
  REPORT_NAME_DIGITAL(__LINE__, E3_MS3_PIN)
#endif
#if PIN_EXISTS(E3_STEP)
  REPORT_NAME_DIGITAL(__LINE__, E3_STEP_PIN)
#endif
#if PIN_EXISTS(E3_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, E3_STDBY_PIN)
#endif
#if PIN_EXISTS(E4_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, E4_AUTO_FAN_PIN)
#endif
#if PIN_EXISTS(E4_CS)
  REPORT_NAME_DIGITAL(__LINE__, E4_CS_PIN)
#endif
#if PIN_EXISTS(E4_DIR)
  REPORT_NAME_DIGITAL(__LINE__, E4_DIR_PIN)
#endif
#if PIN_EXISTS(E4_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, E4_ENABLE_PIN)
#endif
#if PIN_EXISTS(E4_MS1)
  REPORT_NAME_DIGITAL(__LINE__, E4_MS1_PIN)
#endif
#if PIN_EXISTS(E4_MS2)
  REPORT_NAME_DIGITAL(__LINE__, E4_MS2_PIN)
#endif
#if PIN_EXISTS(E4_MS3)
  REPORT_NAME_DIGITAL(__LINE__, E4_MS3_PIN)
#endif
#if PIN_EXISTS(E4_STEP)
  REPORT_NAME_DIGITAL(__LINE__, E4_STEP_PIN)
#endif
#if PIN_EXISTS(E4_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, E4_STDBY_PIN)
#endif
#if PIN_EXISTS(E5_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, E5_AUTO_FAN_PIN)
#endif
#if PIN_EXISTS(E5_CS)
  REPORT_NAME_DIGITAL(__LINE__, E5_CS_PIN)
#endif
#if PIN_EXISTS(E5_DIR)
  REPORT_NAME_DIGITAL(__LINE__, E5_DIR_PIN)
#endif
#if PIN_EXISTS(E5_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, E5_ENABLE_PIN)
#endif
#if PIN_EXISTS(E5_MS1)
  REPORT_NAME_DIGITAL(__LINE__, E5_MS1_PIN)
#endif
#if PIN_EXISTS(E5_MS2)
  REPORT_NAME_DIGITAL(__LINE__, E5_MS2_PIN)
#endif
#if PIN_EXISTS(E5_MS3)
  REPORT_NAME_DIGITAL(__LINE__, E5_MS3_PIN)
#endif
#if PIN_EXISTS(E5_STEP)
  REPORT_NAME_DIGITAL(__LINE__, E5_STEP_PIN)
#endif
#if PIN_EXISTS(E5_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, E5_STDBY_PIN)
#endif
#if PIN_EXISTS(E6_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, E6_AUTO_FAN_PIN)
#endif
#if PIN_EXISTS(E6_CS)
  REPORT_NAME_DIGITAL(__LINE__, E6_CS_PIN)
#endif
#if PIN_EXISTS(E6_DIR)
  REPORT_NAME_DIGITAL(__LINE__, E6_DIR_PIN)
#endif
#if PIN_EXISTS(E6_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, E6_ENABLE_PIN)
#endif
#if PIN_EXISTS(E6_MS1)
  REPORT_NAME_DIGITAL(__LINE__, E6_MS1_PIN)
#endif
#if PIN_EXISTS(E6_MS2)
  REPORT_NAME_DIGITAL(__LINE__, E6_MS2_PIN)
#endif
#if PIN_EXISTS(E6_MS3)
  REPORT_NAME_DIGITAL(__LINE__, E6_MS3_PIN)
#endif
#if PIN_EXISTS(E6_STEP)
  REPORT_NAME_DIGITAL(__LINE__, E6_STEP_PIN)
#endif
#if PIN_EXISTS(E6_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, E6_STDBY_PIN)
#endif
#if PIN_EXISTS(E7_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, E7_AUTO_FAN_PIN)
#endif
#if PIN_EXISTS(E7_CS)
  REPORT_NAME_DIGITAL(__LINE__, E7_CS_PIN)
#endif
#if PIN_EXISTS(E7_DIR)
  REPORT_NAME_DIGITAL(__LINE__, E7_DIR_PIN)
#endif
#if PIN_EXISTS(E7_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, E7_ENABLE_PIN)
#endif
#if PIN_EXISTS(E7_MS1)
  REPORT_NAME_DIGITAL(__LINE__, E7_MS1_PIN)
#endif
#if PIN_EXISTS(E7_MS2)
  REPORT_NAME_DIGITAL(__LINE__, E7_MS2_PIN)
#endif
#if PIN_EXISTS(E7_MS3)
  REPORT_NAME_DIGITAL(__LINE__, E7_MS3_PIN)
#endif
#if PIN_EXISTS(E7_STEP)
  REPORT_NAME_DIGITAL(__LINE__, E7_STEP_PIN)
#endif
#if PIN_EXISTS(E7_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, E7_STDBY_PIN)
#endif
#if _EXISTS(ENET_CRS)
  REPORT_NAME_DIGITAL(__LINE__, ENET_CRS)
#endif
#if _EXISTS(ENET_MDIO)
  REPORT_NAME_DIGITAL(__LINE__, ENET_MDIO)
#endif
#if _EXISTS(ENET_MOC)
  REPORT_NAME_DIGITAL(__LINE__, ENET_MOC)
#endif
#if _EXISTS(ENET_RX_ER)
  REPORT_NAME_DIGITAL(__LINE__, ENET_RX_ER)
#endif
#if _EXISTS(ENET_RXD0)
  REPORT_NAME_DIGITAL(__LINE__, ENET_RXD0)
#endif
#if _EXISTS(ENET_RXD1)
  REPORT_NAME_DIGITAL(__LINE__, ENET_RXD1)
#endif
#if _EXISTS(ENET_TX_EN)
  REPORT_NAME_DIGITAL(__LINE__, ENET_TX_EN)
#endif
#if _EXISTS(ENET_TXD0)
  REPORT_NAME_DIGITAL(__LINE__, ENET_TXD0)
#endif
#if _EXISTS(ENET_TXD1)
  REPORT_NAME_DIGITAL(__LINE__, ENET_TXD1)
#endif
#if PIN_EXISTS(EXP_VOLTAGE_LEVEL)
  REPORT_NAME_DIGITAL(__LINE__, EXP_VOLTAGE_LEVEL_PIN)
#endif

#if _EXISTS(EXT_AUX_A0_IO)
  REPORT_NAME_DIGITAL(__LINE__, EXT_AUX_A0_IO)
#endif
#if _EXISTS(EXT_AUX_A1_IO)
  REPORT_NAME_DIGITAL(__LINE__, EXT_AUX_A1_IO)
#endif
#if _EXISTS(EXT_AUX_A2_IO)
  REPORT_NAME_DIGITAL(__LINE__, EXT_AUX_A2_IO)
#endif
#if _EXISTS(EXT_AUX_A3_IO)
  REPORT_NAME_DIGITAL(__LINE__, EXT_AUX_A3_IO)
#endif
#if _EXISTS(EXT_AUX_A4_IO)
  REPORT_NAME_DIGITAL(__LINE__, EXT_AUX_A4_IO)
#endif
#if _EXISTS(EXT_AUX_PWM_D24)
  REPORT_NAME_DIGITAL(__LINE__, EXT_AUX_PWM_D24)
#endif
#if _EXISTS(EXT_AUX_RX1_D2)
  REPORT_NAME_DIGITAL(__LINE__, EXT_AUX_RX1_D2)
#endif
#if _EXISTS(EXT_AUX_SCL_D0)
  REPORT_NAME_DIGITAL(__LINE__, EXT_AUX_SCL_D0)
#endif
#if _EXISTS(EXT_AUX_SDA_D1)
  REPORT_NAME_DIGITAL(__LINE__, EXT_AUX_SDA_D1)
#endif
#if _EXISTS(EXT_AUX_TX1_D3)
  REPORT_NAME_DIGITAL(__LINE__, EXT_AUX_TX1_D3)
#endif
#if _EXISTS(EXTRUDER_0_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, EXTRUDER_0_AUTO_FAN)
#endif
#if _EXISTS(EXTRUDER_1_AUTO_FAN)
  REPORT_NAME_DIGITAL(__LINE__, EXTRUDER_1_AUTO_FAN)
#endif
#if PIN_EXISTS(FAN)
  REPORT_NAME_DIGITAL(__LINE__, FAN_PIN)
#endif
#if PIN_EXISTS(FAN1)
  REPORT_NAME_DIGITAL(__LINE__, FAN1_PIN)
#endif
#if PIN_EXISTS(FAN2)
  REPORT_NAME_DIGITAL(__LINE__, FAN2_PIN)
#endif
#if PIN_EXISTS(FAN3)
  REPORT_NAME_DIGITAL(__LINE__, FAN3_PIN)
#endif
#if PIN_EXISTS(FAN4)
  REPORT_NAME_DIGITAL(__LINE__, FAN4_PIN)
#endif
#if PIN_EXISTS(FAN5)
  REPORT_NAME_DIGITAL(__LINE__, FAN5_PIN)
#endif
#if PIN_EXISTS(FAN6)
  REPORT_NAME_DIGITAL(__LINE__, FAN6_PIN)
#endif
#if PIN_EXISTS(FAN7)
  REPORT_NAME_DIGITAL(__LINE__, FAN7_PIN)
#endif
#if PIN_EXISTS(FAN_MUX0)
  REPORT_NAME_DIGITAL(__LINE__, FAN_MUX0_PIN)
#endif
#if PIN_EXISTS(FAN_MUX1)
  REPORT_NAME_DIGITAL(__LINE__, FAN_MUX1_PIN)
#endif
#if PIN_EXISTS(FAN_MUX2)
  REPORT_NAME_DIGITAL(__LINE__, FAN_MUX2_PIN)
#endif
#if PIN_EXISTS(POWER_LOSS)
  REPORT_NAME_DIGITAL(__LINE__, POWER_LOSS_PIN)
#endif
#if PIN_EXISTS(SAFE_POWER)
  REPORT_NAME_DIGITAL(__LINE__, SAFE_POWER_PIN)
#endif
#if PIN_EXISTS(FIL_RUNOUT)
  REPORT_NAME_DIGITAL(__LINE__, FIL_RUNOUT_PIN)
#endif
#if PIN_EXISTS(FIL_RUNOUT2)
  REPORT_NAME_DIGITAL(__LINE__, FIL_RUNOUT2_PIN)
#endif
#if PIN_EXISTS(FIL_RUNOUT3)
  REPORT_NAME_DIGITAL(__LINE__, FIL_RUNOUT3_PIN)
#endif
#if PIN_EXISTS(FIL_RUNOUT4)
  REPORT_NAME_DIGITAL(__LINE__, FIL_RUNOUT4_PIN)
#endif
#if PIN_EXISTS(FIL_RUNOUT5)
  REPORT_NAME_DIGITAL(__LINE__, FIL_RUNOUT5_PIN)
#endif
#if PIN_EXISTS(FIL_RUNOUT6)
  REPORT_NAME_DIGITAL(__LINE__, FIL_RUNOUT6_PIN)
#endif
#if PIN_EXISTS(FIL_RUNOUT7)
  REPORT_NAME_DIGITAL(__LINE__, FIL_RUNOUT7_PIN)
#endif
#if PIN_EXISTS(FIL_RUNOUT8)
  REPORT_NAME_DIGITAL(__LINE__, FIL_RUNOUT8_PIN)
#endif
#if PIN_EXISTS(HEATER_0)
  REPORT_NAME_DIGITAL(__LINE__, HEATER_0_PIN)
#endif
#if PIN_EXISTS(HEATER_1)
  REPORT_NAME_DIGITAL(__LINE__, HEATER_1_PIN)
#endif
#if PIN_EXISTS(HEATER_2)
  REPORT_NAME_DIGITAL(__LINE__, HEATER_2_PIN)
#endif
#if PIN_EXISTS(HEATER_3)
  REPORT_NAME_DIGITAL(__LINE__, HEATER_3_PIN)
#endif
#if PIN_EXISTS(HEATER_4)
  REPORT_NAME_DIGITAL(__LINE__, HEATER_4_PIN)
#endif
#if PIN_EXISTS(HEATER_5)
  REPORT_NAME_DIGITAL(__LINE__, HEATER_5_PIN)
#endif
#if PIN_EXISTS(HEATER_6)
  REPORT_NAME_DIGITAL(__LINE__, HEATER_6_PIN)
#endif
#if PIN_EXISTS(HEATER_7)
  REPORT_NAME_DIGITAL(__LINE__, HEATER_7_PIN)
#endif
#if PIN_EXISTS(HEATER_BED)
  REPORT_NAME_DIGITAL(__LINE__, HEATER_BED_PIN)
#endif
#if PIN_EXISTS(HEATER_CHAMBER)
  REPORT_NAME_DIGITAL(__LINE__, HEATER_CHAMBER_PIN)
#endif
#if PIN_EXISTS(COOLER)
  REPORT_NAME_DIGITAL(__LINE__, COOLER_PIN)
#endif
#if PIN_EXISTS(HOME)
  REPORT_NAME_DIGITAL(__LINE__, HOME_PIN)
#endif
#if PIN_EXISTS(I2C_SCL)
  REPORT_NAME_DIGITAL(__LINE__, I2C_SCL_PIN)
#endif
#if PIN_EXISTS(I2C_SDA)
  REPORT_NAME_DIGITAL(__LINE__, I2C_SDA_PIN)
#endif
#if HAS_KILL
  REPORT_NAME_DIGITAL(__LINE__, KILL_PIN)
#endif
#if PIN_EXISTS(FREEZE)
  REPORT_NAME_DIGITAL(__LINE__, FREEZE_PIN)
#endif
#if PIN_EXISTS(LCD_BACKLIGHT)
  REPORT_NAME_DIGITAL(__LINE__, LCD_BACKLIGHT_PIN)
#endif
#if _EXISTS(LCD_PINS_D4)
  REPORT_NAME_DIGITAL(__LINE__, LCD_PINS_D4)
#endif
#if _EXISTS(LCD_PINS_D5)
  REPORT_NAME_DIGITAL(__LINE__, LCD_PINS_D5)
#endif
#if _EXISTS(LCD_PINS_D6)
  REPORT_NAME_DIGITAL(__LINE__, LCD_PINS_D6)
#endif
#if _EXISTS(LCD_PINS_D7)
  REPORT_NAME_DIGITAL(__LINE__, LCD_PINS_D7)
#endif
#if _EXISTS(LCD_PINS_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, LCD_PINS_ENABLE)
#endif
#if _EXISTS(LCD_PINS_RS)
  REPORT_NAME_DIGITAL(__LINE__, LCD_PINS_RS)
#endif
#if _EXISTS(LCD_SDSS)
  REPORT_NAME_DIGITAL(__LINE__, LCD_SDSS)
#endif
#if PIN_EXISTS(LED_GREEN)
  REPORT_NAME_DIGITAL(__LINE__, LED_GREEN_PIN)
#endif
#if PIN_EXISTS(LED)
  REPORT_NAME_DIGITAL(__LINE__, LED_PIN)
#endif
#if PIN_EXISTS(LED2)
  REPORT_NAME_DIGITAL(__LINE__, LED2_PIN)
#endif
#if PIN_EXISTS(LED3)
  REPORT_NAME_DIGITAL(__LINE__, LED3_PIN)
#endif
#if PIN_EXISTS(LED4)
  REPORT_NAME_DIGITAL(__LINE__, LED4_PIN)
#endif
#if PIN_EXISTS(LED_RED)
  REPORT_NAME_DIGITAL(__LINE__, LED_RED_PIN)
#endif
#if PIN_EXISTS(TEMP_0_CS)
  REPORT_NAME_DIGITAL(__LINE__, TEMP_0_CS_PIN)
#endif
#if PIN_EXISTS(TEMP_0_SCK)
  REPORT_NAME_DIGITAL(__LINE__, TEMP_0_SCK_PIN)
#endif
#if PIN_EXISTS(TEMP_0_MOSI)
  REPORT_NAME_DIGITAL(__LINE__, TEMP_0_MOSI_PIN)
#endif
#if PIN_EXISTS(TEMP_0_MISO)
  REPORT_NAME_DIGITAL(__LINE__, TEMP_0_MISO_PIN)
#endif
#if PIN_EXISTS(TEMP_1_CS)
  REPORT_NAME_DIGITAL(__LINE__, TEMP_1_CS_PIN)
#endif
#if PIN_EXISTS(TEMP_1_SCK)
  REPORT_NAME_DIGITAL(__LINE__, TEMP_1_SCK_PIN)
#endif
#if PIN_EXISTS(TEMP_1_MOSI)
  REPORT_NAME_DIGITAL(__LINE__, TEMP_1_MOSI_PIN)
#endif
#if PIN_EXISTS(TEMP_1_MISO)
  REPORT_NAME_DIGITAL(__LINE__, TEMP_1_MISO_PIN)
#endif
#if PIN_EXISTS(MAX7219_CLK)
  REPORT_NAME_DIGITAL(__LINE__, MAX7219_CLK_PIN)
#endif
#if PIN_EXISTS(MAX7219_DIN)
  REPORT_NAME_DIGITAL(__LINE__, MAX7219_DIN_PIN)
#endif
#if PIN_EXISTS(MAX7219_LOAD)
  REPORT_NAME_DIGITAL(__LINE__, MAX7219_LOAD_PIN)
#endif

//#if _EXISTS(MISO)
//  REPORT_NAME_DIGITAL(__LINE__, MISO)
//#endif
#if PIN_EXISTS(MISO)
  REPORT_NAME_DIGITAL(__LINE__, SD_MISO_PIN)
#endif
#if PIN_EXISTS(MOSFET_A)
  REPORT_NAME_DIGITAL(__LINE__, MOSFET_A_PIN)
#endif
#if PIN_EXISTS(MOSFET_B)
  REPORT_NAME_DIGITAL(__LINE__, MOSFET_B_PIN)
#endif
#if PIN_EXISTS(MOSFET_C)
  REPORT_NAME_DIGITAL(__LINE__, MOSFET_C_PIN)
#endif
#if PIN_EXISTS(MOSFET_D)
  REPORT_NAME_DIGITAL(__LINE__, MOSFET_D_PIN)
#endif
//#if _EXISTS(MOSI)
//  REPORT_NAME_DIGITAL(__LINE__, MOSI)
//#endif
#if PIN_EXISTS(MOSI)
  REPORT_NAME_DIGITAL(__LINE__, SD_MOSI_PIN)
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_E)
  REPORT_NAME_DIGITAL(__LINE__, MOTOR_CURRENT_PWM_E_PIN)
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_E0)
  REPORT_NAME_DIGITAL(__LINE__, MOTOR_CURRENT_PWM_E0_PIN)
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_E1)
  REPORT_NAME_DIGITAL(__LINE__, MOTOR_CURRENT_PWM_E1_PIN)
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_X)
  REPORT_NAME_DIGITAL(__LINE__, MOTOR_CURRENT_PWM_X_PIN)
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_Y)
  REPORT_NAME_DIGITAL(__LINE__, MOTOR_CURRENT_PWM_Y_PIN)
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_XY)
  REPORT_NAME_DIGITAL(__LINE__, MOTOR_CURRENT_PWM_XY_PIN)
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_X)
  REPORT_NAME_DIGITAL(__LINE__, MOTOR_CURRENT_PWM_X_PIN)
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_Y)
  REPORT_NAME_DIGITAL(__LINE__, MOTOR_CURRENT_PWM_Y_PIN)
#endif
#if PIN_EXISTS(MOTOR_CURRENT_PWM_Z)
  REPORT_NAME_DIGITAL(__LINE__, MOTOR_CURRENT_PWM_Z_PIN)
#endif
#if PIN_EXISTS(MOTOR_FAULT)
  REPORT_NAME_DIGITAL(__LINE__, MOTOR_FAULT_PIN)
#endif
#if PIN_EXISTS(PHOTOGRAPH)
  REPORT_NAME_DIGITAL(__LINE__, PHOTOGRAPH_PIN)
#endif
#if PIN_EXISTS(CHDK)
  REPORT_NAME_DIGITAL(__LINE__, CHDK_PIN)
#endif
#if PIN_EXISTS(PS_ON)
  REPORT_NAME_DIGITAL(__LINE__, PS_ON_PIN)
#endif
#if PIN_EXISTS(PWM_1)
  REPORT_NAME_DIGITAL(__LINE__, PWM_1_PIN)
#endif
#if PIN_EXISTS(PWM_2)
  REPORT_NAME_DIGITAL(__LINE__, PWM_2_PIN)
#endif
#if _EXISTS(REF_CLK)
  REPORT_NAME_DIGITAL(__LINE__, REF_CLK)
#endif
#if PIN_EXISTS(NEOPIXEL)
  REPORT_NAME_DIGITAL(__LINE__, NEOPIXEL_PIN)
#endif
#if PIN_EXISTS(NEOPIXEL2)
  REPORT_NAME_DIGITAL(__LINE__, NEOPIXEL2_PIN)
#endif
#if PIN_EXISTS(RGB_LED_R)
  REPORT_NAME_DIGITAL(__LINE__, RGB_LED_R_PIN)
#endif
#if PIN_EXISTS(RGB_LED_G)
  REPORT_NAME_DIGITAL(__LINE__, RGB_LED_G_PIN)
#endif
#if PIN_EXISTS(RGB_LED_B)
  REPORT_NAME_DIGITAL(__LINE__, RGB_LED_B_PIN)
#endif
#if PIN_EXISTS(RGB_LED_W)
  REPORT_NAME_DIGITAL(__LINE__, RGB_LED_W_PIN)
#endif
#if PIN_EXISTS(RX_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, RX_ENABLE_PIN)
#endif
#if PIN_EXISTS(SAFETY_TRIGGERED)
  REPORT_NAME_DIGITAL(__LINE__, SAFETY_TRIGGERED_PIN)
#endif
//#if _EXISTS(SCK)
//  REPORT_NAME_DIGITAL(__LINE__, SCK)
//#endif
#if PIN_EXISTS(SCK)
  REPORT_NAME_DIGITAL(__LINE__, SD_SCK_PIN)
#endif
//#if _EXISTS(SCL)
//  REPORT_NAME_DIGITAL(__LINE__, SCL)
//#endif
#if PIN_EXISTS(SD_DETECT)
  REPORT_NAME_DIGITAL(__LINE__, SD_DETECT_PIN)
#endif
//#if _EXISTS(SDA)
//  REPORT_NAME_DIGITAL(__LINE__, SDA)
//#endif
#if PIN_EXISTS(SDPOWER)
  REPORT_NAME_DIGITAL(__LINE__, SDPOWER_PIN)
#endif
#if _EXISTS(SDSS)
  REPORT_NAME_DIGITAL(__LINE__, SDSS)
#endif
#if _EXISTS(SERVO0)
  REPORT_NAME_DIGITAL(__LINE__, SERVO0)
#endif
#if PIN_EXISTS(SERVO0)
  REPORT_NAME_DIGITAL(__LINE__, SERVO0_PIN)
#endif
#if PIN_EXISTS(SERVO1)
  REPORT_NAME_DIGITAL(__LINE__, SERVO1_PIN)
#endif
#if PIN_EXISTS(SERVO2)
  REPORT_NAME_DIGITAL(__LINE__, SERVO2_PIN)
#endif
#if PIN_EXISTS(SERVO3)
  REPORT_NAME_DIGITAL(__LINE__, SERVO3_PIN)
#endif
#if PIN_EXISTS(SHIFT_CLK)
  REPORT_NAME_DIGITAL(__LINE__, SHIFT_CLK_PIN)
#endif
#if PIN_EXISTS(SHIFT_EN)
  REPORT_NAME_DIGITAL(__LINE__, SHIFT_EN_PIN)
#endif
#if PIN_EXISTS(SHIFT_LD)
  REPORT_NAME_DIGITAL(__LINE__, SHIFT_LD_PIN)
#endif
#if PIN_EXISTS(SHIFT_OUT)
  REPORT_NAME_DIGITAL(__LINE__, SHIFT_OUT_PIN)
#endif
#if PIN_EXISTS(SLED)
  REPORT_NAME_DIGITAL(__LINE__, SLED_PIN)
#endif
#if PIN_EXISTS(SLEEP_WAKE)
  REPORT_NAME_DIGITAL(__LINE__, SLEEP_WAKE_PIN)
#endif
#if PIN_EXISTS(SOL0)
  REPORT_NAME_DIGITAL(__LINE__, SOL0_PIN)
#endif
#if PIN_EXISTS(SOL1)
  REPORT_NAME_DIGITAL(__LINE__, SOL1_PIN)
#endif
#if PIN_EXISTS(SOL2)
  REPORT_NAME_DIGITAL(__LINE__, SOL2_PIN)
#endif
#if PIN_EXISTS(SOL3)
  REPORT_NAME_DIGITAL(__LINE__, SOL3_PIN)
#endif
#if PIN_EXISTS(SOL4)
  REPORT_NAME_DIGITAL(__LINE__, SOL4_PIN)
#endif
#if PIN_EXISTS(SOL5)
  REPORT_NAME_DIGITAL(__LINE__, SOL5_PIN)
#endif
#if PIN_EXISTS(SOL6)
  REPORT_NAME_DIGITAL(__LINE__, SOL6_PIN)
#endif
#if PIN_EXISTS(SOL7)
  REPORT_NAME_DIGITAL(__LINE__, SOL7_PIN)
#endif
#if _EXISTS(SPARE_IO)
  REPORT_NAME_DIGITAL(__LINE__, SPARE_IO)
#endif
#if PIN_EXISTS(SPI_EEPROM1_CS)
  REPORT_NAME_DIGITAL(__LINE__, SPI_EEPROM1_CS_PIN)
#endif
#if PIN_EXISTS(SPI_EEPROM2_CS)
  REPORT_NAME_DIGITAL(__LINE__, SPI_EEPROM2_CS_PIN)
#endif
#if PIN_EXISTS(SPI_FLASH_CS)
  REPORT_NAME_DIGITAL(__LINE__, SPI_FLASH_CS_PIN)
#endif
#if PIN_EXISTS(SPINDLE_DIR)
  REPORT_NAME_DIGITAL(__LINE__, SPINDLE_DIR_PIN)
#endif
#if PIN_EXISTS(SPINDLE_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, SPINDLE_ENABLE_PIN)
#endif
#if PIN_EXISTS(SPINDLE_LASER_ENA)
  REPORT_NAME_DIGITAL(__LINE__, SPINDLE_LASER_ENA_PIN)
#endif
#if PIN_EXISTS(SPINDLE_LASER_PWM)
  REPORT_NAME_DIGITAL(__LINE__, SPINDLE_LASER_PWM_PIN)
#endif
#if PIN_EXISTS(SR_CLK)
  REPORT_NAME_DIGITAL(__LINE__, SR_CLK_PIN)
#endif
#if PIN_EXISTS(SR_DATA)
  REPORT_NAME_DIGITAL(__LINE__, SR_DATA_PIN)
#endif
#if PIN_EXISTS(SR_STROBE)
  REPORT_NAME_DIGITAL(__LINE__, SR_STROBE_PIN)
#endif
#if PIN_EXISTS(SS)
  REPORT_NAME_DIGITAL(__LINE__, SD_SS_PIN)
#endif
#if PIN_EXISTS(STAT_LED_BLUE)
  REPORT_NAME_DIGITAL(__LINE__, STAT_LED_BLUE_PIN)
#endif
#if _EXISTS(STAT_LED_RED_LED)
  REPORT_NAME_DIGITAL(__LINE__, STAT_LED_RED_LED)
#endif
#if PIN_EXISTS(STAT_LED_RED)
  REPORT_NAME_DIGITAL(__LINE__, STAT_LED_RED_PIN)
#endif
#if PIN_EXISTS(STEPPER_RESET)
  REPORT_NAME_DIGITAL(__LINE__, STEPPER_RESET_PIN)
#endif
#if PIN_EXISTS(SUICIDE)
  REPORT_NAME_DIGITAL(__LINE__, SUICIDE_PIN)
#endif
#if PIN_EXISTS(TLC_BLANK)
  REPORT_NAME_DIGITAL(__LINE__, TLC_BLANK_PIN)
#endif
#if PIN_EXISTS(TLC_CLOCK)
  REPORT_NAME_DIGITAL(__LINE__, TLC_CLOCK_PIN)
#endif
#if PIN_EXISTS(TLC_DATA)
  REPORT_NAME_DIGITAL(__LINE__, TLC_DATA_PIN)
#endif
#if PIN_EXISTS(TLC_XLAT)
  REPORT_NAME_DIGITAL(__LINE__, TLC_XLAT_PIN)
#endif
#if PIN_EXISTS(TOOL_0)
  REPORT_NAME_DIGITAL(__LINE__, TOOL_0_PIN)
#endif
#if PIN_EXISTS(TOOL_0_PWM)
  REPORT_NAME_DIGITAL(__LINE__, TOOL_0_PWM_PIN)
#endif
#if PIN_EXISTS(TOOL_1)
  REPORT_NAME_DIGITAL(__LINE__, TOOL_1_PIN)
#endif
#if PIN_EXISTS(TOOL_1_PWM)
  REPORT_NAME_DIGITAL(__LINE__, TOOL_1_PWM_PIN)
#endif
#if PIN_EXISTS(TOOL_2)
  REPORT_NAME_DIGITAL(__LINE__, TOOL_2_PIN)
#endif
#if PIN_EXISTS(TOOL_2_PWM)
  REPORT_NAME_DIGITAL(__LINE__, TOOL_2_PWM_PIN)
#endif
#if PIN_EXISTS(TOOL_3)
  REPORT_NAME_DIGITAL(__LINE__, TOOL_3_PIN)
#endif
#if PIN_EXISTS(TOOL_3_PWM)
  REPORT_NAME_DIGITAL(__LINE__, TOOL_3_PWM_PIN)
#endif
#if PIN_EXISTS(TOOL_PWM)
  REPORT_NAME_DIGITAL(__LINE__, TOOL_PWM_PIN)
#endif
#if PIN_EXISTS(TX_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, TX_ENABLE_PIN)
#endif
#if _EXISTS(UI1)
  REPORT_NAME_DIGITAL(__LINE__, UI1)
#endif
#if _EXISTS(UI2)
  REPORT_NAME_DIGITAL(__LINE__, UI2)
#endif
#if _EXISTS(UNUSED_PWM)
  REPORT_NAME_DIGITAL(__LINE__, UNUSED_PWM)
#endif
#if PIN_EXISTS(X_ATT)
  REPORT_NAME_DIGITAL(__LINE__, X_ATT_PIN)
#endif
#if PIN_EXISTS(X_CS)
  REPORT_NAME_DIGITAL(__LINE__, X_CS_PIN)
#endif
#if PIN_EXISTS(X_DIR)
  REPORT_NAME_DIGITAL(__LINE__, X_DIR_PIN)
#endif
#if PIN_EXISTS(X_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, X_ENABLE_PIN)
#endif
#if PIN_EXISTS(X_MAX)
  REPORT_NAME_DIGITAL(__LINE__, X_MAX_PIN)
#endif
#if PIN_EXISTS(X_MIN)
  REPORT_NAME_DIGITAL(__LINE__, X_MIN_PIN)
#endif
#if PIN_EXISTS(X_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, X_DIAG_PIN)
#endif
#if PIN_EXISTS(X_MS1)
  REPORT_NAME_DIGITAL(__LINE__, X_MS1_PIN)
#endif
#if PIN_EXISTS(X_MS2)
  REPORT_NAME_DIGITAL(__LINE__, X_MS2_PIN)
#endif
#if PIN_EXISTS(X_MS3)
  REPORT_NAME_DIGITAL(__LINE__, X_MS3_PIN)
#endif
#if PIN_EXISTS(X_STEP)
  REPORT_NAME_DIGITAL(__LINE__, X_STEP_PIN)
#endif
#if PIN_EXISTS(X_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, X_STDBY_PIN)
#endif
#if PIN_EXISTS(X_STOP)
  REPORT_NAME_DIGITAL(__LINE__, X_STOP_PIN)
#endif
#if PIN_EXISTS(X2_CS)
  REPORT_NAME_DIGITAL(__LINE__, X2_CS_PIN)
#endif
#if PIN_EXISTS(X2_DIR)
  REPORT_NAME_DIGITAL(__LINE__, X2_DIR_PIN)
#endif
#if PIN_EXISTS(X2_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, X2_ENABLE_PIN)
#endif
#if PIN_EXISTS(X2_MAX)
  REPORT_NAME_DIGITAL(__LINE__, X2_MAX_PIN)
#endif
#if PIN_EXISTS(X2_MIN)
  REPORT_NAME_DIGITAL(__LINE__, X2_MIN_PIN)
#endif
#if PIN_EXISTS(X2_MS1)
  REPORT_NAME_DIGITAL(__LINE__, X2_MS1_PIN)
#endif
#if PIN_EXISTS(X2_MS2)
  REPORT_NAME_DIGITAL(__LINE__, X2_MS2_PIN)
#endif
#if PIN_EXISTS(X2_MS3)
  REPORT_NAME_DIGITAL(__LINE__, X2_MS3_PIN)
#endif
#if PIN_EXISTS(X2_STEP)
  REPORT_NAME_DIGITAL(__LINE__, X2_STEP_PIN)
#endif
#if PIN_EXISTS(Y_ATT)
  REPORT_NAME_DIGITAL(__LINE__, Y_ATT_PIN)
#endif
#if PIN_EXISTS(Y_CS)
  REPORT_NAME_DIGITAL(__LINE__, Y_CS_PIN)
#endif
#if PIN_EXISTS(Y_DIR)
  REPORT_NAME_DIGITAL(__LINE__, Y_DIR_PIN)
#endif
#if PIN_EXISTS(Y_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, Y_ENABLE_PIN)
#endif
#if PIN_EXISTS(Y_MAX)
  REPORT_NAME_DIGITAL(__LINE__, Y_MAX_PIN)
#endif
#if PIN_EXISTS(Y_MIN)
  REPORT_NAME_DIGITAL(__LINE__, Y_MIN_PIN)
#endif
#if PIN_EXISTS(Y_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, Y_DIAG_PIN)
#endif
#if PIN_EXISTS(Y_MS1)
  REPORT_NAME_DIGITAL(__LINE__, Y_MS1_PIN)
#endif
#if PIN_EXISTS(Y_MS2)
  REPORT_NAME_DIGITAL(__LINE__, Y_MS2_PIN)
#endif
#if PIN_EXISTS(Y_MS3)
  REPORT_NAME_DIGITAL(__LINE__, Y_MS3_PIN)
#endif
#if PIN_EXISTS(Y_STEP)
  REPORT_NAME_DIGITAL(__LINE__, Y_STEP_PIN)
#endif
#if PIN_EXISTS(Y_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, Y_STDBY_PIN)
#endif
#if PIN_EXISTS(Y_STOP)
  REPORT_NAME_DIGITAL(__LINE__, Y_STOP_PIN)
#endif
#if PIN_EXISTS(Y2_CS)
  REPORT_NAME_DIGITAL(__LINE__, Y2_CS_PIN)
#endif
#if PIN_EXISTS(Y2_DIR)
  REPORT_NAME_DIGITAL(__LINE__, Y2_DIR_PIN)
#endif
#if PIN_EXISTS(Y2_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, Y2_ENABLE_PIN)
#endif
#if PIN_EXISTS(Y2_MAX)
  REPORT_NAME_DIGITAL(__LINE__, Y2_MAX_PIN)
#endif
#if PIN_EXISTS(Y2_MIN)
  REPORT_NAME_DIGITAL(__LINE__, Y2_MIN_PIN)
#endif
#if PIN_EXISTS(Y2_MS1)
  REPORT_NAME_DIGITAL(__LINE__, Y2_MS1_PIN)
#endif
#if PIN_EXISTS(Y2_MS2)
  REPORT_NAME_DIGITAL(__LINE__, Y2_MS2_PIN)
#endif
#if PIN_EXISTS(Y2_MS3)
  REPORT_NAME_DIGITAL(__LINE__, Y2_MS3_PIN)
#endif
#if PIN_EXISTS(Y2_STEP)
  REPORT_NAME_DIGITAL(__LINE__, Y2_STEP_PIN)
#endif
#if PIN_EXISTS(Z_ATT)
  REPORT_NAME_DIGITAL(__LINE__, Z_ATT_PIN)
#endif
#if PIN_EXISTS(Z_CS)
  REPORT_NAME_DIGITAL(__LINE__, Z_CS_PIN)
#endif
#if PIN_EXISTS(Z_DIR)
  REPORT_NAME_DIGITAL(__LINE__, Z_DIR_PIN)
#endif
#if PIN_EXISTS(Z_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, Z_ENABLE_PIN)
#endif
#if PIN_EXISTS(Z_MAX)
  REPORT_NAME_DIGITAL(__LINE__, Z_MAX_PIN)
#endif
#if PIN_EXISTS(Z_MIN)
  REPORT_NAME_DIGITAL(__LINE__, Z_MIN_PIN)
#endif
#if PIN_EXISTS(Z_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, Z_DIAG_PIN)
#endif
#if PIN_EXISTS(Z_MS1)
  REPORT_NAME_DIGITAL(__LINE__, Z_MS1_PIN)
#endif
#if PIN_EXISTS(Z_MS2)
  REPORT_NAME_DIGITAL(__LINE__, Z_MS2_PIN)
#endif
#if PIN_EXISTS(Z_MS3)
  REPORT_NAME_DIGITAL(__LINE__, Z_MS3_PIN)
#endif
#if PIN_EXISTS(Z_STEP)
  REPORT_NAME_DIGITAL(__LINE__, Z_STEP_PIN)
#endif
#if PIN_EXISTS(Z_STDBY)
  REPORT_NAME_DIGITAL(__LINE__, Z_STDBY_PIN)
#endif
#if PIN_EXISTS(Z_STOP)
  REPORT_NAME_DIGITAL(__LINE__, Z_STOP_PIN)
#endif
#if PIN_EXISTS(Z2_CS)
  REPORT_NAME_DIGITAL(__LINE__, Z2_CS_PIN)
#endif
#if PIN_EXISTS(Z2_DIR)
  REPORT_NAME_DIGITAL(__LINE__, Z2_DIR_PIN)
#endif
#if PIN_EXISTS(Z2_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, Z2_ENABLE_PIN)
#endif
#if PIN_EXISTS(Z2_MAX)
  REPORT_NAME_DIGITAL(__LINE__, Z2_MAX_PIN)
#endif
#if PIN_EXISTS(Z2_MIN)
  REPORT_NAME_DIGITAL(__LINE__, Z2_MIN_PIN)
#endif
#if PIN_EXISTS(Z2_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, Z2_DIAG_PIN)
#endif
#if PIN_EXISTS(Z2_MS1)
  REPORT_NAME_DIGITAL(__LINE__, Z2_MS1_PIN)
#endif
#if PIN_EXISTS(Z2_MS2)
  REPORT_NAME_DIGITAL(__LINE__, Z2_MS2_PIN)
#endif
#if PIN_EXISTS(Z2_MS3)
  REPORT_NAME_DIGITAL(__LINE__, Z2_MS3_PIN)
#endif
#if PIN_EXISTS(Z2_STEP)
  REPORT_NAME_DIGITAL(__LINE__, Z2_STEP_PIN)
#endif
#if PIN_EXISTS(Z2_STOP)
  REPORT_NAME_DIGITAL(__LINE__, Z2_STOP_PIN)
#endif
#if PIN_EXISTS(Z3_CS)
  REPORT_NAME_DIGITAL(__LINE__, Z3_CS_PIN)
#endif
#if PIN_EXISTS(Z3_DIR)
  REPORT_NAME_DIGITAL(__LINE__, Z3_DIR_PIN)
#endif
#if PIN_EXISTS(Z3_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, Z3_ENABLE_PIN)
#endif
#if PIN_EXISTS(Z3_MAX)
  REPORT_NAME_DIGITAL(__LINE__, Z3_MAX_PIN)
#endif
#if PIN_EXISTS(Z3_MIN)
  REPORT_NAME_DIGITAL(__LINE__, Z3_MIN_PIN)
#endif
#if PIN_EXISTS(Z3_MS1)
  REPORT_NAME_DIGITAL(__LINE__, Z3_MS1_PIN)
#endif
#if PIN_EXISTS(Z3_MS2)
  REPORT_NAME_DIGITAL(__LINE__, Z3_MS2_PIN)
#endif
#if PIN_EXISTS(Z3_MS3)
  REPORT_NAME_DIGITAL(__LINE__, Z3_MS3_PIN)
#endif
#if PIN_EXISTS(Z3_STEP)
  REPORT_NAME_DIGITAL(__LINE__, Z3_STEP_PIN)
#endif
#if PIN_EXISTS(Z4_CS)
  REPORT_NAME_DIGITAL(__LINE__, Z4_CS_PIN)
#endif
#if PIN_EXISTS(Z4_DIR)
  REPORT_NAME_DIGITAL(__LINE__, Z4_DIR_PIN)
#endif
#if PIN_EXISTS(Z4_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, Z4_ENABLE_PIN)
#endif
#if PIN_EXISTS(Z4_MAX)
  REPORT_NAME_DIGITAL(__LINE__, Z4_MAX_PIN)
#endif
#if PIN_EXISTS(Z4_MIN)
  REPORT_NAME_DIGITAL(__LINE__, Z4_MIN_PIN)
#endif
#if PIN_EXISTS(Z4_MS1)
  REPORT_NAME_DIGITAL(__LINE__, Z4_MS1_PIN)
#endif
#if PIN_EXISTS(Z4_MS2)
  REPORT_NAME_DIGITAL(__LINE__, Z4_MS2_PIN)
#endif
#if PIN_EXISTS(Z4_MS3)
  REPORT_NAME_DIGITAL(__LINE__, Z4_MS3_PIN)
#endif
#if PIN_EXISTS(Z4_STEP)
  REPORT_NAME_DIGITAL(__LINE__, Z4_STEP_PIN)
#endif
#if PIN_EXISTS(Z_MIN_PROBE)
  REPORT_NAME_DIGITAL(__LINE__, Z_MIN_PROBE_PIN)
#endif
#if PIN_EXISTS(PROBE_ACTIVATION_SWITCH)
  REPORT_NAME_DIGITAL(__LINE__, PROBE_ACTIVATION_SWITCH_PIN)
#endif
#if PIN_EXISTS(PROBE_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, PROBE_ENABLE_PIN)
#endif
#if PIN_EXISTS(PROBE_TARE)
  REPORT_NAME_DIGITAL(__LINE__, PROBE_TARE_PIN)
#endif
#if PIN_EXISTS(I_ATT)
  REPORT_NAME_DIGITAL(__LINE__, I_ATT_PIN)
#endif
#if PIN_EXISTS(I_CS)
  REPORT_NAME_DIGITAL(__LINE__, I_CS_PIN)
#endif
#if PIN_EXISTS(I_DIR)
  REPORT_NAME_DIGITAL(__LINE__, I_DIR_PIN)
#endif
#if PIN_EXISTS(I_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, I_ENABLE_PIN)
#endif
#if PIN_EXISTS(I_MAX)
  REPORT_NAME_DIGITAL(__LINE__, I_MAX_PIN)
#endif
#if PIN_EXISTS(I_MIN)
  REPORT_NAME_DIGITAL(__LINE__, I_MIN_PIN)
#endif
#if PIN_EXISTS(I_MS1)
  REPORT_NAME_DIGITAL(__LINE__, I_MS1_PIN)
#endif
#if PIN_EXISTS(I_MS2)
  REPORT_NAME_DIGITAL(__LINE__, I_MS2_PIN)
#endif
#if PIN_EXISTS(I_MS3)
  REPORT_NAME_DIGITAL(__LINE__, I_MS3_PIN)
#endif
#if PIN_EXISTS(I_STEP)
  REPORT_NAME_DIGITAL(__LINE__, I_STEP_PIN)
#endif
#if PIN_EXISTS(I_STOP)
  REPORT_NAME_DIGITAL(__LINE__, I_STOP_PIN)
#endif
#if PIN_EXISTS(J_ATT)
  REPORT_NAME_DIGITAL(__LINE__, J_ATT_PIN)
#endif
#if PIN_EXISTS(J_CS)
  REPORT_NAME_DIGITAL(__LINE__, J_CS_PIN)
#endif
#if PIN_EXISTS(J_DIR)
  REPORT_NAME_DIGITAL(__LINE__, J_DIR_PIN)
#endif
#if PIN_EXISTS(J_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, J_ENABLE_PIN)
#endif
#if PIN_EXISTS(J_MAX)
  REPORT_NAME_DIGITAL(__LINE__, J_MAX_PIN)
#endif
#if PIN_EXISTS(J_MIN)
  REPORT_NAME_DIGITAL(__LINE__, J_MIN_PIN)
#endif
#if PIN_EXISTS(J_MS1)
  REPORT_NAME_DIGITAL(__LINE__, J_MS1_PIN)
#endif
#if PIN_EXISTS(J_MS2)
  REPORT_NAME_DIGITAL(__LINE__, J_MS2_PIN)
#endif
#if PIN_EXISTS(J_MS3)
  REPORT_NAME_DIGITAL(__LINE__, J_MS3_PIN)
#endif
#if PIN_EXISTS(J_STEP)
  REPORT_NAME_DIGITAL(__LINE__, J_STEP_PIN)
#endif
#if PIN_EXISTS(J_STOP)
  REPORT_NAME_DIGITAL(__LINE__, J_STOP_PIN)
#endif
#if PIN_EXISTS(K_ATT)
  REPORT_NAME_DIGITAL(__LINE__, K_ATT_PIN)
#endif
#if PIN_EXISTS(K_CS)
  REPORT_NAME_DIGITAL(__LINE__, K_CS_PIN)
#endif
#if PIN_EXISTS(K_DIR)
  REPORT_NAME_DIGITAL(__LINE__, K_DIR_PIN)
#endif
#if PIN_EXISTS(K_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, K_ENABLE_PIN)
#endif
#if PIN_EXISTS(K_MAX)
  REPORT_NAME_DIGITAL(__LINE__, K_MAX_PIN)
#endif
#if PIN_EXISTS(K_MIN)
  REPORT_NAME_DIGITAL(__LINE__, K_MIN_PIN)
#endif
#if PIN_EXISTS(K_MS1)
  REPORT_NAME_DIGITAL(__LINE__, K_MS1_PIN)
#endif
#if PIN_EXISTS(K_MS2)
  REPORT_NAME_DIGITAL(__LINE__, K_MS2_PIN)
#endif
#if PIN_EXISTS(K_MS3)
  REPORT_NAME_DIGITAL(__LINE__, K_MS3_PIN)
#endif
#if PIN_EXISTS(K_STEP)
  REPORT_NAME_DIGITAL(__LINE__, K_STEP_PIN)
#endif
#if PIN_EXISTS(K_STOP)
  REPORT_NAME_DIGITAL(__LINE__, K_STOP_PIN)
#endif
#if PIN_EXISTS(ZRIB_V20_D6)
  REPORT_NAME_DIGITAL(__LINE__, ZRIB_V20_D6_PIN)
#endif
#if PIN_EXISTS(ZRIB_V20_D9)
  REPORT_NAME_DIGITAL(__LINE__, ZRIB_V20_D9_PIN)
#endif
#if PIN_EXISTS(X_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, X_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(X_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, X_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(X2_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, X2_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(X2_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, X2_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(Y_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, Y_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(Y_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, Y_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(Y2_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, Y2_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(Y2_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, Y2_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(Z_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, Z_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(Z_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, Z_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(Z2_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, Z2_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(Z2_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, Z2_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(Z3_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, Z3_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(Z3_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, Z3_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(Z4_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, Z4_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(Z4_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, Z4_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(I_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, I_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(I_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, I_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(J_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, J_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(J_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, J_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(K_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, K_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(K_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, K_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(E0_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, E0_DIAG_PIN)
#endif
#if PIN_EXISTS(E0_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, E0_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(E0_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, E0_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(E1_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, E1_DIAG_PIN)
#endif
#if PIN_EXISTS(E1_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, E1_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(E1_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, E1_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(E2_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, E2_DIAG_PIN)
#endif
#if PIN_EXISTS(E2_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, E2_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(E2_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, E2_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(E3_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, E3_DIAG_PIN)
#endif
#if PIN_EXISTS(E3_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, E3_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(E3_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, E3_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(E4_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, E4_DIAG_PIN)
#endif
#if PIN_EXISTS(E4_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, E4_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(E4_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, E4_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(E5_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, E5_DIAG_PIN)
#endif
#if PIN_EXISTS(E5_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, E5_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(E5_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, E5_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(E6_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, E6_DIAG_PIN)
#endif
#if PIN_EXISTS(E6_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, E6_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(E6_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, E6_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(E7_DIAG)
  REPORT_NAME_DIGITAL(__LINE__, E7_DIAG_PIN)
#endif
#if PIN_EXISTS(E7_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, E7_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(E7_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, E7_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(I_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, I_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(I_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, I_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(J_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, J_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(J_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, J_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(K_SERIAL_TX)
  REPORT_NAME_DIGITAL(__LINE__, K_SERIAL_TX_PIN)
#endif
#if PIN_EXISTS(K_SERIAL_RX)
  REPORT_NAME_DIGITAL(__LINE__, K_SERIAL_RX_PIN)
#endif
#if PIN_EXISTS(L6470_CHAIN_SCK)
  REPORT_NAME_DIGITAL(__LINE__, L6470_CHAIN_SCK_PIN)
#endif
#if PIN_EXISTS(L6470_CHAIN_MISO)
  REPORT_NAME_DIGITAL(__LINE__, L6470_CHAIN_MISO_PIN)
#endif
#if PIN_EXISTS(L6470_CHAIN_MOSI)
  REPORT_NAME_DIGITAL(__LINE__, L6470_CHAIN_MOSI_PIN)
#endif
#if PIN_EXISTS(L6470_CHAIN_SS)
  REPORT_NAME_DIGITAL(__LINE__, L6470_CHAIN_SS_PIN)
#endif
#if PIN_EXISTS(L6470_RESET_CHAIN)
  REPORT_NAME_DIGITAL(__LINE__, L6470_RESET_CHAIN_PIN)
#endif
#if PIN_EXISTS(FET_SAFETY)
  REPORT_NAME_DIGITAL(__LINE__, FET_SAFETY_PIN)
#endif
#if PIN_EXISTS(TOUCH_MISO)
  REPORT_NAME_DIGITAL(__LINE__, TOUCH_MISO_PIN)
#endif
#if PIN_EXISTS(TOUCH_MOSI)
  REPORT_NAME_DIGITAL(__LINE__, TOUCH_MOSI_PIN)
#endif
#if PIN_EXISTS(TOUCH_SCK)
  REPORT_NAME_DIGITAL(__LINE__, TOUCH_SCK_PIN)
#endif
#if PIN_EXISTS(TOUCH_CS)
  REPORT_NAME_DIGITAL(__LINE__, TOUCH_CS_PIN)
#endif
#if PIN_EXISTS(TOUCH_INT)
  REPORT_NAME_DIGITAL(__LINE__, TOUCH_INT_PIN)
#endif
#if PIN_EXISTS(USB_CS)
  REPORT_NAME_DIGITAL(__LINE__, USB_CS_PIN)
#endif
#if PIN_EXISTS(USB_INTR)
  REPORT_NAME_DIGITAL(__LINE__, USB_INTR_PIN)
#endif
#if PIN_EXISTS(MMU2_RST)
  REPORT_NAME_DIGITAL(__LINE__, MMU2_RST_PIN)
#endif
#if PIN_EXISTS(CALIBRATION)
  REPORT_NAME_DIGITAL(__LINE__, CALIBRATION_PIN)
#endif
#if PIN_EXISTS(SMART_EFFECTOR_MOD)
  REPORT_NAME_DIGITAL(__LINE__, SMART_EFFECTOR_MOD_PIN)
#endif
#if PIN_EXISTS(CLOSED_LOOP_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, CLOSED_LOOP_ENABLE_PIN)
#endif
#if PIN_EXISTS(CLOSED_LOOP_MOVE_COMPLETE)
  REPORT_NAME_DIGITAL(__LINE__, CLOSED_LOOP_MOVE_COMPLETE_PIN)
#endif
#if PIN_EXISTS(ESP_WIFI_MODULE_RESET)
  REPORT_NAME_DIGITAL(__LINE__, ESP_WIFI_MODULE_RESET_PIN)
#endif
#if PIN_EXISTS(ESP_WIFI_MODULE_ENABLE)
  REPORT_NAME_DIGITAL(__LINE__, ESP_WIFI_MODULE_ENABLE_PIN)
#endif
#if PIN_EXISTS(ESP_WIFI_MODULE_GPIO0)
  REPORT_NAME_DIGITAL(__LINE__, ESP_WIFI_MODULE_GPIO0_PIN)
#endif
#if PIN_EXISTS(ESP_WIFI_MODULE_GPIO2)
  REPORT_NAME_DIGITAL(__LINE__, ESP_WIFI_MODULE_GPIO2_PIN)
#endif
// TFT PINS
#if PIN_EXISTS(TFT_CS)
  REPORT_NAME_DIGITAL(__LINE__, TFT_CS_PIN)
#endif
#if PIN_EXISTS(TFT_A0)
  REPORT_NAME_DIGITAL(__LINE__, TFT_A0_PIN)
#endif
#if PIN_EXISTS(TFT_DC)
  REPORT_NAME_DIGITAL(__LINE__, TFT_DC_PIN)
#endif
#if PIN_EXISTS(TFT_MISO)
  REPORT_NAME_DIGITAL(__LINE__, TFT_MISO_PIN)
#endif
#if PIN_EXISTS(TFT_BACKLIGHT)
  REPORT_NAME_DIGITAL(__LINE__, TFT_BACKLIGHT_PIN)
#endif
#if PIN_EXISTS(TFT_RESET)
  REPORT_NAME_DIGITAL(__LINE__, TFT_RESET_PIN)
#endif
