#!/bin/bash
sudo cp RepetierHostMimeTypes.xml /usr/share/mime/packages/
sudo update-mime-database /usr/share/mime
user=$(whoami)
dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
mono="$(which mono)"
echo "Dir: $dir"
echo "[Desktop Entry]
Name=Repetier-Host
Exec=$mono $dir/RepetierHost.exe -home $dir
Type=Application
Terminal=false
Categories=Graphics;
StartupNotify=true
Comment=Repetier-Host 3d printer host software
Path=$dir
Icon=$dir/repetier-logo.png
MimeType=application/sla;text/gcode;application/wavefront-obj;application/x-amf;
Comment[en_US.UTF-8]=Repetier Host
" > $dir/repetier-RepetierHost.desktop
echo "<!DOCTYPE Menu PUBLIC \"-//freedesktop//DTD Menu 1.0//EN\"
          \"http://www.freedesktop.org/standards/menu-spec/menu-1.0.dtd\">
          <Menu>
            <Name>Applications</Name>
                <Filename>shinythings-webmirror.desktop</Filename>
                <Filename>shinythings-webmirror-admin.desktop</Filename>
            </Menu>
" > $dir/Repetier-Host.menu
chmod a+x $dir/repetier-RepetierHost.desktop
sudo cp $dir/repetier-RepetierHost.desktop /usr/share/applications
sudo desktop-file-install --rebuild-mime-info-cache repetier-RepetierHost.desktop
echo "This folder now contains a repetier-RepetierHost.desktop file"
echo "Copy it to your desktop to get a launch icon there"
